<div class="grp-admin-settings-header">
    
    <h3><?php esc_html_e( 'Global Settings', 'gou-manage-related-posts-similar-posts' ); ?></h3>
    <div id="grp-admin-settings-description"><p><?php esc_html_e( 'If you want to temporarily disable related posts functionality for globally on website.', 'gou-manage-related-posts-similar-posts' ); ?></p>
    </div>
    
    <div style="clear:both;"></div>
    
</div>

<?php

	$settings = GRP_Post_Filters::grp_get_configuration_settings();
	
	$global_settings = isset( $settings['global'] ) ? $settings['global'] : '';
	
?>


<section id="grp-settings-form" class="grp-global-settings-section">

	<form method="post" action="">
    
    	<table class="form-table">
            <tbody>
            
            <tr valign="top" class="">
                <th scope="row" class="titledesc">
                    <label for="woocommerce_gwat_config[enable]">
                        <?php esc_html_e( 'Temporary Disable', 'gou-manage-related-posts-similar-posts' ); ?>
                    </label>
                </th>
                <td class="forminp">
                
					<?php
                    	$is_disabled = isset( $global_settings['is_disabled'] ) ? $global_settings['is_disabled'] : '';
                    ?>
                   
                    <input type="checkbox" name="grp_global_fields[is_disabled]" value="yes" <?php if( esc_attr( $is_disabled ) == 'yes' ){ echo 'checked="checked"'; } ?> >
                    <?php esc_html_e('Checked this option, if you want to temporary disable all related posts functionality.', 'gou-manage-related-posts-similar-posts' );?>
                    
                </td>
            </tr>
            
            <tr valign="top" class="">
                <td colspan="2">
                    <input type="button" class="button-primary" name="grp_update_global_settings" value="<?php esc_html_e( 'Save Changes', 'gou-manage-related-posts-similar-posts' ); ?>">
                </td>
            </tr>
            
            </tbody>
        </table>
        
        <?php wp_nonce_field('grp-admin-general-settings', '_wpnonce_grp_admin_general_settings');?>

    
    </form>

</section>