<div class="grp-admin-settings-header">
    
    <h3><?php esc_html_e( 'Configuration Settings', 'gou-manage-related-posts-similar-posts' ); ?></h3>
    <div id="grp-admin-settings-description"><p><?php esc_html_e( 'Activate the related posts functionality and other conditions. For particular post type.', 'gou-manage-related-posts-similar-posts' ); ?></p>
    </div>
    
    <div style="clear:both;"></div>
    
</div>

<section id="grp-settings-form" class="configuration-section">

	<ul class="grp-configuration-posts">
    	
        <?php
		
		$settings = GRP_Post_Filters::grp_get_configuration_settings();
		
		$config_settings = isset( $settings['config'] ) ? $settings['config'] : '';
		
		
		$post_types = grp_get_post_types( 'label' );
		
		foreach( $post_types as $key => $val ){ 
		
			$section_settings = ( isset( $config_settings[$key] ) && is_array( $config_settings[$key] ) ) ? $config_settings[$key] : '';
		
			?>
    		
            <li id="grp-configuration-section-<?php echo esc_attr( $key );?>" class="grp-configuration-posts-li">
                
                <div class="grp-configuration-posts-inner">
                    
                    <span title="<?php esc_html_e( 'Click to show/hide item settings', 'gou-manage-related-posts-similar-posts' ); ?>" data-id="1" class="grp-show-hide grp-show-hide-icon grp-icon-triangle-1-n"></span>
                    
                    <span data-id="1" class="grp-show-hide grp-itemTitle"><font class="title"><?php echo esc_attr( $val );?></font>&nbsp;::&nbsp;<font class="grp-enable-disable"><em><?php echo ( ( isset( $section_settings['is_enable'] ) && $section_settings['is_enable'] == 'yes' ) ? esc_html__('Enabled', 'gou-manage-related-posts-similar-posts' ) : esc_html__('Disabled', 'gou-manage-related-posts-similar-posts' ) ); ?></em></font>
                    </span>
                    
                    <div class="grp-configuration-posts-inner-forms hidden">
                    
                    <form method="post" action="">
                    
                        <table class="form-table">
                            <tbody>
                            
                            <tr valign="top" class="">
                                <th scope="row" class="titledesc">
                                    <label for="woocommerce_gwat_config[enable]">
                                        <?php esc_html_e( 'Enable/Disable', 'gou-manage-related-posts-similar-posts' ); ?>
                                    </label>
                                </th>
                                <td class="forminp">
                                
                                	 <?php
                                    $is_enable = isset( $section_settings['is_enable'] ) ? $section_settings['is_enable'] : '';
                                    ?>
                                   
                                    <input type="checkbox" name="grp_configuration_fields[<?php echo esc_attr( $key );?>][is_enable]" value="yes" <?php if( esc_attr( $is_enable ) == 'yes' ){ echo 'checked="checked"'; } ?> >
                                    <?php esc_html_e('Enable this option to show related posts for this post type.', 'gou-manage-related-posts-similar-posts' );?>
                                    
                                </td>
                            </tr>
                            
                            
                            <tr valign="top">
                                <td colspan="2" class="grp-full-width-td"><div class="grp-full-width-heading"><?php esc_html_e( 'Match Case ::', 'gou-manage-related-posts-similar-posts' ); ?> <em><?php esc_html_e( 'Set the conditions for related posts.', 'gou-manage-related-posts-similar-posts' ); ?></em></div></td>
                            </tr>
                                                
                            <?php
                            
                            $output = 'label'; // or objects
                            $operator = 'and'; // 'and' or 'or'
                            
                            $taxonomies = grp_get_taxonomies( esc_attr( $key ), $output, $operator );
                            
                            //echo "<pre>"; print_r($taxonomies); echo "</pre>";
                            
                            if( !empty( $taxonomies ) ){
                            
                                foreach( $taxonomies as $tkey => $tval ){
                                    
                                    $terms = get_terms( array(
                                        'taxonomy' => $tkey,
                                        'hide_empty' => false,
                                        'orderby' => 'name',
                                        'order' => 'ASC' 
                                    ) );
                                    
                                    ?>
                                    
                                   <tr valign="top" class=""> 
                                   
                                       <th scope="row" class="titledesc">
                                            <label for="woocommerce_gwat_layout[type]">
                                                <?php

                                                printf(
                                                    /* translators: %s: taxonomy label */
                                                    esc_html__( '%s :', 'gou-manage-related-posts-similar-posts' ),
                                                    esc_html( $tval )
                                                );


                                                ?>
                                            </label>
                                        </th>
                                        
                                        <td class="forminp">
                                            
                                            <select name="grp_configuration_fields[<?php echo esc_attr( $key );?>][match_case][<?php echo esc_attr( $tkey );?>]" class="grp-configuration-select">
                                                
                                                <?php
                                            	
                                                $options_arr = Grp_Admin_Settings::grp_configuration_match_select_opts( $tkey );
                                                
                                                if( !empty( $options_arr ) ){
													
													$match_case = isset( $section_settings['match_case'][$tkey] ) ? $section_settings['match_case'][$tkey] : 'within_match';
                                                    
													$options = '';
													
                                                    foreach( $options_arr as $okey => $oval ){
                                                        
														$selected = '';
														if( $match_case == $okey )
															$selected = 'selected="selected"';
                                                        
                                                        $options .= '<option '.$selected.' value="'.esc_attr( $okey ).'">'.esc_attr( $oval ).'</option>';
                                                    
                                                    }
													
													echo wp_kses(
                                                        $options,
                                                        array(
                                                            'option' => array(
                                                                'value'    => true,
                                                                'selected' => true,
                                                            ),
                                                        )
                                                    );
                                                
                                                }
                                                
                                                ?>
                                                
                                            </select>
                                            
                                        </td>
                                    
                                    </tr> 
                                    
                                    <tr valign="top" class="">
                                        <th scope="row" class="titledesc">
                                            <label for="woocommerce_gwat_layout[type]">
                                                <?php
                                                printf(
                                                    /* translators: %s: taxonomy label */
                                                    esc_html__( 'Exclude by %s :', 'gou-manage-related-posts-similar-posts' ),
                                                    esc_html( $tval )
                                                );
                                                ?>

                                            </label>
                                        </th>
                                        
                                        <td class="forminp">
                                            
                                            <?php
                                            
                                            if( !empty( $terms ) ){
                                                
												$match_case = isset( $section_settings['exclude'][$tkey] ) ? $section_settings['exclude'][$tkey] : '';
												
                                                $options = '<ul class="grp-checkbox-cats">';
                                                
                                                foreach( $terms as $termkey => $termval ){
                                                	
													$checked = '';
													if( is_array( $match_case ) && !empty( $match_case ) && in_array( $termval->term_id, $match_case ) )
														$checked = 'checked="checked"';
													
                                                     $options .= '<li><label><input name="grp_configuration_fields['.esc_attr( $key ).'][exclude]['.esc_attr( $tkey ).'][]" '.$checked.' value="'.esc_attr( $termval->term_id ).'" type="checkbox" class="grp-field-checkbox" style=""> '.esc_attr( $termval->name ).'</label></li>';
                                                
                                                }
                                                
                                                $options .= '</ul>';
												
                                                echo wp_kses(
                                                        $options,
                                                        array(
                                                            'option' => array(
                                                                'value'    => true,
                                                                'selected' => true,
                                                            ),
                                                        )
                                                    );
                                            
                                            }
                                            
                                            ?>
                                            
                                        </td>
                                    </tr>
                                    
                                    <?php
                                
                                }
                            
                            }
                            
                            ?>
                            
                            <tr valign="top">
                                <td colspan="2" class="grp-full-width-td"><div class="grp-full-width-heading"><?php esc_html_e( 'Set Layout ::', 'gou-manage-related-posts-similar-posts' ); ?> <em><?php esc_html_e( 'Set the layout for related posts.', 'gou-manage-related-posts-similar-posts' ); ?></em></div></td>
                            </tr>
                            
                            <tr valign="top" class="">
                                <th scope="row" class="titledesc">
                                    <label for="woocommerce_gwat_layout[type]">
                                        <?php esc_html_e( 'Heading:', 'gou-manage-related-posts-similar-posts' ); ?>
                                    </label>
                                </th>
                                
                                <td class="forminp">
                                    
                                    <?php
                                    $heading = isset( $section_settings['layout']['heading'] ) ? $section_settings['layout']['heading'] : esc_html( 'Related Posts', 'gou-manage-related-posts-similar-posts' );
                                    ?>
                                    <input type="text" name="grp_configuration_fields[<?php echo esc_attr( $key );?>][layout][heading]" class="regular-text" value="<?php echo esc_attr( $heading );?>" />
                                    <p class="description" id="tagline-description"><?php esc_html_e( 'Section title, leave blank if you don\'t want to show title.', 'gou-manage-related-posts-similar-posts' ); ?></p>
                                    
                                </td>
                            </tr>
                            
                            <tr valign="top" class="">
                                <th scope="row" class="titledesc">
                                    <label for="woocommerce_gwat_layout[type]">
                                        <?php esc_html_e( 'No Results:', 'gou-manage-related-posts-similar-posts' ); ?>
                                    </label>
                                </th>
                                
                                <td class="forminp">
                                    
                                    <?php
                                    $no_result = isset( $section_settings['layout']['no_result'] ) ? $section_settings['layout']['no_result'] : esc_html( 'No posts found.', 'gou-manage-related-posts-similar-posts' );
                                    ?>
                                    
                                    <input type="text" name="grp_configuration_fields[<?php echo esc_attr( $key );?>][layout][no_result]" class="regular-text" value="<?php echo esc_attr( $no_result );?>" />
                                    <p class="description" id="tagline-description"><?php esc_html_e( 'Message will show if no result found.', 'gou-manage-related-posts-similar-posts' ); ?></p>
                                    
                                </td>
                            </tr>
                            
                            <tr valign="top" class="">
                                <th scope="row" class="titledesc">
                                    <label for="woocommerce_gwat_layout[type]">
                                        <?php esc_html_e( 'Number of Posts:', 'gou-manage-related-posts-similar-posts' ); ?>
                                    </label>
                                </th>
                                
                                <td class="forminp">
                                    
                                    <?php
                                    $max_posts = isset( $section_settings['layout']['max_posts'] ) ? $section_settings['layout']['max_posts'] : 10;
                                    ?>
                                    
                                    <input type="number" name="grp_configuration_fields[<?php echo esc_attr( $key );?>][layout][max_posts]" class="regular-text" value="<?php echo esc_attr( $max_posts );?>" min="1" />
                                    <p class="description" id="tagline-description"><?php esc_html_e( 'Enter maximum number of posts.', 'gou-manage-related-posts-similar-posts' ); ?></p>
                                    
                                </td>
                            </tr>
                            
                            <tr valign="top" class="">
                                <th scope="row" class="titledesc">
                                    <label for="woocommerce_gwat_layout[type]">
                                        <?php esc_html_e( 'Layout:', 'gou-manage-related-posts-similar-posts' ); ?>
                                    </label>
                                </th>
                                
                                <td class="forminp">
                                	
                                    <?php
                                    $layout_type = isset( $section_settings['layout']['layout_type'] ) ? $section_settings['layout']['layout_type'] : 'thumb';
                                    ?>
                                    
                                    <input type="radio" name="grp_configuration_fields[<?php echo esc_attr( $key );?>][layout][layout_type]" class="grp-show-layout-view" value="thumb" <?php if( esc_attr( $layout_type ) == 'thumb' ){ echo 'checked="checked"'; } ?> > <?php esc_html_e( 'Thumb View', 'gou-manage-related-posts-similar-posts' ); ?>
                                    
                                    <input type="radio" name="grp_configuration_fields[<?php echo esc_attr( $key );?>][layout][layout_type]" class="grp-show-layout-view" value="list" <?php if( esc_attr( $layout_type ) == 'list' ){ echo 'checked="checked"'; } ?> > <?php esc_html_e( 'List View', 'gou-manage-related-posts-similar-posts' ); ?>
                                    
                                </td>
                            </tr>
                            
                            <tr valign="top" class="">
                                <td colspan="2" class="grp-outer-td">
                                    
                                    <div class="grp-layout-inner">
                                        <table class="form-table">
                                            <tbody>
                                                
                                                <tr valign="top" class="grp-show-thumb-view <?php if( esc_attr( $layout_type ) == 'list' ){ echo 'hidden'; } ?>">
                                                    <th scope="row" class="titledesc">
                                                        <label for="woocommerce_gwat_layout[type]">
                                                            <?php esc_html_e( 'Posts Per Row?:', 'gou-manage-related-posts-similar-posts' ); ?>
                                                        </label>
                                                    </th>
                                                    
                                                    <td class="forminp">
                                                        
                                                        <?php
														$per_row_posts = isset( $section_settings['layout']['per_row_posts'] ) ? $section_settings['layout']['per_row_posts'] : 3;
														?>
														
                                                        <select name="grp_configuration_fields[<?php echo esc_attr( $key );?>][layout][per_row_posts]" class="grp-configuration-select">
                                                        	<option value="1" <?php if( esc_attr( $per_row_posts ) == '1' ){echo 'selected="selected"';} ?>>1</option>
                                                            <option value="2" <?php if( esc_attr( $per_row_posts ) == '2' ){echo 'selected="selected"';} ?>>2</option>
                                                            <option value="3" <?php if( esc_attr( $per_row_posts ) == '3' ){echo 'selected="selected"';} ?>>3</option>
                                                            <option value="4" <?php if( esc_attr( $per_row_posts ) == '4' ){echo 'selected="selected"';} ?>>4</option>
                                                            <option value="5" <?php if( esc_attr( $per_row_posts ) == '5' ){echo 'selected="selected"';} ?>>5</option>
                                                        
                                                        </select>
                                                        
                                                        <p class="description" id="tagline-description"><?php esc_html_e( 'Enter number of posts, you want to show in per row.', 'gou-manage-related-posts-similar-posts' ); ?></p>
                                                        
                                                    </td>
                                                </tr>
                                                
                                                <tr valign="top" class="">
                                                    <th scope="row" class="titledesc">
                                                        <label for="woocommerce_gwat_layout[type]">
                                                            <?php esc_html_e( 'Show Thumb:', 'gou-manage-related-posts-similar-posts' ); ?>
                                                        </label>
                                                    </th>
                                                    
                                                    <td class="forminp">
                                                        
                                                        <?php
														$show_thumb = isset( $section_settings['layout']['show_thumb'] ) ? $section_settings['layout']['show_thumb'] : '';
														if( empty( $section_settings ) ){
															$show_thumb = '1';
														}
														?>
                                                        
                                                        <input name="grp_configuration_fields[<?php echo esc_attr( $key );?>][layout][show_thumb]" type="checkbox" class="grp-show-post-thumbnail-image" value="1" <?php if( esc_attr( $show_thumb ) == '1' ){ echo 'checked="checked"';} ?>> <?php esc_html_e( 'If you want to show thumb for listing.', 'gou-manage-related-posts-similar-posts' ); ?>
                                                    </td>
                                                </tr>
                                                
                                                <tr valign="top" class="grp-show-thumbnail-image <?php if( esc_attr( $show_thumb ) != '1' ){ echo 'hidden'; } ?>">
                                                    <th scope="row" class="titledesc">
                                                        <label for="woocommerce_gwat_layout[type]">
                                                            <?php esc_html_e( 'Default image:', 'gou-manage-related-posts-similar-posts' ); ?>
                                                        </label>
                                                    </th>
                                                    
                                                    <td class="forminp">
                                                        
                                                        <?php 
														
														$image_id = isset( $section_settings['layout']['default_image'] ) ? $section_settings['layout']['default_image'] : '';
														
														if( !empty( $image_id ) && $image = wp_get_attachment_image_src( $image_id ) ) { ?>
    
                                                            <div class="grp-default-image-container">
                                                                
                                                                <div class="grp-default-image">
                                                                    <div class="grp-remove-default-image">
                                                                        <img title="<?php esc_html_e( 'Remove Image', 'gou-manage-related-posts-similar-posts' ); ?>" src="<?php echo esc_url( GRP_PLUGIN_DIR_URL . 'admin/images/x.png' ); ?>" />
                                                                    </div>
                                                                    <div class="grp-show-default-image">
                                                                    	<img src="<?php echo esc_attr( $image[0] );?>" />
                                                                    </div>
                                                                </div>
                                                                
                                                                <button class="button grp-upload-default-image hidden"><?php esc_html_e( 'Upload Image', 'gou-manage-related-posts-similar-posts' ); ?></button>
                                                                
                                                                <input type="hidden" name="grp_configuration_fields[<?php echo esc_attr( $key );?>][layout][default_image]" value="<?php echo esc_attr( $image_id );?>">
                                                                
                                                            </div>
                                                        
                                                        <?php } else { ?>
                                                            
                                                            <div class="grp-default-image-container">
                                                                
                                                                <div class="grp-default-image hidden">
                                                                    <div class="grp-remove-default-image">
                                                                        <img title="<?php esc_html_e( 'Remove Image', 'gou-manage-related-posts-similar-posts' ); ?>" src="<?php echo esc_url( GRP_PLUGIN_DIR_URL . 'admin/images/x.png' ); ?>" />
                                                                    </div>
                                                                    <div class="grp-show-default-image"></div>
                                                                </div>
                                                                
                                                                <button class="button grp-upload-default-image"><?php esc_html_e( 'Upload Image', 'gou-manage-related-posts-similar-posts' ); ?></button>
                                                                
                                                                <input type="hidden" name="grp_configuration_fields[<?php echo esc_attr( $key );?>][layout][default_image]" value="">
                                                                
                                                            </div>
                                                            
                                                        <?php }  ?>
                                                        
                                                        <p class="description" id="tagline-description"><?php esc_html_e( 'If image not found in post, then it will show as default.', 'gou-manage-related-posts-similar-posts' ); ?></p>
                                                        
                                                    </td>
                                                </tr>
                                                
                                                <tr valign="top" class="grp-show-thumbnail-image <?php if( esc_attr( $show_thumb ) != '1' ){ echo 'hidden'; } ?>">
                                                    <th scope="row" class="titledesc">
                                                        <label for="woocommerce_gwat_layout[type]">
                                                            <?php esc_html_e( 'Thumbnail Size:', 'gou-manage-related-posts-similar-posts' ); ?>
                                                        </label>
                                                    </th>
                                                    
                                                    <td class="forminp">
                                                        
                                                        <select name="grp_configuration_fields[<?php echo esc_attr( $key );?>][layout][thumb_size]" class="grp-configuration-select">
                                                        
                                                            <?php
                                                            $image_sizes = grp_get_images_sizes();
															
															$thumb_size = isset( $section_settings['layout']['thumb_size'] ) ? $section_settings['layout']['thumb_size'] : '';
                                                            
															$options = '';
															
                                                            foreach( $image_sizes as $imagekey => $imageval ){
                                                                
                                                                $height_width = $imagekey.' ('.$imageval['width'].'&#215;'.$imageval['height'].')';
                                                                
																$selected = '';
																if( esc_attr( $thumb_size ) == $imagekey )
																	$selected = 'selected="selected"';
																
                                                                $options .= '<option '.$selected.' value="'.esc_attr( $imagekey ).'">'.esc_attr( $height_width ).'</option>';
                                                            
                                                            }
															
															echo wp_kses(
                                                                $options,
                                                                array(
                                                                    'option' => array(
                                                                        'value'    => true,
                                                                        'selected' => true,
                                                                    ),
                                                                )
                                                            );
                                                            
                                                            ?>
                                                        
                                                        </select>
                                                        
                                                        <p class="description" id="tagline-description"><?php esc_html_e( 'Which size of images you want to show for listings.', 'gou-manage-related-posts-similar-posts' ); ?></p>
                                                       
                                                    </td>
                                                </tr>
                                                
                                                <tr valign="top" class="">
                                                    <th scope="row" class="titledesc">
                                                        <label for="woocommerce_gwat_layout[type]">
                                                            <?php esc_html_e( 'Show Title:', 'gou-manage-related-posts-similar-posts' ); ?>
                                                        </label>
                                                    </th>
                                                    
                                                    <td class="forminp">
                                                        
                                                        <?php
														$show_title = isset( $section_settings['layout']['show_title'] ) ? $section_settings['layout']['show_title'] : '';
														if( empty( $section_settings ) ){
															$show_title = '1';
														}
														?>
                                                        
                                                        <input name="grp_configuration_fields[<?php echo esc_attr( $key );?>][layout][show_title]" type="checkbox" id="users_can_register" value="1" <?php if( esc_attr( $show_title ) == '1' ){ echo 'checked="checked"';} ?>> <?php esc_html_e( 'Select this if show title on listing.', 'gou-manage-related-posts-similar-posts' ); ?>
                                                    </td>
                                                </tr>
                                                
                                                <tr valign="top" class="">
                                                    <th scope="row" class="titledesc">
                                                        <label for="woocommerce_gwat_layout[type]">
                                                            <?php esc_html_e( 'Show Created Date:', 'gou-manage-related-posts-similar-posts' ); ?>
                                                        </label>
                                                    </th>
                                                    
                                                    <td class="forminp">
                                                        
                                                        <?php
														$show_date = isset( $section_settings['layout']['show_date'] ) ? $section_settings['layout']['show_date'] : '';
														if( empty( $section_settings ) ){
															$show_date = '1';
														}
														?>
                                                        
                                                        <input name="grp_configuration_fields[<?php echo esc_attr( $key );?>][layout][show_date]" type="checkbox" id="users_can_register" value="1" <?php if( esc_attr( $show_date ) == '1' ){ echo 'checked="checked"';} ?>> <?php esc_html_e( 'Show created date on listing.', 'gou-manage-related-posts-similar-posts' ); ?>
                                                    </td>
                                                </tr>
                                                
                                                <tr valign="top" class="">
                                                    <th scope="row" class="titledesc">
                                                        <label for="woocommerce_gwat_layout[type]">
                                                            <?php esc_html_e( 'Show Author:', 'gou-manage-related-posts-similar-posts' ); ?>
                                                        </label>
                                                    </th>
                                                    
                                                    <td class="forminp">
                                                        
                                                        <?php
														$show_author = isset( $section_settings['layout']['show_author'] ) ? $section_settings['layout']['show_author'] : '';
														if( empty( $section_settings ) ){
															$show_author = '1';
														}
														?>
                                                        
                                                        <input name="grp_configuration_fields[<?php echo esc_attr( $key );?>][layout][show_author]" type="checkbox" id="users_can_register" value="1" <?php if( esc_attr( $show_author ) == '1' ){ echo 'checked="checked"';} ?>> <?php esc_html_e( 'Show post author on listing.', 'gou-manage-related-posts-similar-posts' ); ?>
                                                    </td>
                                                </tr>
                                                
                                                <tr valign="top" class="">
                                                    <th scope="row" class="titledesc">
                                                        <label for="woocommerce_gwat_layout[type]">
                                                            <?php esc_html_e( 'Show Categories:', 'gou-manage-related-posts-similar-posts' ); ?>
                                                        </label>
                                                    </th>
                                                    
                                                    <td class="forminp">
                                                        
                                                        <?php
														$show_categories = isset( $section_settings['layout']['show_categories'] ) ? $section_settings['layout']['show_categories'] : '';
														if( empty( $section_settings ) ){
															$show_categories = '1';
														}
														?>
                                                        
                                                        <input name="grp_configuration_fields[<?php echo esc_attr( $key );?>][layout][show_categories]" class="grp-show-post-categories" type="checkbox" id="users_can_register" value="1" <?php if( esc_attr( $show_categories ) == '1' ){ echo 'checked="checked"';} ?>> <?php esc_html_e( 'Show the categories on listing.', 'gou-manage-related-posts-similar-posts' ); ?>
                                                       
                                                    </td>
                                                </tr>
                                                
                                                <tr valign="top" class="grp-show-categories <?php if( esc_attr( $show_categories ) != '1' ){ echo 'hidden'; } ?>">
                                                    <th scope="row" class="titledesc">
                                                        <label for="woocommerce_gwat_layout[type]">
                                                            <?php esc_html_e( 'Which Taxonomy?:', 'gou-manage-related-posts-similar-posts' ); ?>
                                                        </label>
                                                    </th>
                                                    
                                                    <td class="forminp">
                                                        
                                                        <?php
														$show_which_categories = isset( $section_settings['layout']['show_which_categories'] ) ? $section_settings['layout']['show_which_categories'] : '';
														?>
                                                        
                                                        <select name="grp_configuration_fields[<?php echo esc_attr( $key );?>][layout][show_which_categories]" class="grp-configuration-select">
                                                        
                                                            <?php
                                                            if( !empty( $taxonomies ) ){
                                                            	
																$options = '';
                                                                foreach( $taxonomies as $innertkey => $innertval ){
                                                                    
																	$selected = '';
																	if( esc_attr( $show_which_categories ) == $innertkey )
																		$selected = 'selected="selected"';
																		
                                                                    $options .= '<option '.$selected.' value="'.esc_attr( $innertkey ).'">'.esc_attr( $innertval ).'</option>';
                                                                
                                                                }
																
																echo wp_kses(
                                                                    $options,
                                                                    array(
                                                                        'option' => array(
                                                                            'value'    => true,
                                                                            'selected' => true,
                                                                        ),
                                                                    )
                                                                );
                                                            
                                                            }
                                                            
                                                            ?>
                                                        
                                                        </select>
                                                        
                                                        <p class="description" id="tagline-description"><?php esc_html_e( 'Which type of categories, you want to show on listing.', 'gou-manage-related-posts-similar-posts' ); ?></p>
                                                       
                                                    </td>
                                                </tr>
                                                
                                                <tr valign="top" class="">
                                                    <th scope="row" class="titledesc">
                                                        <label for="woocommerce_gwat_layout[type]">
                                                            <?php esc_html_e( 'Show Excerpt?:', 'gou-manage-related-posts-similar-posts' ); ?>
                                                        </label>
                                                    </th>
                                                    
                                                    <td class="forminp">
                                                        
                                                        <?php
														$show_excerpt = isset( $section_settings['layout']['show_excerpt'] ) ? $section_settings['layout']['show_excerpt'] : '';
														if( empty( $section_settings ) ){
															$show_excerpt = '1';
														}
														?>
                                                        
                                                        <input name="grp_configuration_fields[<?php echo esc_attr( $key );?>][layout][show_excerpt]" class="grp-show-post-excerpt" type="checkbox" id="users_can_register" value="1" <?php if( esc_attr( $show_excerpt ) == '1' ){ echo 'checked="checked"';} ?>> <?php esc_html_e( 'Are you want to show excerpt on listing.', 'gou-manage-related-posts-similar-posts' ); ?>
                                                       
                                                    </td>
                                                </tr>
                                                
                                                <tr valign="top" class="grp-show-excerpt <?php if( esc_attr( $show_excerpt ) != '1' ){ echo 'hidden'; } ?>">
                                                    <th scope="row" class="titledesc">
                                                        <label for="woocommerce_gwat_layout[type]">
                                                            <?php esc_html_e( 'Excerpt length:', 'gou-manage-related-posts-similar-posts' ); ?>
                                                        </label>
                                                    </th>
                                                    
                                                    <td class="forminp">
                                                        
                                                        <?php
														$excerpt_length = isset( $section_settings['layout']['excerpt_length'] ) ? $section_settings['layout']['excerpt_length'] : 10;
														?>
                                                        
                                                        <input name="grp_configuration_fields[<?php echo esc_attr( $key );?>][layout][excerpt_length]" type="number" class="regular-text" value="<?php echo esc_attr( $excerpt_length );?>" min="1" />
                                                        <p class="description" id="tagline-description"><?php esc_html_e( 'Number of words, you want to show in excerpt.', 'gou-manage-related-posts-similar-posts' ); ?></p>
                                                        
                                                    </td>
                                                </tr>
                                                
                                                <tr valign="top" class="grp-show-excerpt <?php if( esc_attr( $show_excerpt ) != '1' ){ echo 'hidden'; } ?>">
                                                    <th scope="row" class="titledesc">
                                                        <label for="woocommerce_gwat_layout[type]">
                                                            <?php esc_html_e( 'Read More Button?:', 'gou-manage-related-posts-similar-posts' ); ?>
                                                        </label>
                                                    </th>
                                                    
                                                    <td class="forminp">
                                                        
                                                        <?php
														$read_more = isset( $section_settings['layout']['read_more'] ) ? $section_settings['layout']['read_more'] : 'always';
														?>
                                                        
                                                        <select name="grp_configuration_fields[<?php echo esc_attr( $key );?>][layout][read_more]" class="grp-configuration-select">
                                                            <option value="no" <?php if( esc_attr( $read_more ) == 'no' ) { echo 'selected="selected"'; }?> ><?php esc_html_e( 'No Need', 'gou-manage-related-posts-similar-posts' ); ?></option>
                                                            <option value="yes" <?php if( esc_attr( $read_more ) == 'yes' ) { echo 'selected="selected"'; }?> ><?php esc_html_e( 'Only when content length in greater then excerpt length', 'gou-manage-related-posts-similar-posts' ); ?></option>
                                                            <option value="always" <?php if( esc_attr( $read_more ) == 'always' ) { echo 'selected="selected"'; }?> ><?php esc_html_e( 'Always Show', 'gou-manage-related-posts-similar-posts' ); ?></option>
                                                        </select>
                                                        <p class="description" id="tagline-description"><?php esc_html_e( 'Select the conditon for read more button.', 'gou-manage-related-posts-similar-posts' ); ?></p>
                                                        
                                                    </td>
                                                </tr>
                                                
                                            </tbody>
                                        </table>
                                    </div>
                                    
                                </td>
                            </tr>
                            
                            <tr valign="top">
                                <td colspan="2" class="grp-full-width-td"><div class="grp-full-width-heading"><?php esc_html_e( 'Set Order ::', 'gou-manage-related-posts-similar-posts' ); ?> <em><?php esc_html_e( 'Set the order for related posts.', 'gou-manage-related-posts-similar-posts' ); ?></em></div></td>
                            </tr>
                            
                            <tr valign="top" class=""> 
                            
                               <th scope="row" class="titledesc">
                                    <label for="woocommerce_gwat_layout[type]">
                                        <?php
                                        printf(
                                            /* translators: %s: order by label */
                                            esc_html__( 'Order By %s :', 'gou-manage-related-posts-similar-posts' ),
                                            esc_html( $val )
                                        );
                                        ?>
                                    </label>
                                </th>
                                
                                <td class="forminp">
                                    
                                    <select name="grp_configuration_fields[<?php echo esc_attr( $key );?>][order_by]" class="grp-configuration-select">
                                        
                                        <?php
                                        
                                        $options_arr = Grp_Admin_Settings::grp_configuration_order_by_opts( $key );
                                        
                                        if( !empty( $options_arr ) ){
                                            
                                            $match_case = isset( $section_settings['order_by'] ) ? $section_settings['order_by'] : 'within_match';
                                            
											$options = '';
                                            foreach( $options_arr as $okey => $oval ){
                                                
                                                $selected = '';
                                                if( $match_case == $okey )
                                                    $selected = 'selected="selected"';
                                                
                                                $options .= '<option '.$selected.' value="'.esc_attr( $okey ).'">'.esc_attr( $oval ).'</option>';
                                            
                                            }
											
                                            echo wp_kses(
                                                $options,
                                                array(
                                                    'option' => array(
                                                        'value'    => true,
                                                        'selected' => true,
                                                    ),
                                                )
                                            );
                                        
                                        }
                                        
                                        ?>
                                        
                                    </select>
                                    
                                </td>
                            
                            </tr>
                            
                            <tr valign="top" class="">
                                <td colspan="2">
                                    <input type="button" class="button-primary" name="grp_update_section_settings" value="<?php esc_html_e( 'Save Changes', 'gou-manage-related-posts-similar-posts' ); ?>">
                                </td>
                            </tr>
                            
                            </tbody>
                        </table>
                    	
                        <?php wp_nonce_field('grp-admin-configuration-settings', '_wpnonce_grp_admin_configuration_settings');?>
                        
					</form>
                    
                    </div>
                
                </div>
                
            </li>
        
        <?php } ?>
    
    </ol>

</section>