<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha;

class GoogleAnalyticsAdminV1alphaReportingDataAnnotation extends \Google\Site_Kit_Dependencies\Google\Model
{
    /**
     * Color unknown or not specified.
     */
    public const COLOR_COLOR_UNSPECIFIED = 'COLOR_UNSPECIFIED';
    /**
     * Purple color.
     */
    public const COLOR_PURPLE = 'PURPLE';
    /**
     * Brown color.
     */
    public const COLOR_BROWN = 'BROWN';
    /**
     * Blue color.
     */
    public const COLOR_BLUE = 'BLUE';
    /**
     * Green color.
     */
    public const COLOR_GREEN = 'GREEN';
    /**
     * Red color.
     */
    public const COLOR_RED = 'RED';
    /**
     * Cyan color.
     */
    public const COLOR_CYAN = 'CYAN';
    /**
     * Orange color. (Only used for system-generated annotations)
     */
    public const COLOR_ORANGE = 'ORANGE';
    protected $annotationDateType = \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\GoogleTypeDate::class;
    protected $annotationDateDataType = '';
    protected $annotationDateRangeType = \Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\GoogleAnalyticsAdminV1alphaReportingDataAnnotationDateRange::class;
    protected $annotationDateRangeDataType = '';
    /**
     * Required. The color used for display of this Reporting Data Annotation.
     *
     * @var string
     */
    public $color;
    /**
     * Optional. Description for this Reporting Data Annotation.
     *
     * @var string
     */
    public $description;
    /**
     * Required. Identifier. Resource name of this Reporting Data Annotation.
     * Format: 'properties/{property_id}/reportingDataAnnotations/{reporting_data_
     * annotation}' Format: 'properties/123/reportingDataAnnotations/456'
     *
     * @var string
     */
    public $name;
    /**
     * Output only. If true, this annotation was generated by the Google Analytics
     * system. System-generated annotations cannot be updated or deleted.
     *
     * @var bool
     */
    public $systemGenerated;
    /**
     * Required. Human-readable title for this Reporting Data Annotation.
     *
     * @var string
     */
    public $title;
    /**
     * If set, the Reporting Data Annotation is for a specific date represented by
     * this field. The date must be a valid date with year, month and day set. The
     * date may be in the past, present, or future.
     *
     * @param GoogleTypeDate $annotationDate
     */
    public function setAnnotationDate(\Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\GoogleTypeDate $annotationDate)
    {
        $this->annotationDate = $annotationDate;
    }
    /**
     * @return GoogleTypeDate
     */
    public function getAnnotationDate()
    {
        return $this->annotationDate;
    }
    /**
     * If set, the Reporting Data Annotation is for a range of dates represented
     * by this field.
     *
     * @param GoogleAnalyticsAdminV1alphaReportingDataAnnotationDateRange $annotationDateRange
     */
    public function setAnnotationDateRange(\Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\GoogleAnalyticsAdminV1alphaReportingDataAnnotationDateRange $annotationDateRange)
    {
        $this->annotationDateRange = $annotationDateRange;
    }
    /**
     * @return GoogleAnalyticsAdminV1alphaReportingDataAnnotationDateRange
     */
    public function getAnnotationDateRange()
    {
        return $this->annotationDateRange;
    }
    /**
     * Required. The color used for display of this Reporting Data Annotation.
     *
     * Accepted values: COLOR_UNSPECIFIED, PURPLE, BROWN, BLUE, GREEN, RED, CYAN,
     * ORANGE
     *
     * @param self::COLOR_* $color
     */
    public function setColor($color)
    {
        $this->color = $color;
    }
    /**
     * @return self::COLOR_*
     */
    public function getColor()
    {
        return $this->color;
    }
    /**
     * Optional. Description for this Reporting Data Annotation.
     *
     * @param string $description
     */
    public function setDescription($description)
    {
        $this->description = $description;
    }
    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Required. Identifier. Resource name of this Reporting Data Annotation.
     * Format: 'properties/{property_id}/reportingDataAnnotations/{reporting_data_
     * annotation}' Format: 'properties/123/reportingDataAnnotations/456'
     *
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }
    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Output only. If true, this annotation was generated by the Google Analytics
     * system. System-generated annotations cannot be updated or deleted.
     *
     * @param bool $systemGenerated
     */
    public function setSystemGenerated($systemGenerated)
    {
        $this->systemGenerated = $systemGenerated;
    }
    /**
     * @return bool
     */
    public function getSystemGenerated()
    {
        return $this->systemGenerated;
    }
    /**
     * Required. Human-readable title for this Reporting Data Annotation.
     *
     * @param string $title
     */
    public function setTitle($title)
    {
        $this->title = $title;
    }
    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdminV1alpha\GoogleAnalyticsAdminV1alphaReportingDataAnnotation::class, 'Google\\Site_Kit_Dependencies\\Google_Service_GoogleAnalyticsAdminV1alpha_GoogleAnalyticsAdminV1alphaReportingDataAnnotation');
