<?php
/**
 * BestWebSoft product list
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $bws_plugin_info, $wp_version;

$bws_plugins_category = array(
	'admin-tools' => array( 'name' => __( 'Admin Tools', 'bestwebsoft' ) ),
	'content'     => array( 'name' => __( 'Content', 'bestwebsoft' ) ),
	'ecommerce'   => array( 'name' => __( 'eCommerce', 'bestwebsoft' ) ),
	'marketing'   => array( 'name' => __( 'Marketing', 'bestwebsoft' ) ),
	'navigation'  => array( 'name' => __( 'Navigation', 'bestwebsoft' ) ),
	'recommended' => array( 'name' => __( 'Recommended', 'bestwebsoft' ) ),
	'security'    => array( 'name' => __( 'Security', 'bestwebsoft' ) ),
	'seo'         => array( 'name' => __( 'SEO', 'bestwebsoft' ) ),
);

$bws_plugins = array(
	'adblock-detector-by-bestwebsoft/adblock-detector-by-bestwebsoft.php'                       => array(
		'category'     => array( 'ecommerce' ),
		'name'         => 'Adblocker Detector',
		'description'  => __( 'Detects adblocks and displays a non-closable popup banner asking users to turn off their adblocker.', 'bestwebsoft' ),
		'link'         => 'https://bestwebsoft.com/products/wordpress/plugins/adblock-detector/?k=04387cfc31fc8b9553e4741392762231&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'settings'     => 'admin.php?page=adblock-detector-by-bestwebsoft.php',
		'pro_version'  => 'adblock-detector-pro/adblock-detector-pro.php',
		'purchase'     => 'https://bestwebsoft.com/products/wordpress/plugins/adblock-detector/buy/?k=9b3222b005340035eaead38a7a495a0d&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'pro_settings' => 'admin.php?page=adblock-detector-pro.php',
		'icon'         => bws_menu_url( 'icons/plugins/' ) . 'adblock-detector-by-bestwebsoft.png',
		'install_url'  => 'https://bestwebsoft.com/products/wordpress/plugins/adblock-detector/',
	),
	'bike-rental/bike-rental.php'                       => array(
		'category'     => array( 'ecommerce' ),
		'name'         => 'Bike Rental',
		'description'  => __( 'Give a birth for your bike rental and booking WordPress website.', 'bestwebsoft' ),
		'link'         => 'https://bestwebsoft.com/products/wordpress/plugins/bike-rental/?k=04387cfc31fc8b9553e4741392762231&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'settings'     => 'edit.php?post_type=bws_bike&page=bkng_general_settings',
		'pro_version'  => 'bike-rental-pro/bike-rental-pro.php',
		'purchase'     => 'https://bestwebsoft.com/products/wordpress/plugins/bike-rental/buy/?k=9b3222b005340035eaead38a7a495a0d&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'pro_settings' => 'edit.php?post_type=bws_bike&page=bkrntl_bws_bike_settings',
		'icon'         => bws_menu_url( 'icons/plugins/' ) . 'bike-rental.png',
		'install_url'  => 'https://bestwebsoft.com/products/wordpress/plugins/bike-rental/',
	),
	'captcha-bws/captcha-bws.php'                       => array(
		'category'     => array( 'security', 'recommended' ),
		'name'         => 'Captcha',
		'description'  => __( 'Best secure captcha plugin to protect your WordPress forms.', 'bestwebsoft' ),
		'link'         => 'https://bestwebsoft.com/products/wordpress/plugins/captcha/?k=d678516c0990e781edfb6a6c874f0b8a&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'settings'     => 'admin.php?page=captcha.php',
		'pro_version'  => 'captcha-pro/captcha_pro.php',
		'purchase'     => 'https://bestwebsoft.com/products/wordpress/plugins/captcha/buy/?k=ff7d65e55e5e7f98f219be9ed711094e&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'pro_settings' => 'admin.php?page=captcha_pro.php',
	),
	'contact-form-plugin/contact_form.php'              => array(
		'category'     => array( 'marketing', 'recommended' ),
		'name'         => 'Contact Form',
		'description'  => __( 'Allow customers to reach you using secure contact form plugin any website must have.', 'bestwebsoft' ),
		'link'         => 'https://bestwebsoft.com/products/wordpress/plugins/contact-form/?k=012327ef413e5b527883e031d43b088b&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'settings'     => 'admin.php?page=contact_form.php',
		'pro_version'  => 'contact-form-pro/contact_form_pro.php',
		'purchase'     => 'https://bestwebsoft.com/products/wordpress/plugins/contact-form/buy/?k=773dc97bb3551975db0e32edca1a6d71&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'pro_settings' => 'admin.php?page=contact_form_pro.php',
	),
	'custom-search-plugin/custom-search-plugin.php'     => array(
		'category'     => array( 'navigation' ),
		'name'         => 'Custom Search',
		'description'  => __( 'Add custom post types and taxonomies to WordPress website search results.', 'bestwebsoft' ),
		'link'         => 'https://bestwebsoft.com/products/wordpress/plugins/custom-search/?k=933be8f3a8b8719d95d1079d15443e29&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'settings'     => 'admin.php?page=custom_search.php',
		'pro_version'  => 'custom-search-pro/custom-search-pro.php',
		'purchase'     => 'https://bestwebsoft.com/products/wordpress/plugins/custom-search/buy/?k=062b652ac6ac8ba863c9f30fc21d62c6&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'pro_settings' => 'admin.php?page=custom_search_pro.php',
	),
	'error-log-viewer/error-log-viewer.php'             => array(
		'category'    => array( 'admin-tools' ),
		'name'        => 'Error Log Viewer',
		'description' => __( 'Get latest error log messages to diagnose website problems. Define and fix issues faster.', 'bestwebsoft' ),
		'link'        => 'https://bestwebsoft.com/products/wordpress/plugins/error-log-viewer/?k=da0de8bd2c7a0b2fea5df64d55a368b3&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'settings'    => 'admin.php?page=rrrlgvwr.php&tab=settings',
	),
	'gallery-plugin/gallery-plugin.php'                 => array(
		'category'     => array( 'content', 'recommended' ),
		'name'         => 'Gallery',
		'description'  => __( 'Add beautiful galleries, albums & images to your WordPress website in a few clicks.', 'bestwebsoft' ),
		'link'         => 'https://bestwebsoft.com/products/wordpress/plugins/gallery/?k=2da21c0a64eec7ebf16337fa134c5f78&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'settings'     => 'admin.php?page=gallery-plugin.php',
		'pro_version'  => 'gallery-plugin-pro/gallery-plugin-pro.php',
		'purchase'     => 'https://bestwebsoft.com/products/wordpress/plugins/gallery/buy/?k=382e5ce7c96a6391f5ffa5e116b37fe0&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'pro_settings' => 'admin.php?page=gallery-plugin-pro.php',
	),
	'bws-google-2-step-verification/bws-google-2-step-verification.php' => array(
		'category'     => array( 'security' ),
		'name'         => '2-Step Verification',
		'description'  => __( 'Stronger security solution which protects your WordPress website from hacks and unauthorized login attempts.', 'bestwebsoft' ),
		'link'         => 'https://bestwebsoft.com/products/wordpress/plugins/google-2-step-verification/?k=78de1a525f968d56e39f7325908aa98e&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'settings'     => 'admin.php?page=google-2-step-verification.php',
		'pro_version'  => 'bws-google-2-step-verification-pro/bws-google-2-step-verification-pro.php',
		'purchase'     => 'https://bestwebsoft.com/products/wordpress/plugins/google-2-step-verification/buy/?k=b5605ea9bb3628682cfa416e70e78410&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'pro_settings' => 'admin.php?page=google-2-step-verification-pro.php',
	),
	'google-captcha/google-captcha.php'                 => array(
		'category'     => array( 'security', 'recommended' ),
		'name'         => 'reCaptcha',
		'description'  => __( 'Protect WordPress website forms from spam entries with reCaptcha.', 'bestwebsoft' ),
		'link'         => 'https://bestwebsoft.com/products/wordpress/plugins/google-captcha/?k=7b59fbe542acf950b29f3e020d5ad735&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'settings'     => 'admin.php?page=google-captcha.php',
		'pro_version'  => 'google-captcha-pro/google-captcha-pro.php',
		'purchase'     => 'https://bestwebsoft.com/products/wordpress/plugins/google-captcha/buy/?k=773d30149acf1edc32e5c0766b96c134&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'pro_settings' => 'admin.php?page=google-captcha-pro.php',
	),
	'google-sitemap-plugin/google-sitemap-plugin.php'   => array(
		'category'     => array( 'seo', 'recommended' ),
		'name'         => 'Sitemap',
		'description'  => __( 'Generate and add XML sitemap to WordPress website. Help search engines index your blog.', 'bestwebsoft' ),
		'link'         => 'https://bestwebsoft.com/products/wordpress/plugins/google-sitemap/?k=5202b2f5ce2cf85daee5e5f79a51d806&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'settings'     => 'admin.php?page=google-sitemap-plugin.php',
		'pro_version'  => 'google-sitemap-pro/google-sitemap-pro.php',
		'purchase'     => 'https://bestwebsoft.com/products/wordpress/plugins/google-sitemap/buy/?k=7ea384a5cc36cb4c22741caa20dcd56d&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'pro_settings' => 'admin.php?page=google-sitemap-pro.php',
	),
	'htaccess/htaccess.php'                            => array(
		'category'     => array( 'security' ),
		'name'         => 'Htaccess',
		'description'  => __( 'Protect WordPress website – allow and deny access for certain IP addresses, hostnames, etc.', 'bestwebsoft' ),
		'link'         => 'https://bestwebsoft.com/products/wordpress/plugins/htaccess/?k=2b865fcd56a935d22c5c4f1bba52ed46&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'settings'     => 'admin.php?page=htaccess.php',
		'pro_version'  => 'htaccess-pro/htaccess-pro.php',
		'purchase'     => 'https://bestwebsoft.com/products/wordpress/plugins/htaccess/buy/?k=59e9209a32864be534fda77d5e591c15&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'pro_settings' => 'admin.php?page=htaccess-pro.php',
	),
	'limit-attempts/limit-attempts.php'                 => array(
		'category'     => array( 'security', 'recommended' ),
		'name'         => 'Limit Attempts',
		'description'  => __( 'Protect WordPress website against brute force attacks. Limit rate of login attempts.', 'bestwebsoft' ),
		'link'         => 'https://bestwebsoft.com/products/wordpress/plugins/limit-attempts/?k=b14e1697ee4d008abcd4bd34d492573a&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'settings'     => 'admin.php?page=limit-attempts.php',
		'pro_version'  => 'limit-attempts-pro/limit-attempts-pro.php',
		'purchase'     => 'https://bestwebsoft.com/products/wordpress/plugins/limit-attempts/buy/?k=9d42cdf22c7fce2c4b6b447e6a2856e0&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'pro_settings' => 'admin.php?page=limit-attempts-pro.php',
	),
	'bws-login-register/bws-login-register.php'         => array(
		'category'     => array( 'admin-tools', 'navigation' ),
		'name'         => 'Login & Register Form',
		'description'  => __( 'Add LinkedIn Share and Follow buttons to WordPress posts, pages and widgets. 5 plugins included – profile, insider, etc.', 'bestwebsoft' ),
		'link'         => 'https://bestwebsoft.com/products/wordpress/plugins/login-and-register/?k=7d503ba164eca02ddf5b2c4942cbb953&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'settings'     => 'admin.php?page=login-register-form.php',
		'pro_version'  => 'bws-login-register-pro/bws-login-register-pro.php',
		'purchase'     => 'https://bestwebsoft.com/products/wordpress/plugins/login-and-register/buy/?k=df2a23c0abf357439d325bf3953deaf8&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'pro_settings' => 'admin.php?page=bws-login-register-pro.php',
	),
	'multilanguage/multilanguage.php'                   => array(
		'category'     => array( 'content', 'recommended' ),
		'name'         => 'Multilanguage',
		'description'  => __( 'Translate WordPress website content to other languages manually. Create multilingual pages, posts, widgets, menus, etc.', 'bestwebsoft' ),
		'link'         => 'https://bestwebsoft.com/products/wordpress/plugins/multilanguage/?k=7d68c7bfec2486dc350c67fff57ad433&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'settings'     => 'admin.php?page=mltlngg_settings',
		'pro_version'  => 'multilanguage-pro/multilanguage-pro.php',
		'purchase'     => 'https://bestwebsoft.com/products/wordpress/plugins/multilanguage/buy/?k=2d1121cd9a5ced583fc29eefd51bdf57&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'pro_settings' => 'admin.php?page=mltlnggpr_settings',
	),
	'pagination/pagination.php'                         => array(
		'category'     => array( 'navigation' ),
		'name'         => 'Pagination',
		'description'  => __( 'Add customizable pagination to WordPress website. Split long content to multiple pages for better navigation.', 'bestwebsoft' ),
		'link'         => 'https://bestwebsoft.com/products/wordpress/plugins/pagination/?k=22adb940256f149559ba8fedcd728ac8&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'settings'     => 'admin.php?page=pagination.php',
		'pro_version'  => 'pagination-pro/pagination-pro.php',
		'purchase'     => 'https://bestwebsoft.com/products/wordpress/plugins/pagination/buy/?k=b87201d5a0505c621d0b14f4e8d4ccd6&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'pro_settings' => 'admin.php?page=pagination-pro.php',
	),
	'pdf-print/pdf-print.php'                           => array(
		'category'     => array( 'content' ),
		'name'         => 'PDF & Print',
		'description'  => __( 'Generate PDF files and print WordPress posts/pages. Customize document header/footer styles and appearance.', 'bestwebsoft' ),
		'link'         => 'https://bestwebsoft.com/products/wordpress/plugins/pdf-print/?k=bfefdfb522a4c0ff0141daa3f271840c&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'settings'     => 'admin.php?page=pdf-print.php',
		'pro_version'  => 'pdf-print-pro/pdf-print-pro.php',
		'purchase'     => 'https://bestwebsoft.com/products/wordpress/plugins/pdf-print/buy/?k=fd43a0e659ddc170a9060027cbfdcc3a&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'pro_settings' => 'admin.php?page=pdf-print-pro.php',
	),
	'profile-extra-fields/profile-extra-fields.php'     => array(
		'category'     => array( 'admin-tools' ),
		'name'         => 'Profile Extra Fields',
		'description'  => __( 'Add extra fields to default WordPress user profile. The easiest way to create and manage additional custom values.', 'bestwebsoft' ),
		'link'         => 'https://bestwebsoft.com/products/wordpress/plugins/profile-extra-fields/?k=fe3b6c3dbc80bd4b1cf9a27a2f339820&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'settings'     => 'admin.php?page=profile-extra-fields.php',
		'pro_version'  => 'profile-extra-fields-pro/profile-extra-fields-pro.php',
		'purchase'     => 'https://bestwebsoft.com/products/wordpress/plugins/profile-extra-fields/buy/?k=a1f0b20e50ea10e5453aba399de496c0&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'pro_settings' => 'admin.php?page=profile-extra-fields-pro.php',
	),
	'quotes-and-tips/quotes-and-tips.php'               => array(
		'category'    => array( 'content' ),
		'name'        => 'Quotes and Tips',
		'description' => __( 'Add customizable quotes and tips blocks to WordPress posts, pages and widgets.', 'bestwebsoft' ),
		'link'        => 'https://bestwebsoft.com/products/wordpress/plugins/quotes-and-tips/?k=5738a4e85a798c4a5162240c6515098d&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'settings'    => 'admin.php?page=quotes-and-tips.php',
	),
	'updater/updater.php'                               => array(
		'category'     => array( 'admin-tools', 'recommended' ),
		'name'         => 'Updater',
		'description'  => __( 'Automatically check and update WordPress website core with all installed plugins and themes to the latest versions.', 'bestwebsoft' ),
		'link'         => 'https://bestwebsoft.com/products/wordpress/plugins/updater/?k=66f3ecd4c1912009d395c4bb30f779d1&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'settings'     => 'admin.php?page=updater-options',
		'pro_version'  => 'updater-pro/updater_pro.php',
		'purchase'     => 'https://bestwebsoft.com/products/wordpress/plugins/updater/buy/?k=cf633acbefbdff78545347fe08a3aecb&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'pro_settings' => 'admin.php?page=updater-pro-options',
	),
	'user-role/user-role.php'                           => array(
		'category'     => array( 'admin-tools' ),
		'name'         => 'User Role',
		'description'  => __( 'Powerful user role management plugin for WordPress website. Create, edit, copy, and delete user roles.', 'bestwebsoft' ),
		'link'         => 'https://bestwebsoft.com/products/wordpress/plugins/user-role/?k=dfe2244835c6fbf601523964b3f34ccc&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'settings'     => 'admin.php?page=user-role.php',
		'pro_version'  => 'user-role-pro/user-role-pro.php',
		'purchase'     => 'https://bestwebsoft.com/products/wordpress/plugins/user-role/buy/?k=cfa9cea6613fb3d7c0a3622fa2faaf46&pn=' . $bws_plugin_info['id'] . '&v=' . $bws_plugin_info['version'] . '&wp_v=' . $wp_version,
		'pro_settings' => 'admin.php?page=user-role-pro.php',
	),
);

$themes = array(
	(object) array(
		'name' => 'Opening',
		'slug' => 'opening',
		'href' => 'https://bestwebsoft.com/products/wordpress/themes/opening-job-board-wordpress-theme/',
	),
	(object) array(
		'name' => 'Real Estate',
		'slug' => 'realestate',
		'href' => 'https://bestwebsoft.com/products/wordpress/themes/real-estate-creative-wordpress-theme/',
	),
	(object) array(
		'name' => 'Rent a Bike',
		'slug' => 'rent-a-bike',
		'href' => 'https://bestwebsoft.com/products/wordpress/themes/rent-a-bike-booking-wordpress-theme/',
	),
	(object) array(
		'name' => 'Renty',
		'slug' => 'renty',
		'href' => 'https://bestwebsoft.com/products/wordpress/themes/renty-car-rental-booking-wordpress-theme/',
	),
	(object) array(
		'name' => 'Unity',
		'slug' => 'unity',
		'href' => 'https://bestwebsoft.com/products/wordpress/themes/unity-multipurpose-wordpress-theme/',
	),
);
