<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace SimpleCalendar\plugin_deps\Symfony\Component\Translation;

use SimpleCalendar\plugin_deps\Symfony\Contracts\Translation\TranslatableInterface;
use SimpleCalendar\plugin_deps\Symfony\Contracts\Translation\TranslatorInterface;
/**
 * @author Nate Wiebe <nate@northern.co>
 */
class TranslatableMessage implements TranslatableInterface
{
    private string $message;
    private array $parameters;
    private ?string $domain;
    public function __construct(string $message, array $parameters = [], ?string $domain = null)
    {
        $this->message = $message;
        $this->parameters = $parameters;
        $this->domain = $domain;
    }
    public function __toString(): string
    {
        return $this->getMessage();
    }
    public function getMessage(): string
    {
        return $this->message;
    }
    public function getParameters(): array
    {
        return $this->parameters;
    }
    public function getDomain(): ?string
    {
        return $this->domain;
    }
    public function trans(TranslatorInterface $translator, ?string $locale = null): string
    {
        $parameters = $this->getParameters();
        foreach ($parameters as $k => $v) {
            if ($v instanceof TranslatableInterface) {
                $parameters[$k] = $v->trans($translator, $locale);
            }
        }
        return $translator->trans($this->getMessage(), $parameters, $this->getDomain(), $locale);
    }
}
