<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace SimpleCalendar\plugin_deps\Google\Service\Drive;

class LabelField extends \SimpleCalendar\plugin_deps\Google\Collection
{
    protected $collection_key = 'user';
    /**
     * Only present if valueType is dateString. RFC 3339 formatted date: YYYY-MM-
     * DD.
     *
     * @var string[]
     */
    public $dateString;
    /**
     * The identifier of this label field.
     *
     * @var string
     */
    public $id;
    /**
     * Only present if `valueType` is `integer`.
     *
     * @var string[]
     */
    public $integer;
    /**
     * This is always drive#labelField.
     *
     * @var string
     */
    public $kind;
    /**
     * Only present if `valueType` is `selection`
     *
     * @var string[]
     */
    public $selection;
    /**
     * Only present if `valueType` is `text`.
     *
     * @var string[]
     */
    public $text;
    protected $userType = User::class;
    protected $userDataType = 'array';
    /**
     * The field type. While new values may be supported in the future, the
     * following are currently allowed: * `dateString` * `integer` * `selection` *
     * `text` * `user`
     *
     * @var string
     */
    public $valueType;
    /**
     * Only present if valueType is dateString. RFC 3339 formatted date: YYYY-MM-
     * DD.
     *
     * @param string[] $dateString
     */
    public function setDateString($dateString)
    {
        $this->dateString = $dateString;
    }
    /**
     * @return string[]
     */
    public function getDateString()
    {
        return $this->dateString;
    }
    /**
     * The identifier of this label field.
     *
     * @param string $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }
    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Only present if `valueType` is `integer`.
     *
     * @param string[] $integer
     */
    public function setInteger($integer)
    {
        $this->integer = $integer;
    }
    /**
     * @return string[]
     */
    public function getInteger()
    {
        return $this->integer;
    }
    /**
     * This is always drive#labelField.
     *
     * @param string $kind
     */
    public function setKind($kind)
    {
        $this->kind = $kind;
    }
    /**
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }
    /**
     * Only present if `valueType` is `selection`
     *
     * @param string[] $selection
     */
    public function setSelection($selection)
    {
        $this->selection = $selection;
    }
    /**
     * @return string[]
     */
    public function getSelection()
    {
        return $this->selection;
    }
    /**
     * Only present if `valueType` is `text`.
     *
     * @param string[] $text
     */
    public function setText($text)
    {
        $this->text = $text;
    }
    /**
     * @return string[]
     */
    public function getText()
    {
        return $this->text;
    }
    /**
     * Only present if `valueType` is `user`.
     *
     * @param User[] $user
     */
    public function setUser($user)
    {
        $this->user = $user;
    }
    /**
     * @return User[]
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * The field type. While new values may be supported in the future, the
     * following are currently allowed: * `dateString` * `integer` * `selection` *
     * `text` * `user`
     *
     * @param string $valueType
     */
    public function setValueType($valueType)
    {
        $this->valueType = $valueType;
    }
    /**
     * @return string
     */
    public function getValueType()
    {
        return $this->valueType;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
class_alias(LabelField::class, 'SimpleCalendar\plugin_deps\Google_Service_Drive_LabelField');
