<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace SimpleCalendar\plugin_deps\Google\Service\Drive;

class AboutStorageQuota extends \SimpleCalendar\plugin_deps\Google\Model
{
    /**
     * The usage limit, if applicable. This will not be present if the user has
     * unlimited storage. For users that are part of an organization with pooled
     * storage, this is the limit for the organization, rather than the individual
     * user.
     *
     * @var string
     */
    public $limit;
    /**
     * The total usage across all services. For users that are part of an
     * organization with pooled storage, this is the usage across all services for
     * the organization, rather than the individual user.
     *
     * @var string
     */
    public $usage;
    /**
     * The usage by all files in Google Drive.
     *
     * @var string
     */
    public $usageInDrive;
    /**
     * The usage by trashed files in Google Drive.
     *
     * @var string
     */
    public $usageInDriveTrash;
    /**
     * The usage limit, if applicable. This will not be present if the user has
     * unlimited storage. For users that are part of an organization with pooled
     * storage, this is the limit for the organization, rather than the individual
     * user.
     *
     * @param string $limit
     */
    public function setLimit($limit)
    {
        $this->limit = $limit;
    }
    /**
     * @return string
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * The total usage across all services. For users that are part of an
     * organization with pooled storage, this is the usage across all services for
     * the organization, rather than the individual user.
     *
     * @param string $usage
     */
    public function setUsage($usage)
    {
        $this->usage = $usage;
    }
    /**
     * @return string
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * The usage by all files in Google Drive.
     *
     * @param string $usageInDrive
     */
    public function setUsageInDrive($usageInDrive)
    {
        $this->usageInDrive = $usageInDrive;
    }
    /**
     * @return string
     */
    public function getUsageInDrive()
    {
        return $this->usageInDrive;
    }
    /**
     * The usage by trashed files in Google Drive.
     *
     * @param string $usageInDriveTrash
     */
    public function setUsageInDriveTrash($usageInDriveTrash)
    {
        $this->usageInDriveTrash = $usageInDriveTrash;
    }
    /**
     * @return string
     */
    public function getUsageInDriveTrash()
    {
        return $this->usageInDriveTrash;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AboutStorageQuota::class, 'SimpleCalendar\plugin_deps\Google_Service_Drive_AboutStorageQuota');
