<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace SimpleCalendar\plugin_deps\Google\Service\Calendar;

class EventSource extends \SimpleCalendar\plugin_deps\Google\Model
{
    /**
     * Title of the source; for example a title of a web page or an email subject.
     *
     * @var string
     */
    public $title;
    /**
     * URL of the source pointing to a resource. The URL scheme must be HTTP or
     * HTTPS.
     *
     * @var string
     */
    public $url;
    /**
     * Title of the source; for example a title of a web page or an email subject.
     *
     * @param string $title
     */
    public function setTitle($title)
    {
        $this->title = $title;
    }
    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * URL of the source pointing to a resource. The URL scheme must be HTTP or
     * HTTPS.
     *
     * @param string $url
     */
    public function setUrl($url)
    {
        $this->url = $url;
    }
    /**
     * @return string
     */
    public function getUrl()
    {
        return $this->url;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
class_alias(EventSource::class, 'SimpleCalendar\plugin_deps\Google_Service_Calendar_EventSource');
