<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace SimpleCalendar\plugin_deps\Google\Service\Calendar;

class EventAttachment extends \SimpleCalendar\plugin_deps\Google\Model
{
    /**
     * ID of the attached file. Read-only. For Google Drive files, this is the ID
     * of the corresponding Files resource entry in the Drive API.
     *
     * @var string
     */
    public $fileId;
    /**
     * URL link to the attachment. For adding Google Drive file attachments use
     * the same format as in alternateLink property of the Files resource in the
     * Drive API. Required when adding an attachment.
     *
     * @var string
     */
    public $fileUrl;
    /**
     * URL link to the attachment's icon. This field can only be modified for
     * custom third-party attachments.
     *
     * @var string
     */
    public $iconLink;
    /**
     * Internet media type (MIME type) of the attachment.
     *
     * @var string
     */
    public $mimeType;
    /**
     * Attachment title.
     *
     * @var string
     */
    public $title;
    /**
     * ID of the attached file. Read-only. For Google Drive files, this is the ID
     * of the corresponding Files resource entry in the Drive API.
     *
     * @param string $fileId
     */
    public function setFileId($fileId)
    {
        $this->fileId = $fileId;
    }
    /**
     * @return string
     */
    public function getFileId()
    {
        return $this->fileId;
    }
    /**
     * URL link to the attachment. For adding Google Drive file attachments use
     * the same format as in alternateLink property of the Files resource in the
     * Drive API. Required when adding an attachment.
     *
     * @param string $fileUrl
     */
    public function setFileUrl($fileUrl)
    {
        $this->fileUrl = $fileUrl;
    }
    /**
     * @return string
     */
    public function getFileUrl()
    {
        return $this->fileUrl;
    }
    /**
     * URL link to the attachment's icon. This field can only be modified for
     * custom third-party attachments.
     *
     * @param string $iconLink
     */
    public function setIconLink($iconLink)
    {
        $this->iconLink = $iconLink;
    }
    /**
     * @return string
     */
    public function getIconLink()
    {
        return $this->iconLink;
    }
    /**
     * Internet media type (MIME type) of the attachment.
     *
     * @param string $mimeType
     */
    public function setMimeType($mimeType)
    {
        $this->mimeType = $mimeType;
    }
    /**
     * @return string
     */
    public function getMimeType()
    {
        return $this->mimeType;
    }
    /**
     * Attachment title.
     *
     * @param string $title
     */
    public function setTitle($title)
    {
        $this->title = $title;
    }
    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
class_alias(EventAttachment::class, 'SimpleCalendar\plugin_deps\Google_Service_Calendar_EventAttachment');
