import { N as NOOP, A as extend$2, B as isString$1, C as NO, D as isSymbol, E as isBuiltInDirective, G as capitalize, H as camelize, I as EMPTY_OBJ, J as isObject$1, K as toHandlerKey, L as isArray$1, M as isOn, O as isReservedProp, P as isVoidTag, Q as isHTMLTag, R as isSVGTag, S as isMathMLTag, U as parseStringStyle, V as makeMap, W as generateCodeFrame, X as getAugmentedNamespace, Y as runtimeDom_esmBundler, Z as shared_esmBundler, $ as getDefaultExportFromCjs, d as useRouter, k as watch, o as onMounted, a0 as onUnmounted, a as openBlock, c as createElementBlock, g as createBaseVNode, b as createVNode, e as createBlock, h as withCtx, a1 as normalizeStyle, t as toDisplayString, u as unref, _ as __, f as createCommentVNode, T as Transition, l as Teleport, r as ref, a2 as nextTick, i as computed, s as reactive, w as withDirectives, v as vModelText, a3 as withKeys, n as normalizeClass, a4 as getMiGlobal, a5 as defineStore, q as getWidgetSupportForType, j as _export_sfc, a6 as vShow, F as Fragment, p as renderList, a7 as createTextVNode, a8 as renderSlot, m as withModifiers, a9 as defineComponent, aa as h, ab as onBeforeMount, ac as getCurrentInstance, x as onBeforeUnmount, ad as toRefs, ae as mergeProps, af as resolveDynamicComponent, ag as commonjsGlobal, ah as sprintf, ai as getMiGlobal$1 } from "../custom-dashboard.js";
import { u as useFeatureGate, I as Icon } from "./useSampleData-DjRjarai.js";
function formatNumber(value, decimals = 0) {
  if (Number.isNaN(parseFloat(value))) {
    return value;
  }
  if (Number.isInteger(decimals) && decimals > 0) {
    value = parseFloat(value).toFixed(decimals);
  } else {
    value = parseInt(value, 10);
  }
  if (Number.isNaN(value)) {
    return 0;
  }
  value = String(value).replace(/,/g, "");
  const parts = value.toString().split(".");
  parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, ",");
  return parts.join(".");
}
var vuedraggable_umd$1 = { exports: {} };
var vue = { exports: {} };
var vue_cjs_prod = {};
const FRAGMENT = /* @__PURE__ */ Symbol(``);
const TELEPORT = /* @__PURE__ */ Symbol(``);
const SUSPENSE = /* @__PURE__ */ Symbol(``);
const KEEP_ALIVE = /* @__PURE__ */ Symbol(``);
const BASE_TRANSITION = /* @__PURE__ */ Symbol(
  ``
);
const OPEN_BLOCK = /* @__PURE__ */ Symbol(``);
const CREATE_BLOCK = /* @__PURE__ */ Symbol(``);
const CREATE_ELEMENT_BLOCK = /* @__PURE__ */ Symbol(
  ``
);
const CREATE_VNODE = /* @__PURE__ */ Symbol(``);
const CREATE_ELEMENT_VNODE = /* @__PURE__ */ Symbol(
  ``
);
const CREATE_COMMENT = /* @__PURE__ */ Symbol(
  ``
);
const CREATE_TEXT = /* @__PURE__ */ Symbol(
  ``
);
const CREATE_STATIC = /* @__PURE__ */ Symbol(
  ``
);
const RESOLVE_COMPONENT = /* @__PURE__ */ Symbol(
  ``
);
const RESOLVE_DYNAMIC_COMPONENT = /* @__PURE__ */ Symbol(
  ``
);
const RESOLVE_DIRECTIVE = /* @__PURE__ */ Symbol(
  ``
);
const RESOLVE_FILTER = /* @__PURE__ */ Symbol(
  ``
);
const WITH_DIRECTIVES = /* @__PURE__ */ Symbol(
  ``
);
const RENDER_LIST = /* @__PURE__ */ Symbol(``);
const RENDER_SLOT = /* @__PURE__ */ Symbol(``);
const CREATE_SLOTS = /* @__PURE__ */ Symbol(``);
const TO_DISPLAY_STRING = /* @__PURE__ */ Symbol(
  ``
);
const MERGE_PROPS = /* @__PURE__ */ Symbol(``);
const NORMALIZE_CLASS = /* @__PURE__ */ Symbol(
  ``
);
const NORMALIZE_STYLE = /* @__PURE__ */ Symbol(
  ``
);
const NORMALIZE_PROPS = /* @__PURE__ */ Symbol(
  ``
);
const GUARD_REACTIVE_PROPS = /* @__PURE__ */ Symbol(
  ``
);
const TO_HANDLERS = /* @__PURE__ */ Symbol(``);
const CAMELIZE = /* @__PURE__ */ Symbol(``);
const CAPITALIZE = /* @__PURE__ */ Symbol(``);
const TO_HANDLER_KEY = /* @__PURE__ */ Symbol(
  ``
);
const SET_BLOCK_TRACKING = /* @__PURE__ */ Symbol(
  ``
);
const PUSH_SCOPE_ID = /* @__PURE__ */ Symbol(``);
const POP_SCOPE_ID = /* @__PURE__ */ Symbol(``);
const WITH_CTX = /* @__PURE__ */ Symbol(``);
const UNREF = /* @__PURE__ */ Symbol(``);
const IS_REF = /* @__PURE__ */ Symbol(``);
const WITH_MEMO = /* @__PURE__ */ Symbol(``);
const IS_MEMO_SAME = /* @__PURE__ */ Symbol(``);
const helperNameMap = {
  [FRAGMENT]: `Fragment`,
  [TELEPORT]: `Teleport`,
  [SUSPENSE]: `Suspense`,
  [KEEP_ALIVE]: `KeepAlive`,
  [BASE_TRANSITION]: `BaseTransition`,
  [OPEN_BLOCK]: `openBlock`,
  [CREATE_BLOCK]: `createBlock`,
  [CREATE_ELEMENT_BLOCK]: `createElementBlock`,
  [CREATE_VNODE]: `createVNode`,
  [CREATE_ELEMENT_VNODE]: `createElementVNode`,
  [CREATE_COMMENT]: `createCommentVNode`,
  [CREATE_TEXT]: `createTextVNode`,
  [CREATE_STATIC]: `createStaticVNode`,
  [RESOLVE_COMPONENT]: `resolveComponent`,
  [RESOLVE_DYNAMIC_COMPONENT]: `resolveDynamicComponent`,
  [RESOLVE_DIRECTIVE]: `resolveDirective`,
  [RESOLVE_FILTER]: `resolveFilter`,
  [WITH_DIRECTIVES]: `withDirectives`,
  [RENDER_LIST]: `renderList`,
  [RENDER_SLOT]: `renderSlot`,
  [CREATE_SLOTS]: `createSlots`,
  [TO_DISPLAY_STRING]: `toDisplayString`,
  [MERGE_PROPS]: `mergeProps`,
  [NORMALIZE_CLASS]: `normalizeClass`,
  [NORMALIZE_STYLE]: `normalizeStyle`,
  [NORMALIZE_PROPS]: `normalizeProps`,
  [GUARD_REACTIVE_PROPS]: `guardReactiveProps`,
  [TO_HANDLERS]: `toHandlers`,
  [CAMELIZE]: `camelize`,
  [CAPITALIZE]: `capitalize`,
  [TO_HANDLER_KEY]: `toHandlerKey`,
  [SET_BLOCK_TRACKING]: `setBlockTracking`,
  [PUSH_SCOPE_ID]: `pushScopeId`,
  [POP_SCOPE_ID]: `popScopeId`,
  [WITH_CTX]: `withCtx`,
  [UNREF]: `unref`,
  [IS_REF]: `isRef`,
  [WITH_MEMO]: `withMemo`,
  [IS_MEMO_SAME]: `isMemoSame`
};
function registerRuntimeHelpers(helpers) {
  Object.getOwnPropertySymbols(helpers).forEach((s) => {
    helperNameMap[s] = helpers[s];
  });
}
const Namespaces = {
  "HTML": 0,
  "0": "HTML",
  "SVG": 1,
  "1": "SVG",
  "MATH_ML": 2,
  "2": "MATH_ML"
};
const NodeTypes = {
  "ROOT": 0,
  "0": "ROOT",
  "ELEMENT": 1,
  "1": "ELEMENT",
  "TEXT": 2,
  "2": "TEXT",
  "COMMENT": 3,
  "3": "COMMENT",
  "SIMPLE_EXPRESSION": 4,
  "4": "SIMPLE_EXPRESSION",
  "INTERPOLATION": 5,
  "5": "INTERPOLATION",
  "ATTRIBUTE": 6,
  "6": "ATTRIBUTE",
  "DIRECTIVE": 7,
  "7": "DIRECTIVE",
  "COMPOUND_EXPRESSION": 8,
  "8": "COMPOUND_EXPRESSION",
  "IF": 9,
  "9": "IF",
  "IF_BRANCH": 10,
  "10": "IF_BRANCH",
  "FOR": 11,
  "11": "FOR",
  "TEXT_CALL": 12,
  "12": "TEXT_CALL",
  "VNODE_CALL": 13,
  "13": "VNODE_CALL",
  "JS_CALL_EXPRESSION": 14,
  "14": "JS_CALL_EXPRESSION",
  "JS_OBJECT_EXPRESSION": 15,
  "15": "JS_OBJECT_EXPRESSION",
  "JS_PROPERTY": 16,
  "16": "JS_PROPERTY",
  "JS_ARRAY_EXPRESSION": 17,
  "17": "JS_ARRAY_EXPRESSION",
  "JS_FUNCTION_EXPRESSION": 18,
  "18": "JS_FUNCTION_EXPRESSION",
  "JS_CONDITIONAL_EXPRESSION": 19,
  "19": "JS_CONDITIONAL_EXPRESSION",
  "JS_CACHE_EXPRESSION": 20,
  "20": "JS_CACHE_EXPRESSION",
  "JS_BLOCK_STATEMENT": 21,
  "21": "JS_BLOCK_STATEMENT",
  "JS_TEMPLATE_LITERAL": 22,
  "22": "JS_TEMPLATE_LITERAL",
  "JS_IF_STATEMENT": 23,
  "23": "JS_IF_STATEMENT",
  "JS_ASSIGNMENT_EXPRESSION": 24,
  "24": "JS_ASSIGNMENT_EXPRESSION",
  "JS_SEQUENCE_EXPRESSION": 25,
  "25": "JS_SEQUENCE_EXPRESSION",
  "JS_RETURN_STATEMENT": 26,
  "26": "JS_RETURN_STATEMENT"
};
const ElementTypes = {
  "ELEMENT": 0,
  "0": "ELEMENT",
  "COMPONENT": 1,
  "1": "COMPONENT",
  "SLOT": 2,
  "2": "SLOT",
  "TEMPLATE": 3,
  "3": "TEMPLATE"
};
const ConstantTypes = {
  "NOT_CONSTANT": 0,
  "0": "NOT_CONSTANT",
  "CAN_SKIP_PATCH": 1,
  "1": "CAN_SKIP_PATCH",
  "CAN_CACHE": 2,
  "2": "CAN_CACHE",
  "CAN_STRINGIFY": 3,
  "3": "CAN_STRINGIFY"
};
const locStub = {
  start: { line: 1, column: 1, offset: 0 },
  end: { line: 1, column: 1, offset: 0 },
  source: ""
};
function createRoot(children, source = "") {
  return {
    type: 0,
    source,
    children,
    helpers: /* @__PURE__ */ new Set(),
    components: [],
    directives: [],
    hoists: [],
    imports: [],
    cached: [],
    temps: 0,
    codegenNode: void 0,
    loc: locStub
  };
}
function createVNodeCall(context, tag, props, children, patchFlag, dynamicProps, directives, isBlock = false, disableTracking = false, isComponent2 = false, loc = locStub) {
  if (context) {
    if (isBlock) {
      context.helper(OPEN_BLOCK);
      context.helper(getVNodeBlockHelper(context.inSSR, isComponent2));
    } else {
      context.helper(getVNodeHelper(context.inSSR, isComponent2));
    }
    if (directives) {
      context.helper(WITH_DIRECTIVES);
    }
  }
  return {
    type: 13,
    tag,
    props,
    children,
    patchFlag,
    dynamicProps,
    directives,
    isBlock,
    disableTracking,
    isComponent: isComponent2,
    loc
  };
}
function createArrayExpression(elements, loc = locStub) {
  return {
    type: 17,
    loc,
    elements
  };
}
function createObjectExpression(properties, loc = locStub) {
  return {
    type: 15,
    loc,
    properties
  };
}
function createObjectProperty(key, value) {
  return {
    type: 16,
    loc: locStub,
    key: isString$1(key) ? createSimpleExpression(key, true) : key,
    value
  };
}
function createSimpleExpression(content, isStatic = false, loc = locStub, constType = 0) {
  return {
    type: 4,
    loc,
    content,
    isStatic,
    constType: isStatic ? 3 : constType
  };
}
function createInterpolation(content, loc) {
  return {
    type: 5,
    loc,
    content: isString$1(content) ? createSimpleExpression(content, false, loc) : content
  };
}
function createCompoundExpression(children, loc = locStub) {
  return {
    type: 8,
    loc,
    children
  };
}
function createCallExpression(callee, args = [], loc = locStub) {
  return {
    type: 14,
    loc,
    callee,
    arguments: args
  };
}
function createFunctionExpression(params, returns = void 0, newline = false, isSlot = false, loc = locStub) {
  return {
    type: 18,
    params,
    returns,
    newline,
    isSlot,
    loc
  };
}
function createConditionalExpression(test, consequent, alternate, newline = true) {
  return {
    type: 19,
    test,
    consequent,
    alternate,
    newline,
    loc: locStub
  };
}
function createCacheExpression(index2, value, needPauseTracking = false, inVOnce = false) {
  return {
    type: 20,
    index: index2,
    value,
    needPauseTracking,
    inVOnce,
    needArraySpread: false,
    loc: locStub
  };
}
function createBlockStatement(body) {
  return {
    type: 21,
    body,
    loc: locStub
  };
}
function createTemplateLiteral(elements) {
  return {
    type: 22,
    elements,
    loc: locStub
  };
}
function createIfStatement(test, consequent, alternate) {
  return {
    type: 23,
    test,
    consequent,
    alternate,
    loc: locStub
  };
}
function createAssignmentExpression(left, right) {
  return {
    type: 24,
    left,
    right,
    loc: locStub
  };
}
function createSequenceExpression(expressions) {
  return {
    type: 25,
    expressions,
    loc: locStub
  };
}
function createReturnStatement(returns) {
  return {
    type: 26,
    returns,
    loc: locStub
  };
}
function getVNodeHelper(ssr, isComponent2) {
  return ssr || isComponent2 ? CREATE_VNODE : CREATE_ELEMENT_VNODE;
}
function getVNodeBlockHelper(ssr, isComponent2) {
  return ssr || isComponent2 ? CREATE_BLOCK : CREATE_ELEMENT_BLOCK;
}
function convertToBlock(node, { helper, removeHelper, inSSR }) {
  if (!node.isBlock) {
    node.isBlock = true;
    removeHelper(getVNodeHelper(inSSR, node.isComponent));
    helper(OPEN_BLOCK);
    helper(getVNodeBlockHelper(inSSR, node.isComponent));
  }
}
const defaultDelimitersOpen = new Uint8Array([123, 123]);
const defaultDelimitersClose = new Uint8Array([125, 125]);
function isTagStartChar(c) {
  return c >= 97 && c <= 122 || c >= 65 && c <= 90;
}
function isWhitespace(c) {
  return c === 32 || c === 10 || c === 9 || c === 12 || c === 13;
}
function isEndOfTagSection(c) {
  return c === 47 || c === 62 || isWhitespace(c);
}
function toCharCodes(str) {
  const ret = new Uint8Array(str.length);
  for (let i = 0; i < str.length; i++) {
    ret[i] = str.charCodeAt(i);
  }
  return ret;
}
const Sequences = {
  Cdata: new Uint8Array([67, 68, 65, 84, 65, 91]),
  // CDATA[
  CdataEnd: new Uint8Array([93, 93, 62]),
  // ]]>
  CommentEnd: new Uint8Array([45, 45, 62]),
  // `-->`
  ScriptEnd: new Uint8Array([60, 47, 115, 99, 114, 105, 112, 116]),
  // `<\/script`
  StyleEnd: new Uint8Array([60, 47, 115, 116, 121, 108, 101]),
  // `</style`
  TitleEnd: new Uint8Array([60, 47, 116, 105, 116, 108, 101]),
  // `</title`
  TextareaEnd: new Uint8Array([
    60,
    47,
    116,
    101,
    120,
    116,
    97,
    114,
    101,
    97
  ])
  // `</textarea
};
class Tokenizer {
  constructor(stack2, cbs) {
    this.stack = stack2;
    this.cbs = cbs;
    this.state = 1;
    this.buffer = "";
    this.sectionStart = 0;
    this.index = 0;
    this.entityStart = 0;
    this.baseState = 1;
    this.inRCDATA = false;
    this.inXML = false;
    this.inVPre = false;
    this.newlines = [];
    this.mode = 0;
    this.delimiterOpen = defaultDelimitersOpen;
    this.delimiterClose = defaultDelimitersClose;
    this.delimiterIndex = -1;
    this.currentSequence = void 0;
    this.sequenceIndex = 0;
  }
  get inSFCRoot() {
    return this.mode === 2 && this.stack.length === 0;
  }
  reset() {
    this.state = 1;
    this.mode = 0;
    this.buffer = "";
    this.sectionStart = 0;
    this.index = 0;
    this.baseState = 1;
    this.inRCDATA = false;
    this.currentSequence = void 0;
    this.newlines.length = 0;
    this.delimiterOpen = defaultDelimitersOpen;
    this.delimiterClose = defaultDelimitersClose;
  }
  /**
   * Generate Position object with line / column information using recorded
   * newline positions. We know the index is always going to be an already
   * processed index, so all the newlines up to this index should have been
   * recorded.
   */
  getPos(index2) {
    let line = 1;
    let column = index2 + 1;
    const length = this.newlines.length;
    let j = -1;
    if (length > 100) {
      let l = -1;
      let r = length;
      while (l + 1 < r) {
        const m2 = l + r >>> 1;
        this.newlines[m2] < index2 ? l = m2 : r = m2;
      }
      j = l;
    } else {
      for (let i = length - 1; i >= 0; i--) {
        if (index2 > this.newlines[i]) {
          j = i;
          break;
        }
      }
    }
    if (j >= 0) {
      line = j + 2;
      column = index2 - this.newlines[j];
    }
    return {
      column,
      line,
      offset: index2
    };
  }
  peek() {
    return this.buffer.charCodeAt(this.index + 1);
  }
  stateText(c) {
    if (c === 60) {
      if (this.index > this.sectionStart) {
        this.cbs.ontext(this.sectionStart, this.index);
      }
      this.state = 5;
      this.sectionStart = this.index;
    } else if (!this.inVPre && c === this.delimiterOpen[0]) {
      this.state = 2;
      this.delimiterIndex = 0;
      this.stateInterpolationOpen(c);
    }
  }
  stateInterpolationOpen(c) {
    if (c === this.delimiterOpen[this.delimiterIndex]) {
      if (this.delimiterIndex === this.delimiterOpen.length - 1) {
        const start = this.index + 1 - this.delimiterOpen.length;
        if (start > this.sectionStart) {
          this.cbs.ontext(this.sectionStart, start);
        }
        this.state = 3;
        this.sectionStart = start;
      } else {
        this.delimiterIndex++;
      }
    } else if (this.inRCDATA) {
      this.state = 32;
      this.stateInRCDATA(c);
    } else {
      this.state = 1;
      this.stateText(c);
    }
  }
  stateInterpolation(c) {
    if (c === this.delimiterClose[0]) {
      this.state = 4;
      this.delimiterIndex = 0;
      this.stateInterpolationClose(c);
    }
  }
  stateInterpolationClose(c) {
    if (c === this.delimiterClose[this.delimiterIndex]) {
      if (this.delimiterIndex === this.delimiterClose.length - 1) {
        this.cbs.oninterpolation(this.sectionStart, this.index + 1);
        if (this.inRCDATA) {
          this.state = 32;
        } else {
          this.state = 1;
        }
        this.sectionStart = this.index + 1;
      } else {
        this.delimiterIndex++;
      }
    } else {
      this.state = 3;
      this.stateInterpolation(c);
    }
  }
  stateSpecialStartSequence(c) {
    const isEnd = this.sequenceIndex === this.currentSequence.length;
    const isMatch = isEnd ? (
      // If we are at the end of the sequence, make sure the tag name has ended
      isEndOfTagSection(c)
    ) : (
      // Otherwise, do a case-insensitive comparison
      (c | 32) === this.currentSequence[this.sequenceIndex]
    );
    if (!isMatch) {
      this.inRCDATA = false;
    } else if (!isEnd) {
      this.sequenceIndex++;
      return;
    }
    this.sequenceIndex = 0;
    this.state = 6;
    this.stateInTagName(c);
  }
  /** Look for an end tag. For <title> and <textarea>, also decode entities. */
  stateInRCDATA(c) {
    if (this.sequenceIndex === this.currentSequence.length) {
      if (c === 62 || isWhitespace(c)) {
        const endOfText = this.index - this.currentSequence.length;
        if (this.sectionStart < endOfText) {
          const actualIndex = this.index;
          this.index = endOfText;
          this.cbs.ontext(this.sectionStart, endOfText);
          this.index = actualIndex;
        }
        this.sectionStart = endOfText + 2;
        this.stateInClosingTagName(c);
        this.inRCDATA = false;
        return;
      }
      this.sequenceIndex = 0;
    }
    if ((c | 32) === this.currentSequence[this.sequenceIndex]) {
      this.sequenceIndex += 1;
    } else if (this.sequenceIndex === 0) {
      if (this.currentSequence === Sequences.TitleEnd || this.currentSequence === Sequences.TextareaEnd && !this.inSFCRoot) {
        if (!this.inVPre && c === this.delimiterOpen[0]) {
          this.state = 2;
          this.delimiterIndex = 0;
          this.stateInterpolationOpen(c);
        }
      } else if (this.fastForwardTo(60)) {
        this.sequenceIndex = 1;
      }
    } else {
      this.sequenceIndex = Number(c === 60);
    }
  }
  stateCDATASequence(c) {
    if (c === Sequences.Cdata[this.sequenceIndex]) {
      if (++this.sequenceIndex === Sequences.Cdata.length) {
        this.state = 28;
        this.currentSequence = Sequences.CdataEnd;
        this.sequenceIndex = 0;
        this.sectionStart = this.index + 1;
      }
    } else {
      this.sequenceIndex = 0;
      this.state = 23;
      this.stateInDeclaration(c);
    }
  }
  /**
   * When we wait for one specific character, we can speed things up
   * by skipping through the buffer until we find it.
   *
   * @returns Whether the character was found.
   */
  fastForwardTo(c) {
    while (++this.index < this.buffer.length) {
      const cc = this.buffer.charCodeAt(this.index);
      if (cc === 10) {
        this.newlines.push(this.index);
      }
      if (cc === c) {
        return true;
      }
    }
    this.index = this.buffer.length - 1;
    return false;
  }
  /**
   * Comments and CDATA end with `-->` and `]]>`.
   *
   * Their common qualities are:
   * - Their end sequences have a distinct character they start with.
   * - That character is then repeated, so we have to check multiple repeats.
   * - All characters but the start character of the sequence can be skipped.
   */
  stateInCommentLike(c) {
    if (c === this.currentSequence[this.sequenceIndex]) {
      if (++this.sequenceIndex === this.currentSequence.length) {
        if (this.currentSequence === Sequences.CdataEnd) {
          this.cbs.oncdata(this.sectionStart, this.index - 2);
        } else {
          this.cbs.oncomment(this.sectionStart, this.index - 2);
        }
        this.sequenceIndex = 0;
        this.sectionStart = this.index + 1;
        this.state = 1;
      }
    } else if (this.sequenceIndex === 0) {
      if (this.fastForwardTo(this.currentSequence[0])) {
        this.sequenceIndex = 1;
      }
    } else if (c !== this.currentSequence[this.sequenceIndex - 1]) {
      this.sequenceIndex = 0;
    }
  }
  startSpecial(sequence, offset2) {
    this.enterRCDATA(sequence, offset2);
    this.state = 31;
  }
  enterRCDATA(sequence, offset2) {
    this.inRCDATA = true;
    this.currentSequence = sequence;
    this.sequenceIndex = offset2;
  }
  stateBeforeTagName(c) {
    if (c === 33) {
      this.state = 22;
      this.sectionStart = this.index + 1;
    } else if (c === 63) {
      this.state = 24;
      this.sectionStart = this.index + 1;
    } else if (isTagStartChar(c)) {
      this.sectionStart = this.index;
      if (this.mode === 0) {
        this.state = 6;
      } else if (this.inSFCRoot) {
        this.state = 34;
      } else if (!this.inXML) {
        if (c === 116) {
          this.state = 30;
        } else {
          this.state = c === 115 ? 29 : 6;
        }
      } else {
        this.state = 6;
      }
    } else if (c === 47) {
      this.state = 8;
    } else {
      this.state = 1;
      this.stateText(c);
    }
  }
  stateInTagName(c) {
    if (isEndOfTagSection(c)) {
      this.handleTagName(c);
    }
  }
  stateInSFCRootTagName(c) {
    if (isEndOfTagSection(c)) {
      const tag = this.buffer.slice(this.sectionStart, this.index);
      if (tag !== "template") {
        this.enterRCDATA(toCharCodes(`</` + tag), 0);
      }
      this.handleTagName(c);
    }
  }
  handleTagName(c) {
    this.cbs.onopentagname(this.sectionStart, this.index);
    this.sectionStart = -1;
    this.state = 11;
    this.stateBeforeAttrName(c);
  }
  stateBeforeClosingTagName(c) {
    if (isWhitespace(c)) ;
    else if (c === 62) {
      this.state = 1;
      this.sectionStart = this.index + 1;
    } else {
      this.state = isTagStartChar(c) ? 9 : 27;
      this.sectionStart = this.index;
    }
  }
  stateInClosingTagName(c) {
    if (c === 62 || isWhitespace(c)) {
      this.cbs.onclosetag(this.sectionStart, this.index);
      this.sectionStart = -1;
      this.state = 10;
      this.stateAfterClosingTagName(c);
    }
  }
  stateAfterClosingTagName(c) {
    if (c === 62) {
      this.state = 1;
      this.sectionStart = this.index + 1;
    }
  }
  stateBeforeAttrName(c) {
    if (c === 62) {
      this.cbs.onopentagend(this.index);
      if (this.inRCDATA) {
        this.state = 32;
      } else {
        this.state = 1;
      }
      this.sectionStart = this.index + 1;
    } else if (c === 47) {
      this.state = 7;
    } else if (c === 60 && this.peek() === 47) {
      this.cbs.onopentagend(this.index);
      this.state = 5;
      this.sectionStart = this.index;
    } else if (!isWhitespace(c)) {
      this.handleAttrStart(c);
    }
  }
  handleAttrStart(c) {
    if (c === 118 && this.peek() === 45) {
      this.state = 13;
      this.sectionStart = this.index;
    } else if (c === 46 || c === 58 || c === 64 || c === 35) {
      this.cbs.ondirname(this.index, this.index + 1);
      this.state = 14;
      this.sectionStart = this.index + 1;
    } else {
      this.state = 12;
      this.sectionStart = this.index;
    }
  }
  stateInSelfClosingTag(c) {
    if (c === 62) {
      this.cbs.onselfclosingtag(this.index);
      this.state = 1;
      this.sectionStart = this.index + 1;
      this.inRCDATA = false;
    } else if (!isWhitespace(c)) {
      this.state = 11;
      this.stateBeforeAttrName(c);
    }
  }
  stateInAttrName(c) {
    if (c === 61 || isEndOfTagSection(c)) {
      this.cbs.onattribname(this.sectionStart, this.index);
      this.handleAttrNameEnd(c);
    }
  }
  stateInDirName(c) {
    if (c === 61 || isEndOfTagSection(c)) {
      this.cbs.ondirname(this.sectionStart, this.index);
      this.handleAttrNameEnd(c);
    } else if (c === 58) {
      this.cbs.ondirname(this.sectionStart, this.index);
      this.state = 14;
      this.sectionStart = this.index + 1;
    } else if (c === 46) {
      this.cbs.ondirname(this.sectionStart, this.index);
      this.state = 16;
      this.sectionStart = this.index + 1;
    }
  }
  stateInDirArg(c) {
    if (c === 61 || isEndOfTagSection(c)) {
      this.cbs.ondirarg(this.sectionStart, this.index);
      this.handleAttrNameEnd(c);
    } else if (c === 91) {
      this.state = 15;
    } else if (c === 46) {
      this.cbs.ondirarg(this.sectionStart, this.index);
      this.state = 16;
      this.sectionStart = this.index + 1;
    }
  }
  stateInDynamicDirArg(c) {
    if (c === 93) {
      this.state = 14;
    } else if (c === 61 || isEndOfTagSection(c)) {
      this.cbs.ondirarg(this.sectionStart, this.index + 1);
      this.handleAttrNameEnd(c);
    }
  }
  stateInDirModifier(c) {
    if (c === 61 || isEndOfTagSection(c)) {
      this.cbs.ondirmodifier(this.sectionStart, this.index);
      this.handleAttrNameEnd(c);
    } else if (c === 46) {
      this.cbs.ondirmodifier(this.sectionStart, this.index);
      this.sectionStart = this.index + 1;
    }
  }
  handleAttrNameEnd(c) {
    this.sectionStart = this.index;
    this.state = 17;
    this.cbs.onattribnameend(this.index);
    this.stateAfterAttrName(c);
  }
  stateAfterAttrName(c) {
    if (c === 61) {
      this.state = 18;
    } else if (c === 47 || c === 62) {
      this.cbs.onattribend(0, this.sectionStart);
      this.sectionStart = -1;
      this.state = 11;
      this.stateBeforeAttrName(c);
    } else if (!isWhitespace(c)) {
      this.cbs.onattribend(0, this.sectionStart);
      this.handleAttrStart(c);
    }
  }
  stateBeforeAttrValue(c) {
    if (c === 34) {
      this.state = 19;
      this.sectionStart = this.index + 1;
    } else if (c === 39) {
      this.state = 20;
      this.sectionStart = this.index + 1;
    } else if (!isWhitespace(c)) {
      this.sectionStart = this.index;
      this.state = 21;
      this.stateInAttrValueNoQuotes(c);
    }
  }
  handleInAttrValue(c, quote) {
    if (c === quote || this.fastForwardTo(quote)) {
      this.cbs.onattribdata(this.sectionStart, this.index);
      this.sectionStart = -1;
      this.cbs.onattribend(
        quote === 34 ? 3 : 2,
        this.index + 1
      );
      this.state = 11;
    }
  }
  stateInAttrValueDoubleQuotes(c) {
    this.handleInAttrValue(c, 34);
  }
  stateInAttrValueSingleQuotes(c) {
    this.handleInAttrValue(c, 39);
  }
  stateInAttrValueNoQuotes(c) {
    if (isWhitespace(c) || c === 62) {
      this.cbs.onattribdata(this.sectionStart, this.index);
      this.sectionStart = -1;
      this.cbs.onattribend(1, this.index);
      this.state = 11;
      this.stateBeforeAttrName(c);
    } else if (c === 39 || c === 60 || c === 61 || c === 96) {
      this.cbs.onerr(
        18,
        this.index
      );
    } else ;
  }
  stateBeforeDeclaration(c) {
    if (c === 91) {
      this.state = 26;
      this.sequenceIndex = 0;
    } else {
      this.state = c === 45 ? 25 : 23;
    }
  }
  stateInDeclaration(c) {
    if (c === 62 || this.fastForwardTo(62)) {
      this.state = 1;
      this.sectionStart = this.index + 1;
    }
  }
  stateInProcessingInstruction(c) {
    if (c === 62 || this.fastForwardTo(62)) {
      this.cbs.onprocessinginstruction(this.sectionStart, this.index);
      this.state = 1;
      this.sectionStart = this.index + 1;
    }
  }
  stateBeforeComment(c) {
    if (c === 45) {
      this.state = 28;
      this.currentSequence = Sequences.CommentEnd;
      this.sequenceIndex = 2;
      this.sectionStart = this.index + 1;
    } else {
      this.state = 23;
    }
  }
  stateInSpecialComment(c) {
    if (c === 62 || this.fastForwardTo(62)) {
      this.cbs.oncomment(this.sectionStart, this.index);
      this.state = 1;
      this.sectionStart = this.index + 1;
    }
  }
  stateBeforeSpecialS(c) {
    if (c === Sequences.ScriptEnd[3]) {
      this.startSpecial(Sequences.ScriptEnd, 4);
    } else if (c === Sequences.StyleEnd[3]) {
      this.startSpecial(Sequences.StyleEnd, 4);
    } else {
      this.state = 6;
      this.stateInTagName(c);
    }
  }
  stateBeforeSpecialT(c) {
    if (c === Sequences.TitleEnd[3]) {
      this.startSpecial(Sequences.TitleEnd, 4);
    } else if (c === Sequences.TextareaEnd[3]) {
      this.startSpecial(Sequences.TextareaEnd, 4);
    } else {
      this.state = 6;
      this.stateInTagName(c);
    }
  }
  startEntity() {
  }
  stateInEntity() {
  }
  /**
   * Iterates through the buffer, calling the function corresponding to the current state.
   *
   * States that are more likely to be hit are higher up, as a performance improvement.
   */
  parse(input) {
    this.buffer = input;
    while (this.index < this.buffer.length) {
      const c = this.buffer.charCodeAt(this.index);
      if (c === 10 && this.state !== 33) {
        this.newlines.push(this.index);
      }
      switch (this.state) {
        case 1: {
          this.stateText(c);
          break;
        }
        case 2: {
          this.stateInterpolationOpen(c);
          break;
        }
        case 3: {
          this.stateInterpolation(c);
          break;
        }
        case 4: {
          this.stateInterpolationClose(c);
          break;
        }
        case 31: {
          this.stateSpecialStartSequence(c);
          break;
        }
        case 32: {
          this.stateInRCDATA(c);
          break;
        }
        case 26: {
          this.stateCDATASequence(c);
          break;
        }
        case 19: {
          this.stateInAttrValueDoubleQuotes(c);
          break;
        }
        case 12: {
          this.stateInAttrName(c);
          break;
        }
        case 13: {
          this.stateInDirName(c);
          break;
        }
        case 14: {
          this.stateInDirArg(c);
          break;
        }
        case 15: {
          this.stateInDynamicDirArg(c);
          break;
        }
        case 16: {
          this.stateInDirModifier(c);
          break;
        }
        case 28: {
          this.stateInCommentLike(c);
          break;
        }
        case 27: {
          this.stateInSpecialComment(c);
          break;
        }
        case 11: {
          this.stateBeforeAttrName(c);
          break;
        }
        case 6: {
          this.stateInTagName(c);
          break;
        }
        case 34: {
          this.stateInSFCRootTagName(c);
          break;
        }
        case 9: {
          this.stateInClosingTagName(c);
          break;
        }
        case 5: {
          this.stateBeforeTagName(c);
          break;
        }
        case 17: {
          this.stateAfterAttrName(c);
          break;
        }
        case 20: {
          this.stateInAttrValueSingleQuotes(c);
          break;
        }
        case 18: {
          this.stateBeforeAttrValue(c);
          break;
        }
        case 8: {
          this.stateBeforeClosingTagName(c);
          break;
        }
        case 10: {
          this.stateAfterClosingTagName(c);
          break;
        }
        case 29: {
          this.stateBeforeSpecialS(c);
          break;
        }
        case 30: {
          this.stateBeforeSpecialT(c);
          break;
        }
        case 21: {
          this.stateInAttrValueNoQuotes(c);
          break;
        }
        case 7: {
          this.stateInSelfClosingTag(c);
          break;
        }
        case 23: {
          this.stateInDeclaration(c);
          break;
        }
        case 22: {
          this.stateBeforeDeclaration(c);
          break;
        }
        case 25: {
          this.stateBeforeComment(c);
          break;
        }
        case 24: {
          this.stateInProcessingInstruction(c);
          break;
        }
        case 33: {
          this.stateInEntity();
          break;
        }
      }
      this.index++;
    }
    this.cleanup();
    this.finish();
  }
  /**
   * Remove data that has already been consumed from the buffer.
   */
  cleanup() {
    if (this.sectionStart !== this.index) {
      if (this.state === 1 || this.state === 32 && this.sequenceIndex === 0) {
        this.cbs.ontext(this.sectionStart, this.index);
        this.sectionStart = this.index;
      } else if (this.state === 19 || this.state === 20 || this.state === 21) {
        this.cbs.onattribdata(this.sectionStart, this.index);
        this.sectionStart = this.index;
      }
    }
  }
  finish() {
    this.handleTrailingData();
    this.cbs.onend();
  }
  /** Handle any trailing data. */
  handleTrailingData() {
    const endIndex = this.buffer.length;
    if (this.sectionStart >= endIndex) {
      return;
    }
    if (this.state === 28) {
      if (this.currentSequence === Sequences.CdataEnd) {
        this.cbs.oncdata(this.sectionStart, endIndex);
      } else {
        this.cbs.oncomment(this.sectionStart, endIndex);
      }
    } else if (this.state === 6 || this.state === 11 || this.state === 18 || this.state === 17 || this.state === 12 || this.state === 13 || this.state === 14 || this.state === 15 || this.state === 16 || this.state === 20 || this.state === 19 || this.state === 21 || this.state === 9) ;
    else {
      this.cbs.ontext(this.sectionStart, endIndex);
    }
  }
  emitCodePoint(cp, consumed) {
  }
}
const CompilerDeprecationTypes = {
  "COMPILER_IS_ON_ELEMENT": "COMPILER_IS_ON_ELEMENT",
  "COMPILER_V_BIND_SYNC": "COMPILER_V_BIND_SYNC",
  "COMPILER_V_BIND_OBJECT_ORDER": "COMPILER_V_BIND_OBJECT_ORDER",
  "COMPILER_V_ON_NATIVE": "COMPILER_V_ON_NATIVE",
  "COMPILER_V_IF_V_FOR_PRECEDENCE": "COMPILER_V_IF_V_FOR_PRECEDENCE",
  "COMPILER_NATIVE_TEMPLATE": "COMPILER_NATIVE_TEMPLATE",
  "COMPILER_INLINE_TEMPLATE": "COMPILER_INLINE_TEMPLATE",
  "COMPILER_FILTERS": "COMPILER_FILTERS"
};
const deprecationData = {
  ["COMPILER_IS_ON_ELEMENT"]: {
    message: `Platform-native elements with "is" prop will no longer be treated as components in Vue 3 unless the "is" value is explicitly prefixed with "vue:".`,
    link: `https://v3-migration.vuejs.org/breaking-changes/custom-elements-interop.html`
  },
  ["COMPILER_V_BIND_SYNC"]: {
    message: (key) => `.sync modifier for v-bind has been removed. Use v-model with argument instead. \`v-bind:${key}.sync\` should be changed to \`v-model:${key}\`.`,
    link: `https://v3-migration.vuejs.org/breaking-changes/v-model.html`
  },
  ["COMPILER_V_BIND_OBJECT_ORDER"]: {
    message: `v-bind="obj" usage is now order sensitive and behaves like JavaScript object spread: it will now overwrite an existing non-mergeable attribute that appears before v-bind in the case of conflict. To retain 2.x behavior, move v-bind to make it the first attribute. You can also suppress this warning if the usage is intended.`,
    link: `https://v3-migration.vuejs.org/breaking-changes/v-bind.html`
  },
  ["COMPILER_V_ON_NATIVE"]: {
    message: `.native modifier for v-on has been removed as is no longer necessary.`,
    link: `https://v3-migration.vuejs.org/breaking-changes/v-on-native-modifier-removed.html`
  },
  ["COMPILER_V_IF_V_FOR_PRECEDENCE"]: {
    message: `v-if / v-for precedence when used on the same element has changed in Vue 3: v-if now takes higher precedence and will no longer have access to v-for scope variables. It is best to avoid the ambiguity with <template> tags or use a computed property that filters v-for data source.`,
    link: `https://v3-migration.vuejs.org/breaking-changes/v-if-v-for.html`
  },
  ["COMPILER_NATIVE_TEMPLATE"]: {
    message: `<template> with no special directives will render as a native template element instead of its inner content in Vue 3.`
  },
  ["COMPILER_INLINE_TEMPLATE"]: {
    message: `"inline-template" has been removed in Vue 3.`,
    link: `https://v3-migration.vuejs.org/breaking-changes/inline-template-attribute.html`
  },
  ["COMPILER_FILTERS"]: {
    message: `filters have been removed in Vue 3. The "|" symbol will be treated as native JavaScript bitwise OR operator. Use method calls or computed properties instead.`,
    link: `https://v3-migration.vuejs.org/breaking-changes/filters.html`
  }
};
function getCompatValue(key, { compatConfig }) {
  const value = compatConfig && compatConfig[key];
  if (key === "MODE") {
    return value || 3;
  } else {
    return value;
  }
}
function isCompatEnabled(key, context) {
  const mode = getCompatValue("MODE", context);
  const value = getCompatValue(key, context);
  return mode === 3 ? value === true : value !== false;
}
function checkCompatEnabled(key, context, loc, ...args) {
  const enabled = isCompatEnabled(key, context);
  return enabled;
}
function warnDeprecation(key, context, loc, ...args) {
  const val = getCompatValue(key, context);
  if (val === "suppress-warning") {
    return;
  }
  const { message, link } = deprecationData[key];
  const msg = `(deprecation ${key}) ${typeof message === "function" ? message(...args) : message}${link ? `
  Details: ${link}` : ``}`;
  const err = new SyntaxError(msg);
  err.code = key;
  if (loc) err.loc = loc;
  context.onWarn(err);
}
function defaultOnError(error) {
  throw error;
}
function defaultOnWarn(msg) {
}
function createCompilerError(code, loc, messages, additionalMessage) {
  const msg = `https://vuejs.org/error-reference/#compiler-${code}`;
  const error = new SyntaxError(String(msg));
  error.code = code;
  error.loc = loc;
  return error;
}
const ErrorCodes = {
  "ABRUPT_CLOSING_OF_EMPTY_COMMENT": 0,
  "0": "ABRUPT_CLOSING_OF_EMPTY_COMMENT",
  "CDATA_IN_HTML_CONTENT": 1,
  "1": "CDATA_IN_HTML_CONTENT",
  "DUPLICATE_ATTRIBUTE": 2,
  "2": "DUPLICATE_ATTRIBUTE",
  "END_TAG_WITH_ATTRIBUTES": 3,
  "3": "END_TAG_WITH_ATTRIBUTES",
  "END_TAG_WITH_TRAILING_SOLIDUS": 4,
  "4": "END_TAG_WITH_TRAILING_SOLIDUS",
  "EOF_BEFORE_TAG_NAME": 5,
  "5": "EOF_BEFORE_TAG_NAME",
  "EOF_IN_CDATA": 6,
  "6": "EOF_IN_CDATA",
  "EOF_IN_COMMENT": 7,
  "7": "EOF_IN_COMMENT",
  "EOF_IN_SCRIPT_HTML_COMMENT_LIKE_TEXT": 8,
  "8": "EOF_IN_SCRIPT_HTML_COMMENT_LIKE_TEXT",
  "EOF_IN_TAG": 9,
  "9": "EOF_IN_TAG",
  "INCORRECTLY_CLOSED_COMMENT": 10,
  "10": "INCORRECTLY_CLOSED_COMMENT",
  "INCORRECTLY_OPENED_COMMENT": 11,
  "11": "INCORRECTLY_OPENED_COMMENT",
  "INVALID_FIRST_CHARACTER_OF_TAG_NAME": 12,
  "12": "INVALID_FIRST_CHARACTER_OF_TAG_NAME",
  "MISSING_ATTRIBUTE_VALUE": 13,
  "13": "MISSING_ATTRIBUTE_VALUE",
  "MISSING_END_TAG_NAME": 14,
  "14": "MISSING_END_TAG_NAME",
  "MISSING_WHITESPACE_BETWEEN_ATTRIBUTES": 15,
  "15": "MISSING_WHITESPACE_BETWEEN_ATTRIBUTES",
  "NESTED_COMMENT": 16,
  "16": "NESTED_COMMENT",
  "UNEXPECTED_CHARACTER_IN_ATTRIBUTE_NAME": 17,
  "17": "UNEXPECTED_CHARACTER_IN_ATTRIBUTE_NAME",
  "UNEXPECTED_CHARACTER_IN_UNQUOTED_ATTRIBUTE_VALUE": 18,
  "18": "UNEXPECTED_CHARACTER_IN_UNQUOTED_ATTRIBUTE_VALUE",
  "UNEXPECTED_EQUALS_SIGN_BEFORE_ATTRIBUTE_NAME": 19,
  "19": "UNEXPECTED_EQUALS_SIGN_BEFORE_ATTRIBUTE_NAME",
  "UNEXPECTED_NULL_CHARACTER": 20,
  "20": "UNEXPECTED_NULL_CHARACTER",
  "UNEXPECTED_QUESTION_MARK_INSTEAD_OF_TAG_NAME": 21,
  "21": "UNEXPECTED_QUESTION_MARK_INSTEAD_OF_TAG_NAME",
  "UNEXPECTED_SOLIDUS_IN_TAG": 22,
  "22": "UNEXPECTED_SOLIDUS_IN_TAG",
  "X_INVALID_END_TAG": 23,
  "23": "X_INVALID_END_TAG",
  "X_MISSING_END_TAG": 24,
  "24": "X_MISSING_END_TAG",
  "X_MISSING_INTERPOLATION_END": 25,
  "25": "X_MISSING_INTERPOLATION_END",
  "X_MISSING_DIRECTIVE_NAME": 26,
  "26": "X_MISSING_DIRECTIVE_NAME",
  "X_MISSING_DYNAMIC_DIRECTIVE_ARGUMENT_END": 27,
  "27": "X_MISSING_DYNAMIC_DIRECTIVE_ARGUMENT_END",
  "X_V_IF_NO_EXPRESSION": 28,
  "28": "X_V_IF_NO_EXPRESSION",
  "X_V_IF_SAME_KEY": 29,
  "29": "X_V_IF_SAME_KEY",
  "X_V_ELSE_NO_ADJACENT_IF": 30,
  "30": "X_V_ELSE_NO_ADJACENT_IF",
  "X_V_FOR_NO_EXPRESSION": 31,
  "31": "X_V_FOR_NO_EXPRESSION",
  "X_V_FOR_MALFORMED_EXPRESSION": 32,
  "32": "X_V_FOR_MALFORMED_EXPRESSION",
  "X_V_FOR_TEMPLATE_KEY_PLACEMENT": 33,
  "33": "X_V_FOR_TEMPLATE_KEY_PLACEMENT",
  "X_V_BIND_NO_EXPRESSION": 34,
  "34": "X_V_BIND_NO_EXPRESSION",
  "X_V_ON_NO_EXPRESSION": 35,
  "35": "X_V_ON_NO_EXPRESSION",
  "X_V_SLOT_UNEXPECTED_DIRECTIVE_ON_SLOT_OUTLET": 36,
  "36": "X_V_SLOT_UNEXPECTED_DIRECTIVE_ON_SLOT_OUTLET",
  "X_V_SLOT_MIXED_SLOT_USAGE": 37,
  "37": "X_V_SLOT_MIXED_SLOT_USAGE",
  "X_V_SLOT_DUPLICATE_SLOT_NAMES": 38,
  "38": "X_V_SLOT_DUPLICATE_SLOT_NAMES",
  "X_V_SLOT_EXTRANEOUS_DEFAULT_SLOT_CHILDREN": 39,
  "39": "X_V_SLOT_EXTRANEOUS_DEFAULT_SLOT_CHILDREN",
  "X_V_SLOT_MISPLACED": 40,
  "40": "X_V_SLOT_MISPLACED",
  "X_V_MODEL_NO_EXPRESSION": 41,
  "41": "X_V_MODEL_NO_EXPRESSION",
  "X_V_MODEL_MALFORMED_EXPRESSION": 42,
  "42": "X_V_MODEL_MALFORMED_EXPRESSION",
  "X_V_MODEL_ON_SCOPE_VARIABLE": 43,
  "43": "X_V_MODEL_ON_SCOPE_VARIABLE",
  "X_V_MODEL_ON_PROPS": 44,
  "44": "X_V_MODEL_ON_PROPS",
  "X_V_MODEL_ON_CONST": 45,
  "45": "X_V_MODEL_ON_CONST",
  "X_INVALID_EXPRESSION": 46,
  "46": "X_INVALID_EXPRESSION",
  "X_KEEP_ALIVE_INVALID_CHILDREN": 47,
  "47": "X_KEEP_ALIVE_INVALID_CHILDREN",
  "X_PREFIX_ID_NOT_SUPPORTED": 48,
  "48": "X_PREFIX_ID_NOT_SUPPORTED",
  "X_MODULE_MODE_NOT_SUPPORTED": 49,
  "49": "X_MODULE_MODE_NOT_SUPPORTED",
  "X_CACHE_HANDLER_NOT_SUPPORTED": 50,
  "50": "X_CACHE_HANDLER_NOT_SUPPORTED",
  "X_SCOPE_ID_NOT_SUPPORTED": 51,
  "51": "X_SCOPE_ID_NOT_SUPPORTED",
  "X_VNODE_HOOKS": 52,
  "52": "X_VNODE_HOOKS",
  "X_V_BIND_INVALID_SAME_NAME_ARGUMENT": 53,
  "53": "X_V_BIND_INVALID_SAME_NAME_ARGUMENT",
  "__EXTEND_POINT__": 54,
  "54": "__EXTEND_POINT__"
};
const errorMessages = {
  // parse errors
  [0]: "Illegal comment.",
  [1]: "CDATA section is allowed only in XML context.",
  [2]: "Duplicate attribute.",
  [3]: "End tag cannot have attributes.",
  [4]: "Illegal '/' in tags.",
  [5]: "Unexpected EOF in tag.",
  [6]: "Unexpected EOF in CDATA section.",
  [7]: "Unexpected EOF in comment.",
  [8]: "Unexpected EOF in script.",
  [9]: "Unexpected EOF in tag.",
  [10]: "Incorrectly closed comment.",
  [11]: "Incorrectly opened comment.",
  [12]: "Illegal tag name. Use '&lt;' to print '<'.",
  [13]: "Attribute value was expected.",
  [14]: "End tag name was expected.",
  [15]: "Whitespace was expected.",
  [16]: "Unexpected '<!--' in comment.",
  [17]: `Attribute name cannot contain U+0022 ("), U+0027 ('), and U+003C (<).`,
  [18]: "Unquoted attribute value cannot contain U+0022 (\"), U+0027 ('), U+003C (<), U+003D (=), and U+0060 (`).",
  [19]: "Attribute name cannot start with '='.",
  [21]: "'<?' is allowed only in XML context.",
  [20]: `Unexpected null character.`,
  [22]: "Illegal '/' in tags.",
  // Vue-specific parse errors
  [23]: "Invalid end tag.",
  [24]: "Element is missing end tag.",
  [25]: "Interpolation end sign was not found.",
  [27]: "End bracket for dynamic directive argument was not found. Note that dynamic directive argument cannot contain spaces.",
  [26]: "Legal directive name was expected.",
  // transform errors
  [28]: `v-if/v-else-if is missing expression.`,
  [29]: `v-if/else branches must use unique keys.`,
  [30]: `v-else/v-else-if has no adjacent v-if or v-else-if.`,
  [31]: `v-for is missing expression.`,
  [32]: `v-for has invalid expression.`,
  [33]: `<template v-for> key should be placed on the <template> tag.`,
  [34]: `v-bind is missing expression.`,
  [53]: `v-bind with same-name shorthand only allows static argument.`,
  [35]: `v-on is missing expression.`,
  [36]: `Unexpected custom directive on <slot> outlet.`,
  [37]: `Mixed v-slot usage on both the component and nested <template>. When there are multiple named slots, all slots should use <template> syntax to avoid scope ambiguity.`,
  [38]: `Duplicate slot names found. `,
  [39]: `Extraneous children found when component already has explicitly named default slot. These children will be ignored.`,
  [40]: `v-slot can only be used on components or <template> tags.`,
  [41]: `v-model is missing expression.`,
  [42]: `v-model value must be a valid JavaScript member expression.`,
  [43]: `v-model cannot be used on v-for or v-slot scope variables because they are not writable.`,
  [44]: `v-model cannot be used on a prop, because local prop bindings are not writable.
Use a v-bind binding combined with a v-on listener that emits update:x event instead.`,
  [45]: `v-model cannot be used on a const binding because it is not writable.`,
  [46]: `Error parsing JavaScript expression: `,
  [47]: `<KeepAlive> expects exactly one child component.`,
  [52]: `@vnode-* hooks in templates are no longer supported. Use the vue: prefix instead. For example, @vnode-mounted should be changed to @vue:mounted. @vnode-* hooks support has been removed in 3.4.`,
  // generic errors
  [48]: `"prefixIdentifiers" option is not supported in this build of compiler.`,
  [49]: `ES module mode is not supported in this build of compiler.`,
  [50]: `"cacheHandlers" option is only supported when the "prefixIdentifiers" option is enabled.`,
  [51]: `"scopeId" option is only supported in module mode.`,
  // just to fulfill types
  [54]: ``
};
function walkIdentifiers(root, onIdentifier, includeAll = false, parentStack = [], knownIds = /* @__PURE__ */ Object.create(null)) {
  {
    return;
  }
}
function isReferencedIdentifier(id, parent, parentStack) {
  {
    return false;
  }
}
function isInDestructureAssignment(parent, parentStack) {
  if (parent && (parent.type === "ObjectProperty" || parent.type === "ArrayPattern")) {
    let i = parentStack.length;
    while (i--) {
      const p = parentStack[i];
      if (p.type === "AssignmentExpression") {
        return true;
      } else if (p.type !== "ObjectProperty" && !p.type.endsWith("Pattern")) {
        break;
      }
    }
  }
  return false;
}
function isInNewExpression(parentStack) {
  let i = parentStack.length;
  while (i--) {
    const p = parentStack[i];
    if (p.type === "NewExpression") {
      return true;
    } else if (p.type !== "MemberExpression") {
      break;
    }
  }
  return false;
}
function walkFunctionParams(node, onIdent) {
  for (const p of node.params) {
    for (const id of extractIdentifiers(p)) {
      onIdent(id);
    }
  }
}
function walkBlockDeclarations(block, onIdent) {
  const body = block.type === "SwitchCase" ? block.consequent : block.body;
  for (const stmt of body) {
    if (stmt.type === "VariableDeclaration") {
      if (stmt.declare) continue;
      for (const decl of stmt.declarations) {
        for (const id of extractIdentifiers(decl.id)) {
          onIdent(id);
        }
      }
    } else if (stmt.type === "FunctionDeclaration" || stmt.type === "ClassDeclaration") {
      if (stmt.declare || !stmt.id) continue;
      onIdent(stmt.id);
    } else if (isForStatement(stmt)) {
      walkForStatement(stmt, true, onIdent);
    } else if (stmt.type === "SwitchStatement") {
      walkSwitchStatement(stmt, true, onIdent);
    }
  }
}
function isForStatement(stmt) {
  return stmt.type === "ForOfStatement" || stmt.type === "ForInStatement" || stmt.type === "ForStatement";
}
function walkForStatement(stmt, isVar, onIdent) {
  const variable = stmt.type === "ForStatement" ? stmt.init : stmt.left;
  if (variable && variable.type === "VariableDeclaration" && (variable.kind === "var" ? isVar : !isVar)) {
    for (const decl of variable.declarations) {
      for (const id of extractIdentifiers(decl.id)) {
        onIdent(id);
      }
    }
  }
}
function walkSwitchStatement(stmt, isVar, onIdent) {
  for (const cs of stmt.cases) {
    for (const stmt2 of cs.consequent) {
      if (stmt2.type === "VariableDeclaration" && (stmt2.kind === "var" ? isVar : !isVar)) {
        for (const decl of stmt2.declarations) {
          for (const id of extractIdentifiers(decl.id)) {
            onIdent(id);
          }
        }
      }
    }
    walkBlockDeclarations(cs, onIdent);
  }
}
function extractIdentifiers(param, nodes = []) {
  switch (param.type) {
    case "Identifier":
      nodes.push(param);
      break;
    case "MemberExpression":
      let object = param;
      while (object.type === "MemberExpression") {
        object = object.object;
      }
      nodes.push(object);
      break;
    case "ObjectPattern":
      for (const prop of param.properties) {
        if (prop.type === "RestElement") {
          extractIdentifiers(prop.argument, nodes);
        } else {
          extractIdentifiers(prop.value, nodes);
        }
      }
      break;
    case "ArrayPattern":
      param.elements.forEach((element) => {
        if (element) extractIdentifiers(element, nodes);
      });
      break;
    case "RestElement":
      extractIdentifiers(param.argument, nodes);
      break;
    case "AssignmentPattern":
      extractIdentifiers(param.left, nodes);
      break;
  }
  return nodes;
}
const isFunctionType = (node) => {
  return /Function(?:Expression|Declaration)$|Method$/.test(node.type);
};
const isStaticProperty = (node) => node && (node.type === "ObjectProperty" || node.type === "ObjectMethod") && !node.computed;
const isStaticPropertyKey = (node, parent) => isStaticProperty(parent) && parent.key === node;
const TS_NODE_TYPES = [
  "TSAsExpression",
  // foo as number
  "TSTypeAssertion",
  // (<number>foo)
  "TSNonNullExpression",
  // foo!
  "TSInstantiationExpression",
  // foo<string>
  "TSSatisfiesExpression"
  // foo satisfies T
];
function unwrapTSNode(node) {
  if (TS_NODE_TYPES.includes(node.type)) {
    return unwrapTSNode(node.expression);
  } else {
    return node;
  }
}
const isStaticExp = (p) => p.type === 4 && p.isStatic;
function isCoreComponent(tag) {
  switch (tag) {
    case "Teleport":
    case "teleport":
      return TELEPORT;
    case "Suspense":
    case "suspense":
      return SUSPENSE;
    case "KeepAlive":
    case "keep-alive":
      return KEEP_ALIVE;
    case "BaseTransition":
    case "base-transition":
      return BASE_TRANSITION;
  }
}
const nonIdentifierRE = /^$|^\d|[^\$\w\xA0-\uFFFF]/;
const isSimpleIdentifier = (name2) => !nonIdentifierRE.test(name2);
const validFirstIdentCharRE = /[A-Za-z_$\xA0-\uFFFF]/;
const validIdentCharRE = /[\.\?\w$\xA0-\uFFFF]/;
const whitespaceRE = /\s+[.[]\s*|\s*[.[]\s+/g;
const getExpSource = (exp) => exp.type === 4 ? exp.content : exp.loc.source;
const isMemberExpressionBrowser = (exp) => {
  const path = getExpSource(exp).trim().replace(whitespaceRE, (s) => s.trim());
  let state = 0;
  let stateStack = [];
  let currentOpenBracketCount = 0;
  let currentOpenParensCount = 0;
  let currentStringType = null;
  for (let i = 0; i < path.length; i++) {
    const char = path.charAt(i);
    switch (state) {
      case 0:
        if (char === "[") {
          stateStack.push(state);
          state = 1;
          currentOpenBracketCount++;
        } else if (char === "(") {
          stateStack.push(state);
          state = 2;
          currentOpenParensCount++;
        } else if (!(i === 0 ? validFirstIdentCharRE : validIdentCharRE).test(char)) {
          return false;
        }
        break;
      case 1:
        if (char === `'` || char === `"` || char === "`") {
          stateStack.push(state);
          state = 3;
          currentStringType = char;
        } else if (char === `[`) {
          currentOpenBracketCount++;
        } else if (char === `]`) {
          if (!--currentOpenBracketCount) {
            state = stateStack.pop();
          }
        }
        break;
      case 2:
        if (char === `'` || char === `"` || char === "`") {
          stateStack.push(state);
          state = 3;
          currentStringType = char;
        } else if (char === `(`) {
          currentOpenParensCount++;
        } else if (char === `)`) {
          if (i === path.length - 1) {
            return false;
          }
          if (!--currentOpenParensCount) {
            state = stateStack.pop();
          }
        }
        break;
      case 3:
        if (char === currentStringType) {
          state = stateStack.pop();
          currentStringType = null;
        }
        break;
    }
  }
  return !currentOpenBracketCount && !currentOpenParensCount;
};
const isMemberExpressionNode = NOOP;
const isMemberExpression = isMemberExpressionBrowser;
const fnExpRE = /^\s*(?:async\s*)?(?:\([^)]*?\)|[\w$_]+)\s*(?::[^=]+)?=>|^\s*(?:async\s+)?function(?:\s+[\w$]+)?\s*\(/;
const isFnExpressionBrowser = (exp) => fnExpRE.test(getExpSource(exp));
const isFnExpressionNode = NOOP;
const isFnExpression = isFnExpressionBrowser;
function advancePositionWithClone(pos, source, numberOfCharacters = source.length) {
  return advancePositionWithMutation(
    {
      offset: pos.offset,
      line: pos.line,
      column: pos.column
    },
    source,
    numberOfCharacters
  );
}
function advancePositionWithMutation(pos, source, numberOfCharacters = source.length) {
  let linesCount = 0;
  let lastNewLinePos = -1;
  for (let i = 0; i < numberOfCharacters; i++) {
    if (source.charCodeAt(i) === 10) {
      linesCount++;
      lastNewLinePos = i;
    }
  }
  pos.offset += numberOfCharacters;
  pos.line += linesCount;
  pos.column = lastNewLinePos === -1 ? pos.column + numberOfCharacters : numberOfCharacters - lastNewLinePos;
  return pos;
}
function assert(condition, msg) {
  if (!condition) {
    throw new Error(msg || `unexpected compiler condition`);
  }
}
function findDir(node, name2, allowEmpty = false) {
  for (let i = 0; i < node.props.length; i++) {
    const p = node.props[i];
    if (p.type === 7 && (allowEmpty || p.exp) && (isString$1(name2) ? p.name === name2 : name2.test(p.name))) {
      return p;
    }
  }
}
function findProp(node, name2, dynamicOnly = false, allowEmpty = false) {
  for (let i = 0; i < node.props.length; i++) {
    const p = node.props[i];
    if (p.type === 6) {
      if (dynamicOnly) continue;
      if (p.name === name2 && (p.value || allowEmpty)) {
        return p;
      }
    } else if (p.name === "bind" && (p.exp || allowEmpty) && isStaticArgOf(p.arg, name2)) {
      return p;
    }
  }
}
function isStaticArgOf(arg, name2) {
  return !!(arg && isStaticExp(arg) && arg.content === name2);
}
function hasDynamicKeyVBind(node) {
  return node.props.some(
    (p) => p.type === 7 && p.name === "bind" && (!p.arg || // v-bind="obj"
    p.arg.type !== 4 || // v-bind:[_ctx.foo]
    !p.arg.isStatic)
    // v-bind:[foo]
  );
}
function isText$1(node) {
  return node.type === 5 || node.type === 2;
}
function isVPre(p) {
  return p.type === 7 && p.name === "pre";
}
function isVSlot(p) {
  return p.type === 7 && p.name === "slot";
}
function isTemplateNode(node) {
  return node.type === 1 && node.tagType === 3;
}
function isSlotOutlet(node) {
  return node.type === 1 && node.tagType === 2;
}
const propsHelperSet = /* @__PURE__ */ new Set([NORMALIZE_PROPS, GUARD_REACTIVE_PROPS]);
function getUnnormalizedProps(props, callPath = []) {
  if (props && !isString$1(props) && props.type === 14) {
    const callee = props.callee;
    if (!isString$1(callee) && propsHelperSet.has(callee)) {
      return getUnnormalizedProps(
        props.arguments[0],
        callPath.concat(props)
      );
    }
  }
  return [props, callPath];
}
function injectProp(node, prop, context) {
  let propsWithInjection;
  let props = node.type === 13 ? node.props : node.arguments[2];
  let callPath = [];
  let parentCall;
  if (props && !isString$1(props) && props.type === 14) {
    const ret = getUnnormalizedProps(props);
    props = ret[0];
    callPath = ret[1];
    parentCall = callPath[callPath.length - 1];
  }
  if (props == null || isString$1(props)) {
    propsWithInjection = createObjectExpression([prop]);
  } else if (props.type === 14) {
    const first = props.arguments[0];
    if (!isString$1(first) && first.type === 15) {
      if (!hasProp(prop, first)) {
        first.properties.unshift(prop);
      }
    } else {
      if (props.callee === TO_HANDLERS) {
        propsWithInjection = createCallExpression(context.helper(MERGE_PROPS), [
          createObjectExpression([prop]),
          props
        ]);
      } else {
        props.arguments.unshift(createObjectExpression([prop]));
      }
    }
    !propsWithInjection && (propsWithInjection = props);
  } else if (props.type === 15) {
    if (!hasProp(prop, props)) {
      props.properties.unshift(prop);
    }
    propsWithInjection = props;
  } else {
    propsWithInjection = createCallExpression(context.helper(MERGE_PROPS), [
      createObjectExpression([prop]),
      props
    ]);
    if (parentCall && parentCall.callee === GUARD_REACTIVE_PROPS) {
      parentCall = callPath[callPath.length - 2];
    }
  }
  if (node.type === 13) {
    if (parentCall) {
      parentCall.arguments[0] = propsWithInjection;
    } else {
      node.props = propsWithInjection;
    }
  } else {
    if (parentCall) {
      parentCall.arguments[0] = propsWithInjection;
    } else {
      node.arguments[2] = propsWithInjection;
    }
  }
}
function hasProp(prop, props) {
  let result = false;
  if (prop.key.type === 4) {
    const propKeyName = prop.key.content;
    result = props.properties.some(
      (p) => p.key.type === 4 && p.key.content === propKeyName
    );
  }
  return result;
}
function toValidAssetId(name2, type) {
  return `_${type}_${name2.replace(/[^\w]/g, (searchValue, replaceValue) => {
    return searchValue === "-" ? "_" : name2.charCodeAt(replaceValue).toString();
  })}`;
}
function hasScopeRef(node, ids) {
  if (!node || Object.keys(ids).length === 0) {
    return false;
  }
  switch (node.type) {
    case 1:
      for (let i = 0; i < node.props.length; i++) {
        const p = node.props[i];
        if (p.type === 7 && (hasScopeRef(p.arg, ids) || hasScopeRef(p.exp, ids))) {
          return true;
        }
      }
      return node.children.some((c) => hasScopeRef(c, ids));
    case 11:
      if (hasScopeRef(node.source, ids)) {
        return true;
      }
      return node.children.some((c) => hasScopeRef(c, ids));
    case 9:
      return node.branches.some((b) => hasScopeRef(b, ids));
    case 10:
      if (hasScopeRef(node.condition, ids)) {
        return true;
      }
      return node.children.some((c) => hasScopeRef(c, ids));
    case 4:
      return !node.isStatic && isSimpleIdentifier(node.content) && !!ids[node.content];
    case 8:
      return node.children.some((c) => isObject$1(c) && hasScopeRef(c, ids));
    case 5:
    case 12:
      return hasScopeRef(node.content, ids);
    case 2:
    case 3:
    case 20:
      return false;
    default:
      return false;
  }
}
function getMemoedVNodeCall(node) {
  if (node.type === 14 && node.callee === WITH_MEMO) {
    return node.arguments[1].returns;
  } else {
    return node;
  }
}
const forAliasRE = /([\s\S]*?)\s+(?:in|of)\s+(\S[\s\S]*)/;
function isAllWhitespace(str) {
  for (let i = 0; i < str.length; i++) {
    if (!isWhitespace(str.charCodeAt(i))) {
      return false;
    }
  }
  return true;
}
function isWhitespaceText(node) {
  return node.type === 2 && isAllWhitespace(node.content) || node.type === 12 && isWhitespaceText(node.content);
}
function isCommentOrWhitespace(node) {
  return node.type === 3 || isWhitespaceText(node);
}
const defaultParserOptions = {
  parseMode: "base",
  ns: 0,
  delimiters: [`{{`, `}}`],
  getNamespace: () => 0,
  isVoidTag: NO,
  isPreTag: NO,
  isIgnoreNewlineTag: NO,
  isCustomElement: NO,
  onError: defaultOnError,
  onWarn: defaultOnWarn,
  comments: false,
  prefixIdentifiers: false
};
let currentOptions = defaultParserOptions;
let currentRoot = null;
let currentInput = "";
let currentOpenTag = null;
let currentProp = null;
let currentAttrValue = "";
let currentAttrStartIndex = -1;
let currentAttrEndIndex = -1;
let inPre = 0;
let inVPre = false;
let currentVPreBoundary = null;
const stack = [];
const tokenizer = new Tokenizer(stack, {
  onerr: emitError,
  ontext(start, end) {
    onText(getSlice(start, end), start, end);
  },
  ontextentity(char, start, end) {
    onText(char, start, end);
  },
  oninterpolation(start, end) {
    if (inVPre) {
      return onText(getSlice(start, end), start, end);
    }
    let innerStart = start + tokenizer.delimiterOpen.length;
    let innerEnd = end - tokenizer.delimiterClose.length;
    while (isWhitespace(currentInput.charCodeAt(innerStart))) {
      innerStart++;
    }
    while (isWhitespace(currentInput.charCodeAt(innerEnd - 1))) {
      innerEnd--;
    }
    let exp = getSlice(innerStart, innerEnd);
    if (exp.includes("&")) {
      {
        exp = currentOptions.decodeEntities(exp, false);
      }
    }
    addNode({
      type: 5,
      content: createExp(exp, false, getLoc(innerStart, innerEnd)),
      loc: getLoc(start, end)
    });
  },
  onopentagname(start, end) {
    const name2 = getSlice(start, end);
    currentOpenTag = {
      type: 1,
      tag: name2,
      ns: currentOptions.getNamespace(name2, stack[0], currentOptions.ns),
      tagType: 0,
      // will be refined on tag close
      props: [],
      children: [],
      loc: getLoc(start - 1, end),
      codegenNode: void 0
    };
  },
  onopentagend(end) {
    endOpenTag(end);
  },
  onclosetag(start, end) {
    const name2 = getSlice(start, end);
    if (!currentOptions.isVoidTag(name2)) {
      let found = false;
      for (let i = 0; i < stack.length; i++) {
        const e = stack[i];
        if (e.tag.toLowerCase() === name2.toLowerCase()) {
          found = true;
          if (i > 0) {
            emitError(24, stack[0].loc.start.offset);
          }
          for (let j = 0; j <= i; j++) {
            const el = stack.shift();
            onCloseTag(el, end, j < i);
          }
          break;
        }
      }
      if (!found) {
        emitError(23, backTrack(start, 60));
      }
    }
  },
  onselfclosingtag(end) {
    const name2 = currentOpenTag.tag;
    currentOpenTag.isSelfClosing = true;
    endOpenTag(end);
    if (stack[0] && stack[0].tag === name2) {
      onCloseTag(stack.shift(), end);
    }
  },
  onattribname(start, end) {
    currentProp = {
      type: 6,
      name: getSlice(start, end),
      nameLoc: getLoc(start, end),
      value: void 0,
      loc: getLoc(start)
    };
  },
  ondirname(start, end) {
    const raw = getSlice(start, end);
    const name2 = raw === "." || raw === ":" ? "bind" : raw === "@" ? "on" : raw === "#" ? "slot" : raw.slice(2);
    if (!inVPre && name2 === "") {
      emitError(26, start);
    }
    if (inVPre || name2 === "") {
      currentProp = {
        type: 6,
        name: raw,
        nameLoc: getLoc(start, end),
        value: void 0,
        loc: getLoc(start)
      };
    } else {
      currentProp = {
        type: 7,
        name: name2,
        rawName: raw,
        exp: void 0,
        arg: void 0,
        modifiers: raw === "." ? [createSimpleExpression("prop")] : [],
        loc: getLoc(start)
      };
      if (name2 === "pre") {
        inVPre = tokenizer.inVPre = true;
        currentVPreBoundary = currentOpenTag;
        const props = currentOpenTag.props;
        for (let i = 0; i < props.length; i++) {
          if (props[i].type === 7) {
            props[i] = dirToAttr(props[i]);
          }
        }
      }
    }
  },
  ondirarg(start, end) {
    if (start === end) return;
    const arg = getSlice(start, end);
    if (inVPre && !isVPre(currentProp)) {
      currentProp.name += arg;
      setLocEnd(currentProp.nameLoc, end);
    } else {
      const isStatic = arg[0] !== `[`;
      currentProp.arg = createExp(
        isStatic ? arg : arg.slice(1, -1),
        isStatic,
        getLoc(start, end),
        isStatic ? 3 : 0
      );
    }
  },
  ondirmodifier(start, end) {
    const mod2 = getSlice(start, end);
    if (inVPre && !isVPre(currentProp)) {
      currentProp.name += "." + mod2;
      setLocEnd(currentProp.nameLoc, end);
    } else if (currentProp.name === "slot") {
      const arg = currentProp.arg;
      if (arg) {
        arg.content += "." + mod2;
        setLocEnd(arg.loc, end);
      }
    } else {
      const exp = createSimpleExpression(mod2, true, getLoc(start, end));
      currentProp.modifiers.push(exp);
    }
  },
  onattribdata(start, end) {
    currentAttrValue += getSlice(start, end);
    if (currentAttrStartIndex < 0) currentAttrStartIndex = start;
    currentAttrEndIndex = end;
  },
  onattribentity(char, start, end) {
    currentAttrValue += char;
    if (currentAttrStartIndex < 0) currentAttrStartIndex = start;
    currentAttrEndIndex = end;
  },
  onattribnameend(end) {
    const start = currentProp.loc.start.offset;
    const name2 = getSlice(start, end);
    if (currentProp.type === 7) {
      currentProp.rawName = name2;
    }
    if (currentOpenTag.props.some(
      (p) => (p.type === 7 ? p.rawName : p.name) === name2
    )) {
      emitError(2, start);
    }
  },
  onattribend(quote, end) {
    if (currentOpenTag && currentProp) {
      setLocEnd(currentProp.loc, end);
      if (quote !== 0) {
        if (currentAttrValue.includes("&")) {
          currentAttrValue = currentOptions.decodeEntities(
            currentAttrValue,
            true
          );
        }
        if (currentProp.type === 6) {
          if (currentProp.name === "class") {
            currentAttrValue = condense(currentAttrValue).trim();
          }
          if (quote === 1 && !currentAttrValue) {
            emitError(13, end);
          }
          currentProp.value = {
            type: 2,
            content: currentAttrValue,
            loc: quote === 1 ? getLoc(currentAttrStartIndex, currentAttrEndIndex) : getLoc(currentAttrStartIndex - 1, currentAttrEndIndex + 1)
          };
          if (tokenizer.inSFCRoot && currentOpenTag.tag === "template" && currentProp.name === "lang" && currentAttrValue && currentAttrValue !== "html") {
            tokenizer.enterRCDATA(toCharCodes(`</template`), 0);
          }
        } else {
          let expParseMode = 0;
          currentProp.exp = createExp(
            currentAttrValue,
            false,
            getLoc(currentAttrStartIndex, currentAttrEndIndex),
            0,
            expParseMode
          );
          if (currentProp.name === "for") {
            currentProp.forParseResult = parseForExpression(currentProp.exp);
          }
          let syncIndex = -1;
          if (currentProp.name === "bind" && (syncIndex = currentProp.modifiers.findIndex(
            (mod2) => mod2.content === "sync"
          )) > -1 && checkCompatEnabled(
            "COMPILER_V_BIND_SYNC",
            currentOptions,
            currentProp.loc,
            currentProp.arg.loc.source
          )) {
            currentProp.name = "model";
            currentProp.modifiers.splice(syncIndex, 1);
          }
        }
      }
      if (currentProp.type !== 7 || currentProp.name !== "pre") {
        currentOpenTag.props.push(currentProp);
      }
    }
    currentAttrValue = "";
    currentAttrStartIndex = currentAttrEndIndex = -1;
  },
  oncomment(start, end) {
    if (currentOptions.comments) {
      addNode({
        type: 3,
        content: getSlice(start, end),
        loc: getLoc(start - 4, end + 3)
      });
    }
  },
  onend() {
    const end = currentInput.length;
    for (let index2 = 0; index2 < stack.length; index2++) {
      onCloseTag(stack[index2], end - 1);
      emitError(24, stack[index2].loc.start.offset);
    }
  },
  oncdata(start, end) {
    if (stack[0].ns !== 0) {
      onText(getSlice(start, end), start, end);
    } else {
      emitError(1, start - 9);
    }
  },
  onprocessinginstruction(start) {
    if ((stack[0] ? stack[0].ns : currentOptions.ns) === 0) {
      emitError(
        21,
        start - 1
      );
    }
  }
});
const forIteratorRE = /,([^,\}\]]*)(?:,([^,\}\]]*))?$/;
const stripParensRE = /^\(|\)$/g;
function parseForExpression(input) {
  const loc = input.loc;
  const exp = input.content;
  const inMatch = exp.match(forAliasRE);
  if (!inMatch) return;
  const [, LHS, RHS] = inMatch;
  const createAliasExpression = (content, offset2, asParam = false) => {
    const start = loc.start.offset + offset2;
    const end = start + content.length;
    return createExp(
      content,
      false,
      getLoc(start, end),
      0,
      asParam ? 1 : 0
      /* Normal */
    );
  };
  const result = {
    source: createAliasExpression(RHS.trim(), exp.indexOf(RHS, LHS.length)),
    value: void 0,
    key: void 0,
    index: void 0,
    finalized: false
  };
  let valueContent = LHS.trim().replace(stripParensRE, "").trim();
  const trimmedOffset = LHS.indexOf(valueContent);
  const iteratorMatch = valueContent.match(forIteratorRE);
  if (iteratorMatch) {
    valueContent = valueContent.replace(forIteratorRE, "").trim();
    const keyContent = iteratorMatch[1].trim();
    let keyOffset;
    if (keyContent) {
      keyOffset = exp.indexOf(keyContent, trimmedOffset + valueContent.length);
      result.key = createAliasExpression(keyContent, keyOffset, true);
    }
    if (iteratorMatch[2]) {
      const indexContent = iteratorMatch[2].trim();
      if (indexContent) {
        result.index = createAliasExpression(
          indexContent,
          exp.indexOf(
            indexContent,
            result.key ? keyOffset + keyContent.length : trimmedOffset + valueContent.length
          ),
          true
        );
      }
    }
  }
  if (valueContent) {
    result.value = createAliasExpression(valueContent, trimmedOffset, true);
  }
  return result;
}
function getSlice(start, end) {
  return currentInput.slice(start, end);
}
function endOpenTag(end) {
  if (tokenizer.inSFCRoot) {
    currentOpenTag.innerLoc = getLoc(end + 1, end + 1);
  }
  addNode(currentOpenTag);
  const { tag, ns } = currentOpenTag;
  if (ns === 0 && currentOptions.isPreTag(tag)) {
    inPre++;
  }
  if (currentOptions.isVoidTag(tag)) {
    onCloseTag(currentOpenTag, end);
  } else {
    stack.unshift(currentOpenTag);
    if (ns === 1 || ns === 2) {
      tokenizer.inXML = true;
    }
  }
  currentOpenTag = null;
}
function onText(content, start, end) {
  {
    const tag = stack[0] && stack[0].tag;
    if (tag !== "script" && tag !== "style" && content.includes("&")) {
      content = currentOptions.decodeEntities(content, false);
    }
  }
  const parent = stack[0] || currentRoot;
  const lastNode = parent.children[parent.children.length - 1];
  if (lastNode && lastNode.type === 2) {
    lastNode.content += content;
    setLocEnd(lastNode.loc, end);
  } else {
    parent.children.push({
      type: 2,
      content,
      loc: getLoc(start, end)
    });
  }
}
function onCloseTag(el, end, isImplied = false) {
  if (isImplied) {
    setLocEnd(el.loc, backTrack(end, 60));
  } else {
    setLocEnd(el.loc, lookAhead(end, 62) + 1);
  }
  if (tokenizer.inSFCRoot) {
    if (el.children.length) {
      el.innerLoc.end = extend$2({}, el.children[el.children.length - 1].loc.end);
    } else {
      el.innerLoc.end = extend$2({}, el.innerLoc.start);
    }
    el.innerLoc.source = getSlice(
      el.innerLoc.start.offset,
      el.innerLoc.end.offset
    );
  }
  const { tag, ns, children } = el;
  if (!inVPre) {
    if (tag === "slot") {
      el.tagType = 2;
    } else if (isFragmentTemplate(el)) {
      el.tagType = 3;
    } else if (isComponent(el)) {
      el.tagType = 1;
    }
  }
  if (!tokenizer.inRCDATA) {
    el.children = condenseWhitespace(children);
  }
  if (ns === 0 && currentOptions.isIgnoreNewlineTag(tag)) {
    const first = children[0];
    if (first && first.type === 2) {
      first.content = first.content.replace(/^\r?\n/, "");
    }
  }
  if (ns === 0 && currentOptions.isPreTag(tag)) {
    inPre--;
  }
  if (currentVPreBoundary === el) {
    inVPre = tokenizer.inVPre = false;
    currentVPreBoundary = null;
  }
  if (tokenizer.inXML && (stack[0] ? stack[0].ns : currentOptions.ns) === 0) {
    tokenizer.inXML = false;
  }
  {
    const props = el.props;
    if (!tokenizer.inSFCRoot && isCompatEnabled(
      "COMPILER_NATIVE_TEMPLATE",
      currentOptions
    ) && el.tag === "template" && !isFragmentTemplate(el)) {
      const parent = stack[0] || currentRoot;
      const index2 = parent.children.indexOf(el);
      parent.children.splice(index2, 1, ...el.children);
    }
    const inlineTemplateProp = props.find(
      (p) => p.type === 6 && p.name === "inline-template"
    );
    if (inlineTemplateProp && checkCompatEnabled(
      "COMPILER_INLINE_TEMPLATE",
      currentOptions,
      inlineTemplateProp.loc
    ) && el.children.length) {
      inlineTemplateProp.value = {
        type: 2,
        content: getSlice(
          el.children[0].loc.start.offset,
          el.children[el.children.length - 1].loc.end.offset
        ),
        loc: inlineTemplateProp.loc
      };
    }
  }
}
function lookAhead(index2, c) {
  let i = index2;
  while (currentInput.charCodeAt(i) !== c && i < currentInput.length - 1) i++;
  return i;
}
function backTrack(index2, c) {
  let i = index2;
  while (currentInput.charCodeAt(i) !== c && i >= 0) i--;
  return i;
}
const specialTemplateDir = /* @__PURE__ */ new Set(["if", "else", "else-if", "for", "slot"]);
function isFragmentTemplate({ tag, props }) {
  if (tag === "template") {
    for (let i = 0; i < props.length; i++) {
      if (props[i].type === 7 && specialTemplateDir.has(props[i].name)) {
        return true;
      }
    }
  }
  return false;
}
function isComponent({ tag, props }) {
  if (currentOptions.isCustomElement(tag)) {
    return false;
  }
  if (tag === "component" || isUpperCase(tag.charCodeAt(0)) || isCoreComponent(tag) || currentOptions.isBuiltInComponent && currentOptions.isBuiltInComponent(tag) || currentOptions.isNativeTag && !currentOptions.isNativeTag(tag)) {
    return true;
  }
  for (let i = 0; i < props.length; i++) {
    const p = props[i];
    if (p.type === 6) {
      if (p.name === "is" && p.value) {
        if (p.value.content.startsWith("vue:")) {
          return true;
        } else if (checkCompatEnabled(
          "COMPILER_IS_ON_ELEMENT",
          currentOptions,
          p.loc
        )) {
          return true;
        }
      }
    } else if (
      // :is on plain element - only treat as component in compat mode
      p.name === "bind" && isStaticArgOf(p.arg, "is") && checkCompatEnabled(
        "COMPILER_IS_ON_ELEMENT",
        currentOptions,
        p.loc
      )
    ) {
      return true;
    }
  }
  return false;
}
function isUpperCase(c) {
  return c > 64 && c < 91;
}
const windowsNewlineRE = /\r\n/g;
function condenseWhitespace(nodes) {
  const shouldCondense = currentOptions.whitespace !== "preserve";
  let removedWhitespace = false;
  for (let i = 0; i < nodes.length; i++) {
    const node = nodes[i];
    if (node.type === 2) {
      if (!inPre) {
        if (isAllWhitespace(node.content)) {
          const prev = nodes[i - 1] && nodes[i - 1].type;
          const next = nodes[i + 1] && nodes[i + 1].type;
          if (!prev || !next || shouldCondense && (prev === 3 && (next === 3 || next === 1) || prev === 1 && (next === 3 || next === 1 && hasNewlineChar(node.content)))) {
            removedWhitespace = true;
            nodes[i] = null;
          } else {
            node.content = " ";
          }
        } else if (shouldCondense) {
          node.content = condense(node.content);
        }
      } else {
        node.content = node.content.replace(windowsNewlineRE, "\n");
      }
    }
  }
  return removedWhitespace ? nodes.filter(Boolean) : nodes;
}
function hasNewlineChar(str) {
  for (let i = 0; i < str.length; i++) {
    const c = str.charCodeAt(i);
    if (c === 10 || c === 13) {
      return true;
    }
  }
  return false;
}
function condense(str) {
  let ret = "";
  let prevCharIsWhitespace = false;
  for (let i = 0; i < str.length; i++) {
    if (isWhitespace(str.charCodeAt(i))) {
      if (!prevCharIsWhitespace) {
        ret += " ";
        prevCharIsWhitespace = true;
      }
    } else {
      ret += str[i];
      prevCharIsWhitespace = false;
    }
  }
  return ret;
}
function addNode(node) {
  (stack[0] || currentRoot).children.push(node);
}
function getLoc(start, end) {
  return {
    start: tokenizer.getPos(start),
    // @ts-expect-error allow late attachment
    end: end == null ? end : tokenizer.getPos(end),
    // @ts-expect-error allow late attachment
    source: end == null ? end : getSlice(start, end)
  };
}
function cloneLoc(loc) {
  return getLoc(loc.start.offset, loc.end.offset);
}
function setLocEnd(loc, end) {
  loc.end = tokenizer.getPos(end);
  loc.source = getSlice(loc.start.offset, end);
}
function dirToAttr(dir) {
  const attr = {
    type: 6,
    name: dir.rawName,
    nameLoc: getLoc(
      dir.loc.start.offset,
      dir.loc.start.offset + dir.rawName.length
    ),
    value: void 0,
    loc: dir.loc
  };
  if (dir.exp) {
    const loc = dir.exp.loc;
    if (loc.end.offset < dir.loc.end.offset) {
      loc.start.offset--;
      loc.start.column--;
      loc.end.offset++;
      loc.end.column++;
    }
    attr.value = {
      type: 2,
      content: dir.exp.content,
      loc
    };
  }
  return attr;
}
function createExp(content, isStatic = false, loc, constType = 0, parseMode = 0) {
  const exp = createSimpleExpression(content, isStatic, loc, constType);
  return exp;
}
function emitError(code, index2, message) {
  currentOptions.onError(
    createCompilerError(code, getLoc(index2, index2))
  );
}
function reset() {
  tokenizer.reset();
  currentOpenTag = null;
  currentProp = null;
  currentAttrValue = "";
  currentAttrStartIndex = -1;
  currentAttrEndIndex = -1;
  stack.length = 0;
}
function baseParse(input, options2) {
  reset();
  currentInput = input;
  currentOptions = extend$2({}, defaultParserOptions);
  if (options2) {
    let key;
    for (key in options2) {
      if (options2[key] != null) {
        currentOptions[key] = options2[key];
      }
    }
  }
  tokenizer.mode = currentOptions.parseMode === "html" ? 1 : currentOptions.parseMode === "sfc" ? 2 : 0;
  tokenizer.inXML = currentOptions.ns === 1 || currentOptions.ns === 2;
  const delimiters = options2 && options2.delimiters;
  if (delimiters) {
    tokenizer.delimiterOpen = toCharCodes(delimiters[0]);
    tokenizer.delimiterClose = toCharCodes(delimiters[1]);
  }
  const root = currentRoot = createRoot([], input);
  tokenizer.parse(currentInput);
  root.loc = getLoc(0, input.length);
  root.children = condenseWhitespace(root.children);
  currentRoot = null;
  return root;
}
function cacheStatic(root, context) {
  walk(
    root,
    void 0,
    context,
    // Root node is unfortunately non-hoistable due to potential parent
    // fallthrough attributes.
    !!getSingleElementRoot(root)
  );
}
function getSingleElementRoot(root) {
  const children = root.children.filter((x) => x.type !== 3);
  return children.length === 1 && children[0].type === 1 && !isSlotOutlet(children[0]) ? children[0] : null;
}
function walk(node, parent, context, doNotHoistNode = false, inFor = false) {
  const { children } = node;
  const toCache = [];
  for (let i = 0; i < children.length; i++) {
    const child = children[i];
    if (child.type === 1 && child.tagType === 0) {
      const constantType = doNotHoistNode ? 0 : getConstantType(child, context);
      if (constantType > 0) {
        if (constantType >= 2) {
          child.codegenNode.patchFlag = -1;
          toCache.push(child);
          continue;
        }
      } else {
        const codegenNode = child.codegenNode;
        if (codegenNode.type === 13) {
          const flag = codegenNode.patchFlag;
          if ((flag === void 0 || flag === 512 || flag === 1) && getGeneratedPropsConstantType(child, context) >= 2) {
            const props = getNodeProps(child);
            if (props) {
              codegenNode.props = context.hoist(props);
            }
          }
          if (codegenNode.dynamicProps) {
            codegenNode.dynamicProps = context.hoist(codegenNode.dynamicProps);
          }
        }
      }
    } else if (child.type === 12) {
      const constantType = doNotHoistNode ? 0 : getConstantType(child, context);
      if (constantType >= 2) {
        if (child.codegenNode.type === 14 && child.codegenNode.arguments.length > 0) {
          child.codegenNode.arguments.push(
            `-1`
          );
        }
        toCache.push(child);
        continue;
      }
    }
    if (child.type === 1) {
      const isComponent2 = child.tagType === 1;
      if (isComponent2) {
        context.scopes.vSlot++;
      }
      walk(child, node, context, false, inFor);
      if (isComponent2) {
        context.scopes.vSlot--;
      }
    } else if (child.type === 11) {
      walk(child, node, context, child.children.length === 1, true);
    } else if (child.type === 9) {
      for (let i2 = 0; i2 < child.branches.length; i2++) {
        walk(
          child.branches[i2],
          node,
          context,
          child.branches[i2].children.length === 1,
          inFor
        );
      }
    }
  }
  let cachedAsArray = false;
  if (toCache.length === children.length && node.type === 1) {
    if (node.tagType === 0 && node.codegenNode && node.codegenNode.type === 13 && isArray$1(node.codegenNode.children)) {
      node.codegenNode.children = getCacheExpression(
        createArrayExpression(node.codegenNode.children)
      );
      cachedAsArray = true;
    } else if (node.tagType === 1 && node.codegenNode && node.codegenNode.type === 13 && node.codegenNode.children && !isArray$1(node.codegenNode.children) && node.codegenNode.children.type === 15) {
      const slot = getSlotNode(node.codegenNode, "default");
      if (slot) {
        slot.returns = getCacheExpression(
          createArrayExpression(slot.returns)
        );
        cachedAsArray = true;
      }
    } else if (node.tagType === 3 && parent && parent.type === 1 && parent.tagType === 1 && parent.codegenNode && parent.codegenNode.type === 13 && parent.codegenNode.children && !isArray$1(parent.codegenNode.children) && parent.codegenNode.children.type === 15) {
      const slotName = findDir(node, "slot", true);
      const slot = slotName && slotName.arg && getSlotNode(parent.codegenNode, slotName.arg);
      if (slot) {
        slot.returns = getCacheExpression(
          createArrayExpression(slot.returns)
        );
        cachedAsArray = true;
      }
    }
  }
  if (!cachedAsArray) {
    for (const child of toCache) {
      child.codegenNode = context.cache(child.codegenNode);
    }
  }
  function getCacheExpression(value) {
    const exp = context.cache(value);
    exp.needArraySpread = true;
    return exp;
  }
  function getSlotNode(node2, name2) {
    if (node2.children && !isArray$1(node2.children) && node2.children.type === 15) {
      const slot = node2.children.properties.find(
        (p) => p.key === name2 || p.key.content === name2
      );
      return slot && slot.value;
    }
  }
  if (toCache.length && context.transformHoist) {
    context.transformHoist(children, context, node);
  }
}
function getConstantType(node, context) {
  const { constantCache } = context;
  switch (node.type) {
    case 1:
      if (node.tagType !== 0) {
        return 0;
      }
      const cached = constantCache.get(node);
      if (cached !== void 0) {
        return cached;
      }
      const codegenNode = node.codegenNode;
      if (codegenNode.type !== 13) {
        return 0;
      }
      if (codegenNode.isBlock && node.tag !== "svg" && node.tag !== "foreignObject" && node.tag !== "math") {
        return 0;
      }
      if (codegenNode.patchFlag === void 0) {
        let returnType2 = 3;
        const generatedPropsType = getGeneratedPropsConstantType(node, context);
        if (generatedPropsType === 0) {
          constantCache.set(node, 0);
          return 0;
        }
        if (generatedPropsType < returnType2) {
          returnType2 = generatedPropsType;
        }
        for (let i = 0; i < node.children.length; i++) {
          const childType = getConstantType(node.children[i], context);
          if (childType === 0) {
            constantCache.set(node, 0);
            return 0;
          }
          if (childType < returnType2) {
            returnType2 = childType;
          }
        }
        if (returnType2 > 1) {
          for (let i = 0; i < node.props.length; i++) {
            const p = node.props[i];
            if (p.type === 7 && p.name === "bind" && p.exp) {
              const expType = getConstantType(p.exp, context);
              if (expType === 0) {
                constantCache.set(node, 0);
                return 0;
              }
              if (expType < returnType2) {
                returnType2 = expType;
              }
            }
          }
        }
        if (codegenNode.isBlock) {
          for (let i = 0; i < node.props.length; i++) {
            const p = node.props[i];
            if (p.type === 7) {
              constantCache.set(node, 0);
              return 0;
            }
          }
          context.removeHelper(OPEN_BLOCK);
          context.removeHelper(
            getVNodeBlockHelper(context.inSSR, codegenNode.isComponent)
          );
          codegenNode.isBlock = false;
          context.helper(getVNodeHelper(context.inSSR, codegenNode.isComponent));
        }
        constantCache.set(node, returnType2);
        return returnType2;
      } else {
        constantCache.set(node, 0);
        return 0;
      }
    case 2:
    case 3:
      return 3;
    case 9:
    case 11:
    case 10:
      return 0;
    case 5:
    case 12:
      return getConstantType(node.content, context);
    case 4:
      return node.constType;
    case 8:
      let returnType = 3;
      for (let i = 0; i < node.children.length; i++) {
        const child = node.children[i];
        if (isString$1(child) || isSymbol(child)) {
          continue;
        }
        const childType = getConstantType(child, context);
        if (childType === 0) {
          return 0;
        } else if (childType < returnType) {
          returnType = childType;
        }
      }
      return returnType;
    case 20:
      return 2;
    default:
      return 0;
  }
}
const allowHoistedHelperSet = /* @__PURE__ */ new Set([
  NORMALIZE_CLASS,
  NORMALIZE_STYLE,
  NORMALIZE_PROPS,
  GUARD_REACTIVE_PROPS
]);
function getConstantTypeOfHelperCall(value, context) {
  if (value.type === 14 && !isString$1(value.callee) && allowHoistedHelperSet.has(value.callee)) {
    const arg = value.arguments[0];
    if (arg.type === 4) {
      return getConstantType(arg, context);
    } else if (arg.type === 14) {
      return getConstantTypeOfHelperCall(arg, context);
    }
  }
  return 0;
}
function getGeneratedPropsConstantType(node, context) {
  let returnType = 3;
  const props = getNodeProps(node);
  if (props && props.type === 15) {
    const { properties } = props;
    for (let i = 0; i < properties.length; i++) {
      const { key, value } = properties[i];
      const keyType = getConstantType(key, context);
      if (keyType === 0) {
        return keyType;
      }
      if (keyType < returnType) {
        returnType = keyType;
      }
      let valueType;
      if (value.type === 4) {
        valueType = getConstantType(value, context);
      } else if (value.type === 14) {
        valueType = getConstantTypeOfHelperCall(value, context);
      } else {
        valueType = 0;
      }
      if (valueType === 0) {
        return valueType;
      }
      if (valueType < returnType) {
        returnType = valueType;
      }
    }
  }
  return returnType;
}
function getNodeProps(node) {
  const codegenNode = node.codegenNode;
  if (codegenNode.type === 13) {
    return codegenNode.props;
  }
}
function createTransformContext(root, {
  filename = "",
  prefixIdentifiers = false,
  hoistStatic = false,
  hmr = false,
  cacheHandlers = false,
  nodeTransforms = [],
  directiveTransforms = {},
  transformHoist = null,
  isBuiltInComponent = NOOP,
  isCustomElement = NOOP,
  expressionPlugins = [],
  scopeId = null,
  slotted = true,
  ssr = false,
  inSSR = false,
  ssrCssVars = ``,
  bindingMetadata = EMPTY_OBJ,
  inline = false,
  isTS = false,
  onError = defaultOnError,
  onWarn = defaultOnWarn,
  compatConfig
}) {
  const nameMatch = filename.replace(/\?.*$/, "").match(/([^/\\]+)\.\w+$/);
  const context = {
    // options
    filename,
    selfName: nameMatch && capitalize(camelize(nameMatch[1])),
    prefixIdentifiers,
    hoistStatic,
    hmr,
    cacheHandlers,
    nodeTransforms,
    directiveTransforms,
    transformHoist,
    isBuiltInComponent,
    isCustomElement,
    expressionPlugins,
    scopeId,
    slotted,
    ssr,
    inSSR,
    ssrCssVars,
    bindingMetadata,
    inline,
    isTS,
    onError,
    onWarn,
    compatConfig,
    // state
    root,
    helpers: /* @__PURE__ */ new Map(),
    components: /* @__PURE__ */ new Set(),
    directives: /* @__PURE__ */ new Set(),
    hoists: [],
    imports: [],
    cached: [],
    constantCache: /* @__PURE__ */ new WeakMap(),
    temps: 0,
    identifiers: /* @__PURE__ */ Object.create(null),
    scopes: {
      vFor: 0,
      vSlot: 0,
      vPre: 0,
      vOnce: 0
    },
    parent: null,
    grandParent: null,
    currentNode: root,
    childIndex: 0,
    inVOnce: false,
    // methods
    helper(name2) {
      const count = context.helpers.get(name2) || 0;
      context.helpers.set(name2, count + 1);
      return name2;
    },
    removeHelper(name2) {
      const count = context.helpers.get(name2);
      if (count) {
        const currentCount = count - 1;
        if (!currentCount) {
          context.helpers.delete(name2);
        } else {
          context.helpers.set(name2, currentCount);
        }
      }
    },
    helperString(name2) {
      return `_${helperNameMap[context.helper(name2)]}`;
    },
    replaceNode(node) {
      context.parent.children[context.childIndex] = context.currentNode = node;
    },
    removeNode(node) {
      const list = context.parent.children;
      const removalIndex = node ? list.indexOf(node) : context.currentNode ? context.childIndex : -1;
      if (!node || node === context.currentNode) {
        context.currentNode = null;
        context.onNodeRemoved();
      } else {
        if (context.childIndex > removalIndex) {
          context.childIndex--;
          context.onNodeRemoved();
        }
      }
      context.parent.children.splice(removalIndex, 1);
    },
    onNodeRemoved: NOOP,
    addIdentifiers(exp) {
    },
    removeIdentifiers(exp) {
    },
    hoist(exp) {
      if (isString$1(exp)) exp = createSimpleExpression(exp);
      context.hoists.push(exp);
      const identifier = createSimpleExpression(
        `_hoisted_${context.hoists.length}`,
        false,
        exp.loc,
        2
      );
      identifier.hoisted = exp;
      return identifier;
    },
    cache(exp, isVNode = false, inVOnce = false) {
      const cacheExp = createCacheExpression(
        context.cached.length,
        exp,
        isVNode,
        inVOnce
      );
      context.cached.push(cacheExp);
      return cacheExp;
    }
  };
  {
    context.filters = /* @__PURE__ */ new Set();
  }
  return context;
}
function transform(root, options2) {
  const context = createTransformContext(root, options2);
  traverseNode(root, context);
  if (options2.hoistStatic) {
    cacheStatic(root, context);
  }
  if (!options2.ssr) {
    createRootCodegen(root, context);
  }
  root.helpers = /* @__PURE__ */ new Set([...context.helpers.keys()]);
  root.components = [...context.components];
  root.directives = [...context.directives];
  root.imports = context.imports;
  root.hoists = context.hoists;
  root.temps = context.temps;
  root.cached = context.cached;
  root.transformed = true;
  {
    root.filters = [...context.filters];
  }
}
function createRootCodegen(root, context) {
  const { helper } = context;
  const { children } = root;
  if (children.length === 1) {
    const singleElementRootChild = getSingleElementRoot(root);
    if (singleElementRootChild && singleElementRootChild.codegenNode) {
      const codegenNode = singleElementRootChild.codegenNode;
      if (codegenNode.type === 13) {
        convertToBlock(codegenNode, context);
      }
      root.codegenNode = codegenNode;
    } else {
      root.codegenNode = children[0];
    }
  } else if (children.length > 1) {
    let patchFlag = 64;
    root.codegenNode = createVNodeCall(
      context,
      helper(FRAGMENT),
      void 0,
      root.children,
      patchFlag,
      void 0,
      void 0,
      true,
      void 0,
      false
    );
  } else ;
}
function traverseChildren(parent, context) {
  let i = 0;
  const nodeRemoved = () => {
    i--;
  };
  for (; i < parent.children.length; i++) {
    const child = parent.children[i];
    if (isString$1(child)) continue;
    context.grandParent = context.parent;
    context.parent = parent;
    context.childIndex = i;
    context.onNodeRemoved = nodeRemoved;
    traverseNode(child, context);
  }
}
function traverseNode(node, context) {
  context.currentNode = node;
  const { nodeTransforms } = context;
  const exitFns = [];
  for (let i2 = 0; i2 < nodeTransforms.length; i2++) {
    const onExit = nodeTransforms[i2](node, context);
    if (onExit) {
      if (isArray$1(onExit)) {
        exitFns.push(...onExit);
      } else {
        exitFns.push(onExit);
      }
    }
    if (!context.currentNode) {
      return;
    } else {
      node = context.currentNode;
    }
  }
  switch (node.type) {
    case 3:
      if (!context.ssr) {
        context.helper(CREATE_COMMENT);
      }
      break;
    case 5:
      if (!context.ssr) {
        context.helper(TO_DISPLAY_STRING);
      }
      break;
    // for container types, further traverse downwards
    case 9:
      for (let i2 = 0; i2 < node.branches.length; i2++) {
        traverseNode(node.branches[i2], context);
      }
      break;
    case 10:
    case 11:
    case 1:
    case 0:
      traverseChildren(node, context);
      break;
  }
  context.currentNode = node;
  let i = exitFns.length;
  while (i--) {
    exitFns[i]();
  }
}
function createStructuralDirectiveTransform(name2, fn) {
  const matches2 = isString$1(name2) ? (n) => n === name2 : (n) => name2.test(n);
  return (node, context) => {
    if (node.type === 1) {
      const { props } = node;
      if (node.tagType === 3 && props.some(isVSlot)) {
        return;
      }
      const exitFns = [];
      for (let i = 0; i < props.length; i++) {
        const prop = props[i];
        if (prop.type === 7 && matches2(prop.name)) {
          props.splice(i, 1);
          i--;
          const onExit = fn(node, prop, context);
          if (onExit) exitFns.push(onExit);
        }
      }
      return exitFns;
    }
  };
}
const PURE_ANNOTATION = `/*@__PURE__*/`;
const aliasHelper = (s) => `${helperNameMap[s]}: _${helperNameMap[s]}`;
function createCodegenContext(ast, {
  mode = "function",
  prefixIdentifiers = mode === "module",
  sourceMap = false,
  filename = `template.vue.html`,
  scopeId = null,
  optimizeImports = false,
  runtimeGlobalName = `Vue`,
  runtimeModuleName = `vue`,
  ssrRuntimeModuleName = "vue/server-renderer",
  ssr = false,
  isTS = false,
  inSSR = false
}) {
  const context = {
    mode,
    prefixIdentifiers,
    sourceMap,
    filename,
    scopeId,
    optimizeImports,
    runtimeGlobalName,
    runtimeModuleName,
    ssrRuntimeModuleName,
    ssr,
    isTS,
    inSSR,
    source: ast.source,
    code: ``,
    column: 1,
    line: 1,
    offset: 0,
    indentLevel: 0,
    pure: false,
    map: void 0,
    helper(key) {
      return `_${helperNameMap[key]}`;
    },
    push(code, newlineIndex = -2, node) {
      context.code += code;
    },
    indent() {
      newline(++context.indentLevel);
    },
    deindent(withoutNewLine = false) {
      if (withoutNewLine) {
        --context.indentLevel;
      } else {
        newline(--context.indentLevel);
      }
    },
    newline() {
      newline(context.indentLevel);
    }
  };
  function newline(n) {
    context.push(
      "\n" + `  `.repeat(n),
      0
      /* Start */
    );
  }
  return context;
}
function generate$1(ast, options2 = {}) {
  const context = createCodegenContext(ast, options2);
  if (options2.onContextCreated) options2.onContextCreated(context);
  const {
    mode,
    push,
    prefixIdentifiers,
    indent,
    deindent,
    newline,
    scopeId,
    ssr
  } = context;
  const helpers = Array.from(ast.helpers);
  const hasHelpers = helpers.length > 0;
  const useWithBlock = !prefixIdentifiers && mode !== "module";
  const preambleContext = context;
  {
    genFunctionPreamble(ast, preambleContext);
  }
  const functionName = ssr ? `ssrRender` : `render`;
  const args = ssr ? ["_ctx", "_push", "_parent", "_attrs"] : ["_ctx", "_cache"];
  const signature = args.join(", ");
  {
    push(`function ${functionName}(${signature}) {`);
  }
  indent();
  if (useWithBlock) {
    push(`with (_ctx) {`);
    indent();
    if (hasHelpers) {
      push(
        `const { ${helpers.map(aliasHelper).join(", ")} } = _Vue
`,
        -1
        /* End */
      );
      newline();
    }
  }
  if (ast.components.length) {
    genAssets(ast.components, "component", context);
    if (ast.directives.length || ast.temps > 0) {
      newline();
    }
  }
  if (ast.directives.length) {
    genAssets(ast.directives, "directive", context);
    if (ast.temps > 0) {
      newline();
    }
  }
  if (ast.filters && ast.filters.length) {
    newline();
    genAssets(ast.filters, "filter", context);
    newline();
  }
  if (ast.temps > 0) {
    push(`let `);
    for (let i = 0; i < ast.temps; i++) {
      push(`${i > 0 ? `, ` : ``}_temp${i}`);
    }
  }
  if (ast.components.length || ast.directives.length || ast.temps) {
    push(
      `
`,
      0
      /* Start */
    );
    newline();
  }
  if (!ssr) {
    push(`return `);
  }
  if (ast.codegenNode) {
    genNode(ast.codegenNode, context);
  } else {
    push(`null`);
  }
  if (useWithBlock) {
    deindent();
    push(`}`);
  }
  deindent();
  push(`}`);
  return {
    ast,
    code: context.code,
    preamble: ``,
    map: context.map ? context.map.toJSON() : void 0
  };
}
function genFunctionPreamble(ast, context) {
  const {
    ssr,
    prefixIdentifiers,
    push,
    newline,
    runtimeModuleName,
    runtimeGlobalName,
    ssrRuntimeModuleName
  } = context;
  const VueBinding = runtimeGlobalName;
  const helpers = Array.from(ast.helpers);
  if (helpers.length > 0) {
    {
      push(
        `const _Vue = ${VueBinding}
`,
        -1
        /* End */
      );
      if (ast.hoists.length) {
        const staticHelpers = [
          CREATE_VNODE,
          CREATE_ELEMENT_VNODE,
          CREATE_COMMENT,
          CREATE_TEXT,
          CREATE_STATIC
        ].filter((helper) => helpers.includes(helper)).map(aliasHelper).join(", ");
        push(
          `const { ${staticHelpers} } = _Vue
`,
          -1
          /* End */
        );
      }
    }
  }
  genHoists(ast.hoists, context);
  newline();
  push(`return `);
}
function genAssets(assets, type, { helper, push, newline, isTS }) {
  const resolver = helper(
    type === "filter" ? RESOLVE_FILTER : type === "component" ? RESOLVE_COMPONENT : RESOLVE_DIRECTIVE
  );
  for (let i = 0; i < assets.length; i++) {
    let id = assets[i];
    const maybeSelfReference = id.endsWith("__self");
    if (maybeSelfReference) {
      id = id.slice(0, -6);
    }
    push(
      `const ${toValidAssetId(id, type)} = ${resolver}(${JSON.stringify(id)}${maybeSelfReference ? `, true` : ``})${isTS ? `!` : ``}`
    );
    if (i < assets.length - 1) {
      newline();
    }
  }
}
function genHoists(hoists, context) {
  if (!hoists.length) {
    return;
  }
  context.pure = true;
  const { push, newline } = context;
  newline();
  for (let i = 0; i < hoists.length; i++) {
    const exp = hoists[i];
    if (exp) {
      push(`const _hoisted_${i + 1} = `);
      genNode(exp, context);
      newline();
    }
  }
  context.pure = false;
}
function genNodeListAsArray(nodes, context) {
  const multilines = nodes.length > 3 || false;
  context.push(`[`);
  multilines && context.indent();
  genNodeList(nodes, context, multilines);
  multilines && context.deindent();
  context.push(`]`);
}
function genNodeList(nodes, context, multilines = false, comma = true) {
  const { push, newline } = context;
  for (let i = 0; i < nodes.length; i++) {
    const node = nodes[i];
    if (isString$1(node)) {
      push(
        node,
        -3
        /* Unknown */
      );
    } else if (isArray$1(node)) {
      genNodeListAsArray(node, context);
    } else {
      genNode(node, context);
    }
    if (i < nodes.length - 1) {
      if (multilines) {
        comma && push(",");
        newline();
      } else {
        comma && push(", ");
      }
    }
  }
}
function genNode(node, context) {
  if (isString$1(node)) {
    context.push(
      node,
      -3
      /* Unknown */
    );
    return;
  }
  if (isSymbol(node)) {
    context.push(context.helper(node));
    return;
  }
  switch (node.type) {
    case 1:
    case 9:
    case 11:
      genNode(node.codegenNode, context);
      break;
    case 2:
      genText(node, context);
      break;
    case 4:
      genExpression(node, context);
      break;
    case 5:
      genInterpolation(node, context);
      break;
    case 12:
      genNode(node.codegenNode, context);
      break;
    case 8:
      genCompoundExpression(node, context);
      break;
    case 3:
      genComment(node, context);
      break;
    case 13:
      genVNodeCall(node, context);
      break;
    case 14:
      genCallExpression(node, context);
      break;
    case 15:
      genObjectExpression(node, context);
      break;
    case 17:
      genArrayExpression(node, context);
      break;
    case 18:
      genFunctionExpression(node, context);
      break;
    case 19:
      genConditionalExpression(node, context);
      break;
    case 20:
      genCacheExpression(node, context);
      break;
    case 21:
      genNodeList(node.body, context, true, false);
      break;
  }
}
function genText(node, context) {
  context.push(JSON.stringify(node.content), -3, node);
}
function genExpression(node, context) {
  const { content, isStatic } = node;
  context.push(
    isStatic ? JSON.stringify(content) : content,
    -3,
    node
  );
}
function genInterpolation(node, context) {
  const { push, helper, pure } = context;
  if (pure) push(PURE_ANNOTATION);
  push(`${helper(TO_DISPLAY_STRING)}(`);
  genNode(node.content, context);
  push(`)`);
}
function genCompoundExpression(node, context) {
  for (let i = 0; i < node.children.length; i++) {
    const child = node.children[i];
    if (isString$1(child)) {
      context.push(
        child,
        -3
        /* Unknown */
      );
    } else {
      genNode(child, context);
    }
  }
}
function genExpressionAsPropertyKey(node, context) {
  const { push } = context;
  if (node.type === 8) {
    push(`[`);
    genCompoundExpression(node, context);
    push(`]`);
  } else if (node.isStatic) {
    const text = isSimpleIdentifier(node.content) ? node.content : JSON.stringify(node.content);
    push(text, -2, node);
  } else {
    push(`[${node.content}]`, -3, node);
  }
}
function genComment(node, context) {
  const { push, helper, pure } = context;
  if (pure) {
    push(PURE_ANNOTATION);
  }
  push(
    `${helper(CREATE_COMMENT)}(${JSON.stringify(node.content)})`,
    -3,
    node
  );
}
function genVNodeCall(node, context) {
  const { push, helper, pure } = context;
  const {
    tag,
    props,
    children,
    patchFlag,
    dynamicProps,
    directives,
    isBlock,
    disableTracking,
    isComponent: isComponent2
  } = node;
  let patchFlagString;
  if (patchFlag) {
    {
      patchFlagString = String(patchFlag);
    }
  }
  if (directives) {
    push(helper(WITH_DIRECTIVES) + `(`);
  }
  if (isBlock) {
    push(`(${helper(OPEN_BLOCK)}(${disableTracking ? `true` : ``}), `);
  }
  if (pure) {
    push(PURE_ANNOTATION);
  }
  const callHelper = isBlock ? getVNodeBlockHelper(context.inSSR, isComponent2) : getVNodeHelper(context.inSSR, isComponent2);
  push(helper(callHelper) + `(`, -2, node);
  genNodeList(
    genNullableArgs([tag, props, children, patchFlagString, dynamicProps]),
    context
  );
  push(`)`);
  if (isBlock) {
    push(`)`);
  }
  if (directives) {
    push(`, `);
    genNode(directives, context);
    push(`)`);
  }
}
function genNullableArgs(args) {
  let i = args.length;
  while (i--) {
    if (args[i] != null) break;
  }
  return args.slice(0, i + 1).map((arg) => arg || `null`);
}
function genCallExpression(node, context) {
  const { push, helper, pure } = context;
  const callee = isString$1(node.callee) ? node.callee : helper(node.callee);
  if (pure) {
    push(PURE_ANNOTATION);
  }
  push(callee + `(`, -2, node);
  genNodeList(node.arguments, context);
  push(`)`);
}
function genObjectExpression(node, context) {
  const { push, indent, deindent, newline } = context;
  const { properties } = node;
  if (!properties.length) {
    push(`{}`, -2, node);
    return;
  }
  const multilines = properties.length > 1 || false;
  push(multilines ? `{` : `{ `);
  multilines && indent();
  for (let i = 0; i < properties.length; i++) {
    const { key, value } = properties[i];
    genExpressionAsPropertyKey(key, context);
    push(`: `);
    genNode(value, context);
    if (i < properties.length - 1) {
      push(`,`);
      newline();
    }
  }
  multilines && deindent();
  push(multilines ? `}` : ` }`);
}
function genArrayExpression(node, context) {
  genNodeListAsArray(node.elements, context);
}
function genFunctionExpression(node, context) {
  const { push, indent, deindent } = context;
  const { params, returns, body, newline, isSlot } = node;
  if (isSlot) {
    push(`_${helperNameMap[WITH_CTX]}(`);
  }
  push(`(`, -2, node);
  if (isArray$1(params)) {
    genNodeList(params, context);
  } else if (params) {
    genNode(params, context);
  }
  push(`) => `);
  if (newline || body) {
    push(`{`);
    indent();
  }
  if (returns) {
    if (newline) {
      push(`return `);
    }
    if (isArray$1(returns)) {
      genNodeListAsArray(returns, context);
    } else {
      genNode(returns, context);
    }
  } else if (body) {
    genNode(body, context);
  }
  if (newline || body) {
    deindent();
    push(`}`);
  }
  if (isSlot) {
    if (node.isNonScopedSlot) {
      push(`, undefined, true`);
    }
    push(`)`);
  }
}
function genConditionalExpression(node, context) {
  const { test, consequent, alternate, newline: needNewline } = node;
  const { push, indent, deindent, newline } = context;
  if (test.type === 4) {
    const needsParens = !isSimpleIdentifier(test.content);
    needsParens && push(`(`);
    genExpression(test, context);
    needsParens && push(`)`);
  } else {
    push(`(`);
    genNode(test, context);
    push(`)`);
  }
  needNewline && indent();
  context.indentLevel++;
  needNewline || push(` `);
  push(`? `);
  genNode(consequent, context);
  context.indentLevel--;
  needNewline && newline();
  needNewline || push(` `);
  push(`: `);
  const isNested = alternate.type === 19;
  if (!isNested) {
    context.indentLevel++;
  }
  genNode(alternate, context);
  if (!isNested) {
    context.indentLevel--;
  }
  needNewline && deindent(
    true
    /* without newline */
  );
}
function genCacheExpression(node, context) {
  const { push, helper, indent, deindent, newline } = context;
  const { needPauseTracking, needArraySpread } = node;
  if (needArraySpread) {
    push(`[...(`);
  }
  push(`_cache[${node.index}] || (`);
  if (needPauseTracking) {
    indent();
    push(`${helper(SET_BLOCK_TRACKING)}(-1`);
    if (node.inVOnce) push(`, true`);
    push(`),`);
    newline();
    push(`(`);
  }
  push(`_cache[${node.index}] = `);
  genNode(node.value, context);
  if (needPauseTracking) {
    push(`).cacheIndex = ${node.index},`);
    newline();
    push(`${helper(SET_BLOCK_TRACKING)}(1),`);
    newline();
    push(`_cache[${node.index}]`);
    deindent();
  }
  push(`)`);
  if (needArraySpread) {
    push(`)]`);
  }
}
new RegExp(
  "\\b" + "arguments,await,break,case,catch,class,const,continue,debugger,default,delete,do,else,export,extends,finally,for,function,if,import,let,new,return,super,switch,throw,try,var,void,while,with,yield".split(",").join("\\b|\\b") + "\\b"
);
const transformExpression = (node, context) => {
  if (node.type === 5) {
    node.content = processExpression(
      node.content,
      context
    );
  } else if (node.type === 1) {
    const memo = findDir(node, "memo");
    for (let i = 0; i < node.props.length; i++) {
      const dir = node.props[i];
      if (dir.type === 7 && dir.name !== "for") {
        const exp = dir.exp;
        const arg = dir.arg;
        if (exp && exp.type === 4 && !(dir.name === "on" && arg) && // key has been processed in transformFor(vMemo + vFor)
        !(memo && arg && arg.type === 4 && arg.content === "key")) {
          dir.exp = processExpression(
            exp,
            context,
            // slot args must be processed as function params
            dir.name === "slot"
          );
        }
        if (arg && arg.type === 4 && !arg.isStatic) {
          dir.arg = processExpression(arg, context);
        }
      }
    }
  }
};
function processExpression(node, context, asParams = false, asRawStatements = false, localVars = Object.create(context.identifiers)) {
  {
    return node;
  }
}
function stringifyExpression(exp) {
  if (isString$1(exp)) {
    return exp;
  } else if (exp.type === 4) {
    return exp.content;
  } else {
    return exp.children.map(stringifyExpression).join("");
  }
}
const transformIf = createStructuralDirectiveTransform(
  /^(?:if|else|else-if)$/,
  (node, dir, context) => {
    return processIf(node, dir, context, (ifNode, branch, isRoot) => {
      const siblings = context.parent.children;
      let i = siblings.indexOf(ifNode);
      let key = 0;
      while (i-- >= 0) {
        const sibling = siblings[i];
        if (sibling && sibling.type === 9) {
          key += sibling.branches.length;
        }
      }
      return () => {
        if (isRoot) {
          ifNode.codegenNode = createCodegenNodeForBranch(
            branch,
            key,
            context
          );
        } else {
          const parentCondition = getParentCondition(ifNode.codegenNode);
          parentCondition.alternate = createCodegenNodeForBranch(
            branch,
            key + ifNode.branches.length - 1,
            context
          );
        }
      };
    });
  }
);
function processIf(node, dir, context, processCodegen) {
  if (dir.name !== "else" && (!dir.exp || !dir.exp.content.trim())) {
    const loc = dir.exp ? dir.exp.loc : node.loc;
    context.onError(
      createCompilerError(28, dir.loc)
    );
    dir.exp = createSimpleExpression(`true`, false, loc);
  }
  if (dir.name === "if") {
    const branch = createIfBranch(node, dir);
    const ifNode = {
      type: 9,
      loc: cloneLoc(node.loc),
      branches: [branch]
    };
    context.replaceNode(ifNode);
    if (processCodegen) {
      return processCodegen(ifNode, branch, true);
    }
  } else {
    const siblings = context.parent.children;
    let i = siblings.indexOf(node);
    while (i-- >= -1) {
      const sibling = siblings[i];
      if (sibling && isCommentOrWhitespace(sibling)) {
        context.removeNode(sibling);
        continue;
      }
      if (sibling && sibling.type === 9) {
        if ((dir.name === "else-if" || dir.name === "else") && sibling.branches[sibling.branches.length - 1].condition === void 0) {
          context.onError(
            createCompilerError(30, node.loc)
          );
        }
        context.removeNode();
        const branch = createIfBranch(node, dir);
        sibling.branches.push(branch);
        const onExit = processCodegen && processCodegen(sibling, branch, false);
        traverseNode(branch, context);
        if (onExit) onExit();
        context.currentNode = null;
      } else {
        context.onError(
          createCompilerError(30, node.loc)
        );
      }
      break;
    }
  }
}
function createIfBranch(node, dir) {
  const isTemplateIf = node.tagType === 3;
  return {
    type: 10,
    loc: node.loc,
    condition: dir.name === "else" ? void 0 : dir.exp,
    children: isTemplateIf && !findDir(node, "for") ? node.children : [node],
    userKey: findProp(node, `key`),
    isTemplateIf
  };
}
function createCodegenNodeForBranch(branch, keyIndex, context) {
  if (branch.condition) {
    return createConditionalExpression(
      branch.condition,
      createChildrenCodegenNode(branch, keyIndex, context),
      // make sure to pass in asBlock: true so that the comment node call
      // closes the current block.
      createCallExpression(context.helper(CREATE_COMMENT), [
        '""',
        "true"
      ])
    );
  } else {
    return createChildrenCodegenNode(branch, keyIndex, context);
  }
}
function createChildrenCodegenNode(branch, keyIndex, context) {
  const { helper } = context;
  const keyProperty = createObjectProperty(
    `key`,
    createSimpleExpression(
      `${keyIndex}`,
      false,
      locStub,
      2
    )
  );
  const { children } = branch;
  const firstChild = children[0];
  const needFragmentWrapper = children.length !== 1 || firstChild.type !== 1;
  if (needFragmentWrapper) {
    if (children.length === 1 && firstChild.type === 11) {
      const vnodeCall = firstChild.codegenNode;
      injectProp(vnodeCall, keyProperty, context);
      return vnodeCall;
    } else {
      let patchFlag = 64;
      return createVNodeCall(
        context,
        helper(FRAGMENT),
        createObjectExpression([keyProperty]),
        children,
        patchFlag,
        void 0,
        void 0,
        true,
        false,
        false,
        branch.loc
      );
    }
  } else {
    const ret = firstChild.codegenNode;
    const vnodeCall = getMemoedVNodeCall(ret);
    if (vnodeCall.type === 13) {
      convertToBlock(vnodeCall, context);
    }
    injectProp(vnodeCall, keyProperty, context);
    return ret;
  }
}
function getParentCondition(node) {
  while (true) {
    if (node.type === 19) {
      if (node.alternate.type === 19) {
        node = node.alternate;
      } else {
        return node;
      }
    } else if (node.type === 20) {
      node = node.value;
    }
  }
}
const transformFor = createStructuralDirectiveTransform(
  "for",
  (node, dir, context) => {
    const { helper, removeHelper } = context;
    return processFor(node, dir, context, (forNode) => {
      const renderExp = createCallExpression(helper(RENDER_LIST), [
        forNode.source
      ]);
      const isTemplate = isTemplateNode(node);
      const memo = findDir(node, "memo");
      const keyProp = findProp(node, `key`, false, true);
      keyProp && keyProp.type === 7;
      let keyExp = keyProp && (keyProp.type === 6 ? keyProp.value ? createSimpleExpression(keyProp.value.content, true) : void 0 : keyProp.exp);
      const keyProperty = keyProp && keyExp ? createObjectProperty(`key`, keyExp) : null;
      const isStableFragment = forNode.source.type === 4 && forNode.source.constType > 0;
      const fragmentFlag = isStableFragment ? 64 : keyProp ? 128 : 256;
      forNode.codegenNode = createVNodeCall(
        context,
        helper(FRAGMENT),
        void 0,
        renderExp,
        fragmentFlag,
        void 0,
        void 0,
        true,
        !isStableFragment,
        false,
        node.loc
      );
      return () => {
        let childBlock;
        const { children } = forNode;
        const needFragmentWrapper = children.length !== 1 || children[0].type !== 1;
        const slotOutlet = isSlotOutlet(node) ? node : isTemplate && node.children.length === 1 && isSlotOutlet(node.children[0]) ? node.children[0] : null;
        if (slotOutlet) {
          childBlock = slotOutlet.codegenNode;
          if (isTemplate && keyProperty) {
            injectProp(childBlock, keyProperty, context);
          }
        } else if (needFragmentWrapper) {
          childBlock = createVNodeCall(
            context,
            helper(FRAGMENT),
            keyProperty ? createObjectExpression([keyProperty]) : void 0,
            node.children,
            64,
            void 0,
            void 0,
            true,
            void 0,
            false
          );
        } else {
          childBlock = children[0].codegenNode;
          if (isTemplate && keyProperty) {
            injectProp(childBlock, keyProperty, context);
          }
          if (childBlock.isBlock !== !isStableFragment) {
            if (childBlock.isBlock) {
              removeHelper(OPEN_BLOCK);
              removeHelper(
                getVNodeBlockHelper(context.inSSR, childBlock.isComponent)
              );
            } else {
              removeHelper(
                getVNodeHelper(context.inSSR, childBlock.isComponent)
              );
            }
          }
          childBlock.isBlock = !isStableFragment;
          if (childBlock.isBlock) {
            helper(OPEN_BLOCK);
            helper(getVNodeBlockHelper(context.inSSR, childBlock.isComponent));
          } else {
            helper(getVNodeHelper(context.inSSR, childBlock.isComponent));
          }
        }
        if (memo) {
          const loop = createFunctionExpression(
            createForLoopParams(forNode.parseResult, [
              createSimpleExpression(`_cached`)
            ])
          );
          loop.body = createBlockStatement([
            createCompoundExpression([`const _memo = (`, memo.exp, `)`]),
            createCompoundExpression([
              `if (_cached`,
              ...keyExp ? [` && _cached.key === `, keyExp] : [],
              ` && ${context.helperString(
                IS_MEMO_SAME
              )}(_cached, _memo)) return _cached`
            ]),
            createCompoundExpression([`const _item = `, childBlock]),
            createSimpleExpression(`_item.memo = _memo`),
            createSimpleExpression(`return _item`)
          ]);
          renderExp.arguments.push(
            loop,
            createSimpleExpression(`_cache`),
            createSimpleExpression(String(context.cached.length))
          );
          context.cached.push(null);
        } else {
          renderExp.arguments.push(
            createFunctionExpression(
              createForLoopParams(forNode.parseResult),
              childBlock,
              true
            )
          );
        }
      };
    });
  }
);
function processFor(node, dir, context, processCodegen) {
  if (!dir.exp) {
    context.onError(
      createCompilerError(31, dir.loc)
    );
    return;
  }
  const parseResult = dir.forParseResult;
  if (!parseResult) {
    context.onError(
      createCompilerError(32, dir.loc)
    );
    return;
  }
  finalizeForParseResult(parseResult);
  const { addIdentifiers, removeIdentifiers, scopes } = context;
  const { source, value, key, index: index2 } = parseResult;
  const forNode = {
    type: 11,
    loc: dir.loc,
    source,
    valueAlias: value,
    keyAlias: key,
    objectIndexAlias: index2,
    parseResult,
    children: isTemplateNode(node) ? node.children : [node]
  };
  context.replaceNode(forNode);
  scopes.vFor++;
  const onExit = processCodegen && processCodegen(forNode);
  return () => {
    scopes.vFor--;
    if (onExit) onExit();
  };
}
function finalizeForParseResult(result, context) {
  if (result.finalized) return;
  result.finalized = true;
}
function createForLoopParams({ value, key, index: index2 }, memoArgs = []) {
  return createParamsList([value, key, index2, ...memoArgs]);
}
function createParamsList(args) {
  let i = args.length;
  while (i--) {
    if (args[i]) break;
  }
  return args.slice(0, i + 1).map((arg, i2) => arg || createSimpleExpression(`_`.repeat(i2 + 1), false));
}
const defaultFallback = createSimpleExpression(`undefined`, false);
const trackSlotScopes = (node, context) => {
  if (node.type === 1 && (node.tagType === 1 || node.tagType === 3)) {
    const vSlot = findDir(node, "slot");
    if (vSlot) {
      vSlot.exp;
      context.scopes.vSlot++;
      return () => {
        context.scopes.vSlot--;
      };
    }
  }
};
const trackVForSlotScopes = (node, context) => {
  let vFor;
  if (isTemplateNode(node) && node.props.some(isVSlot) && (vFor = findDir(node, "for"))) {
    const result = vFor.forParseResult;
    if (result) {
      finalizeForParseResult(result);
      const { value, key, index: index2 } = result;
      const { addIdentifiers, removeIdentifiers } = context;
      value && addIdentifiers(value);
      key && addIdentifiers(key);
      index2 && addIdentifiers(index2);
      return () => {
        value && removeIdentifiers(value);
        key && removeIdentifiers(key);
        index2 && removeIdentifiers(index2);
      };
    }
  }
};
const buildClientSlotFn = (props, _vForExp, children, loc) => createFunctionExpression(
  props,
  children,
  false,
  true,
  children.length ? children[0].loc : loc
);
function buildSlots(node, context, buildSlotFn = buildClientSlotFn) {
  context.helper(WITH_CTX);
  const { children, loc } = node;
  const slotsProperties = [];
  const dynamicSlots = [];
  let hasDynamicSlots = context.scopes.vSlot > 0 || context.scopes.vFor > 0;
  const onComponentSlot = findDir(node, "slot", true);
  if (onComponentSlot) {
    const { arg, exp } = onComponentSlot;
    if (arg && !isStaticExp(arg)) {
      hasDynamicSlots = true;
    }
    slotsProperties.push(
      createObjectProperty(
        arg || createSimpleExpression("default", true),
        buildSlotFn(exp, void 0, children, loc)
      )
    );
  }
  let hasTemplateSlots = false;
  let hasNamedDefaultSlot = false;
  const implicitDefaultChildren = [];
  const seenSlotNames = /* @__PURE__ */ new Set();
  let conditionalBranchIndex = 0;
  for (let i = 0; i < children.length; i++) {
    const slotElement = children[i];
    let slotDir;
    if (!isTemplateNode(slotElement) || !(slotDir = findDir(slotElement, "slot", true))) {
      if (slotElement.type !== 3) {
        implicitDefaultChildren.push(slotElement);
      }
      continue;
    }
    if (onComponentSlot) {
      context.onError(
        createCompilerError(37, slotDir.loc)
      );
      break;
    }
    hasTemplateSlots = true;
    const { children: slotChildren, loc: slotLoc } = slotElement;
    const {
      arg: slotName = createSimpleExpression(`default`, true),
      exp: slotProps,
      loc: dirLoc
    } = slotDir;
    let staticSlotName;
    if (isStaticExp(slotName)) {
      staticSlotName = slotName ? slotName.content : `default`;
    } else {
      hasDynamicSlots = true;
    }
    const vFor = findDir(slotElement, "for");
    const slotFunction = buildSlotFn(slotProps, vFor, slotChildren, slotLoc);
    let vIf;
    let vElse;
    if (vIf = findDir(slotElement, "if")) {
      hasDynamicSlots = true;
      dynamicSlots.push(
        createConditionalExpression(
          vIf.exp,
          buildDynamicSlot(slotName, slotFunction, conditionalBranchIndex++),
          defaultFallback
        )
      );
    } else if (vElse = findDir(
      slotElement,
      /^else(?:-if)?$/,
      true
      /* allowEmpty */
    )) {
      let j = i;
      let prev;
      while (j--) {
        prev = children[j];
        if (!isCommentOrWhitespace(prev)) {
          break;
        }
      }
      if (prev && isTemplateNode(prev) && findDir(prev, /^(?:else-)?if$/)) {
        let conditional = dynamicSlots[dynamicSlots.length - 1];
        while (conditional.alternate.type === 19) {
          conditional = conditional.alternate;
        }
        conditional.alternate = vElse.exp ? createConditionalExpression(
          vElse.exp,
          buildDynamicSlot(
            slotName,
            slotFunction,
            conditionalBranchIndex++
          ),
          defaultFallback
        ) : buildDynamicSlot(slotName, slotFunction, conditionalBranchIndex++);
      } else {
        context.onError(
          createCompilerError(30, vElse.loc)
        );
      }
    } else if (vFor) {
      hasDynamicSlots = true;
      const parseResult = vFor.forParseResult;
      if (parseResult) {
        finalizeForParseResult(parseResult);
        dynamicSlots.push(
          createCallExpression(context.helper(RENDER_LIST), [
            parseResult.source,
            createFunctionExpression(
              createForLoopParams(parseResult),
              buildDynamicSlot(slotName, slotFunction),
              true
            )
          ])
        );
      } else {
        context.onError(
          createCompilerError(
            32,
            vFor.loc
          )
        );
      }
    } else {
      if (staticSlotName) {
        if (seenSlotNames.has(staticSlotName)) {
          context.onError(
            createCompilerError(
              38,
              dirLoc
            )
          );
          continue;
        }
        seenSlotNames.add(staticSlotName);
        if (staticSlotName === "default") {
          hasNamedDefaultSlot = true;
        }
      }
      slotsProperties.push(createObjectProperty(slotName, slotFunction));
    }
  }
  if (!onComponentSlot) {
    const buildDefaultSlotProperty = (props, children2) => {
      const fn = buildSlotFn(props, void 0, children2, loc);
      if (context.compatConfig) {
        fn.isNonScopedSlot = true;
      }
      return createObjectProperty(`default`, fn);
    };
    if (!hasTemplateSlots) {
      slotsProperties.push(buildDefaultSlotProperty(void 0, children));
    } else if (implicitDefaultChildren.length && // #3766
    // with whitespace: 'preserve', whitespaces between slots will end up in
    // implicitDefaultChildren. Ignore if all implicit children are whitespaces.
    !implicitDefaultChildren.every(isWhitespaceText)) {
      if (hasNamedDefaultSlot) {
        context.onError(
          createCompilerError(
            39,
            implicitDefaultChildren[0].loc
          )
        );
      } else {
        slotsProperties.push(
          buildDefaultSlotProperty(void 0, implicitDefaultChildren)
        );
      }
    }
  }
  const slotFlag = hasDynamicSlots ? 2 : hasForwardedSlots(node.children) ? 3 : 1;
  let slots = createObjectExpression(
    slotsProperties.concat(
      createObjectProperty(
        `_`,
        // 2 = compiled but dynamic = can skip normalization, but must run diff
        // 1 = compiled and static = can skip normalization AND diff as optimized
        createSimpleExpression(
          slotFlag + ``,
          false
        )
      )
    ),
    loc
  );
  if (dynamicSlots.length) {
    slots = createCallExpression(context.helper(CREATE_SLOTS), [
      slots,
      createArrayExpression(dynamicSlots)
    ]);
  }
  return {
    slots,
    hasDynamicSlots
  };
}
function buildDynamicSlot(name2, fn, index2) {
  const props = [
    createObjectProperty(`name`, name2),
    createObjectProperty(`fn`, fn)
  ];
  if (index2 != null) {
    props.push(
      createObjectProperty(`key`, createSimpleExpression(String(index2), true))
    );
  }
  return createObjectExpression(props);
}
function hasForwardedSlots(children) {
  for (let i = 0; i < children.length; i++) {
    const child = children[i];
    switch (child.type) {
      case 1:
        if (child.tagType === 2 || hasForwardedSlots(child.children)) {
          return true;
        }
        break;
      case 9:
        if (hasForwardedSlots(child.branches)) return true;
        break;
      case 10:
      case 11:
        if (hasForwardedSlots(child.children)) return true;
        break;
    }
  }
  return false;
}
const directiveImportMap = /* @__PURE__ */ new WeakMap();
const transformElement = (node, context) => {
  return function postTransformElement() {
    node = context.currentNode;
    if (!(node.type === 1 && (node.tagType === 0 || node.tagType === 1))) {
      return;
    }
    const { tag, props } = node;
    const isComponent2 = node.tagType === 1;
    let vnodeTag = isComponent2 ? resolveComponentType(node, context) : `"${tag}"`;
    const isDynamicComponent = isObject$1(vnodeTag) && vnodeTag.callee === RESOLVE_DYNAMIC_COMPONENT;
    let vnodeProps;
    let vnodeChildren;
    let patchFlag = 0;
    let vnodeDynamicProps;
    let dynamicPropNames;
    let vnodeDirectives;
    let shouldUseBlock = (
      // dynamic component may resolve to plain elements
      isDynamicComponent || vnodeTag === TELEPORT || vnodeTag === SUSPENSE || !isComponent2 && // <svg> and <foreignObject> must be forced into blocks so that block
      // updates inside get proper isSVG flag at runtime. (#639, #643)
      // This is technically web-specific, but splitting the logic out of core
      // leads to too much unnecessary complexity.
      (tag === "svg" || tag === "foreignObject" || tag === "math")
    );
    if (props.length > 0) {
      const propsBuildResult = buildProps(
        node,
        context,
        void 0,
        isComponent2,
        isDynamicComponent
      );
      vnodeProps = propsBuildResult.props;
      patchFlag = propsBuildResult.patchFlag;
      dynamicPropNames = propsBuildResult.dynamicPropNames;
      const directives = propsBuildResult.directives;
      vnodeDirectives = directives && directives.length ? createArrayExpression(
        directives.map((dir) => buildDirectiveArgs(dir, context))
      ) : void 0;
      if (propsBuildResult.shouldUseBlock) {
        shouldUseBlock = true;
      }
    }
    if (node.children.length > 0) {
      if (vnodeTag === KEEP_ALIVE) {
        shouldUseBlock = true;
        patchFlag |= 1024;
      }
      const shouldBuildAsSlots = isComponent2 && // Teleport is not a real component and has dedicated runtime handling
      vnodeTag !== TELEPORT && // explained above.
      vnodeTag !== KEEP_ALIVE;
      if (shouldBuildAsSlots) {
        const { slots, hasDynamicSlots } = buildSlots(node, context);
        vnodeChildren = slots;
        if (hasDynamicSlots) {
          patchFlag |= 1024;
        }
      } else if (node.children.length === 1 && vnodeTag !== TELEPORT) {
        const child = node.children[0];
        const type = child.type;
        const hasDynamicTextChild = type === 5 || type === 8;
        if (hasDynamicTextChild && getConstantType(child, context) === 0) {
          patchFlag |= 1;
        }
        if (hasDynamicTextChild || type === 2) {
          vnodeChildren = child;
        } else {
          vnodeChildren = node.children;
        }
      } else {
        vnodeChildren = node.children;
      }
    }
    if (dynamicPropNames && dynamicPropNames.length) {
      vnodeDynamicProps = stringifyDynamicPropNames(dynamicPropNames);
    }
    node.codegenNode = createVNodeCall(
      context,
      vnodeTag,
      vnodeProps,
      vnodeChildren,
      patchFlag === 0 ? void 0 : patchFlag,
      vnodeDynamicProps,
      vnodeDirectives,
      !!shouldUseBlock,
      false,
      isComponent2,
      node.loc
    );
  };
};
function resolveComponentType(node, context, ssr = false) {
  let { tag } = node;
  const isExplicitDynamic = isComponentTag(tag);
  const isProp = findProp(
    node,
    "is",
    false,
    true
    /* allow empty */
  );
  if (isProp) {
    if (isExplicitDynamic || isCompatEnabled(
      "COMPILER_IS_ON_ELEMENT",
      context
    )) {
      let exp;
      if (isProp.type === 6) {
        exp = isProp.value && createSimpleExpression(isProp.value.content, true);
      } else {
        exp = isProp.exp;
        if (!exp) {
          exp = createSimpleExpression(`is`, false, isProp.arg.loc);
        }
      }
      if (exp) {
        return createCallExpression(context.helper(RESOLVE_DYNAMIC_COMPONENT), [
          exp
        ]);
      }
    } else if (isProp.type === 6 && isProp.value.content.startsWith("vue:")) {
      tag = isProp.value.content.slice(4);
    }
  }
  const builtIn = isCoreComponent(tag) || context.isBuiltInComponent(tag);
  if (builtIn) {
    if (!ssr) context.helper(builtIn);
    return builtIn;
  }
  context.helper(RESOLVE_COMPONENT);
  context.components.add(tag);
  return toValidAssetId(tag, `component`);
}
function buildProps(node, context, props = node.props, isComponent2, isDynamicComponent, ssr = false) {
  const { tag, loc: elementLoc, children } = node;
  let properties = [];
  const mergeArgs = [];
  const runtimeDirectives = [];
  const hasChildren = children.length > 0;
  let shouldUseBlock = false;
  let patchFlag = 0;
  let hasRef = false;
  let hasClassBinding = false;
  let hasStyleBinding = false;
  let hasHydrationEventBinding = false;
  let hasDynamicKeys = false;
  let hasVnodeHook = false;
  const dynamicPropNames = [];
  const pushMergeArg = (arg) => {
    if (properties.length) {
      mergeArgs.push(
        createObjectExpression(dedupeProperties(properties), elementLoc)
      );
      properties = [];
    }
    if (arg) mergeArgs.push(arg);
  };
  const pushRefVForMarker = () => {
    if (context.scopes.vFor > 0) {
      properties.push(
        createObjectProperty(
          createSimpleExpression("ref_for", true),
          createSimpleExpression("true")
        )
      );
    }
  };
  const analyzePatchFlag = ({ key, value }) => {
    if (isStaticExp(key)) {
      const name2 = key.content;
      const isEventHandler = isOn(name2);
      if (isEventHandler && (!isComponent2 || isDynamicComponent) && // omit the flag for click handlers because hydration gives click
      // dedicated fast path.
      name2.toLowerCase() !== "onclick" && // omit v-model handlers
      name2 !== "onUpdate:modelValue" && // omit onVnodeXXX hooks
      !isReservedProp(name2)) {
        hasHydrationEventBinding = true;
      }
      if (isEventHandler && isReservedProp(name2)) {
        hasVnodeHook = true;
      }
      if (isEventHandler && value.type === 14) {
        value = value.arguments[0];
      }
      if (value.type === 20 || (value.type === 4 || value.type === 8) && getConstantType(value, context) > 0) {
        return;
      }
      if (name2 === "ref") {
        hasRef = true;
      } else if (name2 === "class") {
        hasClassBinding = true;
      } else if (name2 === "style") {
        hasStyleBinding = true;
      } else if (name2 !== "key" && !dynamicPropNames.includes(name2)) {
        dynamicPropNames.push(name2);
      }
      if (isComponent2 && (name2 === "class" || name2 === "style") && !dynamicPropNames.includes(name2)) {
        dynamicPropNames.push(name2);
      }
    } else {
      hasDynamicKeys = true;
    }
  };
  for (let i = 0; i < props.length; i++) {
    const prop = props[i];
    if (prop.type === 6) {
      const { loc, name: name2, nameLoc, value } = prop;
      let isStatic = true;
      if (name2 === "ref") {
        hasRef = true;
        pushRefVForMarker();
      }
      if (name2 === "is" && (isComponentTag(tag) || value && value.content.startsWith("vue:") || isCompatEnabled(
        "COMPILER_IS_ON_ELEMENT",
        context
      ))) {
        continue;
      }
      properties.push(
        createObjectProperty(
          createSimpleExpression(name2, true, nameLoc),
          createSimpleExpression(
            value ? value.content : "",
            isStatic,
            value ? value.loc : loc
          )
        )
      );
    } else {
      const { name: name2, arg, exp, loc, modifiers } = prop;
      const isVBind = name2 === "bind";
      const isVOn = name2 === "on";
      if (name2 === "slot") {
        if (!isComponent2) {
          context.onError(
            createCompilerError(40, loc)
          );
        }
        continue;
      }
      if (name2 === "once" || name2 === "memo") {
        continue;
      }
      if (name2 === "is" || isVBind && isStaticArgOf(arg, "is") && (isComponentTag(tag) || isCompatEnabled(
        "COMPILER_IS_ON_ELEMENT",
        context
      ))) {
        continue;
      }
      if (isVOn && ssr) {
        continue;
      }
      if (
        // #938: elements with dynamic keys should be forced into blocks
        isVBind && isStaticArgOf(arg, "key") || // inline before-update hooks need to force block so that it is invoked
        // before children
        isVOn && hasChildren && isStaticArgOf(arg, "vue:before-update")
      ) {
        shouldUseBlock = true;
      }
      if (isVBind && isStaticArgOf(arg, "ref")) {
        pushRefVForMarker();
      }
      if (!arg && (isVBind || isVOn)) {
        hasDynamicKeys = true;
        if (exp) {
          if (isVBind) {
            {
              pushMergeArg();
              if (isCompatEnabled(
                "COMPILER_V_BIND_OBJECT_ORDER",
                context
              )) {
                mergeArgs.unshift(exp);
                continue;
              }
            }
            pushRefVForMarker();
            pushMergeArg();
            mergeArgs.push(exp);
          } else {
            pushMergeArg({
              type: 14,
              loc,
              callee: context.helper(TO_HANDLERS),
              arguments: isComponent2 ? [exp] : [exp, `true`]
            });
          }
        } else {
          context.onError(
            createCompilerError(
              isVBind ? 34 : 35,
              loc
            )
          );
        }
        continue;
      }
      if (isVBind && modifiers.some((mod2) => mod2.content === "prop")) {
        patchFlag |= 32;
      }
      const directiveTransform = context.directiveTransforms[name2];
      if (directiveTransform) {
        const { props: props2, needRuntime } = directiveTransform(prop, node, context);
        !ssr && props2.forEach(analyzePatchFlag);
        if (isVOn && arg && !isStaticExp(arg)) {
          pushMergeArg(createObjectExpression(props2, elementLoc));
        } else {
          properties.push(...props2);
        }
        if (needRuntime) {
          runtimeDirectives.push(prop);
          if (isSymbol(needRuntime)) {
            directiveImportMap.set(prop, needRuntime);
          }
        }
      } else if (!isBuiltInDirective(name2)) {
        runtimeDirectives.push(prop);
        if (hasChildren) {
          shouldUseBlock = true;
        }
      }
    }
  }
  let propsExpression = void 0;
  if (mergeArgs.length) {
    pushMergeArg();
    if (mergeArgs.length > 1) {
      propsExpression = createCallExpression(
        context.helper(MERGE_PROPS),
        mergeArgs,
        elementLoc
      );
    } else {
      propsExpression = mergeArgs[0];
    }
  } else if (properties.length) {
    propsExpression = createObjectExpression(
      dedupeProperties(properties),
      elementLoc
    );
  }
  if (hasDynamicKeys) {
    patchFlag |= 16;
  } else {
    if (hasClassBinding && !isComponent2) {
      patchFlag |= 2;
    }
    if (hasStyleBinding && !isComponent2) {
      patchFlag |= 4;
    }
    if (dynamicPropNames.length) {
      patchFlag |= 8;
    }
    if (hasHydrationEventBinding) {
      patchFlag |= 32;
    }
  }
  if (!shouldUseBlock && (patchFlag === 0 || patchFlag === 32) && (hasRef || hasVnodeHook || runtimeDirectives.length > 0)) {
    patchFlag |= 512;
  }
  if (!context.inSSR && propsExpression) {
    switch (propsExpression.type) {
      case 15:
        let classKeyIndex = -1;
        let styleKeyIndex = -1;
        let hasDynamicKey = false;
        for (let i = 0; i < propsExpression.properties.length; i++) {
          const key = propsExpression.properties[i].key;
          if (isStaticExp(key)) {
            if (key.content === "class") {
              classKeyIndex = i;
            } else if (key.content === "style") {
              styleKeyIndex = i;
            }
          } else if (!key.isHandlerKey) {
            hasDynamicKey = true;
          }
        }
        const classProp = propsExpression.properties[classKeyIndex];
        const styleProp = propsExpression.properties[styleKeyIndex];
        if (!hasDynamicKey) {
          if (classProp && !isStaticExp(classProp.value)) {
            classProp.value = createCallExpression(
              context.helper(NORMALIZE_CLASS),
              [classProp.value]
            );
          }
          if (styleProp && // the static style is compiled into an object,
          // so use `hasStyleBinding` to ensure that it is a dynamic style binding
          (hasStyleBinding || styleProp.value.type === 4 && styleProp.value.content.trim()[0] === `[` || // v-bind:style and style both exist,
          // v-bind:style with static literal object
          styleProp.value.type === 17)) {
            styleProp.value = createCallExpression(
              context.helper(NORMALIZE_STYLE),
              [styleProp.value]
            );
          }
        } else {
          propsExpression = createCallExpression(
            context.helper(NORMALIZE_PROPS),
            [propsExpression]
          );
        }
        break;
      case 14:
        break;
      default:
        propsExpression = createCallExpression(
          context.helper(NORMALIZE_PROPS),
          [
            createCallExpression(context.helper(GUARD_REACTIVE_PROPS), [
              propsExpression
            ])
          ]
        );
        break;
    }
  }
  return {
    props: propsExpression,
    directives: runtimeDirectives,
    patchFlag,
    dynamicPropNames,
    shouldUseBlock
  };
}
function dedupeProperties(properties) {
  const knownProps = /* @__PURE__ */ new Map();
  const deduped = [];
  for (let i = 0; i < properties.length; i++) {
    const prop = properties[i];
    if (prop.key.type === 8 || !prop.key.isStatic) {
      deduped.push(prop);
      continue;
    }
    const name2 = prop.key.content;
    const existing = knownProps.get(name2);
    if (existing) {
      if (name2 === "style" || name2 === "class" || isOn(name2)) {
        mergeAsArray(existing, prop);
      }
    } else {
      knownProps.set(name2, prop);
      deduped.push(prop);
    }
  }
  return deduped;
}
function mergeAsArray(existing, incoming) {
  if (existing.value.type === 17) {
    existing.value.elements.push(incoming.value);
  } else {
    existing.value = createArrayExpression(
      [existing.value, incoming.value],
      existing.loc
    );
  }
}
function buildDirectiveArgs(dir, context) {
  const dirArgs = [];
  const runtime = directiveImportMap.get(dir);
  if (runtime) {
    dirArgs.push(context.helperString(runtime));
  } else {
    {
      context.helper(RESOLVE_DIRECTIVE);
      context.directives.add(dir.name);
      dirArgs.push(toValidAssetId(dir.name, `directive`));
    }
  }
  const { loc } = dir;
  if (dir.exp) dirArgs.push(dir.exp);
  if (dir.arg) {
    if (!dir.exp) {
      dirArgs.push(`void 0`);
    }
    dirArgs.push(dir.arg);
  }
  if (Object.keys(dir.modifiers).length) {
    if (!dir.arg) {
      if (!dir.exp) {
        dirArgs.push(`void 0`);
      }
      dirArgs.push(`void 0`);
    }
    const trueExpression = createSimpleExpression(`true`, false, loc);
    dirArgs.push(
      createObjectExpression(
        dir.modifiers.map(
          (modifier) => createObjectProperty(modifier, trueExpression)
        ),
        loc
      )
    );
  }
  return createArrayExpression(dirArgs, dir.loc);
}
function stringifyDynamicPropNames(props) {
  let propsNamesString = `[`;
  for (let i = 0, l = props.length; i < l; i++) {
    propsNamesString += JSON.stringify(props[i]);
    if (i < l - 1) propsNamesString += ", ";
  }
  return propsNamesString + `]`;
}
function isComponentTag(tag) {
  return tag === "component" || tag === "Component";
}
const transformSlotOutlet = (node, context) => {
  if (isSlotOutlet(node)) {
    const { children, loc } = node;
    const { slotName, slotProps } = processSlotOutlet(node, context);
    const slotArgs = [
      context.prefixIdentifiers ? `_ctx.$slots` : `$slots`,
      slotName,
      "{}",
      "undefined",
      "true"
    ];
    let expectedLen = 2;
    if (slotProps) {
      slotArgs[2] = slotProps;
      expectedLen = 3;
    }
    if (children.length) {
      slotArgs[3] = createFunctionExpression([], children, false, false, loc);
      expectedLen = 4;
    }
    if (context.scopeId && !context.slotted) {
      expectedLen = 5;
    }
    slotArgs.splice(expectedLen);
    node.codegenNode = createCallExpression(
      context.helper(RENDER_SLOT),
      slotArgs,
      loc
    );
  }
};
function processSlotOutlet(node, context) {
  let slotName = `"default"`;
  let slotProps = void 0;
  const nonNameProps = [];
  for (let i = 0; i < node.props.length; i++) {
    const p = node.props[i];
    if (p.type === 6) {
      if (p.value) {
        if (p.name === "name") {
          slotName = JSON.stringify(p.value.content);
        } else {
          p.name = camelize(p.name);
          nonNameProps.push(p);
        }
      }
    } else {
      if (p.name === "bind" && isStaticArgOf(p.arg, "name")) {
        if (p.exp) {
          slotName = p.exp;
        } else if (p.arg && p.arg.type === 4) {
          const name2 = camelize(p.arg.content);
          slotName = p.exp = createSimpleExpression(name2, false, p.arg.loc);
        }
      } else {
        if (p.name === "bind" && p.arg && isStaticExp(p.arg)) {
          p.arg.content = camelize(p.arg.content);
        }
        nonNameProps.push(p);
      }
    }
  }
  if (nonNameProps.length > 0) {
    const { props, directives } = buildProps(
      node,
      context,
      nonNameProps,
      false,
      false
    );
    slotProps = props;
    if (directives.length) {
      context.onError(
        createCompilerError(
          36,
          directives[0].loc
        )
      );
    }
  }
  return {
    slotName,
    slotProps
  };
}
const transformOn$1 = (dir, node, context, augmentor) => {
  const { loc, modifiers, arg } = dir;
  if (!dir.exp && !modifiers.length) {
    context.onError(createCompilerError(35, loc));
  }
  let eventName;
  if (arg.type === 4) {
    if (arg.isStatic) {
      let rawName = arg.content;
      if (rawName.startsWith("vue:")) {
        rawName = `vnode-${rawName.slice(4)}`;
      }
      const eventString = node.tagType !== 0 || rawName.startsWith("vnode") || !/[A-Z]/.test(rawName) ? (
        // for non-element and vnode lifecycle event listeners, auto convert
        // it to camelCase. See issue #2249
        toHandlerKey(camelize(rawName))
      ) : (
        // preserve case for plain element listeners that have uppercase
        // letters, as these may be custom elements' custom events
        `on:${rawName}`
      );
      eventName = createSimpleExpression(eventString, true, arg.loc);
    } else {
      eventName = createCompoundExpression([
        `${context.helperString(TO_HANDLER_KEY)}(`,
        arg,
        `)`
      ]);
    }
  } else {
    eventName = arg;
    eventName.children.unshift(`${context.helperString(TO_HANDLER_KEY)}(`);
    eventName.children.push(`)`);
  }
  let exp = dir.exp;
  if (exp && !exp.content.trim()) {
    exp = void 0;
  }
  let shouldCache = context.cacheHandlers && !exp && !context.inVOnce;
  if (exp) {
    const isMemberExp = isMemberExpression(exp);
    const isInlineStatement = !(isMemberExp || isFnExpression(exp));
    const hasMultipleStatements = exp.content.includes(`;`);
    if (isInlineStatement || shouldCache && isMemberExp) {
      exp = createCompoundExpression([
        `${isInlineStatement ? `$event` : `${``}(...args)`} => ${hasMultipleStatements ? `{` : `(`}`,
        exp,
        hasMultipleStatements ? `}` : `)`
      ]);
    }
  }
  let ret = {
    props: [
      createObjectProperty(
        eventName,
        exp || createSimpleExpression(`() => {}`, false, loc)
      )
    ]
  };
  if (augmentor) {
    ret = augmentor(ret);
  }
  if (shouldCache) {
    ret.props[0].value = context.cache(ret.props[0].value);
  }
  ret.props.forEach((p) => p.key.isHandlerKey = true);
  return ret;
};
const transformBind = (dir, _node, context) => {
  const { modifiers, loc } = dir;
  const arg = dir.arg;
  let { exp } = dir;
  if (exp && exp.type === 4 && !exp.content.trim()) {
    {
      exp = void 0;
    }
  }
  if (arg.type !== 4) {
    arg.children.unshift(`(`);
    arg.children.push(`) || ""`);
  } else if (!arg.isStatic) {
    arg.content = arg.content ? `${arg.content} || ""` : `""`;
  }
  if (modifiers.some((mod2) => mod2.content === "camel")) {
    if (arg.type === 4) {
      if (arg.isStatic) {
        arg.content = camelize(arg.content);
      } else {
        arg.content = `${context.helperString(CAMELIZE)}(${arg.content})`;
      }
    } else {
      arg.children.unshift(`${context.helperString(CAMELIZE)}(`);
      arg.children.push(`)`);
    }
  }
  if (!context.inSSR) {
    if (modifiers.some((mod2) => mod2.content === "prop")) {
      injectPrefix(arg, ".");
    }
    if (modifiers.some((mod2) => mod2.content === "attr")) {
      injectPrefix(arg, "^");
    }
  }
  return {
    props: [createObjectProperty(arg, exp)]
  };
};
const injectPrefix = (arg, prefix) => {
  if (arg.type === 4) {
    if (arg.isStatic) {
      arg.content = prefix + arg.content;
    } else {
      arg.content = `\`${prefix}\${${arg.content}}\``;
    }
  } else {
    arg.children.unshift(`'${prefix}' + (`);
    arg.children.push(`)`);
  }
};
const transformText = (node, context) => {
  if (node.type === 0 || node.type === 1 || node.type === 11 || node.type === 10) {
    return () => {
      const children = node.children;
      let currentContainer = void 0;
      let hasText = false;
      for (let i = 0; i < children.length; i++) {
        const child = children[i];
        if (isText$1(child)) {
          hasText = true;
          for (let j = i + 1; j < children.length; j++) {
            const next = children[j];
            if (isText$1(next)) {
              if (!currentContainer) {
                currentContainer = children[i] = createCompoundExpression(
                  [child],
                  child.loc
                );
              }
              currentContainer.children.push(` + `, next);
              children.splice(j, 1);
              j--;
            } else {
              currentContainer = void 0;
              break;
            }
          }
        }
      }
      if (!hasText || // if this is a plain element with a single text child, leave it
      // as-is since the runtime has dedicated fast path for this by directly
      // setting textContent of the element.
      // for component root it's always normalized anyway.
      children.length === 1 && (node.type === 0 || node.type === 1 && node.tagType === 0 && // #3756
      // custom directives can potentially add DOM elements arbitrarily,
      // we need to avoid setting textContent of the element at runtime
      // to avoid accidentally overwriting the DOM elements added
      // by the user through custom directives.
      !node.props.find(
        (p) => p.type === 7 && !context.directiveTransforms[p.name]
      ) && // in compat mode, <template> tags with no special directives
      // will be rendered as a fragment so its children must be
      // converted into vnodes.
      !(node.tag === "template"))) {
        return;
      }
      for (let i = 0; i < children.length; i++) {
        const child = children[i];
        if (isText$1(child) || child.type === 8) {
          const callArgs = [];
          if (child.type !== 2 || child.content !== " ") {
            callArgs.push(child);
          }
          if (!context.ssr && getConstantType(child, context) === 0) {
            callArgs.push(
              `1`
            );
          }
          children[i] = {
            type: 12,
            content: child,
            loc: child.loc,
            codegenNode: createCallExpression(
              context.helper(CREATE_TEXT),
              callArgs
            )
          };
        }
      }
    };
  }
};
const seen$1 = /* @__PURE__ */ new WeakSet();
const transformOnce = (node, context) => {
  if (node.type === 1 && findDir(node, "once", true)) {
    if (seen$1.has(node) || context.inVOnce || context.inSSR) {
      return;
    }
    seen$1.add(node);
    context.inVOnce = true;
    context.helper(SET_BLOCK_TRACKING);
    return () => {
      context.inVOnce = false;
      const cur = context.currentNode;
      if (cur.codegenNode) {
        cur.codegenNode = context.cache(
          cur.codegenNode,
          true,
          true
        );
      }
    };
  }
};
const transformModel$1 = (dir, node, context) => {
  const { exp, arg } = dir;
  if (!exp) {
    context.onError(
      createCompilerError(41, dir.loc)
    );
    return createTransformProps();
  }
  const rawExp = exp.loc.source.trim();
  const expString = exp.type === 4 ? exp.content : rawExp;
  const bindingType = context.bindingMetadata[rawExp];
  if (bindingType === "props" || bindingType === "props-aliased") {
    context.onError(createCompilerError(44, exp.loc));
    return createTransformProps();
  }
  if (bindingType === "literal-const" || bindingType === "setup-const") {
    context.onError(createCompilerError(45, exp.loc));
    return createTransformProps();
  }
  if (!expString.trim() || !isMemberExpression(exp) && true) {
    context.onError(
      createCompilerError(42, exp.loc)
    );
    return createTransformProps();
  }
  const propName = arg ? arg : createSimpleExpression("modelValue", true);
  const eventName = arg ? isStaticExp(arg) ? `onUpdate:${camelize(arg.content)}` : createCompoundExpression(['"onUpdate:" + ', arg]) : `onUpdate:modelValue`;
  let assignmentExp;
  const eventArg = context.isTS ? `($event: any)` : `$event`;
  {
    assignmentExp = createCompoundExpression([
      `${eventArg} => ((`,
      exp,
      `) = $event)`
    ]);
  }
  const props = [
    // modelValue: foo
    createObjectProperty(propName, dir.exp),
    // "onUpdate:modelValue": $event => (foo = $event)
    createObjectProperty(eventName, assignmentExp)
  ];
  if (dir.modifiers.length && node.tagType === 1) {
    const modifiers = dir.modifiers.map((m2) => m2.content).map((m2) => (isSimpleIdentifier(m2) ? m2 : JSON.stringify(m2)) + `: true`).join(`, `);
    const modifiersKey = arg ? isStaticExp(arg) ? `${arg.content}Modifiers` : createCompoundExpression([arg, ' + "Modifiers"']) : `modelModifiers`;
    props.push(
      createObjectProperty(
        modifiersKey,
        createSimpleExpression(
          `{ ${modifiers} }`,
          false,
          dir.loc,
          2
        )
      )
    );
  }
  return createTransformProps(props);
};
function createTransformProps(props = []) {
  return { props };
}
const validDivisionCharRE = /[\w).+\-_$\]]/;
const transformFilter = (node, context) => {
  if (!isCompatEnabled("COMPILER_FILTERS", context)) {
    return;
  }
  if (node.type === 5) {
    rewriteFilter(node.content, context);
  } else if (node.type === 1) {
    node.props.forEach((prop) => {
      if (prop.type === 7 && prop.name !== "for" && prop.exp) {
        rewriteFilter(prop.exp, context);
      }
    });
  }
};
function rewriteFilter(node, context) {
  if (node.type === 4) {
    parseFilter(node, context);
  } else {
    for (let i = 0; i < node.children.length; i++) {
      const child = node.children[i];
      if (typeof child !== "object") continue;
      if (child.type === 4) {
        parseFilter(child, context);
      } else if (child.type === 8) {
        rewriteFilter(node, context);
      } else if (child.type === 5) {
        rewriteFilter(child.content, context);
      }
    }
  }
}
function parseFilter(node, context) {
  const exp = node.content;
  let inSingle = false;
  let inDouble = false;
  let inTemplateString = false;
  let inRegex = false;
  let curly = 0;
  let square = 0;
  let paren = 0;
  let lastFilterIndex = 0;
  let c, prev, i, expression, filters = [];
  for (i = 0; i < exp.length; i++) {
    prev = c;
    c = exp.charCodeAt(i);
    if (inSingle) {
      if (c === 39 && prev !== 92) inSingle = false;
    } else if (inDouble) {
      if (c === 34 && prev !== 92) inDouble = false;
    } else if (inTemplateString) {
      if (c === 96 && prev !== 92) inTemplateString = false;
    } else if (inRegex) {
      if (c === 47 && prev !== 92) inRegex = false;
    } else if (c === 124 && // pipe
    exp.charCodeAt(i + 1) !== 124 && exp.charCodeAt(i - 1) !== 124 && !curly && !square && !paren) {
      if (expression === void 0) {
        lastFilterIndex = i + 1;
        expression = exp.slice(0, i).trim();
      } else {
        pushFilter();
      }
    } else {
      switch (c) {
        case 34:
          inDouble = true;
          break;
        // "
        case 39:
          inSingle = true;
          break;
        // '
        case 96:
          inTemplateString = true;
          break;
        // `
        case 40:
          paren++;
          break;
        // (
        case 41:
          paren--;
          break;
        // )
        case 91:
          square++;
          break;
        // [
        case 93:
          square--;
          break;
        // ]
        case 123:
          curly++;
          break;
        // {
        case 125:
          curly--;
          break;
      }
      if (c === 47) {
        let j = i - 1;
        let p;
        for (; j >= 0; j--) {
          p = exp.charAt(j);
          if (p !== " ") break;
        }
        if (!p || !validDivisionCharRE.test(p)) {
          inRegex = true;
        }
      }
    }
  }
  if (expression === void 0) {
    expression = exp.slice(0, i).trim();
  } else if (lastFilterIndex !== 0) {
    pushFilter();
  }
  function pushFilter() {
    filters.push(exp.slice(lastFilterIndex, i).trim());
    lastFilterIndex = i + 1;
  }
  if (filters.length) {
    for (i = 0; i < filters.length; i++) {
      expression = wrapFilter(expression, filters[i], context);
    }
    node.content = expression;
    node.ast = void 0;
  }
}
function wrapFilter(exp, filter, context) {
  context.helper(RESOLVE_FILTER);
  const i = filter.indexOf("(");
  if (i < 0) {
    context.filters.add(filter);
    return `${toValidAssetId(filter, "filter")}(${exp})`;
  } else {
    const name2 = filter.slice(0, i);
    const args = filter.slice(i + 1);
    context.filters.add(name2);
    return `${toValidAssetId(name2, "filter")}(${exp}${args !== ")" ? "," + args : args}`;
  }
}
const seen = /* @__PURE__ */ new WeakSet();
const transformMemo = (node, context) => {
  if (node.type === 1) {
    const dir = findDir(node, "memo");
    if (!dir || seen.has(node) || context.inSSR) {
      return;
    }
    seen.add(node);
    return () => {
      const codegenNode = node.codegenNode || context.currentNode.codegenNode;
      if (codegenNode && codegenNode.type === 13) {
        if (node.tagType !== 1) {
          convertToBlock(codegenNode, context);
        }
        node.codegenNode = createCallExpression(context.helper(WITH_MEMO), [
          dir.exp,
          createFunctionExpression(void 0, codegenNode),
          `_cache`,
          String(context.cached.length)
        ]);
        context.cached.push(null);
      }
    };
  }
};
const transformVBindShorthand = (node, context) => {
  if (node.type === 1) {
    for (const prop of node.props) {
      if (prop.type === 7 && prop.name === "bind" && (!prop.exp || // #13930 :foo in in-DOM templates will be parsed into :foo="" by browser
      prop.exp.type === 4 && !prop.exp.content.trim()) && prop.arg) {
        const arg = prop.arg;
        if (arg.type !== 4 || !arg.isStatic) {
          context.onError(
            createCompilerError(
              53,
              arg.loc
            )
          );
          prop.exp = createSimpleExpression("", true, arg.loc);
        } else {
          const propName = camelize(arg.content);
          if (validFirstIdentCharRE.test(propName[0]) || // allow hyphen first char for https://github.com/vuejs/language-tools/pull/3424
          propName[0] === "-") {
            prop.exp = createSimpleExpression(propName, false, arg.loc);
          }
        }
      }
    }
  }
};
function getBaseTransformPreset(prefixIdentifiers) {
  return [
    [
      transformVBindShorthand,
      transformOnce,
      transformIf,
      transformMemo,
      transformFor,
      ...[transformFilter],
      ...[],
      transformSlotOutlet,
      transformElement,
      trackSlotScopes,
      transformText
    ],
    {
      on: transformOn$1,
      bind: transformBind,
      model: transformModel$1
    }
  ];
}
function baseCompile(source, options2 = {}) {
  const onError = options2.onError || defaultOnError;
  const isModuleMode = options2.mode === "module";
  {
    if (options2.prefixIdentifiers === true) {
      onError(createCompilerError(48));
    } else if (isModuleMode) {
      onError(createCompilerError(49));
    }
  }
  const prefixIdentifiers = false;
  if (options2.cacheHandlers) {
    onError(createCompilerError(50));
  }
  if (options2.scopeId && !isModuleMode) {
    onError(createCompilerError(51));
  }
  const resolvedOptions = extend$2({}, options2, {
    prefixIdentifiers
  });
  const ast = isString$1(source) ? baseParse(source, resolvedOptions) : source;
  const [nodeTransforms, directiveTransforms] = getBaseTransformPreset();
  transform(
    ast,
    extend$2({}, resolvedOptions, {
      nodeTransforms: [
        ...nodeTransforms,
        ...options2.nodeTransforms || []
        // user transforms
      ],
      directiveTransforms: extend$2(
        {},
        directiveTransforms,
        options2.directiveTransforms || {}
        // user transforms
      )
    })
  );
  return generate$1(ast, resolvedOptions);
}
const BindingTypes = {
  "DATA": "data",
  "PROPS": "props",
  "PROPS_ALIASED": "props-aliased",
  "SETUP_LET": "setup-let",
  "SETUP_CONST": "setup-const",
  "SETUP_REACTIVE_CONST": "setup-reactive-const",
  "SETUP_MAYBE_REF": "setup-maybe-ref",
  "SETUP_REF": "setup-ref",
  "OPTIONS": "options",
  "LITERAL_CONST": "literal-const"
};
const noopDirectiveTransform = () => ({ props: [] });
const V_MODEL_RADIO = /* @__PURE__ */ Symbol(``);
const V_MODEL_CHECKBOX = /* @__PURE__ */ Symbol(
  ``
);
const V_MODEL_TEXT = /* @__PURE__ */ Symbol(``);
const V_MODEL_SELECT = /* @__PURE__ */ Symbol(
  ``
);
const V_MODEL_DYNAMIC = /* @__PURE__ */ Symbol(
  ``
);
const V_ON_WITH_MODIFIERS = /* @__PURE__ */ Symbol(
  ``
);
const V_ON_WITH_KEYS = /* @__PURE__ */ Symbol(
  ``
);
const V_SHOW = /* @__PURE__ */ Symbol(``);
const TRANSITION = /* @__PURE__ */ Symbol(``);
const TRANSITION_GROUP = /* @__PURE__ */ Symbol(
  ``
);
registerRuntimeHelpers({
  [V_MODEL_RADIO]: `vModelRadio`,
  [V_MODEL_CHECKBOX]: `vModelCheckbox`,
  [V_MODEL_TEXT]: `vModelText`,
  [V_MODEL_SELECT]: `vModelSelect`,
  [V_MODEL_DYNAMIC]: `vModelDynamic`,
  [V_ON_WITH_MODIFIERS]: `withModifiers`,
  [V_ON_WITH_KEYS]: `withKeys`,
  [V_SHOW]: `vShow`,
  [TRANSITION]: `Transition`,
  [TRANSITION_GROUP]: `TransitionGroup`
});
let decoder;
function decodeHtmlBrowser(raw, asAttr = false) {
  if (!decoder) {
    decoder = document.createElement("div");
  }
  if (asAttr) {
    decoder.innerHTML = `<div foo="${raw.replace(/"/g, "&quot;")}">`;
    return decoder.children[0].getAttribute("foo");
  } else {
    decoder.innerHTML = raw;
    return decoder.textContent;
  }
}
const parserOptions = {
  parseMode: "html",
  isVoidTag,
  isNativeTag: (tag) => isHTMLTag(tag) || isSVGTag(tag) || isMathMLTag(tag),
  isPreTag: (tag) => tag === "pre",
  isIgnoreNewlineTag: (tag) => tag === "pre" || tag === "textarea",
  decodeEntities: decodeHtmlBrowser,
  isBuiltInComponent: (tag) => {
    if (tag === "Transition" || tag === "transition") {
      return TRANSITION;
    } else if (tag === "TransitionGroup" || tag === "transition-group") {
      return TRANSITION_GROUP;
    }
  },
  // https://html.spec.whatwg.org/multipage/parsing.html#tree-construction-dispatcher
  getNamespace(tag, parent, rootNamespace) {
    let ns = parent ? parent.ns : rootNamespace;
    if (parent && ns === 2) {
      if (parent.tag === "annotation-xml") {
        if (tag === "svg") {
          return 1;
        }
        if (parent.props.some(
          (a) => a.type === 6 && a.name === "encoding" && a.value != null && (a.value.content === "text/html" || a.value.content === "application/xhtml+xml")
        )) {
          ns = 0;
        }
      } else if (/^m(?:[ions]|text)$/.test(parent.tag) && tag !== "mglyph" && tag !== "malignmark") {
        ns = 0;
      }
    } else if (parent && ns === 1) {
      if (parent.tag === "foreignObject" || parent.tag === "desc" || parent.tag === "title") {
        ns = 0;
      }
    }
    if (ns === 0) {
      if (tag === "svg") {
        return 1;
      }
      if (tag === "math") {
        return 2;
      }
    }
    return ns;
  }
};
const transformStyle = (node) => {
  if (node.type === 1) {
    node.props.forEach((p, i) => {
      if (p.type === 6 && p.name === "style" && p.value) {
        node.props[i] = {
          type: 7,
          name: `bind`,
          arg: createSimpleExpression(`style`, true, p.loc),
          exp: parseInlineCSS(p.value.content, p.loc),
          modifiers: [],
          loc: p.loc
        };
      }
    });
  }
};
const parseInlineCSS = (cssText, loc) => {
  const normalized = parseStringStyle(cssText);
  return createSimpleExpression(
    JSON.stringify(normalized),
    false,
    loc,
    3
  );
};
function createDOMCompilerError(code, loc) {
  return createCompilerError(
    code,
    loc
  );
}
const DOMErrorCodes = {
  "X_V_HTML_NO_EXPRESSION": 54,
  "54": "X_V_HTML_NO_EXPRESSION",
  "X_V_HTML_WITH_CHILDREN": 55,
  "55": "X_V_HTML_WITH_CHILDREN",
  "X_V_TEXT_NO_EXPRESSION": 56,
  "56": "X_V_TEXT_NO_EXPRESSION",
  "X_V_TEXT_WITH_CHILDREN": 57,
  "57": "X_V_TEXT_WITH_CHILDREN",
  "X_V_MODEL_ON_INVALID_ELEMENT": 58,
  "58": "X_V_MODEL_ON_INVALID_ELEMENT",
  "X_V_MODEL_ARG_ON_ELEMENT": 59,
  "59": "X_V_MODEL_ARG_ON_ELEMENT",
  "X_V_MODEL_ON_FILE_INPUT_ELEMENT": 60,
  "60": "X_V_MODEL_ON_FILE_INPUT_ELEMENT",
  "X_V_MODEL_UNNECESSARY_VALUE": 61,
  "61": "X_V_MODEL_UNNECESSARY_VALUE",
  "X_V_SHOW_NO_EXPRESSION": 62,
  "62": "X_V_SHOW_NO_EXPRESSION",
  "X_TRANSITION_INVALID_CHILDREN": 63,
  "63": "X_TRANSITION_INVALID_CHILDREN",
  "X_IGNORED_SIDE_EFFECT_TAG": 64,
  "64": "X_IGNORED_SIDE_EFFECT_TAG",
  "__EXTEND_POINT__": 65,
  "65": "__EXTEND_POINT__"
};
const DOMErrorMessages = {
  [54]: `v-html is missing expression.`,
  [55]: `v-html will override element children.`,
  [56]: `v-text is missing expression.`,
  [57]: `v-text will override element children.`,
  [58]: `v-model can only be used on <input>, <textarea> and <select> elements.`,
  [59]: `v-model argument is not supported on plain elements.`,
  [60]: `v-model cannot be used on file inputs since they are read-only. Use a v-on:change listener instead.`,
  [61]: `Unnecessary value binding used alongside v-model. It will interfere with v-model's behavior.`,
  [62]: `v-show is missing expression.`,
  [63]: `<Transition> expects exactly one child element or component.`,
  [64]: `Tags with side effect (<script> and <style>) are ignored in client component templates.`
};
const transformVHtml = (dir, node, context) => {
  const { exp, loc } = dir;
  if (!exp) {
    context.onError(
      createDOMCompilerError(54, loc)
    );
  }
  if (node.children.length) {
    context.onError(
      createDOMCompilerError(55, loc)
    );
    node.children.length = 0;
  }
  return {
    props: [
      createObjectProperty(
        createSimpleExpression(`innerHTML`, true, loc),
        exp || createSimpleExpression("", true)
      )
    ]
  };
};
const transformVText = (dir, node, context) => {
  const { exp, loc } = dir;
  if (!exp) {
    context.onError(
      createDOMCompilerError(56, loc)
    );
  }
  if (node.children.length) {
    context.onError(
      createDOMCompilerError(57, loc)
    );
    node.children.length = 0;
  }
  return {
    props: [
      createObjectProperty(
        createSimpleExpression(`textContent`, true),
        exp ? getConstantType(exp, context) > 0 ? exp : createCallExpression(
          context.helperString(TO_DISPLAY_STRING),
          [exp],
          loc
        ) : createSimpleExpression("", true)
      )
    ]
  };
};
const transformModel = (dir, node, context) => {
  const baseResult = transformModel$1(dir, node, context);
  if (!baseResult.props.length || node.tagType === 1) {
    return baseResult;
  }
  if (dir.arg) {
    context.onError(
      createDOMCompilerError(
        59,
        dir.arg.loc
      )
    );
  }
  const { tag } = node;
  const isCustomElement = context.isCustomElement(tag);
  if (tag === "input" || tag === "textarea" || tag === "select" || isCustomElement) {
    let directiveToUse = V_MODEL_TEXT;
    let isInvalidType = false;
    if (tag === "input" || isCustomElement) {
      const type = findProp(node, `type`);
      if (type) {
        if (type.type === 7) {
          directiveToUse = V_MODEL_DYNAMIC;
        } else if (type.value) {
          switch (type.value.content) {
            case "radio":
              directiveToUse = V_MODEL_RADIO;
              break;
            case "checkbox":
              directiveToUse = V_MODEL_CHECKBOX;
              break;
            case "file":
              isInvalidType = true;
              context.onError(
                createDOMCompilerError(
                  60,
                  dir.loc
                )
              );
              break;
          }
        }
      } else if (hasDynamicKeyVBind(node)) {
        directiveToUse = V_MODEL_DYNAMIC;
      } else ;
    } else if (tag === "select") {
      directiveToUse = V_MODEL_SELECT;
    } else ;
    if (!isInvalidType) {
      baseResult.needRuntime = context.helper(directiveToUse);
    }
  } else {
    context.onError(
      createDOMCompilerError(
        58,
        dir.loc
      )
    );
  }
  baseResult.props = baseResult.props.filter(
    (p) => !(p.key.type === 4 && p.key.content === "modelValue")
  );
  return baseResult;
};
const isEventOptionModifier = /* @__PURE__ */ makeMap(`passive,once,capture`);
const isNonKeyModifier = /* @__PURE__ */ makeMap(
  // event propagation management
  `stop,prevent,self,ctrl,shift,alt,meta,exact,middle`
);
const maybeKeyModifier = /* @__PURE__ */ makeMap("left,right");
const isKeyboardEvent = /* @__PURE__ */ makeMap(`onkeyup,onkeydown,onkeypress`);
const resolveModifiers = (key, modifiers, context, loc) => {
  const keyModifiers = [];
  const nonKeyModifiers = [];
  const eventOptionModifiers = [];
  for (let i = 0; i < modifiers.length; i++) {
    const modifier = modifiers[i].content;
    if (modifier === "native" && checkCompatEnabled(
      "COMPILER_V_ON_NATIVE",
      context
    )) {
      eventOptionModifiers.push(modifier);
    } else if (isEventOptionModifier(modifier)) {
      eventOptionModifiers.push(modifier);
    } else {
      if (maybeKeyModifier(modifier)) {
        if (isStaticExp(key)) {
          if (isKeyboardEvent(key.content.toLowerCase())) {
            keyModifiers.push(modifier);
          } else {
            nonKeyModifiers.push(modifier);
          }
        } else {
          keyModifiers.push(modifier);
          nonKeyModifiers.push(modifier);
        }
      } else {
        if (isNonKeyModifier(modifier)) {
          nonKeyModifiers.push(modifier);
        } else {
          keyModifiers.push(modifier);
        }
      }
    }
  }
  return {
    keyModifiers,
    nonKeyModifiers,
    eventOptionModifiers
  };
};
const transformClick = (key, event) => {
  const isStaticClick = isStaticExp(key) && key.content.toLowerCase() === "onclick";
  return isStaticClick ? createSimpleExpression(event, true) : key.type !== 4 ? createCompoundExpression([
    `(`,
    key,
    `) === "onClick" ? "${event}" : (`,
    key,
    `)`
  ]) : key;
};
const transformOn = (dir, node, context) => {
  return transformOn$1(dir, node, context, (baseResult) => {
    const { modifiers } = dir;
    if (!modifiers.length) return baseResult;
    let { key, value: handlerExp } = baseResult.props[0];
    const { keyModifiers, nonKeyModifiers, eventOptionModifiers } = resolveModifiers(key, modifiers, context, dir.loc);
    if (nonKeyModifiers.includes("right")) {
      key = transformClick(key, `onContextmenu`);
    }
    if (nonKeyModifiers.includes("middle")) {
      key = transformClick(key, `onMouseup`);
    }
    if (nonKeyModifiers.length) {
      handlerExp = createCallExpression(context.helper(V_ON_WITH_MODIFIERS), [
        handlerExp,
        JSON.stringify(nonKeyModifiers)
      ]);
    }
    if (keyModifiers.length && // if event name is dynamic, always wrap with keys guard
    (!isStaticExp(key) || isKeyboardEvent(key.content.toLowerCase()))) {
      handlerExp = createCallExpression(context.helper(V_ON_WITH_KEYS), [
        handlerExp,
        JSON.stringify(keyModifiers)
      ]);
    }
    if (eventOptionModifiers.length) {
      const modifierPostfix = eventOptionModifiers.map(capitalize).join("");
      key = isStaticExp(key) ? createSimpleExpression(`${key.content}${modifierPostfix}`, true) : createCompoundExpression([`(`, key, `) + "${modifierPostfix}"`]);
    }
    return {
      props: [createObjectProperty(key, handlerExp)]
    };
  });
};
const transformShow = (dir, node, context) => {
  const { exp, loc } = dir;
  if (!exp) {
    context.onError(
      createDOMCompilerError(62, loc)
    );
  }
  return {
    props: [],
    needRuntime: context.helper(V_SHOW)
  };
};
const ignoreSideEffectTags = (node, context) => {
  if (node.type === 1 && node.tagType === 0 && (node.tag === "script" || node.tag === "style")) {
    context.removeNode();
  }
};
const DOMNodeTransforms = [
  transformStyle,
  ...[]
];
const DOMDirectiveTransforms = {
  cloak: noopDirectiveTransform,
  html: transformVHtml,
  text: transformVText,
  model: transformModel,
  // override compiler-core
  on: transformOn,
  // override compiler-core
  show: transformShow
};
function compile(src, options2 = {}) {
  return baseCompile(
    src,
    extend$2({}, parserOptions, options2, {
      nodeTransforms: [
        // ignore <script> and <tag>
        // this is not put inside DOMNodeTransforms because that list is used
        // by compiler-ssr to generate vnode fallback branches
        ignoreSideEffectTags,
        ...DOMNodeTransforms,
        ...options2.nodeTransforms || []
      ],
      directiveTransforms: extend$2(
        {},
        DOMDirectiveTransforms,
        options2.directiveTransforms || {}
      ),
      transformHoist: null
    })
  );
}
function parse(template, options2 = {}) {
  return baseParse(template, extend$2({}, parserOptions, options2));
}
const compilerDom_esmBundler = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  BASE_TRANSITION,
  BindingTypes,
  CAMELIZE,
  CAPITALIZE,
  CREATE_BLOCK,
  CREATE_COMMENT,
  CREATE_ELEMENT_BLOCK,
  CREATE_ELEMENT_VNODE,
  CREATE_SLOTS,
  CREATE_STATIC,
  CREATE_TEXT,
  CREATE_VNODE,
  CompilerDeprecationTypes,
  ConstantTypes,
  DOMDirectiveTransforms,
  DOMErrorCodes,
  DOMErrorMessages,
  DOMNodeTransforms,
  ElementTypes,
  ErrorCodes,
  FRAGMENT,
  GUARD_REACTIVE_PROPS,
  IS_MEMO_SAME,
  IS_REF,
  KEEP_ALIVE,
  MERGE_PROPS,
  NORMALIZE_CLASS,
  NORMALIZE_PROPS,
  NORMALIZE_STYLE,
  Namespaces,
  NodeTypes,
  OPEN_BLOCK,
  POP_SCOPE_ID,
  PUSH_SCOPE_ID,
  RENDER_LIST,
  RENDER_SLOT,
  RESOLVE_COMPONENT,
  RESOLVE_DIRECTIVE,
  RESOLVE_DYNAMIC_COMPONENT,
  RESOLVE_FILTER,
  SET_BLOCK_TRACKING,
  SUSPENSE,
  TELEPORT,
  TO_DISPLAY_STRING,
  TO_HANDLERS,
  TO_HANDLER_KEY,
  TRANSITION,
  TRANSITION_GROUP,
  TS_NODE_TYPES,
  UNREF,
  V_MODEL_CHECKBOX,
  V_MODEL_DYNAMIC,
  V_MODEL_RADIO,
  V_MODEL_SELECT,
  V_MODEL_TEXT,
  V_ON_WITH_KEYS,
  V_ON_WITH_MODIFIERS,
  V_SHOW,
  WITH_CTX,
  WITH_DIRECTIVES,
  WITH_MEMO,
  advancePositionWithClone,
  advancePositionWithMutation,
  assert,
  baseCompile,
  baseParse,
  buildDirectiveArgs,
  buildProps,
  buildSlots,
  checkCompatEnabled,
  compile,
  convertToBlock,
  createArrayExpression,
  createAssignmentExpression,
  createBlockStatement,
  createCacheExpression,
  createCallExpression,
  createCompilerError,
  createCompoundExpression,
  createConditionalExpression,
  createDOMCompilerError,
  createForLoopParams,
  createFunctionExpression,
  createIfStatement,
  createInterpolation,
  createObjectExpression,
  createObjectProperty,
  createReturnStatement,
  createRoot,
  createSequenceExpression,
  createSimpleExpression,
  createStructuralDirectiveTransform,
  createTemplateLiteral,
  createTransformContext,
  createVNodeCall,
  errorMessages,
  extractIdentifiers,
  findDir,
  findProp,
  forAliasRE,
  generate: generate$1,
  generateCodeFrame,
  getBaseTransformPreset,
  getConstantType,
  getMemoedVNodeCall,
  getVNodeBlockHelper,
  getVNodeHelper,
  hasDynamicKeyVBind,
  hasScopeRef,
  helperNameMap,
  injectProp,
  isAllWhitespace,
  isCommentOrWhitespace,
  isCoreComponent,
  isFnExpression,
  isFnExpressionBrowser,
  isFnExpressionNode,
  isFunctionType,
  isInDestructureAssignment,
  isInNewExpression,
  isMemberExpression,
  isMemberExpressionBrowser,
  isMemberExpressionNode,
  isReferencedIdentifier,
  isSimpleIdentifier,
  isSlotOutlet,
  isStaticArgOf,
  isStaticExp,
  isStaticProperty,
  isStaticPropertyKey,
  isTemplateNode,
  isText: isText$1,
  isVPre,
  isVSlot,
  isWhitespaceText,
  locStub,
  noopDirectiveTransform,
  parse,
  parserOptions,
  processExpression,
  processFor,
  processIf,
  processSlotOutlet,
  registerRuntimeHelpers,
  resolveComponentType,
  stringifyExpression,
  toValidAssetId,
  trackSlotScopes,
  trackVForSlotScopes,
  transform,
  transformBind,
  transformElement,
  transformExpression,
  transformModel: transformModel$1,
  transformOn: transformOn$1,
  transformStyle,
  transformVBindShorthand,
  traverseNode,
  unwrapTSNode,
  validFirstIdentCharRE,
  walkBlockDeclarations,
  walkFunctionParams,
  walkIdentifiers,
  warnDeprecation
}, Symbol.toStringTag, { value: "Module" }));
const require$$0$1 = /* @__PURE__ */ getAugmentedNamespace(compilerDom_esmBundler);
const require$$1$2 = /* @__PURE__ */ getAugmentedNamespace(runtimeDom_esmBundler);
const require$$2 = /* @__PURE__ */ getAugmentedNamespace(shared_esmBundler);
var hasRequiredVue_cjs_prod;
function requireVue_cjs_prod() {
  if (hasRequiredVue_cjs_prod) return vue_cjs_prod;
  hasRequiredVue_cjs_prod = 1;
  (function(exports$1) {
    Object.defineProperty(exports$1, "__esModule", { value: true });
    var compilerDom = require$$0$1;
    var runtimeDom = require$$1$2;
    var shared = require$$2;
    function _interopNamespaceDefault(e) {
      var n = /* @__PURE__ */ Object.create(null);
      if (e) {
        for (var k in e) {
          n[k] = e[k];
        }
      }
      n.default = e;
      return Object.freeze(n);
    }
    var runtimeDom__namespace = /* @__PURE__ */ _interopNamespaceDefault(runtimeDom);
    const compileCache = /* @__PURE__ */ Object.create(null);
    function compileToFunction(template, options2) {
      if (!shared.isString(template)) {
        if (template.nodeType) {
          template = template.innerHTML;
        } else {
          return shared.NOOP;
        }
      }
      const key = shared.genCacheKey(template, options2);
      const cached = compileCache[key];
      if (cached) {
        return cached;
      }
      if (template[0] === "#") {
        const el = document.querySelector(template);
        template = el ? el.innerHTML : ``;
      }
      const opts = shared.extend(
        {
          hoistStatic: true,
          onError: void 0,
          onWarn: shared.NOOP
        },
        options2
      );
      if (!opts.isCustomElement && typeof customElements !== "undefined") {
        opts.isCustomElement = (tag) => !!customElements.get(tag);
      }
      const { code } = compilerDom.compile(template, opts);
      const render = new Function("Vue", code)(runtimeDom__namespace);
      render._rc = true;
      return compileCache[key] = render;
    }
    runtimeDom.registerRuntimeCompiler(compileToFunction);
    exports$1.compile = compileToFunction;
    Object.keys(runtimeDom).forEach(function(k) {
      if (k !== "default" && !Object.prototype.hasOwnProperty.call(exports$1, k)) exports$1[k] = runtimeDom[k];
    });
  })(vue_cjs_prod);
  return vue_cjs_prod;
}
var hasRequiredVue;
function requireVue() {
  if (hasRequiredVue) return vue.exports;
  hasRequiredVue = 1;
  {
    vue.exports = requireVue_cjs_prod();
  }
  return vue.exports;
}
function ownKeys(object, enumerableOnly) {
  var keys2 = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    if (enumerableOnly) {
      symbols = symbols.filter(function(sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });
    }
    keys2.push.apply(keys2, symbols);
  }
  return keys2;
}
function _objectSpread2(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i] != null ? arguments[i] : {};
    if (i % 2) {
      ownKeys(Object(source), true).forEach(function(key) {
        _defineProperty(target, key, source[key]);
      });
    } else if (Object.getOwnPropertyDescriptors) {
      Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
    } else {
      ownKeys(Object(source)).forEach(function(key) {
        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
      });
    }
  }
  return target;
}
function _typeof(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof = function(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof = function(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof(obj);
}
function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _extends() {
  _extends = Object.assign || function(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}
function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;
  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }
  return target;
}
function _objectWithoutProperties(source, excluded) {
  if (source == null) return {};
  var target = _objectWithoutPropertiesLoose(source, excluded);
  var key, i;
  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
    for (i = 0; i < sourceSymbolKeys.length; i++) {
      key = sourceSymbolKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
      target[key] = source[key];
    }
  }
  return target;
}
function _toConsumableArray(arr) {
  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
}
function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) return _arrayLikeToArray(arr);
}
function _iterableToArray(iter) {
  if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
}
function _unsupportedIterableToArray(o, minLen) {
  if (!o) return;
  if (typeof o === "string") return _arrayLikeToArray(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor) n = o.constructor.name;
  if (n === "Map" || n === "Set") return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
}
function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;
  for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];
  return arr2;
}
function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
var version$1 = "1.14.0";
function userAgent(pattern) {
  if (typeof window !== "undefined" && window.navigator) {
    return !!/* @__PURE__ */ navigator.userAgent.match(pattern);
  }
}
var IE11OrLess = userAgent(/(?:Trident.*rv[ :]?11\.|msie|iemobile|Windows Phone)/i);
var Edge = userAgent(/Edge/i);
var FireFox = userAgent(/firefox/i);
var Safari = userAgent(/safari/i) && !userAgent(/chrome/i) && !userAgent(/android/i);
var IOS = userAgent(/iP(ad|od|hone)/i);
var ChromeForAndroid = userAgent(/chrome/i) && userAgent(/android/i);
var captureMode = {
  capture: false,
  passive: false
};
function on(el, event, fn) {
  el.addEventListener(event, fn, !IE11OrLess && captureMode);
}
function off(el, event, fn) {
  el.removeEventListener(event, fn, !IE11OrLess && captureMode);
}
function matches(el, selector) {
  if (!selector) return;
  selector[0] === ">" && (selector = selector.substring(1));
  if (el) {
    try {
      if (el.matches) {
        return el.matches(selector);
      } else if (el.msMatchesSelector) {
        return el.msMatchesSelector(selector);
      } else if (el.webkitMatchesSelector) {
        return el.webkitMatchesSelector(selector);
      }
    } catch (_) {
      return false;
    }
  }
  return false;
}
function getParentOrHost(el) {
  return el.host && el !== document && el.host.nodeType ? el.host : el.parentNode;
}
function closest(el, selector, ctx, includeCTX) {
  if (el) {
    ctx = ctx || document;
    do {
      if (selector != null && (selector[0] === ">" ? el.parentNode === ctx && matches(el, selector) : matches(el, selector)) || includeCTX && el === ctx) {
        return el;
      }
      if (el === ctx) break;
    } while (el = getParentOrHost(el));
  }
  return null;
}
var R_SPACE = /\s+/g;
function toggleClass$1(el, name2, state) {
  if (el && name2) {
    if (el.classList) {
      el.classList[state ? "add" : "remove"](name2);
    } else {
      var className = (" " + el.className + " ").replace(R_SPACE, " ").replace(" " + name2 + " ", " ");
      el.className = (className + (state ? " " + name2 : "")).replace(R_SPACE, " ");
    }
  }
}
function css(el, prop, val) {
  var style = el && el.style;
  if (style) {
    if (val === void 0) {
      if (document.defaultView && document.defaultView.getComputedStyle) {
        val = document.defaultView.getComputedStyle(el, "");
      } else if (el.currentStyle) {
        val = el.currentStyle;
      }
      return prop === void 0 ? val : val[prop];
    } else {
      if (!(prop in style) && prop.indexOf("webkit") === -1) {
        prop = "-webkit-" + prop;
      }
      style[prop] = val + (typeof val === "string" ? "" : "px");
    }
  }
}
function matrix(el, selfOnly) {
  var appliedTransforms = "";
  if (typeof el === "string") {
    appliedTransforms = el;
  } else {
    do {
      var transform2 = css(el, "transform");
      if (transform2 && transform2 !== "none") {
        appliedTransforms = transform2 + " " + appliedTransforms;
      }
    } while (!selfOnly && (el = el.parentNode));
  }
  var matrixFn = window.DOMMatrix || window.WebKitCSSMatrix || window.CSSMatrix || window.MSCSSMatrix;
  return matrixFn && new matrixFn(appliedTransforms);
}
function find(ctx, tagName, iterator) {
  if (ctx) {
    var list = ctx.getElementsByTagName(tagName), i = 0, n = list.length;
    if (iterator) {
      for (; i < n; i++) {
        iterator(list[i], i);
      }
    }
    return list;
  }
  return [];
}
function getWindowScrollingElement() {
  var scrollingElement = document.scrollingElement;
  if (scrollingElement) {
    return scrollingElement;
  } else {
    return document.documentElement;
  }
}
function getRect(el, relativeToContainingBlock, relativeToNonStaticParent, undoScale, container) {
  if (!el.getBoundingClientRect && el !== window) return;
  var elRect, top, left, bottom, right, height, width;
  if (el !== window && el.parentNode && el !== getWindowScrollingElement()) {
    elRect = el.getBoundingClientRect();
    top = elRect.top;
    left = elRect.left;
    bottom = elRect.bottom;
    right = elRect.right;
    height = elRect.height;
    width = elRect.width;
  } else {
    top = 0;
    left = 0;
    bottom = window.innerHeight;
    right = window.innerWidth;
    height = window.innerHeight;
    width = window.innerWidth;
  }
  if ((relativeToContainingBlock || relativeToNonStaticParent) && el !== window) {
    container = container || el.parentNode;
    if (!IE11OrLess) {
      do {
        if (container && container.getBoundingClientRect && (css(container, "transform") !== "none" || relativeToNonStaticParent && css(container, "position") !== "static")) {
          var containerRect = container.getBoundingClientRect();
          top -= containerRect.top + parseInt(css(container, "border-top-width"));
          left -= containerRect.left + parseInt(css(container, "border-left-width"));
          bottom = top + elRect.height;
          right = left + elRect.width;
          break;
        }
      } while (container = container.parentNode);
    }
  }
  if (undoScale && el !== window) {
    var elMatrix = matrix(container || el), scaleX = elMatrix && elMatrix.a, scaleY = elMatrix && elMatrix.d;
    if (elMatrix) {
      top /= scaleY;
      left /= scaleX;
      width /= scaleX;
      height /= scaleY;
      bottom = top + height;
      right = left + width;
    }
  }
  return {
    top,
    left,
    bottom,
    right,
    width,
    height
  };
}
function isScrolledPast(el, elSide, parentSide) {
  var parent = getParentAutoScrollElement(el, true), elSideVal = getRect(el)[elSide];
  while (parent) {
    var parentSideVal = getRect(parent)[parentSide], visible = void 0;
    {
      visible = elSideVal >= parentSideVal;
    }
    if (!visible) return parent;
    if (parent === getWindowScrollingElement()) break;
    parent = getParentAutoScrollElement(parent, false);
  }
  return false;
}
function getChild(el, childNum, options2, includeDragEl) {
  var currentChild = 0, i = 0, children = el.children;
  while (i < children.length) {
    if (children[i].style.display !== "none" && children[i] !== Sortable.ghost && (includeDragEl || children[i] !== Sortable.dragged) && closest(children[i], options2.draggable, el, false)) {
      if (currentChild === childNum) {
        return children[i];
      }
      currentChild++;
    }
    i++;
  }
  return null;
}
function lastChild(el, selector) {
  var last = el.lastElementChild;
  while (last && (last === Sortable.ghost || css(last, "display") === "none" || selector && !matches(last, selector))) {
    last = last.previousElementSibling;
  }
  return last || null;
}
function index(el, selector) {
  var index2 = 0;
  if (!el || !el.parentNode) {
    return -1;
  }
  while (el = el.previousElementSibling) {
    if (el.nodeName.toUpperCase() !== "TEMPLATE" && el !== Sortable.clone && (!selector || matches(el, selector))) {
      index2++;
    }
  }
  return index2;
}
function getRelativeScrollOffset(el) {
  var offsetLeft = 0, offsetTop = 0, winScroller = getWindowScrollingElement();
  if (el) {
    do {
      var elMatrix = matrix(el), scaleX = elMatrix.a, scaleY = elMatrix.d;
      offsetLeft += el.scrollLeft * scaleX;
      offsetTop += el.scrollTop * scaleY;
    } while (el !== winScroller && (el = el.parentNode));
  }
  return [offsetLeft, offsetTop];
}
function indexOfObject(arr, obj) {
  for (var i in arr) {
    if (!arr.hasOwnProperty(i)) continue;
    for (var key in obj) {
      if (obj.hasOwnProperty(key) && obj[key] === arr[i][key]) return Number(i);
    }
  }
  return -1;
}
function getParentAutoScrollElement(el, includeSelf) {
  if (!el || !el.getBoundingClientRect) return getWindowScrollingElement();
  var elem = el;
  var gotSelf = false;
  do {
    if (elem.clientWidth < elem.scrollWidth || elem.clientHeight < elem.scrollHeight) {
      var elemCSS = css(elem);
      if (elem.clientWidth < elem.scrollWidth && (elemCSS.overflowX == "auto" || elemCSS.overflowX == "scroll") || elem.clientHeight < elem.scrollHeight && (elemCSS.overflowY == "auto" || elemCSS.overflowY == "scroll")) {
        if (!elem.getBoundingClientRect || elem === document.body) return getWindowScrollingElement();
        if (gotSelf || includeSelf) return elem;
        gotSelf = true;
      }
    }
  } while (elem = elem.parentNode);
  return getWindowScrollingElement();
}
function extend$1(dst, src) {
  if (dst && src) {
    for (var key in src) {
      if (src.hasOwnProperty(key)) {
        dst[key] = src[key];
      }
    }
  }
  return dst;
}
function isRectEqual(rect1, rect2) {
  return Math.round(rect1.top) === Math.round(rect2.top) && Math.round(rect1.left) === Math.round(rect2.left) && Math.round(rect1.height) === Math.round(rect2.height) && Math.round(rect1.width) === Math.round(rect2.width);
}
var _throttleTimeout;
function throttle(callback, ms) {
  return function() {
    if (!_throttleTimeout) {
      var args = arguments, _this = this;
      if (args.length === 1) {
        callback.call(_this, args[0]);
      } else {
        callback.apply(_this, args);
      }
      _throttleTimeout = setTimeout(function() {
        _throttleTimeout = void 0;
      }, ms);
    }
  };
}
function cancelThrottle() {
  clearTimeout(_throttleTimeout);
  _throttleTimeout = void 0;
}
function scrollBy(el, x, y) {
  el.scrollLeft += x;
  el.scrollTop += y;
}
function clone$2(el) {
  var Polymer = window.Polymer;
  var $ = window.jQuery || window.Zepto;
  if (Polymer && Polymer.dom) {
    return Polymer.dom(el).cloneNode(true);
  } else if ($) {
    return $(el).clone(true)[0];
  } else {
    return el.cloneNode(true);
  }
}
function setRect(el, rect) {
  css(el, "position", "absolute");
  css(el, "top", rect.top);
  css(el, "left", rect.left);
  css(el, "width", rect.width);
  css(el, "height", rect.height);
}
function unsetRect(el) {
  css(el, "position", "");
  css(el, "top", "");
  css(el, "left", "");
  css(el, "width", "");
  css(el, "height", "");
}
var expando = "Sortable" + (/* @__PURE__ */ new Date()).getTime();
function AnimationStateManager() {
  var animationStates = [], animationCallbackId;
  return {
    captureAnimationState: function captureAnimationState() {
      animationStates = [];
      if (!this.options.animation) return;
      var children = [].slice.call(this.el.children);
      children.forEach(function(child) {
        if (css(child, "display") === "none" || child === Sortable.ghost) return;
        animationStates.push({
          target: child,
          rect: getRect(child)
        });
        var fromRect = _objectSpread2({}, animationStates[animationStates.length - 1].rect);
        if (child.thisAnimationDuration) {
          var childMatrix = matrix(child, true);
          if (childMatrix) {
            fromRect.top -= childMatrix.f;
            fromRect.left -= childMatrix.e;
          }
        }
        child.fromRect = fromRect;
      });
    },
    addAnimationState: function addAnimationState(state) {
      animationStates.push(state);
    },
    removeAnimationState: function removeAnimationState(target) {
      animationStates.splice(indexOfObject(animationStates, {
        target
      }), 1);
    },
    animateAll: function animateAll(callback) {
      var _this = this;
      if (!this.options.animation) {
        clearTimeout(animationCallbackId);
        if (typeof callback === "function") callback();
        return;
      }
      var animating = false, animationTime = 0;
      animationStates.forEach(function(state) {
        var time = 0, target = state.target, fromRect = target.fromRect, toRect = getRect(target), prevFromRect = target.prevFromRect, prevToRect = target.prevToRect, animatingRect = state.rect, targetMatrix = matrix(target, true);
        if (targetMatrix) {
          toRect.top -= targetMatrix.f;
          toRect.left -= targetMatrix.e;
        }
        target.toRect = toRect;
        if (target.thisAnimationDuration) {
          if (isRectEqual(prevFromRect, toRect) && !isRectEqual(fromRect, toRect) && // Make sure animatingRect is on line between toRect & fromRect
          (animatingRect.top - toRect.top) / (animatingRect.left - toRect.left) === (fromRect.top - toRect.top) / (fromRect.left - toRect.left)) {
            time = calculateRealTime(animatingRect, prevFromRect, prevToRect, _this.options);
          }
        }
        if (!isRectEqual(toRect, fromRect)) {
          target.prevFromRect = fromRect;
          target.prevToRect = toRect;
          if (!time) {
            time = _this.options.animation;
          }
          _this.animate(target, animatingRect, toRect, time);
        }
        if (time) {
          animating = true;
          animationTime = Math.max(animationTime, time);
          clearTimeout(target.animationResetTimer);
          target.animationResetTimer = setTimeout(function() {
            target.animationTime = 0;
            target.prevFromRect = null;
            target.fromRect = null;
            target.prevToRect = null;
            target.thisAnimationDuration = null;
          }, time);
          target.thisAnimationDuration = time;
        }
      });
      clearTimeout(animationCallbackId);
      if (!animating) {
        if (typeof callback === "function") callback();
      } else {
        animationCallbackId = setTimeout(function() {
          if (typeof callback === "function") callback();
        }, animationTime);
      }
      animationStates = [];
    },
    animate: function animate(target, currentRect, toRect, duration2) {
      if (duration2) {
        css(target, "transition", "");
        css(target, "transform", "");
        var elMatrix = matrix(this.el), scaleX = elMatrix && elMatrix.a, scaleY = elMatrix && elMatrix.d, translateX = (currentRect.left - toRect.left) / (scaleX || 1), translateY = (currentRect.top - toRect.top) / (scaleY || 1);
        target.animatingX = !!translateX;
        target.animatingY = !!translateY;
        css(target, "transform", "translate3d(" + translateX + "px," + translateY + "px,0)");
        this.forRepaintDummy = repaint(target);
        css(target, "transition", "transform " + duration2 + "ms" + (this.options.easing ? " " + this.options.easing : ""));
        css(target, "transform", "translate3d(0,0,0)");
        typeof target.animated === "number" && clearTimeout(target.animated);
        target.animated = setTimeout(function() {
          css(target, "transition", "");
          css(target, "transform", "");
          target.animated = false;
          target.animatingX = false;
          target.animatingY = false;
        }, duration2);
      }
    }
  };
}
function repaint(target) {
  return target.offsetWidth;
}
function calculateRealTime(animatingRect, fromRect, toRect, options2) {
  return Math.sqrt(Math.pow(fromRect.top - animatingRect.top, 2) + Math.pow(fromRect.left - animatingRect.left, 2)) / Math.sqrt(Math.pow(fromRect.top - toRect.top, 2) + Math.pow(fromRect.left - toRect.left, 2)) * options2.animation;
}
var plugins = [];
var defaults$2 = {
  initializeByDefault: true
};
var PluginManager = {
  mount: function mount(plugin) {
    for (var option2 in defaults$2) {
      if (defaults$2.hasOwnProperty(option2) && !(option2 in plugin)) {
        plugin[option2] = defaults$2[option2];
      }
    }
    plugins.forEach(function(p) {
      if (p.pluginName === plugin.pluginName) {
        throw "Sortable: Cannot mount plugin ".concat(plugin.pluginName, " more than once");
      }
    });
    plugins.push(plugin);
  },
  pluginEvent: function pluginEvent(eventName, sortable, evt) {
    var _this = this;
    this.eventCanceled = false;
    evt.cancel = function() {
      _this.eventCanceled = true;
    };
    var eventNameGlobal = eventName + "Global";
    plugins.forEach(function(plugin) {
      if (!sortable[plugin.pluginName]) return;
      if (sortable[plugin.pluginName][eventNameGlobal]) {
        sortable[plugin.pluginName][eventNameGlobal](_objectSpread2({
          sortable
        }, evt));
      }
      if (sortable.options[plugin.pluginName] && sortable[plugin.pluginName][eventName]) {
        sortable[plugin.pluginName][eventName](_objectSpread2({
          sortable
        }, evt));
      }
    });
  },
  initializePlugins: function initializePlugins(sortable, el, defaults2, options2) {
    plugins.forEach(function(plugin) {
      var pluginName = plugin.pluginName;
      if (!sortable.options[pluginName] && !plugin.initializeByDefault) return;
      var initialized = new plugin(sortable, el, sortable.options);
      initialized.sortable = sortable;
      initialized.options = sortable.options;
      sortable[pluginName] = initialized;
      _extends(defaults2, initialized.defaults);
    });
    for (var option2 in sortable.options) {
      if (!sortable.options.hasOwnProperty(option2)) continue;
      var modified = this.modifyOption(sortable, option2, sortable.options[option2]);
      if (typeof modified !== "undefined") {
        sortable.options[option2] = modified;
      }
    }
  },
  getEventProperties: function getEventProperties(name2, sortable) {
    var eventProperties = {};
    plugins.forEach(function(plugin) {
      if (typeof plugin.eventProperties !== "function") return;
      _extends(eventProperties, plugin.eventProperties.call(sortable[plugin.pluginName], name2));
    });
    return eventProperties;
  },
  modifyOption: function modifyOption(sortable, name2, value) {
    var modifiedValue;
    plugins.forEach(function(plugin) {
      if (!sortable[plugin.pluginName]) return;
      if (plugin.optionListeners && typeof plugin.optionListeners[name2] === "function") {
        modifiedValue = plugin.optionListeners[name2].call(sortable[plugin.pluginName], value);
      }
    });
    return modifiedValue;
  }
};
function dispatchEvent(_ref) {
  var sortable = _ref.sortable, rootEl2 = _ref.rootEl, name2 = _ref.name, targetEl = _ref.targetEl, cloneEl2 = _ref.cloneEl, toEl = _ref.toEl, fromEl = _ref.fromEl, oldIndex2 = _ref.oldIndex, newIndex2 = _ref.newIndex, oldDraggableIndex2 = _ref.oldDraggableIndex, newDraggableIndex2 = _ref.newDraggableIndex, originalEvent = _ref.originalEvent, putSortable2 = _ref.putSortable, extraEventProperties = _ref.extraEventProperties;
  sortable = sortable || rootEl2 && rootEl2[expando];
  if (!sortable) return;
  var evt, options2 = sortable.options, onName = "on" + name2.charAt(0).toUpperCase() + name2.substr(1);
  if (window.CustomEvent && !IE11OrLess && !Edge) {
    evt = new CustomEvent(name2, {
      bubbles: true,
      cancelable: true
    });
  } else {
    evt = document.createEvent("Event");
    evt.initEvent(name2, true, true);
  }
  evt.to = toEl || rootEl2;
  evt.from = fromEl || rootEl2;
  evt.item = targetEl || rootEl2;
  evt.clone = cloneEl2;
  evt.oldIndex = oldIndex2;
  evt.newIndex = newIndex2;
  evt.oldDraggableIndex = oldDraggableIndex2;
  evt.newDraggableIndex = newDraggableIndex2;
  evt.originalEvent = originalEvent;
  evt.pullMode = putSortable2 ? putSortable2.lastPutMode : void 0;
  var allEventProperties = _objectSpread2(_objectSpread2({}, extraEventProperties), PluginManager.getEventProperties(name2, sortable));
  for (var option2 in allEventProperties) {
    evt[option2] = allEventProperties[option2];
  }
  if (rootEl2) {
    rootEl2.dispatchEvent(evt);
  }
  if (options2[onName]) {
    options2[onName].call(sortable, evt);
  }
}
var _excluded = ["evt"];
var pluginEvent2 = function pluginEvent3(eventName, sortable) {
  var _ref = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {}, originalEvent = _ref.evt, data = _objectWithoutProperties(_ref, _excluded);
  PluginManager.pluginEvent.bind(Sortable)(eventName, sortable, _objectSpread2({
    dragEl,
    parentEl,
    ghostEl,
    rootEl,
    nextEl,
    lastDownEl,
    cloneEl,
    cloneHidden,
    dragStarted: moved,
    putSortable,
    activeSortable: Sortable.active,
    originalEvent,
    oldIndex,
    oldDraggableIndex,
    newIndex,
    newDraggableIndex,
    hideGhostForTarget: _hideGhostForTarget,
    unhideGhostForTarget: _unhideGhostForTarget,
    cloneNowHidden: function cloneNowHidden() {
      cloneHidden = true;
    },
    cloneNowShown: function cloneNowShown() {
      cloneHidden = false;
    },
    dispatchSortableEvent: function dispatchSortableEvent(name2) {
      _dispatchEvent({
        sortable,
        name: name2,
        originalEvent
      });
    }
  }, data));
};
function _dispatchEvent(info) {
  dispatchEvent(_objectSpread2({
    putSortable,
    cloneEl,
    targetEl: dragEl,
    rootEl,
    oldIndex,
    oldDraggableIndex,
    newIndex,
    newDraggableIndex
  }, info));
}
var dragEl, parentEl, ghostEl, rootEl, nextEl, lastDownEl, cloneEl, cloneHidden, oldIndex, newIndex, oldDraggableIndex, newDraggableIndex, activeGroup, putSortable, awaitingDragStarted = false, ignoreNextClick = false, sortables = [], tapEvt, touchEvt, lastDx, lastDy, tapDistanceLeft, tapDistanceTop, moved, lastTarget, lastDirection, pastFirstInvertThresh = false, isCircumstantialInvert = false, targetMoveDistance, ghostRelativeParent, ghostRelativeParentInitialScroll = [], _silent = false, savedInputChecked = [];
var documentExists = typeof document !== "undefined", PositionGhostAbsolutely = IOS, CSSFloatProperty = Edge || IE11OrLess ? "cssFloat" : "float", supportDraggable = documentExists && !ChromeForAndroid && !IOS && "draggable" in document.createElement("div"), supportCssPointerEvents = (function() {
  if (!documentExists) return;
  if (IE11OrLess) {
    return false;
  }
  var el = document.createElement("x");
  el.style.cssText = "pointer-events:auto";
  return el.style.pointerEvents === "auto";
})(), _detectDirection = function _detectDirection2(el, options2) {
  var elCSS = css(el), elWidth = parseInt(elCSS.width) - parseInt(elCSS.paddingLeft) - parseInt(elCSS.paddingRight) - parseInt(elCSS.borderLeftWidth) - parseInt(elCSS.borderRightWidth), child1 = getChild(el, 0, options2), child2 = getChild(el, 1, options2), firstChildCSS = child1 && css(child1), secondChildCSS = child2 && css(child2), firstChildWidth = firstChildCSS && parseInt(firstChildCSS.marginLeft) + parseInt(firstChildCSS.marginRight) + getRect(child1).width, secondChildWidth = secondChildCSS && parseInt(secondChildCSS.marginLeft) + parseInt(secondChildCSS.marginRight) + getRect(child2).width;
  if (elCSS.display === "flex") {
    return elCSS.flexDirection === "column" || elCSS.flexDirection === "column-reverse" ? "vertical" : "horizontal";
  }
  if (elCSS.display === "grid") {
    return elCSS.gridTemplateColumns.split(" ").length <= 1 ? "vertical" : "horizontal";
  }
  if (child1 && firstChildCSS["float"] && firstChildCSS["float"] !== "none") {
    var touchingSideChild2 = firstChildCSS["float"] === "left" ? "left" : "right";
    return child2 && (secondChildCSS.clear === "both" || secondChildCSS.clear === touchingSideChild2) ? "vertical" : "horizontal";
  }
  return child1 && (firstChildCSS.display === "block" || firstChildCSS.display === "flex" || firstChildCSS.display === "table" || firstChildCSS.display === "grid" || firstChildWidth >= elWidth && elCSS[CSSFloatProperty] === "none" || child2 && elCSS[CSSFloatProperty] === "none" && firstChildWidth + secondChildWidth > elWidth) ? "vertical" : "horizontal";
}, _dragElInRowColumn = function _dragElInRowColumn2(dragRect, targetRect, vertical) {
  var dragElS1Opp = vertical ? dragRect.left : dragRect.top, dragElS2Opp = vertical ? dragRect.right : dragRect.bottom, dragElOppLength = vertical ? dragRect.width : dragRect.height, targetS1Opp = vertical ? targetRect.left : targetRect.top, targetS2Opp = vertical ? targetRect.right : targetRect.bottom, targetOppLength = vertical ? targetRect.width : targetRect.height;
  return dragElS1Opp === targetS1Opp || dragElS2Opp === targetS2Opp || dragElS1Opp + dragElOppLength / 2 === targetS1Opp + targetOppLength / 2;
}, _detectNearestEmptySortable = function _detectNearestEmptySortable2(x, y) {
  var ret;
  sortables.some(function(sortable) {
    var threshold = sortable[expando].options.emptyInsertThreshold;
    if (!threshold || lastChild(sortable)) return;
    var rect = getRect(sortable), insideHorizontally = x >= rect.left - threshold && x <= rect.right + threshold, insideVertically = y >= rect.top - threshold && y <= rect.bottom + threshold;
    if (insideHorizontally && insideVertically) {
      return ret = sortable;
    }
  });
  return ret;
}, _prepareGroup = function _prepareGroup2(options2) {
  function toFn(value, pull) {
    return function(to2, from2, dragEl2, evt) {
      var sameGroup = to2.options.group.name && from2.options.group.name && to2.options.group.name === from2.options.group.name;
      if (value == null && (pull || sameGroup)) {
        return true;
      } else if (value == null || value === false) {
        return false;
      } else if (pull && value === "clone") {
        return value;
      } else if (typeof value === "function") {
        return toFn(value(to2, from2, dragEl2, evt), pull)(to2, from2, dragEl2, evt);
      } else {
        var otherGroup = (pull ? to2 : from2).options.group.name;
        return value === true || typeof value === "string" && value === otherGroup || value.join && value.indexOf(otherGroup) > -1;
      }
    };
  }
  var group = {};
  var originalGroup = options2.group;
  if (!originalGroup || _typeof(originalGroup) != "object") {
    originalGroup = {
      name: originalGroup
    };
  }
  group.name = originalGroup.name;
  group.checkPull = toFn(originalGroup.pull, true);
  group.checkPut = toFn(originalGroup.put);
  group.revertClone = originalGroup.revertClone;
  options2.group = group;
}, _hideGhostForTarget = function _hideGhostForTarget2() {
  if (!supportCssPointerEvents && ghostEl) {
    css(ghostEl, "display", "none");
  }
}, _unhideGhostForTarget = function _unhideGhostForTarget2() {
  if (!supportCssPointerEvents && ghostEl) {
    css(ghostEl, "display", "");
  }
};
if (documentExists) {
  document.addEventListener("click", function(evt) {
    if (ignoreNextClick) {
      evt.preventDefault();
      evt.stopPropagation && evt.stopPropagation();
      evt.stopImmediatePropagation && evt.stopImmediatePropagation();
      ignoreNextClick = false;
      return false;
    }
  }, true);
}
var nearestEmptyInsertDetectEvent = function nearestEmptyInsertDetectEvent2(evt) {
  if (dragEl) {
    evt = evt.touches ? evt.touches[0] : evt;
    var nearest = _detectNearestEmptySortable(evt.clientX, evt.clientY);
    if (nearest) {
      var event = {};
      for (var i in evt) {
        if (evt.hasOwnProperty(i)) {
          event[i] = evt[i];
        }
      }
      event.target = event.rootEl = nearest;
      event.preventDefault = void 0;
      event.stopPropagation = void 0;
      nearest[expando]._onDragOver(event);
    }
  }
};
var _checkOutsideTargetEl = function _checkOutsideTargetEl2(evt) {
  if (dragEl) {
    dragEl.parentNode[expando]._isOutsideThisEl(evt.target);
  }
};
function Sortable(el, options2) {
  if (!(el && el.nodeType && el.nodeType === 1)) {
    throw "Sortable: `el` must be an HTMLElement, not ".concat({}.toString.call(el));
  }
  this.el = el;
  this.options = options2 = _extends({}, options2);
  el[expando] = this;
  var defaults2 = {
    group: null,
    sort: true,
    disabled: false,
    store: null,
    handle: null,
    draggable: /^[uo]l$/i.test(el.nodeName) ? ">li" : ">*",
    swapThreshold: 1,
    // percentage; 0 <= x <= 1
    invertSwap: false,
    // invert always
    invertedSwapThreshold: null,
    // will be set to same as swapThreshold if default
    removeCloneOnHide: true,
    direction: function direction() {
      return _detectDirection(el, this.options);
    },
    ghostClass: "sortable-ghost",
    chosenClass: "sortable-chosen",
    dragClass: "sortable-drag",
    ignore: "a, img",
    filter: null,
    preventOnFilter: true,
    animation: 0,
    easing: null,
    setData: function setData(dataTransfer, dragEl2) {
      dataTransfer.setData("Text", dragEl2.textContent);
    },
    dropBubble: false,
    dragoverBubble: false,
    dataIdAttr: "data-id",
    delay: 0,
    delayOnTouchOnly: false,
    touchStartThreshold: (Number.parseInt ? Number : window).parseInt(window.devicePixelRatio, 10) || 1,
    forceFallback: false,
    fallbackClass: "sortable-fallback",
    fallbackOnBody: false,
    fallbackTolerance: 0,
    fallbackOffset: {
      x: 0,
      y: 0
    },
    supportPointer: Sortable.supportPointer !== false && "PointerEvent" in window && !Safari,
    emptyInsertThreshold: 5
  };
  PluginManager.initializePlugins(this, el, defaults2);
  for (var name2 in defaults2) {
    !(name2 in options2) && (options2[name2] = defaults2[name2]);
  }
  _prepareGroup(options2);
  for (var fn in this) {
    if (fn.charAt(0) === "_" && typeof this[fn] === "function") {
      this[fn] = this[fn].bind(this);
    }
  }
  this.nativeDraggable = options2.forceFallback ? false : supportDraggable;
  if (this.nativeDraggable) {
    this.options.touchStartThreshold = 1;
  }
  if (options2.supportPointer) {
    on(el, "pointerdown", this._onTapStart);
  } else {
    on(el, "mousedown", this._onTapStart);
    on(el, "touchstart", this._onTapStart);
  }
  if (this.nativeDraggable) {
    on(el, "dragover", this);
    on(el, "dragenter", this);
  }
  sortables.push(this.el);
  options2.store && options2.store.get && this.sort(options2.store.get(this) || []);
  _extends(this, AnimationStateManager());
}
Sortable.prototype = /** @lends Sortable.prototype */
{
  constructor: Sortable,
  _isOutsideThisEl: function _isOutsideThisEl(target) {
    if (!this.el.contains(target) && target !== this.el) {
      lastTarget = null;
    }
  },
  _getDirection: function _getDirection(evt, target) {
    return typeof this.options.direction === "function" ? this.options.direction.call(this, evt, target, dragEl) : this.options.direction;
  },
  _onTapStart: function _onTapStart(evt) {
    if (!evt.cancelable) return;
    var _this = this, el = this.el, options2 = this.options, preventOnFilter = options2.preventOnFilter, type = evt.type, touch = evt.touches && evt.touches[0] || evt.pointerType && evt.pointerType === "touch" && evt, target = (touch || evt).target, originalTarget = evt.target.shadowRoot && (evt.path && evt.path[0] || evt.composedPath && evt.composedPath()[0]) || target, filter = options2.filter;
    _saveInputCheckedState(el);
    if (dragEl) {
      return;
    }
    if (/mousedown|pointerdown/.test(type) && evt.button !== 0 || options2.disabled) {
      return;
    }
    if (originalTarget.isContentEditable) {
      return;
    }
    if (!this.nativeDraggable && Safari && target && target.tagName.toUpperCase() === "SELECT") {
      return;
    }
    target = closest(target, options2.draggable, el, false);
    if (target && target.animated) {
      return;
    }
    if (lastDownEl === target) {
      return;
    }
    oldIndex = index(target);
    oldDraggableIndex = index(target, options2.draggable);
    if (typeof filter === "function") {
      if (filter.call(this, evt, target, this)) {
        _dispatchEvent({
          sortable: _this,
          rootEl: originalTarget,
          name: "filter",
          targetEl: target,
          toEl: el,
          fromEl: el
        });
        pluginEvent2("filter", _this, {
          evt
        });
        preventOnFilter && evt.cancelable && evt.preventDefault();
        return;
      }
    } else if (filter) {
      filter = filter.split(",").some(function(criteria) {
        criteria = closest(originalTarget, criteria.trim(), el, false);
        if (criteria) {
          _dispatchEvent({
            sortable: _this,
            rootEl: criteria,
            name: "filter",
            targetEl: target,
            fromEl: el,
            toEl: el
          });
          pluginEvent2("filter", _this, {
            evt
          });
          return true;
        }
      });
      if (filter) {
        preventOnFilter && evt.cancelable && evt.preventDefault();
        return;
      }
    }
    if (options2.handle && !closest(originalTarget, options2.handle, el, false)) {
      return;
    }
    this._prepareDragStart(evt, touch, target);
  },
  _prepareDragStart: function _prepareDragStart(evt, touch, target) {
    var _this = this, el = _this.el, options2 = _this.options, ownerDocument = el.ownerDocument, dragStartFn;
    if (target && !dragEl && target.parentNode === el) {
      var dragRect = getRect(target);
      rootEl = el;
      dragEl = target;
      parentEl = dragEl.parentNode;
      nextEl = dragEl.nextSibling;
      lastDownEl = target;
      activeGroup = options2.group;
      Sortable.dragged = dragEl;
      tapEvt = {
        target: dragEl,
        clientX: (touch || evt).clientX,
        clientY: (touch || evt).clientY
      };
      tapDistanceLeft = tapEvt.clientX - dragRect.left;
      tapDistanceTop = tapEvt.clientY - dragRect.top;
      this._lastX = (touch || evt).clientX;
      this._lastY = (touch || evt).clientY;
      dragEl.style["will-change"] = "all";
      dragStartFn = function dragStartFn2() {
        pluginEvent2("delayEnded", _this, {
          evt
        });
        if (Sortable.eventCanceled) {
          _this._onDrop();
          return;
        }
        _this._disableDelayedDragEvents();
        if (!FireFox && _this.nativeDraggable) {
          dragEl.draggable = true;
        }
        _this._triggerDragStart(evt, touch);
        _dispatchEvent({
          sortable: _this,
          name: "choose",
          originalEvent: evt
        });
        toggleClass$1(dragEl, options2.chosenClass, true);
      };
      options2.ignore.split(",").forEach(function(criteria) {
        find(dragEl, criteria.trim(), _disableDraggable);
      });
      on(ownerDocument, "dragover", nearestEmptyInsertDetectEvent);
      on(ownerDocument, "mousemove", nearestEmptyInsertDetectEvent);
      on(ownerDocument, "touchmove", nearestEmptyInsertDetectEvent);
      on(ownerDocument, "mouseup", _this._onDrop);
      on(ownerDocument, "touchend", _this._onDrop);
      on(ownerDocument, "touchcancel", _this._onDrop);
      if (FireFox && this.nativeDraggable) {
        this.options.touchStartThreshold = 4;
        dragEl.draggable = true;
      }
      pluginEvent2("delayStart", this, {
        evt
      });
      if (options2.delay && (!options2.delayOnTouchOnly || touch) && (!this.nativeDraggable || !(Edge || IE11OrLess))) {
        if (Sortable.eventCanceled) {
          this._onDrop();
          return;
        }
        on(ownerDocument, "mouseup", _this._disableDelayedDrag);
        on(ownerDocument, "touchend", _this._disableDelayedDrag);
        on(ownerDocument, "touchcancel", _this._disableDelayedDrag);
        on(ownerDocument, "mousemove", _this._delayedDragTouchMoveHandler);
        on(ownerDocument, "touchmove", _this._delayedDragTouchMoveHandler);
        options2.supportPointer && on(ownerDocument, "pointermove", _this._delayedDragTouchMoveHandler);
        _this._dragStartTimer = setTimeout(dragStartFn, options2.delay);
      } else {
        dragStartFn();
      }
    }
  },
  _delayedDragTouchMoveHandler: function _delayedDragTouchMoveHandler(e) {
    var touch = e.touches ? e.touches[0] : e;
    if (Math.max(Math.abs(touch.clientX - this._lastX), Math.abs(touch.clientY - this._lastY)) >= Math.floor(this.options.touchStartThreshold / (this.nativeDraggable && window.devicePixelRatio || 1))) {
      this._disableDelayedDrag();
    }
  },
  _disableDelayedDrag: function _disableDelayedDrag() {
    dragEl && _disableDraggable(dragEl);
    clearTimeout(this._dragStartTimer);
    this._disableDelayedDragEvents();
  },
  _disableDelayedDragEvents: function _disableDelayedDragEvents() {
    var ownerDocument = this.el.ownerDocument;
    off(ownerDocument, "mouseup", this._disableDelayedDrag);
    off(ownerDocument, "touchend", this._disableDelayedDrag);
    off(ownerDocument, "touchcancel", this._disableDelayedDrag);
    off(ownerDocument, "mousemove", this._delayedDragTouchMoveHandler);
    off(ownerDocument, "touchmove", this._delayedDragTouchMoveHandler);
    off(ownerDocument, "pointermove", this._delayedDragTouchMoveHandler);
  },
  _triggerDragStart: function _triggerDragStart(evt, touch) {
    touch = touch || evt.pointerType == "touch" && evt;
    if (!this.nativeDraggable || touch) {
      if (this.options.supportPointer) {
        on(document, "pointermove", this._onTouchMove);
      } else if (touch) {
        on(document, "touchmove", this._onTouchMove);
      } else {
        on(document, "mousemove", this._onTouchMove);
      }
    } else {
      on(dragEl, "dragend", this);
      on(rootEl, "dragstart", this._onDragStart);
    }
    try {
      if (document.selection) {
        _nextTick(function() {
          document.selection.empty();
        });
      } else {
        window.getSelection().removeAllRanges();
      }
    } catch (err) {
    }
  },
  _dragStarted: function _dragStarted(fallback, evt) {
    awaitingDragStarted = false;
    if (rootEl && dragEl) {
      pluginEvent2("dragStarted", this, {
        evt
      });
      if (this.nativeDraggable) {
        on(document, "dragover", _checkOutsideTargetEl);
      }
      var options2 = this.options;
      !fallback && toggleClass$1(dragEl, options2.dragClass, false);
      toggleClass$1(dragEl, options2.ghostClass, true);
      Sortable.active = this;
      fallback && this._appendGhost();
      _dispatchEvent({
        sortable: this,
        name: "start",
        originalEvent: evt
      });
    } else {
      this._nulling();
    }
  },
  _emulateDragOver: function _emulateDragOver() {
    if (touchEvt) {
      this._lastX = touchEvt.clientX;
      this._lastY = touchEvt.clientY;
      _hideGhostForTarget();
      var target = document.elementFromPoint(touchEvt.clientX, touchEvt.clientY);
      var parent = target;
      while (target && target.shadowRoot) {
        target = target.shadowRoot.elementFromPoint(touchEvt.clientX, touchEvt.clientY);
        if (target === parent) break;
        parent = target;
      }
      dragEl.parentNode[expando]._isOutsideThisEl(target);
      if (parent) {
        do {
          if (parent[expando]) {
            var inserted = void 0;
            inserted = parent[expando]._onDragOver({
              clientX: touchEvt.clientX,
              clientY: touchEvt.clientY,
              target,
              rootEl: parent
            });
            if (inserted && !this.options.dragoverBubble) {
              break;
            }
          }
          target = parent;
        } while (parent = parent.parentNode);
      }
      _unhideGhostForTarget();
    }
  },
  _onTouchMove: function _onTouchMove(evt) {
    if (tapEvt) {
      var options2 = this.options, fallbackTolerance = options2.fallbackTolerance, fallbackOffset = options2.fallbackOffset, touch = evt.touches ? evt.touches[0] : evt, ghostMatrix = ghostEl && matrix(ghostEl, true), scaleX = ghostEl && ghostMatrix && ghostMatrix.a, scaleY = ghostEl && ghostMatrix && ghostMatrix.d, relativeScrollOffset = PositionGhostAbsolutely && ghostRelativeParent && getRelativeScrollOffset(ghostRelativeParent), dx = (touch.clientX - tapEvt.clientX + fallbackOffset.x) / (scaleX || 1) + (relativeScrollOffset ? relativeScrollOffset[0] - ghostRelativeParentInitialScroll[0] : 0) / (scaleX || 1), dy = (touch.clientY - tapEvt.clientY + fallbackOffset.y) / (scaleY || 1) + (relativeScrollOffset ? relativeScrollOffset[1] - ghostRelativeParentInitialScroll[1] : 0) / (scaleY || 1);
      if (!Sortable.active && !awaitingDragStarted) {
        if (fallbackTolerance && Math.max(Math.abs(touch.clientX - this._lastX), Math.abs(touch.clientY - this._lastY)) < fallbackTolerance) {
          return;
        }
        this._onDragStart(evt, true);
      }
      if (ghostEl) {
        if (ghostMatrix) {
          ghostMatrix.e += dx - (lastDx || 0);
          ghostMatrix.f += dy - (lastDy || 0);
        } else {
          ghostMatrix = {
            a: 1,
            b: 0,
            c: 0,
            d: 1,
            e: dx,
            f: dy
          };
        }
        var cssMatrix = "matrix(".concat(ghostMatrix.a, ",").concat(ghostMatrix.b, ",").concat(ghostMatrix.c, ",").concat(ghostMatrix.d, ",").concat(ghostMatrix.e, ",").concat(ghostMatrix.f, ")");
        css(ghostEl, "webkitTransform", cssMatrix);
        css(ghostEl, "mozTransform", cssMatrix);
        css(ghostEl, "msTransform", cssMatrix);
        css(ghostEl, "transform", cssMatrix);
        lastDx = dx;
        lastDy = dy;
        touchEvt = touch;
      }
      evt.cancelable && evt.preventDefault();
    }
  },
  _appendGhost: function _appendGhost() {
    if (!ghostEl) {
      var container = this.options.fallbackOnBody ? document.body : rootEl, rect = getRect(dragEl, true, PositionGhostAbsolutely, true, container), options2 = this.options;
      if (PositionGhostAbsolutely) {
        ghostRelativeParent = container;
        while (css(ghostRelativeParent, "position") === "static" && css(ghostRelativeParent, "transform") === "none" && ghostRelativeParent !== document) {
          ghostRelativeParent = ghostRelativeParent.parentNode;
        }
        if (ghostRelativeParent !== document.body && ghostRelativeParent !== document.documentElement) {
          if (ghostRelativeParent === document) ghostRelativeParent = getWindowScrollingElement();
          rect.top += ghostRelativeParent.scrollTop;
          rect.left += ghostRelativeParent.scrollLeft;
        } else {
          ghostRelativeParent = getWindowScrollingElement();
        }
        ghostRelativeParentInitialScroll = getRelativeScrollOffset(ghostRelativeParent);
      }
      ghostEl = dragEl.cloneNode(true);
      toggleClass$1(ghostEl, options2.ghostClass, false);
      toggleClass$1(ghostEl, options2.fallbackClass, true);
      toggleClass$1(ghostEl, options2.dragClass, true);
      css(ghostEl, "transition", "");
      css(ghostEl, "transform", "");
      css(ghostEl, "box-sizing", "border-box");
      css(ghostEl, "margin", 0);
      css(ghostEl, "top", rect.top);
      css(ghostEl, "left", rect.left);
      css(ghostEl, "width", rect.width);
      css(ghostEl, "height", rect.height);
      css(ghostEl, "opacity", "0.8");
      css(ghostEl, "position", PositionGhostAbsolutely ? "absolute" : "fixed");
      css(ghostEl, "zIndex", "100000");
      css(ghostEl, "pointerEvents", "none");
      Sortable.ghost = ghostEl;
      container.appendChild(ghostEl);
      css(ghostEl, "transform-origin", tapDistanceLeft / parseInt(ghostEl.style.width) * 100 + "% " + tapDistanceTop / parseInt(ghostEl.style.height) * 100 + "%");
    }
  },
  _onDragStart: function _onDragStart(evt, fallback) {
    var _this = this;
    var dataTransfer = evt.dataTransfer;
    var options2 = _this.options;
    pluginEvent2("dragStart", this, {
      evt
    });
    if (Sortable.eventCanceled) {
      this._onDrop();
      return;
    }
    pluginEvent2("setupClone", this);
    if (!Sortable.eventCanceled) {
      cloneEl = clone$2(dragEl);
      cloneEl.draggable = false;
      cloneEl.style["will-change"] = "";
      this._hideClone();
      toggleClass$1(cloneEl, this.options.chosenClass, false);
      Sortable.clone = cloneEl;
    }
    _this.cloneId = _nextTick(function() {
      pluginEvent2("clone", _this);
      if (Sortable.eventCanceled) return;
      if (!_this.options.removeCloneOnHide) {
        rootEl.insertBefore(cloneEl, dragEl);
      }
      _this._hideClone();
      _dispatchEvent({
        sortable: _this,
        name: "clone"
      });
    });
    !fallback && toggleClass$1(dragEl, options2.dragClass, true);
    if (fallback) {
      ignoreNextClick = true;
      _this._loopId = setInterval(_this._emulateDragOver, 50);
    } else {
      off(document, "mouseup", _this._onDrop);
      off(document, "touchend", _this._onDrop);
      off(document, "touchcancel", _this._onDrop);
      if (dataTransfer) {
        dataTransfer.effectAllowed = "move";
        options2.setData && options2.setData.call(_this, dataTransfer, dragEl);
      }
      on(document, "drop", _this);
      css(dragEl, "transform", "translateZ(0)");
    }
    awaitingDragStarted = true;
    _this._dragStartId = _nextTick(_this._dragStarted.bind(_this, fallback, evt));
    on(document, "selectstart", _this);
    moved = true;
    if (Safari) {
      css(document.body, "user-select", "none");
    }
  },
  // Returns true - if no further action is needed (either inserted or another condition)
  _onDragOver: function _onDragOver(evt) {
    var el = this.el, target = evt.target, dragRect, targetRect, revert, options2 = this.options, group = options2.group, activeSortable = Sortable.active, isOwner = activeGroup === group, canSort = options2.sort, fromSortable = putSortable || activeSortable, vertical, _this = this, completedFired = false;
    if (_silent) return;
    function dragOverEvent(name2, extra) {
      pluginEvent2(name2, _this, _objectSpread2({
        evt,
        isOwner,
        axis: vertical ? "vertical" : "horizontal",
        revert,
        dragRect,
        targetRect,
        canSort,
        fromSortable,
        target,
        completed,
        onMove: function onMove(target2, after2) {
          return _onMove(rootEl, el, dragEl, dragRect, target2, getRect(target2), evt, after2);
        },
        changed
      }, extra));
    }
    function capture() {
      dragOverEvent("dragOverAnimationCapture");
      _this.captureAnimationState();
      if (_this !== fromSortable) {
        fromSortable.captureAnimationState();
      }
    }
    function completed(insertion) {
      dragOverEvent("dragOverCompleted", {
        insertion
      });
      if (insertion) {
        if (isOwner) {
          activeSortable._hideClone();
        } else {
          activeSortable._showClone(_this);
        }
        if (_this !== fromSortable) {
          toggleClass$1(dragEl, putSortable ? putSortable.options.ghostClass : activeSortable.options.ghostClass, false);
          toggleClass$1(dragEl, options2.ghostClass, true);
        }
        if (putSortable !== _this && _this !== Sortable.active) {
          putSortable = _this;
        } else if (_this === Sortable.active && putSortable) {
          putSortable = null;
        }
        if (fromSortable === _this) {
          _this._ignoreWhileAnimating = target;
        }
        _this.animateAll(function() {
          dragOverEvent("dragOverAnimationComplete");
          _this._ignoreWhileAnimating = null;
        });
        if (_this !== fromSortable) {
          fromSortable.animateAll();
          fromSortable._ignoreWhileAnimating = null;
        }
      }
      if (target === dragEl && !dragEl.animated || target === el && !target.animated) {
        lastTarget = null;
      }
      if (!options2.dragoverBubble && !evt.rootEl && target !== document) {
        dragEl.parentNode[expando]._isOutsideThisEl(evt.target);
        !insertion && nearestEmptyInsertDetectEvent(evt);
      }
      !options2.dragoverBubble && evt.stopPropagation && evt.stopPropagation();
      return completedFired = true;
    }
    function changed() {
      newIndex = index(dragEl);
      newDraggableIndex = index(dragEl, options2.draggable);
      _dispatchEvent({
        sortable: _this,
        name: "change",
        toEl: el,
        newIndex,
        newDraggableIndex,
        originalEvent: evt
      });
    }
    if (evt.preventDefault !== void 0) {
      evt.cancelable && evt.preventDefault();
    }
    target = closest(target, options2.draggable, el, true);
    dragOverEvent("dragOver");
    if (Sortable.eventCanceled) return completedFired;
    if (dragEl.contains(evt.target) || target.animated && target.animatingX && target.animatingY || _this._ignoreWhileAnimating === target) {
      return completed(false);
    }
    ignoreNextClick = false;
    if (activeSortable && !options2.disabled && (isOwner ? canSort || (revert = parentEl !== rootEl) : putSortable === this || (this.lastPutMode = activeGroup.checkPull(this, activeSortable, dragEl, evt)) && group.checkPut(this, activeSortable, dragEl, evt))) {
      vertical = this._getDirection(evt, target) === "vertical";
      dragRect = getRect(dragEl);
      dragOverEvent("dragOverValid");
      if (Sortable.eventCanceled) return completedFired;
      if (revert) {
        parentEl = rootEl;
        capture();
        this._hideClone();
        dragOverEvent("revert");
        if (!Sortable.eventCanceled) {
          if (nextEl) {
            rootEl.insertBefore(dragEl, nextEl);
          } else {
            rootEl.appendChild(dragEl);
          }
        }
        return completed(true);
      }
      var elLastChild = lastChild(el, options2.draggable);
      if (!elLastChild || _ghostIsLast(evt, vertical, this) && !elLastChild.animated) {
        if (elLastChild === dragEl) {
          return completed(false);
        }
        if (elLastChild && el === evt.target) {
          target = elLastChild;
        }
        if (target) {
          targetRect = getRect(target);
        }
        if (_onMove(rootEl, el, dragEl, dragRect, target, targetRect, evt, !!target) !== false) {
          capture();
          el.appendChild(dragEl);
          parentEl = el;
          changed();
          return completed(true);
        }
      } else if (elLastChild && _ghostIsFirst(evt, vertical, this)) {
        var firstChild = getChild(el, 0, options2, true);
        if (firstChild === dragEl) {
          return completed(false);
        }
        target = firstChild;
        targetRect = getRect(target);
        if (_onMove(rootEl, el, dragEl, dragRect, target, targetRect, evt, false) !== false) {
          capture();
          el.insertBefore(dragEl, firstChild);
          parentEl = el;
          changed();
          return completed(true);
        }
      } else if (target.parentNode === el) {
        targetRect = getRect(target);
        var direction = 0, targetBeforeFirstSwap, differentLevel = dragEl.parentNode !== el, differentRowCol = !_dragElInRowColumn(dragEl.animated && dragEl.toRect || dragRect, target.animated && target.toRect || targetRect, vertical), side1 = vertical ? "top" : "left", scrolledPastTop = isScrolledPast(target, "top", "top") || isScrolledPast(dragEl, "top", "top"), scrollBefore = scrolledPastTop ? scrolledPastTop.scrollTop : void 0;
        if (lastTarget !== target) {
          targetBeforeFirstSwap = targetRect[side1];
          pastFirstInvertThresh = false;
          isCircumstantialInvert = !differentRowCol && options2.invertSwap || differentLevel;
        }
        direction = _getSwapDirection(evt, target, targetRect, vertical, differentRowCol ? 1 : options2.swapThreshold, options2.invertedSwapThreshold == null ? options2.swapThreshold : options2.invertedSwapThreshold, isCircumstantialInvert, lastTarget === target);
        var sibling;
        if (direction !== 0) {
          var dragIndex = index(dragEl);
          do {
            dragIndex -= direction;
            sibling = parentEl.children[dragIndex];
          } while (sibling && (css(sibling, "display") === "none" || sibling === ghostEl));
        }
        if (direction === 0 || sibling === target) {
          return completed(false);
        }
        lastTarget = target;
        lastDirection = direction;
        var nextSibling = target.nextElementSibling, after = false;
        after = direction === 1;
        var moveVector = _onMove(rootEl, el, dragEl, dragRect, target, targetRect, evt, after);
        if (moveVector !== false) {
          if (moveVector === 1 || moveVector === -1) {
            after = moveVector === 1;
          }
          _silent = true;
          setTimeout(_unsilent, 30);
          capture();
          if (after && !nextSibling) {
            el.appendChild(dragEl);
          } else {
            target.parentNode.insertBefore(dragEl, after ? nextSibling : target);
          }
          if (scrolledPastTop) {
            scrollBy(scrolledPastTop, 0, scrollBefore - scrolledPastTop.scrollTop);
          }
          parentEl = dragEl.parentNode;
          if (targetBeforeFirstSwap !== void 0 && !isCircumstantialInvert) {
            targetMoveDistance = Math.abs(targetBeforeFirstSwap - getRect(target)[side1]);
          }
          changed();
          return completed(true);
        }
      }
      if (el.contains(dragEl)) {
        return completed(false);
      }
    }
    return false;
  },
  _ignoreWhileAnimating: null,
  _offMoveEvents: function _offMoveEvents() {
    off(document, "mousemove", this._onTouchMove);
    off(document, "touchmove", this._onTouchMove);
    off(document, "pointermove", this._onTouchMove);
    off(document, "dragover", nearestEmptyInsertDetectEvent);
    off(document, "mousemove", nearestEmptyInsertDetectEvent);
    off(document, "touchmove", nearestEmptyInsertDetectEvent);
  },
  _offUpEvents: function _offUpEvents() {
    var ownerDocument = this.el.ownerDocument;
    off(ownerDocument, "mouseup", this._onDrop);
    off(ownerDocument, "touchend", this._onDrop);
    off(ownerDocument, "pointerup", this._onDrop);
    off(ownerDocument, "touchcancel", this._onDrop);
    off(document, "selectstart", this);
  },
  _onDrop: function _onDrop(evt) {
    var el = this.el, options2 = this.options;
    newIndex = index(dragEl);
    newDraggableIndex = index(dragEl, options2.draggable);
    pluginEvent2("drop", this, {
      evt
    });
    parentEl = dragEl && dragEl.parentNode;
    newIndex = index(dragEl);
    newDraggableIndex = index(dragEl, options2.draggable);
    if (Sortable.eventCanceled) {
      this._nulling();
      return;
    }
    awaitingDragStarted = false;
    isCircumstantialInvert = false;
    pastFirstInvertThresh = false;
    clearInterval(this._loopId);
    clearTimeout(this._dragStartTimer);
    _cancelNextTick(this.cloneId);
    _cancelNextTick(this._dragStartId);
    if (this.nativeDraggable) {
      off(document, "drop", this);
      off(el, "dragstart", this._onDragStart);
    }
    this._offMoveEvents();
    this._offUpEvents();
    if (Safari) {
      css(document.body, "user-select", "");
    }
    css(dragEl, "transform", "");
    if (evt) {
      if (moved) {
        evt.cancelable && evt.preventDefault();
        !options2.dropBubble && evt.stopPropagation();
      }
      ghostEl && ghostEl.parentNode && ghostEl.parentNode.removeChild(ghostEl);
      if (rootEl === parentEl || putSortable && putSortable.lastPutMode !== "clone") {
        cloneEl && cloneEl.parentNode && cloneEl.parentNode.removeChild(cloneEl);
      }
      if (dragEl) {
        if (this.nativeDraggable) {
          off(dragEl, "dragend", this);
        }
        _disableDraggable(dragEl);
        dragEl.style["will-change"] = "";
        if (moved && !awaitingDragStarted) {
          toggleClass$1(dragEl, putSortable ? putSortable.options.ghostClass : this.options.ghostClass, false);
        }
        toggleClass$1(dragEl, this.options.chosenClass, false);
        _dispatchEvent({
          sortable: this,
          name: "unchoose",
          toEl: parentEl,
          newIndex: null,
          newDraggableIndex: null,
          originalEvent: evt
        });
        if (rootEl !== parentEl) {
          if (newIndex >= 0) {
            _dispatchEvent({
              rootEl: parentEl,
              name: "add",
              toEl: parentEl,
              fromEl: rootEl,
              originalEvent: evt
            });
            _dispatchEvent({
              sortable: this,
              name: "remove",
              toEl: parentEl,
              originalEvent: evt
            });
            _dispatchEvent({
              rootEl: parentEl,
              name: "sort",
              toEl: parentEl,
              fromEl: rootEl,
              originalEvent: evt
            });
            _dispatchEvent({
              sortable: this,
              name: "sort",
              toEl: parentEl,
              originalEvent: evt
            });
          }
          putSortable && putSortable.save();
        } else {
          if (newIndex !== oldIndex) {
            if (newIndex >= 0) {
              _dispatchEvent({
                sortable: this,
                name: "update",
                toEl: parentEl,
                originalEvent: evt
              });
              _dispatchEvent({
                sortable: this,
                name: "sort",
                toEl: parentEl,
                originalEvent: evt
              });
            }
          }
        }
        if (Sortable.active) {
          if (newIndex == null || newIndex === -1) {
            newIndex = oldIndex;
            newDraggableIndex = oldDraggableIndex;
          }
          _dispatchEvent({
            sortable: this,
            name: "end",
            toEl: parentEl,
            originalEvent: evt
          });
          this.save();
        }
      }
    }
    this._nulling();
  },
  _nulling: function _nulling() {
    pluginEvent2("nulling", this);
    rootEl = dragEl = parentEl = ghostEl = nextEl = cloneEl = lastDownEl = cloneHidden = tapEvt = touchEvt = moved = newIndex = newDraggableIndex = oldIndex = oldDraggableIndex = lastTarget = lastDirection = putSortable = activeGroup = Sortable.dragged = Sortable.ghost = Sortable.clone = Sortable.active = null;
    savedInputChecked.forEach(function(el) {
      el.checked = true;
    });
    savedInputChecked.length = lastDx = lastDy = 0;
  },
  handleEvent: function handleEvent(evt) {
    switch (evt.type) {
      case "drop":
      case "dragend":
        this._onDrop(evt);
        break;
      case "dragenter":
      case "dragover":
        if (dragEl) {
          this._onDragOver(evt);
          _globalDragOver(evt);
        }
        break;
      case "selectstart":
        evt.preventDefault();
        break;
    }
  },
  /**
   * Serializes the item into an array of string.
   * @returns {String[]}
   */
  toArray: function toArray() {
    var order = [], el, children = this.el.children, i = 0, n = children.length, options2 = this.options;
    for (; i < n; i++) {
      el = children[i];
      if (closest(el, options2.draggable, this.el, false)) {
        order.push(el.getAttribute(options2.dataIdAttr) || _generateId(el));
      }
    }
    return order;
  },
  /**
   * Sorts the elements according to the array.
   * @param  {String[]}  order  order of the items
   */
  sort: function sort(order, useAnimation) {
    var items = {}, rootEl2 = this.el;
    this.toArray().forEach(function(id, i) {
      var el = rootEl2.children[i];
      if (closest(el, this.options.draggable, rootEl2, false)) {
        items[id] = el;
      }
    }, this);
    useAnimation && this.captureAnimationState();
    order.forEach(function(id) {
      if (items[id]) {
        rootEl2.removeChild(items[id]);
        rootEl2.appendChild(items[id]);
      }
    });
    useAnimation && this.animateAll();
  },
  /**
   * Save the current sorting
   */
  save: function save() {
    var store = this.options.store;
    store && store.set && store.set(this);
  },
  /**
   * For each element in the set, get the first element that matches the selector by testing the element itself and traversing up through its ancestors in the DOM tree.
   * @param   {HTMLElement}  el
   * @param   {String}       [selector]  default: `options.draggable`
   * @returns {HTMLElement|null}
   */
  closest: function closest$1(el, selector) {
    return closest(el, selector || this.options.draggable, this.el, false);
  },
  /**
   * Set/get option
   * @param   {string} name
   * @param   {*}      [value]
   * @returns {*}
   */
  option: function option(name2, value) {
    var options2 = this.options;
    if (value === void 0) {
      return options2[name2];
    } else {
      var modifiedValue = PluginManager.modifyOption(this, name2, value);
      if (typeof modifiedValue !== "undefined") {
        options2[name2] = modifiedValue;
      } else {
        options2[name2] = value;
      }
      if (name2 === "group") {
        _prepareGroup(options2);
      }
    }
  },
  /**
   * Destroy
   */
  destroy: function destroy() {
    pluginEvent2("destroy", this);
    var el = this.el;
    el[expando] = null;
    off(el, "mousedown", this._onTapStart);
    off(el, "touchstart", this._onTapStart);
    off(el, "pointerdown", this._onTapStart);
    if (this.nativeDraggable) {
      off(el, "dragover", this);
      off(el, "dragenter", this);
    }
    Array.prototype.forEach.call(el.querySelectorAll("[draggable]"), function(el2) {
      el2.removeAttribute("draggable");
    });
    this._onDrop();
    this._disableDelayedDragEvents();
    sortables.splice(sortables.indexOf(this.el), 1);
    this.el = el = null;
  },
  _hideClone: function _hideClone() {
    if (!cloneHidden) {
      pluginEvent2("hideClone", this);
      if (Sortable.eventCanceled) return;
      css(cloneEl, "display", "none");
      if (this.options.removeCloneOnHide && cloneEl.parentNode) {
        cloneEl.parentNode.removeChild(cloneEl);
      }
      cloneHidden = true;
    }
  },
  _showClone: function _showClone(putSortable2) {
    if (putSortable2.lastPutMode !== "clone") {
      this._hideClone();
      return;
    }
    if (cloneHidden) {
      pluginEvent2("showClone", this);
      if (Sortable.eventCanceled) return;
      if (dragEl.parentNode == rootEl && !this.options.group.revertClone) {
        rootEl.insertBefore(cloneEl, dragEl);
      } else if (nextEl) {
        rootEl.insertBefore(cloneEl, nextEl);
      } else {
        rootEl.appendChild(cloneEl);
      }
      if (this.options.group.revertClone) {
        this.animate(dragEl, cloneEl);
      }
      css(cloneEl, "display", "");
      cloneHidden = false;
    }
  }
};
function _globalDragOver(evt) {
  if (evt.dataTransfer) {
    evt.dataTransfer.dropEffect = "move";
  }
  evt.cancelable && evt.preventDefault();
}
function _onMove(fromEl, toEl, dragEl2, dragRect, targetEl, targetRect, originalEvent, willInsertAfter) {
  var evt, sortable = fromEl[expando], onMoveFn = sortable.options.onMove, retVal;
  if (window.CustomEvent && !IE11OrLess && !Edge) {
    evt = new CustomEvent("move", {
      bubbles: true,
      cancelable: true
    });
  } else {
    evt = document.createEvent("Event");
    evt.initEvent("move", true, true);
  }
  evt.to = toEl;
  evt.from = fromEl;
  evt.dragged = dragEl2;
  evt.draggedRect = dragRect;
  evt.related = targetEl || toEl;
  evt.relatedRect = targetRect || getRect(toEl);
  evt.willInsertAfter = willInsertAfter;
  evt.originalEvent = originalEvent;
  fromEl.dispatchEvent(evt);
  if (onMoveFn) {
    retVal = onMoveFn.call(sortable, evt, originalEvent);
  }
  return retVal;
}
function _disableDraggable(el) {
  el.draggable = false;
}
function _unsilent() {
  _silent = false;
}
function _ghostIsFirst(evt, vertical, sortable) {
  var rect = getRect(getChild(sortable.el, 0, sortable.options, true));
  var spacer = 10;
  return vertical ? evt.clientX < rect.left - spacer || evt.clientY < rect.top && evt.clientX < rect.right : evt.clientY < rect.top - spacer || evt.clientY < rect.bottom && evt.clientX < rect.left;
}
function _ghostIsLast(evt, vertical, sortable) {
  var rect = getRect(lastChild(sortable.el, sortable.options.draggable));
  var spacer = 10;
  return vertical ? evt.clientX > rect.right + spacer || evt.clientX <= rect.right && evt.clientY > rect.bottom && evt.clientX >= rect.left : evt.clientX > rect.right && evt.clientY > rect.top || evt.clientX <= rect.right && evt.clientY > rect.bottom + spacer;
}
function _getSwapDirection(evt, target, targetRect, vertical, swapThreshold, invertedSwapThreshold, invertSwap, isLastTarget) {
  var mouseOnAxis = vertical ? evt.clientY : evt.clientX, targetLength = vertical ? targetRect.height : targetRect.width, targetS1 = vertical ? targetRect.top : targetRect.left, targetS2 = vertical ? targetRect.bottom : targetRect.right, invert = false;
  if (!invertSwap) {
    if (isLastTarget && targetMoveDistance < targetLength * swapThreshold) {
      if (!pastFirstInvertThresh && (lastDirection === 1 ? mouseOnAxis > targetS1 + targetLength * invertedSwapThreshold / 2 : mouseOnAxis < targetS2 - targetLength * invertedSwapThreshold / 2)) {
        pastFirstInvertThresh = true;
      }
      if (!pastFirstInvertThresh) {
        if (lastDirection === 1 ? mouseOnAxis < targetS1 + targetMoveDistance : mouseOnAxis > targetS2 - targetMoveDistance) {
          return -lastDirection;
        }
      } else {
        invert = true;
      }
    } else {
      if (mouseOnAxis > targetS1 + targetLength * (1 - swapThreshold) / 2 && mouseOnAxis < targetS2 - targetLength * (1 - swapThreshold) / 2) {
        return _getInsertDirection(target);
      }
    }
  }
  invert = invert || invertSwap;
  if (invert) {
    if (mouseOnAxis < targetS1 + targetLength * invertedSwapThreshold / 2 || mouseOnAxis > targetS2 - targetLength * invertedSwapThreshold / 2) {
      return mouseOnAxis > targetS1 + targetLength / 2 ? 1 : -1;
    }
  }
  return 0;
}
function _getInsertDirection(target) {
  if (index(dragEl) < index(target)) {
    return 1;
  } else {
    return -1;
  }
}
function _generateId(el) {
  var str = el.tagName + el.className + el.src + el.href + el.textContent, i = str.length, sum = 0;
  while (i--) {
    sum += str.charCodeAt(i);
  }
  return sum.toString(36);
}
function _saveInputCheckedState(root) {
  savedInputChecked.length = 0;
  var inputs = root.getElementsByTagName("input");
  var idx = inputs.length;
  while (idx--) {
    var el = inputs[idx];
    el.checked && savedInputChecked.push(el);
  }
}
function _nextTick(fn) {
  return setTimeout(fn, 0);
}
function _cancelNextTick(id) {
  return clearTimeout(id);
}
if (documentExists) {
  on(document, "touchmove", function(evt) {
    if ((Sortable.active || awaitingDragStarted) && evt.cancelable) {
      evt.preventDefault();
    }
  });
}
Sortable.utils = {
  on,
  off,
  css,
  find,
  is: function is(el, selector) {
    return !!closest(el, selector, el, false);
  },
  extend: extend$1,
  throttle,
  closest,
  toggleClass: toggleClass$1,
  clone: clone$2,
  index,
  nextTick: _nextTick,
  cancelNextTick: _cancelNextTick,
  detectDirection: _detectDirection,
  getChild
};
Sortable.get = function(element) {
  return element[expando];
};
Sortable.mount = function() {
  for (var _len = arguments.length, plugins2 = new Array(_len), _key = 0; _key < _len; _key++) {
    plugins2[_key] = arguments[_key];
  }
  if (plugins2[0].constructor === Array) plugins2 = plugins2[0];
  plugins2.forEach(function(plugin) {
    if (!plugin.prototype || !plugin.prototype.constructor) {
      throw "Sortable: Mounted plugin must be a constructor function, not ".concat({}.toString.call(plugin));
    }
    if (plugin.utils) Sortable.utils = _objectSpread2(_objectSpread2({}, Sortable.utils), plugin.utils);
    PluginManager.mount(plugin);
  });
};
Sortable.create = function(el, options2) {
  return new Sortable(el, options2);
};
Sortable.version = version$1;
var autoScrolls = [], scrollEl, scrollRootEl, scrolling = false, lastAutoScrollX, lastAutoScrollY, touchEvt$1, pointerElemChangedInterval;
function AutoScrollPlugin() {
  function AutoScroll() {
    this.defaults = {
      scroll: true,
      forceAutoScrollFallback: false,
      scrollSensitivity: 30,
      scrollSpeed: 10,
      bubbleScroll: true
    };
    for (var fn in this) {
      if (fn.charAt(0) === "_" && typeof this[fn] === "function") {
        this[fn] = this[fn].bind(this);
      }
    }
  }
  AutoScroll.prototype = {
    dragStarted: function dragStarted2(_ref) {
      var originalEvent = _ref.originalEvent;
      if (this.sortable.nativeDraggable) {
        on(document, "dragover", this._handleAutoScroll);
      } else {
        if (this.options.supportPointer) {
          on(document, "pointermove", this._handleFallbackAutoScroll);
        } else if (originalEvent.touches) {
          on(document, "touchmove", this._handleFallbackAutoScroll);
        } else {
          on(document, "mousemove", this._handleFallbackAutoScroll);
        }
      }
    },
    dragOverCompleted: function dragOverCompleted(_ref2) {
      var originalEvent = _ref2.originalEvent;
      if (!this.options.dragOverBubble && !originalEvent.rootEl) {
        this._handleAutoScroll(originalEvent);
      }
    },
    drop: function drop3() {
      if (this.sortable.nativeDraggable) {
        off(document, "dragover", this._handleAutoScroll);
      } else {
        off(document, "pointermove", this._handleFallbackAutoScroll);
        off(document, "touchmove", this._handleFallbackAutoScroll);
        off(document, "mousemove", this._handleFallbackAutoScroll);
      }
      clearPointerElemChangedInterval();
      clearAutoScrolls();
      cancelThrottle();
    },
    nulling: function nulling() {
      touchEvt$1 = scrollRootEl = scrollEl = scrolling = pointerElemChangedInterval = lastAutoScrollX = lastAutoScrollY = null;
      autoScrolls.length = 0;
    },
    _handleFallbackAutoScroll: function _handleFallbackAutoScroll(evt) {
      this._handleAutoScroll(evt, true);
    },
    _handleAutoScroll: function _handleAutoScroll(evt, fallback) {
      var _this = this;
      var x = (evt.touches ? evt.touches[0] : evt).clientX, y = (evt.touches ? evt.touches[0] : evt).clientY, elem = document.elementFromPoint(x, y);
      touchEvt$1 = evt;
      if (fallback || this.options.forceAutoScrollFallback || Edge || IE11OrLess || Safari) {
        autoScroll(evt, this.options, elem, fallback);
        var ogElemScroller = getParentAutoScrollElement(elem, true);
        if (scrolling && (!pointerElemChangedInterval || x !== lastAutoScrollX || y !== lastAutoScrollY)) {
          pointerElemChangedInterval && clearPointerElemChangedInterval();
          pointerElemChangedInterval = setInterval(function() {
            var newElem = getParentAutoScrollElement(document.elementFromPoint(x, y), true);
            if (newElem !== ogElemScroller) {
              ogElemScroller = newElem;
              clearAutoScrolls();
            }
            autoScroll(evt, _this.options, newElem, fallback);
          }, 10);
          lastAutoScrollX = x;
          lastAutoScrollY = y;
        }
      } else {
        if (!this.options.bubbleScroll || getParentAutoScrollElement(elem, true) === getWindowScrollingElement()) {
          clearAutoScrolls();
          return;
        }
        autoScroll(evt, this.options, getParentAutoScrollElement(elem, false), false);
      }
    }
  };
  return _extends(AutoScroll, {
    pluginName: "scroll",
    initializeByDefault: true
  });
}
function clearAutoScrolls() {
  autoScrolls.forEach(function(autoScroll2) {
    clearInterval(autoScroll2.pid);
  });
  autoScrolls = [];
}
function clearPointerElemChangedInterval() {
  clearInterval(pointerElemChangedInterval);
}
var autoScroll = throttle(function(evt, options2, rootEl2, isFallback) {
  if (!options2.scroll) return;
  var x = (evt.touches ? evt.touches[0] : evt).clientX, y = (evt.touches ? evt.touches[0] : evt).clientY, sens = options2.scrollSensitivity, speed = options2.scrollSpeed, winScroller = getWindowScrollingElement();
  var scrollThisInstance = false, scrollCustomFn;
  if (scrollRootEl !== rootEl2) {
    scrollRootEl = rootEl2;
    clearAutoScrolls();
    scrollEl = options2.scroll;
    scrollCustomFn = options2.scrollFn;
    if (scrollEl === true) {
      scrollEl = getParentAutoScrollElement(rootEl2, true);
    }
  }
  var layersOut = 0;
  var currentParent = scrollEl;
  do {
    var el = currentParent, rect = getRect(el), top = rect.top, bottom = rect.bottom, left = rect.left, right = rect.right, width = rect.width, height = rect.height, canScrollX = void 0, canScrollY = void 0, scrollWidth = el.scrollWidth, scrollHeight = el.scrollHeight, elCSS = css(el), scrollPosX = el.scrollLeft, scrollPosY = el.scrollTop;
    if (el === winScroller) {
      canScrollX = width < scrollWidth && (elCSS.overflowX === "auto" || elCSS.overflowX === "scroll" || elCSS.overflowX === "visible");
      canScrollY = height < scrollHeight && (elCSS.overflowY === "auto" || elCSS.overflowY === "scroll" || elCSS.overflowY === "visible");
    } else {
      canScrollX = width < scrollWidth && (elCSS.overflowX === "auto" || elCSS.overflowX === "scroll");
      canScrollY = height < scrollHeight && (elCSS.overflowY === "auto" || elCSS.overflowY === "scroll");
    }
    var vx = canScrollX && (Math.abs(right - x) <= sens && scrollPosX + width < scrollWidth) - (Math.abs(left - x) <= sens && !!scrollPosX);
    var vy = canScrollY && (Math.abs(bottom - y) <= sens && scrollPosY + height < scrollHeight) - (Math.abs(top - y) <= sens && !!scrollPosY);
    if (!autoScrolls[layersOut]) {
      for (var i = 0; i <= layersOut; i++) {
        if (!autoScrolls[i]) {
          autoScrolls[i] = {};
        }
      }
    }
    if (autoScrolls[layersOut].vx != vx || autoScrolls[layersOut].vy != vy || autoScrolls[layersOut].el !== el) {
      autoScrolls[layersOut].el = el;
      autoScrolls[layersOut].vx = vx;
      autoScrolls[layersOut].vy = vy;
      clearInterval(autoScrolls[layersOut].pid);
      if (vx != 0 || vy != 0) {
        scrollThisInstance = true;
        autoScrolls[layersOut].pid = setInterval((function() {
          if (isFallback && this.layer === 0) {
            Sortable.active._onTouchMove(touchEvt$1);
          }
          var scrollOffsetY = autoScrolls[this.layer].vy ? autoScrolls[this.layer].vy * speed : 0;
          var scrollOffsetX = autoScrolls[this.layer].vx ? autoScrolls[this.layer].vx * speed : 0;
          if (typeof scrollCustomFn === "function") {
            if (scrollCustomFn.call(Sortable.dragged.parentNode[expando], scrollOffsetX, scrollOffsetY, evt, touchEvt$1, autoScrolls[this.layer].el) !== "continue") {
              return;
            }
          }
          scrollBy(autoScrolls[this.layer].el, scrollOffsetX, scrollOffsetY);
        }).bind({
          layer: layersOut
        }), 24);
      }
    }
    layersOut++;
  } while (options2.bubbleScroll && currentParent !== winScroller && (currentParent = getParentAutoScrollElement(currentParent, false)));
  scrolling = scrollThisInstance;
}, 30);
var drop = function drop2(_ref) {
  var originalEvent = _ref.originalEvent, putSortable2 = _ref.putSortable, dragEl2 = _ref.dragEl, activeSortable = _ref.activeSortable, dispatchSortableEvent = _ref.dispatchSortableEvent, hideGhostForTarget = _ref.hideGhostForTarget, unhideGhostForTarget = _ref.unhideGhostForTarget;
  if (!originalEvent) return;
  var toSortable = putSortable2 || activeSortable;
  hideGhostForTarget();
  var touch = originalEvent.changedTouches && originalEvent.changedTouches.length ? originalEvent.changedTouches[0] : originalEvent;
  var target = document.elementFromPoint(touch.clientX, touch.clientY);
  unhideGhostForTarget();
  if (toSortable && !toSortable.el.contains(target)) {
    dispatchSortableEvent("spill");
    this.onSpill({
      dragEl: dragEl2,
      putSortable: putSortable2
    });
  }
};
function Revert() {
}
Revert.prototype = {
  startIndex: null,
  dragStart: function dragStart(_ref2) {
    var oldDraggableIndex2 = _ref2.oldDraggableIndex;
    this.startIndex = oldDraggableIndex2;
  },
  onSpill: function onSpill(_ref3) {
    var dragEl2 = _ref3.dragEl, putSortable2 = _ref3.putSortable;
    this.sortable.captureAnimationState();
    if (putSortable2) {
      putSortable2.captureAnimationState();
    }
    var nextSibling = getChild(this.sortable.el, this.startIndex, this.options);
    if (nextSibling) {
      this.sortable.el.insertBefore(dragEl2, nextSibling);
    } else {
      this.sortable.el.appendChild(dragEl2);
    }
    this.sortable.animateAll();
    if (putSortable2) {
      putSortable2.animateAll();
    }
  },
  drop
};
_extends(Revert, {
  pluginName: "revertOnSpill"
});
function Remove() {
}
Remove.prototype = {
  onSpill: function onSpill2(_ref4) {
    var dragEl2 = _ref4.dragEl, putSortable2 = _ref4.putSortable;
    var parentSortable = putSortable2 || this.sortable;
    parentSortable.captureAnimationState();
    dragEl2.parentNode && dragEl2.parentNode.removeChild(dragEl2);
    parentSortable.animateAll();
  },
  drop
};
_extends(Remove, {
  pluginName: "removeOnSpill"
});
var lastSwapEl;
function SwapPlugin() {
  function Swap() {
    this.defaults = {
      swapClass: "sortable-swap-highlight"
    };
  }
  Swap.prototype = {
    dragStart: function dragStart2(_ref) {
      var dragEl2 = _ref.dragEl;
      lastSwapEl = dragEl2;
    },
    dragOverValid: function dragOverValid(_ref2) {
      var completed = _ref2.completed, target = _ref2.target, onMove = _ref2.onMove, activeSortable = _ref2.activeSortable, changed = _ref2.changed, cancel = _ref2.cancel;
      if (!activeSortable.options.swap) return;
      var el = this.sortable.el, options2 = this.options;
      if (target && target !== el) {
        var prevSwapEl = lastSwapEl;
        if (onMove(target) !== false) {
          toggleClass$1(target, options2.swapClass, true);
          lastSwapEl = target;
        } else {
          lastSwapEl = null;
        }
        if (prevSwapEl && prevSwapEl !== lastSwapEl) {
          toggleClass$1(prevSwapEl, options2.swapClass, false);
        }
      }
      changed();
      completed(true);
      cancel();
    },
    drop: function drop3(_ref3) {
      var activeSortable = _ref3.activeSortable, putSortable2 = _ref3.putSortable, dragEl2 = _ref3.dragEl;
      var toSortable = putSortable2 || this.sortable;
      var options2 = this.options;
      lastSwapEl && toggleClass$1(lastSwapEl, options2.swapClass, false);
      if (lastSwapEl && (options2.swap || putSortable2 && putSortable2.options.swap)) {
        if (dragEl2 !== lastSwapEl) {
          toSortable.captureAnimationState();
          if (toSortable !== activeSortable) activeSortable.captureAnimationState();
          swapNodes(dragEl2, lastSwapEl);
          toSortable.animateAll();
          if (toSortable !== activeSortable) activeSortable.animateAll();
        }
      }
    },
    nulling: function nulling() {
      lastSwapEl = null;
    }
  };
  return _extends(Swap, {
    pluginName: "swap",
    eventProperties: function eventProperties() {
      return {
        swapItem: lastSwapEl
      };
    }
  });
}
function swapNodes(n1, n2) {
  var p1 = n1.parentNode, p2 = n2.parentNode, i1, i2;
  if (!p1 || !p2 || p1.isEqualNode(n2) || p2.isEqualNode(n1)) return;
  i1 = index(n1);
  i2 = index(n2);
  if (p1.isEqualNode(p2) && i1 < i2) {
    i2++;
  }
  p1.insertBefore(n2, p1.children[i1]);
  p2.insertBefore(n1, p2.children[i2]);
}
var multiDragElements = [], multiDragClones = [], lastMultiDragSelect, multiDragSortable, initialFolding = false, folding = false, dragStarted = false, dragEl$1, clonesFromRect, clonesHidden;
function MultiDragPlugin() {
  function MultiDrag(sortable) {
    for (var fn in this) {
      if (fn.charAt(0) === "_" && typeof this[fn] === "function") {
        this[fn] = this[fn].bind(this);
      }
    }
    if (sortable.options.supportPointer) {
      on(document, "pointerup", this._deselectMultiDrag);
    } else {
      on(document, "mouseup", this._deselectMultiDrag);
      on(document, "touchend", this._deselectMultiDrag);
    }
    on(document, "keydown", this._checkKeyDown);
    on(document, "keyup", this._checkKeyUp);
    this.defaults = {
      selectedClass: "sortable-selected",
      multiDragKey: null,
      setData: function setData(dataTransfer, dragEl2) {
        var data = "";
        if (multiDragElements.length && multiDragSortable === sortable) {
          multiDragElements.forEach(function(multiDragElement, i) {
            data += (!i ? "" : ", ") + multiDragElement.textContent;
          });
        } else {
          data = dragEl2.textContent;
        }
        dataTransfer.setData("Text", data);
      }
    };
  }
  MultiDrag.prototype = {
    multiDragKeyDown: false,
    isMultiDrag: false,
    delayStartGlobal: function delayStartGlobal(_ref) {
      var dragged = _ref.dragEl;
      dragEl$1 = dragged;
    },
    delayEnded: function delayEnded() {
      this.isMultiDrag = ~multiDragElements.indexOf(dragEl$1);
    },
    setupClone: function setupClone(_ref2) {
      var sortable = _ref2.sortable, cancel = _ref2.cancel;
      if (!this.isMultiDrag) return;
      for (var i = 0; i < multiDragElements.length; i++) {
        multiDragClones.push(clone$2(multiDragElements[i]));
        multiDragClones[i].sortableIndex = multiDragElements[i].sortableIndex;
        multiDragClones[i].draggable = false;
        multiDragClones[i].style["will-change"] = "";
        toggleClass$1(multiDragClones[i], this.options.selectedClass, false);
        multiDragElements[i] === dragEl$1 && toggleClass$1(multiDragClones[i], this.options.chosenClass, false);
      }
      sortable._hideClone();
      cancel();
    },
    clone: function clone2(_ref3) {
      var sortable = _ref3.sortable, rootEl2 = _ref3.rootEl, dispatchSortableEvent = _ref3.dispatchSortableEvent, cancel = _ref3.cancel;
      if (!this.isMultiDrag) return;
      if (!this.options.removeCloneOnHide) {
        if (multiDragElements.length && multiDragSortable === sortable) {
          insertMultiDragClones(true, rootEl2);
          dispatchSortableEvent("clone");
          cancel();
        }
      }
    },
    showClone: function showClone(_ref4) {
      var cloneNowShown = _ref4.cloneNowShown, rootEl2 = _ref4.rootEl, cancel = _ref4.cancel;
      if (!this.isMultiDrag) return;
      insertMultiDragClones(false, rootEl2);
      multiDragClones.forEach(function(clone2) {
        css(clone2, "display", "");
      });
      cloneNowShown();
      clonesHidden = false;
      cancel();
    },
    hideClone: function hideClone(_ref5) {
      var _this = this;
      _ref5.sortable;
      var cloneNowHidden = _ref5.cloneNowHidden, cancel = _ref5.cancel;
      if (!this.isMultiDrag) return;
      multiDragClones.forEach(function(clone2) {
        css(clone2, "display", "none");
        if (_this.options.removeCloneOnHide && clone2.parentNode) {
          clone2.parentNode.removeChild(clone2);
        }
      });
      cloneNowHidden();
      clonesHidden = true;
      cancel();
    },
    dragStartGlobal: function dragStartGlobal(_ref6) {
      _ref6.sortable;
      if (!this.isMultiDrag && multiDragSortable) {
        multiDragSortable.multiDrag._deselectMultiDrag();
      }
      multiDragElements.forEach(function(multiDragElement) {
        multiDragElement.sortableIndex = index(multiDragElement);
      });
      multiDragElements = multiDragElements.sort(function(a, b) {
        return a.sortableIndex - b.sortableIndex;
      });
      dragStarted = true;
    },
    dragStarted: function dragStarted2(_ref7) {
      var _this2 = this;
      var sortable = _ref7.sortable;
      if (!this.isMultiDrag) return;
      if (this.options.sort) {
        sortable.captureAnimationState();
        if (this.options.animation) {
          multiDragElements.forEach(function(multiDragElement) {
            if (multiDragElement === dragEl$1) return;
            css(multiDragElement, "position", "absolute");
          });
          var dragRect = getRect(dragEl$1, false, true, true);
          multiDragElements.forEach(function(multiDragElement) {
            if (multiDragElement === dragEl$1) return;
            setRect(multiDragElement, dragRect);
          });
          folding = true;
          initialFolding = true;
        }
      }
      sortable.animateAll(function() {
        folding = false;
        initialFolding = false;
        if (_this2.options.animation) {
          multiDragElements.forEach(function(multiDragElement) {
            unsetRect(multiDragElement);
          });
        }
        if (_this2.options.sort) {
          removeMultiDragElements();
        }
      });
    },
    dragOver: function dragOver(_ref8) {
      var target = _ref8.target, completed = _ref8.completed, cancel = _ref8.cancel;
      if (folding && ~multiDragElements.indexOf(target)) {
        completed(false);
        cancel();
      }
    },
    revert: function revert(_ref9) {
      var fromSortable = _ref9.fromSortable, rootEl2 = _ref9.rootEl, sortable = _ref9.sortable, dragRect = _ref9.dragRect;
      if (multiDragElements.length > 1) {
        multiDragElements.forEach(function(multiDragElement) {
          sortable.addAnimationState({
            target: multiDragElement,
            rect: folding ? getRect(multiDragElement) : dragRect
          });
          unsetRect(multiDragElement);
          multiDragElement.fromRect = dragRect;
          fromSortable.removeAnimationState(multiDragElement);
        });
        folding = false;
        insertMultiDragElements(!this.options.removeCloneOnHide, rootEl2);
      }
    },
    dragOverCompleted: function dragOverCompleted(_ref10) {
      var sortable = _ref10.sortable, isOwner = _ref10.isOwner, insertion = _ref10.insertion, activeSortable = _ref10.activeSortable, parentEl2 = _ref10.parentEl, putSortable2 = _ref10.putSortable;
      var options2 = this.options;
      if (insertion) {
        if (isOwner) {
          activeSortable._hideClone();
        }
        initialFolding = false;
        if (options2.animation && multiDragElements.length > 1 && (folding || !isOwner && !activeSortable.options.sort && !putSortable2)) {
          var dragRectAbsolute = getRect(dragEl$1, false, true, true);
          multiDragElements.forEach(function(multiDragElement) {
            if (multiDragElement === dragEl$1) return;
            setRect(multiDragElement, dragRectAbsolute);
            parentEl2.appendChild(multiDragElement);
          });
          folding = true;
        }
        if (!isOwner) {
          if (!folding) {
            removeMultiDragElements();
          }
          if (multiDragElements.length > 1) {
            var clonesHiddenBefore = clonesHidden;
            activeSortable._showClone(sortable);
            if (activeSortable.options.animation && !clonesHidden && clonesHiddenBefore) {
              multiDragClones.forEach(function(clone2) {
                activeSortable.addAnimationState({
                  target: clone2,
                  rect: clonesFromRect
                });
                clone2.fromRect = clonesFromRect;
                clone2.thisAnimationDuration = null;
              });
            }
          } else {
            activeSortable._showClone(sortable);
          }
        }
      }
    },
    dragOverAnimationCapture: function dragOverAnimationCapture(_ref11) {
      var dragRect = _ref11.dragRect, isOwner = _ref11.isOwner, activeSortable = _ref11.activeSortable;
      multiDragElements.forEach(function(multiDragElement) {
        multiDragElement.thisAnimationDuration = null;
      });
      if (activeSortable.options.animation && !isOwner && activeSortable.multiDrag.isMultiDrag) {
        clonesFromRect = _extends({}, dragRect);
        var dragMatrix = matrix(dragEl$1, true);
        clonesFromRect.top -= dragMatrix.f;
        clonesFromRect.left -= dragMatrix.e;
      }
    },
    dragOverAnimationComplete: function dragOverAnimationComplete() {
      if (folding) {
        folding = false;
        removeMultiDragElements();
      }
    },
    drop: function drop3(_ref12) {
      var evt = _ref12.originalEvent, rootEl2 = _ref12.rootEl, parentEl2 = _ref12.parentEl, sortable = _ref12.sortable, dispatchSortableEvent = _ref12.dispatchSortableEvent, oldIndex2 = _ref12.oldIndex, putSortable2 = _ref12.putSortable;
      var toSortable = putSortable2 || this.sortable;
      if (!evt) return;
      var options2 = this.options, children = parentEl2.children;
      if (!dragStarted) {
        if (options2.multiDragKey && !this.multiDragKeyDown) {
          this._deselectMultiDrag();
        }
        toggleClass$1(dragEl$1, options2.selectedClass, !~multiDragElements.indexOf(dragEl$1));
        if (!~multiDragElements.indexOf(dragEl$1)) {
          multiDragElements.push(dragEl$1);
          dispatchEvent({
            sortable,
            rootEl: rootEl2,
            name: "select",
            targetEl: dragEl$1
          });
          if (evt.shiftKey && lastMultiDragSelect && sortable.el.contains(lastMultiDragSelect)) {
            var lastIndex = index(lastMultiDragSelect), currentIndex = index(dragEl$1);
            if (~lastIndex && ~currentIndex && lastIndex !== currentIndex) {
              var n, i;
              if (currentIndex > lastIndex) {
                i = lastIndex;
                n = currentIndex;
              } else {
                i = currentIndex;
                n = lastIndex + 1;
              }
              for (; i < n; i++) {
                if (~multiDragElements.indexOf(children[i])) continue;
                toggleClass$1(children[i], options2.selectedClass, true);
                multiDragElements.push(children[i]);
                dispatchEvent({
                  sortable,
                  rootEl: rootEl2,
                  name: "select",
                  targetEl: children[i]
                });
              }
            }
          } else {
            lastMultiDragSelect = dragEl$1;
          }
          multiDragSortable = toSortable;
        } else {
          multiDragElements.splice(multiDragElements.indexOf(dragEl$1), 1);
          lastMultiDragSelect = null;
          dispatchEvent({
            sortable,
            rootEl: rootEl2,
            name: "deselect",
            targetEl: dragEl$1
          });
        }
      }
      if (dragStarted && this.isMultiDrag) {
        folding = false;
        if ((parentEl2[expando].options.sort || parentEl2 !== rootEl2) && multiDragElements.length > 1) {
          var dragRect = getRect(dragEl$1), multiDragIndex = index(dragEl$1, ":not(." + this.options.selectedClass + ")");
          if (!initialFolding && options2.animation) dragEl$1.thisAnimationDuration = null;
          toSortable.captureAnimationState();
          if (!initialFolding) {
            if (options2.animation) {
              dragEl$1.fromRect = dragRect;
              multiDragElements.forEach(function(multiDragElement) {
                multiDragElement.thisAnimationDuration = null;
                if (multiDragElement !== dragEl$1) {
                  var rect = folding ? getRect(multiDragElement) : dragRect;
                  multiDragElement.fromRect = rect;
                  toSortable.addAnimationState({
                    target: multiDragElement,
                    rect
                  });
                }
              });
            }
            removeMultiDragElements();
            multiDragElements.forEach(function(multiDragElement) {
              if (children[multiDragIndex]) {
                parentEl2.insertBefore(multiDragElement, children[multiDragIndex]);
              } else {
                parentEl2.appendChild(multiDragElement);
              }
              multiDragIndex++;
            });
            if (oldIndex2 === index(dragEl$1)) {
              var update = false;
              multiDragElements.forEach(function(multiDragElement) {
                if (multiDragElement.sortableIndex !== index(multiDragElement)) {
                  update = true;
                  return;
                }
              });
              if (update) {
                dispatchSortableEvent("update");
              }
            }
          }
          multiDragElements.forEach(function(multiDragElement) {
            unsetRect(multiDragElement);
          });
          toSortable.animateAll();
        }
        multiDragSortable = toSortable;
      }
      if (rootEl2 === parentEl2 || putSortable2 && putSortable2.lastPutMode !== "clone") {
        multiDragClones.forEach(function(clone2) {
          clone2.parentNode && clone2.parentNode.removeChild(clone2);
        });
      }
    },
    nullingGlobal: function nullingGlobal() {
      this.isMultiDrag = dragStarted = false;
      multiDragClones.length = 0;
    },
    destroyGlobal: function destroyGlobal() {
      this._deselectMultiDrag();
      off(document, "pointerup", this._deselectMultiDrag);
      off(document, "mouseup", this._deselectMultiDrag);
      off(document, "touchend", this._deselectMultiDrag);
      off(document, "keydown", this._checkKeyDown);
      off(document, "keyup", this._checkKeyUp);
    },
    _deselectMultiDrag: function _deselectMultiDrag(evt) {
      if (typeof dragStarted !== "undefined" && dragStarted) return;
      if (multiDragSortable !== this.sortable) return;
      if (evt && closest(evt.target, this.options.draggable, this.sortable.el, false)) return;
      if (evt && evt.button !== 0) return;
      while (multiDragElements.length) {
        var el = multiDragElements[0];
        toggleClass$1(el, this.options.selectedClass, false);
        multiDragElements.shift();
        dispatchEvent({
          sortable: this.sortable,
          rootEl: this.sortable.el,
          name: "deselect",
          targetEl: el
        });
      }
    },
    _checkKeyDown: function _checkKeyDown(evt) {
      if (evt.key === this.options.multiDragKey) {
        this.multiDragKeyDown = true;
      }
    },
    _checkKeyUp: function _checkKeyUp(evt) {
      if (evt.key === this.options.multiDragKey) {
        this.multiDragKeyDown = false;
      }
    }
  };
  return _extends(MultiDrag, {
    // Static methods & properties
    pluginName: "multiDrag",
    utils: {
      /**
       * Selects the provided multi-drag item
       * @param  {HTMLElement} el    The element to be selected
       */
      select: function select(el) {
        var sortable = el.parentNode[expando];
        if (!sortable || !sortable.options.multiDrag || ~multiDragElements.indexOf(el)) return;
        if (multiDragSortable && multiDragSortable !== sortable) {
          multiDragSortable.multiDrag._deselectMultiDrag();
          multiDragSortable = sortable;
        }
        toggleClass$1(el, sortable.options.selectedClass, true);
        multiDragElements.push(el);
      },
      /**
       * Deselects the provided multi-drag item
       * @param  {HTMLElement} el    The element to be deselected
       */
      deselect: function deselect(el) {
        var sortable = el.parentNode[expando], index2 = multiDragElements.indexOf(el);
        if (!sortable || !sortable.options.multiDrag || !~index2) return;
        toggleClass$1(el, sortable.options.selectedClass, false);
        multiDragElements.splice(index2, 1);
      }
    },
    eventProperties: function eventProperties() {
      var _this3 = this;
      var oldIndicies = [], newIndicies = [];
      multiDragElements.forEach(function(multiDragElement) {
        oldIndicies.push({
          multiDragElement,
          index: multiDragElement.sortableIndex
        });
        var newIndex2;
        if (folding && multiDragElement !== dragEl$1) {
          newIndex2 = -1;
        } else if (folding) {
          newIndex2 = index(multiDragElement, ":not(." + _this3.options.selectedClass + ")");
        } else {
          newIndex2 = index(multiDragElement);
        }
        newIndicies.push({
          multiDragElement,
          index: newIndex2
        });
      });
      return {
        items: _toConsumableArray(multiDragElements),
        clones: [].concat(multiDragClones),
        oldIndicies,
        newIndicies
      };
    },
    optionListeners: {
      multiDragKey: function multiDragKey(key) {
        key = key.toLowerCase();
        if (key === "ctrl") {
          key = "Control";
        } else if (key.length > 1) {
          key = key.charAt(0).toUpperCase() + key.substr(1);
        }
        return key;
      }
    }
  });
}
function insertMultiDragElements(clonesInserted, rootEl2) {
  multiDragElements.forEach(function(multiDragElement, i) {
    var target = rootEl2.children[multiDragElement.sortableIndex + (clonesInserted ? Number(i) : 0)];
    if (target) {
      rootEl2.insertBefore(multiDragElement, target);
    } else {
      rootEl2.appendChild(multiDragElement);
    }
  });
}
function insertMultiDragClones(elementsInserted, rootEl2) {
  multiDragClones.forEach(function(clone2, i) {
    var target = rootEl2.children[clone2.sortableIndex + (elementsInserted ? Number(i) : 0)];
    if (target) {
      rootEl2.insertBefore(clone2, target);
    } else {
      rootEl2.appendChild(clone2);
    }
  });
}
function removeMultiDragElements() {
  multiDragElements.forEach(function(multiDragElement) {
    if (multiDragElement === dragEl$1) return;
    multiDragElement.parentNode && multiDragElement.parentNode.removeChild(multiDragElement);
  });
}
Sortable.mount(new AutoScrollPlugin());
Sortable.mount(Remove, Revert);
const sortable_esm = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  MultiDrag: MultiDragPlugin,
  Sortable,
  Swap: SwapPlugin,
  default: Sortable
}, Symbol.toStringTag, { value: "Module" }));
const require$$1$1 = /* @__PURE__ */ getAugmentedNamespace(sortable_esm);
var vuedraggable_umd = vuedraggable_umd$1.exports;
var hasRequiredVuedraggable_umd;
function requireVuedraggable_umd() {
  if (hasRequiredVuedraggable_umd) return vuedraggable_umd$1.exports;
  hasRequiredVuedraggable_umd = 1;
  (function(module2, exports$1) {
    (function webpackUniversalModuleDefinition(root, factory) {
      module2.exports = factory(requireVue(), require$$1$1);
    })(typeof self !== "undefined" ? self : vuedraggable_umd, function(__WEBPACK_EXTERNAL_MODULE__8bbf__, __WEBPACK_EXTERNAL_MODULE_a352__) {
      return (
        /******/
        (function(modules) {
          var installedModules = {};
          function __webpack_require__(moduleId) {
            if (installedModules[moduleId]) {
              return installedModules[moduleId].exports;
            }
            var module3 = installedModules[moduleId] = {
              /******/
              i: moduleId,
              /******/
              l: false,
              /******/
              exports: {}
              /******/
            };
            modules[moduleId].call(module3.exports, module3, module3.exports, __webpack_require__);
            module3.l = true;
            return module3.exports;
          }
          __webpack_require__.m = modules;
          __webpack_require__.c = installedModules;
          __webpack_require__.d = function(exports$12, name2, getter) {
            if (!__webpack_require__.o(exports$12, name2)) {
              Object.defineProperty(exports$12, name2, { enumerable: true, get: getter });
            }
          };
          __webpack_require__.r = function(exports$12) {
            if (typeof Symbol !== "undefined" && Symbol.toStringTag) {
              Object.defineProperty(exports$12, Symbol.toStringTag, { value: "Module" });
            }
            Object.defineProperty(exports$12, "__esModule", { value: true });
          };
          __webpack_require__.t = function(value, mode) {
            if (mode & 1) value = __webpack_require__(value);
            if (mode & 8) return value;
            if (mode & 4 && typeof value === "object" && value && value.__esModule) return value;
            var ns = /* @__PURE__ */ Object.create(null);
            __webpack_require__.r(ns);
            Object.defineProperty(ns, "default", { enumerable: true, value });
            if (mode & 2 && typeof value != "string") for (var key in value) __webpack_require__.d(ns, key, (function(key2) {
              return value[key2];
            }).bind(null, key));
            return ns;
          };
          __webpack_require__.n = function(module3) {
            var getter = module3 && module3.__esModule ? (
              /******/
              function getDefault() {
                return module3["default"];
              }
            ) : (
              /******/
              function getModuleExports() {
                return module3;
              }
            );
            __webpack_require__.d(getter, "a", getter);
            return getter;
          };
          __webpack_require__.o = function(object, property) {
            return Object.prototype.hasOwnProperty.call(object, property);
          };
          __webpack_require__.p = "";
          return __webpack_require__(__webpack_require__.s = "fb15");
        })({
          /***/
          "00ee": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var wellKnownSymbol = __webpack_require__("b622");
              var TO_STRING_TAG = wellKnownSymbol("toStringTag");
              var test = {};
              test[TO_STRING_TAG] = "z";
              module3.exports = String(test) === "[object z]";
            })
          ),
          /***/
          "0366": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var aFunction = __webpack_require__("1c0b");
              module3.exports = function(fn, that, length) {
                aFunction(fn);
                if (that === void 0) return fn;
                switch (length) {
                  case 0:
                    return function() {
                      return fn.call(that);
                    };
                  case 1:
                    return function(a) {
                      return fn.call(that, a);
                    };
                  case 2:
                    return function(a, b) {
                      return fn.call(that, a, b);
                    };
                  case 3:
                    return function(a, b, c) {
                      return fn.call(that, a, b, c);
                    };
                }
                return function() {
                  return fn.apply(that, arguments);
                };
              };
            })
          ),
          /***/
          "057f": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var toIndexedObject = __webpack_require__("fc6a");
              var nativeGetOwnPropertyNames = __webpack_require__("241c").f;
              var toString2 = {}.toString;
              var windowNames = typeof window == "object" && window && Object.getOwnPropertyNames ? Object.getOwnPropertyNames(window) : [];
              var getWindowNames = function(it) {
                try {
                  return nativeGetOwnPropertyNames(it);
                } catch (error) {
                  return windowNames.slice();
                }
              };
              module3.exports.f = function getOwnPropertyNames(it) {
                return windowNames && toString2.call(it) == "[object Window]" ? getWindowNames(it) : nativeGetOwnPropertyNames(toIndexedObject(it));
              };
            })
          ),
          /***/
          "06cf": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var DESCRIPTORS = __webpack_require__("83ab");
              var propertyIsEnumerableModule = __webpack_require__("d1e7");
              var createPropertyDescriptor = __webpack_require__("5c6c");
              var toIndexedObject = __webpack_require__("fc6a");
              var toPrimitive = __webpack_require__("c04e");
              var has = __webpack_require__("5135");
              var IE8_DOM_DEFINE = __webpack_require__("0cfb");
              var nativeGetOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
              exports$12.f = DESCRIPTORS ? nativeGetOwnPropertyDescriptor : function getOwnPropertyDescriptor(O, P) {
                O = toIndexedObject(O);
                P = toPrimitive(P, true);
                if (IE8_DOM_DEFINE) try {
                  return nativeGetOwnPropertyDescriptor(O, P);
                } catch (error) {
                }
                if (has(O, P)) return createPropertyDescriptor(!propertyIsEnumerableModule.f.call(O, P), O[P]);
              };
            })
          ),
          /***/
          "0cfb": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var DESCRIPTORS = __webpack_require__("83ab");
              var fails = __webpack_require__("d039");
              var createElement2 = __webpack_require__("cc12");
              module3.exports = !DESCRIPTORS && !fails(function() {
                return Object.defineProperty(createElement2("div"), "a", {
                  get: function() {
                    return 7;
                  }
                }).a != 7;
              });
            })
          ),
          /***/
          "13d5": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var $ = __webpack_require__("23e7");
              var $reduce = __webpack_require__("d58f").left;
              var arrayMethodIsStrict = __webpack_require__("a640");
              var arrayMethodUsesToLength = __webpack_require__("ae40");
              var STRICT_METHOD = arrayMethodIsStrict("reduce");
              var USES_TO_LENGTH = arrayMethodUsesToLength("reduce", { 1: 0 });
              $({ target: "Array", proto: true, forced: !STRICT_METHOD || !USES_TO_LENGTH }, {
                reduce: function reduce(callbackfn) {
                  return $reduce(this, callbackfn, arguments.length, arguments.length > 1 ? arguments[1] : void 0);
                }
              });
            })
          ),
          /***/
          "14c3": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var classof = __webpack_require__("c6b6");
              var regexpExec = __webpack_require__("9263");
              module3.exports = function(R, S) {
                var exec = R.exec;
                if (typeof exec === "function") {
                  var result = exec.call(R, S);
                  if (typeof result !== "object") {
                    throw TypeError("RegExp exec method returned something other than an Object or null");
                  }
                  return result;
                }
                if (classof(R) !== "RegExp") {
                  throw TypeError("RegExp#exec called on incompatible receiver");
                }
                return regexpExec.call(R, S);
              };
            })
          ),
          /***/
          "159b": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var global2 = __webpack_require__("da84");
              var DOMIterables = __webpack_require__("fdbc");
              var forEach = __webpack_require__("17c2");
              var createNonEnumerableProperty = __webpack_require__("9112");
              for (var COLLECTION_NAME in DOMIterables) {
                var Collection = global2[COLLECTION_NAME];
                var CollectionPrototype = Collection && Collection.prototype;
                if (CollectionPrototype && CollectionPrototype.forEach !== forEach) try {
                  createNonEnumerableProperty(CollectionPrototype, "forEach", forEach);
                } catch (error) {
                  CollectionPrototype.forEach = forEach;
                }
              }
            })
          ),
          /***/
          "17c2": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var $forEach = __webpack_require__("b727").forEach;
              var arrayMethodIsStrict = __webpack_require__("a640");
              var arrayMethodUsesToLength = __webpack_require__("ae40");
              var STRICT_METHOD = arrayMethodIsStrict("forEach");
              var USES_TO_LENGTH = arrayMethodUsesToLength("forEach");
              module3.exports = !STRICT_METHOD || !USES_TO_LENGTH ? function forEach(callbackfn) {
                return $forEach(this, callbackfn, arguments.length > 1 ? arguments[1] : void 0);
              } : [].forEach;
            })
          ),
          /***/
          "1be4": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var getBuiltIn = __webpack_require__("d066");
              module3.exports = getBuiltIn("document", "documentElement");
            })
          ),
          /***/
          "1c0b": (
            /***/
            (function(module3, exports$12) {
              module3.exports = function(it) {
                if (typeof it != "function") {
                  throw TypeError(String(it) + " is not a function");
                }
                return it;
              };
            })
          ),
          /***/
          "1c7e": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var wellKnownSymbol = __webpack_require__("b622");
              var ITERATOR = wellKnownSymbol("iterator");
              var SAFE_CLOSING = false;
              try {
                var called = 0;
                var iteratorWithReturn = {
                  next: function() {
                    return { done: !!called++ };
                  },
                  "return": function() {
                    SAFE_CLOSING = true;
                  }
                };
                iteratorWithReturn[ITERATOR] = function() {
                  return this;
                };
                Array.from(iteratorWithReturn, function() {
                  throw 2;
                });
              } catch (error) {
              }
              module3.exports = function(exec, SKIP_CLOSING) {
                if (!SKIP_CLOSING && !SAFE_CLOSING) return false;
                var ITERATION_SUPPORT = false;
                try {
                  var object = {};
                  object[ITERATOR] = function() {
                    return {
                      next: function() {
                        return { done: ITERATION_SUPPORT = true };
                      }
                    };
                  };
                  exec(object);
                } catch (error) {
                }
                return ITERATION_SUPPORT;
              };
            })
          ),
          /***/
          "1d80": (
            /***/
            (function(module3, exports$12) {
              module3.exports = function(it) {
                if (it == void 0) throw TypeError("Can't call method on " + it);
                return it;
              };
            })
          ),
          /***/
          "1dde": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var fails = __webpack_require__("d039");
              var wellKnownSymbol = __webpack_require__("b622");
              var V8_VERSION = __webpack_require__("2d00");
              var SPECIES = wellKnownSymbol("species");
              module3.exports = function(METHOD_NAME) {
                return V8_VERSION >= 51 || !fails(function() {
                  var array = [];
                  var constructor = array.constructor = {};
                  constructor[SPECIES] = function() {
                    return { foo: 1 };
                  };
                  return array[METHOD_NAME](Boolean).foo !== 1;
                });
              };
            })
          ),
          /***/
          "23cb": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var toInteger = __webpack_require__("a691");
              var max2 = Math.max;
              var min2 = Math.min;
              module3.exports = function(index2, length) {
                var integer = toInteger(index2);
                return integer < 0 ? max2(integer + length, 0) : min2(integer, length);
              };
            })
          ),
          /***/
          "23e7": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var global2 = __webpack_require__("da84");
              var getOwnPropertyDescriptor = __webpack_require__("06cf").f;
              var createNonEnumerableProperty = __webpack_require__("9112");
              var redefine = __webpack_require__("6eeb");
              var setGlobal = __webpack_require__("ce4e");
              var copyConstructorProperties = __webpack_require__("e893");
              var isForced = __webpack_require__("94ca");
              module3.exports = function(options2, source) {
                var TARGET = options2.target;
                var GLOBAL = options2.global;
                var STATIC = options2.stat;
                var FORCED, target, key, targetProperty, sourceProperty, descriptor;
                if (GLOBAL) {
                  target = global2;
                } else if (STATIC) {
                  target = global2[TARGET] || setGlobal(TARGET, {});
                } else {
                  target = (global2[TARGET] || {}).prototype;
                }
                if (target) for (key in source) {
                  sourceProperty = source[key];
                  if (options2.noTargetGet) {
                    descriptor = getOwnPropertyDescriptor(target, key);
                    targetProperty = descriptor && descriptor.value;
                  } else targetProperty = target[key];
                  FORCED = isForced(GLOBAL ? key : TARGET + (STATIC ? "." : "#") + key, options2.forced);
                  if (!FORCED && targetProperty !== void 0) {
                    if (typeof sourceProperty === typeof targetProperty) continue;
                    copyConstructorProperties(sourceProperty, targetProperty);
                  }
                  if (options2.sham || targetProperty && targetProperty.sham) {
                    createNonEnumerableProperty(sourceProperty, "sham", true);
                  }
                  redefine(target, key, sourceProperty, options2);
                }
              };
            })
          ),
          /***/
          "241c": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var internalObjectKeys = __webpack_require__("ca84");
              var enumBugKeys = __webpack_require__("7839");
              var hiddenKeys = enumBugKeys.concat("length", "prototype");
              exports$12.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
                return internalObjectKeys(O, hiddenKeys);
              };
            })
          ),
          /***/
          "25f0": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var redefine = __webpack_require__("6eeb");
              var anObject = __webpack_require__("825a");
              var fails = __webpack_require__("d039");
              var flags = __webpack_require__("ad6d");
              var TO_STRING = "toString";
              var RegExpPrototype = RegExp.prototype;
              var nativeToString = RegExpPrototype[TO_STRING];
              var NOT_GENERIC = fails(function() {
                return nativeToString.call({ source: "a", flags: "b" }) != "/a/b";
              });
              var INCORRECT_NAME = nativeToString.name != TO_STRING;
              if (NOT_GENERIC || INCORRECT_NAME) {
                redefine(RegExp.prototype, TO_STRING, function toString2() {
                  var R = anObject(this);
                  var p = String(R.source);
                  var rf = R.flags;
                  var f = String(rf === void 0 && R instanceof RegExp && !("flags" in RegExpPrototype) ? flags.call(R) : rf);
                  return "/" + p + "/" + f;
                }, { unsafe: true });
              }
            })
          ),
          /***/
          "2ca0": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var $ = __webpack_require__("23e7");
              var getOwnPropertyDescriptor = __webpack_require__("06cf").f;
              var toLength = __webpack_require__("50c4");
              var notARegExp = __webpack_require__("5a34");
              var requireObjectCoercible = __webpack_require__("1d80");
              var correctIsRegExpLogic = __webpack_require__("ab13");
              var IS_PURE = __webpack_require__("c430");
              var nativeStartsWith = "".startsWith;
              var min2 = Math.min;
              var CORRECT_IS_REGEXP_LOGIC = correctIsRegExpLogic("startsWith");
              var MDN_POLYFILL_BUG = !IS_PURE && !CORRECT_IS_REGEXP_LOGIC && !!(function() {
                var descriptor = getOwnPropertyDescriptor(String.prototype, "startsWith");
                return descriptor && !descriptor.writable;
              })();
              $({ target: "String", proto: true, forced: !MDN_POLYFILL_BUG && !CORRECT_IS_REGEXP_LOGIC }, {
                startsWith: function startsWith(searchString) {
                  var that = String(requireObjectCoercible(this));
                  notARegExp(searchString);
                  var index2 = toLength(min2(arguments.length > 1 ? arguments[1] : void 0, that.length));
                  var search = String(searchString);
                  return nativeStartsWith ? nativeStartsWith.call(that, search, index2) : that.slice(index2, index2 + search.length) === search;
                }
              });
            })
          ),
          /***/
          "2d00": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var global2 = __webpack_require__("da84");
              var userAgent2 = __webpack_require__("342f");
              var process2 = global2.process;
              var versions = process2 && process2.versions;
              var v8 = versions && versions.v8;
              var match, version2;
              if (v8) {
                match = v8.split(".");
                version2 = match[0] + match[1];
              } else if (userAgent2) {
                match = userAgent2.match(/Edge\/(\d+)/);
                if (!match || match[1] >= 74) {
                  match = userAgent2.match(/Chrome\/(\d+)/);
                  if (match) version2 = match[1];
                }
              }
              module3.exports = version2 && +version2;
            })
          ),
          /***/
          "342f": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var getBuiltIn = __webpack_require__("d066");
              module3.exports = getBuiltIn("navigator", "userAgent") || "";
            })
          ),
          /***/
          "35a1": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var classof = __webpack_require__("f5df");
              var Iterators = __webpack_require__("3f8c");
              var wellKnownSymbol = __webpack_require__("b622");
              var ITERATOR = wellKnownSymbol("iterator");
              module3.exports = function(it) {
                if (it != void 0) return it[ITERATOR] || it["@@iterator"] || Iterators[classof(it)];
              };
            })
          ),
          /***/
          "37e8": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var DESCRIPTORS = __webpack_require__("83ab");
              var definePropertyModule = __webpack_require__("9bf2");
              var anObject = __webpack_require__("825a");
              var objectKeys = __webpack_require__("df75");
              module3.exports = DESCRIPTORS ? Object.defineProperties : function defineProperties(O, Properties) {
                anObject(O);
                var keys2 = objectKeys(Properties);
                var length = keys2.length;
                var index2 = 0;
                var key;
                while (length > index2) definePropertyModule.f(O, key = keys2[index2++], Properties[key]);
                return O;
              };
            })
          ),
          /***/
          "3bbe": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var isObject2 = __webpack_require__("861d");
              module3.exports = function(it) {
                if (!isObject2(it) && it !== null) {
                  throw TypeError("Can't set " + String(it) + " as a prototype");
                }
                return it;
              };
            })
          ),
          /***/
          "3ca3": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var charAt = __webpack_require__("6547").charAt;
              var InternalStateModule = __webpack_require__("69f3");
              var defineIterator = __webpack_require__("7dd0");
              var STRING_ITERATOR = "String Iterator";
              var setInternalState = InternalStateModule.set;
              var getInternalState = InternalStateModule.getterFor(STRING_ITERATOR);
              defineIterator(String, "String", function(iterated) {
                setInternalState(this, {
                  type: STRING_ITERATOR,
                  string: String(iterated),
                  index: 0
                });
              }, function next() {
                var state = getInternalState(this);
                var string = state.string;
                var index2 = state.index;
                var point;
                if (index2 >= string.length) return { value: void 0, done: true };
                point = charAt(string, index2);
                state.index += point.length;
                return { value: point, done: false };
              });
            })
          ),
          /***/
          "3f8c": (
            /***/
            (function(module3, exports$12) {
              module3.exports = {};
            })
          ),
          /***/
          "4160": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var $ = __webpack_require__("23e7");
              var forEach = __webpack_require__("17c2");
              $({ target: "Array", proto: true, forced: [].forEach != forEach }, {
                forEach
              });
            })
          ),
          /***/
          "428f": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var global2 = __webpack_require__("da84");
              module3.exports = global2;
            })
          ),
          /***/
          "44ad": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var fails = __webpack_require__("d039");
              var classof = __webpack_require__("c6b6");
              var split = "".split;
              module3.exports = fails(function() {
                return !Object("z").propertyIsEnumerable(0);
              }) ? function(it) {
                return classof(it) == "String" ? split.call(it, "") : Object(it);
              } : Object;
            })
          ),
          /***/
          "44d2": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var wellKnownSymbol = __webpack_require__("b622");
              var create = __webpack_require__("7c73");
              var definePropertyModule = __webpack_require__("9bf2");
              var UNSCOPABLES = wellKnownSymbol("unscopables");
              var ArrayPrototype = Array.prototype;
              if (ArrayPrototype[UNSCOPABLES] == void 0) {
                definePropertyModule.f(ArrayPrototype, UNSCOPABLES, {
                  configurable: true,
                  value: create(null)
                });
              }
              module3.exports = function(key) {
                ArrayPrototype[UNSCOPABLES][key] = true;
              };
            })
          ),
          /***/
          "44e7": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var isObject2 = __webpack_require__("861d");
              var classof = __webpack_require__("c6b6");
              var wellKnownSymbol = __webpack_require__("b622");
              var MATCH = wellKnownSymbol("match");
              module3.exports = function(it) {
                var isRegExp;
                return isObject2(it) && ((isRegExp = it[MATCH]) !== void 0 ? !!isRegExp : classof(it) == "RegExp");
              };
            })
          ),
          /***/
          "4930": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var fails = __webpack_require__("d039");
              module3.exports = !!Object.getOwnPropertySymbols && !fails(function() {
                return !String(/* @__PURE__ */ Symbol());
              });
            })
          ),
          /***/
          "4d64": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var toIndexedObject = __webpack_require__("fc6a");
              var toLength = __webpack_require__("50c4");
              var toAbsoluteIndex = __webpack_require__("23cb");
              var createMethod = function(IS_INCLUDES) {
                return function($this, el, fromIndex) {
                  var O = toIndexedObject($this);
                  var length = toLength(O.length);
                  var index2 = toAbsoluteIndex(fromIndex, length);
                  var value;
                  if (IS_INCLUDES && el != el) while (length > index2) {
                    value = O[index2++];
                    if (value != value) return true;
                  }
                  else for (; length > index2; index2++) {
                    if ((IS_INCLUDES || index2 in O) && O[index2] === el) return IS_INCLUDES || index2 || 0;
                  }
                  return !IS_INCLUDES && -1;
                };
              };
              module3.exports = {
                // `Array.prototype.includes` method
                // https://tc39.github.io/ecma262/#sec-array.prototype.includes
                includes: createMethod(true),
                // `Array.prototype.indexOf` method
                // https://tc39.github.io/ecma262/#sec-array.prototype.indexof
                indexOf: createMethod(false)
              };
            })
          ),
          /***/
          "4de4": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var $ = __webpack_require__("23e7");
              var $filter = __webpack_require__("b727").filter;
              var arrayMethodHasSpeciesSupport = __webpack_require__("1dde");
              var arrayMethodUsesToLength = __webpack_require__("ae40");
              var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport("filter");
              var USES_TO_LENGTH = arrayMethodUsesToLength("filter");
              $({ target: "Array", proto: true, forced: !HAS_SPECIES_SUPPORT || !USES_TO_LENGTH }, {
                filter: function filter(callbackfn) {
                  return $filter(this, callbackfn, arguments.length > 1 ? arguments[1] : void 0);
                }
              });
            })
          ),
          /***/
          "4df4": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var bind = __webpack_require__("0366");
              var toObject2 = __webpack_require__("7b0b");
              var callWithSafeIterationClosing = __webpack_require__("9bdd");
              var isArrayIteratorMethod = __webpack_require__("e95a");
              var toLength = __webpack_require__("50c4");
              var createProperty = __webpack_require__("8418");
              var getIteratorMethod = __webpack_require__("35a1");
              module3.exports = function from2(arrayLike) {
                var O = toObject2(arrayLike);
                var C = typeof this == "function" ? this : Array;
                var argumentsLength = arguments.length;
                var mapfn = argumentsLength > 1 ? arguments[1] : void 0;
                var mapping = mapfn !== void 0;
                var iteratorMethod = getIteratorMethod(O);
                var index2 = 0;
                var length, result, step, iterator, next, value;
                if (mapping) mapfn = bind(mapfn, argumentsLength > 2 ? arguments[2] : void 0, 2);
                if (iteratorMethod != void 0 && !(C == Array && isArrayIteratorMethod(iteratorMethod))) {
                  iterator = iteratorMethod.call(O);
                  next = iterator.next;
                  result = new C();
                  for (; !(step = next.call(iterator)).done; index2++) {
                    value = mapping ? callWithSafeIterationClosing(iterator, mapfn, [step.value, index2], true) : step.value;
                    createProperty(result, index2, value);
                  }
                } else {
                  length = toLength(O.length);
                  result = new C(length);
                  for (; length > index2; index2++) {
                    value = mapping ? mapfn(O[index2], index2) : O[index2];
                    createProperty(result, index2, value);
                  }
                }
                result.length = index2;
                return result;
              };
            })
          ),
          /***/
          "4fad": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var $ = __webpack_require__("23e7");
              var $entries = __webpack_require__("6f53").entries;
              $({ target: "Object", stat: true }, {
                entries: function entries(O) {
                  return $entries(O);
                }
              });
            })
          ),
          /***/
          "50c4": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var toInteger = __webpack_require__("a691");
              var min2 = Math.min;
              module3.exports = function(argument) {
                return argument > 0 ? min2(toInteger(argument), 9007199254740991) : 0;
              };
            })
          ),
          /***/
          "5135": (
            /***/
            (function(module3, exports$12) {
              var hasOwnProperty = {}.hasOwnProperty;
              module3.exports = function(it, key) {
                return hasOwnProperty.call(it, key);
              };
            })
          ),
          /***/
          "5319": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var fixRegExpWellKnownSymbolLogic = __webpack_require__("d784");
              var anObject = __webpack_require__("825a");
              var toObject2 = __webpack_require__("7b0b");
              var toLength = __webpack_require__("50c4");
              var toInteger = __webpack_require__("a691");
              var requireObjectCoercible = __webpack_require__("1d80");
              var advanceStringIndex = __webpack_require__("8aa5");
              var regExpExec = __webpack_require__("14c3");
              var max2 = Math.max;
              var min2 = Math.min;
              var floor = Math.floor;
              var SUBSTITUTION_SYMBOLS = /\$([$&'`]|\d\d?|<[^>]*>)/g;
              var SUBSTITUTION_SYMBOLS_NO_NAMED = /\$([$&'`]|\d\d?)/g;
              var maybeToString = function(it) {
                return it === void 0 ? it : String(it);
              };
              fixRegExpWellKnownSymbolLogic("replace", 2, function(REPLACE, nativeReplace, maybeCallNative, reason) {
                var REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE = reason.REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE;
                var REPLACE_KEEPS_$0 = reason.REPLACE_KEEPS_$0;
                var UNSAFE_SUBSTITUTE = REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE ? "$" : "$0";
                return [
                  // `String.prototype.replace` method
                  // https://tc39.github.io/ecma262/#sec-string.prototype.replace
                  function replace(searchValue, replaceValue) {
                    var O = requireObjectCoercible(this);
                    var replacer = searchValue == void 0 ? void 0 : searchValue[REPLACE];
                    return replacer !== void 0 ? replacer.call(searchValue, O, replaceValue) : nativeReplace.call(String(O), searchValue, replaceValue);
                  },
                  // `RegExp.prototype[@@replace]` method
                  // https://tc39.github.io/ecma262/#sec-regexp.prototype-@@replace
                  function(regexp, replaceValue) {
                    if (!REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE && REPLACE_KEEPS_$0 || typeof replaceValue === "string" && replaceValue.indexOf(UNSAFE_SUBSTITUTE) === -1) {
                      var res = maybeCallNative(nativeReplace, regexp, this, replaceValue);
                      if (res.done) return res.value;
                    }
                    var rx = anObject(regexp);
                    var S = String(this);
                    var functionalReplace = typeof replaceValue === "function";
                    if (!functionalReplace) replaceValue = String(replaceValue);
                    var global2 = rx.global;
                    if (global2) {
                      var fullUnicode = rx.unicode;
                      rx.lastIndex = 0;
                    }
                    var results = [];
                    while (true) {
                      var result = regExpExec(rx, S);
                      if (result === null) break;
                      results.push(result);
                      if (!global2) break;
                      var matchStr = String(result[0]);
                      if (matchStr === "") rx.lastIndex = advanceStringIndex(S, toLength(rx.lastIndex), fullUnicode);
                    }
                    var accumulatedResult = "";
                    var nextSourcePosition = 0;
                    for (var i = 0; i < results.length; i++) {
                      result = results[i];
                      var matched = String(result[0]);
                      var position = max2(min2(toInteger(result.index), S.length), 0);
                      var captures = [];
                      for (var j = 1; j < result.length; j++) captures.push(maybeToString(result[j]));
                      var namedCaptures = result.groups;
                      if (functionalReplace) {
                        var replacerArgs = [matched].concat(captures, position, S);
                        if (namedCaptures !== void 0) replacerArgs.push(namedCaptures);
                        var replacement = String(replaceValue.apply(void 0, replacerArgs));
                      } else {
                        replacement = getSubstitution(matched, S, position, captures, namedCaptures, replaceValue);
                      }
                      if (position >= nextSourcePosition) {
                        accumulatedResult += S.slice(nextSourcePosition, position) + replacement;
                        nextSourcePosition = position + matched.length;
                      }
                    }
                    return accumulatedResult + S.slice(nextSourcePosition);
                  }
                ];
                function getSubstitution(matched, str, position, captures, namedCaptures, replacement) {
                  var tailPos = position + matched.length;
                  var m2 = captures.length;
                  var symbols = SUBSTITUTION_SYMBOLS_NO_NAMED;
                  if (namedCaptures !== void 0) {
                    namedCaptures = toObject2(namedCaptures);
                    symbols = SUBSTITUTION_SYMBOLS;
                  }
                  return nativeReplace.call(replacement, symbols, function(match, ch) {
                    var capture;
                    switch (ch.charAt(0)) {
                      case "$":
                        return "$";
                      case "&":
                        return matched;
                      case "`":
                        return str.slice(0, position);
                      case "'":
                        return str.slice(tailPos);
                      case "<":
                        capture = namedCaptures[ch.slice(1, -1)];
                        break;
                      default:
                        var n = +ch;
                        if (n === 0) return match;
                        if (n > m2) {
                          var f = floor(n / 10);
                          if (f === 0) return match;
                          if (f <= m2) return captures[f - 1] === void 0 ? ch.charAt(1) : captures[f - 1] + ch.charAt(1);
                          return match;
                        }
                        capture = captures[n - 1];
                    }
                    return capture === void 0 ? "" : capture;
                  });
                }
              });
            })
          ),
          /***/
          "5692": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var IS_PURE = __webpack_require__("c430");
              var store = __webpack_require__("c6cd");
              (module3.exports = function(key, value) {
                return store[key] || (store[key] = value !== void 0 ? value : {});
              })("versions", []).push({
                version: "3.6.5",
                mode: IS_PURE ? "pure" : "global",
                copyright: "© 2020 Denis Pushkarev (zloirock.ru)"
              });
            })
          ),
          /***/
          "56ef": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var getBuiltIn = __webpack_require__("d066");
              var getOwnPropertyNamesModule = __webpack_require__("241c");
              var getOwnPropertySymbolsModule = __webpack_require__("7418");
              var anObject = __webpack_require__("825a");
              module3.exports = getBuiltIn("Reflect", "ownKeys") || function ownKeys2(it) {
                var keys2 = getOwnPropertyNamesModule.f(anObject(it));
                var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
                return getOwnPropertySymbols ? keys2.concat(getOwnPropertySymbols(it)) : keys2;
              };
            })
          ),
          /***/
          "5a34": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var isRegExp = __webpack_require__("44e7");
              module3.exports = function(it) {
                if (isRegExp(it)) {
                  throw TypeError("The method doesn't accept regular expressions");
                }
                return it;
              };
            })
          ),
          /***/
          "5c6c": (
            /***/
            (function(module3, exports$12) {
              module3.exports = function(bitmap, value) {
                return {
                  enumerable: !(bitmap & 1),
                  configurable: !(bitmap & 2),
                  writable: !(bitmap & 4),
                  value
                };
              };
            })
          ),
          /***/
          "5db7": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var $ = __webpack_require__("23e7");
              var flattenIntoArray = __webpack_require__("a2bf");
              var toObject2 = __webpack_require__("7b0b");
              var toLength = __webpack_require__("50c4");
              var aFunction = __webpack_require__("1c0b");
              var arraySpeciesCreate = __webpack_require__("65f0");
              $({ target: "Array", proto: true }, {
                flatMap: function flatMap(callbackfn) {
                  var O = toObject2(this);
                  var sourceLen = toLength(O.length);
                  var A2;
                  aFunction(callbackfn);
                  A2 = arraySpeciesCreate(O, 0);
                  A2.length = flattenIntoArray(A2, O, O, sourceLen, 0, 1, callbackfn, arguments.length > 1 ? arguments[1] : void 0);
                  return A2;
                }
              });
            })
          ),
          /***/
          "6547": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var toInteger = __webpack_require__("a691");
              var requireObjectCoercible = __webpack_require__("1d80");
              var createMethod = function(CONVERT_TO_STRING) {
                return function($this, pos) {
                  var S = String(requireObjectCoercible($this));
                  var position = toInteger(pos);
                  var size = S.length;
                  var first, second;
                  if (position < 0 || position >= size) return CONVERT_TO_STRING ? "" : void 0;
                  first = S.charCodeAt(position);
                  return first < 55296 || first > 56319 || position + 1 === size || (second = S.charCodeAt(position + 1)) < 56320 || second > 57343 ? CONVERT_TO_STRING ? S.charAt(position) : first : CONVERT_TO_STRING ? S.slice(position, position + 2) : (first - 55296 << 10) + (second - 56320) + 65536;
                };
              };
              module3.exports = {
                // `String.prototype.codePointAt` method
                // https://tc39.github.io/ecma262/#sec-string.prototype.codepointat
                codeAt: createMethod(false),
                // `String.prototype.at` method
                // https://github.com/mathiasbynens/String.prototype.at
                charAt: createMethod(true)
              };
            })
          ),
          /***/
          "65f0": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var isObject2 = __webpack_require__("861d");
              var isArray2 = __webpack_require__("e8b5");
              var wellKnownSymbol = __webpack_require__("b622");
              var SPECIES = wellKnownSymbol("species");
              module3.exports = function(originalArray, length) {
                var C;
                if (isArray2(originalArray)) {
                  C = originalArray.constructor;
                  if (typeof C == "function" && (C === Array || isArray2(C.prototype))) C = void 0;
                  else if (isObject2(C)) {
                    C = C[SPECIES];
                    if (C === null) C = void 0;
                  }
                }
                return new (C === void 0 ? Array : C)(length === 0 ? 0 : length);
              };
            })
          ),
          /***/
          "69f3": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var NATIVE_WEAK_MAP = __webpack_require__("7f9a");
              var global2 = __webpack_require__("da84");
              var isObject2 = __webpack_require__("861d");
              var createNonEnumerableProperty = __webpack_require__("9112");
              var objectHas = __webpack_require__("5135");
              var sharedKey = __webpack_require__("f772");
              var hiddenKeys = __webpack_require__("d012");
              var WeakMap2 = global2.WeakMap;
              var set2, get2, has;
              var enforce = function(it) {
                return has(it) ? get2(it) : set2(it, {});
              };
              var getterFor = function(TYPE) {
                return function(it) {
                  var state;
                  if (!isObject2(it) || (state = get2(it)).type !== TYPE) {
                    throw TypeError("Incompatible receiver, " + TYPE + " required");
                  }
                  return state;
                };
              };
              if (NATIVE_WEAK_MAP) {
                var store = new WeakMap2();
                var wmget = store.get;
                var wmhas = store.has;
                var wmset = store.set;
                set2 = function(it, metadata) {
                  wmset.call(store, it, metadata);
                  return metadata;
                };
                get2 = function(it) {
                  return wmget.call(store, it) || {};
                };
                has = function(it) {
                  return wmhas.call(store, it);
                };
              } else {
                var STATE = sharedKey("state");
                hiddenKeys[STATE] = true;
                set2 = function(it, metadata) {
                  createNonEnumerableProperty(it, STATE, metadata);
                  return metadata;
                };
                get2 = function(it) {
                  return objectHas(it, STATE) ? it[STATE] : {};
                };
                has = function(it) {
                  return objectHas(it, STATE);
                };
              }
              module3.exports = {
                set: set2,
                get: get2,
                has,
                enforce,
                getterFor
              };
            })
          ),
          /***/
          "6eeb": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var global2 = __webpack_require__("da84");
              var createNonEnumerableProperty = __webpack_require__("9112");
              var has = __webpack_require__("5135");
              var setGlobal = __webpack_require__("ce4e");
              var inspectSource = __webpack_require__("8925");
              var InternalStateModule = __webpack_require__("69f3");
              var getInternalState = InternalStateModule.get;
              var enforceInternalState = InternalStateModule.enforce;
              var TEMPLATE = String(String).split("String");
              (module3.exports = function(O, key, value, options2) {
                var unsafe = options2 ? !!options2.unsafe : false;
                var simple = options2 ? !!options2.enumerable : false;
                var noTargetGet = options2 ? !!options2.noTargetGet : false;
                if (typeof value == "function") {
                  if (typeof key == "string" && !has(value, "name")) createNonEnumerableProperty(value, "name", key);
                  enforceInternalState(value).source = TEMPLATE.join(typeof key == "string" ? key : "");
                }
                if (O === global2) {
                  if (simple) O[key] = value;
                  else setGlobal(key, value);
                  return;
                } else if (!unsafe) {
                  delete O[key];
                } else if (!noTargetGet && O[key]) {
                  simple = true;
                }
                if (simple) O[key] = value;
                else createNonEnumerableProperty(O, key, value);
              })(Function.prototype, "toString", function toString2() {
                return typeof this == "function" && getInternalState(this).source || inspectSource(this);
              });
            })
          ),
          /***/
          "6f53": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var DESCRIPTORS = __webpack_require__("83ab");
              var objectKeys = __webpack_require__("df75");
              var toIndexedObject = __webpack_require__("fc6a");
              var propertyIsEnumerable = __webpack_require__("d1e7").f;
              var createMethod = function(TO_ENTRIES) {
                return function(it) {
                  var O = toIndexedObject(it);
                  var keys2 = objectKeys(O);
                  var length = keys2.length;
                  var i = 0;
                  var result = [];
                  var key;
                  while (length > i) {
                    key = keys2[i++];
                    if (!DESCRIPTORS || propertyIsEnumerable.call(O, key)) {
                      result.push(TO_ENTRIES ? [key, O[key]] : O[key]);
                    }
                  }
                  return result;
                };
              };
              module3.exports = {
                // `Object.entries` method
                // https://tc39.github.io/ecma262/#sec-object.entries
                entries: createMethod(true),
                // `Object.values` method
                // https://tc39.github.io/ecma262/#sec-object.values
                values: createMethod(false)
              };
            })
          ),
          /***/
          "73d9": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var addToUnscopables = __webpack_require__("44d2");
              addToUnscopables("flatMap");
            })
          ),
          /***/
          "7418": (
            /***/
            (function(module3, exports$12) {
              exports$12.f = Object.getOwnPropertySymbols;
            })
          ),
          /***/
          "746f": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var path = __webpack_require__("428f");
              var has = __webpack_require__("5135");
              var wrappedWellKnownSymbolModule = __webpack_require__("e538");
              var defineProperty = __webpack_require__("9bf2").f;
              module3.exports = function(NAME) {
                var Symbol2 = path.Symbol || (path.Symbol = {});
                if (!has(Symbol2, NAME)) defineProperty(Symbol2, NAME, {
                  value: wrappedWellKnownSymbolModule.f(NAME)
                });
              };
            })
          ),
          /***/
          "7839": (
            /***/
            (function(module3, exports$12) {
              module3.exports = [
                "constructor",
                "hasOwnProperty",
                "isPrototypeOf",
                "propertyIsEnumerable",
                "toLocaleString",
                "toString",
                "valueOf"
              ];
            })
          ),
          /***/
          "7b0b": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var requireObjectCoercible = __webpack_require__("1d80");
              module3.exports = function(argument) {
                return Object(requireObjectCoercible(argument));
              };
            })
          ),
          /***/
          "7c73": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var anObject = __webpack_require__("825a");
              var defineProperties = __webpack_require__("37e8");
              var enumBugKeys = __webpack_require__("7839");
              var hiddenKeys = __webpack_require__("d012");
              var html = __webpack_require__("1be4");
              var documentCreateElement = __webpack_require__("cc12");
              var sharedKey = __webpack_require__("f772");
              var GT = ">";
              var LT = "<";
              var PROTOTYPE = "prototype";
              var SCRIPT = "script";
              var IE_PROTO = sharedKey("IE_PROTO");
              var EmptyConstructor = function() {
              };
              var scriptTag = function(content) {
                return LT + SCRIPT + GT + content + LT + "/" + SCRIPT + GT;
              };
              var NullProtoObjectViaActiveX = function(activeXDocument2) {
                activeXDocument2.write(scriptTag(""));
                activeXDocument2.close();
                var temp = activeXDocument2.parentWindow.Object;
                activeXDocument2 = null;
                return temp;
              };
              var NullProtoObjectViaIFrame = function() {
                var iframe = documentCreateElement("iframe");
                var JS = "java" + SCRIPT + ":";
                var iframeDocument;
                iframe.style.display = "none";
                html.appendChild(iframe);
                iframe.src = String(JS);
                iframeDocument = iframe.contentWindow.document;
                iframeDocument.open();
                iframeDocument.write(scriptTag("document.F=Object"));
                iframeDocument.close();
                return iframeDocument.F;
              };
              var activeXDocument;
              var NullProtoObject = function() {
                try {
                  activeXDocument = document.domain && new ActiveXObject("htmlfile");
                } catch (error) {
                }
                NullProtoObject = activeXDocument ? NullProtoObjectViaActiveX(activeXDocument) : NullProtoObjectViaIFrame();
                var length = enumBugKeys.length;
                while (length--) delete NullProtoObject[PROTOTYPE][enumBugKeys[length]];
                return NullProtoObject();
              };
              hiddenKeys[IE_PROTO] = true;
              module3.exports = Object.create || function create(O, Properties) {
                var result;
                if (O !== null) {
                  EmptyConstructor[PROTOTYPE] = anObject(O);
                  result = new EmptyConstructor();
                  EmptyConstructor[PROTOTYPE] = null;
                  result[IE_PROTO] = O;
                } else result = NullProtoObject();
                return Properties === void 0 ? result : defineProperties(result, Properties);
              };
            })
          ),
          /***/
          "7dd0": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var $ = __webpack_require__("23e7");
              var createIteratorConstructor = __webpack_require__("9ed3");
              var getPrototypeOf = __webpack_require__("e163");
              var setPrototypeOf = __webpack_require__("d2bb");
              var setToStringTag = __webpack_require__("d44e");
              var createNonEnumerableProperty = __webpack_require__("9112");
              var redefine = __webpack_require__("6eeb");
              var wellKnownSymbol = __webpack_require__("b622");
              var IS_PURE = __webpack_require__("c430");
              var Iterators = __webpack_require__("3f8c");
              var IteratorsCore = __webpack_require__("ae93");
              var IteratorPrototype = IteratorsCore.IteratorPrototype;
              var BUGGY_SAFARI_ITERATORS = IteratorsCore.BUGGY_SAFARI_ITERATORS;
              var ITERATOR = wellKnownSymbol("iterator");
              var KEYS = "keys";
              var VALUES = "values";
              var ENTRIES = "entries";
              var returnThis = function() {
                return this;
              };
              module3.exports = function(Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
                createIteratorConstructor(IteratorConstructor, NAME, next);
                var getIterationMethod = function(KIND) {
                  if (KIND === DEFAULT && defaultIterator) return defaultIterator;
                  if (!BUGGY_SAFARI_ITERATORS && KIND in IterablePrototype) return IterablePrototype[KIND];
                  switch (KIND) {
                    case KEYS:
                      return function keys2() {
                        return new IteratorConstructor(this, KIND);
                      };
                    case VALUES:
                      return function values() {
                        return new IteratorConstructor(this, KIND);
                      };
                    case ENTRIES:
                      return function entries() {
                        return new IteratorConstructor(this, KIND);
                      };
                  }
                  return function() {
                    return new IteratorConstructor(this);
                  };
                };
                var TO_STRING_TAG = NAME + " Iterator";
                var INCORRECT_VALUES_NAME = false;
                var IterablePrototype = Iterable.prototype;
                var nativeIterator = IterablePrototype[ITERATOR] || IterablePrototype["@@iterator"] || DEFAULT && IterablePrototype[DEFAULT];
                var defaultIterator = !BUGGY_SAFARI_ITERATORS && nativeIterator || getIterationMethod(DEFAULT);
                var anyNativeIterator = NAME == "Array" ? IterablePrototype.entries || nativeIterator : nativeIterator;
                var CurrentIteratorPrototype, methods, KEY;
                if (anyNativeIterator) {
                  CurrentIteratorPrototype = getPrototypeOf(anyNativeIterator.call(new Iterable()));
                  if (IteratorPrototype !== Object.prototype && CurrentIteratorPrototype.next) {
                    if (!IS_PURE && getPrototypeOf(CurrentIteratorPrototype) !== IteratorPrototype) {
                      if (setPrototypeOf) {
                        setPrototypeOf(CurrentIteratorPrototype, IteratorPrototype);
                      } else if (typeof CurrentIteratorPrototype[ITERATOR] != "function") {
                        createNonEnumerableProperty(CurrentIteratorPrototype, ITERATOR, returnThis);
                      }
                    }
                    setToStringTag(CurrentIteratorPrototype, TO_STRING_TAG, true, true);
                    if (IS_PURE) Iterators[TO_STRING_TAG] = returnThis;
                  }
                }
                if (DEFAULT == VALUES && nativeIterator && nativeIterator.name !== VALUES) {
                  INCORRECT_VALUES_NAME = true;
                  defaultIterator = function values() {
                    return nativeIterator.call(this);
                  };
                }
                if ((!IS_PURE || FORCED) && IterablePrototype[ITERATOR] !== defaultIterator) {
                  createNonEnumerableProperty(IterablePrototype, ITERATOR, defaultIterator);
                }
                Iterators[NAME] = defaultIterator;
                if (DEFAULT) {
                  methods = {
                    values: getIterationMethod(VALUES),
                    keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
                    entries: getIterationMethod(ENTRIES)
                  };
                  if (FORCED) for (KEY in methods) {
                    if (BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
                      redefine(IterablePrototype, KEY, methods[KEY]);
                    }
                  }
                  else $({ target: NAME, proto: true, forced: BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME }, methods);
                }
                return methods;
              };
            })
          ),
          /***/
          "7f9a": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var global2 = __webpack_require__("da84");
              var inspectSource = __webpack_require__("8925");
              var WeakMap2 = global2.WeakMap;
              module3.exports = typeof WeakMap2 === "function" && /native code/.test(inspectSource(WeakMap2));
            })
          ),
          /***/
          "825a": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var isObject2 = __webpack_require__("861d");
              module3.exports = function(it) {
                if (!isObject2(it)) {
                  throw TypeError(String(it) + " is not an object");
                }
                return it;
              };
            })
          ),
          /***/
          "83ab": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var fails = __webpack_require__("d039");
              module3.exports = !fails(function() {
                return Object.defineProperty({}, 1, { get: function() {
                  return 7;
                } })[1] != 7;
              });
            })
          ),
          /***/
          "8418": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var toPrimitive = __webpack_require__("c04e");
              var definePropertyModule = __webpack_require__("9bf2");
              var createPropertyDescriptor = __webpack_require__("5c6c");
              module3.exports = function(object, key, value) {
                var propertyKey = toPrimitive(key);
                if (propertyKey in object) definePropertyModule.f(object, propertyKey, createPropertyDescriptor(0, value));
                else object[propertyKey] = value;
              };
            })
          ),
          /***/
          "861d": (
            /***/
            (function(module3, exports$12) {
              module3.exports = function(it) {
                return typeof it === "object" ? it !== null : typeof it === "function";
              };
            })
          ),
          /***/
          "8875": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;
              (function(root, factory) {
                {
                  !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = factory, __WEBPACK_AMD_DEFINE_RESULT__ = typeof __WEBPACK_AMD_DEFINE_FACTORY__ === "function" ? __WEBPACK_AMD_DEFINE_FACTORY__.apply(exports$12, __WEBPACK_AMD_DEFINE_ARRAY__) : __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_RESULT__ !== void 0 && (module3.exports = __WEBPACK_AMD_DEFINE_RESULT__));
                }
              })(typeof self !== "undefined" ? self : this, function() {
                function getCurrentScript() {
                  var descriptor = Object.getOwnPropertyDescriptor(document, "currentScript");
                  if (!descriptor && "currentScript" in document && document.currentScript) {
                    return document.currentScript;
                  }
                  if (descriptor && descriptor.get !== getCurrentScript && document.currentScript) {
                    return document.currentScript;
                  }
                  try {
                    throw new Error();
                  } catch (err) {
                    var ieStackRegExp = /.*at [^(]*\((.*):(.+):(.+)\)$/ig, ffStackRegExp = /@([^@]*):(\d+):(\d+)\s*$/ig, stackDetails = ieStackRegExp.exec(err.stack) || ffStackRegExp.exec(err.stack), scriptLocation = stackDetails && stackDetails[1] || false, line = stackDetails && stackDetails[2] || false, currentLocation = document.location.href.replace(document.location.hash, ""), pageSource, inlineScriptSourceRegExp, inlineScriptSource, scripts = document.getElementsByTagName("script");
                    if (scriptLocation === currentLocation) {
                      pageSource = document.documentElement.outerHTML;
                      inlineScriptSourceRegExp = new RegExp("(?:[^\\n]+?\\n){0," + (line - 2) + "}[^<]*<script>([\\d\\D]*?)<\\/script>[\\d\\D]*", "i");
                      inlineScriptSource = pageSource.replace(inlineScriptSourceRegExp, "$1").trim();
                    }
                    for (var i = 0; i < scripts.length; i++) {
                      if (scripts[i].readyState === "interactive") {
                        return scripts[i];
                      }
                      if (scripts[i].src === scriptLocation) {
                        return scripts[i];
                      }
                      if (scriptLocation === currentLocation && scripts[i].innerHTML && scripts[i].innerHTML.trim() === inlineScriptSource) {
                        return scripts[i];
                      }
                    }
                    return null;
                  }
                }
                return getCurrentScript;
              });
            })
          ),
          /***/
          "8925": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var store = __webpack_require__("c6cd");
              var functionToString = Function.toString;
              if (typeof store.inspectSource != "function") {
                store.inspectSource = function(it) {
                  return functionToString.call(it);
                };
              }
              module3.exports = store.inspectSource;
            })
          ),
          /***/
          "8aa5": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var charAt = __webpack_require__("6547").charAt;
              module3.exports = function(S, index2, unicode) {
                return index2 + (unicode ? charAt(S, index2).length : 1);
              };
            })
          ),
          /***/
          "8bbf": (
            /***/
            (function(module3, exports$12) {
              module3.exports = __WEBPACK_EXTERNAL_MODULE__8bbf__;
            })
          ),
          /***/
          "90e3": (
            /***/
            (function(module3, exports$12) {
              var id = 0;
              var postfix = Math.random();
              module3.exports = function(key) {
                return "Symbol(" + String(key === void 0 ? "" : key) + ")_" + (++id + postfix).toString(36);
              };
            })
          ),
          /***/
          "9112": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var DESCRIPTORS = __webpack_require__("83ab");
              var definePropertyModule = __webpack_require__("9bf2");
              var createPropertyDescriptor = __webpack_require__("5c6c");
              module3.exports = DESCRIPTORS ? function(object, key, value) {
                return definePropertyModule.f(object, key, createPropertyDescriptor(1, value));
              } : function(object, key, value) {
                object[key] = value;
                return object;
              };
            })
          ),
          /***/
          "9263": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var regexpFlags = __webpack_require__("ad6d");
              var stickyHelpers = __webpack_require__("9f7f");
              var nativeExec = RegExp.prototype.exec;
              var nativeReplace = String.prototype.replace;
              var patchedExec = nativeExec;
              var UPDATES_LAST_INDEX_WRONG = (function() {
                var re1 = /a/;
                var re2 = /b*/g;
                nativeExec.call(re1, "a");
                nativeExec.call(re2, "a");
                return re1.lastIndex !== 0 || re2.lastIndex !== 0;
              })();
              var UNSUPPORTED_Y = stickyHelpers.UNSUPPORTED_Y || stickyHelpers.BROKEN_CARET;
              var NPCG_INCLUDED = /()??/.exec("")[1] !== void 0;
              var PATCH = UPDATES_LAST_INDEX_WRONG || NPCG_INCLUDED || UNSUPPORTED_Y;
              if (PATCH) {
                patchedExec = function exec(str) {
                  var re = this;
                  var lastIndex, reCopy, match, i;
                  var sticky = UNSUPPORTED_Y && re.sticky;
                  var flags = regexpFlags.call(re);
                  var source = re.source;
                  var charsAdded = 0;
                  var strCopy = str;
                  if (sticky) {
                    flags = flags.replace("y", "");
                    if (flags.indexOf("g") === -1) {
                      flags += "g";
                    }
                    strCopy = String(str).slice(re.lastIndex);
                    if (re.lastIndex > 0 && (!re.multiline || re.multiline && str[re.lastIndex - 1] !== "\n")) {
                      source = "(?: " + source + ")";
                      strCopy = " " + strCopy;
                      charsAdded++;
                    }
                    reCopy = new RegExp("^(?:" + source + ")", flags);
                  }
                  if (NPCG_INCLUDED) {
                    reCopy = new RegExp("^" + source + "$(?!\\s)", flags);
                  }
                  if (UPDATES_LAST_INDEX_WRONG) lastIndex = re.lastIndex;
                  match = nativeExec.call(sticky ? reCopy : re, strCopy);
                  if (sticky) {
                    if (match) {
                      match.input = match.input.slice(charsAdded);
                      match[0] = match[0].slice(charsAdded);
                      match.index = re.lastIndex;
                      re.lastIndex += match[0].length;
                    } else re.lastIndex = 0;
                  } else if (UPDATES_LAST_INDEX_WRONG && match) {
                    re.lastIndex = re.global ? match.index + match[0].length : lastIndex;
                  }
                  if (NPCG_INCLUDED && match && match.length > 1) {
                    nativeReplace.call(match[0], reCopy, function() {
                      for (i = 1; i < arguments.length - 2; i++) {
                        if (arguments[i] === void 0) match[i] = void 0;
                      }
                    });
                  }
                  return match;
                };
              }
              module3.exports = patchedExec;
            })
          ),
          /***/
          "94ca": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var fails = __webpack_require__("d039");
              var replacement = /#|\.prototype\./;
              var isForced = function(feature, detection) {
                var value = data[normalize2(feature)];
                return value == POLYFILL ? true : value == NATIVE ? false : typeof detection == "function" ? fails(detection) : !!detection;
              };
              var normalize2 = isForced.normalize = function(string) {
                return String(string).replace(replacement, ".").toLowerCase();
              };
              var data = isForced.data = {};
              var NATIVE = isForced.NATIVE = "N";
              var POLYFILL = isForced.POLYFILL = "P";
              module3.exports = isForced;
            })
          ),
          /***/
          "99af": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var $ = __webpack_require__("23e7");
              var fails = __webpack_require__("d039");
              var isArray2 = __webpack_require__("e8b5");
              var isObject2 = __webpack_require__("861d");
              var toObject2 = __webpack_require__("7b0b");
              var toLength = __webpack_require__("50c4");
              var createProperty = __webpack_require__("8418");
              var arraySpeciesCreate = __webpack_require__("65f0");
              var arrayMethodHasSpeciesSupport = __webpack_require__("1dde");
              var wellKnownSymbol = __webpack_require__("b622");
              var V8_VERSION = __webpack_require__("2d00");
              var IS_CONCAT_SPREADABLE = wellKnownSymbol("isConcatSpreadable");
              var MAX_SAFE_INTEGER = 9007199254740991;
              var MAXIMUM_ALLOWED_INDEX_EXCEEDED = "Maximum allowed index exceeded";
              var IS_CONCAT_SPREADABLE_SUPPORT = V8_VERSION >= 51 || !fails(function() {
                var array = [];
                array[IS_CONCAT_SPREADABLE] = false;
                return array.concat()[0] !== array;
              });
              var SPECIES_SUPPORT = arrayMethodHasSpeciesSupport("concat");
              var isConcatSpreadable = function(O) {
                if (!isObject2(O)) return false;
                var spreadable = O[IS_CONCAT_SPREADABLE];
                return spreadable !== void 0 ? !!spreadable : isArray2(O);
              };
              var FORCED = !IS_CONCAT_SPREADABLE_SUPPORT || !SPECIES_SUPPORT;
              $({ target: "Array", proto: true, forced: FORCED }, {
                concat: function concat(arg) {
                  var O = toObject2(this);
                  var A2 = arraySpeciesCreate(O, 0);
                  var n = 0;
                  var i, k, length, len, E;
                  for (i = -1, length = arguments.length; i < length; i++) {
                    E = i === -1 ? O : arguments[i];
                    if (isConcatSpreadable(E)) {
                      len = toLength(E.length);
                      if (n + len > MAX_SAFE_INTEGER) throw TypeError(MAXIMUM_ALLOWED_INDEX_EXCEEDED);
                      for (k = 0; k < len; k++, n++) if (k in E) createProperty(A2, n, E[k]);
                    } else {
                      if (n >= MAX_SAFE_INTEGER) throw TypeError(MAXIMUM_ALLOWED_INDEX_EXCEEDED);
                      createProperty(A2, n++, E);
                    }
                  }
                  A2.length = n;
                  return A2;
                }
              });
            })
          ),
          /***/
          "9bdd": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var anObject = __webpack_require__("825a");
              module3.exports = function(iterator, fn, value, ENTRIES) {
                try {
                  return ENTRIES ? fn(anObject(value)[0], value[1]) : fn(value);
                } catch (error) {
                  var returnMethod = iterator["return"];
                  if (returnMethod !== void 0) anObject(returnMethod.call(iterator));
                  throw error;
                }
              };
            })
          ),
          /***/
          "9bf2": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var DESCRIPTORS = __webpack_require__("83ab");
              var IE8_DOM_DEFINE = __webpack_require__("0cfb");
              var anObject = __webpack_require__("825a");
              var toPrimitive = __webpack_require__("c04e");
              var nativeDefineProperty = Object.defineProperty;
              exports$12.f = DESCRIPTORS ? nativeDefineProperty : function defineProperty(O, P, Attributes) {
                anObject(O);
                P = toPrimitive(P, true);
                anObject(Attributes);
                if (IE8_DOM_DEFINE) try {
                  return nativeDefineProperty(O, P, Attributes);
                } catch (error) {
                }
                if ("get" in Attributes || "set" in Attributes) throw TypeError("Accessors not supported");
                if ("value" in Attributes) O[P] = Attributes.value;
                return O;
              };
            })
          ),
          /***/
          "9ed3": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var IteratorPrototype = __webpack_require__("ae93").IteratorPrototype;
              var create = __webpack_require__("7c73");
              var createPropertyDescriptor = __webpack_require__("5c6c");
              var setToStringTag = __webpack_require__("d44e");
              var Iterators = __webpack_require__("3f8c");
              var returnThis = function() {
                return this;
              };
              module3.exports = function(IteratorConstructor, NAME, next) {
                var TO_STRING_TAG = NAME + " Iterator";
                IteratorConstructor.prototype = create(IteratorPrototype, { next: createPropertyDescriptor(1, next) });
                setToStringTag(IteratorConstructor, TO_STRING_TAG, false, true);
                Iterators[TO_STRING_TAG] = returnThis;
                return IteratorConstructor;
              };
            })
          ),
          /***/
          "9f7f": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var fails = __webpack_require__("d039");
              function RE(s, f) {
                return RegExp(s, f);
              }
              exports$12.UNSUPPORTED_Y = fails(function() {
                var re = RE("a", "y");
                re.lastIndex = 2;
                return re.exec("abcd") != null;
              });
              exports$12.BROKEN_CARET = fails(function() {
                var re = RE("^r", "gy");
                re.lastIndex = 2;
                return re.exec("str") != null;
              });
            })
          ),
          /***/
          "a2bf": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var isArray2 = __webpack_require__("e8b5");
              var toLength = __webpack_require__("50c4");
              var bind = __webpack_require__("0366");
              var flattenIntoArray = function(target, original, source, sourceLen, start, depth, mapper, thisArg) {
                var targetIndex = start;
                var sourceIndex = 0;
                var mapFn = mapper ? bind(mapper, thisArg, 3) : false;
                var element;
                while (sourceIndex < sourceLen) {
                  if (sourceIndex in source) {
                    element = mapFn ? mapFn(source[sourceIndex], sourceIndex, original) : source[sourceIndex];
                    if (depth > 0 && isArray2(element)) {
                      targetIndex = flattenIntoArray(target, original, element, toLength(element.length), targetIndex, depth - 1) - 1;
                    } else {
                      if (targetIndex >= 9007199254740991) throw TypeError("Exceed the acceptable array length");
                      target[targetIndex] = element;
                    }
                    targetIndex++;
                  }
                  sourceIndex++;
                }
                return targetIndex;
              };
              module3.exports = flattenIntoArray;
            })
          ),
          /***/
          "a352": (
            /***/
            (function(module3, exports$12) {
              module3.exports = __WEBPACK_EXTERNAL_MODULE_a352__;
            })
          ),
          /***/
          "a434": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var $ = __webpack_require__("23e7");
              var toAbsoluteIndex = __webpack_require__("23cb");
              var toInteger = __webpack_require__("a691");
              var toLength = __webpack_require__("50c4");
              var toObject2 = __webpack_require__("7b0b");
              var arraySpeciesCreate = __webpack_require__("65f0");
              var createProperty = __webpack_require__("8418");
              var arrayMethodHasSpeciesSupport = __webpack_require__("1dde");
              var arrayMethodUsesToLength = __webpack_require__("ae40");
              var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport("splice");
              var USES_TO_LENGTH = arrayMethodUsesToLength("splice", { ACCESSORS: true, 0: 0, 1: 2 });
              var max2 = Math.max;
              var min2 = Math.min;
              var MAX_SAFE_INTEGER = 9007199254740991;
              var MAXIMUM_ALLOWED_LENGTH_EXCEEDED = "Maximum allowed length exceeded";
              $({ target: "Array", proto: true, forced: !HAS_SPECIES_SUPPORT || !USES_TO_LENGTH }, {
                splice: function splice(start, deleteCount) {
                  var O = toObject2(this);
                  var len = toLength(O.length);
                  var actualStart = toAbsoluteIndex(start, len);
                  var argumentsLength = arguments.length;
                  var insertCount, actualDeleteCount, A2, k, from2, to2;
                  if (argumentsLength === 0) {
                    insertCount = actualDeleteCount = 0;
                  } else if (argumentsLength === 1) {
                    insertCount = 0;
                    actualDeleteCount = len - actualStart;
                  } else {
                    insertCount = argumentsLength - 2;
                    actualDeleteCount = min2(max2(toInteger(deleteCount), 0), len - actualStart);
                  }
                  if (len + insertCount - actualDeleteCount > MAX_SAFE_INTEGER) {
                    throw TypeError(MAXIMUM_ALLOWED_LENGTH_EXCEEDED);
                  }
                  A2 = arraySpeciesCreate(O, actualDeleteCount);
                  for (k = 0; k < actualDeleteCount; k++) {
                    from2 = actualStart + k;
                    if (from2 in O) createProperty(A2, k, O[from2]);
                  }
                  A2.length = actualDeleteCount;
                  if (insertCount < actualDeleteCount) {
                    for (k = actualStart; k < len - actualDeleteCount; k++) {
                      from2 = k + actualDeleteCount;
                      to2 = k + insertCount;
                      if (from2 in O) O[to2] = O[from2];
                      else delete O[to2];
                    }
                    for (k = len; k > len - actualDeleteCount + insertCount; k--) delete O[k - 1];
                  } else if (insertCount > actualDeleteCount) {
                    for (k = len - actualDeleteCount; k > actualStart; k--) {
                      from2 = k + actualDeleteCount - 1;
                      to2 = k + insertCount - 1;
                      if (from2 in O) O[to2] = O[from2];
                      else delete O[to2];
                    }
                  }
                  for (k = 0; k < insertCount; k++) {
                    O[k + actualStart] = arguments[k + 2];
                  }
                  O.length = len - actualDeleteCount + insertCount;
                  return A2;
                }
              });
            })
          ),
          /***/
          "a4d3": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var $ = __webpack_require__("23e7");
              var global2 = __webpack_require__("da84");
              var getBuiltIn = __webpack_require__("d066");
              var IS_PURE = __webpack_require__("c430");
              var DESCRIPTORS = __webpack_require__("83ab");
              var NATIVE_SYMBOL = __webpack_require__("4930");
              var USE_SYMBOL_AS_UID = __webpack_require__("fdbf");
              var fails = __webpack_require__("d039");
              var has = __webpack_require__("5135");
              var isArray2 = __webpack_require__("e8b5");
              var isObject2 = __webpack_require__("861d");
              var anObject = __webpack_require__("825a");
              var toObject2 = __webpack_require__("7b0b");
              var toIndexedObject = __webpack_require__("fc6a");
              var toPrimitive = __webpack_require__("c04e");
              var createPropertyDescriptor = __webpack_require__("5c6c");
              var nativeObjectCreate = __webpack_require__("7c73");
              var objectKeys = __webpack_require__("df75");
              var getOwnPropertyNamesModule = __webpack_require__("241c");
              var getOwnPropertyNamesExternal = __webpack_require__("057f");
              var getOwnPropertySymbolsModule = __webpack_require__("7418");
              var getOwnPropertyDescriptorModule = __webpack_require__("06cf");
              var definePropertyModule = __webpack_require__("9bf2");
              var propertyIsEnumerableModule = __webpack_require__("d1e7");
              var createNonEnumerableProperty = __webpack_require__("9112");
              var redefine = __webpack_require__("6eeb");
              var shared = __webpack_require__("5692");
              var sharedKey = __webpack_require__("f772");
              var hiddenKeys = __webpack_require__("d012");
              var uid = __webpack_require__("90e3");
              var wellKnownSymbol = __webpack_require__("b622");
              var wrappedWellKnownSymbolModule = __webpack_require__("e538");
              var defineWellKnownSymbol = __webpack_require__("746f");
              var setToStringTag = __webpack_require__("d44e");
              var InternalStateModule = __webpack_require__("69f3");
              var $forEach = __webpack_require__("b727").forEach;
              var HIDDEN = sharedKey("hidden");
              var SYMBOL = "Symbol";
              var PROTOTYPE = "prototype";
              var TO_PRIMITIVE = wellKnownSymbol("toPrimitive");
              var setInternalState = InternalStateModule.set;
              var getInternalState = InternalStateModule.getterFor(SYMBOL);
              var ObjectPrototype = Object[PROTOTYPE];
              var $Symbol = global2.Symbol;
              var $stringify = getBuiltIn("JSON", "stringify");
              var nativeGetOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
              var nativeDefineProperty = definePropertyModule.f;
              var nativeGetOwnPropertyNames = getOwnPropertyNamesExternal.f;
              var nativePropertyIsEnumerable = propertyIsEnumerableModule.f;
              var AllSymbols = shared("symbols");
              var ObjectPrototypeSymbols = shared("op-symbols");
              var StringToSymbolRegistry = shared("string-to-symbol-registry");
              var SymbolToStringRegistry = shared("symbol-to-string-registry");
              var WellKnownSymbolsStore = shared("wks");
              var QObject = global2.QObject;
              var USE_SETTER = !QObject || !QObject[PROTOTYPE] || !QObject[PROTOTYPE].findChild;
              var setSymbolDescriptor = DESCRIPTORS && fails(function() {
                return nativeObjectCreate(nativeDefineProperty({}, "a", {
                  get: function() {
                    return nativeDefineProperty(this, "a", { value: 7 }).a;
                  }
                })).a != 7;
              }) ? function(O, P, Attributes) {
                var ObjectPrototypeDescriptor = nativeGetOwnPropertyDescriptor(ObjectPrototype, P);
                if (ObjectPrototypeDescriptor) delete ObjectPrototype[P];
                nativeDefineProperty(O, P, Attributes);
                if (ObjectPrototypeDescriptor && O !== ObjectPrototype) {
                  nativeDefineProperty(ObjectPrototype, P, ObjectPrototypeDescriptor);
                }
              } : nativeDefineProperty;
              var wrap = function(tag, description) {
                var symbol = AllSymbols[tag] = nativeObjectCreate($Symbol[PROTOTYPE]);
                setInternalState(symbol, {
                  type: SYMBOL,
                  tag,
                  description
                });
                if (!DESCRIPTORS) symbol.description = description;
                return symbol;
              };
              var isSymbol2 = USE_SYMBOL_AS_UID ? function(it) {
                return typeof it == "symbol";
              } : function(it) {
                return Object(it) instanceof $Symbol;
              };
              var $defineProperty = function defineProperty(O, P, Attributes) {
                if (O === ObjectPrototype) $defineProperty(ObjectPrototypeSymbols, P, Attributes);
                anObject(O);
                var key = toPrimitive(P, true);
                anObject(Attributes);
                if (has(AllSymbols, key)) {
                  if (!Attributes.enumerable) {
                    if (!has(O, HIDDEN)) nativeDefineProperty(O, HIDDEN, createPropertyDescriptor(1, {}));
                    O[HIDDEN][key] = true;
                  } else {
                    if (has(O, HIDDEN) && O[HIDDEN][key]) O[HIDDEN][key] = false;
                    Attributes = nativeObjectCreate(Attributes, { enumerable: createPropertyDescriptor(0, false) });
                  }
                  return setSymbolDescriptor(O, key, Attributes);
                }
                return nativeDefineProperty(O, key, Attributes);
              };
              var $defineProperties = function defineProperties(O, Properties) {
                anObject(O);
                var properties = toIndexedObject(Properties);
                var keys2 = objectKeys(properties).concat($getOwnPropertySymbols(properties));
                $forEach(keys2, function(key) {
                  if (!DESCRIPTORS || $propertyIsEnumerable.call(properties, key)) $defineProperty(O, key, properties[key]);
                });
                return O;
              };
              var $create = function create(O, Properties) {
                return Properties === void 0 ? nativeObjectCreate(O) : $defineProperties(nativeObjectCreate(O), Properties);
              };
              var $propertyIsEnumerable = function propertyIsEnumerable(V) {
                var P = toPrimitive(V, true);
                var enumerable = nativePropertyIsEnumerable.call(this, P);
                if (this === ObjectPrototype && has(AllSymbols, P) && !has(ObjectPrototypeSymbols, P)) return false;
                return enumerable || !has(this, P) || !has(AllSymbols, P) || has(this, HIDDEN) && this[HIDDEN][P] ? enumerable : true;
              };
              var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(O, P) {
                var it = toIndexedObject(O);
                var key = toPrimitive(P, true);
                if (it === ObjectPrototype && has(AllSymbols, key) && !has(ObjectPrototypeSymbols, key)) return;
                var descriptor = nativeGetOwnPropertyDescriptor(it, key);
                if (descriptor && has(AllSymbols, key) && !(has(it, HIDDEN) && it[HIDDEN][key])) {
                  descriptor.enumerable = true;
                }
                return descriptor;
              };
              var $getOwnPropertyNames = function getOwnPropertyNames(O) {
                var names = nativeGetOwnPropertyNames(toIndexedObject(O));
                var result = [];
                $forEach(names, function(key) {
                  if (!has(AllSymbols, key) && !has(hiddenKeys, key)) result.push(key);
                });
                return result;
              };
              var $getOwnPropertySymbols = function getOwnPropertySymbols(O) {
                var IS_OBJECT_PROTOTYPE = O === ObjectPrototype;
                var names = nativeGetOwnPropertyNames(IS_OBJECT_PROTOTYPE ? ObjectPrototypeSymbols : toIndexedObject(O));
                var result = [];
                $forEach(names, function(key) {
                  if (has(AllSymbols, key) && (!IS_OBJECT_PROTOTYPE || has(ObjectPrototype, key))) {
                    result.push(AllSymbols[key]);
                  }
                });
                return result;
              };
              if (!NATIVE_SYMBOL) {
                $Symbol = function Symbol2() {
                  if (this instanceof $Symbol) throw TypeError("Symbol is not a constructor");
                  var description = !arguments.length || arguments[0] === void 0 ? void 0 : String(arguments[0]);
                  var tag = uid(description);
                  var setter = function(value) {
                    if (this === ObjectPrototype) setter.call(ObjectPrototypeSymbols, value);
                    if (has(this, HIDDEN) && has(this[HIDDEN], tag)) this[HIDDEN][tag] = false;
                    setSymbolDescriptor(this, tag, createPropertyDescriptor(1, value));
                  };
                  if (DESCRIPTORS && USE_SETTER) setSymbolDescriptor(ObjectPrototype, tag, { configurable: true, set: setter });
                  return wrap(tag, description);
                };
                redefine($Symbol[PROTOTYPE], "toString", function toString2() {
                  return getInternalState(this).tag;
                });
                redefine($Symbol, "withoutSetter", function(description) {
                  return wrap(uid(description), description);
                });
                propertyIsEnumerableModule.f = $propertyIsEnumerable;
                definePropertyModule.f = $defineProperty;
                getOwnPropertyDescriptorModule.f = $getOwnPropertyDescriptor;
                getOwnPropertyNamesModule.f = getOwnPropertyNamesExternal.f = $getOwnPropertyNames;
                getOwnPropertySymbolsModule.f = $getOwnPropertySymbols;
                wrappedWellKnownSymbolModule.f = function(name2) {
                  return wrap(wellKnownSymbol(name2), name2);
                };
                if (DESCRIPTORS) {
                  nativeDefineProperty($Symbol[PROTOTYPE], "description", {
                    configurable: true,
                    get: function description() {
                      return getInternalState(this).description;
                    }
                  });
                  if (!IS_PURE) {
                    redefine(ObjectPrototype, "propertyIsEnumerable", $propertyIsEnumerable, { unsafe: true });
                  }
                }
              }
              $({ global: true, wrap: true, forced: !NATIVE_SYMBOL, sham: !NATIVE_SYMBOL }, {
                Symbol: $Symbol
              });
              $forEach(objectKeys(WellKnownSymbolsStore), function(name2) {
                defineWellKnownSymbol(name2);
              });
              $({ target: SYMBOL, stat: true, forced: !NATIVE_SYMBOL }, {
                // `Symbol.for` method
                // https://tc39.github.io/ecma262/#sec-symbol.for
                "for": function(key) {
                  var string = String(key);
                  if (has(StringToSymbolRegistry, string)) return StringToSymbolRegistry[string];
                  var symbol = $Symbol(string);
                  StringToSymbolRegistry[string] = symbol;
                  SymbolToStringRegistry[symbol] = string;
                  return symbol;
                },
                // `Symbol.keyFor` method
                // https://tc39.github.io/ecma262/#sec-symbol.keyfor
                keyFor: function keyFor(sym) {
                  if (!isSymbol2(sym)) throw TypeError(sym + " is not a symbol");
                  if (has(SymbolToStringRegistry, sym)) return SymbolToStringRegistry[sym];
                },
                useSetter: function() {
                  USE_SETTER = true;
                },
                useSimple: function() {
                  USE_SETTER = false;
                }
              });
              $({ target: "Object", stat: true, forced: !NATIVE_SYMBOL, sham: !DESCRIPTORS }, {
                // `Object.create` method
                // https://tc39.github.io/ecma262/#sec-object.create
                create: $create,
                // `Object.defineProperty` method
                // https://tc39.github.io/ecma262/#sec-object.defineproperty
                defineProperty: $defineProperty,
                // `Object.defineProperties` method
                // https://tc39.github.io/ecma262/#sec-object.defineproperties
                defineProperties: $defineProperties,
                // `Object.getOwnPropertyDescriptor` method
                // https://tc39.github.io/ecma262/#sec-object.getownpropertydescriptors
                getOwnPropertyDescriptor: $getOwnPropertyDescriptor
              });
              $({ target: "Object", stat: true, forced: !NATIVE_SYMBOL }, {
                // `Object.getOwnPropertyNames` method
                // https://tc39.github.io/ecma262/#sec-object.getownpropertynames
                getOwnPropertyNames: $getOwnPropertyNames,
                // `Object.getOwnPropertySymbols` method
                // https://tc39.github.io/ecma262/#sec-object.getownpropertysymbols
                getOwnPropertySymbols: $getOwnPropertySymbols
              });
              $({ target: "Object", stat: true, forced: fails(function() {
                getOwnPropertySymbolsModule.f(1);
              }) }, {
                getOwnPropertySymbols: function getOwnPropertySymbols(it) {
                  return getOwnPropertySymbolsModule.f(toObject2(it));
                }
              });
              if ($stringify) {
                var FORCED_JSON_STRINGIFY = !NATIVE_SYMBOL || fails(function() {
                  var symbol = $Symbol();
                  return $stringify([symbol]) != "[null]" || $stringify({ a: symbol }) != "{}" || $stringify(Object(symbol)) != "{}";
                });
                $({ target: "JSON", stat: true, forced: FORCED_JSON_STRINGIFY }, {
                  // eslint-disable-next-line no-unused-vars
                  stringify: function stringify(it, replacer, space) {
                    var args = [it];
                    var index2 = 1;
                    var $replacer;
                    while (arguments.length > index2) args.push(arguments[index2++]);
                    $replacer = replacer;
                    if (!isObject2(replacer) && it === void 0 || isSymbol2(it)) return;
                    if (!isArray2(replacer)) replacer = function(key, value) {
                      if (typeof $replacer == "function") value = $replacer.call(this, key, value);
                      if (!isSymbol2(value)) return value;
                    };
                    args[1] = replacer;
                    return $stringify.apply(null, args);
                  }
                });
              }
              if (!$Symbol[PROTOTYPE][TO_PRIMITIVE]) {
                createNonEnumerableProperty($Symbol[PROTOTYPE], TO_PRIMITIVE, $Symbol[PROTOTYPE].valueOf);
              }
              setToStringTag($Symbol, SYMBOL);
              hiddenKeys[HIDDEN] = true;
            })
          ),
          /***/
          "a630": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var $ = __webpack_require__("23e7");
              var from2 = __webpack_require__("4df4");
              var checkCorrectnessOfIteration = __webpack_require__("1c7e");
              var INCORRECT_ITERATION = !checkCorrectnessOfIteration(function(iterable) {
                Array.from(iterable);
              });
              $({ target: "Array", stat: true, forced: INCORRECT_ITERATION }, {
                from: from2
              });
            })
          ),
          /***/
          "a640": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var fails = __webpack_require__("d039");
              module3.exports = function(METHOD_NAME, argument) {
                var method = [][METHOD_NAME];
                return !!method && fails(function() {
                  method.call(null, argument || function() {
                    throw 1;
                  }, 1);
                });
              };
            })
          ),
          /***/
          "a691": (
            /***/
            (function(module3, exports$12) {
              var ceil = Math.ceil;
              var floor = Math.floor;
              module3.exports = function(argument) {
                return isNaN(argument = +argument) ? 0 : (argument > 0 ? floor : ceil)(argument);
              };
            })
          ),
          /***/
          "ab13": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var wellKnownSymbol = __webpack_require__("b622");
              var MATCH = wellKnownSymbol("match");
              module3.exports = function(METHOD_NAME) {
                var regexp = /./;
                try {
                  "/./"[METHOD_NAME](regexp);
                } catch (e) {
                  try {
                    regexp[MATCH] = false;
                    return "/./"[METHOD_NAME](regexp);
                  } catch (f) {
                  }
                }
                return false;
              };
            })
          ),
          /***/
          "ac1f": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var $ = __webpack_require__("23e7");
              var exec = __webpack_require__("9263");
              $({ target: "RegExp", proto: true, forced: /./.exec !== exec }, {
                exec
              });
            })
          ),
          /***/
          "ad6d": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var anObject = __webpack_require__("825a");
              module3.exports = function() {
                var that = anObject(this);
                var result = "";
                if (that.global) result += "g";
                if (that.ignoreCase) result += "i";
                if (that.multiline) result += "m";
                if (that.dotAll) result += "s";
                if (that.unicode) result += "u";
                if (that.sticky) result += "y";
                return result;
              };
            })
          ),
          /***/
          "ae40": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var DESCRIPTORS = __webpack_require__("83ab");
              var fails = __webpack_require__("d039");
              var has = __webpack_require__("5135");
              var defineProperty = Object.defineProperty;
              var cache = {};
              var thrower = function(it) {
                throw it;
              };
              module3.exports = function(METHOD_NAME, options2) {
                if (has(cache, METHOD_NAME)) return cache[METHOD_NAME];
                if (!options2) options2 = {};
                var method = [][METHOD_NAME];
                var ACCESSORS = has(options2, "ACCESSORS") ? options2.ACCESSORS : false;
                var argument0 = has(options2, 0) ? options2[0] : thrower;
                var argument1 = has(options2, 1) ? options2[1] : void 0;
                return cache[METHOD_NAME] = !!method && !fails(function() {
                  if (ACCESSORS && !DESCRIPTORS) return true;
                  var O = { length: -1 };
                  if (ACCESSORS) defineProperty(O, 1, { enumerable: true, get: thrower });
                  else O[1] = 1;
                  method.call(O, argument0, argument1);
                });
              };
            })
          ),
          /***/
          "ae93": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var getPrototypeOf = __webpack_require__("e163");
              var createNonEnumerableProperty = __webpack_require__("9112");
              var has = __webpack_require__("5135");
              var wellKnownSymbol = __webpack_require__("b622");
              var IS_PURE = __webpack_require__("c430");
              var ITERATOR = wellKnownSymbol("iterator");
              var BUGGY_SAFARI_ITERATORS = false;
              var returnThis = function() {
                return this;
              };
              var IteratorPrototype, PrototypeOfArrayIteratorPrototype, arrayIterator;
              if ([].keys) {
                arrayIterator = [].keys();
                if (!("next" in arrayIterator)) BUGGY_SAFARI_ITERATORS = true;
                else {
                  PrototypeOfArrayIteratorPrototype = getPrototypeOf(getPrototypeOf(arrayIterator));
                  if (PrototypeOfArrayIteratorPrototype !== Object.prototype) IteratorPrototype = PrototypeOfArrayIteratorPrototype;
                }
              }
              if (IteratorPrototype == void 0) IteratorPrototype = {};
              if (!IS_PURE && !has(IteratorPrototype, ITERATOR)) {
                createNonEnumerableProperty(IteratorPrototype, ITERATOR, returnThis);
              }
              module3.exports = {
                IteratorPrototype,
                BUGGY_SAFARI_ITERATORS
              };
            })
          ),
          /***/
          "b041": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var TO_STRING_TAG_SUPPORT = __webpack_require__("00ee");
              var classof = __webpack_require__("f5df");
              module3.exports = TO_STRING_TAG_SUPPORT ? {}.toString : function toString2() {
                return "[object " + classof(this) + "]";
              };
            })
          ),
          /***/
          "b0c0": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var DESCRIPTORS = __webpack_require__("83ab");
              var defineProperty = __webpack_require__("9bf2").f;
              var FunctionPrototype = Function.prototype;
              var FunctionPrototypeToString = FunctionPrototype.toString;
              var nameRE = /^\s*function ([^ (]*)/;
              var NAME = "name";
              if (DESCRIPTORS && !(NAME in FunctionPrototype)) {
                defineProperty(FunctionPrototype, NAME, {
                  configurable: true,
                  get: function() {
                    try {
                      return FunctionPrototypeToString.call(this).match(nameRE)[1];
                    } catch (error) {
                      return "";
                    }
                  }
                });
              }
            })
          ),
          /***/
          "b622": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var global2 = __webpack_require__("da84");
              var shared = __webpack_require__("5692");
              var has = __webpack_require__("5135");
              var uid = __webpack_require__("90e3");
              var NATIVE_SYMBOL = __webpack_require__("4930");
              var USE_SYMBOL_AS_UID = __webpack_require__("fdbf");
              var WellKnownSymbolsStore = shared("wks");
              var Symbol2 = global2.Symbol;
              var createWellKnownSymbol = USE_SYMBOL_AS_UID ? Symbol2 : Symbol2 && Symbol2.withoutSetter || uid;
              module3.exports = function(name2) {
                if (!has(WellKnownSymbolsStore, name2)) {
                  if (NATIVE_SYMBOL && has(Symbol2, name2)) WellKnownSymbolsStore[name2] = Symbol2[name2];
                  else WellKnownSymbolsStore[name2] = createWellKnownSymbol("Symbol." + name2);
                }
                return WellKnownSymbolsStore[name2];
              };
            })
          ),
          /***/
          "b64b": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var $ = __webpack_require__("23e7");
              var toObject2 = __webpack_require__("7b0b");
              var nativeKeys = __webpack_require__("df75");
              var fails = __webpack_require__("d039");
              var FAILS_ON_PRIMITIVES = fails(function() {
                nativeKeys(1);
              });
              $({ target: "Object", stat: true, forced: FAILS_ON_PRIMITIVES }, {
                keys: function keys2(it) {
                  return nativeKeys(toObject2(it));
                }
              });
            })
          ),
          /***/
          "b727": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var bind = __webpack_require__("0366");
              var IndexedObject = __webpack_require__("44ad");
              var toObject2 = __webpack_require__("7b0b");
              var toLength = __webpack_require__("50c4");
              var arraySpeciesCreate = __webpack_require__("65f0");
              var push = [].push;
              var createMethod = function(TYPE) {
                var IS_MAP = TYPE == 1;
                var IS_FILTER = TYPE == 2;
                var IS_SOME = TYPE == 3;
                var IS_EVERY = TYPE == 4;
                var IS_FIND_INDEX = TYPE == 6;
                var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
                return function($this, callbackfn, that, specificCreate) {
                  var O = toObject2($this);
                  var self2 = IndexedObject(O);
                  var boundFunction = bind(callbackfn, that, 3);
                  var length = toLength(self2.length);
                  var index2 = 0;
                  var create = specificCreate || arraySpeciesCreate;
                  var target = IS_MAP ? create($this, length) : IS_FILTER ? create($this, 0) : void 0;
                  var value, result;
                  for (; length > index2; index2++) if (NO_HOLES || index2 in self2) {
                    value = self2[index2];
                    result = boundFunction(value, index2, O);
                    if (TYPE) {
                      if (IS_MAP) target[index2] = result;
                      else if (result) switch (TYPE) {
                        case 3:
                          return true;
                        // some
                        case 5:
                          return value;
                        // find
                        case 6:
                          return index2;
                        // findIndex
                        case 2:
                          push.call(target, value);
                      }
                      else if (IS_EVERY) return false;
                    }
                  }
                  return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : target;
                };
              };
              module3.exports = {
                // `Array.prototype.forEach` method
                // https://tc39.github.io/ecma262/#sec-array.prototype.foreach
                forEach: createMethod(0),
                // `Array.prototype.map` method
                // https://tc39.github.io/ecma262/#sec-array.prototype.map
                map: createMethod(1),
                // `Array.prototype.filter` method
                // https://tc39.github.io/ecma262/#sec-array.prototype.filter
                filter: createMethod(2),
                // `Array.prototype.some` method
                // https://tc39.github.io/ecma262/#sec-array.prototype.some
                some: createMethod(3),
                // `Array.prototype.every` method
                // https://tc39.github.io/ecma262/#sec-array.prototype.every
                every: createMethod(4),
                // `Array.prototype.find` method
                // https://tc39.github.io/ecma262/#sec-array.prototype.find
                find: createMethod(5),
                // `Array.prototype.findIndex` method
                // https://tc39.github.io/ecma262/#sec-array.prototype.findIndex
                findIndex: createMethod(6)
              };
            })
          ),
          /***/
          "c04e": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var isObject2 = __webpack_require__("861d");
              module3.exports = function(input, PREFERRED_STRING) {
                if (!isObject2(input)) return input;
                var fn, val;
                if (PREFERRED_STRING && typeof (fn = input.toString) == "function" && !isObject2(val = fn.call(input))) return val;
                if (typeof (fn = input.valueOf) == "function" && !isObject2(val = fn.call(input))) return val;
                if (!PREFERRED_STRING && typeof (fn = input.toString) == "function" && !isObject2(val = fn.call(input))) return val;
                throw TypeError("Can't convert object to primitive value");
              };
            })
          ),
          /***/
          "c430": (
            /***/
            (function(module3, exports$12) {
              module3.exports = false;
            })
          ),
          /***/
          "c6b6": (
            /***/
            (function(module3, exports$12) {
              var toString2 = {}.toString;
              module3.exports = function(it) {
                return toString2.call(it).slice(8, -1);
              };
            })
          ),
          /***/
          "c6cd": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var global2 = __webpack_require__("da84");
              var setGlobal = __webpack_require__("ce4e");
              var SHARED = "__core-js_shared__";
              var store = global2[SHARED] || setGlobal(SHARED, {});
              module3.exports = store;
            })
          ),
          /***/
          "c740": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var $ = __webpack_require__("23e7");
              var $findIndex = __webpack_require__("b727").findIndex;
              var addToUnscopables = __webpack_require__("44d2");
              var arrayMethodUsesToLength = __webpack_require__("ae40");
              var FIND_INDEX = "findIndex";
              var SKIPS_HOLES = true;
              var USES_TO_LENGTH = arrayMethodUsesToLength(FIND_INDEX);
              if (FIND_INDEX in []) Array(1)[FIND_INDEX](function() {
                SKIPS_HOLES = false;
              });
              $({ target: "Array", proto: true, forced: SKIPS_HOLES || !USES_TO_LENGTH }, {
                findIndex: function findIndex(callbackfn) {
                  return $findIndex(this, callbackfn, arguments.length > 1 ? arguments[1] : void 0);
                }
              });
              addToUnscopables(FIND_INDEX);
            })
          ),
          /***/
          "c8ba": (
            /***/
            (function(module3, exports$12) {
              var g;
              g = /* @__PURE__ */ (function() {
                return this;
              })();
              try {
                g = g || new Function("return this")();
              } catch (e) {
                if (typeof window === "object") g = window;
              }
              module3.exports = g;
            })
          ),
          /***/
          "c975": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var $ = __webpack_require__("23e7");
              var $indexOf = __webpack_require__("4d64").indexOf;
              var arrayMethodIsStrict = __webpack_require__("a640");
              var arrayMethodUsesToLength = __webpack_require__("ae40");
              var nativeIndexOf = [].indexOf;
              var NEGATIVE_ZERO = !!nativeIndexOf && 1 / [1].indexOf(1, -0) < 0;
              var STRICT_METHOD = arrayMethodIsStrict("indexOf");
              var USES_TO_LENGTH = arrayMethodUsesToLength("indexOf", { ACCESSORS: true, 1: 0 });
              $({ target: "Array", proto: true, forced: NEGATIVE_ZERO || !STRICT_METHOD || !USES_TO_LENGTH }, {
                indexOf: function indexOf2(searchElement) {
                  return NEGATIVE_ZERO ? nativeIndexOf.apply(this, arguments) || 0 : $indexOf(this, searchElement, arguments.length > 1 ? arguments[1] : void 0);
                }
              });
            })
          ),
          /***/
          "ca84": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var has = __webpack_require__("5135");
              var toIndexedObject = __webpack_require__("fc6a");
              var indexOf2 = __webpack_require__("4d64").indexOf;
              var hiddenKeys = __webpack_require__("d012");
              module3.exports = function(object, names) {
                var O = toIndexedObject(object);
                var i = 0;
                var result = [];
                var key;
                for (key in O) !has(hiddenKeys, key) && has(O, key) && result.push(key);
                while (names.length > i) if (has(O, key = names[i++])) {
                  ~indexOf2(result, key) || result.push(key);
                }
                return result;
              };
            })
          ),
          /***/
          "caad": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var $ = __webpack_require__("23e7");
              var $includes = __webpack_require__("4d64").includes;
              var addToUnscopables = __webpack_require__("44d2");
              var arrayMethodUsesToLength = __webpack_require__("ae40");
              var USES_TO_LENGTH = arrayMethodUsesToLength("indexOf", { ACCESSORS: true, 1: 0 });
              $({ target: "Array", proto: true, forced: !USES_TO_LENGTH }, {
                includes: function includes(el) {
                  return $includes(this, el, arguments.length > 1 ? arguments[1] : void 0);
                }
              });
              addToUnscopables("includes");
            })
          ),
          /***/
          "cc12": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var global2 = __webpack_require__("da84");
              var isObject2 = __webpack_require__("861d");
              var document2 = global2.document;
              var EXISTS = isObject2(document2) && isObject2(document2.createElement);
              module3.exports = function(it) {
                return EXISTS ? document2.createElement(it) : {};
              };
            })
          ),
          /***/
          "ce4e": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var global2 = __webpack_require__("da84");
              var createNonEnumerableProperty = __webpack_require__("9112");
              module3.exports = function(key, value) {
                try {
                  createNonEnumerableProperty(global2, key, value);
                } catch (error) {
                  global2[key] = value;
                }
                return value;
              };
            })
          ),
          /***/
          "d012": (
            /***/
            (function(module3, exports$12) {
              module3.exports = {};
            })
          ),
          /***/
          "d039": (
            /***/
            (function(module3, exports$12) {
              module3.exports = function(exec) {
                try {
                  return !!exec();
                } catch (error) {
                  return true;
                }
              };
            })
          ),
          /***/
          "d066": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var path = __webpack_require__("428f");
              var global2 = __webpack_require__("da84");
              var aFunction = function(variable) {
                return typeof variable == "function" ? variable : void 0;
              };
              module3.exports = function(namespace, method) {
                return arguments.length < 2 ? aFunction(path[namespace]) || aFunction(global2[namespace]) : path[namespace] && path[namespace][method] || global2[namespace] && global2[namespace][method];
              };
            })
          ),
          /***/
          "d1e7": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var nativePropertyIsEnumerable = {}.propertyIsEnumerable;
              var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
              var NASHORN_BUG = getOwnPropertyDescriptor && !nativePropertyIsEnumerable.call({ 1: 2 }, 1);
              exports$12.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
                var descriptor = getOwnPropertyDescriptor(this, V);
                return !!descriptor && descriptor.enumerable;
              } : nativePropertyIsEnumerable;
            })
          ),
          /***/
          "d28b": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var defineWellKnownSymbol = __webpack_require__("746f");
              defineWellKnownSymbol("iterator");
            })
          ),
          /***/
          "d2bb": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var anObject = __webpack_require__("825a");
              var aPossiblePrototype = __webpack_require__("3bbe");
              module3.exports = Object.setPrototypeOf || ("__proto__" in {} ? (function() {
                var CORRECT_SETTER = false;
                var test = {};
                var setter;
                try {
                  setter = Object.getOwnPropertyDescriptor(Object.prototype, "__proto__").set;
                  setter.call(test, []);
                  CORRECT_SETTER = test instanceof Array;
                } catch (error) {
                }
                return function setPrototypeOf(O, proto2) {
                  anObject(O);
                  aPossiblePrototype(proto2);
                  if (CORRECT_SETTER) setter.call(O, proto2);
                  else O.__proto__ = proto2;
                  return O;
                };
              })() : void 0);
            })
          ),
          /***/
          "d3b7": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var TO_STRING_TAG_SUPPORT = __webpack_require__("00ee");
              var redefine = __webpack_require__("6eeb");
              var toString2 = __webpack_require__("b041");
              if (!TO_STRING_TAG_SUPPORT) {
                redefine(Object.prototype, "toString", toString2, { unsafe: true });
              }
            })
          ),
          /***/
          "d44e": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var defineProperty = __webpack_require__("9bf2").f;
              var has = __webpack_require__("5135");
              var wellKnownSymbol = __webpack_require__("b622");
              var TO_STRING_TAG = wellKnownSymbol("toStringTag");
              module3.exports = function(it, TAG, STATIC) {
                if (it && !has(it = STATIC ? it : it.prototype, TO_STRING_TAG)) {
                  defineProperty(it, TO_STRING_TAG, { configurable: true, value: TAG });
                }
              };
            })
          ),
          /***/
          "d58f": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var aFunction = __webpack_require__("1c0b");
              var toObject2 = __webpack_require__("7b0b");
              var IndexedObject = __webpack_require__("44ad");
              var toLength = __webpack_require__("50c4");
              var createMethod = function(IS_RIGHT) {
                return function(that, callbackfn, argumentsLength, memo) {
                  aFunction(callbackfn);
                  var O = toObject2(that);
                  var self2 = IndexedObject(O);
                  var length = toLength(O.length);
                  var index2 = IS_RIGHT ? length - 1 : 0;
                  var i = IS_RIGHT ? -1 : 1;
                  if (argumentsLength < 2) while (true) {
                    if (index2 in self2) {
                      memo = self2[index2];
                      index2 += i;
                      break;
                    }
                    index2 += i;
                    if (IS_RIGHT ? index2 < 0 : length <= index2) {
                      throw TypeError("Reduce of empty array with no initial value");
                    }
                  }
                  for (; IS_RIGHT ? index2 >= 0 : length > index2; index2 += i) if (index2 in self2) {
                    memo = callbackfn(memo, self2[index2], index2, O);
                  }
                  return memo;
                };
              };
              module3.exports = {
                // `Array.prototype.reduce` method
                // https://tc39.github.io/ecma262/#sec-array.prototype.reduce
                left: createMethod(false),
                // `Array.prototype.reduceRight` method
                // https://tc39.github.io/ecma262/#sec-array.prototype.reduceright
                right: createMethod(true)
              };
            })
          ),
          /***/
          "d784": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              __webpack_require__("ac1f");
              var redefine = __webpack_require__("6eeb");
              var fails = __webpack_require__("d039");
              var wellKnownSymbol = __webpack_require__("b622");
              var regexpExec = __webpack_require__("9263");
              var createNonEnumerableProperty = __webpack_require__("9112");
              var SPECIES = wellKnownSymbol("species");
              var REPLACE_SUPPORTS_NAMED_GROUPS = !fails(function() {
                var re = /./;
                re.exec = function() {
                  var result = [];
                  result.groups = { a: "7" };
                  return result;
                };
                return "".replace(re, "$<a>") !== "7";
              });
              var REPLACE_KEEPS_$0 = (function() {
                return "a".replace(/./, "$0") === "$0";
              })();
              var REPLACE = wellKnownSymbol("replace");
              var REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE = (function() {
                if (/./[REPLACE]) {
                  return /./[REPLACE]("a", "$0") === "";
                }
                return false;
              })();
              var SPLIT_WORKS_WITH_OVERWRITTEN_EXEC = !fails(function() {
                var re = /(?:)/;
                var originalExec = re.exec;
                re.exec = function() {
                  return originalExec.apply(this, arguments);
                };
                var result = "ab".split(re);
                return result.length !== 2 || result[0] !== "a" || result[1] !== "b";
              });
              module3.exports = function(KEY, length, exec, sham) {
                var SYMBOL = wellKnownSymbol(KEY);
                var DELEGATES_TO_SYMBOL = !fails(function() {
                  var O = {};
                  O[SYMBOL] = function() {
                    return 7;
                  };
                  return ""[KEY](O) != 7;
                });
                var DELEGATES_TO_EXEC = DELEGATES_TO_SYMBOL && !fails(function() {
                  var execCalled = false;
                  var re = /a/;
                  if (KEY === "split") {
                    re = {};
                    re.constructor = {};
                    re.constructor[SPECIES] = function() {
                      return re;
                    };
                    re.flags = "";
                    re[SYMBOL] = /./[SYMBOL];
                  }
                  re.exec = function() {
                    execCalled = true;
                    return null;
                  };
                  re[SYMBOL]("");
                  return !execCalled;
                });
                if (!DELEGATES_TO_SYMBOL || !DELEGATES_TO_EXEC || KEY === "replace" && !(REPLACE_SUPPORTS_NAMED_GROUPS && REPLACE_KEEPS_$0 && !REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE) || KEY === "split" && !SPLIT_WORKS_WITH_OVERWRITTEN_EXEC) {
                  var nativeRegExpMethod = /./[SYMBOL];
                  var methods = exec(SYMBOL, ""[KEY], function(nativeMethod, regexp, str, arg2, forceStringMethod) {
                    if (regexp.exec === regexpExec) {
                      if (DELEGATES_TO_SYMBOL && !forceStringMethod) {
                        return { done: true, value: nativeRegExpMethod.call(regexp, str, arg2) };
                      }
                      return { done: true, value: nativeMethod.call(str, regexp, arg2) };
                    }
                    return { done: false };
                  }, {
                    REPLACE_KEEPS_$0,
                    REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE
                  });
                  var stringMethod = methods[0];
                  var regexMethod = methods[1];
                  redefine(String.prototype, KEY, stringMethod);
                  redefine(
                    RegExp.prototype,
                    SYMBOL,
                    length == 2 ? function(string, arg) {
                      return regexMethod.call(string, this, arg);
                    } : function(string) {
                      return regexMethod.call(string, this);
                    }
                  );
                }
                if (sham) createNonEnumerableProperty(RegExp.prototype[SYMBOL], "sham", true);
              };
            })
          ),
          /***/
          "d81d": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var $ = __webpack_require__("23e7");
              var $map = __webpack_require__("b727").map;
              var arrayMethodHasSpeciesSupport = __webpack_require__("1dde");
              var arrayMethodUsesToLength = __webpack_require__("ae40");
              var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport("map");
              var USES_TO_LENGTH = arrayMethodUsesToLength("map");
              $({ target: "Array", proto: true, forced: !HAS_SPECIES_SUPPORT || !USES_TO_LENGTH }, {
                map: function map2(callbackfn) {
                  return $map(this, callbackfn, arguments.length > 1 ? arguments[1] : void 0);
                }
              });
            })
          ),
          /***/
          "da84": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              (function(global2) {
                var check = function(it) {
                  return it && it.Math == Math && it;
                };
                module3.exports = // eslint-disable-next-line no-undef
                check(typeof globalThis == "object" && globalThis) || check(typeof window == "object" && window) || check(typeof self == "object" && self) || check(typeof global2 == "object" && global2) || // eslint-disable-next-line no-new-func
                Function("return this")();
              }).call(this, __webpack_require__("c8ba"));
            })
          ),
          /***/
          "dbb4": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var $ = __webpack_require__("23e7");
              var DESCRIPTORS = __webpack_require__("83ab");
              var ownKeys2 = __webpack_require__("56ef");
              var toIndexedObject = __webpack_require__("fc6a");
              var getOwnPropertyDescriptorModule = __webpack_require__("06cf");
              var createProperty = __webpack_require__("8418");
              $({ target: "Object", stat: true, sham: !DESCRIPTORS }, {
                getOwnPropertyDescriptors: function getOwnPropertyDescriptors(object) {
                  var O = toIndexedObject(object);
                  var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
                  var keys2 = ownKeys2(O);
                  var result = {};
                  var index2 = 0;
                  var key, descriptor;
                  while (keys2.length > index2) {
                    descriptor = getOwnPropertyDescriptor(O, key = keys2[index2++]);
                    if (descriptor !== void 0) createProperty(result, key, descriptor);
                  }
                  return result;
                }
              });
            })
          ),
          /***/
          "dbf1": (
            /***/
            (function(module3, __webpack_exports__, __webpack_require__) {
              (function(global2) {
                __webpack_require__.d(__webpack_exports__, "a", function() {
                  return console2;
                });
                function getConsole() {
                  if (typeof window !== "undefined") {
                    return window.console;
                  }
                  return global2.console;
                }
                var console2 = getConsole();
              }).call(this, __webpack_require__("c8ba"));
            })
          ),
          /***/
          "ddb0": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var global2 = __webpack_require__("da84");
              var DOMIterables = __webpack_require__("fdbc");
              var ArrayIteratorMethods = __webpack_require__("e260");
              var createNonEnumerableProperty = __webpack_require__("9112");
              var wellKnownSymbol = __webpack_require__("b622");
              var ITERATOR = wellKnownSymbol("iterator");
              var TO_STRING_TAG = wellKnownSymbol("toStringTag");
              var ArrayValues = ArrayIteratorMethods.values;
              for (var COLLECTION_NAME in DOMIterables) {
                var Collection = global2[COLLECTION_NAME];
                var CollectionPrototype = Collection && Collection.prototype;
                if (CollectionPrototype) {
                  if (CollectionPrototype[ITERATOR] !== ArrayValues) try {
                    createNonEnumerableProperty(CollectionPrototype, ITERATOR, ArrayValues);
                  } catch (error) {
                    CollectionPrototype[ITERATOR] = ArrayValues;
                  }
                  if (!CollectionPrototype[TO_STRING_TAG]) {
                    createNonEnumerableProperty(CollectionPrototype, TO_STRING_TAG, COLLECTION_NAME);
                  }
                  if (DOMIterables[COLLECTION_NAME]) for (var METHOD_NAME in ArrayIteratorMethods) {
                    if (CollectionPrototype[METHOD_NAME] !== ArrayIteratorMethods[METHOD_NAME]) try {
                      createNonEnumerableProperty(CollectionPrototype, METHOD_NAME, ArrayIteratorMethods[METHOD_NAME]);
                    } catch (error) {
                      CollectionPrototype[METHOD_NAME] = ArrayIteratorMethods[METHOD_NAME];
                    }
                  }
                }
              }
            })
          ),
          /***/
          "df75": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var internalObjectKeys = __webpack_require__("ca84");
              var enumBugKeys = __webpack_require__("7839");
              module3.exports = Object.keys || function keys2(O) {
                return internalObjectKeys(O, enumBugKeys);
              };
            })
          ),
          /***/
          "e01a": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var $ = __webpack_require__("23e7");
              var DESCRIPTORS = __webpack_require__("83ab");
              var global2 = __webpack_require__("da84");
              var has = __webpack_require__("5135");
              var isObject2 = __webpack_require__("861d");
              var defineProperty = __webpack_require__("9bf2").f;
              var copyConstructorProperties = __webpack_require__("e893");
              var NativeSymbol = global2.Symbol;
              if (DESCRIPTORS && typeof NativeSymbol == "function" && (!("description" in NativeSymbol.prototype) || // Safari 12 bug
              NativeSymbol().description !== void 0)) {
                var EmptyStringDescriptionStore = {};
                var SymbolWrapper = function Symbol2() {
                  var description = arguments.length < 1 || arguments[0] === void 0 ? void 0 : String(arguments[0]);
                  var result = this instanceof SymbolWrapper ? new NativeSymbol(description) : description === void 0 ? NativeSymbol() : NativeSymbol(description);
                  if (description === "") EmptyStringDescriptionStore[result] = true;
                  return result;
                };
                copyConstructorProperties(SymbolWrapper, NativeSymbol);
                var symbolPrototype = SymbolWrapper.prototype = NativeSymbol.prototype;
                symbolPrototype.constructor = SymbolWrapper;
                var symbolToString = symbolPrototype.toString;
                var native = String(NativeSymbol("test")) == "Symbol(test)";
                var regexp = /^Symbol\((.*)\)[^)]+$/;
                defineProperty(symbolPrototype, "description", {
                  configurable: true,
                  get: function description() {
                    var symbol = isObject2(this) ? this.valueOf() : this;
                    var string = symbolToString.call(symbol);
                    if (has(EmptyStringDescriptionStore, symbol)) return "";
                    var desc = native ? string.slice(7, -1) : string.replace(regexp, "$1");
                    return desc === "" ? void 0 : desc;
                  }
                });
                $({ global: true, forced: true }, {
                  Symbol: SymbolWrapper
                });
              }
            })
          ),
          /***/
          "e163": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var has = __webpack_require__("5135");
              var toObject2 = __webpack_require__("7b0b");
              var sharedKey = __webpack_require__("f772");
              var CORRECT_PROTOTYPE_GETTER = __webpack_require__("e177");
              var IE_PROTO = sharedKey("IE_PROTO");
              var ObjectPrototype = Object.prototype;
              module3.exports = CORRECT_PROTOTYPE_GETTER ? Object.getPrototypeOf : function(O) {
                O = toObject2(O);
                if (has(O, IE_PROTO)) return O[IE_PROTO];
                if (typeof O.constructor == "function" && O instanceof O.constructor) {
                  return O.constructor.prototype;
                }
                return O instanceof Object ? ObjectPrototype : null;
              };
            })
          ),
          /***/
          "e177": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var fails = __webpack_require__("d039");
              module3.exports = !fails(function() {
                function F() {
                }
                F.prototype.constructor = null;
                return Object.getPrototypeOf(new F()) !== F.prototype;
              });
            })
          ),
          /***/
          "e260": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var toIndexedObject = __webpack_require__("fc6a");
              var addToUnscopables = __webpack_require__("44d2");
              var Iterators = __webpack_require__("3f8c");
              var InternalStateModule = __webpack_require__("69f3");
              var defineIterator = __webpack_require__("7dd0");
              var ARRAY_ITERATOR = "Array Iterator";
              var setInternalState = InternalStateModule.set;
              var getInternalState = InternalStateModule.getterFor(ARRAY_ITERATOR);
              module3.exports = defineIterator(Array, "Array", function(iterated, kind) {
                setInternalState(this, {
                  type: ARRAY_ITERATOR,
                  target: toIndexedObject(iterated),
                  // target
                  index: 0,
                  // next index
                  kind
                  // kind
                });
              }, function() {
                var state = getInternalState(this);
                var target = state.target;
                var kind = state.kind;
                var index2 = state.index++;
                if (!target || index2 >= target.length) {
                  state.target = void 0;
                  return { value: void 0, done: true };
                }
                if (kind == "keys") return { value: index2, done: false };
                if (kind == "values") return { value: target[index2], done: false };
                return { value: [index2, target[index2]], done: false };
              }, "values");
              Iterators.Arguments = Iterators.Array;
              addToUnscopables("keys");
              addToUnscopables("values");
              addToUnscopables("entries");
            })
          ),
          /***/
          "e439": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var $ = __webpack_require__("23e7");
              var fails = __webpack_require__("d039");
              var toIndexedObject = __webpack_require__("fc6a");
              var nativeGetOwnPropertyDescriptor = __webpack_require__("06cf").f;
              var DESCRIPTORS = __webpack_require__("83ab");
              var FAILS_ON_PRIMITIVES = fails(function() {
                nativeGetOwnPropertyDescriptor(1);
              });
              var FORCED = !DESCRIPTORS || FAILS_ON_PRIMITIVES;
              $({ target: "Object", stat: true, forced: FORCED, sham: !DESCRIPTORS }, {
                getOwnPropertyDescriptor: function getOwnPropertyDescriptor(it, key) {
                  return nativeGetOwnPropertyDescriptor(toIndexedObject(it), key);
                }
              });
            })
          ),
          /***/
          "e538": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var wellKnownSymbol = __webpack_require__("b622");
              exports$12.f = wellKnownSymbol;
            })
          ),
          /***/
          "e893": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var has = __webpack_require__("5135");
              var ownKeys2 = __webpack_require__("56ef");
              var getOwnPropertyDescriptorModule = __webpack_require__("06cf");
              var definePropertyModule = __webpack_require__("9bf2");
              module3.exports = function(target, source) {
                var keys2 = ownKeys2(source);
                var defineProperty = definePropertyModule.f;
                var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
                for (var i = 0; i < keys2.length; i++) {
                  var key = keys2[i];
                  if (!has(target, key)) defineProperty(target, key, getOwnPropertyDescriptor(source, key));
                }
              };
            })
          ),
          /***/
          "e8b5": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var classof = __webpack_require__("c6b6");
              module3.exports = Array.isArray || function isArray2(arg) {
                return classof(arg) == "Array";
              };
            })
          ),
          /***/
          "e95a": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var wellKnownSymbol = __webpack_require__("b622");
              var Iterators = __webpack_require__("3f8c");
              var ITERATOR = wellKnownSymbol("iterator");
              var ArrayPrototype = Array.prototype;
              module3.exports = function(it) {
                return it !== void 0 && (Iterators.Array === it || ArrayPrototype[ITERATOR] === it);
              };
            })
          ),
          /***/
          "f5df": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var TO_STRING_TAG_SUPPORT = __webpack_require__("00ee");
              var classofRaw = __webpack_require__("c6b6");
              var wellKnownSymbol = __webpack_require__("b622");
              var TO_STRING_TAG = wellKnownSymbol("toStringTag");
              var CORRECT_ARGUMENTS = classofRaw(/* @__PURE__ */ (function() {
                return arguments;
              })()) == "Arguments";
              var tryGet = function(it, key) {
                try {
                  return it[key];
                } catch (error) {
                }
              };
              module3.exports = TO_STRING_TAG_SUPPORT ? classofRaw : function(it) {
                var O, tag, result;
                return it === void 0 ? "Undefined" : it === null ? "Null" : typeof (tag = tryGet(O = Object(it), TO_STRING_TAG)) == "string" ? tag : CORRECT_ARGUMENTS ? classofRaw(O) : (result = classofRaw(O)) == "Object" && typeof O.callee == "function" ? "Arguments" : result;
              };
            })
          ),
          /***/
          "f772": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var shared = __webpack_require__("5692");
              var uid = __webpack_require__("90e3");
              var keys2 = shared("keys");
              module3.exports = function(key) {
                return keys2[key] || (keys2[key] = uid(key));
              };
            })
          ),
          /***/
          "fb15": (
            /***/
            (function(module3, __webpack_exports__, __webpack_require__) {
              __webpack_require__.r(__webpack_exports__);
              if (typeof window !== "undefined") {
                var currentScript = window.document.currentScript;
                {
                  var getCurrentScript = __webpack_require__("8875");
                  currentScript = getCurrentScript();
                  if (!("currentScript" in document)) {
                    Object.defineProperty(document, "currentScript", { get: getCurrentScript });
                  }
                }
                var src = currentScript && currentScript.src.match(/(.+\/)[^/]+\.js(\?.*)?$/);
                if (src) {
                  __webpack_require__.p = src[1];
                }
              }
              __webpack_require__("99af");
              __webpack_require__("4de4");
              __webpack_require__("4160");
              __webpack_require__("c975");
              __webpack_require__("d81d");
              __webpack_require__("a434");
              __webpack_require__("159b");
              __webpack_require__("a4d3");
              __webpack_require__("e439");
              __webpack_require__("dbb4");
              __webpack_require__("b64b");
              function _defineProperty2(obj, key, value) {
                if (key in obj) {
                  Object.defineProperty(obj, key, {
                    value,
                    enumerable: true,
                    configurable: true,
                    writable: true
                  });
                } else {
                  obj[key] = value;
                }
                return obj;
              }
              function ownKeys2(object, enumerableOnly) {
                var keys2 = Object.keys(object);
                if (Object.getOwnPropertySymbols) {
                  var symbols = Object.getOwnPropertySymbols(object);
                  if (enumerableOnly) symbols = symbols.filter(function(sym) {
                    return Object.getOwnPropertyDescriptor(object, sym).enumerable;
                  });
                  keys2.push.apply(keys2, symbols);
                }
                return keys2;
              }
              function _objectSpread22(target) {
                for (var i = 1; i < arguments.length; i++) {
                  var source = arguments[i] != null ? arguments[i] : {};
                  if (i % 2) {
                    ownKeys2(Object(source), true).forEach(function(key) {
                      _defineProperty2(target, key, source[key]);
                    });
                  } else if (Object.getOwnPropertyDescriptors) {
                    Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
                  } else {
                    ownKeys2(Object(source)).forEach(function(key) {
                      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
                    });
                  }
                }
                return target;
              }
              function _arrayWithHoles(arr) {
                if (Array.isArray(arr)) return arr;
              }
              __webpack_require__("e01a");
              __webpack_require__("d28b");
              __webpack_require__("e260");
              __webpack_require__("d3b7");
              __webpack_require__("3ca3");
              __webpack_require__("ddb0");
              function _iterableToArrayLimit(arr, i) {
                if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return;
                var _arr = [];
                var _n = true;
                var _d = false;
                var _e = void 0;
                try {
                  for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
                    _arr.push(_s.value);
                    if (i && _arr.length === i) break;
                  }
                } catch (err) {
                  _d = true;
                  _e = err;
                } finally {
                  try {
                    if (!_n && _i["return"] != null) _i["return"]();
                  } finally {
                    if (_d) throw _e;
                  }
                }
                return _arr;
              }
              __webpack_require__("a630");
              __webpack_require__("fb6a");
              __webpack_require__("b0c0");
              __webpack_require__("25f0");
              function _arrayLikeToArray2(arr, len) {
                if (len == null || len > arr.length) len = arr.length;
                for (var i = 0, arr2 = new Array(len); i < len; i++) {
                  arr2[i] = arr[i];
                }
                return arr2;
              }
              function _unsupportedIterableToArray2(o, minLen) {
                if (!o) return;
                if (typeof o === "string") return _arrayLikeToArray2(o, minLen);
                var n = Object.prototype.toString.call(o).slice(8, -1);
                if (n === "Object" && o.constructor) n = o.constructor.name;
                if (n === "Map" || n === "Set") return Array.from(o);
                if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray2(o, minLen);
              }
              function _nonIterableRest() {
                throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
              }
              function _slicedToArray(arr, i) {
                return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray2(arr, i) || _nonIterableRest();
              }
              function _arrayWithoutHoles2(arr) {
                if (Array.isArray(arr)) return _arrayLikeToArray2(arr);
              }
              function _iterableToArray2(iter) {
                if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter);
              }
              function _nonIterableSpread2() {
                throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
              }
              function _toConsumableArray2(arr) {
                return _arrayWithoutHoles2(arr) || _iterableToArray2(arr) || _unsupportedIterableToArray2(arr) || _nonIterableSpread2();
              }
              var external_commonjs_sortablejs_commonjs2_sortablejs_amd_sortablejs_root_Sortable_ = __webpack_require__("a352");
              var external_commonjs_sortablejs_commonjs2_sortablejs_amd_sortablejs_root_Sortable_default = /* @__PURE__ */ __webpack_require__.n(external_commonjs_sortablejs_commonjs2_sortablejs_amd_sortablejs_root_Sortable_);
              function removeNode(node) {
                if (node.parentElement !== null) {
                  node.parentElement.removeChild(node);
                }
              }
              function insertNodeAt(fatherNode, node, position) {
                var refNode = position === 0 ? fatherNode.children[0] : fatherNode.children[position - 1].nextSibling;
                fatherNode.insertBefore(node, refNode);
              }
              var console2 = __webpack_require__("dbf1");
              __webpack_require__("13d5");
              __webpack_require__("4fad");
              __webpack_require__("ac1f");
              __webpack_require__("5319");
              function cached(fn) {
                var cache = /* @__PURE__ */ Object.create(null);
                return function cachedFn(str) {
                  var hit = cache[str];
                  return hit || (cache[str] = fn(str));
                };
              }
              var regex = /-(\w)/g;
              var camelize2 = cached(function(str) {
                return str.replace(regex, function(_, c) {
                  return c.toUpperCase();
                });
              });
              __webpack_require__("5db7");
              __webpack_require__("73d9");
              var manageAndEmit = ["Start", "Add", "Remove", "Update", "End"];
              var emit = ["Choose", "Unchoose", "Sort", "Filter", "Clone"];
              var manage = ["Move"];
              var eventHandlerNames = [manage, manageAndEmit, emit].flatMap(function(events2) {
                return events2;
              }).map(function(evt) {
                return "on".concat(evt);
              });
              var events = {
                manage,
                manageAndEmit,
                emit
              };
              function isReadOnly(eventName) {
                return eventHandlerNames.indexOf(eventName) !== -1;
              }
              __webpack_require__("caad");
              __webpack_require__("2ca0");
              var tags = ["a", "abbr", "address", "area", "article", "aside", "audio", "b", "base", "bdi", "bdo", "blockquote", "body", "br", "button", "canvas", "caption", "cite", "code", "col", "colgroup", "data", "datalist", "dd", "del", "details", "dfn", "dialog", "div", "dl", "dt", "em", "embed", "fieldset", "figcaption", "figure", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "i", "iframe", "img", "input", "ins", "kbd", "label", "legend", "li", "link", "main", "map", "mark", "math", "menu", "menuitem", "meta", "meter", "nav", "noscript", "object", "ol", "optgroup", "option", "output", "p", "param", "picture", "pre", "progress", "q", "rb", "rp", "rt", "rtc", "ruby", "s", "samp", "script", "section", "select", "slot", "small", "source", "span", "strong", "style", "sub", "summary", "sup", "svg", "table", "tbody", "td", "template", "textarea", "tfoot", "th", "thead", "time", "title", "tr", "track", "u", "ul", "var", "video", "wbr"];
              function isHtmlTag(name2) {
                return tags.includes(name2);
              }
              function isTransition(name2) {
                return ["transition-group", "TransitionGroup"].includes(name2);
              }
              function isHtmlAttribute(value) {
                return ["id", "class", "role", "style"].includes(value) || value.startsWith("data-") || value.startsWith("aria-") || value.startsWith("on");
              }
              function project(entries) {
                return entries.reduce(function(res, _ref) {
                  var _ref2 = _slicedToArray(_ref, 2), key = _ref2[0], value = _ref2[1];
                  res[key] = value;
                  return res;
                }, {});
              }
              function getComponentAttributes(_ref3) {
                var $attrs = _ref3.$attrs, _ref3$componentData = _ref3.componentData, componentData = _ref3$componentData === void 0 ? {} : _ref3$componentData;
                var attributes = project(Object.entries($attrs).filter(function(_ref4) {
                  var _ref5 = _slicedToArray(_ref4, 2), key = _ref5[0];
                  _ref5[1];
                  return isHtmlAttribute(key);
                }));
                return _objectSpread22(_objectSpread22({}, attributes), componentData);
              }
              function createSortableOption(_ref6) {
                var $attrs = _ref6.$attrs, callBackBuilder = _ref6.callBackBuilder;
                var options2 = project(getValidSortableEntries($attrs));
                Object.entries(callBackBuilder).forEach(function(_ref7) {
                  var _ref8 = _slicedToArray(_ref7, 2), eventType = _ref8[0], eventBuilder = _ref8[1];
                  events[eventType].forEach(function(event) {
                    options2["on".concat(event)] = eventBuilder(event);
                  });
                });
                var draggable2 = "[data-draggable]".concat(options2.draggable || "");
                return _objectSpread22(_objectSpread22({}, options2), {}, {
                  draggable: draggable2
                });
              }
              function getValidSortableEntries(value) {
                return Object.entries(value).filter(function(_ref9) {
                  var _ref10 = _slicedToArray(_ref9, 2), key = _ref10[0];
                  _ref10[1];
                  return !isHtmlAttribute(key);
                }).map(function(_ref11) {
                  var _ref12 = _slicedToArray(_ref11, 2), key = _ref12[0], value2 = _ref12[1];
                  return [camelize2(key), value2];
                }).filter(function(_ref13) {
                  var _ref14 = _slicedToArray(_ref13, 2), key = _ref14[0];
                  _ref14[1];
                  return !isReadOnly(key);
                });
              }
              __webpack_require__("c740");
              function _classCallCheck(instance, Constructor) {
                if (!(instance instanceof Constructor)) {
                  throw new TypeError("Cannot call a class as a function");
                }
              }
              function _defineProperties(target, props2) {
                for (var i = 0; i < props2.length; i++) {
                  var descriptor = props2[i];
                  descriptor.enumerable = descriptor.enumerable || false;
                  descriptor.configurable = true;
                  if ("value" in descriptor) descriptor.writable = true;
                  Object.defineProperty(target, descriptor.key, descriptor);
                }
              }
              function _createClass(Constructor, protoProps, staticProps) {
                if (protoProps) _defineProperties(Constructor.prototype, protoProps);
                return Constructor;
              }
              var getHtmlElementFromNode = function getHtmlElementFromNode2(_ref) {
                var el = _ref.el;
                return el;
              };
              var addContext = function addContext2(domElement, context) {
                return domElement.__draggable_context = context;
              };
              var getContext = function getContext2(domElement) {
                return domElement.__draggable_context;
              };
              var componentStructure_ComponentStructure = /* @__PURE__ */ (function() {
                function ComponentStructure(_ref2) {
                  var _ref2$nodes = _ref2.nodes, header = _ref2$nodes.header, defaultNodes = _ref2$nodes.default, footer = _ref2$nodes.footer, root = _ref2.root, realList = _ref2.realList;
                  _classCallCheck(this, ComponentStructure);
                  this.defaultNodes = defaultNodes;
                  this.children = [].concat(_toConsumableArray2(header), _toConsumableArray2(defaultNodes), _toConsumableArray2(footer));
                  this.externalComponent = root.externalComponent;
                  this.rootTransition = root.transition;
                  this.tag = root.tag;
                  this.realList = realList;
                }
                _createClass(ComponentStructure, [{
                  key: "render",
                  value: function render(h2, attributes) {
                    var tag = this.tag, children = this.children, _isRootComponent = this._isRootComponent;
                    var option2 = !_isRootComponent ? children : {
                      default: function _default() {
                        return children;
                      }
                    };
                    return h2(tag, attributes, option2);
                  }
                }, {
                  key: "updated",
                  value: function updated() {
                    var defaultNodes = this.defaultNodes, realList = this.realList;
                    defaultNodes.forEach(function(node, index2) {
                      addContext(getHtmlElementFromNode(node), {
                        element: realList[index2],
                        index: index2
                      });
                    });
                  }
                }, {
                  key: "getUnderlyingVm",
                  value: function getUnderlyingVm(domElement) {
                    return getContext(domElement);
                  }
                }, {
                  key: "getVmIndexFromDomIndex",
                  value: function getVmIndexFromDomIndex(domIndex, element) {
                    var defaultNodes = this.defaultNodes;
                    var length = defaultNodes.length;
                    var domChildren = element.children;
                    var domElement = domChildren.item(domIndex);
                    if (domElement === null) {
                      return length;
                    }
                    var context = getContext(domElement);
                    if (context) {
                      return context.index;
                    }
                    if (length === 0) {
                      return 0;
                    }
                    var firstDomListElement = getHtmlElementFromNode(defaultNodes[0]);
                    var indexFirstDomListElement = _toConsumableArray2(domChildren).findIndex(function(element2) {
                      return element2 === firstDomListElement;
                    });
                    return domIndex < indexFirstDomListElement ? 0 : length;
                  }
                }, {
                  key: "_isRootComponent",
                  get: function get2() {
                    return this.externalComponent || this.rootTransition;
                  }
                }]);
                return ComponentStructure;
              })();
              var external_commonjs_vue_commonjs2_vue_root_Vue_ = __webpack_require__("8bbf");
              function getSlot(slots, key) {
                var slotValue = slots[key];
                return slotValue ? slotValue() : [];
              }
              function computeNodes(_ref) {
                var $slots = _ref.$slots, realList = _ref.realList, getKey = _ref.getKey;
                var normalizedList = realList || [];
                var _map = ["header", "footer"].map(function(name2) {
                  return getSlot($slots, name2);
                }), _map2 = _slicedToArray(_map, 2), header = _map2[0], footer = _map2[1];
                var item = $slots.item;
                if (!item) {
                  throw new Error("draggable element must have an item slot");
                }
                var defaultNodes = normalizedList.flatMap(function(element, index2) {
                  return item({
                    element,
                    index: index2
                  }).map(function(node) {
                    node.key = getKey(element);
                    node.props = _objectSpread22(_objectSpread22({}, node.props || {}), {}, {
                      "data-draggable": true
                    });
                    return node;
                  });
                });
                if (defaultNodes.length !== normalizedList.length) {
                  throw new Error("Item slot must have only one child");
                }
                return {
                  header,
                  footer,
                  default: defaultNodes
                };
              }
              function getRootInformation(tag) {
                var transition = isTransition(tag);
                var externalComponent = !isHtmlTag(tag) && !transition;
                return {
                  transition,
                  externalComponent,
                  tag: externalComponent ? Object(external_commonjs_vue_commonjs2_vue_root_Vue_["resolveComponent"])(tag) : transition ? external_commonjs_vue_commonjs2_vue_root_Vue_["TransitionGroup"] : tag
                };
              }
              function computeComponentStructure(_ref2) {
                var $slots = _ref2.$slots, tag = _ref2.tag, realList = _ref2.realList, getKey = _ref2.getKey;
                var nodes = computeNodes({
                  $slots,
                  realList,
                  getKey
                });
                var root = getRootInformation(tag);
                return new componentStructure_ComponentStructure({
                  nodes,
                  root,
                  realList
                });
              }
              function _emit(evtName, evtData) {
                var _this = this;
                Object(external_commonjs_vue_commonjs2_vue_root_Vue_["nextTick"])(function() {
                  return _this.$emit(evtName.toLowerCase(), evtData);
                });
              }
              function _manage(evtName) {
                var _this2 = this;
                return function(evtData, originalElement) {
                  if (_this2.realList !== null) {
                    return _this2["onDrag".concat(evtName)](evtData, originalElement);
                  }
                };
              }
              function _manageAndEmit(evtName) {
                var _this3 = this;
                var delegateCallBack = _manage.call(this, evtName);
                return function(evtData, originalElement) {
                  delegateCallBack.call(_this3, evtData, originalElement);
                  _emit.call(_this3, evtName, evtData);
                };
              }
              var draggingElement = null;
              var props = {
                list: {
                  type: Array,
                  required: false,
                  default: null
                },
                modelValue: {
                  type: Array,
                  required: false,
                  default: null
                },
                itemKey: {
                  type: [String, Function],
                  required: true
                },
                clone: {
                  type: Function,
                  default: function _default(original) {
                    return original;
                  }
                },
                tag: {
                  type: String,
                  default: "div"
                },
                move: {
                  type: Function,
                  default: null
                },
                componentData: {
                  type: Object,
                  required: false,
                  default: null
                }
              };
              var emits = ["update:modelValue", "change"].concat(_toConsumableArray2([].concat(_toConsumableArray2(events.manageAndEmit), _toConsumableArray2(events.emit)).map(function(evt) {
                return evt.toLowerCase();
              })));
              var draggableComponent = Object(external_commonjs_vue_commonjs2_vue_root_Vue_["defineComponent"])({
                name: "draggable",
                inheritAttrs: false,
                props,
                emits,
                data: function data() {
                  return {
                    error: false
                  };
                },
                render: function render() {
                  try {
                    this.error = false;
                    var $slots = this.$slots, $attrs = this.$attrs, tag = this.tag, componentData = this.componentData, realList = this.realList, getKey = this.getKey;
                    var componentStructure = computeComponentStructure({
                      $slots,
                      tag,
                      realList,
                      getKey
                    });
                    this.componentStructure = componentStructure;
                    var attributes = getComponentAttributes({
                      $attrs,
                      componentData
                    });
                    return componentStructure.render(external_commonjs_vue_commonjs2_vue_root_Vue_["h"], attributes);
                  } catch (err) {
                    this.error = true;
                    return Object(external_commonjs_vue_commonjs2_vue_root_Vue_["h"])("pre", {
                      style: {
                        color: "red"
                      }
                    }, err.stack);
                  }
                },
                created: function created() {
                  if (this.list !== null && this.modelValue !== null) {
                    console2[
                      "a"
                      /* console */
                    ].error("modelValue and list props are mutually exclusive! Please set one or another.");
                  }
                },
                mounted: function mounted() {
                  var _this4 = this;
                  if (this.error) {
                    return;
                  }
                  var $attrs = this.$attrs, $el = this.$el, componentStructure = this.componentStructure;
                  componentStructure.updated();
                  var sortableOptions = createSortableOption({
                    $attrs,
                    callBackBuilder: {
                      manageAndEmit: function manageAndEmit2(event) {
                        return _manageAndEmit.call(_this4, event);
                      },
                      emit: function emit2(event) {
                        return _emit.bind(_this4, event);
                      },
                      manage: function manage2(event) {
                        return _manage.call(_this4, event);
                      }
                    }
                  });
                  var targetDomElement = $el.nodeType === 1 ? $el : $el.parentElement;
                  this._sortable = new external_commonjs_sortablejs_commonjs2_sortablejs_amd_sortablejs_root_Sortable_default.a(targetDomElement, sortableOptions);
                  this.targetDomElement = targetDomElement;
                  targetDomElement.__draggable_component__ = this;
                },
                updated: function updated() {
                  this.componentStructure.updated();
                },
                beforeUnmount: function beforeUnmount() {
                  if (this._sortable !== void 0) this._sortable.destroy();
                },
                computed: {
                  realList: function realList() {
                    var list = this.list;
                    return list ? list : this.modelValue;
                  },
                  getKey: function getKey() {
                    var itemKey = this.itemKey;
                    if (typeof itemKey === "function") {
                      return itemKey;
                    }
                    return function(element) {
                      return element[itemKey];
                    };
                  }
                },
                watch: {
                  $attrs: {
                    handler: function handler(newOptionValue) {
                      var _sortable = this._sortable;
                      if (!_sortable) return;
                      getValidSortableEntries(newOptionValue).forEach(function(_ref) {
                        var _ref2 = _slicedToArray(_ref, 2), key = _ref2[0], value = _ref2[1];
                        _sortable.option(key, value);
                      });
                    },
                    deep: true
                  }
                },
                methods: {
                  getUnderlyingVm: function getUnderlyingVm(domElement) {
                    return this.componentStructure.getUnderlyingVm(domElement) || null;
                  },
                  getUnderlyingPotencialDraggableComponent: function getUnderlyingPotencialDraggableComponent(htmElement) {
                    return htmElement.__draggable_component__;
                  },
                  emitChanges: function emitChanges(evt) {
                    var _this5 = this;
                    Object(external_commonjs_vue_commonjs2_vue_root_Vue_["nextTick"])(function() {
                      return _this5.$emit("change", evt);
                    });
                  },
                  alterList: function alterList(onList) {
                    if (this.list) {
                      onList(this.list);
                      return;
                    }
                    var newList = _toConsumableArray2(this.modelValue);
                    onList(newList);
                    this.$emit("update:modelValue", newList);
                  },
                  spliceList: function spliceList() {
                    var _arguments = arguments;
                    var spliceList2 = function spliceList3(list) {
                      return list.splice.apply(list, _toConsumableArray2(_arguments));
                    };
                    this.alterList(spliceList2);
                  },
                  updatePosition: function updatePosition(oldIndex2, newIndex2) {
                    var updatePosition2 = function updatePosition3(list) {
                      return list.splice(newIndex2, 0, list.splice(oldIndex2, 1)[0]);
                    };
                    this.alterList(updatePosition2);
                  },
                  getRelatedContextFromMoveEvent: function getRelatedContextFromMoveEvent(_ref3) {
                    var to2 = _ref3.to, related = _ref3.related;
                    var component = this.getUnderlyingPotencialDraggableComponent(to2);
                    if (!component) {
                      return {
                        component
                      };
                    }
                    var list = component.realList;
                    var context = {
                      list,
                      component
                    };
                    if (to2 !== related && list) {
                      var destination = component.getUnderlyingVm(related) || {};
                      return _objectSpread22(_objectSpread22({}, destination), context);
                    }
                    return context;
                  },
                  getVmIndexFromDomIndex: function getVmIndexFromDomIndex(domIndex) {
                    return this.componentStructure.getVmIndexFromDomIndex(domIndex, this.targetDomElement);
                  },
                  onDragStart: function onDragStart(evt) {
                    this.context = this.getUnderlyingVm(evt.item);
                    evt.item._underlying_vm_ = this.clone(this.context.element);
                    draggingElement = evt.item;
                  },
                  onDragAdd: function onDragAdd(evt) {
                    var element = evt.item._underlying_vm_;
                    if (element === void 0) {
                      return;
                    }
                    removeNode(evt.item);
                    var newIndex2 = this.getVmIndexFromDomIndex(evt.newIndex);
                    this.spliceList(newIndex2, 0, element);
                    var added = {
                      element,
                      newIndex: newIndex2
                    };
                    this.emitChanges({
                      added
                    });
                  },
                  onDragRemove: function onDragRemove(evt) {
                    insertNodeAt(this.$el, evt.item, evt.oldIndex);
                    if (evt.pullMode === "clone") {
                      removeNode(evt.clone);
                      return;
                    }
                    var _this$context = this.context, oldIndex2 = _this$context.index, element = _this$context.element;
                    this.spliceList(oldIndex2, 1);
                    var removed = {
                      element,
                      oldIndex: oldIndex2
                    };
                    this.emitChanges({
                      removed
                    });
                  },
                  onDragUpdate: function onDragUpdate(evt) {
                    removeNode(evt.item);
                    insertNodeAt(evt.from, evt.item, evt.oldIndex);
                    var oldIndex2 = this.context.index;
                    var newIndex2 = this.getVmIndexFromDomIndex(evt.newIndex);
                    this.updatePosition(oldIndex2, newIndex2);
                    var moved2 = {
                      element: this.context.element,
                      oldIndex: oldIndex2,
                      newIndex: newIndex2
                    };
                    this.emitChanges({
                      moved: moved2
                    });
                  },
                  computeFutureIndex: function computeFutureIndex(relatedContext, evt) {
                    if (!relatedContext.element) {
                      return 0;
                    }
                    var domChildren = _toConsumableArray2(evt.to.children).filter(function(el) {
                      return el.style["display"] !== "none";
                    });
                    var currentDomIndex = domChildren.indexOf(evt.related);
                    var currentIndex = relatedContext.component.getVmIndexFromDomIndex(currentDomIndex);
                    var draggedInList = domChildren.indexOf(draggingElement) !== -1;
                    return draggedInList || !evt.willInsertAfter ? currentIndex : currentIndex + 1;
                  },
                  onDragMove: function onDragMove(evt, originalEvent) {
                    var move = this.move, realList = this.realList;
                    if (!move || !realList) {
                      return true;
                    }
                    var relatedContext = this.getRelatedContextFromMoveEvent(evt);
                    var futureIndex = this.computeFutureIndex(relatedContext, evt);
                    var draggedContext = _objectSpread22(_objectSpread22({}, this.context), {}, {
                      futureIndex
                    });
                    var sendEvent = _objectSpread22(_objectSpread22({}, evt), {}, {
                      relatedContext,
                      draggedContext
                    });
                    return move(sendEvent, originalEvent);
                  },
                  onDragEnd: function onDragEnd() {
                    draggingElement = null;
                  }
                }
              });
              var vuedraggable = draggableComponent;
              __webpack_exports__["default"] = vuedraggable;
            })
          ),
          /***/
          "fb6a": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var $ = __webpack_require__("23e7");
              var isObject2 = __webpack_require__("861d");
              var isArray2 = __webpack_require__("e8b5");
              var toAbsoluteIndex = __webpack_require__("23cb");
              var toLength = __webpack_require__("50c4");
              var toIndexedObject = __webpack_require__("fc6a");
              var createProperty = __webpack_require__("8418");
              var wellKnownSymbol = __webpack_require__("b622");
              var arrayMethodHasSpeciesSupport = __webpack_require__("1dde");
              var arrayMethodUsesToLength = __webpack_require__("ae40");
              var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport("slice");
              var USES_TO_LENGTH = arrayMethodUsesToLength("slice", { ACCESSORS: true, 0: 0, 1: 2 });
              var SPECIES = wellKnownSymbol("species");
              var nativeSlice = [].slice;
              var max2 = Math.max;
              $({ target: "Array", proto: true, forced: !HAS_SPECIES_SUPPORT || !USES_TO_LENGTH }, {
                slice: function slice(start, end) {
                  var O = toIndexedObject(this);
                  var length = toLength(O.length);
                  var k = toAbsoluteIndex(start, length);
                  var fin = toAbsoluteIndex(end === void 0 ? length : end, length);
                  var Constructor, result, n;
                  if (isArray2(O)) {
                    Constructor = O.constructor;
                    if (typeof Constructor == "function" && (Constructor === Array || isArray2(Constructor.prototype))) {
                      Constructor = void 0;
                    } else if (isObject2(Constructor)) {
                      Constructor = Constructor[SPECIES];
                      if (Constructor === null) Constructor = void 0;
                    }
                    if (Constructor === Array || Constructor === void 0) {
                      return nativeSlice.call(O, k, fin);
                    }
                  }
                  result = new (Constructor === void 0 ? Array : Constructor)(max2(fin - k, 0));
                  for (n = 0; k < fin; k++, n++) if (k in O) createProperty(result, n, O[k]);
                  result.length = n;
                  return result;
                }
              });
            })
          ),
          /***/
          "fc6a": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var IndexedObject = __webpack_require__("44ad");
              var requireObjectCoercible = __webpack_require__("1d80");
              module3.exports = function(it) {
                return IndexedObject(requireObjectCoercible(it));
              };
            })
          ),
          /***/
          "fdbc": (
            /***/
            (function(module3, exports$12) {
              module3.exports = {
                CSSRuleList: 0,
                CSSStyleDeclaration: 0,
                CSSValueList: 0,
                ClientRectList: 0,
                DOMRectList: 0,
                DOMStringList: 0,
                DOMTokenList: 1,
                DataTransferItemList: 0,
                FileList: 0,
                HTMLAllCollection: 0,
                HTMLCollection: 0,
                HTMLFormElement: 0,
                HTMLSelectElement: 0,
                MediaList: 0,
                MimeTypeArray: 0,
                NamedNodeMap: 0,
                NodeList: 1,
                PaintRequestList: 0,
                Plugin: 0,
                PluginArray: 0,
                SVGLengthList: 0,
                SVGNumberList: 0,
                SVGPathSegList: 0,
                SVGPointList: 0,
                SVGStringList: 0,
                SVGTransformList: 0,
                SourceBufferList: 0,
                StyleSheetList: 0,
                TextTrackCueList: 0,
                TextTrackList: 0,
                TouchList: 0
              };
            })
          ),
          /***/
          "fdbf": (
            /***/
            (function(module3, exports$12, __webpack_require__) {
              var NATIVE_SYMBOL = __webpack_require__("4930");
              module3.exports = NATIVE_SYMBOL && !Symbol.sham && typeof Symbol.iterator == "symbol";
            })
          )
          /******/
        })["default"]
      );
    });
  })(vuedraggable_umd$1);
  return vuedraggable_umd$1.exports;
}
var vuedraggable_umdExports = requireVuedraggable_umd();
const draggable = /* @__PURE__ */ getDefaultExportFromCjs(vuedraggable_umdExports);
const _hoisted_1$i = ["aria-expanded"];
const _sfc_main$n = {
  __name: "ViewDropdown",
  props: {
    viewId: {
      type: [String, Number],
      required: true
    },
    viewName: {
      type: String,
      required: true
    }
  },
  emits: ["rename", "delete", "edit"],
  setup(__props, { emit: __emit }) {
    const router = useRouter();
    const { hasAccess, openUpsellModal } = useFeatureGate("custom-dashboard");
    const props = __props;
    const emit = __emit;
    const isOpen = ref(false);
    const dropdown = ref(null);
    const menuPosition = reactive({ top: 0, left: 0 });
    const menuStyle = computed(() => ({
      position: "fixed",
      top: `${menuPosition.top}px`,
      left: `${menuPosition.left}px`,
      width: "145px",
      zIndex: 99999
    }));
    function adjustDropdownPosition() {
      if (!dropdown.value) return;
      const trigger = dropdown.value.querySelector(".exactmetrics-view-dropdown__trigger");
      if (!trigger) return;
      const rect = trigger.getBoundingClientRect();
      const menuWidth = 160;
      const viewportPadding = 8;
      let left = rect.right - menuWidth;
      const top = rect.bottom + 4;
      if (left < viewportPadding) {
        left = rect.left;
      }
      if (left + menuWidth > window.innerWidth - viewportPadding) {
        left = window.innerWidth - menuWidth - viewportPadding;
      }
      menuPosition.top = top;
      menuPosition.left = left;
    }
    function toggleDropdown() {
      isOpen.value = !isOpen.value;
      if (isOpen.value) {
        nextTick(() => adjustDropdownPosition());
      }
    }
    function handleResize() {
      if (isOpen.value) {
        adjustDropdownPosition();
      }
    }
    function handleScroll() {
      if (isOpen.value) {
        isOpen.value = false;
      }
    }
    watch(isOpen, (newValue) => {
      if (newValue) {
        nextTick(() => adjustDropdownPosition());
      }
    });
    function handleView() {
      isOpen.value = false;
      router.push({ name: "dashboard-view", params: { id: props.viewId } });
    }
    function handleEdit() {
      isOpen.value = false;
      if (!hasAccess.value) {
        openUpsellModal();
        return;
      }
      emit("edit", props.viewId);
    }
    function handleRename() {
      isOpen.value = false;
      if (!hasAccess.value) {
        openUpsellModal();
        return;
      }
      emit("rename", props.viewId);
    }
    function handleDelete() {
      isOpen.value = false;
      if (!hasAccess.value) {
        openUpsellModal();
        return;
      }
      emit("delete", props.viewId);
    }
    function handleClickOutside(event) {
      if (!dropdown.value) return;
      const menu = document.querySelector(".exactmetrics-view-dropdown__menu");
      const clickedInMenu = menu && menu.contains(event.target);
      const clickedInDropdown = dropdown.value.contains(event.target);
      if (!clickedInDropdown && !clickedInMenu) {
        isOpen.value = false;
      }
    }
    onMounted(() => {
      document.addEventListener("click", handleClickOutside);
      window.addEventListener("resize", handleResize);
      window.addEventListener("scroll", handleScroll, true);
    });
    onUnmounted(() => {
      document.removeEventListener("click", handleClickOutside);
      window.removeEventListener("resize", handleResize);
      window.removeEventListener("scroll", handleScroll, true);
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: "exactmetrics-view-dropdown",
        ref_key: "dropdown",
        ref: dropdown
      }, [
        createBaseVNode("button", {
          class: "exactmetrics-view-dropdown__trigger",
          onClick: toggleDropdown,
          "aria-expanded": isOpen.value,
          "aria-haspopup": "true"
        }, [
          createVNode(Icon, {
            name: "dots-vertical",
            size: 16
          })
        ], 8, _hoisted_1$i),
        (openBlock(), createBlock(Teleport, { to: "body" }, [
          createVNode(Transition, { name: "dropdown" }, {
            default: withCtx(() => [
              isOpen.value ? (openBlock(), createElementBlock("div", {
                key: 0,
                class: "exactmetrics-view-dropdown__menu",
                style: normalizeStyle(menuStyle.value)
              }, [
                createBaseVNode("button", {
                  class: "exactmetrics-view-dropdown__item",
                  onClick: handleView
                }, [
                  createVNode(Icon, {
                    name: "dashicons-visibility",
                    size: 16
                  }),
                  createBaseVNode("span", null, toDisplayString(unref(__)("View", "google-analytics-dashboard-for-wp")), 1)
                ]),
                createBaseVNode("button", {
                  class: "exactmetrics-view-dropdown__item",
                  onClick: handleEdit
                }, [
                  createVNode(Icon, {
                    name: "dashicons-edit",
                    size: 16
                  }),
                  createBaseVNode("span", null, toDisplayString(unref(__)("Edit", "google-analytics-dashboard-for-wp")), 1)
                ]),
                createBaseVNode("button", {
                  class: "exactmetrics-view-dropdown__item",
                  onClick: handleRename
                }, [
                  createVNode(Icon, {
                    name: "dashicons-edit",
                    size: 16
                  }),
                  createBaseVNode("span", null, toDisplayString(unref(__)("Rename", "google-analytics-dashboard-for-wp")), 1)
                ]),
                createBaseVNode("button", {
                  class: "exactmetrics-view-dropdown__item exactmetrics-view-dropdown__item--danger",
                  onClick: handleDelete
                }, [
                  createVNode(Icon, {
                    name: "dashicons-trash",
                    size: 16
                  }),
                  createBaseVNode("span", null, toDisplayString(unref(__)("Delete", "google-analytics-dashboard-for-wp")), 1)
                ])
              ], 4)) : createCommentVNode("", true)
            ]),
            _: 1
          })
        ]))
      ], 512);
    };
  }
};
const _sfc_main$m = {
  __name: "ViewTab",
  props: {
    viewId: {
      type: [String, Number],
      required: true
    },
    viewName: {
      type: String,
      required: true
    },
    isActive: {
      type: Boolean,
      default: false
    }
  },
  emits: ["select", "rename", "delete", "edit"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const isEditing = ref(false);
    const editingName = ref("");
    const editInput = ref(null);
    async function handleRename() {
      isEditing.value = true;
      editingName.value = props.viewName;
      await nextTick();
      if (editInput.value) {
        editInput.value.focus();
        editInput.value.select();
      }
    }
    function handleEdit() {
      emit("edit", props.viewId);
    }
    function handleSave() {
      const trimmedName = editingName.value.trim();
      if (trimmedName && trimmedName !== props.viewName) {
        emit("rename", { id: props.viewId, name: trimmedName });
      }
      isEditing.value = false;
    }
    function handleCancel() {
      isEditing.value = false;
      editingName.value = "";
    }
    function handleDelete() {
      emit("delete", props.viewId);
    }
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(["exactmetrics-view-tab", {
          "exactmetrics-view-tab--active": __props.isActive,
          "exactmetrics-view-tab--editing": isEditing.value
        }])
      }, [
        !isEditing.value ? (openBlock(), createElementBlock("button", {
          key: 0,
          class: "exactmetrics-view-tab__button",
          onClick: _cache[0] || (_cache[0] = ($event) => _ctx.$emit("select", __props.viewId))
        }, toDisplayString(__props.viewName), 1)) : withDirectives((openBlock(), createElementBlock("input", {
          key: 1,
          ref_key: "editInput",
          ref: editInput,
          "onUpdate:modelValue": _cache[1] || (_cache[1] = ($event) => editingName.value = $event),
          class: "exactmetrics-view-tab__input",
          type: "text",
          onBlur: handleSave,
          onKeyup: [
            withKeys(handleSave, ["enter"]),
            withKeys(handleCancel, ["esc"])
          ]
        }, null, 544)), [
          [vModelText, editingName.value]
        ]),
        !isEditing.value ? (openBlock(), createBlock(_sfc_main$n, {
          key: 2,
          "view-id": __props.viewId,
          "view-name": __props.viewName,
          onRename: handleRename,
          onDelete: handleDelete,
          onEdit: handleEdit
        }, null, 8, ["view-id", "view-name"])) : createCommentVNode("", true)
      ], 2);
    };
  }
};
function ajaxRequest(action, data = {}) {
  return new Promise((resolve, reject) => {
    const nonce = getMiGlobal("nonce");
    if (!window.wp || !window.wp.ajax) {
      reject(new Error("WordPress AJAX is not available"));
      return;
    }
    const requestData = {
      ...data,
      nonce
    };
    wp.ajax.post(action, requestData).done((response) => {
      resolve({ data: response });
    }).fail((error) => {
      reject(error);
    });
  });
}
const customDashboardAPI = {
  /**
   * Get all custom views for the current user
   * @returns {Promise<Array>} Array of custom view objects
   */
  async getCustomViews() {
    try {
      const response = await ajaxRequest("exactmetrics_get_custom_views", {});
      return response.data || [];
    } catch (error) {
      console.error("Error fetching custom views:", error);
      throw error;
    }
  },
  /**
   * Save a custom view (create or update)
   * @param {Object} viewData - The view data
   * @param {number} viewData.view_id - View ID (0 for new view)
   * @param {string} viewData.title - View title
   * @param {Array} viewData.layout - Widget layout configuration
   * @returns {Promise<Object>} Response with view_id and message
   */
  async saveCustomView(viewData) {
    try {
      const response = await ajaxRequest("exactmetrics_save_custom_view", {
        view_id: viewData.view_id || 0,
        title: viewData.title || "My Custom View",
        layout: JSON.stringify(viewData.layout || [])
      });
      return response.data;
    } catch (error) {
      console.error("Error saving custom view:", error);
      throw error;
    }
  },
  /**
   * Delete a custom view
   * @param {number} viewId - The view ID to delete
   * @returns {Promise<Object>} Response with success message
   */
  async deleteCustomView(viewId) {
    try {
      const response = await ajaxRequest("exactmetrics_delete_custom_view", {
        view_id: viewId
      });
      return response.data;
    } catch (error) {
      console.error("Error deleting custom view:", error);
      throw error;
    }
  },
  /**
   * Get widget metadata for available widgets
   * @returns {Promise<Object>} Object with widget metadata keyed by widget type
   */
  async getWidgetMetadata() {
    try {
      const response = await ajaxRequest(
        "exactmetrics_get_custom_view_metadata",
        {}
      );
      return response.data || {};
    } catch (error) {
      console.error("Error fetching widget metadata:", error);
      throw error;
    }
  },
  /**
   * Get dashboard data for specified widgets.
   *
   * Currently uses WordPress as a proxy to the Relay API.
   * A future enhancement will use direct browser-to-Relay communication
   * with the Bearer token for better performance.
   *
   * @param {Array} widgets - Array of widget configurations
   * @param {Object} dateRange - Date range with start and end dates
   * @returns {Promise<Object>} Dashboard data with widget results
   */
  async getDashboardData(widgets, dateRange) {
    try {
      const response = await ajaxRequest(
        "exactmetrics_get_custom_dashboard_data",
        {
          widgets: JSON.stringify(widgets),
          date_range: JSON.stringify(dateRange)
        }
      );
      return response.data;
    } catch (error) {
      console.error("Error fetching dashboard data:", error);
      throw error;
    }
  },
  /**
   * Update the order of views (drag-and-drop reordering)
   * @param {Array} viewOrders - Array of {id, order} objects
   * @returns {Promise<Object>} Response with success message
   */
  async updateViewsOrder(viewOrders) {
    try {
      const response = await ajaxRequest("exactmetrics_update_views_order", {
        view_orders: JSON.stringify(viewOrders)
      });
      return response.data;
    } catch (error) {
      console.error("Error updating view order:", error);
      throw error;
    }
  }
};
const useCustomViewsStore = defineStore("customViews", {
  state: () => ({
    // Views data
    views: [],
    currentView: null,
    // Widget metadata
    widgetMetadata: {},
    // Dashboard data
    dashboardData: {},
    // UI state
    loading: false,
    saving: false,
    error: null,
    // Date range
    dateRange: {
      start: "",
      end: ""
    }
  }),
  getters: {
    /**
     * Check if loading is in progress
     */
    isLoading: (state) => state.loading,
    /**
     * Get all views sorted by menu_order
     */
    allViews: (state) => {
      return [...state.views].sort((a, b) => {
        if (a.menu_order !== b.menu_order) {
          return a.menu_order - b.menu_order;
        }
        return b.id - a.id;
      });
    },
    /**
     * Get view by ID
     */
    getViewById: (state) => {
      return (id) => state.views.find((view) => view.id === parseInt(id, 10));
    },
    /**
     * Check if currently editing
     */
    isEditing: (state) => {
      return state.currentView && state.currentView.id > 0;
    },
    /**
     * Get widgets for current view
     */
    currentViewWidgets: (state) => {
      return state.currentView?.layout || [];
    },
    /**
     * Get widget metadata by type
     */
    getWidgetByType: (state) => {
      return (type) => state.widgetMetadata[type] || null;
    }
  },
  actions: {
    /**
     * Set loading state
     * @param {boolean} isLoading - Whether loading is in progress
     */
    setLoading(isLoading) {
      this.loading = isLoading;
    },
    /**
     * Load all custom views
     * Note: This method does NOT manage loading state - the calling component
     * should use setLoading() to control when loading starts/ends.
     */
    async loadViews() {
      this.error = null;
      try {
        const views = await customDashboardAPI.getCustomViews();
        this.views = views;
        return views;
      } catch (error) {
        this.error = {
          title: __("Error Loading Views", "google-analytics-dashboard-for-wp"),
          message: error.message || __("Failed to load custom views", "google-analytics-dashboard-for-wp")
        };
        throw error;
      }
    },
    /**
     * Load widget metadata
     */
    async loadWidgetMetadata() {
      try {
        const metadata = await customDashboardAPI.getWidgetMetadata();
        this.widgetMetadata = metadata;
        return metadata;
      } catch (error) {
        console.error("Failed to load widget metadata:", error);
        throw error;
      }
    },
    /**
     * Create a new view
     */
    createNewView(title = "") {
      this.currentView = {
        id: 0,
        title: title || __("New View", "google-analytics-dashboard-for-wp"),
        layout: []
      };
    },
    /**
     * Create a new view from a template
     * @param {Object} template - Template object with layout
     * @returns {Promise<Object>} The created view
     */
    async createViewFromTemplate(template) {
      if (!template) {
        throw new Error(
          __("No template provided", "google-analytics-dashboard-for-wp")
        );
      }
      if (Object.keys(this.widgetMetadata).length === 0) {
        await this.loadWidgetMetadata();
      }
      const title = template.newNavName || template.title || __("My New View", "google-analytics-dashboard-for-wp");
      this.currentView = {
        id: 0,
        title,
        layout: []
      };
      if (!template.layout || template.layout.length === 0) {
        await this.saveCurrentView();
        return this.currentView;
      }
      const layout = [];
      template.layout.forEach((widgetConfig, index2) => {
        const widgetMeta = this.widgetMetadata[widgetConfig.type];
        if (!widgetMeta) {
          console.warn(`Widget type ${widgetConfig.type} not found in metadata`);
          return;
        }
        const widgetId = `${widgetConfig.type}-${Date.now()}-${index2}`;
        const defaults2 = { ...widgetMeta.defaults };
        if (defaults2.type) {
          defaults2.displayType = defaults2.type;
          delete defaults2.type;
        }
        const widget = {
          id: widgetId,
          type: widgetConfig.type,
          title: widgetMeta.title || widgetMeta.name,
          ...defaults2,
          // Apply widget defaults
          position: {
            x: index2 % 3,
            // 3-column grid
            y: Math.floor(index2 / 3),
            w: widgetConfig.width || 1
          }
        };
        if (widgetConfig.displayType) {
          widget.displayType = widgetConfig.displayType;
        }
        layout.push(widget);
      });
      this.currentView.layout = layout;
      await this.saveCurrentView();
      return this.currentView;
    },
    /**
     * Load view for viewing (read-only mode)
     */
    async loadViewForViewing(viewId) {
      const view = this.getViewById(viewId);
      if (view) {
        this.currentView = { ...view };
      } else {
        await this.loadViews();
        const freshView = this.getViewById(viewId);
        if (freshView) {
          this.currentView = { ...freshView };
        } else {
          throw new Error(__("View not found", "google-analytics-dashboard-for-wp"));
        }
      }
    },
    /**
     * Load view for editing
     */
    async loadViewForEdit(viewId) {
      const view = this.getViewById(viewId);
      if (view) {
        this.currentView = { ...view };
      } else {
        await this.loadViews();
        const freshView = this.getViewById(viewId);
        if (freshView) {
          this.currentView = { ...freshView };
        } else {
          throw new Error(__("View not found", "google-analytics-dashboard-for-wp"));
        }
      }
      await this.refreshWidgetConfigs();
    },
    /**
     * Refresh widget configurations with latest backend metadata
     * This ensures widgets always use current backend defaults while preserving user choices
     */
    async refreshWidgetConfigs() {
      if (!this.currentView || !this.currentView.layout) {
        return;
      }
      if (Object.keys(this.widgetMetadata).length === 0) {
        await this.loadWidgetMetadata();
      }
      this.currentView.layout = this.currentView.layout.map((widget) => {
        const widgetMeta = this.widgetMetadata[widget.type];
        if (!widgetMeta) {
          return widget;
        }
        const refreshedDefaults = widgetMeta.defaults || {};
        const userChoices = {};
        if (widget.displayType && widget.displayType !== refreshedDefaults.type) {
          userChoices.displayType = widget.displayType;
        }
        if (widget.metrics && widget.metrics.length > 0) {
          const displayType = widget.displayType || refreshedDefaults.type || "infobox";
          const typeSupport = getWidgetSupportForType(
            widgetMeta.support,
            displayType
          );
          const supportedMetrics = typeSupport.metrics || [];
          const validUserMetrics = widget.metrics.filter(
            (m2) => supportedMetrics.includes(m2)
          );
          if (validUserMetrics.length > 0) {
            userChoices.metrics = validUserMetrics;
          }
        }
        const refreshedWidget = {
          ...refreshedDefaults,
          // Fresh defaults from backend
          ...userChoices,
          // User's valid choices
          id: widget.id,
          // Always keep ID
          type: widget.type,
          // Always keep type
          title: widget.title || widgetMeta.title,
          // Keep custom title or use widget default title
          position: widget.position
          // Always keep position
        };
        return refreshedWidget;
      });
    },
    /**
     * Save current view
     */
    async saveCurrentView() {
      if (!this.currentView) {
        throw new Error(__("No view to save", "google-analytics-dashboard-for-wp"));
      }
      this.saving = true;
      this.error = null;
      try {
        const result = await customDashboardAPI.saveCustomView({
          view_id: this.currentView.id,
          title: this.currentView.title,
          layout: this.currentView.layout
        });
        if (result.view_id) {
          this.currentView.id = result.view_id;
        }
        await this.loadViews();
        return result;
      } catch (error) {
        this.error = {
          title: __("Error Saving View", "google-analytics-dashboard-for-wp"),
          message: error.message || __("Failed to save custom view", "google-analytics-dashboard-for-wp")
        };
        throw error;
      } finally {
        this.saving = false;
      }
    },
    /**
     * Delete a view
     */
    async deleteView(viewId) {
      try {
        const result = await customDashboardAPI.deleteCustomView(viewId);
        this.views = this.views.filter((view) => view.id !== viewId);
        if (this.currentView?.id === viewId) {
          this.currentView = null;
        }
        return result;
      } catch (error) {
        this.error = {
          title: __("Error Deleting View", "google-analytics-dashboard-for-wp"),
          message: error.message || __("Failed to delete custom view", "google-analytics-dashboard-for-wp")
        };
        throw error;
      }
    },
    /**
     * Add widget to current view
     */
    addWidget(widget, position = null) {
      if (!this.currentView) {
        return;
      }
      const newWidget = {
        id: `${widget.type}-${Date.now()}`,
        type: widget.type,
        ...widget.defaults,
        position: position || { x: 0, y: 0, w: 1, h: 1 }
      };
      this.currentView.layout.push(newWidget);
    },
    /**
     * Remove widget from current view
     */
    removeWidget(widgetId) {
      if (!this.currentView) {
        return;
      }
      this.currentView.layout = this.currentView.layout.filter(
        (widget) => widget.id !== widgetId
      );
    },
    /**
     * Update widget configuration
     */
    updateWidget(widgetId, updates) {
      if (!this.currentView) {
        return;
      }
      const index2 = this.currentView.layout.findIndex(
        (widget) => widget.id === widgetId
      );
      if (index2 !== -1) {
        this.currentView.layout[index2] = {
          ...this.currentView.layout[index2],
          ...updates
        };
      }
    },
    /**
     * Update widget positions (for drag and drop)
     */
    updateWidgetPositions(positions) {
      if (!this.currentView) {
        return;
      }
      positions.forEach(({ id, position }) => {
        const widget = this.currentView.layout.find((w) => w.id === id);
        if (widget) {
          widget.position = position;
        }
      });
    },
    /**
     * Load dashboard data for widgets
     */
    async loadDashboardData(widgets = null, dateRange = null) {
      const widgetsToLoad = widgets || this.currentViewWidgets;
      const range = dateRange || this.dateRange;
      if (!widgetsToLoad.length) {
        return;
      }
      this.loading = true;
      try {
        const data = await customDashboardAPI.getDashboardData(
          widgetsToLoad,
          range
        );
        this.dashboardData = data.widgets || {};
        if (data.date_range) {
          this.dateRange = data.date_range;
        }
        return data;
      } catch (error) {
        this.error = {
          title: __("Error Loading Data", "google-analytics-dashboard-for-wp"),
          message: error.message || __("Failed to load dashboard data", "google-analytics-dashboard-for-wp")
        };
        throw error;
      } finally {
        this.loading = false;
      }
    },
    /**
     * Set date range
     */
    setDateRange(start, end) {
      this.dateRange = { start, end };
    },
    /**
     * Update views order after drag-and-drop
     * @param {Array} viewOrders - Array of {id, order} objects
     */
    async updateViewsOrder(viewOrders) {
      try {
        await customDashboardAPI.updateViewsOrder(viewOrders);
        viewOrders.forEach(({ id, order }) => {
          const view = this.views.find((v) => v.id === id);
          if (view) {
            view.menu_order = order;
          }
        });
        return true;
      } catch (error) {
        this.error = {
          title: __("Error Updating Order", "google-analytics-dashboard-for-wp"),
          message: error.message || __("Failed to update view order", "google-analytics-dashboard-for-wp")
        };
        throw error;
      }
    },
    /**
     * Set error
     */
    setError(error) {
      this.error = error;
    },
    /**
     * Clear error
     */
    clearError() {
      this.error = null;
    },
    /**
     * Reset store
     */
    reset() {
      this.views = [];
      this.currentView = null;
      this.widgetMetadata = {};
      this.dashboardData = {};
      this.loading = false;
      this.saving = false;
      this.error = null;
      this.dateRange = { start: "", end: "" };
    }
  }
});
const _hoisted_1$h = { class: "exactmetrics-dashboard-tabs" };
const _hoisted_2$e = ["aria-label"];
const _hoisted_3$7 = ["aria-label"];
const _sfc_main$l = {
  __name: "ViewNavigation",
  props: {
    allViews: {
      type: Array,
      required: true
    },
    currentView: {
      type: Object,
      default: null
    },
    autoSaveStatus: {
      type: String,
      required: true
    },
    isNewView: {
      type: Boolean,
      default: false
    },
    allowReorder: {
      type: Boolean,
      default: false
    }
  },
  emits: ["select", "rename", "delete", "addNew", "edit"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const store = useCustomViewsStore();
    const localViews = ref([...props.allViews]);
    const tabsListRef = ref(null);
    const canScrollLeft = ref(false);
    const canScrollRight = ref(false);
    function updateScrollState() {
      if (!tabsListRef.value) return;
      const el = tabsListRef.value;
      const scrollLeft = el.scrollLeft;
      const scrollWidth = el.scrollWidth;
      const clientWidth = el.clientWidth;
      canScrollLeft.value = scrollLeft > 0;
      canScrollRight.value = scrollLeft + clientWidth < scrollWidth - 1;
    }
    function scrollTabs(direction) {
      if (!tabsListRef.value) return;
      const scrollAmount = 200;
      const el = tabsListRef.value;
      el.scrollBy({
        left: direction === "left" ? -scrollAmount : scrollAmount,
        behavior: "smooth"
      });
    }
    watch(() => props.allViews, (newViews) => {
      localViews.value = [...newViews];
      nextTick(() => updateScrollState());
    }, { deep: true });
    watch(() => props.isNewView, (isNew) => {
      if (isNew && tabsListRef.value) {
        nextTick(() => {
          tabsListRef.value.scrollTo({
            left: tabsListRef.value.scrollWidth,
            behavior: "smooth"
          });
          updateScrollState();
        });
      }
    });
    let resizeObserver = null;
    onMounted(() => {
      updateScrollState();
      if (tabsListRef.value && window.ResizeObserver) {
        resizeObserver = new ResizeObserver(() => {
          updateScrollState();
        });
        resizeObserver.observe(tabsListRef.value);
      }
    });
    onUnmounted(() => {
      if (resizeObserver) {
        resizeObserver.disconnect();
      }
    });
    const handleDragEnd = async () => {
      const viewOrders = localViews.value.map((view, index2) => ({
        id: view.id,
        order: index2
      }));
      try {
        await store.updateViewsOrder(viewOrders);
      } catch (error) {
        console.error("Failed to update view order:", error);
        localViews.value = [...props.allViews];
      }
    };
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1$h, [
        withDirectives(createBaseVNode("button", {
          class: "exactmetrics-dashboard-tabs__arrow exactmetrics-dashboard-tabs__arrow--left",
          "aria-label": unref(__)("Scroll tabs left", "google-analytics-dashboard-for-wp"),
          onClick: _cache[0] || (_cache[0] = ($event) => scrollTabs("left"))
        }, [..._cache[13] || (_cache[13] = [
          createBaseVNode("svg", {
            width: "8",
            height: "14",
            viewBox: "0 0 8 14",
            fill: "none",
            xmlns: "http://www.w3.org/2000/svg"
          }, [
            createBaseVNode("path", {
              d: "M7 13L1 7L7 1",
              stroke: "currentColor",
              "stroke-width": "2",
              "stroke-linecap": "round",
              "stroke-linejoin": "round"
            })
          ], -1)
        ])], 8, _hoisted_2$e), [
          [vShow, canScrollLeft.value]
        ]),
        createBaseVNode("div", {
          ref_key: "tabsListRef",
          ref: tabsListRef,
          class: "exactmetrics-dashboard-tabs__list",
          onScroll: updateScrollState
        }, [
          __props.allowReorder ? (openBlock(), createBlock(unref(draggable), {
            key: 0,
            modelValue: localViews.value,
            "onUpdate:modelValue": _cache[5] || (_cache[5] = ($event) => localViews.value = $event),
            "item-key": "id",
            animation: 200,
            handle: ".exactmetrics-view-tab",
            "ghost-class": "exactmetrics-view-tab--dragging",
            class: "exactmetrics-draggable-tabs",
            onEnd: handleDragEnd
          }, {
            item: withCtx(({ element: view }) => [
              (openBlock(), createBlock(_sfc_main$m, {
                key: view.id,
                "view-id": view.id,
                "view-name": view.title,
                "is-active": view.id === __props.currentView?.id,
                onSelect: _cache[1] || (_cache[1] = ($event) => emit("select", $event)),
                onRename: _cache[2] || (_cache[2] = ($event) => emit("rename", $event)),
                onDelete: _cache[3] || (_cache[3] = ($event) => emit("delete", $event)),
                onEdit: _cache[4] || (_cache[4] = ($event) => emit("edit", $event))
              }, null, 8, ["view-id", "view-name", "is-active"]))
            ]),
            _: 1
          }, 8, ["modelValue"])) : (openBlock(true), createElementBlock(Fragment, { key: 1 }, renderList(__props.allViews, (view) => {
            return openBlock(), createBlock(_sfc_main$m, {
              key: view.id,
              "view-id": view.id,
              "view-name": view.title,
              "is-active": view.id === __props.currentView?.id,
              onSelect: _cache[6] || (_cache[6] = ($event) => emit("select", $event)),
              onRename: _cache[7] || (_cache[7] = ($event) => emit("rename", $event)),
              onDelete: _cache[8] || (_cache[8] = ($event) => emit("delete", $event)),
              onEdit: _cache[9] || (_cache[9] = ($event) => emit("edit", $event))
            }, null, 8, ["view-id", "view-name", "is-active"]);
          }), 128)),
          __props.isNewView ? (openBlock(), createBlock(_sfc_main$m, {
            key: "new",
            "view-id": "new",
            "view-name": __props.currentView?.title || unref(__)("My New View", "google-analytics-dashboard-for-wp"),
            "is-active": true,
            onSelect: () => {
            },
            onRename: _cache[10] || (_cache[10] = ($event) => emit("rename", $event)),
            onDelete: () => {
            }
          }, null, 8, ["view-name"])) : createCommentVNode("", true)
        ], 544),
        withDirectives(createBaseVNode("button", {
          class: "exactmetrics-dashboard-tabs__arrow exactmetrics-dashboard-tabs__arrow--right",
          "aria-label": unref(__)("Scroll tabs right", "google-analytics-dashboard-for-wp"),
          onClick: _cache[11] || (_cache[11] = ($event) => scrollTabs("right"))
        }, [..._cache[14] || (_cache[14] = [
          createBaseVNode("svg", {
            width: "8",
            height: "14",
            viewBox: "0 0 8 14",
            fill: "none",
            xmlns: "http://www.w3.org/2000/svg"
          }, [
            createBaseVNode("path", {
              d: "M1 1L7 7L1 13",
              stroke: "currentColor",
              "stroke-width": "2",
              "stroke-linecap": "round",
              "stroke-linejoin": "round"
            })
          ], -1)
        ])], 8, _hoisted_3$7), [
          [vShow, canScrollRight.value]
        ]),
        createBaseVNode("button", {
          class: "exactmetrics-button exactmetrics-button--primary",
          onClick: _cache[12] || (_cache[12] = ($event) => emit("addNew"))
        }, [
          createVNode(Icon, {
            name: "dashicons-plus-alt2",
            size: 16,
            color: "#fff"
          }),
          createTextVNode(" " + toDisplayString(unref(__)("Add View", "google-analytics-dashboard-for-wp")), 1)
        ])
      ]);
    };
  }
};
const ViewNavigation = /* @__PURE__ */ _export_sfc(_sfc_main$l, [["__scopeId", "data-v-8c95a211"]]);
const colorCardBackground = "#F4F3F7";
const colorLinkHover = "#393f4c";
const colorWarning = "#ffaa00";
const colorDelete = "#dc3232";
const colorOrange = "#f2994a";
const colorBlue = "#509fe2";
const colorPurple = "#6528f5";
const brandName = "exactmetrics";
const vars = {
  colorCardBackground,
  colorLinkHover,
  colorWarning,
  colorDelete,
  colorOrange,
  colorBlue,
  colorPurple,
  brandName
};
const brandConfig = {
  name: vars.brandName,
  // Brand-specific icon paths
  icons: {
    logoFallback: "logos/exactmetrics-header",
    emptyState: "templates/exactmetrics/create-new"
  },
  // All colors imported from SCSS (single source of truth)
  colors: {
    primary: vars.colorPrimary,
    primaryHover: vars.colorPrimaryHover,
    secondary: vars.colorSecondary,
    tertiary: vars.colorTertiary,
    // Buttons
    button: {
      background: vars.btnBackground,
      backgroundHover: vars.btnBackgroundHover,
      backgroundFaux: vars.btnBackgroundFaux,
      border: vars.btnBorder,
      borderHover: vars.btnBorderHover,
      text: vars.btnText
    },
    buttonSecondary: {
      background: vars.btnSecondaryBackground,
      backgroundHover: vars.btnSecondaryBackgroundHover,
      border: vars.btnSecondaryBorder,
      borderHover: vars.btnSecondaryBorderHover,
      text: vars.btnSecondaryText
    },
    buttonGreen: {
      background: vars.btnGreenBackground,
      backgroundHover: vars.btnGreenBackgroundHover,
      border: vars.btnGreenBorder,
      borderHover: vars.btnGreenBorderHover,
      text: vars.btnGreenText
    },
    buttonRed: {
      background: vars.btnRedBackground,
      border: vars.btnRedBorder,
      text: vars.btnRedText
    },
    buttonDisabled: {
      background: vars.btnDisabledBackground,
      border: vars.btnDisabledBorder,
      text: vars.btnDisabledText
    },
    // Status colors
    success: vars.colorSuccess,
    error: vars.colorError,
    warning: vars.colorWarning,
    info: vars.colorInfo,
    delete: vars.colorDelete,
    // Layout
    body: vars.colorBody,
    header: vars.colorHeader,
    cardBackground: vars.colorCardBackground,
    border: vars.colorBorder,
    // Text
    text: {
      dark: vars.textDark,
      primary: vars.textPrimary,
      secondary: vars.textSecondary,
      muted: vars.textMuted,
      highlight: vars.textHighlight
    },
    // Forms
    input: {
      border: vars.inputBorder,
      placeholder: vars.inputPlaceholder
    },
    // Links
    link: vars.colorLink,
    linkHover: vars.colorLinkHover,
    // Navigation
    navigation: {
      link: vars.navLink,
      linkActive: vars.navLinkActive
    },
    // Misc
    checkbox: {
      background: vars.checkboxBackground,
      backgroundFaux: vars.checkboxBackgroundFaux
    },
    infoIcon: vars.infoIcon,
    tooltip: vars.tooltip,
    purple: vars.colorPurple,
    orange: vars.colorOrange,
    blue: vars.colorBlue
  },
  // Chart color palette (uses SCSS primary + custom chart colors)
  chartColors: [
    "#6528F5",
    // Primary Purple (Figma)
    "#A735DF",
    // Magenta Purple (Figma)
    "#0AA9BF",
    // Cyan/Teal (Figma)
    "#E63060",
    // Pink/Red (Figma)
    "#B0BDC8",
    // Light Gray/Blue (Figma)
    vars.colorPrimaryHover,
    // Dark Purple (from SCSS)
    vars.btnGreenBackgroundHover,
    // Green Hover (from SCSS)
    vars.btnSecondaryBackground,
    // Light Purple (from SCSS)
    vars.textMuted,
    // Purple Gray (from SCSS)
    vars.colorOrange
    // Orange (from SCSS)
  ]
};
const _hoisted_1$g = ["aria-label"];
const _hoisted_2$d = {
  key: 0,
  class: "mi-spinner-text"
};
const _sfc_main$k = {
  __name: "LoadingSpinnerInline",
  props: {
    label: { type: String, default: __("Loading", "google-analytics-dashboard-for-wp") },
    text: { type: String, default: "" }
  },
  setup(__props) {
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(Fragment, null, [
        createBaseVNode("span", {
          class: "mi-spinner",
          "aria-label": __props.label,
          role: "status"
        }, null, 8, _hoisted_1$g),
        __props.text ? (openBlock(), createElementBlock("span", _hoisted_2$d, toDisplayString(__props.text), 1)) : createCommentVNode("", true),
        renderSlot(_ctx.$slots, "default", {}, void 0, true)
      ], 64);
    };
  }
};
const LoadingSpinnerInline = /* @__PURE__ */ _export_sfc(_sfc_main$k, [["__scopeId", "data-v-f987e014"]]);
const _hoisted_1$f = { class: "exactmetrics-widget__header" };
const _hoisted_2$c = {
  key: 0,
  class: "exactmetrics-widget__title"
};
const _hoisted_3$6 = {
  key: 2,
  class: "exactmetrics-widget__actions"
};
const _hoisted_4$4 = ["aria-label"];
const _hoisted_5$4 = {
  key: 0,
  class: "exactmetrics-widget__menu"
};
const _hoisted_6$3 = ["checked"];
const _hoisted_7$3 = { class: "exactmetrics-widget__checkbox-text" };
const _hoisted_8$3 = { class: "exactmetrics-widget__body" };
const _hoisted_9$3 = {
  key: 0,
  class: "exactmetrics-widget__loading"
};
const _hoisted_10$3 = {
  key: 1,
  class: "exactmetrics-widget__error"
};
const _hoisted_11$2 = {
  key: 2,
  class: "exactmetrics-widget__content"
};
const _sfc_main$j = {
  __name: "BaseWidget",
  props: {
    widget: {
      type: Object,
      required: true
    },
    loading: {
      type: Boolean,
      default: false
    },
    error: {
      type: String,
      default: null
    },
    category: {
      type: String,
      default: "chart",
      validator: (value) => ["metric", "chart", "table"].includes(value)
    },
    canEditMetrics: {
      type: Boolean,
      default: false
    },
    canEditDimensions: {
      type: Boolean,
      default: false
    },
    canToggleChartType: {
      type: Boolean,
      default: false
    },
    supportedTypes: {
      type: Array,
      default: () => []
    },
    canToggleExtendedView: {
      type: Boolean,
      default: false
    },
    isEditable: {
      type: Boolean,
      default: true
    },
    widgetMetadata: {
      type: Object,
      default: null
    }
  },
  emits: ["delete", "edit-metrics", "edit-dimensions", "toggle-chart", "toggle-extended-view", "toggle-comparison", "rename"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const showMenu = ref(false);
    const showTypeSubmenu = ref(false);
    const isEditingTitle = ref(false);
    const editedTitle = ref("");
    const titleInput = ref(null);
    const submenuTrigger = ref(null);
    const submenuPosition = reactive({ top: 0, left: 0 });
    let submenuCloseTimeout = null;
    const submenuStyle = computed(() => ({
      position: "fixed",
      top: `${submenuPosition.top}px`,
      left: `${submenuPosition.left}px`,
      zIndex: 99999
    }));
    function toggleMenu() {
      showMenu.value = !showMenu.value;
    }
    function closeMenu() {
      showMenu.value = false;
      showTypeSubmenu.value = false;
      if (submenuCloseTimeout) {
        clearTimeout(submenuCloseTimeout);
        submenuCloseTimeout = null;
      }
    }
    function handleSubmenuMouseEnter() {
      if (submenuCloseTimeout) {
        clearTimeout(submenuCloseTimeout);
        submenuCloseTimeout = null;
      }
      if (submenuTrigger.value) {
        const rect = submenuTrigger.value.getBoundingClientRect();
        submenuPosition.top = rect.top;
        submenuPosition.left = rect.right + 2;
      }
      showTypeSubmenu.value = true;
    }
    function handleSubmenuMouseLeave() {
      submenuCloseTimeout = setTimeout(() => {
        showTypeSubmenu.value = false;
      }, 150);
    }
    function handleDelete() {
      closeMenu();
      emit("delete", props.widget.id);
    }
    function handleEditMetrics() {
      closeMenu();
      emit("edit-metrics", props.widget.id);
    }
    function handleEditDimensions() {
      closeMenu();
      emit("edit-dimensions", props.widget.id);
    }
    function handleToggleChart(type) {
      closeMenu();
      emit("toggle-chart", { widgetId: props.widget.id, chartType: type });
    }
    function handleToggleExtendedView() {
      closeMenu();
      emit("toggle-extended-view", props.widget.id);
    }
    function handleToggleComparison() {
      closeMenu();
      emit("toggle-comparison", props.widget.id);
    }
    function handleRenameWidget() {
      closeMenu();
      editedTitle.value = props.widget.title || props.widget.name;
      isEditingTitle.value = true;
      nextTick(() => {
        titleInput.value?.focus();
        titleInput.value?.select();
      });
    }
    function saveTitle() {
      if (editedTitle.value.trim() && editedTitle.value !== props.widget.title) {
        emit("rename", { widgetId: props.widget.id, title: editedTitle.value.trim() });
      }
      isEditingTitle.value = false;
    }
    function cancelEditTitle() {
      isEditingTitle.value = false;
      editedTitle.value = "";
    }
    const currentDisplayType = computed(() => {
      if (props.widget?.displayType) {
        return props.widget.displayType;
      }
      return props.widgetMetadata?.defaults?.type || "infobox";
    });
    const supportsComparison = computed(() => {
      const currentType = currentDisplayType.value;
      if (props.widgetMetadata?.support && "compare" in props.widgetMetadata.support) {
        const compareConfig = props.widgetMetadata.support.compare;
        if (typeof compareConfig === "object" && !Array.isArray(compareConfig)) {
          const result = compareConfig[currentType] === true;
          return result;
        }
        if (typeof compareConfig === "boolean") {
          return compareConfig;
        }
      }
      const defaultResult = currentType === "infobox" || currentType === "line-chart" || currentType === "table";
      return defaultResult;
    });
    const extendedViewIcon = computed(() => {
      return props.widget?.extendedView ? "icons/minimize" : "icons/maximize";
    });
    const extendedViewLabel = computed(() => {
      return props.widget?.extendedView ? __("Show Compact View", "google-analytics-dashboard-for-wp") : __("Show Extended View", "google-analytics-dashboard-for-wp");
    });
    const vClickOutside = {
      mounted(el, binding) {
        setTimeout(() => {
          el.clickOutsideEvent = function(event) {
            if (!(el === event.target || el.contains(event.target))) {
              binding.value();
            }
          };
          document.addEventListener("click", el.clickOutsideEvent);
        }, 100);
      },
      unmounted(el) {
        if (el.clickOutsideEvent) {
          document.removeEventListener("click", el.clickOutsideEvent);
        }
      }
    };
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(["exactmetrics-widget", [
          `exactmetrics-widget--${__props.widget.type}`,
          `exactmetrics-widget--category-${__props.category}`,
          { "exactmetrics-widget--loading": __props.loading },
          { "exactmetrics-widget--menu-open": showMenu.value }
        ]])
      }, [
        createBaseVNode("div", _hoisted_1$f, [
          !isEditingTitle.value ? (openBlock(), createElementBlock("h3", _hoisted_2$c, toDisplayString(__props.widget.title || __props.widget.name), 1)) : withDirectives((openBlock(), createElementBlock("input", {
            key: 1,
            ref_key: "titleInput",
            ref: titleInput,
            "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => editedTitle.value = $event),
            class: "exactmetrics-widget__title-input",
            type: "text",
            onKeydown: [
              withKeys(saveTitle, ["enter"]),
              withKeys(cancelEditTitle, ["esc"])
            ],
            onBlur: saveTitle
          }, null, 544)), [
            [vModelText, editedTitle.value]
          ]),
          __props.isEditable ? (openBlock(), createElementBlock("div", _hoisted_3$6, [
            createBaseVNode("button", {
              class: "exactmetrics-widget__settings",
              onClick: withModifiers(toggleMenu, ["stop", "prevent"]),
              "aria-label": unref(__)("Widget settings", "google-analytics-dashboard-for-wp")
            }, [
              createVNode(Icon, {
                name: "settings",
                size: 20
              })
            ], 8, _hoisted_4$4),
            showMenu.value ? withDirectives((openBlock(), createElementBlock("div", _hoisted_5$4, [
              createBaseVNode("button", {
                class: "exactmetrics-widget__menu-item",
                onClick: withModifiers(handleRenameWidget, ["stop"])
              }, [
                createVNode(Icon, {
                  name: "dashicons-edit",
                  size: 16
                }),
                createTextVNode(" " + toDisplayString(unref(__)("Rename Widget", "google-analytics-dashboard-for-wp")), 1)
              ]),
              __props.canEditMetrics ? (openBlock(), createElementBlock("button", {
                key: 0,
                class: "exactmetrics-widget__menu-item",
                onClick: withModifiers(handleEditMetrics, ["stop"])
              }, [
                createVNode(Icon, {
                  name: "dashicons-chart-bar",
                  size: 16
                }),
                createTextVNode(" " + toDisplayString(unref(__)("Edit Metrics", "google-analytics-dashboard-for-wp")), 1)
              ])) : createCommentVNode("", true),
              __props.canEditDimensions ? (openBlock(), createElementBlock("button", {
                key: 1,
                class: "exactmetrics-widget__menu-item",
                onClick: withModifiers(handleEditDimensions, ["stop"])
              }, [
                createVNode(Icon, {
                  name: "dashicons-category",
                  size: 16
                }),
                createTextVNode(" " + toDisplayString(unref(__)("Edit Breakdown", "google-analytics-dashboard-for-wp")), 1)
              ])) : createCommentVNode("", true),
              __props.canToggleChartType ? (openBlock(), createElementBlock("button", {
                key: 2,
                ref_key: "submenuTrigger",
                ref: submenuTrigger,
                class: "exactmetrics-widget__menu-item exactmetrics-widget__menu-item--submenu",
                onMouseenter: handleSubmenuMouseEnter,
                onMouseleave: handleSubmenuMouseLeave
              }, [
                createVNode(Icon, {
                  name: "dashicons-layout",
                  size: 16
                }),
                createTextVNode(" " + toDisplayString(unref(__)("Type", "google-analytics-dashboard-for-wp")) + " ", 1),
                createVNode(Icon, {
                  name: "dashicons-arrow-right-alt2",
                  size: 16,
                  class: "exactmetrics-widget__menu-arrow"
                })
              ], 544)) : createCommentVNode("", true),
              (openBlock(), createBlock(Teleport, { to: "body" }, [
                showTypeSubmenu.value ? (openBlock(), createElementBlock("div", {
                  key: 0,
                  class: "exactmetrics-widget__submenu exactmetrics-widget__submenu--teleported",
                  style: normalizeStyle(submenuStyle.value),
                  onMouseenter: handleSubmenuMouseEnter,
                  onMouseleave: handleSubmenuMouseLeave
                }, [
                  __props.supportedTypes.includes("infobox") ? (openBlock(), createElementBlock("button", {
                    key: 0,
                    class: normalizeClass(["exactmetrics-widget__menu-item", { "is-active": currentDisplayType.value === "infobox" }]),
                    onClick: _cache[1] || (_cache[1] = withModifiers(($event) => handleToggleChart("infobox"), ["stop"]))
                  }, [
                    createVNode(Icon, {
                      name: "dashicons-info",
                      size: 16
                    }),
                    createTextVNode(" " + toDisplayString(unref(__)("Info Card", "google-analytics-dashboard-for-wp")), 1)
                  ], 2)) : createCommentVNode("", true),
                  __props.supportedTypes.includes("line-chart") ? (openBlock(), createElementBlock("button", {
                    key: 1,
                    class: normalizeClass(["exactmetrics-widget__menu-item", { "is-active": currentDisplayType.value === "line-chart" }]),
                    onClick: _cache[2] || (_cache[2] = withModifiers(($event) => handleToggleChart("line-chart"), ["stop"]))
                  }, [
                    createVNode(Icon, {
                      name: "dashicons-chart-line",
                      size: 16
                    }),
                    createTextVNode(" " + toDisplayString(unref(__)("Line Chart", "google-analytics-dashboard-for-wp")), 1)
                  ], 2)) : createCommentVNode("", true),
                  __props.supportedTypes.includes("area-chart") ? (openBlock(), createElementBlock("button", {
                    key: 2,
                    class: normalizeClass(["exactmetrics-widget__menu-item", { "is-active": currentDisplayType.value === "area-chart" }]),
                    onClick: _cache[3] || (_cache[3] = withModifiers(($event) => handleToggleChart("area-chart"), ["stop"]))
                  }, [
                    createVNode(Icon, {
                      name: "dashicons-chart-area",
                      size: 16
                    }),
                    createTextVNode(" " + toDisplayString(unref(__)("Area Chart", "google-analytics-dashboard-for-wp")), 1)
                  ], 2)) : createCommentVNode("", true),
                  __props.supportedTypes.includes("bar-chart") ? (openBlock(), createElementBlock("button", {
                    key: 3,
                    class: normalizeClass(["exactmetrics-widget__menu-item", { "is-active": currentDisplayType.value === "bar-chart" }]),
                    onClick: _cache[4] || (_cache[4] = withModifiers(($event) => handleToggleChart("bar-chart"), ["stop"]))
                  }, [
                    createVNode(Icon, {
                      name: "dashicons-chart-bar",
                      size: 16
                    }),
                    createTextVNode(" " + toDisplayString(unref(__)("Bar Chart", "google-analytics-dashboard-for-wp")), 1)
                  ], 2)) : createCommentVNode("", true),
                  __props.supportedTypes.includes("pie-chart") ? (openBlock(), createElementBlock("button", {
                    key: 4,
                    class: normalizeClass(["exactmetrics-widget__menu-item", { "is-active": currentDisplayType.value === "pie-chart" }]),
                    onClick: _cache[5] || (_cache[5] = withModifiers(($event) => handleToggleChart("pie-chart"), ["stop"]))
                  }, [
                    createVNode(Icon, {
                      name: "dashicons-chart-pie",
                      size: 16
                    }),
                    createTextVNode(" " + toDisplayString(unref(__)("Pie Chart", "google-analytics-dashboard-for-wp")), 1)
                  ], 2)) : createCommentVNode("", true),
                  __props.supportedTypes.includes("table") ? (openBlock(), createElementBlock("button", {
                    key: 5,
                    class: normalizeClass(["exactmetrics-widget__menu-item", { "is-active": currentDisplayType.value === "table" }]),
                    onClick: _cache[6] || (_cache[6] = withModifiers(($event) => handleToggleChart("table"), ["stop"]))
                  }, [
                    createVNode(Icon, {
                      name: "dashicons-list-view",
                      size: 16
                    }),
                    createTextVNode(" " + toDisplayString(unref(__)("Table", "google-analytics-dashboard-for-wp")), 1)
                  ], 2)) : createCommentVNode("", true)
                ], 36)) : createCommentVNode("", true)
              ])),
              __props.canToggleExtendedView ? (openBlock(), createElementBlock("button", {
                key: 3,
                class: "exactmetrics-widget__menu-item",
                onClick: withModifiers(handleToggleExtendedView, ["stop"])
              }, [
                createVNode(Icon, {
                  name: extendedViewIcon.value,
                  size: 16
                }, null, 8, ["name"]),
                createTextVNode(" " + toDisplayString(extendedViewLabel.value), 1)
              ])) : createCommentVNode("", true),
              supportsComparison.value ? (openBlock(), createElementBlock("label", {
                key: 4,
                class: "exactmetrics-widget__menu-item exactmetrics-widget__menu-item--checkbox",
                onClick: _cache[7] || (_cache[7] = withModifiers(() => {
                }, ["stop"]))
              }, [
                createBaseVNode("input", {
                  type: "checkbox",
                  checked: __props.widget.compare,
                  onChange: handleToggleComparison,
                  class: "exactmetrics-widget__checkbox"
                }, null, 40, _hoisted_6$3),
                createBaseVNode("span", _hoisted_7$3, toDisplayString(unref(__)("Show Comparison", "google-analytics-dashboard-for-wp")), 1)
              ])) : createCommentVNode("", true),
              createBaseVNode("button", {
                class: "exactmetrics-widget__menu-item exactmetrics-widget__menu-item--danger",
                onClick: withModifiers(handleDelete, ["stop"])
              }, [
                createVNode(Icon, {
                  name: "dashicons-trash",
                  size: 16
                }),
                createTextVNode(" " + toDisplayString(unref(__)("Delete Card", "google-analytics-dashboard-for-wp")), 1)
              ])
            ])), [
              [vClickOutside, closeMenu]
            ]) : createCommentVNode("", true)
          ])) : createCommentVNode("", true)
        ]),
        createBaseVNode("div", _hoisted_8$3, [
          __props.loading ? (openBlock(), createElementBlock("div", _hoisted_9$3, [
            createVNode(LoadingSpinnerInline),
            createBaseVNode("span", null, toDisplayString(unref(__)("Loading...", "google-analytics-dashboard-for-wp")), 1)
          ])) : __props.error ? (openBlock(), createElementBlock("div", _hoisted_10$3, [
            createVNode(Icon, {
              name: "warning",
              size: 24
            }),
            createBaseVNode("p", null, toDisplayString(__props.error), 1)
          ])) : (openBlock(), createElementBlock("div", _hoisted_11$2, [
            renderSlot(_ctx.$slots, "default")
          ]))
        ])
      ], 2);
    };
  }
};
const _hoisted_1$e = { class: "exactmetrics-key-metric__period-block" };
const _hoisted_2$b = { class: "exactmetrics-key-metric__value-row" };
const _hoisted_3$5 = { class: "exactmetrics-key-metric__value" };
const _hoisted_4$3 = { class: "exactmetrics-key-metric__date-range" };
const _hoisted_5$3 = { class: "exactmetrics-key-metric__period-block exactmetrics-key-metric__period-block--previous" };
const _hoisted_6$2 = { class: "exactmetrics-key-metric__value" };
const _hoisted_7$2 = { class: "exactmetrics-key-metric__date-range" };
const _hoisted_8$2 = { class: "exactmetrics-key-metric__value" };
const _hoisted_9$2 = {
  key: 0,
  class: "exactmetrics-key-metric__comparison"
};
const _hoisted_10$2 = { class: "exactmetrics-key-metric__period" };
const _sfc_main$i = {
  __name: "KeyMetricWidget",
  props: {
    widget: {
      type: Object,
      required: true
    },
    data: {
      type: Object,
      default: null
    },
    loading: {
      type: Boolean,
      default: false
    },
    widgetMetadata: {
      type: Object,
      default: null
    }
  },
  emits: ["delete"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const primaryValue = computed(() => {
      if (!props.data) return 0;
      if (props.data.rows && props.data.rows.length > 0) {
        const firstRow = props.data.rows[0];
        if (firstRow.m && firstRow.m.length > 0 && firstRow.m[0].length > 0) {
          const value = firstRow.m[0][0];
          return value;
        }
      }
      return 0;
    });
    const formattedValue = computed(() => {
      const value = parseFloat(primaryValue.value);
      if (isNaN(value)) return "0";
      if (props.widget.type === "revenue") {
        return new Intl.NumberFormat("en-US", {
          style: "currency",
          currency: "USD",
          minimumFractionDigits: 0,
          maximumFractionDigits: 0
        }).format(value);
      }
      if (props.widget.type === "engagement-rate" || props.widget.type === "bounce-rate") {
        return `${value.toFixed(1)}%`;
      }
      if (value >= 1e6) {
        return `${(value / 1e6).toFixed(1)}M`;
      }
      if (value >= 1e3) {
        return `${(value / 1e3).toFixed(1)}K`;
      }
      return formatNumber(value);
    });
    const hasComparison = computed(() => {
      if (!props.data?.rows || props.data.rows.length === 0) return false;
      const firstRow = props.data.rows[0];
      return firstRow.m && firstRow.m.length > 0 && firstRow.m[0].length > 1;
    });
    const comparisonChange = computed(() => {
      if (!hasComparison.value) return 0;
      const firstRow = props.data.rows[0];
      const current = parseFloat(firstRow.m[0][0]);
      const previous = parseFloat(firstRow.m[0][1]);
      if (previous === 0) return 0;
      return Math.round((current - previous) / previous * 100);
    });
    const comparisonText = computed(() => {
      const change = comparisonChange.value;
      const prefix = change > 0 ? "+" : "";
      return `${prefix}${Math.abs(change)}%`;
    });
    const comparisonClass = computed(() => {
      const change = comparisonChange.value;
      if (change > 0) return "exactmetrics-key-metric__change--up";
      if (change < 0) return "exactmetrics-key-metric__change--down";
      return "";
    });
    const comparisonIcon = computed(() => {
      const change = comparisonChange.value;
      if (change > 0) return "dashicons-arrow-up-alt";
      if (change < 0) return "dashicons-arrow-down-alt";
      return "dashicons-minus";
    });
    const comparisonPeriod = computed(() => {
      if (props.data?.comparison?.period) {
        return props.data.comparison.period;
      }
      if (props.data?.dateRange?.current?.start && props.data?.dateRange?.current?.end) {
        const start = new Date(props.data.dateRange.current.start);
        const end = new Date(props.data.dateRange.current.end);
        const days2 = Math.ceil((end - start) / (1e3 * 60 * 60 * 24));
        if (days2 === 1) {
          return __("vs. Previous Day", "google-analytics-dashboard-for-wp");
        }
        return __("vs. Previous %s Days", "google-analytics-dashboard-for-wp").replace("%s", days2);
      }
      return __("vs. Previous 30 Days", "google-analytics-dashboard-for-wp");
    });
    const errorMessage = computed(() => {
      if (props.data?.error) {
        return props.data.message || __("Error loading data", "google-analytics-dashboard-for-wp");
      }
      return null;
    });
    const isExtendedMode = computed(() => {
      return props.widget?.extendedView === true;
    });
    const previousValue = computed(() => {
      if (!hasComparison.value) return 0;
      const firstRow = props.data.rows[0];
      return parseFloat(firstRow.m[0][1]);
    });
    const formattedPreviousValue = computed(() => {
      const value = previousValue.value;
      if (isNaN(value)) return "0";
      if (props.widget.type === "revenue") {
        return new Intl.NumberFormat("en-US", {
          style: "currency",
          currency: "USD",
          minimumFractionDigits: 0,
          maximumFractionDigits: 0
        }).format(value);
      }
      if (props.widget.type === "engagement-rate" || props.widget.type === "bounce-rate") {
        return `${value.toFixed(1)}%`;
      }
      if (value >= 1e6) {
        return `${(value / 1e6).toFixed(1)}M`;
      }
      if (value >= 1e3) {
        return `${(value / 1e3).toFixed(1)}K`;
      }
      return formatNumber(value);
    });
    const formatDate = (dateStr) => {
      if (!dateStr) return "";
      const date = /* @__PURE__ */ new Date(dateStr + "T00:00:00");
      return date.toLocaleDateString("en-US", {
        month: "short",
        day: "numeric",
        year: "numeric"
      });
    };
    const currentPeriodDates = computed(() => {
      if (props.data?.dateRange?.current) {
        const { start, end } = props.data.dateRange.current;
        return `${formatDate(start)} - ${formatDate(end)}`;
      }
      return props.data?.comparison?.period || __("Current Period", "google-analytics-dashboard-for-wp");
    });
    const previousPeriodDates = computed(() => {
      if (props.data?.dateRange?.previous) {
        const { start, end } = props.data.dateRange.previous;
        return `${formatDate(start)} - ${formatDate(end)}`;
      }
      return __("Previous Period", "google-analytics-dashboard-for-wp");
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(_sfc_main$j, {
        widget: __props.widget,
        loading: __props.loading,
        error: errorMessage.value,
        category: "metric",
        "widget-metadata": __props.widgetMetadata,
        onDelete: _cache[0] || (_cache[0] = ($event) => _ctx.$emit("delete", $event))
      }, {
        default: withCtx(() => [
          createBaseVNode("div", {
            class: normalizeClass(["exactmetrics-key-metric", { "exactmetrics-key-metric--extended": isExtendedMode.value }])
          }, [
            isExtendedMode.value && hasComparison.value ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
              createBaseVNode("div", _hoisted_1$e, [
                createBaseVNode("div", _hoisted_2$b, [
                  createBaseVNode("span", _hoisted_3$5, toDisplayString(formattedValue.value), 1),
                  createBaseVNode("span", {
                    class: normalizeClass(["exactmetrics-key-metric__change", comparisonClass.value])
                  }, [
                    createVNode(Icon, {
                      name: comparisonIcon.value,
                      size: 14
                    }, null, 8, ["name"]),
                    createTextVNode(" " + toDisplayString(comparisonText.value), 1)
                  ], 2)
                ]),
                createBaseVNode("div", _hoisted_4$3, toDisplayString(currentPeriodDates.value), 1)
              ]),
              createBaseVNode("div", _hoisted_5$3, [
                createBaseVNode("div", _hoisted_6$2, toDisplayString(formattedPreviousValue.value), 1),
                createBaseVNode("div", _hoisted_7$2, toDisplayString(previousPeriodDates.value), 1)
              ])
            ], 64)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
              createBaseVNode("div", _hoisted_8$2, toDisplayString(formattedValue.value), 1),
              hasComparison.value ? (openBlock(), createElementBlock("div", _hoisted_9$2, [
                createBaseVNode("span", {
                  class: normalizeClass(["exactmetrics-key-metric__change", comparisonClass.value])
                }, [
                  createVNode(Icon, {
                    name: comparisonIcon.value,
                    size: 12
                  }, null, 8, ["name"]),
                  createTextVNode(" " + toDisplayString(comparisonText.value), 1)
                ], 2),
                createBaseVNode("span", _hoisted_10$2, toDisplayString(comparisonPeriod.value), 1)
              ])) : createCommentVNode("", true)
            ], 64))
          ], 2)
        ]),
        _: 1
      }, 8, ["widget", "loading", "error", "widget-metadata"]);
    };
  }
};
const KeyMetricWidget = /* @__PURE__ */ _export_sfc(_sfc_main$i, [["__scopeId", "data-v-7c8afdc2"]]);
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
class Environment {
  /**
   * Check if running in server-side rendering environment (Node.js)
   * @returns {boolean} True if in SSR/Node.js, false if in browser
   */
  static isSSR() {
    return typeof window === "undefined" || typeof document === "undefined";
  }
  /**
   * Check if running in browser environment
   * @returns {boolean} True if in browser, false if in SSR/Node.js
   */
  static isBrowser() {
    return !this.isSSR();
  }
  /**
   * Check if a specific browser API is available
   * @param {string} api - Name of the API to check (e.g., 'ResizeObserver')
   * @returns {boolean} True if API is available
   */
  static hasAPI(api) {
    if (this.isSSR()) return false;
    return typeof window[api] !== "undefined";
  }
}
class SSRElement {
  constructor(nodeName, namespaceURI = null) {
    this.nodeName = nodeName;
    this.namespaceURI = namespaceURI;
    this.attributes = /* @__PURE__ */ new Map();
    this.children = [];
    this.textContent = "";
    this.style = {};
    this.classList = new SSRClassList();
    this.parentNode = null;
  }
  setAttribute(name2, value) {
    this.attributes.set(name2, value);
  }
  getAttribute(name2) {
    return this.attributes.get(name2);
  }
  removeAttribute(name2) {
    this.attributes.delete(name2);
  }
  hasAttribute(name2) {
    return this.attributes.has(name2);
  }
  appendChild(child) {
    if (child && child !== this) {
      child.parentNode = this;
      this.children.push(child);
    }
    return child;
  }
  removeChild(child) {
    const index2 = this.children.indexOf(child);
    if (index2 !== -1) {
      this.children.splice(index2, 1);
      child.parentNode = null;
    }
    return child;
  }
  insertBefore(newNode, referenceNode) {
    if (!referenceNode) {
      return this.appendChild(newNode);
    }
    const index2 = this.children.indexOf(referenceNode);
    if (index2 !== -1) {
      newNode.parentNode = this;
      this.children.splice(index2, 0, newNode);
    }
    return newNode;
  }
  cloneNode(deep = false) {
    const clone2 = new SSRElement(this.nodeName, this.namespaceURI);
    clone2.textContent = this.textContent;
    this.attributes.forEach((value, key) => {
      clone2.attributes.set(key, value);
    });
    Object.assign(clone2.style, this.style);
    if (deep) {
      this.children.forEach((child) => {
        if (child.cloneNode) {
          clone2.appendChild(child.cloneNode(true));
        }
      });
    }
    return clone2;
  }
  getBoundingClientRect() {
    return {
      width: this._ssrWidth || 0,
      height: this._ssrHeight || 0,
      top: 0,
      left: 0,
      right: this._ssrWidth || 0,
      bottom: this._ssrHeight || 0,
      x: 0,
      y: 0
    };
  }
  getRootNode() {
    let root = this;
    while (root.parentNode) {
      root = root.parentNode;
    }
    return root;
  }
  toString() {
    let attrs = "";
    this.attributes.forEach((value, key) => {
      attrs += ` ${key}="${value}"`;
    });
    if (this.children.length === 0 && !this.textContent) {
      return `<${this.nodeName}${attrs}/>`;
    }
    const childrenStr = this.children.map((c) => c.toString()).join("");
    return `<${this.nodeName}${attrs}>${this.textContent}${childrenStr}</${this.nodeName}>`;
  }
  // Property getters/setters
  get innerHTML() {
    return this.children.map((c) => c.toString()).join("");
  }
  set innerHTML(value) {
    this.children = [];
    this.textContent = value;
  }
  get outerHTML() {
    return this.toString();
  }
  get isConnected() {
    return true;
  }
}
class SSRClassList {
  constructor() {
    this.classes = /* @__PURE__ */ new Set();
  }
  add(...classNames) {
    classNames.forEach((name2) => this.classes.add(name2));
  }
  remove(...classNames) {
    classNames.forEach((name2) => this.classes.delete(name2));
  }
  contains(className) {
    return this.classes.has(className);
  }
  toggle(className, force) {
    if (force === true) {
      this.classes.add(className);
      return true;
    } else if (force === false) {
      this.classes.delete(className);
      return false;
    } else {
      if (this.classes.has(className)) {
        this.classes.delete(className);
        return false;
      } else {
        this.classes.add(className);
        return true;
      }
    }
  }
  toString() {
    return Array.from(this.classes).join(" ");
  }
}
class SSRDOMShim {
  constructor() {
    this.SVGNS = "http://www.w3.org/2000/svg";
    this.XLINKNS = "http://www.w3.org/1999/xlink";
  }
  /**
   * Create SVG element with namespace
   * @param {string} namespaceURI - Namespace URI
   * @param {string} qualifiedName - Element tag name
   * @returns {SSRElement} Mock SVG element
   */
  createElementNS(namespaceURI, qualifiedName) {
    return new SSRElement(qualifiedName, namespaceURI);
  }
  /**
   * Create text node
   * @param {string} data - Text content
   * @returns {object} Text node mock
   */
  createTextNode(data) {
    return {
      nodeName: "#text",
      nodeType: 3,
      textContent: data,
      toString() {
        return this.textContent;
      }
    };
  }
  /**
   * Query selector (returns null in SSR)
   * @returns {null}
   */
  querySelector() {
    return null;
  }
  /**
   * Query selector all (returns empty array in SSR)
   * @returns {Array}
   */
  querySelectorAll() {
    return [];
  }
  /**
   * Get computed style (returns empty object in SSR)
   * @returns {object}
   */
  getComputedStyle() {
    return {};
  }
  /**
   * Get bounding client rect for element
   * @param {SSRElement} element - Element to measure
   * @returns {object} Mock dimensions
   */
  getBoundingClientRect(element) {
    if (element && element.getBoundingClientRect) {
      return element.getBoundingClientRect();
    }
    return {
      width: 0,
      height: 0,
      top: 0,
      left: 0,
      right: 0,
      bottom: 0,
      x: 0,
      y: 0
    };
  }
  /**
   * Create mock XMLSerializer for SSR
   * @returns {object} XMLSerializer mock
   */
  createXMLSerializer() {
    return {
      serializeToString(element) {
        return element.toString ? element.toString() : "";
      }
    };
  }
  /**
   * Create mock DOMParser for SSR
   * @returns {object} DOMParser mock
   */
  createDOMParser() {
    return {
      parseFromString(str, _type) {
        const root = new SSRElement("root");
        root.innerHTML = str;
        return {
          documentElement: root
        };
      }
    };
  }
}
let shim = null;
let xmlSerializerInstance = null;
let domParserInstance = null;
class BrowserAPIs {
  /**
   * Initialize the SSR shim if in SSR environment
   * Must be called before using other methods
   */
  static init() {
    if (Environment.isSSR() && !shim) {
      shim = new SSRDOMShim();
    }
  }
  /**
   * Create an SVG element with namespace
   * @param {string} namespaceURI - Namespace URI
   * @param {string} qualifiedName - Element tag name
   * @returns {Element|SSRElement} SVG element
   */
  static createElementNS(namespaceURI, qualifiedName) {
    if (Environment.isSSR()) {
      if (!shim) this.init();
      return shim.createElementNS(namespaceURI, qualifiedName);
    }
    return document.createElementNS(namespaceURI, qualifiedName);
  }
  /**
   * Create a text node
   * @param {string} data - Text content
   * @returns {Text|object} Text node
   */
  static createTextNode(data) {
    if (Environment.isSSR()) {
      if (!shim) this.init();
      return shim.createTextNode(data);
    }
    return document.createTextNode(data);
  }
  /**
   * Query selector
   * @param {string} selector - CSS selector
   * @returns {Element|null}
   */
  static querySelector(selector) {
    if (Environment.isSSR()) {
      return null;
    }
    return document.querySelector(selector);
  }
  /**
   * Query selector all
   * @param {string} selector - CSS selector
   * @returns {NodeList|Array}
   */
  static querySelectorAll(selector) {
    if (Environment.isSSR()) {
      return [];
    }
    return document.querySelectorAll(selector);
  }
  /**
   * Get computed style for an element
   * @param {Element} element - Element to get styles for
   * @returns {CSSStyleDeclaration|object}
   */
  static getComputedStyle(element) {
    if (Environment.isSSR()) {
      return {};
    }
    return window.getComputedStyle(element);
  }
  /**
   * Get bounding client rect for an element
   * @param {Element} element - Element to measure
   * @returns {DOMRect|object}
   */
  static getBoundingClientRect(element) {
    if (Environment.isSSR()) {
      if (!shim) this.init();
      return shim.getBoundingClientRect(element);
    }
    return element ? element.getBoundingClientRect() : {
      width: 0,
      height: 0,
      top: 0,
      left: 0,
      right: 0,
      bottom: 0,
      x: 0,
      y: 0
    };
  }
  /**
   * Get XMLSerializer instance
   * @returns {XMLSerializer|object}
   */
  static getXMLSerializer() {
    if (Environment.isSSR()) {
      if (!shim) this.init();
      if (!xmlSerializerInstance) {
        xmlSerializerInstance = shim.createXMLSerializer();
      }
      return xmlSerializerInstance;
    }
    if (!xmlSerializerInstance) {
      xmlSerializerInstance = new XMLSerializer();
    }
    return xmlSerializerInstance;
  }
  /**
   * Get DOMParser instance
   * @returns {DOMParser|object}
   */
  static getDOMParser() {
    if (Environment.isSSR()) {
      if (!shim) this.init();
      if (!domParserInstance) {
        domParserInstance = shim.createDOMParser();
      }
      return domParserInstance;
    }
    if (!domParserInstance) {
      domParserInstance = new DOMParser();
    }
    return domParserInstance;
  }
  /**
   * Add event listener to window
   * @param {string} event - Event name
   * @param {Function} handler - Event handler
   * @param {object} options - Event options
   */
  static addWindowEventListener(event, handler, options2) {
    if (Environment.isBrowser()) {
      window.addEventListener(event, handler, options2);
    }
  }
  /**
   * Remove event listener from window
   * @param {string} event - Event name
   * @param {Function} handler - Event handler
   * @param {object} options - Event options
   */
  static removeWindowEventListener(event, handler, options2) {
    if (Environment.isBrowser()) {
      window.removeEventListener(event, handler, options2);
    }
  }
  /**
   * Request animation frame
   * @param {Function} callback - Callback function
   * @returns {number|null}
   */
  static requestAnimationFrame(callback) {
    if (Environment.isBrowser()) {
      return window.requestAnimationFrame(callback);
    }
    callback();
    return null;
  }
  /**
   * Cancel animation frame
   * @param {number} id - Animation frame ID
   */
  static cancelAnimationFrame(id) {
    if (Environment.isBrowser() && id) {
      window.cancelAnimationFrame(id);
    }
  }
  /**
   * Check if element exists
   * @param {Element} element - Element to check
   * @returns {boolean}
   */
  static elementExists(element) {
    if (!element) return false;
    if (Environment.isSSR()) {
      return element._ssrMode === true || element.nodeName !== void 0;
    }
    return element.getRootNode ? element.getRootNode({ composed: true }) === document || element.isConnected : false;
  }
  /**
   * Get window object (or null in SSR)
   * @returns {Window|null}
   */
  static getWindow() {
    return Environment.isBrowser() ? window : null;
  }
  /**
   * Get document object (or null in SSR)
   * @returns {Document|null}
   */
  static getDocument() {
    return Environment.isBrowser() ? document : null;
  }
  /**
   * Get the shim instance (for testing purposes)
   * @returns {SSRDOMShim|null}
   */
  static _getShim() {
    return shim;
  }
  /**
   * Reset the shim instance (for testing purposes)
   */
  static _resetShim() {
    shim = null;
    xmlSerializerInstance = null;
    domParserInstance = null;
  }
}
let Utils$1 = class Utils {
  static bind(fn, me) {
    return function() {
      return fn.apply(me, arguments);
    };
  }
  static isObject(item) {
    return item && typeof item === "object" && !Array.isArray(item);
  }
  // Type checking that works across different window objects
  static is(type, val) {
    return Object.prototype.toString.call(val) === "[object " + type + "]";
  }
  static isSafari() {
    return /^((?!chrome|android).)*safari/i.test(navigator.userAgent);
  }
  static listToArray(list) {
    let i, array = [];
    for (i = 0; i < list.length; i++) {
      array[i] = list[i];
    }
    return array;
  }
  // to extend defaults with user options
  // credit: http://stackoverflow.com/questions/27936772/deep-object-merging-in-es6-es7#answer-34749873
  static extend(target, source) {
    if (typeof Object.assign !== "function") {
      (function() {
        Object.assign = function(target2) {
          if (target2 === void 0 || target2 === null) {
            throw new TypeError("Cannot convert undefined or null to object");
          }
          let output2 = Object(target2);
          for (let index2 = 1; index2 < arguments.length; index2++) {
            let source2 = arguments[index2];
            if (source2 !== void 0 && source2 !== null) {
              for (let nextKey in source2) {
                if (Object.prototype.hasOwnProperty.call(source2, nextKey)) {
                  output2[nextKey] = source2[nextKey];
                }
              }
            }
          }
          return output2;
        };
      })();
    }
    let output = Object.assign({}, target);
    if (this.isObject(target) && this.isObject(source)) {
      Object.keys(source).forEach((key) => {
        if (this.isObject(source[key])) {
          if (!(key in target)) {
            Object.assign(output, {
              [key]: source[key]
            });
          } else {
            output[key] = this.extend(target[key], source[key]);
          }
        } else {
          Object.assign(output, {
            [key]: source[key]
          });
        }
      });
    }
    return output;
  }
  static extendArray(arrToExtend, resultArr) {
    let extendedArr = [];
    arrToExtend.map((item) => {
      extendedArr.push(Utils.extend(resultArr, item));
    });
    arrToExtend = extendedArr;
    return arrToExtend;
  }
  // If month counter exceeds 12, it starts again from 1
  static monthMod(month) {
    return month % 12;
  }
  /**
   * clone object with optional shallow copy for performance
   * @param {*} source - Source object to clone
   * @param {WeakMap} visited - Circular reference tracker
   * @param {boolean} shallow - If true, performs shallow copy (default: false)
   * @returns {*} Cloned object
   */
  static clone(source, visited = /* @__PURE__ */ new WeakMap(), shallow = false) {
    if (source === null || typeof source !== "object") {
      return source;
    }
    if (visited.has(source)) {
      return visited.get(source);
    }
    let cloneResult;
    if (Array.isArray(source)) {
      if (shallow) {
        cloneResult = source.slice();
      } else {
        cloneResult = [];
        visited.set(source, cloneResult);
        for (let i = 0; i < source.length; i++) {
          cloneResult[i] = this.clone(source[i], visited, false);
        }
      }
    } else if (source instanceof Date) {
      cloneResult = new Date(source.getTime());
    } else {
      if (shallow) {
        cloneResult = Object.assign({}, source);
      } else {
        cloneResult = {};
        visited.set(source, cloneResult);
        for (let prop in source) {
          if (Object.prototype.hasOwnProperty.call(source, prop)) {
            cloneResult[prop] = this.clone(source[prop], visited, false);
          }
        }
      }
    }
    return cloneResult;
  }
  /**
   * Shallow clone for performance when deep clone isn't needed
   * @param {*} source - Source to clone
   * @returns {*} Shallow cloned object
   */
  static shallowClone(source) {
    if (source === null || typeof source !== "object") {
      return source;
    }
    if (Array.isArray(source)) {
      return source.slice();
    }
    return Object.assign({}, source);
  }
  /**
   * Fast shallow equality check for objects
   * @param {Object} obj1 - First object
   * @param {Object} obj2 - Second object
   * @returns {boolean} True if shallowly equal
   */
  static shallowEqual(obj1, obj2) {
    if (obj1 === obj2) return true;
    if (!obj1 || !obj2) return false;
    if (typeof obj1 !== "object" || typeof obj2 !== "object") {
      return obj1 === obj2;
    }
    const keys1 = Object.keys(obj1);
    const keys2 = Object.keys(obj2);
    if (keys1.length !== keys2.length) return false;
    for (let key of keys1) {
      if (obj1[key] !== obj2[key]) return false;
    }
    return true;
  }
  static log10(x) {
    return Math.log(x) / Math.LN10;
  }
  static roundToBase10(x) {
    return Math.pow(10, Math.floor(Math.log10(x)));
  }
  static roundToBase(x, base) {
    return Math.pow(base, Math.floor(Math.log(x) / Math.log(base)));
  }
  static parseNumber(val) {
    if (typeof val === "number" || val === null) return val;
    return parseFloat(val);
  }
  static stripNumber(num, precision = 2) {
    return Number.isInteger(num) ? num : parseFloat(num.toPrecision(precision));
  }
  static randomId() {
    return (Math.random() + 1).toString(36).substring(4);
  }
  static noExponents(num) {
    if (num.toString().includes("e")) {
      return Math.round(num);
    }
    return num;
  }
  static elementExists(element) {
    if (!element || !element.isConnected) {
      return false;
    }
    return true;
  }
  /**
   * detects if an element is inside a Shadow DOM
   */
  static isInShadowDOM(el) {
    if (!el || !el.getRootNode) {
      return false;
    }
    const rootNode = el.getRootNode();
    return rootNode && rootNode !== document && Utils.is("ShadowRoot", rootNode);
  }
  /**
   * gets the shadow root host element
   */
  static getShadowRootHost(el) {
    if (!Utils.isInShadowDOM(el)) {
      return null;
    }
    const rootNode = el.getRootNode();
    return rootNode.host || null;
  }
  static getDimensions(el) {
    if (!el) return [0, 0];
    if (Environment.isSSR()) {
      return [el._ssrWidth || 400, el._ssrHeight || 300];
    }
    const rootNode = el.getRootNode && el.getRootNode();
    const inShadowDOM = rootNode && rootNode !== document;
    if (inShadowDOM && rootNode.host) {
      const hostRect = rootNode.host.getBoundingClientRect();
      return [hostRect.width, hostRect.height];
    }
    let computedStyle;
    try {
      computedStyle = getComputedStyle(el, null);
    } catch (e) {
      return [el.clientWidth || 0, el.clientHeight || 0];
    }
    let elementHeight = el.clientHeight;
    let elementWidth = el.clientWidth;
    elementHeight -= parseFloat(computedStyle.paddingTop) + parseFloat(computedStyle.paddingBottom);
    elementWidth -= parseFloat(computedStyle.paddingLeft) + parseFloat(computedStyle.paddingRight);
    return [elementWidth, elementHeight];
  }
  static getBoundingClientRect(element) {
    if (!element) {
      return {
        top: 0,
        right: 0,
        bottom: 0,
        left: 0,
        width: 0,
        height: 0,
        x: 0,
        y: 0
      };
    }
    if (Environment.isSSR()) {
      return BrowserAPIs.getBoundingClientRect(element);
    }
    const rect = element.getBoundingClientRect();
    return {
      top: rect.top,
      right: rect.right,
      bottom: rect.bottom,
      left: rect.left,
      width: element.clientWidth,
      height: element.clientHeight,
      x: rect.left,
      y: rect.top
    };
  }
  static getLargestStringFromArr(arr) {
    return arr.reduce((a, b) => {
      if (Array.isArray(b)) {
        b = b.reduce((aa, bb) => aa.length > bb.length ? aa : bb);
      }
      return a.length > b.length ? a : b;
    }, 0);
  }
  // http://stackoverflow.com/questions/5623838/rgb-to-hex-and-hex-to-rgb#answer-12342275
  static hexToRgba(hex = "#999999", opacity = 0.6) {
    if (hex.substring(0, 1) !== "#") {
      hex = "#999999";
    }
    let h2 = hex.replace("#", "");
    h2 = h2.match(new RegExp("(.{" + h2.length / 3 + "})", "g"));
    for (let i = 0; i < h2.length; i++) {
      h2[i] = parseInt(h2[i].length === 1 ? h2[i] + h2[i] : h2[i], 16);
    }
    if (typeof opacity !== "undefined") h2.push(opacity);
    return "rgba(" + h2.join(",") + ")";
  }
  static getOpacityFromRGBA(rgba) {
    return parseFloat(rgba.replace(/^.*,(.+)\)/, "$1"));
  }
  static rgb2hex(rgb) {
    rgb = rgb.match(
      /^rgba?[\s+]?\([\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?/i
    );
    return rgb && rgb.length === 4 ? "#" + ("0" + parseInt(rgb[1], 10).toString(16)).slice(-2) + ("0" + parseInt(rgb[2], 10).toString(16)).slice(-2) + ("0" + parseInt(rgb[3], 10).toString(16)).slice(-2) : "";
  }
  shadeRGBColor(percent, color) {
    let f = color.split(","), t = percent < 0 ? 0 : 255, p = percent < 0 ? percent * -1 : percent, R = parseInt(f[0].slice(4), 10), G = parseInt(f[1], 10), B = parseInt(f[2], 10);
    return "rgb(" + (Math.round((t - R) * p) + R) + "," + (Math.round((t - G) * p) + G) + "," + (Math.round((t - B) * p) + B) + ")";
  }
  shadeHexColor(percent, color) {
    let f = parseInt(color.slice(1), 16), t = percent < 0 ? 0 : 255, p = percent < 0 ? percent * -1 : percent, R = f >> 16, G = f >> 8 & 255, B = f & 255;
    return "#" + (16777216 + (Math.round((t - R) * p) + R) * 65536 + (Math.round((t - G) * p) + G) * 256 + (Math.round((t - B) * p) + B)).toString(16).slice(1);
  }
  // beautiful color shading blending code
  // http://stackoverflow.com/questions/5560248/programmatically-lighten-or-darken-a-hex-color-or-rgb-and-blend-colors
  shadeColor(p, color) {
    if (Utils.isColorHex(color)) {
      return this.shadeHexColor(p, color);
    } else {
      return this.shadeRGBColor(p, color);
    }
  }
  static isColorHex(color) {
    return /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)|(^#[0-9A-F]{8}$)/i.test(color);
  }
  static isCSSVariable(color) {
    if (typeof color !== "string") return false;
    const value = color.trim();
    return value.startsWith("var(") && value.endsWith(")");
  }
  static getThemeColor(color) {
    if (!Utils.isCSSVariable(color)) return color;
    const tempElem = document.createElement("div");
    tempElem.style.cssText = "position:fixed; left: -9999px; visibility:hidden;";
    tempElem.style.color = color;
    document.body.appendChild(tempElem);
    let computedColor;
    try {
      computedColor = window.getComputedStyle(tempElem).color;
    } finally {
      if (tempElem.parentNode) {
        tempElem.parentNode.removeChild(tempElem);
      }
    }
    return computedColor;
  }
  static getPolygonPos(size, dataPointsLen) {
    let dotsArray = [];
    let angle = Math.PI * 2 / dataPointsLen;
    for (let i = 0; i < dataPointsLen; i++) {
      let curPos = {};
      curPos.x = size * Math.sin(i * angle);
      curPos.y = -size * Math.cos(i * angle);
      dotsArray.push(curPos);
    }
    return dotsArray;
  }
  static polarToCartesian(centerX, centerY, radius, angleInDegrees) {
    let angleInRadians = (angleInDegrees - 90) * Math.PI / 180;
    return {
      x: centerX + radius * Math.cos(angleInRadians),
      y: centerY + radius * Math.sin(angleInRadians)
    };
  }
  static escapeString(str, escapeWith = "x") {
    let newStr = str.toString().slice();
    newStr = newStr.replace(
      /[` ~!@#$%^&*()|+=?;:'",.<>{}[\]\\/]/gi,
      escapeWith
    );
    return newStr;
  }
  static negToZero(val) {
    return val < 0 ? 0 : val;
  }
  static moveIndexInArray(arr, old_index, new_index) {
    if (new_index >= arr.length) {
      let k = new_index - arr.length + 1;
      while (k--) {
        arr.push(void 0);
      }
    }
    arr.splice(new_index, 0, arr.splice(old_index, 1)[0]);
    return arr;
  }
  static extractNumber(s) {
    return parseFloat(s.replace(/[^\d.]*/g, ""));
  }
  static findAncestor(el, cls) {
    while ((el = el.parentElement) && !el.classList.contains(cls)) ;
    return el;
  }
  static setELstyles(el, styles) {
    for (let key in styles) {
      if (Object.prototype.hasOwnProperty.call(styles, key)) {
        el.style.key = styles[key];
      }
    }
  }
  // prevents JS prevision errors when adding
  static preciseAddition(a, b) {
    let aDecimals = (String(a).split(".")[1] || "").length;
    let bDecimals = (String(b).split(".")[1] || "").length;
    let factor = Math.pow(10, Math.max(aDecimals, bDecimals));
    return (Math.round(a * factor) + Math.round(b * factor)) / factor;
  }
  static isNumber(value) {
    return !isNaN(value) && parseFloat(Number(value)) === value && !isNaN(parseInt(value, 10));
  }
  static isFloat(n) {
    return Number(n) === n && n % 1 !== 0;
  }
  static isMsEdge() {
    let ua = window.navigator.userAgent;
    let edge = ua.indexOf("Edge/");
    if (edge > 0) {
      return parseInt(ua.substring(edge + 5, ua.indexOf(".", edge)), 10);
    }
    return false;
  }
  //
  // Find the Greatest Common Divisor of two numbers
  //
  static getGCD(a, b, p = 7) {
    let factor = Math.pow(10, p - Math.floor(Math.log10(Math.max(a, b))));
    if (factor > 1) {
      a = Math.round(Math.abs(a) * factor);
      b = Math.round(Math.abs(b) * factor);
    } else {
      factor = 1;
    }
    while (b) {
      let t = b;
      b = a % b;
      a = t;
    }
    return a / factor;
  }
  static getPrimeFactors(n) {
    const factors = [];
    let divisor = 2;
    while (n >= 2) {
      if (n % divisor == 0) {
        factors.push(divisor);
        n = n / divisor;
      } else {
        divisor++;
      }
    }
    return factors;
  }
  static mod(a, b, p = 7) {
    let big = Math.pow(10, p - Math.floor(Math.log10(Math.max(a, b))));
    a = Math.round(Math.abs(a) * big);
    b = Math.round(Math.abs(b) * big);
    return a % b / big;
  }
};
class Animations {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
  }
  animateLine(el, from2, to2, speed) {
    el.attr(from2).animate(speed).attr(to2);
  }
  /*
   ** Animate radius of a circle element
   */
  animateMarker(el, speed, easing, cb) {
    el.attr({
      opacity: 0
    }).animate(speed).attr({
      opacity: 1
    }).after(() => {
      cb();
    });
  }
  /*
   ** Animate rect properties
   */
  animateRect(el, from2, to2, speed, fn) {
    el.attr(from2).animate(speed).attr(to2).after(() => fn());
  }
  animatePathsGradually(params) {
    let { el, realIndex, j, fill, pathFrom, pathTo, speed, delay } = params;
    let me = this;
    let w = this.w;
    let delayFactor = 0;
    if (w.config.chart.animations.animateGradually.enabled) {
      delayFactor = w.config.chart.animations.animateGradually.delay;
    }
    if (w.config.chart.animations.dynamicAnimation.enabled && w.globals.dataChanged && w.config.chart.type !== "bar") {
      delayFactor = 0;
    }
    me.morphSVG(
      el,
      realIndex,
      j,
      w.config.chart.type === "line" && !w.globals.comboCharts ? "stroke" : fill,
      pathFrom,
      pathTo,
      speed,
      delay * delayFactor
    );
  }
  showDelayedElements() {
    this.w.globals.delayedElements.forEach((d) => {
      const ele = d.el;
      ele.classList.remove("apexcharts-element-hidden");
      ele.classList.add("apexcharts-hidden-element-shown");
    });
  }
  animationCompleted(el) {
    const w = this.w;
    if (w.globals.animationEnded) return;
    w.globals.animationEnded = true;
    this.showDelayedElements();
    if (typeof w.config.chart.events.animationEnd === "function") {
      w.config.chart.events.animationEnd(this.ctx, { el, w });
    }
  }
  // SVG.js animation for morphing one path to another
  morphSVG(el, realIndex, j, fill, pathFrom, pathTo, speed, delay) {
    let w = this.w;
    if (!pathFrom) {
      pathFrom = el.attr("pathFrom");
    }
    if (!pathTo) {
      pathTo = el.attr("pathTo");
    }
    const disableAnimationForCorrupPath = () => {
      if (w.config.chart.type === "radar") {
        speed = 1;
      }
      return `M 0 ${w.globals.gridHeight}`;
    };
    if (!pathFrom || pathFrom.indexOf("undefined") > -1 || pathFrom.indexOf("NaN") > -1) {
      pathFrom = disableAnimationForCorrupPath();
    }
    if (!pathTo.trim() || pathTo.indexOf("undefined") > -1 || pathTo.indexOf("NaN") > -1) {
      pathTo = disableAnimationForCorrupPath();
    }
    if (!w.globals.shouldAnimate) {
      speed = 1;
    }
    el.plot(pathFrom).animate(1, delay).plot(pathFrom).animate(speed, delay).plot(pathTo).after(() => {
      if (Utils$1.isNumber(j)) {
        if (j === w.globals.series[w.globals.maxValsInArrayIndex].length - 2 && w.globals.shouldAnimate) {
          this.animationCompleted(el);
        }
      } else if (fill !== "none" && w.globals.shouldAnimate) {
        if (!w.globals.comboCharts && realIndex === w.globals.series.length - 1 || w.globals.comboCharts) {
          this.animationCompleted(el);
        }
      }
      this.showDelayedElements();
    });
  }
}
class Filters {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
  }
  // create a re-usable filter which can be appended other filter effects and applied to multiple elements
  getDefaultFilter(el, i) {
    const w = this.w;
    if (el.unfilter) {
      el.unfilter(true);
    }
    if (w.config.chart.dropShadow.enabled) {
      this.dropShadow(el, w.config.chart.dropShadow, i);
    }
  }
  applyFilter(el, i, filterType) {
    var _a, _b, _c;
    const w = this.w;
    if (el.unfilter) {
      el.unfilter(true);
    }
    if (filterType === "none") {
      this.getDefaultFilter(el, i);
      return;
    }
    const shadowAttr = w.config.chart.dropShadow;
    const brightnessFactor = filterType === "lighten" ? 2 : 0.3;
    if (el.filterWith) {
      el.filterWith((add2) => {
        add2.colorMatrix({
          type: "matrix",
          values: `
            ${brightnessFactor} 0 0 0 0
            0 ${brightnessFactor} 0 0 0
            0 0 ${brightnessFactor} 0 0
            0 0 0 1 0
          `,
          in: "SourceGraphic",
          result: "brightness"
        });
        if (shadowAttr.enabled) {
          this.addShadow(add2, i, shadowAttr, "brightness");
        }
      });
      if (!shadowAttr.noUserSpaceOnUse) {
        (_b = (_a = el.filterer()) == null ? void 0 : _a.node) == null ? void 0 : _b.setAttribute("filterUnits", "userSpaceOnUse");
      }
      this._scaleFilterSize((_c = el.filterer()) == null ? void 0 : _c.node);
    }
  }
  // appends dropShadow to the filter object which can be chained with other filter effects
  addShadow(add2, i, attrs, source) {
    var _a;
    const w = this.w;
    let { blur, top, left, color, opacity } = attrs;
    color = Array.isArray(color) ? color[i] : color;
    if (((_a = w.config.chart.dropShadow.enabledOnSeries) == null ? void 0 : _a.length) > 0) {
      if (w.config.chart.dropShadow.enabledOnSeries.indexOf(i) === -1) {
        return add2;
      }
    }
    add2.offset({
      in: source,
      dx: left,
      dy: top,
      result: "offset"
    });
    add2.gaussianBlur({
      in: "offset",
      stdDeviation: blur,
      result: "blur"
    });
    add2.flood({
      "flood-color": color,
      "flood-opacity": opacity,
      result: "flood"
    });
    add2.composite({
      in: "flood",
      in2: "blur",
      operator: "in",
      result: "shadow"
    });
    add2.merge(["shadow", source]);
  }
  // directly adds dropShadow to the element and returns the same element.
  dropShadow(el, attrs, i = 0) {
    var _a, _b, _c, _d, _e;
    const w = this.w;
    if (el.unfilter) {
      el.unfilter(true);
    }
    if (Utils$1.isMsEdge() && w.config.chart.type === "radialBar") {
      return el;
    }
    if (((_a = w.config.chart.dropShadow.enabledOnSeries) == null ? void 0 : _a.length) > 0) {
      if (((_b = w.config.chart.dropShadow.enabledOnSeries) == null ? void 0 : _b.indexOf(i)) === -1) {
        return el;
      }
    }
    if (el.filterWith) {
      el.filterWith((add2) => {
        this.addShadow(add2, i, attrs, "SourceGraphic");
      });
      if (!attrs.noUserSpaceOnUse) {
        (_d = (_c = el.filterer()) == null ? void 0 : _c.node) == null ? void 0 : _d.setAttribute("filterUnits", "userSpaceOnUse");
      }
      this._scaleFilterSize((_e = el.filterer()) == null ? void 0 : _e.node);
    }
    return el;
  }
  setSelectionFilter(el, realIndex, dataPointIndex) {
    const w = this.w;
    if (typeof w.globals.selectedDataPoints[realIndex] !== "undefined") {
      if (w.globals.selectedDataPoints[realIndex].indexOf(dataPointIndex) > -1) {
        el.node.setAttribute("selected", true);
        let activeFilter = w.config.states.active.filter;
        if (activeFilter !== "none") {
          this.applyFilter(el, realIndex, activeFilter.type);
        }
      }
    }
  }
  _scaleFilterSize(el) {
    if (!el) return;
    const setAttributes = (attrs) => {
      for (let key in attrs) {
        if (Object.prototype.hasOwnProperty.call(attrs, key)) {
          el.setAttribute(key, attrs[key]);
        }
      }
    };
    setAttributes({
      width: "200%",
      height: "200%",
      x: "-50%",
      y: "-50%"
    });
  }
}
class Graphics {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
  }
  /*****************************************************************************
   *                                                                            *
   *  SVG Path Rounding Function                                                *
   *  Copyright (C) 2014 Yona Appletree                                         *
   *                                                                            *
   *  Licensed under the Apache License, Version 2.0 (the "License");           *
   *  you may not use this file except in compliance with the License.          *
   *  You may obtain a copy of the License at                                   *
   *                                                                            *
   *      http://www.apache.org/licenses/LICENSE-2.0                            *
   *                                                                            *
   *  Unless required by applicable law or agreed to in writing, software       *
   *  distributed under the License is distributed on an "AS IS" BASIS,         *
   *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  *
   *  See the License for the specific language governing permissions and       *
   *  limitations under the License.                                            *
   *                                                                            *
   *****************************************************************************/
  /**
   * SVG Path rounding function. Takes an input path string and outputs a path
   * string where all line-line corners have been rounded. Only supports absolute
   * commands at the moment.
   *
   * @param pathString The SVG input path
   * @param radius The amount to round the corners, either a value in the SVG
   *               coordinate space, or, if useFractionalRadius is true, a value
   *               from 0 to 1.
   * @returns A new SVG path string with the rounding
   */
  roundPathCorners(pathString, radius) {
    if (pathString.indexOf("NaN") > -1) pathString = "";
    function moveTowardsLength(movingPoint, targetPoint, amount) {
      var width = targetPoint.x - movingPoint.x;
      var height = targetPoint.y - movingPoint.y;
      var distance = Math.sqrt(width * width + height * height);
      return moveTowardsFractional(
        movingPoint,
        targetPoint,
        Math.min(1, amount / distance)
      );
    }
    function moveTowardsFractional(movingPoint, targetPoint, fraction) {
      return {
        x: movingPoint.x + (targetPoint.x - movingPoint.x) * fraction,
        y: movingPoint.y + (targetPoint.y - movingPoint.y) * fraction
      };
    }
    function adjustCommand(cmd, newPoint) {
      if (cmd.length > 2) {
        cmd[cmd.length - 2] = newPoint.x;
        cmd[cmd.length - 1] = newPoint.y;
      }
    }
    function pointForCommand(cmd) {
      return {
        x: parseFloat(cmd[cmd.length - 2]),
        y: parseFloat(cmd[cmd.length - 1])
      };
    }
    var pathParts = pathString.split(/[,\s]/).reduce(function(parts, part) {
      var match = part.match(/^([a-zA-Z])(.+)/);
      if (match) {
        parts.push(match[1]);
        parts.push(match[2]);
      } else {
        parts.push(part);
      }
      return parts;
    }, []);
    var commands = pathParts.reduce(function(commands2, part) {
      if (parseFloat(part) == part && commands2.length) {
        commands2[commands2.length - 1].push(part);
      } else {
        commands2.push([part]);
      }
      return commands2;
    }, []);
    var resultCommands = [];
    if (commands.length > 1) {
      var startPoint = pointForCommand(commands[0]);
      var virtualCloseLine = null;
      if (commands[commands.length - 1][0] == "Z" && commands[0].length > 2) {
        virtualCloseLine = ["L", startPoint.x, startPoint.y];
        commands[commands.length - 1] = virtualCloseLine;
      }
      resultCommands.push(commands[0]);
      for (var cmdIndex = 1; cmdIndex < commands.length; cmdIndex++) {
        var prevCmd = resultCommands[resultCommands.length - 1];
        var curCmd = commands[cmdIndex];
        var nextCmd = curCmd == virtualCloseLine ? commands[1] : commands[cmdIndex + 1];
        if (nextCmd && prevCmd && prevCmd.length > 2 && curCmd[0] == "L" && nextCmd.length > 2 && nextCmd[0] == "L") {
          var prevPoint = pointForCommand(prevCmd);
          var curPoint = pointForCommand(curCmd);
          var nextPoint = pointForCommand(nextCmd);
          var curveStart, curveEnd;
          curveStart = moveTowardsLength(curPoint, prevPoint, radius);
          curveEnd = moveTowardsLength(curPoint, nextPoint, radius);
          adjustCommand(curCmd, curveStart);
          curCmd.origPoint = curPoint;
          resultCommands.push(curCmd);
          var startControl = moveTowardsFractional(curveStart, curPoint, 0.5);
          var endControl = moveTowardsFractional(curPoint, curveEnd, 0.5);
          var curveCmd = [
            "C",
            startControl.x,
            startControl.y,
            endControl.x,
            endControl.y,
            curveEnd.x,
            curveEnd.y
          ];
          curveCmd.origPoint = curPoint;
          resultCommands.push(curveCmd);
        } else {
          resultCommands.push(curCmd);
        }
      }
      if (virtualCloseLine) {
        var newStartPoint = pointForCommand(
          resultCommands[resultCommands.length - 1]
        );
        resultCommands.push(["Z"]);
        adjustCommand(resultCommands[0], newStartPoint);
      }
    } else {
      resultCommands = commands;
    }
    return resultCommands.reduce(function(str, c) {
      return str + c.join(" ") + " ";
    }, "");
  }
  drawLine(x1, y1, x2, y2, lineColor = "#a8a8a8", dashArray = 0, strokeWidth = null, strokeLineCap = "butt") {
    let w = this.w;
    let line = w.globals.dom.Paper.line().attr({
      x1,
      y1,
      x2,
      y2,
      stroke: lineColor,
      "stroke-dasharray": dashArray,
      "stroke-width": strokeWidth,
      "stroke-linecap": strokeLineCap
    });
    return line;
  }
  drawRect(x1 = 0, y1 = 0, x2 = 0, y2 = 0, radius = 0, color = "#fefefe", opacity = 1, strokeWidth = null, strokeColor = null, strokeDashArray = 0) {
    let w = this.w;
    let rect = w.globals.dom.Paper.rect();
    rect.attr({
      x: x1,
      y: y1,
      width: x2 > 0 ? x2 : 0,
      height: y2 > 0 ? y2 : 0,
      rx: radius,
      ry: radius,
      opacity,
      "stroke-width": strokeWidth !== null ? strokeWidth : 0,
      stroke: strokeColor !== null ? strokeColor : "none",
      "stroke-dasharray": strokeDashArray
    });
    rect.node.setAttribute("fill", color);
    return rect;
  }
  drawPolygon(polygonString, stroke = "#e1e1e1", strokeWidth = 1, fill = "none") {
    const w = this.w;
    const polygon = w.globals.dom.Paper.polygon(polygonString).attr({
      fill,
      stroke,
      "stroke-width": strokeWidth
    });
    return polygon;
  }
  drawCircle(radius, attrs = null) {
    const w = this.w;
    if (radius < 0) radius = 0;
    const c = w.globals.dom.Paper.circle(radius * 2);
    if (attrs !== null) {
      c.attr(attrs);
    }
    return c;
  }
  drawPath({
    d = "",
    stroke = "#a8a8a8",
    strokeWidth = 1,
    fill,
    fillOpacity = 1,
    strokeOpacity = 1,
    classes,
    strokeLinecap = null,
    strokeDashArray = 0
  }) {
    let w = this.w;
    if (strokeLinecap === null) {
      strokeLinecap = w.config.stroke.lineCap;
    }
    if (d.indexOf("undefined") > -1 || d.indexOf("NaN") > -1) {
      d = `M 0 ${w.globals.gridHeight}`;
    }
    let p = w.globals.dom.Paper.path(d).attr({
      fill,
      "fill-opacity": fillOpacity,
      stroke,
      "stroke-opacity": strokeOpacity,
      "stroke-linecap": strokeLinecap,
      "stroke-width": strokeWidth,
      "stroke-dasharray": strokeDashArray,
      class: classes
    });
    return p;
  }
  group(attrs = null) {
    const w = this.w;
    const g = w.globals.dom.Paper.group();
    if (attrs !== null) {
      g.attr(attrs);
    }
    return g;
  }
  move(x, y) {
    let move = ["M", x, y].join(" ");
    return move;
  }
  line(x, y, hORv = null) {
    let line = null;
    if (hORv === null) {
      line = [" L", x, y].join(" ");
    } else if (hORv === "H") {
      line = [" H", x].join(" ");
    } else if (hORv === "V") {
      line = [" V", y].join(" ");
    }
    return line;
  }
  curve(x1, y1, x2, y2, x, y) {
    let curve = ["C", x1, y1, x2, y2, x, y].join(" ");
    return curve;
  }
  quadraticCurve(x1, y1, x, y) {
    let curve = ["Q", x1, y1, x, y].join(" ");
    return curve;
  }
  arc(rx, ry, axisRotation, largeArcFlag, sweepFlag, x, y, relative = false) {
    let coord = "A";
    if (relative) coord = "a";
    let arc = [coord, rx, ry, axisRotation, largeArcFlag, sweepFlag, x, y].join(
      " "
    );
    return arc;
  }
  /**
   * @memberof Graphics
   * @param {object}
   *  i = series's index
   *  realIndex = realIndex is series's actual index when it was drawn time. After several redraws, the iterating "i" may change in loops, but realIndex doesn't
   *  pathFrom = existing pathFrom to animateTo
   *  pathTo = new Path to which d attr will be animated from pathFrom to pathTo
   *  stroke = line Color
   *  strokeWidth = width of path Line
   *  fill = it can be gradient, single color, pattern or image
   *  animationDelay = how much to delay when starting animation (in milliseconds)
   *  dataChangeSpeed = for dynamic animations, when data changes
   *  className = class attribute to add
   * @return {object} svg.js path object
   **/
  renderPaths({
    j,
    realIndex,
    pathFrom,
    pathTo,
    stroke,
    strokeWidth,
    strokeLinecap,
    fill,
    animationDelay,
    initialSpeed,
    dataChangeSpeed,
    className,
    chartType,
    shouldClipToGrid = true,
    bindEventsOnPaths = true,
    drawShadow = true
  }) {
    let w = this.w;
    const filters = new Filters(this.ctx);
    const anim = new Animations(this.ctx);
    let initialAnim = this.w.config.chart.animations.enabled;
    let dynamicAnim = initialAnim && this.w.config.chart.animations.dynamicAnimation.enabled;
    if (pathFrom && pathFrom.startsWith("M 0 0") && pathTo) {
      const moveCommand = pathTo.match(/^M\s+[\d.-]+\s+[\d.-]+/);
      if (moveCommand) {
        pathFrom = pathFrom.replace(/^M\s+0\s+0/, moveCommand[0]);
      }
    }
    let d;
    let shouldAnimate = !!(initialAnim && !w.globals.resized || dynamicAnim && w.globals.dataChanged && w.globals.shouldAnimate);
    if (shouldAnimate) {
      d = pathFrom;
    } else {
      d = pathTo;
      w.globals.animationEnded = true;
    }
    let strokeDashArrayOpt = w.config.stroke.dashArray;
    let strokeDashArray = 0;
    if (Array.isArray(strokeDashArrayOpt)) {
      strokeDashArray = strokeDashArrayOpt[realIndex];
    } else {
      strokeDashArray = w.config.stroke.dashArray;
    }
    let el = this.drawPath({
      d,
      stroke,
      strokeWidth,
      fill,
      fillOpacity: 1,
      classes: className,
      strokeLinecap,
      strokeDashArray
    });
    el.attr("index", realIndex);
    if (shouldClipToGrid) {
      if (chartType === "bar" && !w.globals.isHorizontal || w.globals.comboCharts) {
        el.attr({
          "clip-path": `url(#gridRectBarMask${w.globals.cuid})`
        });
      } else {
        el.attr({
          "clip-path": `url(#gridRectMask${w.globals.cuid})`
        });
      }
    }
    if (w.config.chart.dropShadow.enabled && drawShadow) {
      filters.dropShadow(el, w.config.chart.dropShadow, realIndex);
    }
    if (bindEventsOnPaths) {
      el.node.addEventListener("mouseenter", this.pathMouseEnter.bind(this, el));
      el.node.addEventListener("mouseleave", this.pathMouseLeave.bind(this, el));
      el.node.addEventListener("mousedown", this.pathMouseDown.bind(this, el));
    }
    el.attr({
      pathTo,
      pathFrom
    });
    const defaultAnimateOpts = {
      el,
      j,
      realIndex,
      pathFrom,
      pathTo,
      fill,
      strokeWidth,
      delay: animationDelay
    };
    if (initialAnim && !w.globals.resized && !w.globals.dataChanged) {
      anim.animatePathsGradually(__spreadProps(__spreadValues({}, defaultAnimateOpts), {
        speed: initialSpeed
      }));
    } else {
      if (w.globals.resized || !w.globals.dataChanged) {
        anim.showDelayedElements();
      }
    }
    if (w.globals.dataChanged && dynamicAnim && shouldAnimate) {
      anim.animatePathsGradually(__spreadProps(__spreadValues({}, defaultAnimateOpts), {
        speed: dataChangeSpeed
      }));
    }
    return el;
  }
  drawPattern(style, width, height, stroke = "#a8a8a8", strokeWidth = 0) {
    let w = this.w;
    let p = w.globals.dom.Paper.pattern(width, height, (add2) => {
      if (style === "horizontalLines") {
        add2.line(0, 0, height, 0).stroke({ color: stroke, width: strokeWidth + 1 });
      } else if (style === "verticalLines") {
        add2.line(0, 0, 0, width).stroke({ color: stroke, width: strokeWidth + 1 });
      } else if (style === "slantedLines") {
        add2.line(0, 0, width, height).stroke({ color: stroke, width: strokeWidth });
      } else if (style === "squares") {
        add2.rect(width, height).fill("none").stroke({ color: stroke, width: strokeWidth });
      } else if (style === "circles") {
        add2.circle(width).fill("none").stroke({ color: stroke, width: strokeWidth });
      }
    });
    return p;
  }
  drawGradient(style, gfrom, gto, opacityFrom, opacityTo, size = null, stops = null, colorStops = [], i = 0) {
    let w = this.w;
    let g;
    if (gfrom.length < 9 && gfrom.indexOf("#") === 0) {
      gfrom = Utils$1.hexToRgba(gfrom, opacityFrom);
    }
    if (gto.length < 9 && gto.indexOf("#") === 0) {
      gto = Utils$1.hexToRgba(gto, opacityTo);
    }
    let stop1 = 0;
    let stop2 = 1;
    let stop3 = 1;
    let stop4 = null;
    if (stops !== null) {
      stop1 = typeof stops[0] !== "undefined" ? stops[0] / 100 : 0;
      stop2 = typeof stops[1] !== "undefined" ? stops[1] / 100 : 1;
      stop3 = typeof stops[2] !== "undefined" ? stops[2] / 100 : 1;
      stop4 = typeof stops[3] !== "undefined" ? stops[3] / 100 : null;
    }
    let radial = !!(w.config.chart.type === "donut" || w.config.chart.type === "pie" || w.config.chart.type === "polarArea" || w.config.chart.type === "bubble");
    if (!colorStops || colorStops.length === 0) {
      g = w.globals.dom.Paper.gradient(radial ? "radial" : "linear", (add2) => {
        add2.stop(stop1, gfrom, opacityFrom);
        add2.stop(stop2, gto, opacityTo);
        add2.stop(stop3, gto, opacityTo);
        if (stop4 !== null) {
          add2.stop(stop4, gfrom, opacityFrom);
        }
      });
    } else {
      g = w.globals.dom.Paper.gradient(radial ? "radial" : "linear", (add2) => {
        let gradientStops = Array.isArray(colorStops[i]) ? colorStops[i] : colorStops;
        gradientStops.forEach((s) => {
          add2.stop(s.offset / 100, s.color, s.opacity);
        });
      });
    }
    if (!radial) {
      if (style === "vertical") {
        g.from(0, 0).to(0, 1);
      } else if (style === "diagonal") {
        g.from(0, 0).to(1, 1);
      } else if (style === "horizontal") {
        g.from(0, 1).to(1, 1);
      } else if (style === "diagonal2") {
        g.from(1, 0).to(0, 1);
      }
    } else {
      let offx = w.globals.gridWidth / 2;
      let offy = w.globals.gridHeight / 2;
      if (w.config.chart.type !== "bubble") {
        g.attr({
          gradientUnits: "userSpaceOnUse",
          cx: offx,
          cy: offy,
          r: size
        });
      } else {
        g.attr({
          cx: 0.5,
          cy: 0.5,
          r: 0.8,
          fx: 0.2,
          fy: 0.2
        });
      }
    }
    return g;
  }
  getTextBasedOnMaxWidth({ text, maxWidth, fontSize, fontFamily }) {
    const tRects = this.getTextRects(text, fontSize, fontFamily);
    const wordWidth = tRects.width / text.length;
    const wordsBasedOnWidth = Math.floor(maxWidth / wordWidth);
    if (maxWidth < tRects.width) {
      return text.slice(0, wordsBasedOnWidth - 3) + "...";
    }
    return text;
  }
  drawText({
    x,
    y,
    text,
    textAnchor,
    fontSize,
    fontFamily,
    fontWeight,
    foreColor,
    opacity,
    maxWidth,
    cssClass = "",
    isPlainText = true,
    dominantBaseline = "auto"
  }) {
    let w = this.w;
    if (typeof text === "undefined") text = "";
    let truncatedText = text;
    if (!textAnchor) {
      textAnchor = "start";
    }
    if (!foreColor || !foreColor.length) {
      foreColor = w.config.chart.foreColor;
    }
    fontFamily = fontFamily || w.config.chart.fontFamily;
    fontSize = fontSize || "11px";
    fontWeight = fontWeight || "regular";
    const commonProps = {
      maxWidth,
      fontSize,
      fontFamily
    };
    let elText;
    if (Array.isArray(text)) {
      elText = w.globals.dom.Paper.text((add2) => {
        for (let i = 0; i < text.length; i++) {
          truncatedText = text[i];
          if (maxWidth) {
            truncatedText = this.getTextBasedOnMaxWidth(__spreadValues({
              text: text[i]
            }, commonProps));
          }
          i === 0 ? add2.tspan(truncatedText) : add2.tspan(truncatedText).newLine();
        }
      });
    } else {
      if (maxWidth) {
        truncatedText = this.getTextBasedOnMaxWidth(__spreadValues({
          text
        }, commonProps));
      }
      elText = isPlainText ? w.globals.dom.Paper.plain(text) : w.globals.dom.Paper.text((add2) => add2.tspan(truncatedText));
    }
    elText.attr({
      x,
      y,
      "text-anchor": textAnchor,
      "dominant-baseline": dominantBaseline,
      "font-size": fontSize,
      "font-family": fontFamily,
      "font-weight": fontWeight,
      fill: foreColor,
      class: "apexcharts-text " + cssClass
    });
    elText.node.style.fontFamily = fontFamily;
    elText.node.style.opacity = opacity;
    return elText;
  }
  getMarkerPath(x, y, type, size) {
    let d = "";
    switch (type) {
      case "cross":
        size = size / 1.4;
        d = `M ${x - size} ${y - size} L ${x + size} ${y + size}  M ${x - size} ${y + size} L ${x + size} ${y - size}`;
        break;
      case "plus":
        size = size / 1.12;
        d = `M ${x - size} ${y} L ${x + size} ${y}  M ${x} ${y - size} L ${x} ${y + size}`;
        break;
      case "star":
      case "sparkle": {
        let points = 5;
        size = size * 1.15;
        if (type === "sparkle") {
          size = size / 1.1;
          points = 4;
        }
        const step = Math.PI / points;
        for (let i = 0; i <= 2 * points; i++) {
          const angle = i * step;
          const radius = i % 2 === 0 ? size : size / 2;
          const xPos = x + radius * Math.sin(angle);
          const yPos = y - radius * Math.cos(angle);
          d += (i === 0 ? "M" : "L") + xPos + "," + yPos;
        }
        d += "Z";
        break;
      }
      case "triangle":
        d = `M ${x} ${y - size} 
             L ${x + size} ${y + size} 
             L ${x - size} ${y + size} 
             Z`;
        break;
      case "square":
      case "rect":
        size = size / 1.125;
        d = `M ${x - size} ${y - size} 
           L ${x + size} ${y - size} 
           L ${x + size} ${y + size} 
           L ${x - size} ${y + size} 
           Z`;
        break;
      case "diamond":
        size = size * 1.05;
        d = `M ${x} ${y - size} 
             L ${x + size} ${y} 
             L ${x} ${y + size} 
             L ${x - size} ${y} 
            Z`;
        break;
      case "line":
        size = size / 1.1;
        d = `M ${x - size} ${y} 
           L ${x + size} ${y}`;
        break;
      case "circle":
      default:
        size = size * 2;
        d = `M ${x}, ${y} 
           m -${size / 2}, 0 
           a ${size / 2},${size / 2} 0 1,0 ${size},0 
           a ${size / 2},${size / 2} 0 1,0 -${size},0`;
        break;
    }
    return d;
  }
  /**
   * @param {number} x - The x-coordinate of the marker
   * @param {number} y - The y-coordinate of the marker.
   * @param {number} size - The size of the marker
   * @param {Object} opts - The options for the marker.
   * @returns {Object} The created marker.
   */
  drawMarkerShape(x, y, type, size, opts) {
    const path = this.drawPath({
      d: this.getMarkerPath(x, y, type, size, opts),
      stroke: opts.pointStrokeColor,
      strokeDashArray: opts.pointStrokeDashArray,
      strokeWidth: opts.pointStrokeWidth,
      fill: opts.pointFillColor,
      fillOpacity: opts.pointFillOpacity,
      strokeOpacity: opts.pointStrokeOpacity
    });
    path.attr({
      cx: x,
      cy: y,
      shape: opts.shape,
      class: opts.class ? opts.class : ""
    });
    return path;
  }
  drawMarker(x, y, opts) {
    x = x || 0;
    let size = opts.pSize || 0;
    if (!Utils$1.isNumber(y)) {
      size = 0;
      y = 0;
    }
    return this.drawMarkerShape(x, y, opts == null ? void 0 : opts.shape, size, __spreadValues(__spreadValues({}, opts), opts.shape === "line" || opts.shape === "plus" || opts.shape === "cross" ? {
      pointStrokeColor: opts.pointFillColor,
      pointStrokeOpacity: opts.pointFillOpacity
    } : {}));
  }
  pathMouseEnter(path, e) {
    let w = this.w;
    const filters = new Filters(this.ctx);
    const i = parseInt(path.node.getAttribute("index"), 10);
    const j = parseInt(path.node.getAttribute("j"), 10);
    if (typeof w.config.chart.events.dataPointMouseEnter === "function") {
      w.config.chart.events.dataPointMouseEnter(e, this.ctx, {
        seriesIndex: i,
        dataPointIndex: j,
        w
      });
    }
    this.ctx.events.fireEvent("dataPointMouseEnter", [
      e,
      this.ctx,
      { seriesIndex: i, dataPointIndex: j, w }
    ]);
    if (w.config.states.active.filter.type !== "none") {
      if (path.node.getAttribute("selected") === "true") {
        return;
      }
    }
    if (w.config.states.hover.filter.type !== "none") {
      if (!w.globals.isTouchDevice) {
        let hoverFilter = w.config.states.hover.filter;
        filters.applyFilter(path, i, hoverFilter.type);
      }
    }
  }
  pathMouseLeave(path, e) {
    let w = this.w;
    const filters = new Filters(this.ctx);
    const i = parseInt(path.node.getAttribute("index"), 10);
    const j = parseInt(path.node.getAttribute("j"), 10);
    if (typeof w.config.chart.events.dataPointMouseLeave === "function") {
      w.config.chart.events.dataPointMouseLeave(e, this.ctx, {
        seriesIndex: i,
        dataPointIndex: j,
        w
      });
    }
    this.ctx.events.fireEvent("dataPointMouseLeave", [
      e,
      this.ctx,
      { seriesIndex: i, dataPointIndex: j, w }
    ]);
    if (w.config.states.active.filter.type !== "none") {
      if (path.node.getAttribute("selected") === "true") {
        return;
      }
    }
    if (w.config.states.hover.filter.type !== "none") {
      filters.getDefaultFilter(path, i);
    }
  }
  pathMouseDown(path, e) {
    let w = this.w;
    const filters = new Filters(this.ctx);
    const i = parseInt(path.node.getAttribute("index"), 10);
    const j = parseInt(path.node.getAttribute("j"), 10);
    let selected = "false";
    if (path.node.getAttribute("selected") === "true") {
      path.node.setAttribute("selected", "false");
      if (w.globals.selectedDataPoints[i].indexOf(j) > -1) {
        let index2 = w.globals.selectedDataPoints[i].indexOf(j);
        w.globals.selectedDataPoints[i].splice(index2, 1);
      }
    } else {
      if (!w.config.states.active.allowMultipleDataPointsSelection && w.globals.selectedDataPoints.length > 0) {
        w.globals.selectedDataPoints = [];
        const elPaths = w.globals.dom.Paper.find(
          ".apexcharts-series path:not(.apexcharts-decoration-element)"
        );
        const elCircles = w.globals.dom.Paper.find(
          ".apexcharts-series circle:not(.apexcharts-decoration-element), .apexcharts-series rect:not(.apexcharts-decoration-element)"
        );
        const deSelect = (els) => {
          Array.prototype.forEach.call(els, (el) => {
            el.node.setAttribute("selected", "false");
            filters.getDefaultFilter(el, i);
          });
        };
        deSelect(elPaths);
        deSelect(elCircles);
      }
      path.node.setAttribute("selected", "true");
      selected = "true";
      if (typeof w.globals.selectedDataPoints[i] === "undefined") {
        w.globals.selectedDataPoints[i] = [];
      }
      w.globals.selectedDataPoints[i].push(j);
    }
    if (selected === "true") {
      let activeFilter = w.config.states.active.filter;
      if (activeFilter !== "none") {
        filters.applyFilter(path, i, activeFilter.type);
      } else {
        if (w.config.states.hover.filter !== "none") {
          if (!w.globals.isTouchDevice) {
            let hoverFilter = w.config.states.hover.filter;
            filters.applyFilter(path, i, hoverFilter.type);
          }
        }
      }
    } else {
      if (w.config.states.active.filter.type !== "none") {
        if (w.config.states.hover.filter.type !== "none" && !w.globals.isTouchDevice) {
          let hoverFilter = w.config.states.hover.filter;
          filters.applyFilter(path, i, hoverFilter.type);
        } else {
          filters.getDefaultFilter(path, i);
        }
      }
    }
    if (typeof w.config.chart.events.dataPointSelection === "function") {
      w.config.chart.events.dataPointSelection(e, this.ctx, {
        selectedDataPoints: w.globals.selectedDataPoints,
        seriesIndex: i,
        dataPointIndex: j,
        w
      });
    }
    if (e) {
      this.ctx.events.fireEvent("dataPointSelection", [
        e,
        this.ctx,
        {
          selectedDataPoints: w.globals.selectedDataPoints,
          seriesIndex: i,
          dataPointIndex: j,
          w
        }
      ]);
    }
  }
  rotateAroundCenter(el) {
    let coord = {};
    if (el && typeof el.getBBox === "function") {
      coord = el.getBBox();
    }
    let x = coord.x + coord.width / 2;
    let y = coord.y + coord.height / 2;
    return {
      x,
      y
    };
  }
  /**
   * Sets up event delegation on a parent group element.
   * Uses mouseover/mouseout (which bubble) to simulate mouseenter/mouseleave
   * on matching child elements, reducing per-element listener overhead.
   */
  setupEventDelegation(parentGroup, targetSelector) {
    let currentHovered = null;
    parentGroup.node.addEventListener("mouseover", (e) => {
      const targetNode = Graphics._findDelegateTarget(
        e.target,
        parentGroup.node,
        targetSelector
      );
      if (!targetNode || targetNode === currentHovered) return;
      if (currentHovered && currentHovered.instance) {
        this.pathMouseLeave(currentHovered.instance, e);
      }
      currentHovered = targetNode;
      if (targetNode.instance) {
        this.pathMouseEnter(targetNode.instance, e);
      }
    });
    parentGroup.node.addEventListener("mouseout", (e) => {
      if (!currentHovered) return;
      const relatedNode = e.relatedTarget ? Graphics._findDelegateTarget(
        e.relatedTarget,
        parentGroup.node,
        targetSelector
      ) : null;
      if (relatedNode !== currentHovered) {
        if (currentHovered && currentHovered.instance) {
          this.pathMouseLeave(currentHovered.instance, e);
        }
        currentHovered = null;
      }
    });
    parentGroup.node.addEventListener("mousedown", (e) => {
      const targetNode = Graphics._findDelegateTarget(
        e.target,
        parentGroup.node,
        targetSelector
      );
      if (targetNode && targetNode.instance) {
        this.pathMouseDown(targetNode.instance, e);
      }
    });
  }
  static _findDelegateTarget(node, boundary, selector) {
    while (node && node !== boundary && node !== document) {
      if (node.matches && node.matches(selector)) return node;
      node = node.parentNode;
    }
    return null;
  }
  static setAttrs(el, attrs) {
    for (let key in attrs) {
      if (Object.prototype.hasOwnProperty.call(attrs, key)) {
        el.setAttribute(key, attrs[key]);
      }
    }
  }
  getTextRects(text, fontSize, fontFamily, transform2, useBBox = true) {
    let w = this.w;
    const cacheKey = `${text}|${fontSize}|${fontFamily}|${transform2}|${useBBox}`;
    const cache = w.globals.textRectsCache;
    if (cache && cache.has(cacheKey)) {
      return cache.get(cacheKey);
    }
    let virtualText = this.drawText({
      x: -200,
      y: -200,
      text,
      textAnchor: "start",
      fontSize,
      fontFamily,
      foreColor: "#fff",
      opacity: 0
    });
    if (transform2) {
      virtualText.attr("transform", transform2);
    }
    w.globals.dom.Paper.add(virtualText);
    let rect = virtualText.bbox();
    if (!useBBox) {
      rect = virtualText.node.getBoundingClientRect();
    }
    virtualText.remove();
    const result = {
      width: rect.width,
      height: rect.height
    };
    if (cache) {
      cache.set(cacheKey, result);
    }
    return result;
  }
  /**
   * append ... to long text
   * http://stackoverflow.com/questions/9241315/trimming-text-to-a-given-pixel-width-in-svg
   * @memberof Graphics
   **/
  placeTextWithEllipsis(textObj, textString, width) {
    if (typeof textObj.getComputedTextLength !== "function") return;
    textObj.textContent = textString;
    if (textString.length > 0) {
      if (textObj.getComputedTextLength() >= width / 1.1) {
        for (let x = textString.length - 3; x > 0; x -= 3) {
          if (textObj.getSubStringLength(0, x) <= width / 1.1) {
            textObj.textContent = textString.substring(0, x) + "...";
            return;
          }
        }
        textObj.textContent = ".";
      }
    }
  }
}
class CoreUtils {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
  }
  static checkComboSeries(series, chartType) {
    let comboCharts = false;
    let comboBarCount = 0;
    let comboCount = 0;
    if (chartType === void 0) {
      chartType = "line";
    }
    if (series.length && typeof series[0].type !== "undefined") {
      series.forEach((s) => {
        if (s.type === "bar" || s.type === "column" || s.type === "candlestick" || s.type === "boxPlot") {
          comboBarCount++;
        }
        if (typeof s.type !== "undefined" && s.type !== chartType) {
          comboCount++;
        }
      });
    }
    if (comboCount > 0) {
      comboCharts = true;
    }
    return {
      comboBarCount,
      comboCharts
    };
  }
  /**
   * @memberof CoreUtils
   * returns the sum of all individual values in a multiple stacked series
   * Eg. w.globals.series = [[32,33,43,12], [2,3,5,1]]
   *  @return [34,36,48,13]
   **/
  getStackedSeriesTotals(excludedSeriesIndices = []) {
    const w = this.w;
    let total = [];
    if (w.globals.series.length === 0) return total;
    for (let i = 0; i < w.globals.series[w.globals.maxValsInArrayIndex].length; i++) {
      let t = 0;
      for (let j = 0; j < w.globals.series.length; j++) {
        if (typeof w.globals.series[j][i] !== "undefined" && excludedSeriesIndices.indexOf(j) === -1) {
          t += w.globals.series[j][i];
        }
      }
      total.push(t);
    }
    return total;
  }
  // get total of the all values inside all series
  getSeriesTotalByIndex(index2 = null) {
    if (index2 === null) {
      return this.w.config.series.reduce((acc, cur) => acc + cur, 0);
    } else {
      return this.w.globals.series[index2].reduce((acc, cur) => acc + cur, 0);
    }
  }
  /**
   * @memberof CoreUtils
   * returns the sum of values in a multiple stacked grouped charts
   * Eg. w.globals.series = [[32,33,43,12], [2,3,5,1], [43, 23, 34, 22]]
   * series 1 and 2 are in a group, while series 3 is in another group
   *  @return [[34, 36, 48, 12], [43, 23, 34, 22]]
   **/
  getStackedSeriesTotalsByGroups() {
    const w = this.w;
    let total = [];
    w.globals.seriesGroups.forEach((sg) => {
      let includedIndexes = [];
      w.config.series.forEach((s, si) => {
        if (sg.indexOf(w.globals.seriesNames[si]) > -1) {
          includedIndexes.push(si);
        }
      });
      const excludedIndices = w.globals.series.map((_, fi) => includedIndexes.indexOf(fi) === -1 ? fi : -1).filter((f) => f !== -1);
      total.push(this.getStackedSeriesTotals(excludedIndices));
    });
    return total;
  }
  setSeriesYAxisMappings() {
    const gl = this.w.globals;
    const cnf = this.w.config;
    let axisSeriesMap = [];
    let seriesYAxisReverseMap = [];
    let unassignedSeriesIndices = [];
    let seriesNameArrayStyle = gl.series.length > cnf.yaxis.length || cnf.yaxis.some((a) => Array.isArray(a.seriesName));
    cnf.series.forEach((s, i) => {
      unassignedSeriesIndices.push(i);
      seriesYAxisReverseMap.push(null);
    });
    cnf.yaxis.forEach((yaxe, yi) => {
      axisSeriesMap[yi] = [];
    });
    let unassignedYAxisIndices = [];
    cnf.yaxis.forEach((yaxe, yi) => {
      let assigned = false;
      if (yaxe.seriesName) {
        let seriesNames = [];
        if (Array.isArray(yaxe.seriesName)) {
          seriesNames = yaxe.seriesName;
        } else {
          seriesNames.push(yaxe.seriesName);
        }
        seriesNames.forEach((name2) => {
          cnf.series.forEach((s, si) => {
            if (s.name === name2) {
              let remove = si;
              if (yi === si || seriesNameArrayStyle) {
                if (!seriesNameArrayStyle || unassignedSeriesIndices.indexOf(si) > -1) {
                  axisSeriesMap[yi].push([yi, si]);
                } else {
                  console.warn(
                    "Series '" + s.name + "' referenced more than once in what looks like the new style. That is, when using either seriesName: [], or when there are more series than yaxes."
                  );
                }
              } else {
                axisSeriesMap[si].push([si, yi]);
                remove = yi;
              }
              assigned = true;
              remove = unassignedSeriesIndices.indexOf(remove);
              if (remove !== -1) {
                unassignedSeriesIndices.splice(remove, 1);
              }
            }
          });
        });
      }
      if (!assigned) {
        unassignedYAxisIndices.push(yi);
      }
    });
    axisSeriesMap = axisSeriesMap.map((yaxe) => {
      let ra = [];
      yaxe.forEach((sa) => {
        seriesYAxisReverseMap[sa[1]] = sa[0];
        ra.push(sa[1]);
      });
      return ra;
    });
    let lastUnassignedYAxis = cnf.yaxis.length - 1;
    for (let i = 0; i < unassignedYAxisIndices.length; i++) {
      lastUnassignedYAxis = unassignedYAxisIndices[i];
      axisSeriesMap[lastUnassignedYAxis] = [];
      if (unassignedSeriesIndices) {
        let si = unassignedSeriesIndices[0];
        unassignedSeriesIndices.shift();
        axisSeriesMap[lastUnassignedYAxis].push(si);
        seriesYAxisReverseMap[si] = lastUnassignedYAxis;
      } else {
        break;
      }
    }
    unassignedSeriesIndices.forEach((i) => {
      axisSeriesMap[lastUnassignedYAxis].push(i);
      seriesYAxisReverseMap[i] = lastUnassignedYAxis;
    });
    gl.seriesYAxisMap = axisSeriesMap.map((x) => x);
    gl.seriesYAxisReverseMap = seriesYAxisReverseMap.map((x) => x);
    gl.seriesYAxisMap.forEach((axisSeries, ai) => {
      axisSeries.forEach((si) => {
        if (cnf.series[si] && cnf.series[si].group === void 0) {
          cnf.series[si].group = "apexcharts-axis-".concat(ai.toString());
        }
      });
    });
  }
  isSeriesNull(index2 = null) {
    let r = [];
    if (index2 === null) {
      r = this.w.config.series.filter((d) => d !== null);
    } else {
      r = this.w.config.series[index2].data.filter((d) => d !== null);
    }
    return r.length === 0;
  }
  seriesHaveSameValues(index2) {
    return this.w.globals.series[index2].every((val, i, arr) => val === arr[0]);
  }
  getCategoryLabels(labels) {
    const w = this.w;
    let catLabels = labels.slice();
    if (w.config.xaxis.convertedCatToNumeric) {
      catLabels = labels.map((i) => {
        return w.config.xaxis.labels.formatter(i - w.globals.minX + 1);
      });
    }
    return catLabels;
  }
  // maxValsInArrayIndex is the index of series[] which has the largest number of items
  getLargestSeries() {
    const w = this.w;
    w.globals.maxValsInArrayIndex = w.globals.series.map((a) => a.length).indexOf(
      Math.max.apply(
        Math,
        w.globals.series.map((a) => a.length)
      )
    );
  }
  getLargestMarkerSize() {
    const w = this.w;
    let size = 0;
    w.globals.markers.size.forEach((m2) => {
      size = Math.max(size, m2);
    });
    if (w.config.markers.discrete && w.config.markers.discrete.length) {
      w.config.markers.discrete.forEach((m2) => {
        size = Math.max(size, m2.size);
      });
    }
    if (size > 0) {
      if (w.config.markers.hover.size > 0) {
        size = w.config.markers.hover.size;
      } else {
        size += w.config.markers.hover.sizeOffset;
      }
    }
    w.globals.markers.largestSize = size;
    return size;
  }
  /**
   * @memberof Core
   * returns the sum of all values in a series
   * Eg. w.globals.series = [[32,33,43,12], [2,3,5,1]]
   *  @return [120, 11]
   **/
  getSeriesTotals() {
    const w = this.w;
    w.globals.seriesTotals = w.globals.series.map((ser) => {
      let total = 0;
      if (Array.isArray(ser)) {
        for (let j = 0; j < ser.length; j++) {
          total += ser[j];
        }
      } else {
        total += ser;
      }
      return total;
    });
  }
  getSeriesTotalsXRange(minX, maxX) {
    const w = this.w;
    const seriesTotalsXRange = w.globals.series.map((ser, index2) => {
      let total = 0;
      for (let j = 0; j < ser.length; j++) {
        if (w.globals.seriesX[index2][j] > minX && w.globals.seriesX[index2][j] < maxX) {
          total += ser[j];
        }
      }
      return total;
    });
    return seriesTotalsXRange;
  }
  /**
   * @memberof CoreUtils
   * returns the percentage value of all individual values which can be used in a 100% stacked series
   * Eg. w.globals.series = [[32, 33, 43, 12], [2, 3, 5, 1]]
   *  @return [[94.11, 91.66, 89.58, 92.30], [5.88, 8.33, 10.41, 7.7]]
   **/
  getPercentSeries() {
    const w = this.w;
    w.globals.seriesPercent = w.globals.series.map((ser) => {
      let seriesPercent = [];
      if (Array.isArray(ser)) {
        for (let j = 0; j < ser.length; j++) {
          let total = w.globals.stackedSeriesTotals[j];
          let percent = 0;
          if (total) {
            percent = 100 * ser[j] / total;
          }
          seriesPercent.push(percent);
        }
      } else {
        const total = w.globals.seriesTotals.reduce((acc, val) => acc + val, 0);
        let percent = 100 * ser / total;
        seriesPercent.push(percent);
      }
      return seriesPercent;
    });
  }
  getCalculatedRatios() {
    let w = this.w;
    let gl = w.globals;
    let yRatio = [];
    let invertedYRatio = 0;
    let xRatio = 0;
    let invertedXRatio = 0;
    let zRatio = 0;
    let baseLineY = [];
    let baseLineInvertedY = 0.1;
    let baseLineX = 0;
    gl.yRange = [];
    if (gl.isMultipleYAxis) {
      for (let i = 0; i < gl.minYArr.length; i++) {
        gl.yRange.push(Math.abs(gl.minYArr[i] - gl.maxYArr[i]));
        baseLineY.push(0);
      }
    } else {
      gl.yRange.push(Math.abs(gl.minY - gl.maxY));
    }
    gl.xRange = Math.abs(gl.maxX - gl.minX);
    gl.zRange = Math.abs(gl.maxZ - gl.minZ);
    for (let i = 0; i < gl.yRange.length; i++) {
      yRatio.push(gl.yRange[i] / gl.gridHeight);
    }
    xRatio = gl.xRange / gl.gridWidth;
    invertedYRatio = gl.yRange / gl.gridWidth;
    invertedXRatio = gl.xRange / gl.gridHeight;
    zRatio = gl.zRange / gl.gridHeight * 16;
    if (!zRatio) {
      zRatio = 1;
    }
    if (gl.minY !== Number.MIN_VALUE && Math.abs(gl.minY) !== 0) {
      gl.hasNegs = true;
    }
    if (w.globals.seriesYAxisReverseMap.length > 0) {
      let scaleBaseLineYScale = (y, i) => {
        let yAxis = w.config.yaxis[w.globals.seriesYAxisReverseMap[i]];
        let sign2 = y < 0 ? -1 : 1;
        y = Math.abs(y);
        if (yAxis.logarithmic) {
          y = this.getBaseLog(yAxis.logBase, y);
        }
        return -sign2 * y / yRatio[i];
      };
      if (gl.isMultipleYAxis) {
        baseLineY = [];
        for (let i = 0; i < yRatio.length; i++) {
          baseLineY.push(scaleBaseLineYScale(gl.minYArr[i], i));
        }
      } else {
        baseLineY = [];
        baseLineY.push(scaleBaseLineYScale(gl.minY, 0));
        if (gl.minY !== Number.MIN_VALUE && Math.abs(gl.minY) !== 0) {
          baseLineInvertedY = -gl.minY / invertedYRatio;
          baseLineX = gl.minX / xRatio;
        }
      }
    } else {
      baseLineY = [];
      baseLineY.push(0);
      baseLineInvertedY = 0;
      baseLineX = 0;
    }
    return {
      yRatio,
      invertedYRatio,
      zRatio,
      xRatio,
      invertedXRatio,
      baseLineInvertedY,
      baseLineY,
      baseLineX
    };
  }
  getLogSeries(series) {
    const w = this.w;
    w.globals.seriesLog = series.map((s, i) => {
      let yAxisIndex = w.globals.seriesYAxisReverseMap[i];
      if (w.config.yaxis[yAxisIndex] && w.config.yaxis[yAxisIndex].logarithmic) {
        return s.map((d) => {
          if (d === null) return null;
          return this.getLogVal(w.config.yaxis[yAxisIndex].logBase, d, i);
        });
      } else {
        return s;
      }
    });
    return w.globals.invalidLogScale ? series : w.globals.seriesLog;
  }
  getLogValAtSeriesIndex(val, seriesIndex) {
    if (val === null) return null;
    const w = this.w;
    let yAxisIndex = w.globals.seriesYAxisReverseMap[seriesIndex];
    if (w.config.yaxis[yAxisIndex] && w.config.yaxis[yAxisIndex].logarithmic) {
      return this.getLogVal(
        w.config.yaxis[yAxisIndex].logBase,
        val,
        seriesIndex
      );
    }
    return val;
  }
  getBaseLog(base, value) {
    return Math.log(value) / Math.log(base);
  }
  getLogVal(b, d, seriesIndex) {
    if (d <= 0) {
      return 0;
    }
    const w = this.w;
    const min_log_val = w.globals.minYArr[seriesIndex] === 0 ? -1 : this.getBaseLog(b, w.globals.minYArr[seriesIndex]);
    const max_log_val = w.globals.maxYArr[seriesIndex] === 0 ? 0 : this.getBaseLog(b, w.globals.maxYArr[seriesIndex]);
    const number_of_height_levels = max_log_val - min_log_val;
    if (d < 1) return d / number_of_height_levels;
    const log_height_value = this.getBaseLog(b, d) - min_log_val;
    return log_height_value / number_of_height_levels;
  }
  getLogYRatios(yRatio) {
    const w = this.w;
    const gl = this.w.globals;
    gl.yLogRatio = yRatio.slice();
    gl.logYRange = gl.yRange.map((_, i) => {
      let yAxisIndex = w.globals.seriesYAxisReverseMap[i];
      if (w.config.yaxis[yAxisIndex] && this.w.config.yaxis[yAxisIndex].logarithmic) {
        let maxY = -Number.MAX_VALUE;
        let minY = Number.MIN_VALUE;
        let range = 1;
        gl.seriesLog.forEach((s, si) => {
          s.forEach((v) => {
            if (w.config.yaxis[si] && w.config.yaxis[si].logarithmic) {
              maxY = Math.max(v, maxY);
              minY = Math.min(v, minY);
            }
          });
        });
        range = Math.pow(gl.yRange[i], Math.abs(minY - maxY) / gl.yRange[i]);
        gl.yLogRatio[i] = range / gl.gridHeight;
        return range;
      }
    });
    return gl.invalidLogScale ? yRatio.slice() : gl.yLogRatio;
  }
  // Some config objects can be array - and we need to extend them correctly
  static extendArrayProps(configInstance, options2, w) {
    var _a, _b;
    if (options2 == null ? void 0 : options2.yaxis) {
      options2 = configInstance.extendYAxis(options2, w);
    }
    if (options2 == null ? void 0 : options2.annotations) {
      if (options2.annotations.yaxis) {
        options2 = configInstance.extendYAxisAnnotations(options2);
      }
      if ((_a = options2 == null ? void 0 : options2.annotations) == null ? void 0 : _a.xaxis) {
        options2 = configInstance.extendXAxisAnnotations(options2);
      }
      if ((_b = options2 == null ? void 0 : options2.annotations) == null ? void 0 : _b.points) {
        options2 = configInstance.extendPointAnnotations(options2);
      }
    }
    return options2;
  }
  // Series of the same group and type can be stacked together distinct from
  // other series of the same type on the same axis.
  drawSeriesByGroup(typeSeries, typeGroups, type, chartClass) {
    let w = this.w;
    let graph = [];
    if (typeSeries.series.length > 0) {
      typeGroups.forEach((gn) => {
        let gs = [];
        let gi = [];
        typeSeries.i.forEach((i, ii) => {
          if (w.config.series[i].group === gn) {
            gs.push(typeSeries.series[ii]);
            gi.push(i);
          }
        });
        gs.length > 0 && graph.push(chartClass.draw(gs, type, gi));
      });
    }
    return graph;
  }
}
let Helpers$4 = class Helpers {
  constructor(annoCtx) {
    this.w = annoCtx.w;
    this.annoCtx = annoCtx;
  }
  setOrientations(anno, annoIndex = null) {
    const w = this.w;
    if (anno.label.orientation === "vertical") {
      const i = annoIndex !== null ? annoIndex : 0;
      const xAnno = w.globals.dom.baseEl.querySelector(
        `.apexcharts-xaxis-annotations .apexcharts-xaxis-annotation-label[rel='${i}']`
      );
      if (xAnno !== null) {
        const xAnnoCoord = xAnno.getBBox();
        xAnno.setAttribute(
          "x",
          parseFloat(xAnno.getAttribute("x")) - xAnnoCoord.height + 4
        );
        const yOffset = anno.label.position === "top" ? xAnnoCoord.width : -xAnnoCoord.width;
        xAnno.setAttribute("y", parseFloat(xAnno.getAttribute("y")) + yOffset);
        const { x, y } = this.annoCtx.graphics.rotateAroundCenter(xAnno);
        xAnno.setAttribute("transform", `rotate(-90 ${x} ${y})`);
      }
    }
  }
  addBackgroundToAnno(annoEl, anno) {
    const w = this.w;
    if (!annoEl || !anno.label.text || !String(anno.label.text).trim()) {
      return null;
    }
    const gridEl = w.globals.dom.baseEl.querySelector(".apexcharts-grid");
    const elGridRect = gridEl.getBoundingClientRect();
    const gridBBox = gridEl.getBBox();
    const zoom = elGridRect.width / gridBBox.width || 1;
    const coords = annoEl.getBoundingClientRect();
    let {
      left: pleft,
      right: pright,
      top: ptop,
      bottom: pbottom
    } = anno.label.style.padding;
    if (anno.label.orientation === "vertical") {
      [ptop, pbottom, pleft, pright] = [pleft, pright, ptop, pbottom];
    }
    const x1 = (coords.left - elGridRect.left) / zoom - pleft;
    const y1 = (coords.top - elGridRect.top) / zoom - ptop;
    const elRect = this.annoCtx.graphics.drawRect(
      x1 - w.globals.barPadForNumericAxis,
      y1,
      coords.width / zoom + pleft + pright,
      coords.height / zoom + ptop + pbottom,
      anno.label.borderRadius,
      anno.label.style.background,
      1,
      anno.label.borderWidth,
      anno.label.borderColor,
      0
    );
    if (anno.id) {
      elRect.node.classList.add(anno.id);
    }
    return elRect;
  }
  annotationsBackground() {
    const w = this.w;
    const add2 = (anno, i, type) => {
      const annoLabel = w.globals.dom.baseEl.querySelector(
        `.apexcharts-${type}-annotations .apexcharts-${type}-annotation-label[rel='${i}']`
      );
      if (annoLabel) {
        const parent = annoLabel.parentNode;
        const elRect = this.addBackgroundToAnno(annoLabel, anno);
        if (elRect) {
          parent.insertBefore(elRect.node, annoLabel);
          if (anno.label.mouseEnter) {
            elRect.node.addEventListener(
              "mouseenter",
              anno.label.mouseEnter.bind(this, anno)
            );
          }
          if (anno.label.mouseLeave) {
            elRect.node.addEventListener(
              "mouseleave",
              anno.label.mouseLeave.bind(this, anno)
            );
          }
          if (anno.label.click) {
            elRect.node.addEventListener(
              "click",
              anno.label.click.bind(this, anno)
            );
          }
        }
      }
    };
    w.config.annotations.xaxis.forEach((anno, i) => add2(anno, i, "xaxis"));
    w.config.annotations.yaxis.forEach((anno, i) => add2(anno, i, "yaxis"));
    w.config.annotations.points.forEach((anno, i) => add2(anno, i, "point"));
  }
  getY1Y2(type, anno) {
    var _a;
    const w = this.w;
    let y = type === "y1" ? anno.y : anno.y2;
    let yP;
    let clipped = false;
    if (this.annoCtx.invertAxis) {
      const labels = w.config.xaxis.convertedCatToNumeric ? w.globals.categoryLabels : w.globals.labels;
      const catIndex = labels.indexOf(y);
      const xLabel = w.globals.dom.baseEl.querySelector(
        `.apexcharts-yaxis-texts-g text:nth-child(${catIndex + 1})`
      );
      yP = xLabel ? parseFloat(xLabel.getAttribute("y")) : (w.globals.gridHeight / labels.length - 1) * (catIndex + 1) - w.globals.barHeight;
      if (anno.seriesIndex !== void 0 && w.globals.barHeight) {
        yP -= w.globals.barHeight / 2 * (w.globals.series.length - 1) - w.globals.barHeight * anno.seriesIndex;
      }
    } else {
      const seriesIndex = w.globals.seriesYAxisMap[anno.yAxisIndex][0];
      const yPos = w.config.yaxis[anno.yAxisIndex].logarithmic ? new CoreUtils(this.annoCtx.ctx).getLogVal(
        w.config.yaxis[anno.yAxisIndex].logBase,
        y,
        seriesIndex
      ) / w.globals.yLogRatio[seriesIndex] : (y - w.globals.minYArr[seriesIndex]) / (w.globals.yRange[seriesIndex] / w.globals.gridHeight);
      yP = w.globals.gridHeight - Math.min(Math.max(yPos, 0), w.globals.gridHeight);
      clipped = yPos > w.globals.gridHeight || yPos < 0;
      if (anno.marker && (anno.y === void 0 || anno.y === null)) {
        yP = 0;
      }
      if ((_a = w.config.yaxis[anno.yAxisIndex]) == null ? void 0 : _a.reversed) {
        yP = yPos;
      }
    }
    if (typeof y === "string" && y.includes("px")) {
      yP = parseFloat(y);
    }
    return { yP, clipped };
  }
  getX1X2(type, anno) {
    const w = this.w;
    const x = type === "x1" ? anno.x : anno.x2;
    const min2 = this.annoCtx.invertAxis ? w.globals.minY : w.globals.minX;
    const max2 = this.annoCtx.invertAxis ? w.globals.maxY : w.globals.maxX;
    const range = this.annoCtx.invertAxis ? w.globals.yRange[0] : w.globals.xRange;
    let clipped = false;
    let xP = this.annoCtx.inversedReversedAxis ? (max2 - x) / (range / w.globals.gridWidth) : (x - min2) / (range / w.globals.gridWidth);
    if ((w.config.xaxis.type === "category" || w.config.xaxis.convertedCatToNumeric) && !this.annoCtx.invertAxis && !w.globals.dataFormatXNumeric) {
      if (!w.config.chart.sparkline.enabled) {
        xP = this.getStringX(x);
      }
    }
    if (typeof x === "string" && x.includes("px")) {
      xP = parseFloat(x);
    }
    if ((x === void 0 || x === null) && anno.marker) {
      xP = w.globals.gridWidth;
    }
    if (anno.seriesIndex !== void 0 && w.globals.barWidth && !this.annoCtx.invertAxis) {
      xP -= w.globals.barWidth / 2 * (w.globals.series.length - 1) - w.globals.barWidth * anno.seriesIndex;
    }
    if (typeof xP !== "number") {
      xP = 0;
      clipped = true;
    }
    if (parseFloat(xP.toFixed(10)) > parseFloat(w.globals.gridWidth.toFixed(10))) {
      xP = w.globals.gridWidth;
      clipped = true;
    } else if (xP < 0) {
      xP = 0;
      clipped = true;
    }
    return { x: xP, clipped };
  }
  getStringX(x) {
    const w = this.w;
    let rX = x;
    if (w.config.xaxis.convertedCatToNumeric && w.globals.categoryLabels.length) {
      x = w.globals.categoryLabels.indexOf(x) + 1;
    }
    const catIndex = w.globals.labels.map((item) => Array.isArray(item) ? item.join(" ") : item).indexOf(x);
    const xLabel = w.globals.dom.baseEl.querySelector(
      `.apexcharts-xaxis-texts-g text:nth-child(${catIndex + 1})`
    );
    if (xLabel) {
      rX = parseFloat(xLabel.getAttribute("x"));
    }
    return rX;
  }
};
class XAnnotations {
  constructor(annoCtx) {
    this.w = annoCtx.w;
    this.annoCtx = annoCtx;
    this.invertAxis = this.annoCtx.invertAxis;
    this.helpers = new Helpers$4(this.annoCtx);
  }
  addXaxisAnnotation(anno, parent, index2) {
    let w = this.w;
    let result = this.helpers.getX1X2("x1", anno);
    let x1 = result.x;
    let clipX1 = result.clipped;
    let clipX2 = true;
    let x2;
    const text = anno.label.text;
    let strokeDashArray = anno.strokeDashArray;
    if (!Utils$1.isNumber(x1)) return;
    if (anno.x2 === null || typeof anno.x2 === "undefined") {
      if (!clipX1) {
        let line = this.annoCtx.graphics.drawLine(
          x1 + anno.offsetX,
          // x1
          0 + anno.offsetY,
          // y1
          x1 + anno.offsetX,
          // x2
          w.globals.gridHeight + anno.offsetY,
          // y2
          anno.borderColor,
          // lineColor
          strokeDashArray,
          //dashArray
          anno.borderWidth
        );
        parent.appendChild(line.node);
        if (anno.id) {
          line.node.classList.add(anno.id);
        }
      }
    } else {
      let result2 = this.helpers.getX1X2("x2", anno);
      x2 = result2.x;
      clipX2 = result2.clipped;
      if (x2 < x1) {
        let temp = x1;
        x1 = x2;
        x2 = temp;
      }
      let rect = this.annoCtx.graphics.drawRect(
        x1 + anno.offsetX,
        // x1
        0 + anno.offsetY,
        // y1
        x2 - x1,
        // x2
        w.globals.gridHeight + anno.offsetY,
        // y2
        0,
        // radius
        anno.fillColor,
        // color
        anno.opacity,
        // opacity,
        1,
        // strokeWidth
        anno.borderColor,
        // strokeColor
        strokeDashArray
        // stokeDashArray
      );
      rect.node.classList.add("apexcharts-annotation-rect");
      rect.attr("clip-path", `url(#gridRectMask${w.globals.cuid})`);
      parent.appendChild(rect.node);
      if (anno.id) {
        rect.node.classList.add(anno.id);
      }
    }
    if (!(clipX1 && clipX2)) {
      let textRects = this.annoCtx.graphics.getTextRects(
        text,
        parseFloat(anno.label.style.fontSize)
      );
      let textY = anno.label.position === "top" ? 4 : anno.label.position === "center" ? w.globals.gridHeight / 2 + (anno.label.orientation === "vertical" ? textRects.width / 2 : 0) : w.globals.gridHeight;
      let elText = this.annoCtx.graphics.drawText({
        x: x1 + anno.label.offsetX,
        y: textY + anno.label.offsetY - (anno.label.orientation === "vertical" ? anno.label.position === "top" ? textRects.width / 2 - 12 : -textRects.width / 2 : 0),
        text,
        textAnchor: anno.label.textAnchor,
        fontSize: anno.label.style.fontSize,
        fontFamily: anno.label.style.fontFamily,
        fontWeight: anno.label.style.fontWeight,
        foreColor: anno.label.style.color,
        cssClass: `apexcharts-xaxis-annotation-label ${anno.label.style.cssClass} ${anno.id ? anno.id : ""}`
      });
      elText.attr({
        rel: index2
      });
      parent.appendChild(elText.node);
      this.annoCtx.helpers.setOrientations(anno, index2);
    }
  }
  drawXAxisAnnotations() {
    let w = this.w;
    let elg = this.annoCtx.graphics.group({
      class: "apexcharts-xaxis-annotations"
    });
    w.config.annotations.xaxis.map((anno, index2) => {
      this.addXaxisAnnotation(anno, elg.node, index2);
    });
    return elg;
  }
}
class DateTime {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
    this.months31 = [1, 3, 5, 7, 8, 10, 12];
    this.months30 = [2, 4, 6, 9, 11];
    this.daysCntOfYear = [0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334];
  }
  isValidDate(date) {
    if (typeof date === "number") {
      return false;
    }
    return !isNaN(this.parseDate(date));
  }
  getTimeStamp(dateStr) {
    if (!Date.parse(dateStr)) {
      return dateStr;
    }
    const utc = this.w.config.xaxis.labels.datetimeUTC;
    return !utc ? new Date(dateStr).getTime() : new Date(new Date(dateStr).toISOString().substr(0, 25)).getTime();
  }
  getDate(timestamp) {
    const utc = this.w.config.xaxis.labels.datetimeUTC;
    return utc ? new Date(new Date(timestamp).toUTCString()) : new Date(timestamp);
  }
  parseDate(dateStr) {
    const parsed = Date.parse(dateStr);
    if (!isNaN(parsed)) {
      return this.getTimeStamp(dateStr);
    }
    let output = Date.parse(dateStr.replace(/-/g, "/").replace(/[a-z]+/gi, " "));
    output = this.getTimeStamp(output);
    return output;
  }
  // This fixes the difference of x-axis labels between chrome/safari
  // Fixes #1726, #1544, #1485, #1255
  parseDateWithTimezone(dateStr) {
    return Date.parse(dateStr.replace(/-/g, "/").replace(/[a-z]+/gi, " "));
  }
  // http://stackoverflow.com/questions/14638018/current-time-formatting-with-javascript#answer-14638191
  formatDate(date, format2) {
    const locale2 = this.w.globals.locale;
    const utc = this.w.config.xaxis.labels.datetimeUTC;
    let MMMM = ["\0", ...locale2.months];
    let MMM = ["", ...locale2.shortMonths];
    let dddd = ["", ...locale2.days];
    let ddd = ["", ...locale2.shortDays];
    function ii(i, len) {
      let s2 = i + "";
      len = len || 2;
      while (s2.length < len) s2 = "0" + s2;
      return s2;
    }
    let y = utc ? date.getUTCFullYear() : date.getFullYear();
    format2 = format2.replace(/(^|[^\\])yyyy+/g, "$1" + y);
    format2 = format2.replace(/(^|[^\\])yy/g, "$1" + y.toString().substr(2, 2));
    format2 = format2.replace(/(^|[^\\])y/g, "$1" + y);
    let M = (utc ? date.getUTCMonth() : date.getMonth()) + 1;
    format2 = format2.replace(/(^|[^\\])MMMM+/g, "$1" + MMMM[0]);
    format2 = format2.replace(/(^|[^\\])MMM/g, "$1" + MMM[0]);
    format2 = format2.replace(/(^|[^\\])MM/g, "$1" + ii(M));
    format2 = format2.replace(/(^|[^\\])M/g, "$1" + M);
    let d = utc ? date.getUTCDate() : date.getDate();
    format2 = format2.replace(/(^|[^\\])dddd+/g, "$1" + dddd[0]);
    format2 = format2.replace(/(^|[^\\])ddd/g, "$1" + ddd[0]);
    format2 = format2.replace(/(^|[^\\])dd/g, "$1" + ii(d));
    format2 = format2.replace(/(^|[^\\])d/g, "$1" + d);
    let H = utc ? date.getUTCHours() : date.getHours();
    format2 = format2.replace(/(^|[^\\])HH+/g, "$1" + ii(H));
    format2 = format2.replace(/(^|[^\\])H/g, "$1" + H);
    let h2 = H > 12 ? H - 12 : H === 0 ? 12 : H;
    format2 = format2.replace(/(^|[^\\])hh+/g, "$1" + ii(h2));
    format2 = format2.replace(/(^|[^\\])h/g, "$1" + h2);
    let m2 = utc ? date.getUTCMinutes() : date.getMinutes();
    format2 = format2.replace(/(^|[^\\])mm+/g, "$1" + ii(m2));
    format2 = format2.replace(/(^|[^\\])m/g, "$1" + m2);
    let s = utc ? date.getUTCSeconds() : date.getSeconds();
    format2 = format2.replace(/(^|[^\\])ss+/g, "$1" + ii(s));
    format2 = format2.replace(/(^|[^\\])s/g, "$1" + s);
    let f = utc ? date.getUTCMilliseconds() : date.getMilliseconds();
    format2 = format2.replace(/(^|[^\\])fff+/g, "$1" + ii(f, 3));
    f = Math.round(f / 10);
    format2 = format2.replace(/(^|[^\\])ff/g, "$1" + ii(f));
    f = Math.round(f / 10);
    format2 = format2.replace(/(^|[^\\])f/g, "$1" + f);
    let T = H < 12 ? "AM" : "PM";
    format2 = format2.replace(/(^|[^\\])TT+/g, "$1" + T);
    format2 = format2.replace(/(^|[^\\])T/g, "$1" + T.charAt(0));
    let t = T.toLowerCase();
    format2 = format2.replace(/(^|[^\\])tt+/g, "$1" + t);
    format2 = format2.replace(/(^|[^\\])t/g, "$1" + t.charAt(0));
    let tz = -date.getTimezoneOffset();
    let K = utc || !tz ? "Z" : tz > 0 ? "+" : "-";
    if (!utc) {
      tz = Math.abs(tz);
      let tzHrs = Math.floor(tz / 60);
      let tzMin = tz % 60;
      K += ii(tzHrs) + ":" + ii(tzMin);
    }
    format2 = format2.replace(/(^|[^\\])K/g, "$1" + K);
    let day = (utc ? date.getUTCDay() : date.getDay()) + 1;
    format2 = format2.replace(new RegExp(dddd[0], "g"), dddd[day]);
    format2 = format2.replace(new RegExp(ddd[0], "g"), ddd[day]);
    format2 = format2.replace(new RegExp(MMMM[0], "g"), MMMM[M]);
    format2 = format2.replace(new RegExp(MMM[0], "g"), MMM[M]);
    format2 = format2.replace(/\\(.)/g, "$1");
    return format2;
  }
  getTimeUnitsfromTimestamp(minX, maxX) {
    let w = this.w;
    if (w.config.xaxis.min !== void 0) {
      minX = w.config.xaxis.min;
    }
    if (w.config.xaxis.max !== void 0) {
      maxX = w.config.xaxis.max;
    }
    const tsMin = this.getDate(minX);
    const tsMax = this.getDate(maxX);
    const minD = this.formatDate(tsMin, "yyyy MM dd HH mm ss fff").split(" ");
    const maxD = this.formatDate(tsMax, "yyyy MM dd HH mm ss fff").split(" ");
    return {
      minMillisecond: parseInt(minD[6], 10),
      maxMillisecond: parseInt(maxD[6], 10),
      minSecond: parseInt(minD[5], 10),
      maxSecond: parseInt(maxD[5], 10),
      minMinute: parseInt(minD[4], 10),
      maxMinute: parseInt(maxD[4], 10),
      minHour: parseInt(minD[3], 10),
      maxHour: parseInt(maxD[3], 10),
      minDate: parseInt(minD[2], 10),
      maxDate: parseInt(maxD[2], 10),
      minMonth: parseInt(minD[1], 10) - 1,
      maxMonth: parseInt(maxD[1], 10) - 1,
      minYear: parseInt(minD[0], 10),
      maxYear: parseInt(maxD[0], 10)
    };
  }
  isLeapYear(year) {
    return year % 4 === 0 && year % 100 !== 0 || year % 400 === 0;
  }
  calculcateLastDaysOfMonth(month, year, subtract2) {
    const days2 = this.determineDaysOfMonths(month, year);
    return days2 - subtract2;
  }
  determineDaysOfYear(year) {
    let days2 = 365;
    if (this.isLeapYear(year)) {
      days2 = 366;
    }
    return days2;
  }
  determineRemainingDaysOfYear(year, month, date) {
    let dayOfYear = this.daysCntOfYear[month] + date;
    if (month > 1 && this.isLeapYear()) dayOfYear++;
    return dayOfYear;
  }
  determineDaysOfMonths(month, year) {
    let days2 = 30;
    month = Utils$1.monthMod(month);
    switch (true) {
      case this.months30.indexOf(month) > -1:
        if (month === 2) {
          if (this.isLeapYear(year)) {
            days2 = 29;
          } else {
            days2 = 28;
          }
        }
        break;
      case this.months31.indexOf(month) > -1:
        days2 = 31;
        break;
      default:
        days2 = 31;
        break;
    }
    return days2;
  }
}
class Formatters {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
    this.tooltipKeyFormat = "dd MMM";
  }
  xLabelFormat(fn, val, timestamp, _opts) {
    let w = this.w;
    if (w.config.xaxis.type === "datetime") {
      if (w.config.xaxis.labels.formatter === void 0) {
        if (w.config.tooltip.x.formatter === void 0) {
          let datetimeObj = new DateTime(this.ctx);
          return datetimeObj.formatDate(
            datetimeObj.getDate(val),
            w.config.tooltip.x.format
          );
        }
      }
    }
    return fn(val, timestamp, _opts);
  }
  defaultGeneralFormatter(val) {
    if (Array.isArray(val)) {
      return val.map((v) => {
        return v;
      });
    } else {
      return val;
    }
  }
  defaultYFormatter(v, yaxe) {
    let w = this.w;
    if (Utils$1.isNumber(v)) {
      if (w.globals.yValueDecimal !== 0) {
        v = v.toFixed(
          yaxe.decimalsInFloat !== void 0 ? yaxe.decimalsInFloat : w.globals.yValueDecimal
        );
      } else {
        const f = v.toFixed(0);
        v = v == f ? f : v.toFixed(1);
      }
    }
    return v;
  }
  setLabelFormatters() {
    let w = this.w;
    w.globals.xaxisTooltipFormatter = (val) => {
      return this.defaultGeneralFormatter(val);
    };
    w.globals.ttKeyFormatter = (val) => {
      return this.defaultGeneralFormatter(val);
    };
    w.globals.ttZFormatter = (val) => {
      return val;
    };
    w.globals.legendFormatter = (val) => {
      return this.defaultGeneralFormatter(val);
    };
    if (w.config.xaxis.labels.formatter !== void 0) {
      w.globals.xLabelFormatter = w.config.xaxis.labels.formatter;
    } else {
      w.globals.xLabelFormatter = (val) => {
        if (Utils$1.isNumber(val)) {
          if (!w.config.xaxis.convertedCatToNumeric && w.config.xaxis.type === "numeric") {
            if (Utils$1.isNumber(w.config.xaxis.decimalsInFloat)) {
              return val.toFixed(w.config.xaxis.decimalsInFloat);
            } else {
              const diff2 = w.globals.maxX - w.globals.minX;
              if (diff2 > 0 && diff2 < 100) {
                return val.toFixed(1);
              }
              return val.toFixed(0);
            }
          }
          if (w.globals.isBarHorizontal) {
            const range = w.globals.maxY - w.globals.minYArr;
            if (range < 4) {
              return val.toFixed(1);
            }
          }
          return val.toFixed(0);
        }
        return val;
      };
    }
    if (typeof w.config.tooltip.x.formatter === "function") {
      w.globals.ttKeyFormatter = w.config.tooltip.x.formatter;
    } else {
      w.globals.ttKeyFormatter = w.globals.xLabelFormatter;
    }
    if (typeof w.config.xaxis.tooltip.formatter === "function") {
      w.globals.xaxisTooltipFormatter = w.config.xaxis.tooltip.formatter;
    }
    if (Array.isArray(w.config.tooltip.y)) {
      w.globals.ttVal = w.config.tooltip.y;
    } else {
      if (w.config.tooltip.y.formatter !== void 0) {
        w.globals.ttVal = w.config.tooltip.y;
      }
    }
    if (w.config.tooltip.z.formatter !== void 0) {
      w.globals.ttZFormatter = w.config.tooltip.z.formatter;
    }
    if (w.config.legend.formatter !== void 0) {
      w.globals.legendFormatter = w.config.legend.formatter;
    }
    w.config.yaxis.forEach((yaxe, i) => {
      if (yaxe.labels.formatter !== void 0) {
        w.globals.yLabelFormatters[i] = yaxe.labels.formatter;
      } else {
        w.globals.yLabelFormatters[i] = (val) => {
          if (!w.globals.xyCharts) return val;
          if (Array.isArray(val)) {
            return val.map((v) => {
              return this.defaultYFormatter(v, yaxe, i);
            });
          } else {
            return this.defaultYFormatter(val, yaxe, i);
          }
        };
      }
    });
    return w.globals;
  }
  heatmapLabelFormatters() {
    const w = this.w;
    if (w.config.chart.type === "heatmap") {
      w.globals.yAxisScale[0].result = w.globals.seriesNames.slice();
      let longest = w.globals.seriesNames.reduce(
        (a, b) => a.length > b.length ? a : b,
        0
      );
      w.globals.yAxisScale[0].niceMax = longest;
      w.globals.yAxisScale[0].niceMin = longest;
    }
  }
}
class AxesUtils {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
  }
  // Based on the formatter function, get the label text and position
  getLabel(labels, timescaleLabels, x, i, drawnLabels = [], fontSize = "12px", isLeafGroup = true) {
    const w = this.w;
    let rawLabel = typeof labels[i] === "undefined" ? "" : labels[i];
    let label = rawLabel;
    let xlbFormatter = w.globals.xLabelFormatter;
    let customFormatter = w.config.xaxis.labels.formatter;
    let isBold = false;
    let xFormat = new Formatters(this.ctx);
    let timestamp = rawLabel;
    if (isLeafGroup) {
      label = xFormat.xLabelFormat(xlbFormatter, rawLabel, timestamp, {
        i,
        dateFormatter: new DateTime(this.ctx).formatDate,
        w
      });
      if (customFormatter !== void 0) {
        label = customFormatter(rawLabel, labels[i], {
          i,
          dateFormatter: new DateTime(this.ctx).formatDate,
          w
        });
      }
    }
    const determineHighestUnit = (unit) => {
      let highestUnit = null;
      timescaleLabels.forEach((t) => {
        if (t.unit === "month") {
          highestUnit = "year";
        } else if (t.unit === "day") {
          highestUnit = "month";
        } else if (t.unit === "hour") {
          highestUnit = "day";
        } else if (t.unit === "minute") {
          highestUnit = "hour";
        }
      });
      return highestUnit === unit;
    };
    if (timescaleLabels.length > 0) {
      isBold = determineHighestUnit(timescaleLabels[i].unit);
      x = timescaleLabels[i].position;
      label = timescaleLabels[i].value;
    } else {
      if (w.config.xaxis.type === "datetime" && customFormatter === void 0) {
        label = "";
      }
    }
    if (typeof label === "undefined") label = "";
    label = Array.isArray(label) ? label : label.toString();
    let graphics = new Graphics(this.ctx);
    let textRect = {};
    if (w.globals.rotateXLabels && isLeafGroup) {
      textRect = graphics.getTextRects(
        label,
        parseInt(fontSize, 10),
        null,
        `rotate(${w.config.xaxis.labels.rotate} 0 0)`,
        false
      );
    } else {
      textRect = graphics.getTextRects(label, parseInt(fontSize, 10));
    }
    const allowDuplicatesInTimeScale = !w.config.xaxis.labels.showDuplicates && this.ctx.timeScale;
    if (!Array.isArray(label) && (String(label) === "NaN" || drawnLabels.indexOf(label) >= 0 && allowDuplicatesInTimeScale)) {
      label = "";
    }
    return {
      x,
      text: label,
      textRect,
      isBold
    };
  }
  checkLabelBasedOnTickamount(i, label, labelsLen) {
    const w = this.w;
    let ticks = w.config.xaxis.tickAmount;
    if (ticks === "dataPoints") ticks = Math.round(w.globals.gridWidth / 120);
    if (ticks > labelsLen) return label;
    let tickMultiple = Math.round(labelsLen / (ticks + 1));
    if (i % tickMultiple === 0) {
      return label;
    } else {
      label.text = "";
    }
    return label;
  }
  checkForOverflowingLabels(i, label, labelsLen, drawnLabels, drawnLabelsRects) {
    const w = this.w;
    if (i === 0) {
      if (w.globals.skipFirstTimelinelabel) {
        label.text = "";
      }
    }
    if (i === labelsLen - 1) {
      if (w.globals.skipLastTimelinelabel) {
        label.text = "";
      }
    }
    if (w.config.xaxis.labels.hideOverlappingLabels && drawnLabels.length > 0) {
      const prev = drawnLabelsRects[drawnLabelsRects.length - 1];
      if (w.config.xaxis.labels.trim && w.config.xaxis.type !== "datetime") {
        return label;
      }
      if (label.x < prev.textRect.width / (w.globals.rotateXLabels ? Math.abs(w.config.xaxis.labels.rotate) / 12 : 1.01) + prev.x) {
        label.text = "";
      }
    }
    return label;
  }
  checkForReversedLabels(i, labels) {
    const w = this.w;
    if (w.config.yaxis[i] && w.config.yaxis[i].reversed) {
      labels.reverse();
    }
    return labels;
  }
  yAxisAllSeriesCollapsed(index2) {
    const gl = this.w.globals;
    return !gl.seriesYAxisMap[index2].some((si) => {
      return gl.collapsedSeriesIndices.indexOf(si) === -1;
    });
  }
  // Method to translate annotation.yAxisIndex values from
  // seriesName-as-a-string values to seriesName-as-an-array values (old style
  // series mapping to new style).
  translateYAxisIndex(index2) {
    const w = this.w;
    const gl = w.globals;
    const yaxis = w.config.yaxis;
    let newStyle = gl.series.length > yaxis.length || yaxis.some((a) => Array.isArray(a.seriesName));
    if (newStyle) {
      return index2;
    } else {
      return gl.seriesYAxisReverseMap[index2];
    }
  }
  isYAxisHidden(index2) {
    const w = this.w;
    const yaxis = w.config.yaxis[index2];
    if (!yaxis.show || this.yAxisAllSeriesCollapsed(index2)) {
      return true;
    }
    if (!yaxis.showForNullSeries) {
      const seriesIndices = w.globals.seriesYAxisMap[index2];
      const coreUtils = new CoreUtils(this.ctx);
      return seriesIndices.every((si) => coreUtils.isSeriesNull(si));
    }
    return false;
  }
  // get the label color for y-axis
  // realIndex is the actual series index, while i is the tick Index
  getYAxisForeColor(yColors, realIndex) {
    const w = this.w;
    if (Array.isArray(yColors) && w.globals.yAxisScale[realIndex]) {
      this.ctx.theme.pushExtraColors(
        yColors,
        w.globals.yAxisScale[realIndex].result.length,
        false
      );
    }
    return yColors;
  }
  drawYAxisTicks(x, tickAmount, axisBorder, axisTicks, realIndex, labelsDivider, elYaxis) {
    let w = this.w;
    let graphics = new Graphics(this.ctx);
    let tY = w.globals.translateY + w.config.yaxis[realIndex].labels.offsetY;
    if (w.globals.isBarHorizontal) {
      tY = 0;
    } else if (w.config.chart.type === "heatmap") {
      tY += labelsDivider / 2;
    }
    if (axisTicks.show && tickAmount > 0) {
      if (w.config.yaxis[realIndex].opposite === true) x = x + axisTicks.width;
      for (let i = tickAmount; i >= 0; i--) {
        let elTick = graphics.drawLine(
          x + axisBorder.offsetX - axisTicks.width + axisTicks.offsetX,
          tY + axisTicks.offsetY,
          x + axisBorder.offsetX + axisTicks.offsetX,
          tY + axisTicks.offsetY,
          axisTicks.color
        );
        elYaxis.add(elTick);
        tY += labelsDivider;
      }
    }
  }
}
class YAnnotations {
  constructor(annoCtx) {
    this.w = annoCtx.w;
    this.annoCtx = annoCtx;
    this.helpers = new Helpers$4(this.annoCtx);
    this.axesUtils = new AxesUtils(this.annoCtx);
  }
  addYaxisAnnotation(anno, parent, index2) {
    let w = this.w;
    let strokeDashArray = anno.strokeDashArray;
    let result = this.helpers.getY1Y2("y1", anno);
    let y1 = result.yP;
    let clipY1 = result.clipped;
    let y2;
    let clipY2 = true;
    let drawn = false;
    const text = anno.label.text;
    if (anno.y2 === null || typeof anno.y2 === "undefined") {
      if (!clipY1) {
        drawn = true;
        let line = this.annoCtx.graphics.drawLine(
          0 + anno.offsetX,
          // x1
          y1 + anno.offsetY,
          // y1
          this._getYAxisAnnotationWidth(anno),
          // x2
          y1 + anno.offsetY,
          // y2
          anno.borderColor,
          // lineColor
          strokeDashArray,
          // dashArray
          anno.borderWidth
        );
        parent.appendChild(line.node);
        if (anno.id) {
          line.node.classList.add(anno.id);
        }
      }
    } else {
      result = this.helpers.getY1Y2("y2", anno);
      y2 = result.yP;
      clipY2 = result.clipped;
      if (y2 > y1) {
        let temp = y1;
        y1 = y2;
        y2 = temp;
      }
      if (!(clipY1 && clipY2)) {
        drawn = true;
        let rect = this.annoCtx.graphics.drawRect(
          0 + anno.offsetX,
          // x1
          y2 + anno.offsetY,
          // y1
          this._getYAxisAnnotationWidth(anno),
          // x2
          y1 - y2,
          // y2
          0,
          // radius
          anno.fillColor,
          // color
          anno.opacity,
          // opacity,
          1,
          // strokeWidth
          anno.borderColor,
          // strokeColor
          strokeDashArray
          // stokeDashArray
        );
        rect.node.classList.add("apexcharts-annotation-rect");
        rect.attr("clip-path", `url(#gridRectMask${w.globals.cuid})`);
        parent.appendChild(rect.node);
        if (anno.id) {
          rect.node.classList.add(anno.id);
        }
      }
    }
    if (drawn) {
      let textX = anno.label.position === "right" ? w.globals.gridWidth : anno.label.position === "center" ? w.globals.gridWidth / 2 : 0;
      let elText = this.annoCtx.graphics.drawText({
        x: textX + anno.label.offsetX,
        y: (y2 != null ? y2 : y1) + anno.label.offsetY - 3,
        text,
        textAnchor: anno.label.textAnchor,
        fontSize: anno.label.style.fontSize,
        fontFamily: anno.label.style.fontFamily,
        fontWeight: anno.label.style.fontWeight,
        foreColor: anno.label.style.color,
        cssClass: `apexcharts-yaxis-annotation-label ${anno.label.style.cssClass} ${anno.id ? anno.id : ""}`
      });
      elText.attr({
        rel: index2
      });
      parent.appendChild(elText.node);
    }
  }
  _getYAxisAnnotationWidth(anno) {
    const w = this.w;
    let width = w.globals.gridWidth;
    if (anno.width.indexOf("%") > -1) {
      width = w.globals.gridWidth * parseInt(anno.width, 10) / 100;
    } else {
      width = parseInt(anno.width, 10);
    }
    return width + anno.offsetX;
  }
  drawYAxisAnnotations() {
    const w = this.w;
    let elg = this.annoCtx.graphics.group({
      class: "apexcharts-yaxis-annotations"
    });
    w.config.annotations.yaxis.forEach((anno, index2) => {
      anno.yAxisIndex = this.axesUtils.translateYAxisIndex(anno.yAxisIndex);
      if (!(this.axesUtils.isYAxisHidden(anno.yAxisIndex) && this.axesUtils.yAxisAllSeriesCollapsed(anno.yAxisIndex))) {
        this.addYaxisAnnotation(anno, elg.node, index2);
      }
    });
    return elg;
  }
}
class PointAnnotations {
  constructor(annoCtx) {
    this.w = annoCtx.w;
    this.annoCtx = annoCtx;
    this.helpers = new Helpers$4(this.annoCtx);
  }
  addPointAnnotation(anno, parent, index2) {
    const w = this.w;
    if (w.globals.collapsedSeriesIndices.indexOf(anno.seriesIndex) > -1) {
      return;
    }
    let result = this.helpers.getX1X2("x1", anno);
    let x = result.x;
    let clipX = result.clipped;
    result = this.helpers.getY1Y2("y1", anno);
    let y = result.yP;
    let clipY = result.clipped;
    if (!Utils$1.isNumber(x)) return;
    if (!(clipY || clipX)) {
      let optsPoints = {
        pSize: anno.marker.size,
        pointStrokeWidth: anno.marker.strokeWidth,
        pointFillColor: anno.marker.fillColor,
        pointStrokeColor: anno.marker.strokeColor,
        shape: anno.marker.shape,
        pRadius: anno.marker.radius,
        class: `apexcharts-point-annotation-marker ${anno.marker.cssClass} ${anno.id ? anno.id : ""}`
      };
      let point = this.annoCtx.graphics.drawMarker(
        x + anno.marker.offsetX,
        y + anno.marker.offsetY,
        optsPoints
      );
      parent.appendChild(point.node);
      const text = anno.label.text ? anno.label.text : "";
      let elText = this.annoCtx.graphics.drawText({
        x: x + anno.label.offsetX,
        y: y + anno.label.offsetY - anno.marker.size - parseFloat(anno.label.style.fontSize) / 1.6,
        text,
        textAnchor: anno.label.textAnchor,
        fontSize: anno.label.style.fontSize,
        fontFamily: anno.label.style.fontFamily,
        fontWeight: anno.label.style.fontWeight,
        foreColor: anno.label.style.color,
        cssClass: `apexcharts-point-annotation-label ${anno.label.style.cssClass} ${anno.id ? anno.id : ""}`
      });
      elText.attr({
        rel: index2
      });
      parent.appendChild(elText.node);
      if (anno.customSVG.SVG) {
        let g = this.annoCtx.graphics.group({
          class: "apexcharts-point-annotations-custom-svg " + anno.customSVG.cssClass
        });
        g.attr({
          transform: `translate(${x + anno.customSVG.offsetX}, ${y + anno.customSVG.offsetY})`
        });
        g.node.innerHTML = anno.customSVG.SVG;
        parent.appendChild(g.node);
      }
      if (anno.image.path) {
        let imgWidth = anno.image.width ? anno.image.width : 20;
        let imgHeight = anno.image.height ? anno.image.height : 20;
        point = this.annoCtx.addImage({
          x: x + anno.image.offsetX - imgWidth / 2,
          y: y + anno.image.offsetY - imgHeight / 2,
          width: imgWidth,
          height: imgHeight,
          path: anno.image.path,
          appendTo: ".apexcharts-point-annotations"
        });
      }
      if (anno.mouseEnter) {
        point.node.addEventListener(
          "mouseenter",
          anno.mouseEnter.bind(this, anno)
        );
      }
      if (anno.mouseLeave) {
        point.node.addEventListener(
          "mouseleave",
          anno.mouseLeave.bind(this, anno)
        );
      }
      if (anno.click) {
        point.node.addEventListener("click", anno.click.bind(this, anno));
      }
    }
  }
  drawPointAnnotations() {
    let w = this.w;
    let elg = this.annoCtx.graphics.group({
      class: "apexcharts-point-annotations"
    });
    w.config.annotations.points.map((anno, index2) => {
      this.addPointAnnotation(anno, elg.node, index2);
    });
    return elg;
  }
}
const name = "en";
const options = { "months": ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"], "shortMonths": ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"], "days": ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"], "shortDays": ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"], "toolbar": { "exportToSVG": "Download SVG", "exportToPNG": "Download PNG", "exportToCSV": "Download CSV", "menu": "Menu", "selection": "Selection", "selectionZoom": "Selection Zoom", "zoomIn": "Zoom In", "zoomOut": "Zoom Out", "pan": "Panning", "reset": "Reset Zoom" } };
const en = {
  name,
  options
};
class Options {
  constructor() {
    this.yAxis = {
      show: true,
      showAlways: false,
      showForNullSeries: true,
      seriesName: void 0,
      opposite: false,
      reversed: false,
      logarithmic: false,
      logBase: 10,
      tickAmount: void 0,
      stepSize: void 0,
      forceNiceScale: false,
      max: void 0,
      min: void 0,
      floating: false,
      decimalsInFloat: void 0,
      labels: {
        show: true,
        showDuplicates: false,
        minWidth: 0,
        maxWidth: 160,
        offsetX: 0,
        offsetY: 0,
        align: void 0,
        rotate: 0,
        padding: 20,
        style: {
          colors: [],
          fontSize: "11px",
          fontWeight: 400,
          fontFamily: void 0,
          cssClass: ""
        },
        formatter: void 0
      },
      axisBorder: {
        show: false,
        color: "#e0e0e0",
        width: 1,
        offsetX: 0,
        offsetY: 0
      },
      axisTicks: {
        show: false,
        color: "#e0e0e0",
        width: 6,
        offsetX: 0,
        offsetY: 0
      },
      title: {
        text: void 0,
        rotate: -90,
        offsetY: 0,
        offsetX: 0,
        style: {
          color: void 0,
          fontSize: "11px",
          fontWeight: 900,
          fontFamily: void 0,
          cssClass: ""
        }
      },
      tooltip: {
        enabled: false,
        offsetX: 0
      },
      crosshairs: {
        show: true,
        position: "front",
        stroke: {
          color: "#b6b6b6",
          width: 1,
          dashArray: 0
        }
      }
    };
    this.pointAnnotation = {
      id: void 0,
      x: 0,
      y: null,
      yAxisIndex: 0,
      seriesIndex: void 0,
      mouseEnter: void 0,
      mouseLeave: void 0,
      click: void 0,
      marker: {
        size: 4,
        fillColor: "#fff",
        strokeWidth: 2,
        strokeColor: "#333",
        shape: "circle",
        offsetX: 0,
        offsetY: 0,
        // radius: 2, // DEPRECATED
        cssClass: ""
      },
      label: {
        borderColor: "#c2c2c2",
        borderWidth: 1,
        borderRadius: 2,
        text: void 0,
        textAnchor: "middle",
        offsetX: 0,
        offsetY: 0,
        mouseEnter: void 0,
        mouseLeave: void 0,
        click: void 0,
        style: {
          background: "#fff",
          color: void 0,
          fontSize: "11px",
          fontFamily: void 0,
          fontWeight: 400,
          cssClass: "",
          padding: {
            left: 5,
            right: 5,
            top: 2,
            bottom: 2
          }
        }
      },
      customSVG: {
        // this will be deprecated in the next major version as it is going to be replaced with a better alternative below (image)
        SVG: void 0,
        cssClass: void 0,
        offsetX: 0,
        offsetY: 0
      },
      image: {
        path: void 0,
        width: 20,
        height: 20,
        offsetX: 0,
        offsetY: 0
      }
    };
    this.yAxisAnnotation = {
      id: void 0,
      y: 0,
      y2: null,
      strokeDashArray: 1,
      fillColor: "#c2c2c2",
      borderColor: "#c2c2c2",
      borderWidth: 1,
      opacity: 0.3,
      offsetX: 0,
      offsetY: 0,
      width: "100%",
      yAxisIndex: 0,
      label: {
        borderColor: "#c2c2c2",
        borderWidth: 1,
        borderRadius: 2,
        text: void 0,
        textAnchor: "end",
        position: "right",
        offsetX: 0,
        offsetY: -3,
        mouseEnter: void 0,
        mouseLeave: void 0,
        click: void 0,
        style: {
          background: "#fff",
          color: void 0,
          fontSize: "11px",
          fontFamily: void 0,
          fontWeight: 400,
          cssClass: "",
          padding: {
            left: 5,
            right: 5,
            top: 2,
            bottom: 2
          }
        }
      }
    };
    this.xAxisAnnotation = {
      id: void 0,
      x: 0,
      x2: null,
      strokeDashArray: 1,
      fillColor: "#c2c2c2",
      borderColor: "#c2c2c2",
      borderWidth: 1,
      opacity: 0.3,
      offsetX: 0,
      offsetY: 0,
      label: {
        borderColor: "#c2c2c2",
        borderWidth: 1,
        borderRadius: 2,
        text: void 0,
        textAnchor: "middle",
        orientation: "vertical",
        position: "top",
        offsetX: 0,
        offsetY: 0,
        mouseEnter: void 0,
        mouseLeave: void 0,
        click: void 0,
        style: {
          background: "#fff",
          color: void 0,
          fontSize: "11px",
          fontFamily: void 0,
          fontWeight: 400,
          cssClass: "",
          padding: {
            left: 5,
            right: 5,
            top: 2,
            bottom: 2
          }
        }
      }
    };
    this.text = {
      x: 0,
      y: 0,
      text: "",
      textAnchor: "start",
      foreColor: void 0,
      fontSize: "13px",
      fontFamily: void 0,
      fontWeight: 400,
      appendTo: ".apexcharts-annotations",
      backgroundColor: "transparent",
      borderColor: "#c2c2c2",
      borderRadius: 0,
      borderWidth: 0,
      paddingLeft: 4,
      paddingRight: 4,
      paddingTop: 2,
      paddingBottom: 2
    };
  }
  init() {
    return {
      annotations: {
        yaxis: [this.yAxisAnnotation],
        xaxis: [this.xAxisAnnotation],
        points: [this.pointAnnotation],
        texts: [],
        images: [],
        shapes: []
      },
      chart: {
        animations: {
          enabled: true,
          speed: 800,
          animateGradually: {
            delay: 150,
            enabled: true
          },
          dynamicAnimation: {
            enabled: true,
            speed: 350
          }
        },
        background: "",
        locales: [en],
        defaultLocale: "en",
        dropShadow: {
          enabled: false,
          enabledOnSeries: void 0,
          top: 2,
          left: 2,
          blur: 4,
          color: "#000",
          opacity: 0.7
        },
        events: {
          animationEnd: void 0,
          beforeMount: void 0,
          mounted: void 0,
          updated: void 0,
          click: void 0,
          mouseMove: void 0,
          mouseLeave: void 0,
          xAxisLabelClick: void 0,
          legendClick: void 0,
          markerClick: void 0,
          selection: void 0,
          dataPointSelection: void 0,
          dataPointMouseEnter: void 0,
          dataPointMouseLeave: void 0,
          beforeZoom: void 0,
          beforeResetZoom: void 0,
          zoomed: void 0,
          scrolled: void 0,
          brushScrolled: void 0,
          keyDown: void 0,
          keyUp: void 0
        },
        foreColor: "#373d3f",
        fontFamily: "Helvetica, Arial, sans-serif",
        height: "auto",
        parentHeightOffset: 15,
        redrawOnParentResize: true,
        redrawOnWindowResize: true,
        id: void 0,
        group: void 0,
        nonce: void 0,
        offsetX: 0,
        offsetY: 0,
        injectStyleSheet: true,
        selection: {
          enabled: false,
          type: "x",
          // selectedPoints: undefined, // default datapoints that should be selected automatically
          fill: {
            color: "#24292e",
            opacity: 0.1
          },
          stroke: {
            width: 1,
            color: "#24292e",
            opacity: 0.4,
            dashArray: 3
          },
          xaxis: {
            min: void 0,
            max: void 0
          },
          yaxis: {
            min: void 0,
            max: void 0
          }
        },
        sparkline: {
          enabled: false
        },
        brush: {
          enabled: false,
          autoScaleYaxis: true,
          target: void 0,
          targets: void 0
        },
        stacked: false,
        stackOnlyBar: true,
        // mixed chart with stacked bars and line series - incorrect line draw #907
        stackType: "normal",
        toolbar: {
          show: true,
          offsetX: 0,
          offsetY: 0,
          tools: {
            download: true,
            selection: true,
            zoom: true,
            zoomin: true,
            zoomout: true,
            pan: true,
            reset: true,
            customIcons: []
          },
          export: {
            csv: {
              filename: void 0,
              columnDelimiter: ",",
              headerCategory: "category",
              headerValue: "value",
              categoryFormatter: void 0,
              valueFormatter: void 0
            },
            png: {
              filename: void 0
            },
            svg: {
              filename: void 0
            },
            scale: void 0,
            width: void 0
          },
          autoSelected: "zoom"
          // accepts -> zoom, pan, selection
        },
        type: "line",
        width: "100%",
        zoom: {
          enabled: true,
          type: "x",
          autoScaleYaxis: false,
          allowMouseWheelZoom: true,
          zoomedArea: {
            fill: {
              color: "#90CAF9",
              opacity: 0.4
            },
            stroke: {
              color: "#0D47A1",
              opacity: 0.4,
              width: 1
            }
          }
        },
        accessibility: {
          enabled: true,
          description: void 0,
          announcements: {
            enabled: true
          },
          keyboard: {
            enabled: true
          }
        }
      },
      parsing: {
        x: void 0,
        y: void 0
      },
      plotOptions: {
        line: {
          isSlopeChart: false,
          colors: {
            threshold: 0,
            colorAboveThreshold: void 0,
            colorBelowThreshold: void 0
          }
        },
        area: {
          fillTo: "origin"
        },
        bar: {
          horizontal: false,
          columnWidth: "70%",
          // should be in percent 0 - 100
          barHeight: "70%",
          // should be in percent 0 - 100
          distributed: false,
          borderRadius: 0,
          borderRadiusApplication: "around",
          // [around, end]
          borderRadiusWhenStacked: "last",
          // [all, last]
          rangeBarOverlap: true,
          rangeBarGroupRows: false,
          hideZeroBarsWhenGrouped: false,
          isDumbbell: false,
          dumbbellColors: void 0,
          isFunnel: false,
          isFunnel3d: true,
          colors: {
            ranges: [],
            backgroundBarColors: [],
            backgroundBarOpacity: 1,
            backgroundBarRadius: 0
          },
          dataLabels: {
            position: "top",
            // top, center, bottom
            maxItems: 100,
            hideOverflowingLabels: true,
            orientation: "horizontal",
            total: {
              enabled: false,
              formatter: void 0,
              offsetX: 0,
              offsetY: 0,
              style: {
                color: "#373d3f",
                fontSize: "12px",
                fontFamily: void 0,
                fontWeight: 600
              }
            }
          }
        },
        bubble: {
          zScaling: true,
          minBubbleRadius: void 0,
          maxBubbleRadius: void 0
        },
        candlestick: {
          colors: {
            upward: "#00B746",
            downward: "#EF403C"
          },
          wick: {
            useFillColor: true
          }
        },
        boxPlot: {
          colors: {
            upper: "#00E396",
            lower: "#008FFB"
          }
        },
        heatmap: {
          radius: 2,
          enableShades: true,
          shadeIntensity: 0.5,
          reverseNegativeShade: false,
          distributed: false,
          useFillColorAsStroke: false,
          colorScale: {
            inverse: false,
            ranges: [],
            min: void 0,
            max: void 0
          }
        },
        treemap: {
          enableShades: true,
          shadeIntensity: 0.5,
          distributed: false,
          reverseNegativeShade: false,
          useFillColorAsStroke: false,
          borderRadius: 4,
          dataLabels: {
            format: "scale"
            // scale | truncate
          },
          colorScale: {
            inverse: false,
            ranges: [],
            min: void 0,
            max: void 0
          },
          seriesTitle: {
            show: true,
            offsetY: 1,
            offsetX: 1,
            borderColor: "#000",
            borderWidth: 1,
            borderRadius: 2,
            style: {
              background: "rgba(0, 0, 0, 0.6)",
              color: "#fff",
              fontSize: "12px",
              fontFamily: void 0,
              fontWeight: 400,
              cssClass: "",
              padding: {
                left: 6,
                right: 6,
                top: 2,
                bottom: 2
              }
            }
          }
        },
        radialBar: {
          inverseOrder: false,
          startAngle: 0,
          endAngle: 360,
          offsetX: 0,
          offsetY: 0,
          hollow: {
            margin: 5,
            size: "50%",
            background: "transparent",
            image: void 0,
            imageWidth: 150,
            imageHeight: 150,
            imageOffsetX: 0,
            imageOffsetY: 0,
            imageClipped: true,
            position: "front",
            dropShadow: {
              enabled: false,
              top: 0,
              left: 0,
              blur: 3,
              color: "#000",
              opacity: 0.5
            }
          },
          track: {
            show: true,
            startAngle: void 0,
            endAngle: void 0,
            background: "#f2f2f2",
            strokeWidth: "97%",
            opacity: 1,
            margin: 5,
            // margin is in pixels
            dropShadow: {
              enabled: false,
              top: 0,
              left: 0,
              blur: 3,
              color: "#000",
              opacity: 0.5
            }
          },
          dataLabels: {
            show: true,
            name: {
              show: true,
              fontSize: "16px",
              fontFamily: void 0,
              fontWeight: 600,
              color: void 0,
              offsetY: 0,
              formatter(val) {
                return val;
              }
            },
            value: {
              show: true,
              fontSize: "14px",
              fontFamily: void 0,
              fontWeight: 400,
              color: void 0,
              offsetY: 16,
              formatter(val) {
                return val + "%";
              }
            },
            total: {
              show: false,
              label: "Total",
              fontSize: "16px",
              fontWeight: 600,
              fontFamily: void 0,
              color: void 0,
              formatter(w) {
                return w.globals.seriesTotals.reduce((a, b) => a + b, 0) / w.globals.series.length + "%";
              }
            }
          },
          barLabels: {
            enabled: false,
            offsetX: 0,
            offsetY: 0,
            useSeriesColors: true,
            fontFamily: void 0,
            fontWeight: 600,
            fontSize: "16px",
            formatter(val) {
              return val;
            },
            onClick: void 0
          }
        },
        pie: {
          customScale: 1,
          offsetX: 0,
          offsetY: 0,
          startAngle: 0,
          endAngle: 360,
          expandOnClick: true,
          dataLabels: {
            // These are the percentage values which are displayed on slice
            offset: 0,
            // offset by which labels will move outside
            minAngleToShowLabel: 10
          },
          donut: {
            size: "65%",
            background: "transparent",
            labels: {
              // These are the inner labels appearing inside donut
              show: false,
              name: {
                show: true,
                fontSize: "16px",
                fontFamily: void 0,
                fontWeight: 600,
                color: void 0,
                offsetY: -10,
                formatter(val) {
                  return val;
                }
              },
              value: {
                show: true,
                fontSize: "20px",
                fontFamily: void 0,
                fontWeight: 400,
                color: void 0,
                offsetY: 10,
                formatter(val) {
                  return val;
                }
              },
              total: {
                show: false,
                showAlways: false,
                label: "Total",
                fontSize: "16px",
                fontWeight: 400,
                fontFamily: void 0,
                color: void 0,
                formatter(w) {
                  return w.globals.seriesTotals.reduce((a, b) => a + b, 0);
                }
              }
            }
          }
        },
        polarArea: {
          rings: {
            strokeWidth: 1,
            strokeColor: "#e8e8e8"
          },
          spokes: {
            strokeWidth: 1,
            connectorColors: "#e8e8e8"
          }
        },
        radar: {
          size: void 0,
          offsetX: 0,
          offsetY: 0,
          polygons: {
            // strokeColor: '#e8e8e8', // should be deprecated in the minor version i.e 3.2
            strokeWidth: 1,
            strokeColors: "#e8e8e8",
            connectorColors: "#e8e8e8",
            fill: {
              colors: void 0
            }
          }
        }
      },
      colors: void 0,
      dataLabels: {
        enabled: true,
        enabledOnSeries: void 0,
        formatter(val) {
          return val !== null ? val : "";
        },
        textAnchor: "middle",
        distributed: false,
        offsetX: 0,
        offsetY: 0,
        style: {
          fontSize: "12px",
          fontFamily: void 0,
          fontWeight: 600,
          colors: void 0
        },
        background: {
          enabled: true,
          foreColor: "#fff",
          backgroundColor: void 0,
          borderRadius: 2,
          padding: 4,
          opacity: 0.9,
          borderWidth: 1,
          borderColor: "#fff",
          dropShadow: {
            enabled: false,
            top: 1,
            left: 1,
            blur: 1,
            color: "#000",
            opacity: 0.8
          }
        },
        dropShadow: {
          enabled: false,
          top: 1,
          left: 1,
          blur: 1,
          color: "#000",
          opacity: 0.8
        }
      },
      fill: {
        type: "solid",
        colors: void 0,
        // array of colors
        opacity: 0.85,
        gradient: {
          shade: "dark",
          type: "horizontal",
          shadeIntensity: 0.5,
          gradientToColors: void 0,
          inverseColors: true,
          opacityFrom: 1,
          opacityTo: 1,
          stops: [0, 50, 100],
          colorStops: []
        },
        image: {
          src: [],
          width: void 0,
          // optional
          height: void 0
          // optional
        },
        pattern: {
          style: "squares",
          // String | Array of Strings
          width: 6,
          height: 6,
          strokeWidth: 2
        }
      },
      forecastDataPoints: {
        count: 0,
        fillOpacity: 0.5,
        strokeWidth: void 0,
        dashArray: 4
      },
      grid: {
        show: true,
        borderColor: "#e0e0e0",
        strokeDashArray: 0,
        position: "back",
        xaxis: {
          lines: {
            show: false
          }
        },
        yaxis: {
          lines: {
            show: true
          }
        },
        row: {
          colors: void 0,
          // takes as array which will be repeated on rows
          opacity: 0.5
        },
        column: {
          colors: void 0,
          // takes an array which will be repeated on columns
          opacity: 0.5
        },
        padding: {
          top: 0,
          right: 10,
          bottom: 0,
          left: 12
        }
      },
      labels: [],
      legend: {
        show: true,
        showForSingleSeries: false,
        showForNullSeries: true,
        showForZeroSeries: true,
        floating: false,
        position: "bottom",
        // whether to position legends in 1 of 4
        // direction - top, bottom, left, right
        horizontalAlign: "center",
        // when position top/bottom, you can specify whether to align legends left, right or center
        inverseOrder: false,
        fontSize: "12px",
        fontFamily: void 0,
        fontWeight: 400,
        width: void 0,
        height: void 0,
        formatter: void 0,
        tooltipHoverFormatter: void 0,
        offsetX: -20,
        offsetY: 4,
        customLegendItems: [],
        clusterGroupedSeries: true,
        clusterGroupedSeriesOrientation: "vertical",
        labels: {
          colors: void 0,
          useSeriesColors: false
        },
        markers: {
          size: 7,
          fillColors: void 0,
          strokeWidth: 1,
          shape: void 0,
          offsetX: 0,
          offsetY: 0,
          customHTML: void 0,
          onClick: void 0
        },
        itemMargin: {
          horizontal: 5,
          vertical: 4
        },
        onItemClick: {
          toggleDataSeries: true
        },
        onItemHover: {
          highlightDataSeries: true
        }
      },
      markers: {
        discrete: [],
        size: 0,
        colors: void 0,
        strokeColors: "#fff",
        strokeWidth: 2,
        strokeOpacity: 0.9,
        strokeDashArray: 0,
        fillOpacity: 1,
        shape: "circle",
        offsetX: 0,
        offsetY: 0,
        showNullDataPoints: true,
        onClick: void 0,
        onDblClick: void 0,
        hover: {
          size: void 0,
          sizeOffset: 3
        }
      },
      noData: {
        text: void 0,
        align: "center",
        verticalAlign: "middle",
        offsetX: 0,
        offsetY: 0,
        style: {
          color: void 0,
          fontSize: "14px",
          fontFamily: void 0
        }
      },
      responsive: [],
      // breakpoints should follow ascending order 400, then 700, then 1000
      series: void 0,
      states: {
        hover: {
          filter: {
            type: "lighten"
          }
        },
        active: {
          allowMultipleDataPointsSelection: false,
          filter: {
            type: "darken"
          }
        }
      },
      title: {
        text: void 0,
        align: "left",
        margin: 5,
        offsetX: 0,
        offsetY: 0,
        floating: false,
        style: {
          fontSize: "14px",
          fontWeight: 900,
          fontFamily: void 0,
          color: void 0
        }
      },
      subtitle: {
        text: void 0,
        align: "left",
        margin: 5,
        offsetX: 0,
        offsetY: 30,
        floating: false,
        style: {
          fontSize: "12px",
          fontWeight: 400,
          fontFamily: void 0,
          color: void 0
        }
      },
      stroke: {
        show: true,
        curve: "smooth",
        // "smooth" / "straight" / "monotoneCubic" / "stepline" / "linestep"
        lineCap: "butt",
        // round, butt , square
        width: 2,
        colors: void 0,
        // array of colors
        dashArray: 0,
        // single value or array of values
        fill: {
          type: "solid",
          colors: void 0,
          // array of colors
          opacity: 0.85,
          gradient: {
            shade: "dark",
            type: "horizontal",
            shadeIntensity: 0.5,
            gradientToColors: void 0,
            inverseColors: true,
            opacityFrom: 1,
            opacityTo: 1,
            stops: [0, 50, 100],
            colorStops: []
          }
        }
      },
      tooltip: {
        enabled: true,
        enabledOnSeries: void 0,
        shared: true,
        hideEmptySeries: false,
        followCursor: false,
        // when disabled, the tooltip will show on top of the series instead of mouse position
        intersect: false,
        // when enabled, tooltip will only show when user directly hovers over point
        inverseOrder: false,
        custom: void 0,
        fillSeriesColor: false,
        theme: "light",
        cssClass: "",
        style: {
          fontSize: "12px",
          fontFamily: void 0
        },
        onDatasetHover: {
          highlightDataSeries: false
        },
        x: {
          // x value
          show: true,
          format: "dd MMM",
          // dd/MM, dd MMM yy, dd MMM yyyy
          formatter: void 0
          // a custom user supplied formatter function
        },
        y: {
          formatter: void 0,
          title: {
            formatter(seriesName) {
              return seriesName ? seriesName + ": " : "";
            }
          }
        },
        z: {
          formatter: void 0,
          title: "Size: "
        },
        marker: {
          show: true,
          fillColors: void 0
        },
        items: {
          display: "flex"
        },
        fixed: {
          enabled: false,
          position: "topRight",
          // topRight, topLeft, bottomRight, bottomLeft
          offsetX: 0,
          offsetY: 0
        }
      },
      xaxis: {
        type: "category",
        categories: [],
        convertedCatToNumeric: false,
        // internal property which should not be altered outside
        offsetX: 0,
        offsetY: 0,
        overwriteCategories: void 0,
        labels: {
          show: true,
          rotate: -45,
          rotateAlways: false,
          hideOverlappingLabels: true,
          trim: false,
          minHeight: void 0,
          maxHeight: 120,
          showDuplicates: true,
          style: {
            colors: [],
            fontSize: "12px",
            fontWeight: 400,
            fontFamily: void 0,
            cssClass: ""
          },
          offsetX: 0,
          offsetY: 0,
          format: void 0,
          formatter: void 0,
          // custom formatter function which will override format
          datetimeUTC: true,
          datetimeFormatter: {
            year: "yyyy",
            month: "MMM 'yy",
            day: "dd MMM",
            hour: "HH:mm",
            minute: "HH:mm:ss",
            second: "HH:mm:ss"
          }
        },
        group: {
          groups: [],
          style: {
            colors: [],
            fontSize: "12px",
            fontWeight: 400,
            fontFamily: void 0,
            cssClass: ""
          }
        },
        axisBorder: {
          show: true,
          color: "#e0e0e0",
          width: "100%",
          height: 1,
          offsetX: 0,
          offsetY: 0
        },
        axisTicks: {
          show: true,
          color: "#e0e0e0",
          height: 6,
          offsetX: 0,
          offsetY: 0
        },
        stepSize: void 0,
        tickAmount: void 0,
        tickPlacement: "on",
        min: void 0,
        max: void 0,
        range: void 0,
        floating: false,
        decimalsInFloat: void 0,
        position: "bottom",
        title: {
          text: void 0,
          offsetX: 0,
          offsetY: 0,
          style: {
            color: void 0,
            fontSize: "12px",
            fontWeight: 900,
            fontFamily: void 0,
            cssClass: ""
          }
        },
        crosshairs: {
          show: true,
          width: 1,
          // tickWidth/barWidth or an integer
          position: "back",
          opacity: 0.9,
          stroke: {
            color: "#b6b6b6",
            width: 1,
            dashArray: 3
          },
          fill: {
            type: "solid",
            // solid, gradient
            color: "#B1B9C4",
            gradient: {
              colorFrom: "#D8E3F0",
              colorTo: "#BED1E6",
              stops: [0, 100],
              opacityFrom: 0.4,
              opacityTo: 0.5
            }
          },
          dropShadow: {
            enabled: false,
            left: 0,
            top: 0,
            blur: 1,
            opacity: 0.8
          }
        },
        tooltip: {
          enabled: true,
          offsetY: 0,
          formatter: void 0,
          style: {
            fontSize: "12px",
            fontFamily: void 0
          }
        }
      },
      yaxis: this.yAxis,
      theme: {
        mode: "",
        palette: "palette1",
        // If defined, it will overwrite globals.colors variable
        monochrome: {
          // monochrome allows you to select just 1 color and fill out the rest with light/dark shade (intensity can be selected)
          enabled: false,
          color: "#008FFB",
          shadeTo: "light",
          shadeIntensity: 0.65
        }
      }
    };
  }
}
class Annotations {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
    this.graphics = new Graphics(this.ctx);
    if (this.w.globals.isBarHorizontal) {
      this.invertAxis = true;
    }
    this.helpers = new Helpers$4(this);
    this.xAxisAnnotations = new XAnnotations(this);
    this.yAxisAnnotations = new YAnnotations(this);
    this.pointsAnnotations = new PointAnnotations(this);
    if (this.w.globals.isBarHorizontal && this.w.config.yaxis[0].reversed) {
      this.inversedReversedAxis = true;
    }
    this.xDivision = this.w.globals.gridWidth / this.w.globals.dataPoints;
  }
  drawAxesAnnotations() {
    const w = this.w;
    if (w.globals.axisCharts && w.globals.dataPoints) {
      let yAnnotations = this.yAxisAnnotations.drawYAxisAnnotations();
      let xAnnotations = this.xAxisAnnotations.drawXAxisAnnotations();
      let pointAnnotations = this.pointsAnnotations.drawPointAnnotations();
      const initialAnim = w.config.chart.animations.enabled;
      const annoArray = [yAnnotations, xAnnotations, pointAnnotations];
      const annoElArray = [
        xAnnotations.node,
        yAnnotations.node,
        pointAnnotations.node
      ];
      for (let i = 0; i < 3; i++) {
        w.globals.dom.elGraphical.add(annoArray[i]);
        if (initialAnim && !w.globals.resized && !w.globals.dataChanged) {
          if (w.config.chart.type !== "scatter" && w.config.chart.type !== "bubble" && w.globals.dataPoints > 1) {
            annoElArray[i].classList.add("apexcharts-element-hidden");
          }
        }
        w.globals.delayedElements.push({ el: annoElArray[i], index: 0 });
      }
      this.helpers.annotationsBackground();
    }
  }
  drawImageAnnos() {
    const w = this.w;
    w.config.annotations.images.map((s, index2) => {
      this.addImage(s, index2);
    });
  }
  drawTextAnnos() {
    const w = this.w;
    w.config.annotations.texts.map((t, index2) => {
      this.addText(t, index2);
    });
  }
  addXaxisAnnotation(anno, parent, index2) {
    this.xAxisAnnotations.addXaxisAnnotation(anno, parent, index2);
  }
  addYaxisAnnotation(anno, parent, index2) {
    this.yAxisAnnotations.addYaxisAnnotation(anno, parent, index2);
  }
  addPointAnnotation(anno, parent, index2) {
    this.pointsAnnotations.addPointAnnotation(anno, parent, index2);
  }
  addText(params) {
    const {
      x,
      y,
      text,
      textAnchor,
      foreColor,
      fontSize,
      fontFamily,
      fontWeight,
      cssClass,
      backgroundColor,
      borderWidth,
      strokeDashArray,
      borderRadius,
      borderColor,
      appendTo = ".apexcharts-svg",
      paddingLeft = 4,
      paddingRight = 4,
      paddingBottom = 2,
      paddingTop = 2
    } = params;
    const w = this.w;
    let elText = this.graphics.drawText({
      x,
      y,
      text,
      textAnchor: textAnchor || "start",
      fontSize: fontSize || "12px",
      fontWeight: fontWeight || "regular",
      fontFamily: fontFamily || w.config.chart.fontFamily,
      foreColor: foreColor || w.config.chart.foreColor,
      cssClass: "apexcharts-text " + cssClass ? cssClass : ""
    });
    const parent = w.globals.dom.baseEl.querySelector(appendTo);
    if (parent) {
      parent.appendChild(elText.node);
    }
    const textRect = elText.bbox();
    if (text) {
      const elRect = this.graphics.drawRect(
        textRect.x - paddingLeft,
        textRect.y - paddingTop,
        textRect.width + paddingLeft + paddingRight,
        textRect.height + paddingBottom + paddingTop,
        borderRadius,
        backgroundColor ? backgroundColor : "transparent",
        1,
        borderWidth,
        borderColor,
        strokeDashArray
      );
      parent.insertBefore(elRect.node, elText.node);
    }
  }
  addImage(params) {
    const w = this.w;
    const {
      path,
      x = 0,
      y = 0,
      width = 20,
      height = 20,
      appendTo = ".apexcharts-svg"
    } = params;
    let img = w.globals.dom.Paper.image(path);
    img.size(width, height).move(x, y);
    const parent = w.globals.dom.baseEl.querySelector(appendTo);
    if (parent) {
      parent.appendChild(img.node);
    }
    return img;
  }
  // The addXaxisAnnotation method requires a parent class, and user calling this method externally on the chart instance may not specify parent, hence a different method
  addXaxisAnnotationExternal(params, pushToMemory, context) {
    this.addAnnotationExternal({
      params,
      pushToMemory,
      context,
      type: "xaxis",
      contextMethod: context.addXaxisAnnotation
    });
    return context;
  }
  addYaxisAnnotationExternal(params, pushToMemory, context) {
    this.addAnnotationExternal({
      params,
      pushToMemory,
      context,
      type: "yaxis",
      contextMethod: context.addYaxisAnnotation
    });
    return context;
  }
  addPointAnnotationExternal(params, pushToMemory, context) {
    if (typeof this.invertAxis === "undefined") {
      this.invertAxis = context.w.globals.isBarHorizontal;
    }
    this.addAnnotationExternal({
      params,
      pushToMemory,
      context,
      type: "point",
      contextMethod: context.addPointAnnotation
    });
    return context;
  }
  addAnnotationExternal({
    params,
    pushToMemory,
    context,
    type,
    contextMethod
  }) {
    const me = context;
    const w = me.w;
    const parent = w.globals.dom.baseEl.querySelector(
      `.apexcharts-${type}-annotations`
    );
    const index2 = parent.childNodes.length + 1;
    const options2 = new Options();
    const axesAnno = Object.assign(
      {},
      type === "xaxis" ? options2.xAxisAnnotation : type === "yaxis" ? options2.yAxisAnnotation : options2.pointAnnotation
    );
    const anno = Utils$1.extend(axesAnno, params);
    switch (type) {
      case "xaxis":
        this.addXaxisAnnotation(anno, parent, index2);
        break;
      case "yaxis":
        this.addYaxisAnnotation(anno, parent, index2);
        break;
      case "point":
        this.addPointAnnotation(anno, parent, index2);
        break;
    }
    let axesAnnoLabel = w.globals.dom.baseEl.querySelector(
      `.apexcharts-${type}-annotations .apexcharts-${type}-annotation-label[rel='${index2}']`
    );
    const elRect = this.helpers.addBackgroundToAnno(axesAnnoLabel, anno);
    if (elRect) {
      parent.insertBefore(elRect.node, axesAnnoLabel);
    }
    if (pushToMemory) {
      w.globals.memory.methodsToExec.push({
        context: me,
        id: anno.id ? anno.id : Utils$1.randomId(),
        method: contextMethod,
        label: "addAnnotation",
        params
      });
    }
    return context;
  }
  clearAnnotations(ctx) {
    const w = ctx.w;
    let annos = w.globals.dom.baseEl.querySelectorAll(
      ".apexcharts-yaxis-annotations, .apexcharts-xaxis-annotations, .apexcharts-point-annotations"
    );
    for (let i = w.globals.memory.methodsToExec.length - 1; i >= 0; i--) {
      if (w.globals.memory.methodsToExec[i].label === "addText" || w.globals.memory.methodsToExec[i].label === "addAnnotation") {
        w.globals.memory.methodsToExec.splice(i, 1);
      }
    }
    annos = Utils$1.listToArray(annos);
    Array.prototype.forEach.call(annos, (a) => {
      while (a.firstChild) {
        a.removeChild(a.firstChild);
      }
    });
  }
  removeAnnotation(ctx, id) {
    const w = ctx.w;
    let annos = w.globals.dom.baseEl.querySelectorAll(`.${id}`);
    if (annos) {
      w.globals.memory.methodsToExec.map((m2, i) => {
        if (m2.id === id) {
          w.globals.memory.methodsToExec.splice(i, 1);
        }
      });
      Object.keys(w.config.annotations).forEach((key) => {
        const annotationArray = w.config.annotations[key];
        if (Array.isArray(annotationArray)) {
          w.config.annotations[key] = annotationArray.filter((m2) => m2.id !== id);
        }
      });
      Array.prototype.forEach.call(annos, (a) => {
        a.parentElement.removeChild(a);
      });
    }
  }
}
const getRangeValues = ({
  isTimeline,
  ctx,
  seriesIndex,
  dataPointIndex,
  y1,
  y2,
  w
}) => {
  var _a;
  let start = w.globals.seriesRangeStart[seriesIndex][dataPointIndex];
  let end = w.globals.seriesRangeEnd[seriesIndex][dataPointIndex];
  let ylabel = w.globals.labels[dataPointIndex];
  let seriesName = w.config.series[seriesIndex].name ? w.config.series[seriesIndex].name : "";
  const yLbFormatter = w.globals.ttKeyFormatter;
  const yLbTitleFormatter = w.config.tooltip.y.title.formatter;
  const opts = {
    w,
    seriesIndex,
    dataPointIndex,
    start,
    end
  };
  if (typeof yLbTitleFormatter === "function") {
    seriesName = yLbTitleFormatter(seriesName, opts);
  }
  if ((_a = w.config.series[seriesIndex].data[dataPointIndex]) == null ? void 0 : _a.x) {
    ylabel = w.config.series[seriesIndex].data[dataPointIndex].x;
  }
  if (!isTimeline) {
    if (w.config.xaxis.type === "datetime") {
      let xFormat = new Formatters(ctx);
      ylabel = xFormat.xLabelFormat(w.globals.ttKeyFormatter, ylabel, ylabel, {
        i: void 0,
        dateFormatter: new DateTime(ctx).formatDate,
        w
      });
    }
  }
  if (typeof yLbFormatter === "function") {
    ylabel = yLbFormatter(ylabel, opts);
  }
  if (Number.isFinite(y1) && Number.isFinite(y2)) {
    start = y1;
    end = y2;
  }
  let startVal = "";
  let endVal = "";
  const color = w.globals.colors[seriesIndex];
  if (w.config.tooltip.x.formatter === void 0) {
    if (w.config.xaxis.type === "datetime") {
      let datetimeObj = new DateTime(ctx);
      startVal = datetimeObj.formatDate(
        datetimeObj.getDate(start),
        w.config.tooltip.x.format
      );
      endVal = datetimeObj.formatDate(
        datetimeObj.getDate(end),
        w.config.tooltip.x.format
      );
    } else {
      startVal = start;
      endVal = end;
    }
  } else {
    startVal = w.config.tooltip.x.formatter(start);
    endVal = w.config.tooltip.x.formatter(end);
  }
  return { start, end, startVal, endVal, ylabel, color, seriesName };
};
const buildRangeTooltipHTML = (opts) => {
  let { color, seriesName, ylabel, start, end, seriesIndex, dataPointIndex } = opts;
  const formatter = opts.ctx.tooltip.tooltipLabels.getFormatters(seriesIndex);
  start = formatter.yLbFormatter(start);
  end = formatter.yLbFormatter(end);
  const val = formatter.yLbFormatter(
    opts.w.globals.series[seriesIndex][dataPointIndex]
  );
  let valueHTML = "";
  const rangeValues = `<span class="value start-value">
  ${start}
  </span> <span class="separator">-</span> <span class="value end-value">
  ${end}
  </span>`;
  if (opts.w.globals.comboCharts) {
    if (opts.w.config.series[seriesIndex].type === "rangeArea" || opts.w.config.series[seriesIndex].type === "rangeBar") {
      valueHTML = rangeValues;
    } else {
      valueHTML = `<span>${val}</span>`;
    }
  } else {
    valueHTML = rangeValues;
  }
  return '<div class="apexcharts-tooltip-rangebar"><div> <span class="series-name" style="color: ' + color + '">' + (seriesName ? seriesName : "") + '</span></div><div> <span class="category">' + ylabel + ": </span> " + valueHTML + " </div></div>";
};
class Defaults {
  constructor(opts) {
    this.opts = opts;
  }
  hideYAxis() {
    this.opts.yaxis[0].show = false;
    this.opts.yaxis[0].title.text = "";
    this.opts.yaxis[0].axisBorder.show = false;
    this.opts.yaxis[0].axisTicks.show = false;
    this.opts.yaxis[0].floating = true;
  }
  line() {
    return {
      dataLabels: {
        enabled: false
      },
      stroke: {
        width: 5,
        curve: "straight"
      },
      markers: {
        size: 0,
        hover: {
          sizeOffset: 6
        }
      },
      xaxis: {
        crosshairs: {
          width: 1
        }
      }
    };
  }
  sparkline(defaults2) {
    this.hideYAxis();
    const ret = {
      grid: {
        show: false,
        padding: {
          left: 0,
          right: 0,
          top: 0,
          bottom: 0
        }
      },
      legend: {
        show: false
      },
      xaxis: {
        labels: {
          show: false
        },
        tooltip: {
          enabled: false
        },
        axisBorder: {
          show: false
        },
        axisTicks: {
          show: false
        }
      },
      chart: {
        toolbar: {
          show: false
        },
        zoom: {
          enabled: false
        }
      },
      dataLabels: {
        enabled: false
      }
    };
    return Utils$1.extend(defaults2, ret);
  }
  slope() {
    this.hideYAxis();
    return {
      chart: {
        toolbar: {
          show: false
        },
        zoom: {
          enabled: false
        }
      },
      dataLabels: {
        enabled: true,
        formatter(val, opts) {
          const seriesName = opts.w.config.series[opts.seriesIndex].name;
          return val !== null ? seriesName + ": " + val : "";
        },
        background: {
          enabled: false
        },
        offsetX: -5
      },
      grid: {
        xaxis: {
          lines: {
            show: true
          }
        },
        yaxis: {
          lines: {
            show: false
          }
        }
      },
      xaxis: {
        position: "top",
        labels: {
          style: {
            fontSize: 14,
            fontWeight: 900
          }
        },
        tooltip: {
          enabled: false
        },
        crosshairs: {
          show: false
        }
      },
      markers: {
        size: 8,
        hover: {
          sizeOffset: 1
        }
      },
      legend: {
        show: false
      },
      tooltip: {
        shared: false,
        intersect: true,
        followCursor: true
      },
      stroke: {
        width: 5,
        curve: "straight"
      }
    };
  }
  bar() {
    return {
      chart: {
        stacked: false
      },
      plotOptions: {
        bar: {
          dataLabels: {
            position: "center"
          }
        }
      },
      dataLabels: {
        style: {
          colors: ["#fff"]
        },
        background: {
          enabled: false
        }
      },
      stroke: {
        width: 0,
        lineCap: "square"
      },
      fill: {
        opacity: 0.85
      },
      legend: {
        markers: {
          shape: "square"
        }
      },
      tooltip: {
        shared: false,
        intersect: true
      },
      xaxis: {
        tooltip: {
          enabled: false
        },
        tickPlacement: "between",
        crosshairs: {
          width: "barWidth",
          position: "back",
          fill: {
            type: "gradient"
          },
          dropShadow: {
            enabled: false
          },
          stroke: {
            width: 0
          }
        }
      }
    };
  }
  funnel() {
    this.hideYAxis();
    return __spreadProps(__spreadValues({}, this.bar()), {
      chart: {
        animations: {
          speed: 800,
          animateGradually: {
            enabled: false
          }
        }
      },
      plotOptions: {
        bar: {
          horizontal: true,
          borderRadiusApplication: "around",
          borderRadius: 0,
          dataLabels: {
            position: "center"
          }
        }
      },
      grid: {
        show: false,
        padding: {
          left: 0,
          right: 0
        }
      },
      xaxis: {
        labels: {
          show: false
        },
        tooltip: {
          enabled: false
        },
        axisBorder: {
          show: false
        },
        axisTicks: {
          show: false
        }
      }
    });
  }
  candlestick() {
    return {
      stroke: {
        width: 1
      },
      fill: {
        opacity: 1
      },
      dataLabels: {
        enabled: false
      },
      tooltip: {
        shared: true,
        custom: ({ seriesIndex, dataPointIndex, w }) => {
          return this._getBoxTooltip(
            w,
            seriesIndex,
            dataPointIndex,
            ["Open", "High", "", "Low", "Close"],
            "candlestick"
          );
        }
      },
      states: {
        active: {
          filter: {
            type: "none"
          }
        }
      },
      xaxis: {
        crosshairs: {
          width: 1
        }
      }
    };
  }
  boxPlot() {
    return {
      chart: {
        animations: {
          dynamicAnimation: {
            enabled: false
          }
        }
      },
      stroke: {
        width: 1,
        colors: ["#24292e"]
      },
      dataLabels: {
        enabled: false
      },
      tooltip: {
        shared: true,
        custom: ({ seriesIndex, dataPointIndex, w }) => {
          return this._getBoxTooltip(
            w,
            seriesIndex,
            dataPointIndex,
            ["Minimum", "Q1", "Median", "Q3", "Maximum"],
            "boxPlot"
          );
        }
      },
      markers: {
        size: 7,
        strokeWidth: 1,
        strokeColors: "#111"
      },
      xaxis: {
        crosshairs: {
          width: 1
        }
      }
    };
  }
  rangeBar() {
    const handleTimelineTooltip = (opts) => {
      const { color, seriesName, ylabel, startVal, endVal } = getRangeValues(__spreadProps(__spreadValues({}, opts), {
        isTimeline: true
      }));
      return buildRangeTooltipHTML(__spreadProps(__spreadValues({}, opts), {
        color,
        seriesName,
        ylabel,
        start: startVal,
        end: endVal
      }));
    };
    const handleRangeColumnTooltip = (opts) => {
      const { color, seriesName, ylabel, start, end } = getRangeValues(opts);
      return buildRangeTooltipHTML(__spreadProps(__spreadValues({}, opts), {
        color,
        seriesName,
        ylabel,
        start,
        end
      }));
    };
    return {
      chart: {
        animations: {
          animateGradually: false
        }
      },
      stroke: {
        width: 0,
        lineCap: "square"
      },
      plotOptions: {
        bar: {
          borderRadius: 0,
          dataLabels: {
            position: "center"
          }
        }
      },
      dataLabels: {
        enabled: false,
        formatter(val, { seriesIndex, dataPointIndex, w }) {
          const getVal = () => {
            const start = w.globals.seriesRangeStart[seriesIndex][dataPointIndex];
            const end = w.globals.seriesRangeEnd[seriesIndex][dataPointIndex];
            return end - start;
          };
          if (w.globals.comboCharts) {
            if (w.config.series[seriesIndex].type === "rangeBar" || w.config.series[seriesIndex].type === "rangeArea") {
              return getVal();
            } else {
              return val;
            }
          } else {
            return getVal();
          }
        },
        background: {
          enabled: false
        },
        style: {
          colors: ["#fff"]
        }
      },
      markers: {
        size: 10
      },
      tooltip: {
        shared: false,
        followCursor: true,
        custom(opts) {
          if (opts.w.config.plotOptions && opts.w.config.plotOptions.bar && opts.w.config.plotOptions.bar.horizontal) {
            return handleTimelineTooltip(opts);
          } else {
            return handleRangeColumnTooltip(opts);
          }
        }
      },
      xaxis: {
        tickPlacement: "between",
        tooltip: {
          enabled: false
        },
        crosshairs: {
          stroke: {
            width: 0
          }
        }
      }
    };
  }
  dumbbell(opts) {
    var _a, _b;
    if (!((_a = opts.plotOptions.bar) == null ? void 0 : _a.barHeight)) {
      opts.plotOptions.bar.barHeight = 2;
    }
    if (!((_b = opts.plotOptions.bar) == null ? void 0 : _b.columnWidth)) {
      opts.plotOptions.bar.columnWidth = 2;
    }
    return opts;
  }
  area() {
    return {
      stroke: {
        width: 4,
        fill: {
          type: "solid",
          gradient: {
            inverseColors: false,
            shade: "light",
            type: "vertical",
            opacityFrom: 0.65,
            opacityTo: 0.5,
            stops: [0, 100, 100]
          }
        }
      },
      fill: {
        type: "gradient",
        gradient: {
          inverseColors: false,
          shade: "light",
          type: "vertical",
          opacityFrom: 0.65,
          opacityTo: 0.5,
          stops: [0, 100, 100]
        }
      },
      markers: {
        size: 0,
        hover: {
          sizeOffset: 6
        }
      },
      tooltip: {
        followCursor: false
      }
    };
  }
  rangeArea() {
    const handleRangeAreaTooltip = (opts) => {
      const { color, seriesName, ylabel, start, end } = getRangeValues(opts);
      return buildRangeTooltipHTML(__spreadProps(__spreadValues({}, opts), {
        color,
        seriesName,
        ylabel,
        start,
        end
      }));
    };
    return {
      stroke: {
        curve: "straight",
        width: 0
      },
      fill: {
        type: "solid",
        opacity: 0.6
      },
      markers: {
        size: 0
      },
      states: {
        hover: {
          filter: {
            type: "none"
          }
        },
        active: {
          filter: {
            type: "none"
          }
        }
      },
      tooltip: {
        intersect: false,
        shared: true,
        followCursor: true,
        custom(opts) {
          return handleRangeAreaTooltip(opts);
        }
      }
    };
  }
  brush(defaults2) {
    const ret = {
      chart: {
        toolbar: {
          autoSelected: "selection",
          show: false
        },
        zoom: {
          enabled: false
        }
      },
      dataLabels: {
        enabled: false
      },
      stroke: {
        width: 1
      },
      tooltip: {
        enabled: false
      },
      xaxis: {
        tooltip: {
          enabled: false
        }
      }
    };
    return Utils$1.extend(defaults2, ret);
  }
  stacked100(opts) {
    opts.dataLabels = opts.dataLabels || {};
    opts.dataLabels.formatter = opts.dataLabels.formatter || void 0;
    const existingDataLabelFormatter = opts.dataLabels.formatter;
    opts.yaxis.forEach((yaxe, index2) => {
      opts.yaxis[index2].min = 0;
      opts.yaxis[index2].max = 100;
    });
    const isBar = opts.chart.type === "bar";
    if (isBar) {
      opts.dataLabels.formatter = existingDataLabelFormatter || function(val) {
        if (typeof val === "number") {
          return val ? val.toFixed(0) + "%" : val;
        }
        return val;
      };
    }
    return opts;
  }
  stackedBars() {
    const barDefaults = this.bar();
    return __spreadProps(__spreadValues({}, barDefaults), {
      plotOptions: __spreadProps(__spreadValues({}, barDefaults.plotOptions), {
        bar: __spreadProps(__spreadValues({}, barDefaults.plotOptions.bar), {
          borderRadiusApplication: "end",
          borderRadiusWhenStacked: "last"
        })
      })
    });
  }
  // This function removes the left and right spacing in chart for line/area/scatter if xaxis type = category for those charts by converting xaxis = numeric. Numeric/Datetime xaxis prevents the unnecessary spacing in the left/right of the chart area
  convertCatToNumeric(opts) {
    opts.xaxis.convertedCatToNumeric = true;
    return opts;
  }
  convertCatToNumericXaxis(opts, ctx, cats) {
    opts.xaxis.type = "numeric";
    opts.xaxis.labels = opts.xaxis.labels || {};
    opts.xaxis.labels.formatter = opts.xaxis.labels.formatter || function(val) {
      return Utils$1.isNumber(val) ? Math.floor(val) : val;
    };
    const defaultFormatter = opts.xaxis.labels.formatter;
    let labels = opts.xaxis.categories && opts.xaxis.categories.length ? opts.xaxis.categories : opts.labels;
    if (cats && cats.length) {
      labels = cats.map((c) => {
        return Array.isArray(c) ? c : String(c);
      });
    }
    if (labels && labels.length) {
      opts.xaxis.labels.formatter = function(val) {
        return Utils$1.isNumber(val) ? defaultFormatter(labels[Math.floor(val) - 1]) : defaultFormatter(val);
      };
    }
    opts.xaxis.categories = [];
    opts.labels = [];
    opts.xaxis.tickAmount = opts.xaxis.tickAmount || "dataPoints";
    return opts;
  }
  bubble() {
    return {
      dataLabels: {
        style: {
          colors: ["#fff"]
        }
      },
      tooltip: {
        shared: false,
        intersect: true
      },
      xaxis: {
        crosshairs: {
          width: 0
        }
      },
      fill: {
        type: "solid",
        gradient: {
          shade: "light",
          inverse: true,
          shadeIntensity: 0.55,
          opacityFrom: 0.4,
          opacityTo: 0.8
        }
      }
    };
  }
  scatter() {
    return {
      dataLabels: {
        enabled: false
      },
      tooltip: {
        shared: false,
        intersect: true
      },
      markers: {
        size: 6,
        strokeWidth: 1,
        hover: {
          sizeOffset: 2
        }
      }
    };
  }
  heatmap() {
    return {
      chart: {
        stacked: false
      },
      fill: {
        opacity: 1
      },
      dataLabels: {
        style: {
          colors: ["#fff"]
        }
      },
      stroke: {
        colors: ["#fff"]
      },
      tooltip: {
        followCursor: true,
        marker: {
          show: false
        },
        x: {
          show: false
        }
      },
      legend: {
        position: "top",
        markers: {
          shape: "square"
        }
      },
      grid: {
        padding: {
          right: 20
        }
      }
    };
  }
  treemap() {
    return {
      chart: {
        zoom: {
          enabled: false
        }
      },
      dataLabels: {
        style: {
          fontSize: 14,
          fontWeight: 600,
          colors: ["#fff"]
        }
      },
      stroke: {
        show: true,
        width: 2,
        colors: ["#fff"]
      },
      legend: {
        show: false
      },
      fill: {
        opacity: 1,
        gradient: {
          stops: [0, 100]
        }
      },
      tooltip: {
        followCursor: true,
        x: {
          show: false
        }
      },
      grid: {
        padding: {
          left: 0,
          right: 0
        }
      },
      xaxis: {
        crosshairs: {
          show: false
        },
        tooltip: {
          enabled: false
        }
      }
    };
  }
  pie() {
    return {
      chart: {
        toolbar: {
          show: false
        }
      },
      plotOptions: {
        pie: {
          donut: {
            labels: {
              show: false
            }
          }
        }
      },
      dataLabels: {
        formatter(val) {
          return val.toFixed(1) + "%";
        },
        style: {
          colors: ["#fff"]
        },
        background: {
          enabled: false
        },
        dropShadow: {
          enabled: true
        }
      },
      stroke: {
        colors: ["#fff"]
      },
      fill: {
        opacity: 1,
        gradient: {
          shade: "light",
          stops: [0, 100]
        }
      },
      tooltip: {
        theme: "dark",
        fillSeriesColor: true
      },
      legend: {
        position: "right"
      },
      grid: {
        padding: {
          left: 0,
          right: 0,
          top: 0,
          bottom: 0
        }
      }
    };
  }
  donut() {
    return {
      chart: {
        toolbar: {
          show: false
        }
      },
      dataLabels: {
        formatter(val) {
          return val.toFixed(1) + "%";
        },
        style: {
          colors: ["#fff"]
        },
        background: {
          enabled: false
        },
        dropShadow: {
          enabled: true
        }
      },
      stroke: {
        colors: ["#fff"]
      },
      fill: {
        opacity: 1,
        gradient: {
          shade: "light",
          shadeIntensity: 0.35,
          stops: [80, 100],
          opacityFrom: 1,
          opacityTo: 1
        }
      },
      tooltip: {
        theme: "dark",
        fillSeriesColor: true
      },
      legend: {
        position: "right"
      },
      grid: {
        padding: {
          left: 0,
          right: 0,
          top: 0,
          bottom: 0
        }
      }
    };
  }
  polarArea() {
    return {
      chart: {
        toolbar: {
          show: false
        }
      },
      dataLabels: {
        formatter(val) {
          return val.toFixed(1) + "%";
        },
        enabled: false
      },
      stroke: {
        show: true,
        width: 2
      },
      fill: {
        opacity: 0.7
      },
      tooltip: {
        theme: "dark",
        fillSeriesColor: true
      },
      legend: {
        position: "right"
      },
      grid: {
        padding: {
          left: 0,
          right: 0,
          top: 0,
          bottom: 0
        }
      }
    };
  }
  radar() {
    this.opts.yaxis[0].labels.offsetY = this.opts.yaxis[0].labels.offsetY ? this.opts.yaxis[0].labels.offsetY : 6;
    return {
      dataLabels: {
        enabled: false,
        style: {
          fontSize: "11px"
        }
      },
      stroke: {
        width: 2
      },
      markers: {
        size: 5,
        strokeWidth: 1,
        strokeOpacity: 1
      },
      fill: {
        opacity: 0.2
      },
      tooltip: {
        shared: false,
        intersect: true,
        followCursor: true
      },
      grid: {
        show: false,
        padding: {
          left: 0,
          right: 0,
          top: 0,
          bottom: 0
        }
      },
      xaxis: {
        labels: {
          formatter: (val) => val,
          style: {
            colors: ["#a8a8a8"],
            fontSize: "11px"
          }
        },
        tooltip: {
          enabled: false
        },
        crosshairs: {
          show: false
        }
      }
    };
  }
  radialBar() {
    return {
      chart: {
        animations: {
          dynamicAnimation: {
            enabled: true,
            speed: 800
          }
        },
        toolbar: {
          show: false
        }
      },
      fill: {
        gradient: {
          shade: "dark",
          shadeIntensity: 0.4,
          inverseColors: false,
          type: "diagonal2",
          opacityFrom: 1,
          opacityTo: 1,
          stops: [70, 98, 100]
        }
      },
      legend: {
        show: false,
        position: "right"
      },
      tooltip: {
        enabled: false,
        fillSeriesColor: true
      },
      grid: {
        padding: {
          left: 0,
          right: 0,
          top: 0,
          bottom: 0
        }
      }
    };
  }
  _getBoxTooltip(w, seriesIndex, dataPointIndex, labels, chartType) {
    const o = w.globals.seriesCandleO[seriesIndex][dataPointIndex];
    const h2 = w.globals.seriesCandleH[seriesIndex][dataPointIndex];
    const m2 = w.globals.seriesCandleM[seriesIndex][dataPointIndex];
    const l = w.globals.seriesCandleL[seriesIndex][dataPointIndex];
    const c = w.globals.seriesCandleC[seriesIndex][dataPointIndex];
    if (w.config.series[seriesIndex].type && w.config.series[seriesIndex].type !== chartType) {
      return `<div class="apexcharts-custom-tooltip">
          ${w.config.series[seriesIndex].name ? w.config.series[seriesIndex].name : "series-" + (seriesIndex + 1)}: <strong>${w.globals.series[seriesIndex][dataPointIndex]}</strong>
        </div>`;
    } else {
      return `<div class="apexcharts-tooltip-box apexcharts-tooltip-${w.config.chart.type}"><div>${labels[0]}: <span class="value">` + o + `</span></div><div>${labels[1]}: <span class="value">` + h2 + "</span></div>" + (m2 ? `<div>${labels[2]}: <span class="value">` + m2 + "</span></div>" : "") + `<div>${labels[3]}: <span class="value">` + l + `</span></div><div>${labels[4]}: <span class="value">` + c + "</span></div></div>";
    }
  }
}
class Config {
  constructor(opts) {
    this.opts = opts;
  }
  init({ responsiveOverride }) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j;
    let opts = this.opts;
    let options2 = new Options();
    let defaults2 = new Defaults(opts);
    this.chartType = opts.chart.type;
    opts = this.extendYAxis(opts);
    opts = this.extendAnnotations(opts);
    let config = options2.init();
    let newDefaults = {};
    if (opts && typeof opts === "object") {
      let chartDefaults = {};
      const chartTypes = [
        "line",
        "area",
        "bar",
        "candlestick",
        "boxPlot",
        "rangeBar",
        "rangeArea",
        "bubble",
        "scatter",
        "heatmap",
        "treemap",
        "pie",
        "polarArea",
        "donut",
        "radar",
        "radialBar"
      ];
      if (chartTypes.indexOf(opts.chart.type) !== -1) {
        chartDefaults = defaults2[opts.chart.type]();
      } else {
        chartDefaults = defaults2.line();
      }
      if ((_b = (_a = opts.plotOptions) == null ? void 0 : _a.bar) == null ? void 0 : _b.isFunnel) {
        chartDefaults = defaults2.funnel();
      }
      if (opts.chart.stacked && opts.chart.type === "bar") {
        chartDefaults = defaults2.stackedBars();
      }
      if ((_c = opts.chart.brush) == null ? void 0 : _c.enabled) {
        chartDefaults = defaults2.brush(chartDefaults);
      }
      if ((_e = (_d = opts.plotOptions) == null ? void 0 : _d.line) == null ? void 0 : _e.isSlopeChart) {
        chartDefaults = defaults2.slope();
      }
      if (opts.chart.stacked && opts.chart.stackType === "100%") {
        opts = defaults2.stacked100(opts);
      }
      if ((_g = (_f = opts.plotOptions) == null ? void 0 : _f.bar) == null ? void 0 : _g.isDumbbell) {
        opts = defaults2.dumbbell(opts);
      }
      this.checkForDarkTheme(window.Apex);
      this.checkForDarkTheme(opts);
      opts.xaxis = opts.xaxis || window.Apex.xaxis || {};
      if (!responsiveOverride) {
        opts.xaxis.convertedCatToNumeric = false;
      }
      opts = this.checkForCatToNumericXAxis(this.chartType, chartDefaults, opts);
      if (((_h = opts.chart.sparkline) == null ? void 0 : _h.enabled) || ((_j = (_i = window.Apex.chart) == null ? void 0 : _i.sparkline) == null ? void 0 : _j.enabled)) {
        chartDefaults = defaults2.sparkline(chartDefaults);
      }
      newDefaults = Utils$1.extend(config, chartDefaults);
    }
    let mergedWithDefaultConfig = Utils$1.extend(newDefaults, window.Apex);
    config = Utils$1.extend(mergedWithDefaultConfig, opts);
    config = this.handleUserInputErrors(config);
    return config;
  }
  checkForCatToNumericXAxis(chartType, chartDefaults, opts) {
    var _a, _b;
    let defaults2 = new Defaults(opts);
    const isBarHorizontal = (chartType === "bar" || chartType === "boxPlot") && ((_b = (_a = opts.plotOptions) == null ? void 0 : _a.bar) == null ? void 0 : _b.horizontal);
    const unsupportedZoom = chartType === "pie" || chartType === "polarArea" || chartType === "donut" || chartType === "radar" || chartType === "radialBar" || chartType === "heatmap";
    const notNumericXAxis = opts.xaxis.type !== "datetime" && opts.xaxis.type !== "numeric";
    let tickPlacement = opts.xaxis.tickPlacement ? opts.xaxis.tickPlacement : chartDefaults.xaxis && chartDefaults.xaxis.tickPlacement;
    if (!isBarHorizontal && !unsupportedZoom && notNumericXAxis && tickPlacement !== "between") {
      opts = defaults2.convertCatToNumeric(opts);
    }
    return opts;
  }
  extendYAxis(opts, w) {
    let options2 = new Options();
    if (typeof opts.yaxis === "undefined" || !opts.yaxis || Array.isArray(opts.yaxis) && opts.yaxis.length === 0) {
      opts.yaxis = {};
    }
    if (opts.yaxis.constructor !== Array && window.Apex.yaxis && window.Apex.yaxis.constructor !== Array) {
      opts.yaxis = Utils$1.extend(opts.yaxis, window.Apex.yaxis);
    }
    if (opts.yaxis.constructor !== Array) {
      opts.yaxis = [Utils$1.extend(options2.yAxis, opts.yaxis)];
    } else {
      opts.yaxis = Utils$1.extendArray(opts.yaxis, options2.yAxis);
    }
    let isLogY = false;
    opts.yaxis.forEach((y) => {
      if (y.logarithmic) {
        isLogY = true;
      }
    });
    let series = opts.series;
    if (w && !series) {
      series = w.config.series;
    }
    if (isLogY && series.length !== opts.yaxis.length && series.length) {
      opts.yaxis = series.map((s, i) => {
        if (!s.name) {
          series[i].name = `series-${i + 1}`;
        }
        if (opts.yaxis[i]) {
          opts.yaxis[i].seriesName = series[i].name;
          return opts.yaxis[i];
        } else {
          const newYaxis = Utils$1.extend(options2.yAxis, opts.yaxis[0]);
          newYaxis.show = false;
          return newYaxis;
        }
      });
    }
    if (isLogY && series.length > 1 && series.length !== opts.yaxis.length) {
      console.warn(
        "A multi-series logarithmic chart should have equal number of series and y-axes"
      );
    }
    return opts;
  }
  // annotations also accepts array, so we need to extend them manually
  extendAnnotations(opts) {
    if (typeof opts.annotations === "undefined") {
      opts.annotations = {};
      opts.annotations.yaxis = [];
      opts.annotations.xaxis = [];
      opts.annotations.points = [];
    }
    opts = this.extendYAxisAnnotations(opts);
    opts = this.extendXAxisAnnotations(opts);
    opts = this.extendPointAnnotations(opts);
    return opts;
  }
  extendYAxisAnnotations(opts) {
    let options2 = new Options();
    opts.annotations.yaxis = Utils$1.extendArray(
      typeof opts.annotations.yaxis !== "undefined" ? opts.annotations.yaxis : [],
      options2.yAxisAnnotation
    );
    return opts;
  }
  extendXAxisAnnotations(opts) {
    let options2 = new Options();
    opts.annotations.xaxis = Utils$1.extendArray(
      typeof opts.annotations.xaxis !== "undefined" ? opts.annotations.xaxis : [],
      options2.xAxisAnnotation
    );
    return opts;
  }
  extendPointAnnotations(opts) {
    let options2 = new Options();
    opts.annotations.points = Utils$1.extendArray(
      typeof opts.annotations.points !== "undefined" ? opts.annotations.points : [],
      options2.pointAnnotation
    );
    return opts;
  }
  checkForDarkTheme(opts) {
    if (opts.theme && opts.theme.mode === "dark") {
      if (!opts.tooltip) {
        opts.tooltip = {};
      }
      if (opts.tooltip.theme !== "light") {
        opts.tooltip.theme = "dark";
      }
      if (!opts.chart.foreColor) {
        opts.chart.foreColor = "#f6f7f8";
      }
      if (!opts.theme.palette) {
        opts.theme.palette = "palette4";
      }
    }
  }
  handleUserInputErrors(opts) {
    let config = opts;
    if (config.tooltip.shared && config.tooltip.intersect) {
      throw new Error(
        "tooltip.shared cannot be enabled when tooltip.intersect is true. Turn off any other option by setting it to false."
      );
    }
    if (config.chart.type === "bar" && config.plotOptions.bar.horizontal) {
      if (config.yaxis.length > 1) {
        throw new Error(
          "Multiple Y Axis for bars are not supported. Switch to column chart by setting plotOptions.bar.horizontal=false"
        );
      }
      if (config.yaxis[0].reversed) {
        config.yaxis[0].opposite = true;
      }
      config.xaxis.tooltip.enabled = false;
      config.yaxis[0].tooltip.enabled = false;
      config.chart.zoom.enabled = false;
    }
    if (config.chart.type === "bar" || config.chart.type === "rangeBar") {
      if (config.tooltip.shared) {
        if (config.xaxis.crosshairs.width === "barWidth" && config.series.length > 1) {
          config.xaxis.crosshairs.width = "tickWidth";
        }
      }
    }
    if (config.chart.type === "candlestick" || config.chart.type === "boxPlot") {
      if (config.yaxis[0].reversed) {
        console.warn(
          `Reversed y-axis in ${config.chart.type} chart is not supported.`
        );
        config.yaxis[0].reversed = false;
      }
    }
    return config;
  }
}
class Globals {
  initGlobalVars(gl) {
    gl.series = [];
    gl.seriesCandleO = [];
    gl.seriesCandleH = [];
    gl.seriesCandleM = [];
    gl.seriesCandleL = [];
    gl.seriesCandleC = [];
    gl.seriesRangeStart = [];
    gl.seriesRangeEnd = [];
    gl.seriesRange = [];
    gl.seriesPercent = [];
    gl.seriesGoals = [];
    gl.seriesX = [];
    gl.seriesZ = [];
    gl.seriesNames = [];
    gl.seriesTotals = [];
    gl.seriesLog = [];
    gl.seriesColors = [];
    gl.stackedSeriesTotals = [];
    gl.seriesXvalues = [];
    gl.seriesYvalues = [];
    gl.dataWasParsed = false;
    gl.originalSeries = null;
    gl.labels = [];
    gl.hasXaxisGroups = false;
    gl.groups = [];
    gl.barGroups = [];
    gl.lineGroups = [];
    gl.areaGroups = [];
    gl.hasSeriesGroups = false;
    gl.seriesGroups = [];
    gl.categoryLabels = [];
    gl.timescaleLabels = [];
    gl.noLabelsProvided = false;
    gl.resizeTimer = null;
    gl.selectionResizeTimer = null;
    gl.lastWheelExecution = 0;
    gl.delayedElements = [];
    gl.pointsArray = [];
    gl.dataLabelsRects = [];
    gl.textRectsCache = /* @__PURE__ */ new Map();
    gl.domCache = /* @__PURE__ */ new Map();
    gl.dimensionCache = {};
    gl.cachedSelectors = {};
    gl.isXNumeric = false;
    gl.skipLastTimelinelabel = false;
    gl.skipFirstTimelinelabel = false;
    gl.isDataXYZ = false;
    gl.isMultiLineX = false;
    gl.isMultipleYAxis = false;
    gl.maxY = -Number.MAX_VALUE;
    gl.minY = Number.MIN_VALUE;
    gl.minYArr = [];
    gl.maxYArr = [];
    gl.maxX = -Number.MAX_VALUE;
    gl.minX = Number.MAX_VALUE;
    gl.initialMaxX = -Number.MAX_VALUE;
    gl.initialMinX = Number.MAX_VALUE;
    gl.maxDate = 0;
    gl.minDate = Number.MAX_VALUE;
    gl.minZ = Number.MAX_VALUE;
    gl.maxZ = -Number.MAX_VALUE;
    gl.minXDiff = Number.MAX_VALUE;
    gl.yAxisScale = [];
    gl.xAxisScale = null;
    gl.xAxisTicksPositions = [];
    gl.yLabelsCoords = [];
    gl.yTitleCoords = [];
    gl.barPadForNumericAxis = 0;
    gl.padHorizontal = 0;
    gl.xRange = 0;
    gl.yRange = [];
    gl.zRange = 0;
    gl.dataPoints = 0;
    gl.xTickAmount = 0;
    gl.multiAxisTickAmount = 0;
  }
  globalVars(config) {
    return {
      chartID: null,
      // chart ID - apexcharts-cuid
      cuid: null,
      // chart ID - random numbers excluding "apexcharts" part
      events: {
        beforeMount: [],
        mounted: [],
        updated: [],
        clicked: [],
        selection: [],
        dataPointSelection: [],
        zoomed: [],
        scrolled: []
      },
      colors: [],
      clientX: null,
      clientY: null,
      fill: {
        colors: []
      },
      stroke: {
        colors: []
      },
      dataLabels: {
        style: {
          colors: []
        }
      },
      radarPolygons: {
        fill: {
          colors: []
        }
      },
      markers: {
        colors: [],
        size: config.markers.size,
        largestSize: 0
      },
      animationEnded: false,
      isTouchDevice: "ontouchstart" in window || navigator.msMaxTouchPoints,
      isDirty: false,
      // chart has been updated after the initial render. This is different than dataChanged property. isDirty means user manually called some method to update
      isExecCalled: false,
      // whether user updated the chart through the exec method
      initialConfig: null,
      // we will store the first config user has set to go back when user finishes interactions like zooming and come out of it
      initialSeries: [],
      lastXAxis: [],
      lastYAxis: [],
      columnSeries: null,
      labels: [],
      // store the text to draw on x axis
      // Don't mutate the labels, many things including tooltips depends on it!
      timescaleLabels: [],
      // store the timescaleLabels Labels in another variable
      noLabelsProvided: false,
      // if user didn't provide any categories/labels or x values, fallback to 1,2,3,4...
      allSeriesCollapsed: false,
      collapsedSeries: [],
      // when user collapses a series, it goes into this array
      collapsedSeriesIndices: [],
      // this stores the index of the collapsedSeries instead of whole object for quick access
      ancillaryCollapsedSeries: [],
      // when user collapses an "alwaysVisible" series, it goes into this array
      ancillaryCollapsedSeriesIndices: [],
      // this stores the index of the ancillaryCollapsedSeries whose y-axis is always visible
      risingSeries: [],
      // when user re-opens a collapsed series, it goes here
      dataFormatXNumeric: false,
      // boolean value to indicate user has passed numeric x values
      capturedSeriesIndex: -1,
      capturedDataPointIndex: -1,
      selectedDataPoints: [],
      invalidLogScale: false,
      // if a user enabled log scale but the data provided is not valid to generate a log scale, turn on this flag
      ignoreYAxisIndexes: [],
      // when series are being collapsed in multiple y axes, ignore certain index
      maxValsInArrayIndex: 0,
      radialSize: 0,
      selection: void 0,
      zoomEnabled: config.chart.toolbar.autoSelected === "zoom" && config.chart.toolbar.tools.zoom && config.chart.zoom.enabled,
      panEnabled: config.chart.toolbar.autoSelected === "pan" && config.chart.toolbar.tools.pan,
      selectionEnabled: config.chart.toolbar.autoSelected === "selection" && config.chart.toolbar.tools.selection,
      yaxis: null,
      mousedown: false,
      lastClientPosition: {},
      // don't reset this variable this the chart is destroyed. It is used to detect right or left mousemove in panning
      visibleXRange: void 0,
      yValueDecimal: 0,
      // are there floating numbers in the series. If yes, this represent the len of the decimals
      total: 0,
      SVGNS: "http://www.w3.org/2000/svg",
      // svg namespace
      svgWidth: 0,
      // the whole svg width
      svgHeight: 0,
      // the whole svg height
      noData: false,
      // whether there is any data to display or not
      locale: {},
      // the current locale values will be preserved here for global access
      dom: {},
      // for storing all dom nodes in this particular property
      memory: {
        methodsToExec: []
      },
      domCache: /* @__PURE__ */ new Map(),
      dimensionCache: {},
      cachedSelectors: {},
      resizeObserver: null,
      shouldAnimate: true,
      skipLastTimelinelabel: false,
      // when last label is cropped, skip drawing it
      skipFirstTimelinelabel: false,
      // when first label is cropped, skip drawing it
      delayedElements: [],
      // element which appear after animation has finished
      axisCharts: true,
      // chart type = line or area or bar
      // (refer them also as plot charts in the code)
      isDataXYZ: false,
      // bool: data was provided in a {[x,y,z]} pattern
      isSlopeChart: config.plotOptions.line.isSlopeChart,
      resized: false,
      // bool: user has resized
      resizeTimer: null,
      // timeout function to make a small delay before
      // drawing when user resized
      comboCharts: false,
      // bool: whether it's a combination of line/column
      dataChanged: false,
      // bool: has data changed dynamically
      previousPaths: [],
      // array: when data is changed, it will animate from
      // previous paths
      allSeriesHasEqualX: true,
      pointsArray: [],
      // store the points positions here to draw later on hover
      // format is - [[x,y],[x,y]... [x,y]]
      dataLabelsRects: [],
      // store the positions of datalabels to prevent collision
      lastDrawnDataLabelsIndexes: [],
      hasNullValues: false,
      // bool: whether series contains null values
      zoomed: false,
      // whether user has zoomed or not
      gridWidth: 0,
      // drawable width of actual graphs (series paths)
      gridHeight: 0,
      // drawable height of actual graphs (series paths)
      rotateXLabels: false,
      defaultLabels: false,
      xLabelFormatter: void 0,
      // formatter for x axis labels
      yLabelFormatters: [],
      xaxisTooltipFormatter: void 0,
      // formatter for x axis tooltip
      ttKeyFormatter: void 0,
      ttVal: void 0,
      ttZFormatter: void 0,
      LINE_HEIGHT_RATIO: 1.618,
      xAxisLabelsHeight: 0,
      xAxisGroupLabelsHeight: 0,
      xAxisLabelsWidth: 0,
      yAxisLabelsWidth: 0,
      scaleX: 1,
      scaleY: 1,
      translateX: 0,
      translateY: 0,
      translateYAxisX: [],
      yAxisWidths: [],
      translateXAxisY: 0,
      translateXAxisX: 0,
      tooltip: null,
      // Rules for niceScaleAllowedMagMsd:
      // 1) An array of two arrays only ([[],[]]):
      //    * array[0][]: influences labelling of data series that contain only integers
      //       - must contain only integers (or expect ugly ticks)
      //    * array[1][]: influences labelling of data series that contain at least one float
      //       - may contain floats
      //    * both arrays:
      //       - each array[][i] ideally satisfy: 10 mod array[][i] == 0 (or expect ugly ticks)
      //       - to avoid clipping data point keep each array[][i] >= i
      // 2) each array[i][] contains 11 values, for all possible index values 0..10.
      //    array[][0] should not be needed (not proven) but ensures non-zero is returned.
      //
      // Users can effectively force their preferred "magMsd" through stepSize and
      // forceNiceScale. With forceNiceScale: true, stepSize becomes normalizable to the
      // axis's min..max range, which allows users to set stepSize to an integer 1..10, for
      // example, stepSize: 3. This value will be preferred to the value determined through
      // this array. The range-normalized value is checked for consistency with other
      // user defined options and will be ignored if inconsistent.
      niceScaleAllowedMagMsd: [
        [1, 1, 2, 5, 5, 5, 10, 10, 10, 10, 10],
        [1, 1, 2, 5, 5, 5, 10, 10, 10, 10, 10]
      ],
      // Default ticks based on SVG size. These values have high numbers
      // of divisors. The array is indexed using a calculated maxTicks value
      // divided by 2 simply to halve the array size. See Scales.niceScale().
      niceScaleDefaultTicks: [
        1,
        2,
        4,
        4,
        6,
        6,
        6,
        6,
        6,
        6,
        6,
        6,
        6,
        6,
        6,
        6,
        6,
        6,
        12,
        12,
        12,
        12,
        12,
        12,
        12,
        12,
        12,
        24
      ],
      seriesYAxisMap: [],
      // Given yAxis index, return all series indices belonging to it. Multiple series can be referenced to each yAxis.
      seriesYAxisReverseMap: []
      // Given a Series index, return its yAxis index.
    };
  }
  init(config) {
    let globals = this.globalVars(config);
    this.initGlobalVars(globals);
    globals.initialConfig = Utils$1.extend({}, config);
    globals.initialSeries = Utils$1.clone(config.series);
    globals.lastXAxis = Utils$1.clone(globals.initialConfig.xaxis);
    globals.lastYAxis = Utils$1.clone(globals.initialConfig.yaxis);
    return globals;
  }
}
class Base {
  constructor(opts) {
    this.opts = opts;
  }
  init() {
    const config = new Config(this.opts).init({ responsiveOverride: false });
    const globals = new Globals().init(config);
    const w = {
      config,
      globals
    };
    return w;
  }
}
class Fill {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
    this.opts = null;
    this.seriesIndex = 0;
    this.patternIDs = [];
  }
  clippedImgArea(params) {
    let w = this.w;
    let cnf = w.config;
    let svgW = parseInt(w.globals.gridWidth, 10);
    let svgH = parseInt(w.globals.gridHeight, 10);
    let size = svgW > svgH ? svgW : svgH;
    let fillImg = params.image;
    let imgWidth = 0;
    let imgHeight = 0;
    if (typeof params.width === "undefined" && typeof params.height === "undefined") {
      if (cnf.fill.image.width !== void 0 && cnf.fill.image.height !== void 0) {
        imgWidth = cnf.fill.image.width + 1;
        imgHeight = cnf.fill.image.height;
      } else {
        imgWidth = size + 1;
        imgHeight = size;
      }
    } else {
      imgWidth = params.width;
      imgHeight = params.height;
    }
    let elPattern = document.createElementNS(w.globals.SVGNS, "pattern");
    Graphics.setAttrs(elPattern, {
      id: params.patternID,
      patternUnits: params.patternUnits ? params.patternUnits : "userSpaceOnUse",
      width: imgWidth + "px",
      height: imgHeight + "px"
    });
    let elImage = document.createElementNS(w.globals.SVGNS, "image");
    elPattern.appendChild(elImage);
    elImage.setAttributeNS(window.SVG.xlink, "href", fillImg);
    Graphics.setAttrs(elImage, {
      x: 0,
      y: 0,
      preserveAspectRatio: "none",
      width: imgWidth + "px",
      height: imgHeight + "px"
    });
    elImage.style.opacity = params.opacity;
    w.globals.dom.elDefs.node.appendChild(elPattern);
  }
  getSeriesIndex(opts) {
    const w = this.w;
    const cType = w.config.chart.type;
    if ((cType === "bar" || cType === "rangeBar") && w.config.plotOptions.bar.distributed || cType === "heatmap" || cType === "treemap") {
      this.seriesIndex = opts.seriesNumber;
    } else {
      this.seriesIndex = opts.seriesNumber % w.globals.series.length;
    }
    return this.seriesIndex;
  }
  computeColorStops(data, multiColorConfig) {
    const w = this.w;
    let maxPositive = null;
    let minNegative = null;
    for (let value of data) {
      if (value >= multiColorConfig.threshold) {
        if (maxPositive === null || value > maxPositive) {
          maxPositive = value;
        }
      } else {
        if (minNegative === null || value < minNegative) {
          minNegative = value;
        }
      }
    }
    if (maxPositive === null) {
      maxPositive = multiColorConfig.threshold;
    }
    if (minNegative === null) {
      minNegative = multiColorConfig.threshold;
    }
    let totalRange = maxPositive - multiColorConfig.threshold + (multiColorConfig.threshold - minNegative);
    if (totalRange === 0) {
      totalRange = 1;
    }
    let negativePercentage = (multiColorConfig.threshold - minNegative) / totalRange * 100;
    let offset2 = 100 - negativePercentage;
    offset2 = Math.max(0, Math.min(offset2, 100));
    return [
      {
        offset: offset2,
        color: multiColorConfig.colorAboveThreshold,
        opacity: w.config.fill.opacity
      },
      {
        offset: 0,
        color: multiColorConfig.colorBelowThreshold,
        opacity: w.config.fill.opacity
      }
    ];
  }
  fillPath(opts) {
    var _a, _b, _c, _d, _e, _f;
    let w = this.w;
    this.opts = opts;
    let cnf = this.w.config;
    let pathFill;
    let patternFill, gradientFill;
    this.seriesIndex = this.getSeriesIndex(opts);
    const drawMultiColorLine = cnf.plotOptions.line.colors.colorAboveThreshold && cnf.plotOptions.line.colors.colorBelowThreshold;
    let fillColors = this.getFillColors();
    let fillColor = fillColors[this.seriesIndex];
    if (w.globals.seriesColors[this.seriesIndex] !== void 0) {
      fillColor = w.globals.seriesColors[this.seriesIndex];
    }
    if (typeof fillColor === "function") {
      fillColor = fillColor({
        seriesIndex: this.seriesIndex,
        dataPointIndex: opts.dataPointIndex,
        value: opts.value,
        w
      });
    }
    let fillType = opts.fillType ? opts.fillType : this.getFillType(this.seriesIndex);
    let fillOpacity = Array.isArray(cnf.fill.opacity) ? cnf.fill.opacity[this.seriesIndex] : cnf.fill.opacity;
    const useGradient = fillType === "gradient" || drawMultiColorLine;
    if (opts.color) {
      fillColor = opts.color;
    }
    if ((_c = (_b = (_a = w.config.series[this.seriesIndex]) == null ? void 0 : _a.data) == null ? void 0 : _b[opts.dataPointIndex]) == null ? void 0 : _c.fillColor) {
      fillColor = (_f = (_e = (_d = w.config.series[this.seriesIndex]) == null ? void 0 : _d.data) == null ? void 0 : _e[opts.dataPointIndex]) == null ? void 0 : _f.fillColor;
    }
    if (!fillColor) {
      fillColor = "#fff";
      console.warn("undefined color - ApexCharts");
    }
    if (Utils$1.isCSSVariable(fillColor)) {
      fillColor = Utils$1.getThemeColor(fillColor);
    }
    let defaultColor = fillColor;
    if (fillColor.indexOf("rgb") === -1) {
      if (fillColor.indexOf("#") === -1) {
        defaultColor = fillColor;
      } else if (fillColor.length < 9) {
        defaultColor = Utils$1.hexToRgba(fillColor, fillOpacity);
      }
    } else {
      if (fillColor.indexOf("rgba") > -1) {
        fillOpacity = Utils$1.getOpacityFromRGBA(fillColor);
      } else {
        defaultColor = Utils$1.hexToRgba(Utils$1.rgb2hex(fillColor), fillOpacity);
      }
    }
    if (opts.opacity) fillOpacity = opts.opacity;
    if (fillType === "pattern") {
      patternFill = this.handlePatternFill({
        fillConfig: opts.fillConfig,
        patternFill,
        fillColor,
        fillOpacity,
        defaultColor
      });
    }
    if (useGradient) {
      let colorStops = cnf.fill.gradient.colorStops ? [...cnf.fill.gradient.colorStops] : [];
      let type = cnf.fill.gradient.type;
      if (drawMultiColorLine) {
        colorStops[this.seriesIndex] = this.computeColorStops(
          w.globals.series[this.seriesIndex],
          cnf.plotOptions.line.colors
        );
        type = "vertical";
      }
      gradientFill = this.handleGradientFill({
        type,
        fillConfig: opts.fillConfig,
        fillColor,
        fillOpacity,
        colorStops,
        i: this.seriesIndex
      });
    }
    if (fillType === "image") {
      let imgSrc = cnf.fill.image.src;
      let patternID = opts.patternID ? opts.patternID : "";
      const patternKey = `pattern${w.globals.cuid}${opts.seriesNumber + 1}${patternID}`;
      if (this.patternIDs.indexOf(patternKey) === -1) {
        this.clippedImgArea({
          opacity: fillOpacity,
          image: Array.isArray(imgSrc) ? opts.seriesNumber < imgSrc.length ? imgSrc[opts.seriesNumber] : imgSrc[0] : imgSrc,
          width: opts.width ? opts.width : void 0,
          height: opts.height ? opts.height : void 0,
          patternUnits: opts.patternUnits,
          patternID: patternKey
        });
        this.patternIDs.push(patternKey);
      }
      pathFill = `url(#${patternKey})`;
    } else if (useGradient) {
      pathFill = gradientFill;
    } else if (fillType === "pattern") {
      pathFill = patternFill;
    } else {
      pathFill = defaultColor;
    }
    if (opts.solid) {
      pathFill = defaultColor;
    }
    return pathFill;
  }
  getFillType(seriesIndex) {
    const w = this.w;
    if (Array.isArray(w.config.fill.type)) {
      return w.config.fill.type[seriesIndex];
    } else {
      return w.config.fill.type;
    }
  }
  getFillColors() {
    const w = this.w;
    const cnf = w.config;
    const opts = this.opts;
    let fillColors = [];
    if (w.globals.comboCharts) {
      if (w.config.series[this.seriesIndex].type === "line") {
        if (Array.isArray(w.globals.stroke.colors)) {
          fillColors = w.globals.stroke.colors;
        } else {
          fillColors.push(w.globals.stroke.colors);
        }
      } else {
        if (Array.isArray(w.globals.fill.colors)) {
          fillColors = w.globals.fill.colors;
        } else {
          fillColors.push(w.globals.fill.colors);
        }
      }
    } else {
      if (cnf.chart.type === "line") {
        if (Array.isArray(w.globals.stroke.colors)) {
          fillColors = w.globals.stroke.colors;
        } else {
          fillColors.push(w.globals.stroke.colors);
        }
      } else {
        if (Array.isArray(w.globals.fill.colors)) {
          fillColors = w.globals.fill.colors;
        } else {
          fillColors.push(w.globals.fill.colors);
        }
      }
    }
    if (typeof opts.fillColors !== "undefined") {
      fillColors = [];
      if (Array.isArray(opts.fillColors)) {
        fillColors = opts.fillColors.slice();
      } else {
        fillColors.push(opts.fillColors);
      }
    }
    return fillColors;
  }
  handlePatternFill({
    fillConfig,
    patternFill,
    fillColor,
    fillOpacity,
    defaultColor
  }) {
    let fillCnf = this.w.config.fill;
    if (fillConfig) {
      fillCnf = fillConfig;
    }
    const opts = this.opts;
    let graphics = new Graphics(this.ctx);
    let patternStrokeWidth = Array.isArray(fillCnf.pattern.strokeWidth) ? fillCnf.pattern.strokeWidth[this.seriesIndex] : fillCnf.pattern.strokeWidth;
    let patternLineColor = fillColor;
    if (Array.isArray(fillCnf.pattern.style)) {
      if (typeof fillCnf.pattern.style[opts.seriesNumber] !== "undefined") {
        let pf = graphics.drawPattern(
          fillCnf.pattern.style[opts.seriesNumber],
          fillCnf.pattern.width,
          fillCnf.pattern.height,
          patternLineColor,
          patternStrokeWidth,
          fillOpacity
        );
        patternFill = pf;
      } else {
        patternFill = defaultColor;
      }
    } else {
      patternFill = graphics.drawPattern(
        fillCnf.pattern.style,
        fillCnf.pattern.width,
        fillCnf.pattern.height,
        patternLineColor,
        patternStrokeWidth,
        fillOpacity
      );
    }
    return patternFill;
  }
  handleGradientFill({
    type,
    fillColor,
    fillOpacity,
    fillConfig,
    colorStops,
    i
  }) {
    let fillCnf = this.w.config.fill;
    if (fillConfig) {
      fillCnf = __spreadValues(__spreadValues({}, fillCnf), fillConfig);
    }
    const opts = this.opts;
    let graphics = new Graphics(this.ctx);
    let utils = new Utils$1();
    type = type || fillCnf.gradient.type;
    let gradientFrom = fillColor;
    let gradientTo;
    let opacityFrom = fillCnf.gradient.opacityFrom === void 0 ? fillOpacity : Array.isArray(fillCnf.gradient.opacityFrom) ? fillCnf.gradient.opacityFrom[i] : fillCnf.gradient.opacityFrom;
    if (gradientFrom.indexOf("rgba") > -1) {
      opacityFrom = Utils$1.getOpacityFromRGBA(gradientFrom);
    }
    let opacityTo = fillCnf.gradient.opacityTo === void 0 ? fillOpacity : Array.isArray(fillCnf.gradient.opacityTo) ? fillCnf.gradient.opacityTo[i] : fillCnf.gradient.opacityTo;
    if (fillCnf.gradient.gradientToColors === void 0 || fillCnf.gradient.gradientToColors.length === 0) {
      if (fillCnf.gradient.shade === "dark") {
        gradientTo = utils.shadeColor(
          parseFloat(fillCnf.gradient.shadeIntensity) * -1,
          fillColor.indexOf("rgb") > -1 ? Utils$1.rgb2hex(fillColor) : fillColor
        );
      } else {
        gradientTo = utils.shadeColor(
          parseFloat(fillCnf.gradient.shadeIntensity),
          fillColor.indexOf("rgb") > -1 ? Utils$1.rgb2hex(fillColor) : fillColor
        );
      }
    } else {
      if (fillCnf.gradient.gradientToColors[opts.seriesNumber]) {
        const gToColor = fillCnf.gradient.gradientToColors[opts.seriesNumber];
        gradientTo = gToColor;
        if (gToColor.indexOf("rgba") > -1) {
          opacityTo = Utils$1.getOpacityFromRGBA(gToColor);
        }
      } else {
        gradientTo = fillColor;
      }
    }
    if (fillCnf.gradient.gradientFrom) {
      gradientFrom = fillCnf.gradient.gradientFrom;
    }
    if (fillCnf.gradient.gradientTo) {
      gradientTo = fillCnf.gradient.gradientTo;
    }
    if (fillCnf.gradient.inverseColors) {
      let t = gradientFrom;
      gradientFrom = gradientTo;
      gradientTo = t;
    }
    if (gradientFrom.indexOf("rgb") > -1) {
      gradientFrom = Utils$1.rgb2hex(gradientFrom);
    }
    if (gradientTo.indexOf("rgb") > -1) {
      gradientTo = Utils$1.rgb2hex(gradientTo);
    }
    return graphics.drawGradient(
      type,
      gradientFrom,
      gradientTo,
      opacityFrom,
      opacityTo,
      opts.size,
      fillCnf.gradient.stops,
      colorStops,
      i
    );
  }
}
class Markers {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
    this._filters = new Filters(this.ctx);
    this._graphics = new Graphics(this.ctx);
  }
  setGlobalMarkerSize() {
    const w = this.w;
    w.globals.markers.size = Array.isArray(w.config.markers.size) ? w.config.markers.size : [w.config.markers.size];
    if (w.globals.markers.size.length > 0) {
      if (w.globals.markers.size.length < w.globals.series.length + 1) {
        for (let i = 0; i <= w.globals.series.length; i++) {
          if (typeof w.globals.markers.size[i] === "undefined") {
            w.globals.markers.size.push(w.globals.markers.size[0]);
          }
        }
      }
    } else {
      w.globals.markers.size = w.config.series.map(() => w.config.markers.size);
    }
  }
  plotChartMarkers({
    pointsPos,
    seriesIndex,
    j,
    pSize,
    alwaysDrawMarker = false,
    isVirtualPoint = false
  }) {
    let w = this.w;
    let i = seriesIndex;
    let p = pointsPos;
    let elMarkersWrap = null;
    let graphics = new Graphics(this.ctx);
    const hasDiscreteMarkers = w.config.markers.discrete && w.config.markers.discrete.length;
    if (Array.isArray(p.x)) {
      for (let q = 0; q < p.x.length; q++) {
        let markerElement;
        let dataPointIndex = j;
        let invalidMarker = !Utils$1.isNumber(p.y[q]);
        if (w.globals.markers.largestSize === 0 && w.globals.hasNullValues && w.globals.series[i][j + 1] !== null && !isVirtualPoint) {
          invalidMarker = true;
        }
        if (j === 1 && q === 0) dataPointIndex = 0;
        if (j === 1 && q === 1) dataPointIndex = 1;
        let markerClasses = "apexcharts-marker";
        if ((w.config.chart.type === "line" || w.config.chart.type === "area") && !w.globals.comboCharts && !w.config.tooltip.intersect) {
          markerClasses += " no-pointer-events";
        }
        const shouldMarkerDraw = Array.isArray(w.config.markers.size) ? w.globals.markers.size[seriesIndex] > 0 : w.config.markers.size > 0;
        if (shouldMarkerDraw || alwaysDrawMarker || hasDiscreteMarkers) {
          if (!invalidMarker) {
            markerClasses += ` w${Utils$1.randomId()}`;
          }
          let opts = this.getMarkerConfig({
            cssClass: markerClasses,
            seriesIndex,
            dataPointIndex
          });
          if (w.config.series[i].data[dataPointIndex]) {
            if (w.config.series[i].data[dataPointIndex].fillColor) {
              opts.pointFillColor = w.config.series[i].data[dataPointIndex].fillColor;
            }
            if (w.config.series[i].data[dataPointIndex].strokeColor) {
              opts.pointStrokeColor = w.config.series[i].data[dataPointIndex].strokeColor;
            }
          }
          if (typeof pSize !== "undefined") {
            opts.pSize = pSize;
          }
          if (p.x[q] < -w.globals.markers.largestSize || p.x[q] > w.globals.gridWidth + w.globals.markers.largestSize || p.y[q] < -w.globals.markers.largestSize || p.y[q] > w.globals.gridHeight + w.globals.markers.largestSize) {
            opts.pSize = 0;
          }
          if (!invalidMarker) {
            const shouldCreateMarkerWrap = w.globals.markers.size[seriesIndex] > 0 || alwaysDrawMarker || hasDiscreteMarkers;
            if (shouldCreateMarkerWrap && !elMarkersWrap) {
              elMarkersWrap = graphics.group({
                class: alwaysDrawMarker || hasDiscreteMarkers ? "" : "apexcharts-series-markers"
              });
              elMarkersWrap.attr(
                "clip-path",
                `url(#gridRectMarkerMask${w.globals.cuid})`
              );
              this.setupMarkerDelegation(elMarkersWrap);
            }
            markerElement = graphics.drawMarker(p.x[q], p.y[q], opts);
            markerElement.attr("rel", dataPointIndex);
            markerElement.attr("j", dataPointIndex);
            markerElement.attr("index", seriesIndex);
            markerElement.node.setAttribute("default-marker-size", opts.pSize);
            this._filters.setSelectionFilter(
              markerElement,
              seriesIndex,
              dataPointIndex
            );
            if (elMarkersWrap) {
              elMarkersWrap.add(markerElement);
            }
          }
        } else {
          if (typeof w.globals.pointsArray[seriesIndex] === "undefined")
            w.globals.pointsArray[seriesIndex] = [];
          w.globals.pointsArray[seriesIndex].push([p.x[q], p.y[q]]);
        }
      }
    }
    return elMarkersWrap;
  }
  getMarkerConfig({
    cssClass,
    seriesIndex,
    dataPointIndex = null,
    radius = null,
    size = null,
    strokeWidth = null
  }) {
    const w = this.w;
    let pStyle = this.getMarkerStyle(seriesIndex);
    let pSize = size === null ? w.globals.markers.size[seriesIndex] : size;
    const m2 = w.config.markers;
    if (dataPointIndex !== null && m2.discrete.length) {
      m2.discrete.map((marker) => {
        if (marker.seriesIndex === seriesIndex && marker.dataPointIndex === dataPointIndex) {
          pStyle.pointStrokeColor = marker.strokeColor;
          pStyle.pointFillColor = marker.fillColor;
          pSize = marker.size;
          pStyle.pointShape = marker.shape;
        }
      });
    }
    return {
      pSize: radius === null ? pSize : radius,
      pRadius: radius !== null ? radius : m2.radius,
      pointStrokeWidth: strokeWidth !== null ? strokeWidth : Array.isArray(m2.strokeWidth) ? m2.strokeWidth[seriesIndex] : m2.strokeWidth,
      pointStrokeColor: pStyle.pointStrokeColor,
      pointFillColor: pStyle.pointFillColor,
      shape: pStyle.pointShape || (Array.isArray(m2.shape) ? m2.shape[seriesIndex] : m2.shape),
      class: cssClass,
      pointStrokeOpacity: Array.isArray(m2.strokeOpacity) ? m2.strokeOpacity[seriesIndex] : m2.strokeOpacity,
      pointStrokeDashArray: Array.isArray(m2.strokeDashArray) ? m2.strokeDashArray[seriesIndex] : m2.strokeDashArray,
      pointFillOpacity: Array.isArray(m2.fillOpacity) ? m2.fillOpacity[seriesIndex] : m2.fillOpacity,
      seriesIndex
    };
  }
  setupMarkerDelegation(parentGroup) {
    const w = this.w;
    const selector = ".apexcharts-marker";
    this._graphics.setupEventDelegation(parentGroup, selector);
    parentGroup.node.addEventListener("click", (e) => {
      if (w.config.markers.onClick) {
        const targetNode = Graphics._findDelegateTarget(
          e.target,
          parentGroup.node,
          selector
        );
        if (targetNode) w.config.markers.onClick(e);
      }
    });
    parentGroup.node.addEventListener("dblclick", (e) => {
      if (w.config.markers.onDblClick) {
        const targetNode = Graphics._findDelegateTarget(
          e.target,
          parentGroup.node,
          selector
        );
        if (targetNode) w.config.markers.onDblClick(e);
      }
    });
    parentGroup.node.addEventListener(
      "touchstart",
      (e) => {
        const targetNode = Graphics._findDelegateTarget(
          e.target,
          parentGroup.node,
          selector
        );
        if (targetNode && targetNode.instance) {
          this._graphics.pathMouseDown(targetNode.instance, e);
        }
      },
      { passive: true }
    );
  }
  addEvents(marker) {
    const w = this.w;
    marker.node.addEventListener(
      "mouseenter",
      this._graphics.pathMouseEnter.bind(this.ctx, marker)
    );
    marker.node.addEventListener(
      "mouseleave",
      this._graphics.pathMouseLeave.bind(this.ctx, marker)
    );
    marker.node.addEventListener(
      "mousedown",
      this._graphics.pathMouseDown.bind(this.ctx, marker)
    );
    marker.node.addEventListener("click", w.config.markers.onClick);
    marker.node.addEventListener("dblclick", w.config.markers.onDblClick);
    marker.node.addEventListener(
      "touchstart",
      this._graphics.pathMouseDown.bind(this.ctx, marker),
      { passive: true }
    );
  }
  getMarkerStyle(seriesIndex) {
    let w = this.w;
    let colors = w.globals.markers.colors;
    let strokeColors = w.config.markers.strokeColor || w.config.markers.strokeColors;
    let pointStrokeColor = Array.isArray(strokeColors) ? strokeColors[seriesIndex] : strokeColors;
    let pointFillColor = Array.isArray(colors) ? colors[seriesIndex] : colors;
    return {
      pointStrokeColor,
      pointFillColor
    };
  }
}
class Scatter {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
    this.initialAnim = this.w.config.chart.animations.enabled;
    this.anim = new Animations(this.ctx);
    this.filters = new Filters(this.ctx);
    this.fill = new Fill(this.ctx);
    this.markers = new Markers(this.ctx);
    this.graphics = new Graphics(this.ctx);
  }
  draw(elSeries, j, opts) {
    let w = this.w;
    let graphics = this.graphics;
    let realIndex = opts.realIndex;
    let pointsPos = opts.pointsPos;
    let zRatio = opts.zRatio;
    let elPointsMain = opts.elParent;
    let elPointsWrap = graphics.group({
      class: `apexcharts-series-markers apexcharts-series-${w.config.chart.type}`
    });
    elPointsWrap.attr("clip-path", `url(#gridRectMarkerMask${w.globals.cuid})`);
    this.markers.setupMarkerDelegation(elPointsWrap);
    if (Array.isArray(pointsPos.x)) {
      for (let q = 0; q < pointsPos.x.length; q++) {
        let dataPointIndex = j + 1;
        let shouldDraw = true;
        if (j === 0 && q === 0) dataPointIndex = 0;
        if (j === 0 && q === 1) dataPointIndex = 1;
        let radius = w.globals.markers.size[realIndex];
        if (zRatio !== Infinity) {
          const bubble2 = w.config.plotOptions.bubble;
          radius = w.globals.seriesZ[realIndex][dataPointIndex];
          if (bubble2.zScaling) {
            radius /= zRatio;
          }
          if (bubble2.minBubbleRadius && radius < bubble2.minBubbleRadius) {
            radius = bubble2.minBubbleRadius;
          }
          if (bubble2.maxBubbleRadius && radius > bubble2.maxBubbleRadius) {
            radius = bubble2.maxBubbleRadius;
          }
        }
        let x = pointsPos.x[q];
        let y = pointsPos.y[q];
        radius = radius || 0;
        if (y === null || typeof w.globals.series[realIndex][dataPointIndex] === "undefined") {
          shouldDraw = false;
        }
        if (shouldDraw) {
          const point = this.drawPoint(
            x,
            y,
            radius,
            realIndex,
            dataPointIndex,
            j
          );
          elPointsWrap.add(point);
        }
        elPointsMain.add(elPointsWrap);
      }
    }
  }
  drawPoint(x, y, radius, realIndex, dataPointIndex, j) {
    const w = this.w;
    let i = realIndex;
    const anim = this.anim;
    const filters = this.filters;
    const fill = this.fill;
    const markers = this.markers;
    const graphics = this.graphics;
    const markerConfig = markers.getMarkerConfig({
      cssClass: "apexcharts-marker",
      seriesIndex: i,
      dataPointIndex,
      radius: w.config.chart.type === "bubble" || w.globals.comboCharts && w.config.series[realIndex] && w.config.series[realIndex].type === "bubble" ? radius : null
    });
    let pathFillCircle = fill.fillPath({
      seriesNumber: realIndex,
      dataPointIndex,
      color: markerConfig.pointFillColor,
      patternUnits: "objectBoundingBox",
      value: w.globals.series[realIndex][j]
    });
    let el = graphics.drawMarker(x, y, markerConfig);
    if (w.config.series[i].data[dataPointIndex]) {
      if (w.config.series[i].data[dataPointIndex].fillColor) {
        pathFillCircle = w.config.series[i].data[dataPointIndex].fillColor;
      }
    }
    el.attr({
      fill: pathFillCircle
    });
    if (w.config.chart.dropShadow.enabled) {
      const dropShadow = w.config.chart.dropShadow;
      filters.dropShadow(el, dropShadow, realIndex);
    }
    if (this.initialAnim && !w.globals.dataChanged && !w.globals.resized) {
      let speed = w.config.chart.animations.speed;
      anim.animateMarker(el, speed, w.globals.easing, () => {
        window.setTimeout(() => {
          anim.animationCompleted(el);
        }, 100);
      });
    } else {
      w.globals.animationEnded = true;
    }
    el.attr({
      rel: dataPointIndex,
      j: dataPointIndex,
      index: realIndex,
      "default-marker-size": markerConfig.pSize
    });
    filters.setSelectionFilter(el, realIndex, dataPointIndex);
    el.node.classList.add("apexcharts-marker");
    return el;
  }
  centerTextInBubble(y) {
    let w = this.w;
    y = y + parseInt(w.config.dataLabels.style.fontSize, 10) / 4;
    return {
      y
    };
  }
}
class DataLabels {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
  }
  // When there are many datalabels to be printed, and some of them overlaps each other in the same series, this method will take care of that
  // Also, when datalabels exceeds the drawable area and get clipped off, we need to adjust and move some pixels to make them visible again
  dataLabelsCorrection(x, y, val, i, dataPointIndex, alwaysDrawDataLabel, fontSize) {
    let w = this.w;
    let graphics = new Graphics(this.ctx);
    let drawnextLabel = false;
    let textRects = graphics.getTextRects(val, fontSize);
    let width = textRects.width;
    let height = textRects.height;
    if (y < 0) y = 0;
    if (y > w.globals.gridHeight + height) y = w.globals.gridHeight + height / 2;
    if (typeof w.globals.dataLabelsRects[i] === "undefined")
      w.globals.dataLabelsRects[i] = [];
    w.globals.dataLabelsRects[i].push({ x, y, width, height });
    let len = w.globals.dataLabelsRects[i].length - 2;
    let lastDrawnIndex = typeof w.globals.lastDrawnDataLabelsIndexes[i] !== "undefined" ? w.globals.lastDrawnDataLabelsIndexes[i][w.globals.lastDrawnDataLabelsIndexes[i].length - 1] : 0;
    if (typeof w.globals.dataLabelsRects[i][len] !== "undefined") {
      let lastDataLabelRect = w.globals.dataLabelsRects[i][lastDrawnIndex];
      if (
        // next label forward and x not intersecting
        x > lastDataLabelRect.x + lastDataLabelRect.width || y > lastDataLabelRect.y + lastDataLabelRect.height || y + height < lastDataLabelRect.y || x + width < lastDataLabelRect.x
      ) {
        drawnextLabel = true;
      }
    }
    if (dataPointIndex === 0 || alwaysDrawDataLabel) {
      drawnextLabel = true;
    }
    return {
      x,
      y,
      textRects,
      drawnextLabel
    };
  }
  drawDataLabel({ type, pos, i, j, isRangeStart, strokeWidth = 2 }) {
    let w = this.w;
    const graphics = new Graphics(this.ctx);
    let dataLabelsConfig = w.config.dataLabels;
    let x = 0;
    let y = 0;
    let dataPointIndex = j;
    let elDataLabelsWrap = null;
    const seriesCollapsed = w.globals.collapsedSeriesIndices.indexOf(i) !== -1;
    if (seriesCollapsed || !dataLabelsConfig.enabled || !Array.isArray(pos.x)) {
      return elDataLabelsWrap;
    }
    elDataLabelsWrap = graphics.group({
      class: "apexcharts-data-labels"
    });
    for (let q = 0; q < pos.x.length; q++) {
      x = pos.x[q] + dataLabelsConfig.offsetX;
      y = pos.y[q] + dataLabelsConfig.offsetY + strokeWidth;
      if (!isNaN(x)) {
        if (j === 1 && q === 0) dataPointIndex = 0;
        if (j === 1 && q === 1) dataPointIndex = 1;
        let val = w.globals.series[i][dataPointIndex];
        if (type === "rangeArea") {
          if (isRangeStart) {
            val = w.globals.seriesRangeStart[i][dataPointIndex];
          } else {
            val = w.globals.seriesRangeEnd[i][dataPointIndex];
          }
        }
        let text = "";
        const getText = (v) => {
          return w.config.dataLabels.formatter(v, {
            ctx: this.ctx,
            seriesIndex: i,
            dataPointIndex,
            w
          });
        };
        if (w.config.chart.type === "bubble") {
          val = w.globals.seriesZ[i][dataPointIndex];
          text = getText(val);
          y = pos.y[q];
          const scatter = new Scatter(this.ctx);
          let centerTextInBubbleCoords = scatter.centerTextInBubble(
            y,
            i,
            dataPointIndex
          );
          y = centerTextInBubbleCoords.y;
        } else {
          if (typeof val !== "undefined") {
            text = getText(val);
          }
        }
        let textAnchor = w.config.dataLabels.textAnchor;
        if (w.globals.isSlopeChart) {
          if (dataPointIndex === 0) {
            textAnchor = "end";
          } else if (dataPointIndex === w.config.series[i].data.length - 1) {
            textAnchor = "start";
          } else {
            textAnchor = "middle";
          }
        }
        this.plotDataLabelsText({
          x,
          y,
          text,
          i,
          j: dataPointIndex,
          parent: elDataLabelsWrap,
          offsetCorrection: true,
          dataLabelsConfig: w.config.dataLabels,
          textAnchor
        });
      }
    }
    return elDataLabelsWrap;
  }
  plotDataLabelsText(opts) {
    let w = this.w;
    let graphics = new Graphics(this.ctx);
    let {
      x,
      y,
      i,
      j,
      text,
      textAnchor,
      fontSize,
      parent,
      dataLabelsConfig,
      color,
      alwaysDrawDataLabel,
      offsetCorrection,
      className
    } = opts;
    let dataLabelText = null;
    if (Array.isArray(w.config.dataLabels.enabledOnSeries)) {
      if (w.config.dataLabels.enabledOnSeries.indexOf(i) < 0) {
        return dataLabelText;
      }
    }
    let correctedLabels = {
      x,
      y,
      drawnextLabel: true,
      textRects: null
    };
    if (offsetCorrection) {
      correctedLabels = this.dataLabelsCorrection(
        x,
        y,
        text,
        i,
        j,
        alwaysDrawDataLabel,
        parseInt(dataLabelsConfig.style.fontSize, 10)
      );
    }
    if (!w.globals.zoomed) {
      x = correctedLabels.x;
      y = correctedLabels.y;
    }
    if (correctedLabels.textRects) {
      if (x < -20 - correctedLabels.textRects.width || x > w.globals.gridWidth + correctedLabels.textRects.width + 30) {
        text = "";
      }
    }
    let dataLabelColor = w.globals.dataLabels.style.colors[i];
    if ((w.config.chart.type === "bar" || w.config.chart.type === "rangeBar") && w.config.plotOptions.bar.distributed || w.config.dataLabels.distributed) {
      dataLabelColor = w.globals.dataLabels.style.colors[j];
    }
    if (typeof dataLabelColor === "function") {
      dataLabelColor = dataLabelColor({
        series: w.globals.series,
        seriesIndex: i,
        dataPointIndex: j,
        w
      });
    }
    if (color) {
      dataLabelColor = color;
    }
    let offX = dataLabelsConfig.offsetX;
    let offY = dataLabelsConfig.offsetY;
    if (w.config.chart.type === "bar" || w.config.chart.type === "rangeBar") {
      offX = 0;
      offY = 0;
    }
    if (w.globals.isSlopeChart) {
      if (j !== 0) {
        offX = dataLabelsConfig.offsetX * -2 + 5;
      }
      if (j !== 0 && j !== w.config.series[i].data.length - 1) {
        offX = 0;
      }
    }
    if (correctedLabels.drawnextLabel) {
      if (textAnchor === "middle") {
        if (x === w.globals.gridWidth) {
          textAnchor = "end";
        }
      }
      dataLabelText = graphics.drawText({
        width: 100,
        height: parseInt(dataLabelsConfig.style.fontSize, 10),
        x: x + offX,
        y: y + offY,
        foreColor: dataLabelColor,
        textAnchor: textAnchor || dataLabelsConfig.textAnchor,
        text,
        fontSize: fontSize || dataLabelsConfig.style.fontSize,
        fontFamily: dataLabelsConfig.style.fontFamily,
        fontWeight: dataLabelsConfig.style.fontWeight || "normal"
      });
      dataLabelText.attr({
        class: className || "apexcharts-datalabel",
        cx: x,
        cy: y
      });
      if (dataLabelsConfig.dropShadow.enabled) {
        const textShadow = dataLabelsConfig.dropShadow;
        const filters = new Filters(this.ctx);
        filters.dropShadow(dataLabelText, textShadow);
      }
      parent.add(dataLabelText);
      if (typeof w.globals.lastDrawnDataLabelsIndexes[i] === "undefined") {
        w.globals.lastDrawnDataLabelsIndexes[i] = [];
      }
      w.globals.lastDrawnDataLabelsIndexes[i].push(j);
    }
    return dataLabelText;
  }
  addBackgroundToDataLabel(el, coords) {
    const w = this.w;
    const bCnf = w.config.dataLabels.background;
    const paddingH = bCnf.padding;
    const paddingV = bCnf.padding / 2;
    const width = coords.width;
    const height = coords.height;
    const graphics = new Graphics(this.ctx);
    const elRect = graphics.drawRect(
      coords.x - paddingH,
      coords.y - paddingV / 2,
      width + paddingH * 2,
      height + paddingV,
      bCnf.borderRadius,
      w.config.chart.background === "transparent" || !w.config.chart.background ? "#fff" : w.config.chart.background,
      bCnf.opacity,
      bCnf.borderWidth,
      bCnf.borderColor
    );
    if (bCnf.dropShadow.enabled) {
      const filters = new Filters(this.ctx);
      filters.dropShadow(elRect, bCnf.dropShadow);
    }
    return elRect;
  }
  dataLabelsBackground() {
    const w = this.w;
    if (w.config.chart.type === "bubble") return;
    const elDataLabels = w.globals.dom.baseEl.querySelectorAll(
      ".apexcharts-datalabels text"
    );
    for (let i = 0; i < elDataLabels.length; i++) {
      const el = elDataLabels[i];
      const coords = el.getBBox();
      let elRect = null;
      if (coords.width && coords.height) {
        elRect = this.addBackgroundToDataLabel(el, coords);
      }
      if (elRect) {
        el.parentNode.insertBefore(elRect.node, el);
        const background = w.config.dataLabels.background.backgroundColor || el.getAttribute("fill");
        const shouldAnim = w.config.chart.animations.enabled && !w.globals.resized && !w.globals.dataChanged;
        if (shouldAnim) {
          elRect.animate().attr({ fill: background });
        } else {
          elRect.attr({ fill: background });
        }
        el.setAttribute("fill", w.config.dataLabels.background.foreColor);
      }
    }
  }
  bringForward() {
    const w = this.w;
    const elDataLabelsNodes = w.globals.dom.baseEl.querySelectorAll(
      ".apexcharts-datalabels"
    );
    const elSeries = w.globals.dom.baseEl.querySelector(
      ".apexcharts-plot-series:last-child"
    );
    for (let i = 0; i < elDataLabelsNodes.length; i++) {
      if (elSeries) {
        elSeries.insertBefore(elDataLabelsNodes[i], elSeries.nextSibling);
      }
    }
  }
}
const apexchartsLegendCSS = ".apexcharts-flip-y {\n  transform: scaleY(-1) translateY(-100%);\n  transform-origin: top;\n  transform-box: fill-box;\n}\n.apexcharts-flip-x {\n  transform: scaleX(-1);\n  transform-origin: center;\n  transform-box: fill-box;\n}\n.apexcharts-legend {\n  display: flex;\n  overflow: auto;\n  padding: 0 10px;\n}\n.apexcharts-legend.apexcharts-legend-group-horizontal {\n  flex-direction: column;\n}\n.apexcharts-legend-group {\n  display: flex;\n}\n.apexcharts-legend-group-vertical {\n  flex-direction: column-reverse;\n}\n.apexcharts-legend.apx-legend-position-bottom, .apexcharts-legend.apx-legend-position-top {\n  flex-wrap: wrap\n}\n.apexcharts-legend.apx-legend-position-right, .apexcharts-legend.apx-legend-position-left {\n  flex-direction: column;\n  bottom: 0;\n}\n.apexcharts-legend.apx-legend-position-bottom.apexcharts-align-left, .apexcharts-legend.apx-legend-position-top.apexcharts-align-left, .apexcharts-legend.apx-legend-position-right, .apexcharts-legend.apx-legend-position-left {\n  justify-content: flex-start;\n  align-items: flex-start;\n}\n.apexcharts-legend.apx-legend-position-bottom.apexcharts-align-center, .apexcharts-legend.apx-legend-position-top.apexcharts-align-center {\n  justify-content: center;\n  align-items: center;\n}\n.apexcharts-legend.apx-legend-position-bottom.apexcharts-align-right, .apexcharts-legend.apx-legend-position-top.apexcharts-align-right {\n  justify-content: flex-end;\n  align-items: flex-end;\n}\n.apexcharts-legend-series {\n  cursor: pointer;\n  line-height: normal;\n  display: flex;\n  align-items: center;\n}\n.apexcharts-legend-text {\n  position: relative;\n  font-size: 14px;\n}\n.apexcharts-legend-text *, .apexcharts-legend-marker * {\n  pointer-events: none;\n}\n.apexcharts-legend-marker {\n  position: relative;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  cursor: pointer;\n  margin-right: 1px;\n}\n\n.apexcharts-legend-series.apexcharts-no-click {\n  cursor: auto;\n}\n.apexcharts-legend .apexcharts-hidden-zero-series, .apexcharts-legend .apexcharts-hidden-null-series {\n  display: none !important;\n}\n.apexcharts-inactive-legend {\n  opacity: 0.45;\n} ";
class Series {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
    this.legendInactiveClass = "legend-mouseover-inactive";
  }
  clearSeriesCache() {
    const w = this.w;
    if (w.globals.cachedSelectors) {
      delete w.globals.cachedSelectors.allSeriesEls;
      delete w.globals.cachedSelectors.highlightSeriesEls;
    }
  }
  getAllSeriesEls() {
    const w = this.w;
    const cacheKey = "allSeriesEls";
    if (!w.globals.cachedSelectors[cacheKey]) {
      w.globals.cachedSelectors[cacheKey] = w.globals.dom.baseEl.getElementsByClassName(`apexcharts-series`);
    }
    return w.globals.cachedSelectors[cacheKey];
  }
  getSeriesByName(seriesName) {
    return this.w.globals.dom.baseEl.querySelector(
      `.apexcharts-inner .apexcharts-series[seriesName='${Utils$1.escapeString(
        seriesName
      )}']`
    );
  }
  isSeriesHidden(seriesName) {
    const targetElement = this.getSeriesByName(seriesName);
    let realIndex = parseInt(targetElement.getAttribute("data:realIndex"), 10);
    let isHidden = targetElement.classList.contains(
      "apexcharts-series-collapsed"
    );
    return { isHidden, realIndex };
  }
  addCollapsedClassToSeries(elSeries, index2) {
    const w = this.w;
    function iterateOnAllCollapsedSeries(series) {
      for (let cs = 0; cs < series.length; cs++) {
        if (series[cs].index === index2) {
          elSeries.node.classList.add("apexcharts-series-collapsed");
        }
      }
    }
    iterateOnAllCollapsedSeries(w.globals.collapsedSeries);
    iterateOnAllCollapsedSeries(w.globals.ancillaryCollapsedSeries);
  }
  toggleSeries(seriesName) {
    let isSeriesHidden = this.isSeriesHidden(seriesName);
    this.ctx.legend.legendHelpers.toggleDataSeries(
      isSeriesHidden.realIndex,
      isSeriesHidden.isHidden
    );
    return isSeriesHidden.isHidden;
  }
  showSeries(seriesName) {
    let isSeriesHidden = this.isSeriesHidden(seriesName);
    if (isSeriesHidden.isHidden) {
      this.ctx.legend.legendHelpers.toggleDataSeries(
        isSeriesHidden.realIndex,
        true
      );
    }
  }
  hideSeries(seriesName) {
    let isSeriesHidden = this.isSeriesHidden(seriesName);
    if (!isSeriesHidden.isHidden) {
      this.ctx.legend.legendHelpers.toggleDataSeries(
        isSeriesHidden.realIndex,
        false
      );
    }
  }
  resetSeries(shouldUpdateChart = true, shouldResetZoom = true, shouldResetCollapsed = true) {
    const w = this.w;
    this.clearSeriesCache();
    let series = Utils$1.clone(w.globals.initialSeries);
    w.globals.previousPaths = [];
    if (shouldResetCollapsed) {
      w.globals.collapsedSeries = [];
      w.globals.ancillaryCollapsedSeries = [];
      w.globals.collapsedSeriesIndices = [];
      w.globals.ancillaryCollapsedSeriesIndices = [];
    } else {
      series = this.emptyCollapsedSeries(series);
    }
    w.config.series = series;
    if (shouldUpdateChart) {
      if (shouldResetZoom) {
        w.globals.zoomed = false;
        this.ctx.updateHelpers.revertDefaultAxisMinMax();
      }
      this.ctx.updateHelpers._updateSeries(
        series,
        w.config.chart.animations.dynamicAnimation.enabled
      );
    }
  }
  emptyCollapsedSeries(series) {
    const w = this.w;
    for (let i = 0; i < series.length; i++) {
      if (w.globals.collapsedSeriesIndices.indexOf(i) > -1) {
        series[i].data = [];
      }
    }
    return series;
  }
  highlightSeries(seriesName) {
    const w = this.w;
    const targetElement = this.getSeriesByName(seriesName);
    let realIndex = parseInt(targetElement == null ? void 0 : targetElement.getAttribute("data:realIndex"), 10);
    const cacheKey = "highlightSeriesEls";
    let allSeriesEls = w.globals.cachedSelectors[cacheKey];
    if (!allSeriesEls) {
      allSeriesEls = w.globals.dom.baseEl.querySelectorAll(
        `.apexcharts-series, .apexcharts-datalabels, .apexcharts-yaxis`
      );
      w.globals.cachedSelectors[cacheKey] = allSeriesEls;
    }
    let seriesEl = null;
    let dataLabelEl = null;
    let yaxisEl = null;
    if (w.globals.axisCharts || w.config.chart.type === "radialBar") {
      if (w.globals.axisCharts) {
        seriesEl = w.globals.dom.baseEl.querySelector(
          `.apexcharts-series[data\\:realIndex='${realIndex}']`
        );
        dataLabelEl = w.globals.dom.baseEl.querySelector(
          `.apexcharts-datalabels[data\\:realIndex='${realIndex}']`
        );
        let yaxisIndex = w.globals.seriesYAxisReverseMap[realIndex];
        yaxisEl = w.globals.dom.baseEl.querySelector(
          `.apexcharts-yaxis[rel='${yaxisIndex}']`
        );
      } else {
        seriesEl = w.globals.dom.baseEl.querySelector(
          `.apexcharts-series[rel='${realIndex + 1}']`
        );
      }
    } else {
      seriesEl = w.globals.dom.baseEl.querySelector(
        `.apexcharts-series[rel='${realIndex + 1}'] path`
      );
    }
    for (let se = 0; se < allSeriesEls.length; se++) {
      allSeriesEls[se].classList.add(this.legendInactiveClass);
    }
    if (seriesEl) {
      if (!w.globals.axisCharts) {
        seriesEl.parentNode.classList.remove(this.legendInactiveClass);
      }
      seriesEl.classList.remove(this.legendInactiveClass);
      if (dataLabelEl !== null) {
        dataLabelEl.classList.remove(this.legendInactiveClass);
      }
      if (yaxisEl !== null) {
        yaxisEl.classList.remove(this.legendInactiveClass);
      }
    } else {
      for (let se = 0; se < allSeriesEls.length; se++) {
        allSeriesEls[se].classList.remove(this.legendInactiveClass);
      }
    }
  }
  toggleSeriesOnHover(e, targetElement) {
    const w = this.w;
    if (!targetElement) targetElement = e.target;
    let allSeriesEls = w.globals.dom.baseEl.querySelectorAll(
      `.apexcharts-series, .apexcharts-datalabels, .apexcharts-yaxis`
    );
    if (e.type === "mousemove") {
      let realIndex = parseInt(targetElement.getAttribute("rel"), 10) - 1;
      this.highlightSeries(w.globals.seriesNames[realIndex]);
    } else if (e.type === "mouseout") {
      for (let se = 0; se < allSeriesEls.length; se++) {
        allSeriesEls[se].classList.remove(this.legendInactiveClass);
      }
    }
  }
  highlightRangeInSeries(e, targetElement) {
    const w = this.w;
    const allHeatMapElements = w.globals.dom.baseEl.getElementsByClassName(
      "apexcharts-heatmap-rect"
    );
    const activeInactive = (action) => {
      for (let i = 0; i < allHeatMapElements.length; i++) {
        allHeatMapElements[i].classList[action](this.legendInactiveClass);
      }
    };
    const removeInactiveClassFromHoveredRange = (range, rangeMax) => {
      for (let i = 0; i < allHeatMapElements.length; i++) {
        const val = Number(allHeatMapElements[i].getAttribute("val"));
        if (val >= range.from && (val < range.to || range.to === rangeMax && val === rangeMax)) {
          allHeatMapElements[i].classList.remove(this.legendInactiveClass);
        }
      }
    };
    if (e.type === "mousemove") {
      let seriesCnt = parseInt(targetElement.getAttribute("rel"), 10) - 1;
      activeInactive("add");
      const ranges = w.config.plotOptions.heatmap.colorScale.ranges;
      const range = ranges[seriesCnt];
      const rangeMax = ranges.reduce((acc, cur) => Math.max(acc, cur.to), 0);
      removeInactiveClassFromHoveredRange(range, rangeMax);
    } else if (e.type === "mouseout") {
      activeInactive("remove");
    }
  }
  getActiveConfigSeriesIndex(order = "asc", chartTypes = []) {
    const w = this.w;
    let activeIndex = 0;
    if (w.config.series.length > 1) {
      let activeSeriesIndex = w.config.series.map((s, index2) => {
        const checkChartType = () => {
          if (w.globals.comboCharts) {
            return chartTypes.length === 0 || chartTypes.length && chartTypes.indexOf(w.config.series[index2].type) > -1;
          }
          return true;
        };
        const hasData = s.data && s.data.length > 0 && w.globals.collapsedSeriesIndices.indexOf(index2) === -1;
        return hasData && checkChartType() ? index2 : -1;
      });
      for (let a = order === "asc" ? 0 : activeSeriesIndex.length - 1; order === "asc" ? a < activeSeriesIndex.length : a >= 0; order === "asc" ? a++ : a--) {
        if (activeSeriesIndex[a] !== -1) {
          activeIndex = activeSeriesIndex[a];
          break;
        }
      }
    }
    return activeIndex;
  }
  getBarSeriesIndices() {
    const w = this.w;
    if (w.globals.comboCharts) {
      return this.w.config.series.map((s, i) => {
        return s.type === "bar" || s.type === "column" ? i : -1;
      }).filter((i) => {
        return i !== -1;
      });
    }
    return this.w.config.series.map((s, i) => {
      return i;
    });
  }
  getPreviousPaths() {
    let w = this.w;
    w.globals.previousPaths = [];
    function pushPaths(seriesEls, i, type) {
      let paths = seriesEls[i].childNodes;
      let dArr = {
        type,
        paths: [],
        realIndex: seriesEls[i].getAttribute("data:realIndex")
      };
      for (let j = 0; j < paths.length; j++) {
        if (paths[j].hasAttribute("pathTo")) {
          let d = paths[j].getAttribute("pathTo");
          dArr.paths.push({
            d
          });
        }
      }
      w.globals.previousPaths.push(dArr);
    }
    const getPaths = (chartType) => {
      return w.globals.dom.baseEl.querySelectorAll(
        `.apexcharts-${chartType}-series .apexcharts-series`
      );
    };
    const chartTypes = [
      "line",
      "area",
      "bar",
      "rangebar",
      "rangeArea",
      "candlestick",
      "radar"
    ];
    chartTypes.forEach((type) => {
      const paths = getPaths(type);
      for (let p = 0; p < paths.length; p++) {
        pushPaths(paths, p, type);
      }
    });
    let heatTreeSeries = w.globals.dom.baseEl.querySelectorAll(
      `.apexcharts-${w.config.chart.type} .apexcharts-series`
    );
    if (heatTreeSeries.length > 0) {
      for (let h2 = 0; h2 < heatTreeSeries.length; h2++) {
        let seriesEls = w.globals.dom.baseEl.querySelectorAll(
          `.apexcharts-${w.config.chart.type} .apexcharts-series[data\\:realIndex='${h2}'] rect`
        );
        let dArr = [];
        for (let i = 0; i < seriesEls.length; i++) {
          const getAttr = (x) => {
            return seriesEls[i].getAttribute(x);
          };
          const rect = {
            x: parseFloat(getAttr("x")),
            y: parseFloat(getAttr("y")),
            width: parseFloat(getAttr("width")),
            height: parseFloat(getAttr("height"))
          };
          dArr.push({
            rect,
            color: seriesEls[i].getAttribute("color")
          });
        }
        w.globals.previousPaths.push(dArr);
      }
    }
    if (!w.globals.axisCharts) {
      w.globals.previousPaths = w.globals.series;
    }
  }
  clearPreviousPaths() {
    const w = this.w;
    w.globals.previousPaths = [];
    w.globals.allSeriesCollapsed = false;
  }
  handleNoData() {
    const w = this.w;
    const me = this;
    const noDataOpts = w.config.noData;
    const graphics = new Graphics(me.ctx);
    let x = w.globals.svgWidth / 2;
    let y = w.globals.svgHeight / 2;
    let textAnchor = "middle";
    w.globals.noData = true;
    w.globals.animationEnded = true;
    if (noDataOpts.align === "left") {
      x = 10;
      textAnchor = "start";
    } else if (noDataOpts.align === "right") {
      x = w.globals.svgWidth - 10;
      textAnchor = "end";
    }
    if (noDataOpts.verticalAlign === "top") {
      y = 50;
    } else if (noDataOpts.verticalAlign === "bottom") {
      y = w.globals.svgHeight - 50;
    }
    x = x + noDataOpts.offsetX;
    y = y + parseInt(noDataOpts.style.fontSize, 10) + 2 + noDataOpts.offsetY;
    if (noDataOpts.text !== void 0 && noDataOpts.text !== "") {
      let titleText = graphics.drawText({
        x,
        y,
        text: noDataOpts.text,
        textAnchor,
        fontSize: noDataOpts.style.fontSize,
        fontFamily: noDataOpts.style.fontFamily,
        foreColor: noDataOpts.style.color,
        opacity: 1,
        class: "apexcharts-text-nodata"
      });
      w.globals.dom.Paper.add(titleText);
    }
  }
  // When user clicks on legends, the collapsed series is filled with [0,0,0,...,0]
  // This is because we don't want to alter the series' length as it is used at many places
  setNullSeriesToZeroValues(series) {
    let w = this.w;
    for (let sl = 0; sl < series.length; sl++) {
      if (series[sl].length === 0) {
        for (let j = 0; j < series[w.globals.maxValsInArrayIndex].length; j++) {
          series[sl].push(0);
        }
      }
    }
    return series;
  }
  hasAllSeriesEqualX() {
    let equalLen = true;
    const w = this.w;
    const filteredSerX = this.filteredSeriesX();
    for (let i = 0; i < filteredSerX.length - 1; i++) {
      if (filteredSerX[i][0] !== filteredSerX[i + 1][0]) {
        equalLen = false;
        break;
      }
    }
    w.globals.allSeriesHasEqualX = equalLen;
    return equalLen;
  }
  filteredSeriesX() {
    const w = this.w;
    const filteredSeriesX = w.globals.seriesX.map(
      (ser) => ser.length > 0 ? ser : []
    );
    return filteredSeriesX;
  }
}
class Data {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
    this.twoDSeries = [];
    this.threeDSeries = [];
    this.twoDSeriesX = [];
    this.seriesGoals = [];
    this.coreUtils = new CoreUtils(this.ctx);
  }
  // Helper to get the first valid data point from the active series
  getFirstDataPoint() {
    const series = this.w.config.series;
    const sr = new Series(this.ctx);
    this.activeSeriesIndex = sr.getActiveConfigSeriesIndex();
    if (series[this.activeSeriesIndex] && series[this.activeSeriesIndex].data && series[this.activeSeriesIndex].data.length > 0 && series[this.activeSeriesIndex].data[0] !== null && typeof series[this.activeSeriesIndex].data[0] !== "undefined") {
      return series[this.activeSeriesIndex].data[0];
    }
    return null;
  }
  isMultiFormat() {
    return this.isFormatXY() || this.isFormat2DArray();
  }
  // given format is [{x, y}, {x, y}]
  isFormatXY() {
    const firstDataPoint = this.getFirstDataPoint();
    return firstDataPoint && typeof firstDataPoint.x !== "undefined";
  }
  // given format is [[x, y], [x, y]]
  isFormat2DArray() {
    const firstDataPoint = this.getFirstDataPoint();
    return firstDataPoint && Array.isArray(firstDataPoint);
  }
  handleFormat2DArray(ser, i) {
    const cnf = this.w.config;
    const gl = this.w.globals;
    const data = ser[i].data;
    const isBoxPlot = cnf.chart.type === "boxPlot" || cnf.series[i].type === "boxPlot";
    for (let j = 0; j < data.length; j++) {
      const point = data[j];
      const x = point[0];
      const y = point[1];
      const z = point[2];
      if (typeof y !== "undefined") {
        if (Array.isArray(y) && y.length === 4 && !isBoxPlot) {
          this.twoDSeries.push(Utils$1.parseNumber(y[3]));
        } else if (point.length >= 5) {
          this.twoDSeries.push(Utils$1.parseNumber(point[4]));
        } else {
          this.twoDSeries.push(Utils$1.parseNumber(y));
        }
        gl.dataFormatXNumeric = true;
      }
      if (cnf.xaxis.type === "datetime") {
        let ts = new Date(x);
        ts = ts.getTime();
        this.twoDSeriesX.push(ts);
      } else {
        this.twoDSeriesX.push(x);
      }
      if (typeof z !== "undefined") {
        this.threeDSeries.push(z);
        gl.isDataXYZ = true;
      }
    }
  }
  handleFormatXY(ser, i) {
    const cnf = this.w.config;
    const gl = this.w.globals;
    const dt = new DateTime(this.ctx);
    const data = ser[i].data;
    let activeI = i;
    if (gl.collapsedSeriesIndices.indexOf(i) > -1) {
      activeI = this.activeSeriesIndex;
    }
    const activeData = ser[activeI].data;
    for (let j = 0; j < data.length; j++) {
      const point = data[j];
      if (typeof point.y !== "undefined") {
        const val = Array.isArray(point.y) ? Utils$1.parseNumber(point.y[point.y.length - 1]) : Utils$1.parseNumber(point.y);
        this.twoDSeries.push(val);
      }
      if (typeof this.seriesGoals[i] === "undefined") {
        this.seriesGoals[i] = [];
      }
      if (typeof point.goals !== "undefined" && Array.isArray(point.goals)) {
        this.seriesGoals[i].push(point.goals);
      } else {
        this.seriesGoals[i].push(null);
      }
      if (typeof point.z !== "undefined") {
        this.threeDSeries.push(point.z);
        gl.isDataXYZ = true;
      }
    }
    for (let j = 0; j < activeData.length; j++) {
      const point = activeData[j];
      const x = point.x;
      const isXString = typeof x === "string";
      const isXArr = Array.isArray(x);
      const isXDate = !isXArr && !!dt.isValidDate(x);
      if (isXString || isXDate) {
        if (isXString || cnf.xaxis.convertedCatToNumeric) {
          const isRangeColumn = gl.isBarHorizontal && gl.isRangeData;
          if (cnf.xaxis.type === "datetime" && !isRangeColumn) {
            this.twoDSeriesX.push(dt.parseDate(x));
          } else {
            this.fallbackToCategory = true;
            this.twoDSeriesX.push(x);
            if (!isNaN(x) && this.w.config.xaxis.type !== "category" && typeof x !== "string") {
              gl.isXNumeric = true;
            }
          }
        } else {
          if (cnf.xaxis.type === "datetime") {
            this.twoDSeriesX.push(dt.parseDate(x.toString()));
          } else {
            gl.dataFormatXNumeric = true;
            gl.isXNumeric = true;
            this.twoDSeriesX.push(parseFloat(x));
          }
        }
      } else if (isXArr) {
        this.fallbackToCategory = true;
        this.twoDSeriesX.push(x);
      } else {
        gl.isXNumeric = true;
        gl.dataFormatXNumeric = true;
        this.twoDSeriesX.push(x);
      }
    }
  }
  handleRangeData(ser, i) {
    const gl = this.w.globals;
    let range = {};
    if (this.isFormat2DArray()) {
      range = this.handleRangeDataFormat("array", ser, i);
    } else if (this.isFormatXY()) {
      range = this.handleRangeDataFormat("xy", ser, i);
    }
    gl.seriesRangeStart[i] = range.start === void 0 ? [] : range.start;
    gl.seriesRangeEnd[i] = range.end === void 0 ? [] : range.end;
    gl.seriesRange[i] = range.rangeUniques;
    gl.seriesRange.forEach((sr) => {
      if (!sr) return;
      sr.forEach((sarr) => {
        const yItems = sarr.y;
        const len = yItems.length;
        if (len <= 1) return;
        for (let arri = 0; arri < len; arri++) {
          const arr = yItems[arri];
          const range1y1 = arr.y1;
          const range1y2 = arr.y2;
          for (let sri = arri + 1; sri < len; sri++) {
            const range2 = yItems[sri];
            const range2y1 = range2.y1;
            const range2y2 = range2.y2;
            if (range1y1 <= range2y2 && range2y1 <= range1y2) {
              if (sarr.overlaps.indexOf(arr.rangeName) < 0) {
                sarr.overlaps.push(arr.rangeName);
              }
              if (sarr.overlaps.indexOf(range2.rangeName) < 0) {
                sarr.overlaps.push(range2.rangeName);
              }
            }
          }
        }
      });
    });
    return range;
  }
  handleCandleStickBoxData(ser, i) {
    const gl = this.w.globals;
    let ohlc = {};
    if (this.isFormat2DArray()) {
      ohlc = this.handleCandleStickBoxDataFormat("array", ser, i);
    } else if (this.isFormatXY()) {
      ohlc = this.handleCandleStickBoxDataFormat("xy", ser, i);
    }
    gl.seriesCandleO[i] = ohlc.o;
    gl.seriesCandleH[i] = ohlc.h;
    gl.seriesCandleM[i] = ohlc.m;
    gl.seriesCandleL[i] = ohlc.l;
    gl.seriesCandleC[i] = ohlc.c;
    return ohlc;
  }
  handleRangeDataFormat(format2, ser, i) {
    const rangeStart = [];
    const rangeEnd = [];
    const uniqueKeysMap = /* @__PURE__ */ new Map();
    const uniqueKeys = [];
    ser[i].data.forEach((item) => {
      if (!uniqueKeysMap.has(item.x)) {
        const keyObj = {
          x: item.x,
          overlaps: [],
          y: []
        };
        uniqueKeysMap.set(item.x, keyObj);
        uniqueKeys.push(keyObj);
      }
    });
    if (format2 === "array") {
      for (let j = 0; j < ser[i].data.length; j++) {
        if (Array.isArray(ser[i].data[j])) {
          rangeStart.push(ser[i].data[j][1][0]);
          rangeEnd.push(ser[i].data[j][1][1]);
        } else {
          rangeStart.push(ser[i].data[j]);
          rangeEnd.push(ser[i].data[j]);
        }
      }
    } else if (format2 === "xy") {
      for (let j = 0; j < ser[i].data.length; j++) {
        let isDataPoint2D = Array.isArray(ser[i].data[j].y);
        const id = Utils$1.randomId();
        const x = ser[i].data[j].x;
        const y = {
          y1: isDataPoint2D ? ser[i].data[j].y[0] : ser[i].data[j].y,
          y2: isDataPoint2D ? ser[i].data[j].y[1] : ser[i].data[j].y,
          rangeName: id
        };
        ser[i].data[j].rangeName = id;
        const keyObj = uniqueKeysMap.get(x);
        if (keyObj) {
          keyObj.y.push(y);
        }
        rangeStart.push(y.y1);
        rangeEnd.push(y.y2);
      }
    }
    return {
      start: rangeStart,
      end: rangeEnd,
      rangeUniques: uniqueKeys
    };
  }
  handleCandleStickBoxDataFormat(format2, ser, i) {
    const w = this.w;
    const isBoxPlot = w.config.chart.type === "boxPlot" || w.config.series[i].type === "boxPlot";
    const serO = [];
    const serH = [];
    const serM = [];
    const serL = [];
    const serC = [];
    const data = ser[i].data;
    let getVals;
    if (format2 === "array") {
      const isFlat = isBoxPlot && data[0].length === 6 || !isBoxPlot && data[0].length === 5;
      if (isFlat) {
        getVals = (d) => d.slice(1);
      } else {
        getVals = (d) => Array.isArray(d[1]) ? d[1] : [];
      }
    } else {
      getVals = (d) => Array.isArray(d.y) ? d.y : [];
    }
    for (let j = 0; j < data.length; j++) {
      const vals = getVals(data[j]);
      if (vals && vals.length >= 2) {
        serO.push(vals[0]);
        serH.push(vals[1]);
        if (isBoxPlot) {
          serM.push(vals[2]);
          serL.push(vals[3]);
          serC.push(vals[4]);
        } else {
          serL.push(vals[2]);
          serC.push(vals[3]);
        }
      }
    }
    return {
      o: serO,
      h: serH,
      m: serM,
      l: serL,
      c: serC
    };
  }
  parseDataAxisCharts(ser, ctx = this.ctx) {
    const cnf = this.w.config;
    const gl = this.w.globals;
    const dt = new DateTime(ctx);
    const xlabels = cnf.labels.length > 0 ? cnf.labels.slice() : cnf.xaxis.categories.slice();
    gl.isRangeBar = cnf.chart.type === "rangeBar" && gl.isBarHorizontal;
    gl.hasXaxisGroups = cnf.xaxis.type === "category" && cnf.xaxis.group.groups.length > 0;
    if (gl.hasXaxisGroups) {
      gl.groups = cnf.xaxis.group.groups;
    }
    ser.forEach((s, i) => {
      if (s.name !== void 0) {
        gl.seriesNames.push(s.name);
      } else {
        gl.seriesNames.push("series-" + parseInt(i + 1, 10));
      }
    });
    this.coreUtils.setSeriesYAxisMappings();
    let buckets = [];
    let groups = [...new Set(cnf.series.map((s) => s.group))];
    cnf.series.forEach((s, i) => {
      let index2 = groups.indexOf(s.group);
      if (!buckets[index2]) buckets[index2] = [];
      buckets[index2].push(gl.seriesNames[i]);
    });
    gl.seriesGroups = buckets;
    const handleDates = () => {
      for (let j = 0; j < xlabels.length; j++) {
        if (typeof xlabels[j] === "string") {
          let isDate2 = dt.isValidDate(xlabels[j]);
          if (isDate2) {
            this.twoDSeriesX.push(dt.parseDate(xlabels[j]));
          } else {
            throw new Error(
              "You have provided invalid Date format. Please provide a valid JavaScript Date"
            );
          }
        } else {
          this.twoDSeriesX.push(xlabels[j]);
        }
      }
    };
    for (let i = 0; i < ser.length; i++) {
      this.twoDSeries = [];
      this.twoDSeriesX = [];
      this.threeDSeries = [];
      if (typeof ser[i].data === "undefined") {
        console.error(
          "It is a possibility that you may have not included 'data' property in series."
        );
        return;
      }
      if (cnf.chart.type === "rangeBar" || cnf.chart.type === "rangeArea" || ser[i].type === "rangeBar" || ser[i].type === "rangeArea") {
        gl.isRangeData = true;
        this.handleRangeData(ser, i);
      }
      if (this.isMultiFormat()) {
        if (this.isFormat2DArray()) {
          this.handleFormat2DArray(ser, i);
        } else if (this.isFormatXY()) {
          this.handleFormatXY(ser, i);
        }
        if (cnf.chart.type === "candlestick" || ser[i].type === "candlestick" || cnf.chart.type === "boxPlot" || ser[i].type === "boxPlot") {
          this.handleCandleStickBoxData(ser, i);
        }
        gl.series.push(this.twoDSeries);
        gl.labels.push(this.twoDSeriesX);
        gl.seriesX.push(this.twoDSeriesX);
        gl.seriesGoals = this.seriesGoals;
        if (i === this.activeSeriesIndex && !this.fallbackToCategory) {
          gl.isXNumeric = true;
        }
      } else {
        if (cnf.xaxis.type === "datetime") {
          gl.isXNumeric = true;
          handleDates();
          gl.seriesX.push(this.twoDSeriesX);
        } else if (cnf.xaxis.type === "numeric") {
          gl.isXNumeric = true;
          if (xlabels.length > 0) {
            this.twoDSeriesX = xlabels;
            gl.seriesX.push(this.twoDSeriesX);
          }
        }
        gl.labels.push(this.twoDSeriesX);
        const singleArray = ser[i].data.map((d) => Utils$1.parseNumber(d));
        gl.series.push(singleArray);
      }
      gl.seriesZ.push(this.threeDSeries);
      if (ser[i].color !== void 0) {
        gl.seriesColors.push(ser[i].color);
      } else {
        gl.seriesColors.push(void 0);
      }
    }
    return this.w;
  }
  parseDataNonAxisCharts(ser) {
    const gl = this.w.globals;
    const cnf = this.w.config;
    const hasOldFormat = Array.isArray(ser) && ser.every((s) => typeof s === "number") && cnf.labels.length > 0;
    const hasNewFormat = Array.isArray(ser) && ser.some(
      (s) => s && typeof s === "object" && s.data || s && typeof s === "object" && s.parsing
    );
    if (hasOldFormat && hasNewFormat) {
      console.warn(
        "ApexCharts: Both old format (numeric series + labels) and new format (series objects with data/parsing) detected. Using old format for backward compatibility."
      );
    }
    if (hasOldFormat) {
      gl.series = ser.slice();
      gl.seriesNames = cnf.labels.slice();
      for (let i = 0; i < gl.series.length; i++) {
        if (gl.seriesNames[i] === void 0) {
          gl.seriesNames.push("series-" + (i + 1));
        }
      }
      return this.w;
    }
    if (Array.isArray(ser) && ser.every((s) => typeof s === "number")) {
      gl.series = ser.slice();
      gl.seriesNames = [];
      for (let i = 0; i < gl.series.length; i++) {
        gl.seriesNames.push(cnf.labels[i] || `series-${i + 1}`);
      }
      return this.w;
    }
    const processedData = this.extractPieDataFromSeries(ser);
    gl.series = processedData.values;
    gl.seriesNames = processedData.labels;
    if (cnf.chart.type === "radialBar") {
      gl.series = gl.series.map((val) => {
        const numVal = Utils$1.parseNumber(val);
        if (numVal > 100) {
          console.warn(
            `ApexCharts: RadialBar value ${numVal} > 100, consider using percentage values (0-100)`
          );
        }
        return numVal;
      });
    }
    for (let i = 0; i < gl.series.length; i++) {
      if (gl.seriesNames[i] === void 0) {
        gl.seriesNames.push("series-" + (i + 1));
      }
    }
    return this.w;
  }
  /**
   * Reset parsing flags to allow re-parsing of data during updates
   */
  resetParsingFlags() {
    const w = this.w;
    w.globals.dataWasParsed = false;
    w.globals.originalSeries = null;
    if (w.config.series) {
      w.config.series.forEach((serie) => {
        if (serie.__apexParsed) {
          delete serie.__apexParsed;
        }
      });
    }
  }
  extractPieDataFromSeries(ser) {
    const values = [];
    const labels = [];
    if (!Array.isArray(ser)) {
      console.warn("ApexCharts: Expected array for series data");
      return { values: [], labels: [] };
    }
    if (ser.length === 0) {
      console.warn("ApexCharts: Empty series array");
      return { values: [], labels: [] };
    }
    const firstItem = ser[0];
    if (typeof firstItem === "object" && firstItem !== null && firstItem.data) {
      this.extractPieDataFromSeriesObjects(ser, values, labels);
    } else {
      console.warn(
        "ApexCharts: Unsupported series format for pie/donut/radialBar. Expected series objects with data property."
      );
      return { values: [], labels: [] };
    }
    return { values, labels };
  }
  // Extract data from series objects: [{ data: [...], parsing: {...} }]
  extractPieDataFromSeriesObjects(seriesArray, values, labels) {
    seriesArray.forEach((serie, serieIndex) => {
      if (!serie.data || !Array.isArray(serie.data)) {
        console.warn(`ApexCharts: Series ${serieIndex} has no valid data array`);
        return;
      }
      serie.data.forEach((dataPoint) => {
        if (typeof dataPoint === "object" && dataPoint !== null) {
          if (dataPoint.x !== void 0 && dataPoint.y !== void 0) {
            labels.push(String(dataPoint.x));
            values.push(Utils$1.parseNumber(dataPoint.y));
          } else {
            console.warn(
              "ApexCharts: Invalid data point format for pie chart. Expected {x, y} format:",
              dataPoint
            );
          }
        } else {
          console.warn(
            "ApexCharts: Expected object data point, got:",
            typeof dataPoint
          );
        }
      });
    });
  }
  /** User possibly set string categories in xaxis.categories or labels prop
   * Or didn't set xaxis labels at all - in which case we manually do it.
   * If user passed series data as [[3, 2], [4, 5]] or [{ x: 3, y: 55 }],
   * this shouldn't be called
   * @param {array} ser - the series which user passed to the config
   */
  handleExternalLabelsData(ser) {
    const cnf = this.w.config;
    const gl = this.w.globals;
    if (cnf.xaxis.categories.length > 0) {
      gl.labels = cnf.xaxis.categories;
    } else if (cnf.labels.length > 0) {
      gl.labels = cnf.labels.slice();
    } else if (this.fallbackToCategory) {
      gl.labels = gl.labels[0];
      if (gl.seriesRange.length) {
        gl.seriesRange.map((srt) => {
          srt.forEach((sr) => {
            if (gl.labels.indexOf(sr.x) < 0 && sr.x) {
              gl.labels.push(sr.x);
            }
          });
        });
        gl.labels = Array.from(
          new Set(gl.labels.map(JSON.stringify)),
          JSON.parse
        );
      }
      if (cnf.xaxis.convertedCatToNumeric) {
        const defaults2 = new Defaults(cnf);
        defaults2.convertCatToNumericXaxis(cnf, this.ctx, gl.seriesX[0]);
        this._generateExternalLabels(ser);
      }
    } else {
      this._generateExternalLabels(ser);
    }
  }
  _generateExternalLabels(ser) {
    const gl = this.w.globals;
    const cnf = this.w.config;
    let labelArr = [];
    if (gl.axisCharts) {
      if (gl.series.length > 0) {
        if (this.isFormatXY()) {
          const seriesDataFiltered = cnf.series.map((serie) => {
            return serie.data.filter(
              (v, i, a) => a.findIndex((t) => t.x === v.x) === i
            );
          });
          const len = seriesDataFiltered.reduce(
            (p, c, i, a) => a[p].length > c.length ? p : i,
            0
          );
          for (let i = 0; i < seriesDataFiltered[len].length; i++) {
            labelArr.push(i + 1);
          }
        } else {
          for (let i = 0; i < gl.series[gl.maxValsInArrayIndex].length; i++) {
            labelArr.push(i + 1);
          }
        }
      }
      gl.seriesX = [];
      for (let i = 0; i < ser.length; i++) {
        gl.seriesX.push(labelArr);
      }
      if (!this.w.globals.isBarHorizontal) {
        gl.isXNumeric = true;
      }
    }
    if (labelArr.length === 0) {
      labelArr = gl.axisCharts ? [] : gl.series.map((gls, glsi) => {
        return glsi + 1;
      });
      for (let i = 0; i < ser.length; i++) {
        gl.seriesX.push(labelArr);
      }
    }
    gl.labels = labelArr;
    if (cnf.xaxis.convertedCatToNumeric) {
      gl.categoryLabels = labelArr.map((l) => {
        return cnf.xaxis.labels.formatter(l);
      });
    }
    gl.noLabelsProvided = true;
  }
  parseRawDataIfNeeded(series) {
    const cnf = this.w.config;
    const gl = this.w.globals;
    const globalParsing = cnf.parsing;
    if (gl.dataWasParsed) {
      return series;
    }
    if (!globalParsing && !series.some((s) => s.parsing)) {
      return series;
    }
    const processedSeries = series.map((serie, index2) => {
      var _a, _b, _c;
      if (!serie.data || !Array.isArray(serie.data) || serie.data.length === 0) {
        return serie;
      }
      const effectiveParsing = {
        x: ((_a = serie.parsing) == null ? void 0 : _a.x) || (globalParsing == null ? void 0 : globalParsing.x),
        y: ((_b = serie.parsing) == null ? void 0 : _b.y) || (globalParsing == null ? void 0 : globalParsing.y),
        z: ((_c = serie.parsing) == null ? void 0 : _c.z) || (globalParsing == null ? void 0 : globalParsing.z)
      };
      if (!effectiveParsing.x && !effectiveParsing.y) {
        return serie;
      }
      const firstDataPoint = serie.data[0];
      if (typeof firstDataPoint === "object" && firstDataPoint !== null && (Object.prototype.hasOwnProperty.call(firstDataPoint, "x") || Object.prototype.hasOwnProperty.call(firstDataPoint, "y")) || Array.isArray(firstDataPoint)) {
        return serie;
      }
      if (!effectiveParsing.x || !effectiveParsing.y || Array.isArray(effectiveParsing.y) && effectiveParsing.y.length === 0) {
        console.warn(
          `ApexCharts: Series ${index2} has parsing config but missing x or y field specification`
        );
        return serie;
      }
      const transformedData = serie.data.map((item, itemIndex) => {
        if (typeof item !== "object" || item === null) {
          console.warn(
            `ApexCharts: Series ${index2}, data point ${itemIndex} is not an object, skipping parsing`
          );
          return item;
        }
        const x = this.getNestedValue(item, effectiveParsing.x);
        let y;
        let z = void 0;
        if (Array.isArray(effectiveParsing.y)) {
          const yValues = effectiveParsing.y.map(
            (fieldName) => this.getNestedValue(item, fieldName)
          );
          if (this.w.config.chart.type === "bubble" && yValues.length === 2) {
            y = yValues[0];
          } else {
            y = yValues;
          }
        } else {
          y = this.getNestedValue(item, effectiveParsing.y);
        }
        if (effectiveParsing.z) {
          z = this.getNestedValue(item, effectiveParsing.z);
        }
        if (x === void 0) {
          console.warn(
            `ApexCharts: Series ${index2}, data point ${itemIndex} missing field '${effectiveParsing.x}'`
          );
        }
        if (y === void 0) {
          console.warn(
            `ApexCharts: Series ${index2}, data point ${itemIndex} missing field '${effectiveParsing.y}'`
          );
        }
        const result = { x, y };
        if (this.w.config.chart.type === "bubble" && Array.isArray(effectiveParsing.y) && effectiveParsing.y.length === 2) {
          const zValue = this.getNestedValue(item, effectiveParsing.y[1]);
          if (zValue !== void 0) {
            result.z = zValue;
          }
        }
        if (z !== void 0) {
          result.z = z;
        }
        return result;
      });
      return __spreadProps(__spreadValues({}, serie), {
        data: transformedData,
        __apexParsed: true
      });
    });
    gl.dataWasParsed = true;
    if (!gl.originalSeries) {
      gl.originalSeries = Utils$1.clone(series);
    }
    return processedSeries;
  }
  /**
   * Get nested object value using dot notation path
   * @param {Object} obj - The object to search in
   * @param {string} path - Dot notation path (e.g., 'user.profile.name')
   * @returns {*} The value at the path, or undefined if not found
   */
  getNestedValue(obj, path) {
    if (!obj || typeof obj !== "object" || !path) {
      return void 0;
    }
    if (path.indexOf(".") === -1) {
      return obj[path];
    }
    const keys2 = path.split(".");
    let current = obj;
    for (let i = 0; i < keys2.length; i++) {
      if (current === null || current === void 0 || typeof current !== "object") {
        return void 0;
      }
      current = current[keys2[i]];
    }
    return current;
  }
  // Segregate user provided data into appropriate vars
  parseData(ser) {
    let w = this.w;
    let cnf = w.config;
    let gl = w.globals;
    ser = this.parseRawDataIfNeeded(ser);
    cnf.series = ser;
    gl.initialSeries = Utils$1.clone(ser);
    this.excludeCollapsedSeriesInYAxis();
    this.fallbackToCategory = false;
    this.ctx.core.resetGlobals();
    this.ctx.core.isMultipleY();
    if (gl.axisCharts) {
      this.parseDataAxisCharts(ser);
      this.coreUtils.getLargestSeries();
    } else {
      this.parseDataNonAxisCharts(ser);
    }
    if (cnf.chart.stacked) {
      const series = new Series(this.ctx);
      gl.series = series.setNullSeriesToZeroValues(gl.series);
    }
    this.coreUtils.getSeriesTotals();
    if (gl.axisCharts) {
      gl.stackedSeriesTotals = this.coreUtils.getStackedSeriesTotals();
      gl.stackedSeriesTotalsByGroups = this.coreUtils.getStackedSeriesTotalsByGroups();
    }
    this.coreUtils.getPercentSeries();
    if (!gl.dataFormatXNumeric && (!gl.isXNumeric || cnf.xaxis.type === "numeric" && cnf.labels.length === 0 && cnf.xaxis.categories.length === 0)) {
      this.handleExternalLabelsData(ser);
    }
    const catLabels = this.coreUtils.getCategoryLabels(gl.labels);
    for (let l = 0; l < catLabels.length; l++) {
      if (Array.isArray(catLabels[l])) {
        gl.isMultiLineX = true;
        break;
      }
    }
  }
  excludeCollapsedSeriesInYAxis() {
    const w = this.w;
    let yAxisIndexes = [];
    w.globals.seriesYAxisMap.forEach((yAxisArr, yi) => {
      let collapsedCount = 0;
      yAxisArr.forEach((seriesIndex) => {
        if (w.globals.collapsedSeriesIndices.indexOf(seriesIndex) !== -1) {
          collapsedCount++;
        }
      });
      if (collapsedCount > 0 && collapsedCount == yAxisArr.length) {
        yAxisIndexes.push(yi);
      }
    });
    w.globals.ignoreYAxisIndexes = yAxisIndexes.map((x) => x);
  }
}
class Exports {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
  }
  svgStringToNode(svgString) {
    const parser = new DOMParser();
    const svgDoc = parser.parseFromString(svgString, "image/svg+xml");
    return svgDoc.documentElement;
  }
  scaleSvgNode(svg, scale) {
    let svgWidth = parseFloat(svg.getAttributeNS(null, "width"));
    let svgHeight = parseFloat(svg.getAttributeNS(null, "height"));
    svg.setAttributeNS(null, "width", svgWidth * scale);
    svg.setAttributeNS(null, "height", svgHeight * scale);
    svg.setAttributeNS(null, "viewBox", "0 0 " + svgWidth + " " + svgHeight);
  }
  getSvgString(_scale) {
    return new Promise((resolve) => {
      const w = this.w;
      let scale = _scale || w.config.chart.toolbar.export.scale || w.config.chart.toolbar.export.width / w.globals.svgWidth;
      if (!scale) {
        scale = 1;
      }
      const width = w.globals.svgWidth * scale;
      const height = w.globals.svgHeight * scale;
      const clonedNode = w.globals.dom.elWrap.cloneNode(true);
      clonedNode.style.width = width + "px";
      clonedNode.style.height = height + "px";
      const serializedNode = new XMLSerializer().serializeToString(clonedNode);
      const shouldIncludeLegendStyles = w.config.legend.show && w.globals.dom.elLegendWrap && w.globals.dom.elLegendWrap.children.length > 0;
      let exportStyles = `
        .apexcharts-tooltip, .apexcharts-toolbar, .apexcharts-xaxistooltip, .apexcharts-yaxistooltip, .apexcharts-xcrosshairs, .apexcharts-ycrosshairs, .apexcharts-zoom-rect, .apexcharts-selection-rect {
          display: none;
        }
      `;
      if (shouldIncludeLegendStyles) {
        exportStyles += apexchartsLegendCSS;
      }
      let svgString = `
        <svg xmlns="http://www.w3.org/2000/svg"
          version="1.1"
          xmlns:xlink="http://www.w3.org/1999/xlink"
          class="apexcharts-svg"
          xmlns:data="ApexChartsNS"
          transform="translate(0, 0)"
          width="${w.globals.svgWidth}px" height="${w.globals.svgHeight}px">
          <foreignObject width="100%" height="100%">
            <div xmlns="http://www.w3.org/1999/xhtml" style="width:${width}px; height:${height}px;">
            <style type="text/css">
              ${exportStyles}
            </style>
              ${serializedNode}
            </div>
          </foreignObject>
        </svg>
      `;
      const svgNode = this.svgStringToNode(svgString);
      if (scale !== 1) {
        this.scaleSvgNode(svgNode, scale);
      }
      this.convertImagesToBase64(svgNode).then(() => {
        svgString = new XMLSerializer().serializeToString(svgNode);
        resolve(svgString.replace(/&nbsp;/g, "&#160;"));
      });
    });
  }
  convertImagesToBase64(svgNode) {
    const images = svgNode.getElementsByTagName("image");
    const promises = Array.from(images).map((img) => {
      const href = img.getAttributeNS("http://www.w3.org/1999/xlink", "href");
      if (href && !href.startsWith("data:")) {
        return this.getBase64FromUrl(href).then((base64) => {
          img.setAttributeNS("http://www.w3.org/1999/xlink", "href", base64);
        }).catch((error) => {
          console.error("Error converting image to base64:", error);
        });
      }
      return Promise.resolve();
    });
    return Promise.all(promises);
  }
  getBase64FromUrl(url) {
    return new Promise((resolve, reject) => {
      const img = new Image();
      img.crossOrigin = "Anonymous";
      img.onload = () => {
        const canvas = document.createElement("canvas");
        canvas.width = img.width;
        canvas.height = img.height;
        const ctx = canvas.getContext("2d");
        ctx.drawImage(img, 0, 0);
        resolve(canvas.toDataURL());
      };
      img.onerror = reject;
      img.src = url;
    });
  }
  svgUrl() {
    return new Promise((resolve) => {
      this.getSvgString().then((svgData) => {
        const svgBlob = new Blob([svgData], {
          type: "image/svg+xml;charset=utf-8"
        });
        resolve(URL.createObjectURL(svgBlob));
      });
    });
  }
  dataURI(options2) {
    return new Promise((resolve) => {
      const w = this.w;
      const scale = options2 ? options2.scale || options2.width / w.globals.svgWidth : 1;
      const canvas = document.createElement("canvas");
      canvas.width = w.globals.svgWidth * scale;
      canvas.height = parseInt(w.globals.dom.elWrap.style.height, 10) * scale;
      const canvasBg = w.config.chart.background === "transparent" || !w.config.chart.background ? "#fff" : w.config.chart.background;
      let ctx = canvas.getContext("2d");
      ctx.fillStyle = canvasBg;
      ctx.fillRect(0, 0, canvas.width * scale, canvas.height * scale);
      this.getSvgString(scale).then((svgData) => {
        const svgUrl = "data:image/svg+xml," + encodeURIComponent(svgData);
        let img = new Image();
        img.crossOrigin = "anonymous";
        img.onload = () => {
          ctx.drawImage(img, 0, 0);
          if (canvas.msToBlob) {
            let blob = canvas.msToBlob();
            resolve({ blob });
          } else {
            let imgURI = canvas.toDataURL("image/png");
            resolve({ imgURI });
          }
        };
        img.src = svgUrl;
      });
    });
  }
  exportToSVG() {
    this.svgUrl().then((url) => {
      this.triggerDownload(
        url,
        this.w.config.chart.toolbar.export.svg.filename,
        ".svg"
      );
    });
  }
  exportToPng() {
    const scale = this.w.config.chart.toolbar.export.scale;
    const width = this.w.config.chart.toolbar.export.width;
    const option2 = scale ? { scale } : width ? { width } : void 0;
    this.dataURI(option2).then(({ imgURI, blob }) => {
      if (blob) {
        navigator.msSaveOrOpenBlob(blob, this.w.globals.chartID + ".png");
      } else {
        this.triggerDownload(
          imgURI,
          this.w.config.chart.toolbar.export.png.filename,
          ".png"
        );
      }
    });
  }
  exportToCSV({
    series,
    fileName,
    columnDelimiter = ",",
    lineDelimiter = "\n"
  }) {
    const w = this.w;
    if (!series) series = w.config.series;
    let columns = [];
    let rows = [];
    let result = "";
    let universalBOM = "\uFEFF";
    let gSeries = w.globals.series.map((s, i) => {
      return w.globals.collapsedSeriesIndices.indexOf(i) === -1 ? s : [];
    });
    const getFormattedCategory = (cat) => {
      if (typeof w.config.chart.toolbar.export.csv.categoryFormatter === "function") {
        return w.config.chart.toolbar.export.csv.categoryFormatter(cat);
      }
      if (w.config.xaxis.type === "datetime" && String(cat).length >= 10) {
        return new Date(cat).toDateString();
      }
      return Utils$1.isNumber(cat) ? cat : cat.split(columnDelimiter).join("");
    };
    const getFormattedValue = (value) => {
      return typeof w.config.chart.toolbar.export.csv.valueFormatter === "function" ? w.config.chart.toolbar.export.csv.valueFormatter(value) : value;
    };
    const seriesMaxDataLength = Math.max(
      ...series.map((s) => {
        return s.data ? s.data.length : 0;
      })
    );
    const dataFormat = new Data(this.ctx);
    const axesUtils = new AxesUtils(this.ctx);
    const getCat = (i) => {
      let cat = "";
      if (!w.globals.axisCharts) {
        cat = w.config.labels[i];
      } else {
        if (w.config.xaxis.type === "category" || w.config.xaxis.convertedCatToNumeric) {
          if (w.globals.isBarHorizontal) {
            let lbFormatter = w.globals.yLabelFormatters[0];
            let sr = new Series(this.ctx);
            let activeSeries = sr.getActiveConfigSeriesIndex();
            cat = lbFormatter(w.globals.labels[i], {
              seriesIndex: activeSeries,
              dataPointIndex: i,
              w
            });
          } else {
            cat = axesUtils.getLabel(
              w.globals.labels,
              w.globals.timescaleLabels,
              0,
              i
            ).text;
          }
        }
        if (w.config.xaxis.type === "datetime") {
          if (w.config.xaxis.categories.length) {
            cat = w.config.xaxis.categories[i];
          } else if (w.config.labels.length) {
            cat = w.config.labels[i];
          }
        }
      }
      if (cat === null) return "nullvalue";
      if (Array.isArray(cat)) {
        cat = cat.join(" ");
      }
      return Utils$1.isNumber(cat) ? cat : cat.split(columnDelimiter).join("");
    };
    const getEmptyDataForCsvColumn = () => {
      return [...Array(seriesMaxDataLength)].map(() => "");
    };
    const handleAxisRowsColumns = (s, sI) => {
      var _a;
      if (columns.length && sI === 0) {
        rows.push(columns.join(columnDelimiter));
      }
      if (s.data) {
        s.data = s.data.length && s.data || getEmptyDataForCsvColumn();
        for (let i = 0; i < s.data.length; i++) {
          columns = [];
          let cat = getCat(i);
          if (cat === "nullvalue") continue;
          if (!cat) {
            if (dataFormat.isFormatXY()) {
              cat = series[sI].data[i].x;
            } else if (dataFormat.isFormat2DArray()) {
              cat = series[sI].data[i] ? series[sI].data[i][0] : "";
            }
          }
          if (sI === 0) {
            columns.push(getFormattedCategory(cat));
            for (let ci = 0; ci < w.globals.series.length; ci++) {
              const value = dataFormat.isFormatXY() ? (_a = series[ci].data[i]) == null ? void 0 : _a.y : gSeries[ci][i];
              columns.push(getFormattedValue(value));
            }
          }
          if (w.config.chart.type === "candlestick" || s.type && s.type === "candlestick") {
            columns.pop();
            columns.push(w.globals.seriesCandleO[sI][i]);
            columns.push(w.globals.seriesCandleH[sI][i]);
            columns.push(w.globals.seriesCandleL[sI][i]);
            columns.push(w.globals.seriesCandleC[sI][i]);
          }
          if (w.config.chart.type === "boxPlot" || s.type && s.type === "boxPlot") {
            columns.pop();
            columns.push(w.globals.seriesCandleO[sI][i]);
            columns.push(w.globals.seriesCandleH[sI][i]);
            columns.push(w.globals.seriesCandleM[sI][i]);
            columns.push(w.globals.seriesCandleL[sI][i]);
            columns.push(w.globals.seriesCandleC[sI][i]);
          }
          if (w.config.chart.type === "rangeBar") {
            columns.pop();
            columns.push(w.globals.seriesRangeStart[sI][i]);
            columns.push(w.globals.seriesRangeEnd[sI][i]);
          }
          if (columns.length) {
            rows.push(columns.join(columnDelimiter));
          }
        }
      }
    };
    const handleUnequalXValues = () => {
      const categories = /* @__PURE__ */ new Set();
      const data = {};
      series.forEach((s, sI) => {
        s == null ? void 0 : s.data.forEach((dataItem) => {
          let cat, value;
          if (dataFormat.isFormatXY()) {
            cat = dataItem.x;
            value = dataItem.y;
          } else if (dataFormat.isFormat2DArray()) {
            cat = dataItem[0];
            value = dataItem[1];
          } else {
            return;
          }
          if (!data[cat]) {
            data[cat] = Array(series.length).fill("");
          }
          data[cat][sI] = getFormattedValue(value);
          categories.add(cat);
        });
      });
      if (columns.length) {
        rows.push(columns.join(columnDelimiter));
      }
      Array.from(categories).sort().forEach((cat) => {
        rows.push([
          getFormattedCategory(cat),
          data[cat].join(columnDelimiter)
        ]);
      });
    };
    columns.push(w.config.chart.toolbar.export.csv.headerCategory);
    if (w.config.chart.type === "boxPlot") {
      columns.push("minimum");
      columns.push("q1");
      columns.push("median");
      columns.push("q3");
      columns.push("maximum");
    } else if (w.config.chart.type === "candlestick") {
      columns.push("open");
      columns.push("high");
      columns.push("low");
      columns.push("close");
    } else if (w.config.chart.type === "rangeBar") {
      columns.push("minimum");
      columns.push("maximum");
    } else {
      series.map((s, sI) => {
        const sname = (s.name ? s.name : `series-${sI}`) + "";
        if (w.globals.axisCharts) {
          columns.push(
            sname.split(columnDelimiter).join("") ? sname.split(columnDelimiter).join("") : `series-${sI}`
          );
        }
      });
    }
    if (!w.globals.axisCharts) {
      columns.push(w.config.chart.toolbar.export.csv.headerValue);
      rows.push(columns.join(columnDelimiter));
    }
    if (!w.globals.allSeriesHasEqualX && w.globals.axisCharts && !w.config.xaxis.categories.length && !w.config.labels.length) {
      handleUnequalXValues();
    } else {
      series.map((s, sI) => {
        if (w.globals.axisCharts) {
          handleAxisRowsColumns(s, sI);
        } else {
          columns = [];
          columns.push(getFormattedCategory(w.globals.labels[sI]));
          columns.push(getFormattedValue(gSeries[sI]));
          rows.push(columns.join(columnDelimiter));
        }
      });
    }
    result += rows.join(lineDelimiter);
    this.triggerDownload(
      "data:text/csv; charset=utf-8," + encodeURIComponent(universalBOM + result),
      fileName ? fileName : w.config.chart.toolbar.export.csv.filename,
      ".csv"
    );
  }
  triggerDownload(href, filename, ext) {
    const downloadLink = document.createElement("a");
    downloadLink.href = href;
    downloadLink.download = (filename ? filename : this.w.globals.chartID) + ext;
    document.body.appendChild(downloadLink);
    downloadLink.click();
    document.body.removeChild(downloadLink);
  }
}
class XAxis {
  constructor(ctx, elgrid) {
    this.ctx = ctx;
    this.elgrid = elgrid;
    this.w = ctx.w;
    const w = this.w;
    this.axesUtils = new AxesUtils(ctx);
    this.xaxisLabels = w.globals.labels.slice();
    if (w.globals.timescaleLabels.length > 0 && !w.globals.isBarHorizontal) {
      this.xaxisLabels = w.globals.timescaleLabels.slice();
    }
    if (w.config.xaxis.overwriteCategories) {
      this.xaxisLabels = w.config.xaxis.overwriteCategories;
    }
    this.drawnLabels = [];
    this.drawnLabelsRects = [];
    if (w.config.xaxis.position === "top") {
      this.offY = 0;
    } else {
      this.offY = w.globals.gridHeight;
    }
    this.offY = this.offY + w.config.xaxis.axisBorder.offsetY;
    this.isCategoryBarHorizontal = w.config.chart.type === "bar" && w.config.plotOptions.bar.horizontal;
    this.xaxisFontSize = w.config.xaxis.labels.style.fontSize;
    this.xaxisFontFamily = w.config.xaxis.labels.style.fontFamily;
    this.xaxisForeColors = w.config.xaxis.labels.style.colors;
    this.xaxisBorderWidth = w.config.xaxis.axisBorder.width;
    if (this.isCategoryBarHorizontal) {
      this.xaxisBorderWidth = w.config.yaxis[0].axisBorder.width.toString();
    }
    if (String(this.xaxisBorderWidth).indexOf("%") > -1) {
      this.xaxisBorderWidth = w.globals.gridWidth * parseInt(this.xaxisBorderWidth, 10) / 100;
    } else {
      this.xaxisBorderWidth = parseInt(this.xaxisBorderWidth, 10);
    }
    this.xaxisBorderHeight = w.config.xaxis.axisBorder.height;
    this.yaxis = w.config.yaxis[0];
  }
  drawXaxis() {
    let w = this.w;
    let graphics = new Graphics(this.ctx);
    let elXaxis = graphics.group({
      class: "apexcharts-xaxis",
      transform: `translate(${w.config.xaxis.offsetX}, ${w.config.xaxis.offsetY})`
    });
    let elXaxisTexts = graphics.group({
      class: "apexcharts-xaxis-texts-g",
      transform: `translate(${w.globals.translateXAxisX}, ${w.globals.translateXAxisY})`
    });
    elXaxis.add(elXaxisTexts);
    let labels = [];
    for (let i = 0; i < this.xaxisLabels.length; i++) {
      labels.push(this.xaxisLabels[i]);
    }
    this.drawXAxisLabelAndGroup(
      true,
      graphics,
      elXaxisTexts,
      labels,
      w.globals.isXNumeric,
      (i, colWidth) => colWidth
    );
    if (w.globals.hasXaxisGroups) {
      let labelsGroup = w.globals.groups;
      labels = [];
      for (let i = 0; i < labelsGroup.length; i++) {
        labels.push(labelsGroup[i].title);
      }
      let overwriteStyles = {};
      if (w.config.xaxis.group.style) {
        overwriteStyles.xaxisFontSize = w.config.xaxis.group.style.fontSize;
        overwriteStyles.xaxisFontFamily = w.config.xaxis.group.style.fontFamily;
        overwriteStyles.xaxisForeColors = w.config.xaxis.group.style.colors;
        overwriteStyles.fontWeight = w.config.xaxis.group.style.fontWeight;
        overwriteStyles.cssClass = w.config.xaxis.group.style.cssClass;
      }
      this.drawXAxisLabelAndGroup(
        false,
        graphics,
        elXaxisTexts,
        labels,
        false,
        (i, colWidth) => labelsGroup[i].cols * colWidth,
        overwriteStyles
      );
    }
    if (w.config.xaxis.title.text !== void 0) {
      let elXaxisTitle = graphics.group({
        class: "apexcharts-xaxis-title"
      });
      let elXAxisTitleText = graphics.drawText({
        x: w.globals.gridWidth / 2 + w.config.xaxis.title.offsetX,
        y: this.offY + parseFloat(this.xaxisFontSize) + (w.config.xaxis.position === "bottom" ? w.globals.xAxisLabelsHeight : -w.globals.xAxisLabelsHeight - 10) + w.config.xaxis.title.offsetY,
        text: w.config.xaxis.title.text,
        textAnchor: "middle",
        fontSize: w.config.xaxis.title.style.fontSize,
        fontFamily: w.config.xaxis.title.style.fontFamily,
        fontWeight: w.config.xaxis.title.style.fontWeight,
        foreColor: w.config.xaxis.title.style.color,
        cssClass: "apexcharts-xaxis-title-text " + w.config.xaxis.title.style.cssClass
      });
      elXaxisTitle.add(elXAxisTitleText);
      elXaxis.add(elXaxisTitle);
    }
    if (w.config.xaxis.axisBorder.show) {
      const offX = w.globals.barPadForNumericAxis;
      let elHorzLine = graphics.drawLine(
        w.globals.padHorizontal + w.config.xaxis.axisBorder.offsetX - offX,
        this.offY,
        this.xaxisBorderWidth + offX,
        this.offY,
        w.config.xaxis.axisBorder.color,
        0,
        this.xaxisBorderHeight
      );
      if (this.elgrid && this.elgrid.elGridBorders && w.config.grid.show) {
        this.elgrid.elGridBorders.add(elHorzLine);
      } else {
        elXaxis.add(elHorzLine);
      }
    }
    return elXaxis;
  }
  drawXAxisLabelAndGroup(isLeafGroup, graphics, elXaxisTexts, labels, isXNumeric, colWidthCb, overwriteStyles = {}) {
    let drawnLabels = [];
    let drawnLabelsRects = [];
    let w = this.w;
    const xaxisFontSize = overwriteStyles.xaxisFontSize || this.xaxisFontSize;
    const xaxisFontFamily = overwriteStyles.xaxisFontFamily || this.xaxisFontFamily;
    const xaxisForeColors = overwriteStyles.xaxisForeColors || this.xaxisForeColors;
    const fontWeight = overwriteStyles.fontWeight || w.config.xaxis.labels.style.fontWeight;
    const cssClass = overwriteStyles.cssClass || w.config.xaxis.labels.style.cssClass;
    let colWidth;
    let xPos = w.globals.padHorizontal;
    let labelsLen = labels.length;
    let dataPoints = w.config.xaxis.type === "category" ? w.globals.dataPoints : labelsLen;
    if (dataPoints === 0 && labelsLen > dataPoints) dataPoints = labelsLen;
    if (isXNumeric) {
      let len = Math.max(
        Number(w.config.xaxis.tickAmount) || 1,
        dataPoints > 1 ? dataPoints - 1 : dataPoints
      );
      colWidth = w.globals.gridWidth / Math.min(len, labelsLen - 1);
      xPos = xPos + colWidthCb(0, colWidth) / 2 + w.config.xaxis.labels.offsetX;
    } else {
      colWidth = w.globals.gridWidth / dataPoints;
      xPos = xPos + colWidthCb(0, colWidth) + w.config.xaxis.labels.offsetX;
    }
    for (let i = 0; i <= labelsLen - 1; i++) {
      let x = xPos - colWidthCb(i, colWidth) / 2 + w.config.xaxis.labels.offsetX;
      if (i === 0 && labelsLen === 1 && colWidth / 2 === xPos && dataPoints === 1) {
        x = w.globals.gridWidth / 2;
      }
      let label = this.axesUtils.getLabel(
        labels,
        w.globals.timescaleLabels,
        x,
        i,
        drawnLabels,
        xaxisFontSize,
        isLeafGroup
      );
      let offsetYCorrection = 28;
      if (w.globals.rotateXLabels && isLeafGroup) {
        offsetYCorrection = 22;
      }
      if (w.config.xaxis.title.text && w.config.xaxis.position === "top") {
        offsetYCorrection += parseFloat(w.config.xaxis.title.style.fontSize) + 2;
      }
      if (!isLeafGroup) {
        offsetYCorrection = offsetYCorrection + parseFloat(xaxisFontSize) + (w.globals.xAxisLabelsHeight - w.globals.xAxisGroupLabelsHeight) + (w.globals.rotateXLabels ? 10 : 0);
      }
      const isCategoryTickAmounts = typeof w.config.xaxis.tickAmount !== "undefined" && w.config.xaxis.tickAmount !== "dataPoints" && w.config.xaxis.type !== "datetime";
      if (isCategoryTickAmounts) {
        label = this.axesUtils.checkLabelBasedOnTickamount(i, label, labelsLen);
      } else {
        label = this.axesUtils.checkForOverflowingLabels(
          i,
          label,
          labelsLen,
          drawnLabels,
          drawnLabelsRects
        );
      }
      const getCatForeColor = () => {
        return isLeafGroup && w.config.xaxis.convertedCatToNumeric ? xaxisForeColors[w.globals.minX + i - 1] : xaxisForeColors[i];
      };
      if (w.config.xaxis.labels.show) {
        let elText = graphics.drawText({
          x: label.x,
          y: this.offY + w.config.xaxis.labels.offsetY + offsetYCorrection - (w.config.xaxis.position === "top" ? w.globals.xAxisHeight + w.config.xaxis.axisTicks.height - 2 : 0),
          text: label.text,
          textAnchor: "middle",
          fontWeight: label.isBold ? 600 : fontWeight,
          fontSize: xaxisFontSize,
          fontFamily: xaxisFontFamily,
          foreColor: Array.isArray(xaxisForeColors) ? getCatForeColor() : xaxisForeColors,
          isPlainText: false,
          cssClass: (isLeafGroup ? "apexcharts-xaxis-label " : "apexcharts-xaxis-group-label ") + cssClass
        });
        elXaxisTexts.add(elText);
        elText.on("click", (e) => {
          if (typeof w.config.chart.events.xAxisLabelClick === "function") {
            const opts = Object.assign({}, w, {
              labelIndex: i
            });
            w.config.chart.events.xAxisLabelClick(e, this.ctx, opts);
          }
        });
        if (isLeafGroup) {
          let elTooltipTitle = document.createElementNS(
            w.globals.SVGNS,
            "title"
          );
          elTooltipTitle.textContent = Array.isArray(label.text) ? label.text.join(" ") : label.text;
          elText.node.appendChild(elTooltipTitle);
          if (label.text !== "") {
            drawnLabels.push(label.text);
            drawnLabelsRects.push(label);
          }
        }
      }
      if (i < labelsLen - 1) {
        xPos = xPos + colWidthCb(i + 1, colWidth);
      }
    }
  }
  // this actually becomes the vertical axis (for bar charts)
  drawXaxisInversed(realIndex) {
    let w = this.w;
    let graphics = new Graphics(this.ctx);
    let translateYAxisX = w.config.yaxis[0].opposite ? w.globals.translateYAxisX[realIndex] : 0;
    let elYaxis = graphics.group({
      class: "apexcharts-yaxis apexcharts-xaxis-inversed",
      rel: realIndex
    });
    let elYaxisTexts = graphics.group({
      class: "apexcharts-yaxis-texts-g apexcharts-xaxis-inversed-texts-g",
      transform: "translate(" + translateYAxisX + ", 0)"
    });
    elYaxis.add(elYaxisTexts);
    let colHeight;
    let yPos;
    let labels = [];
    if (w.config.yaxis[realIndex].show) {
      for (let i = 0; i < this.xaxisLabels.length; i++) {
        labels.push(this.xaxisLabels[i]);
      }
    }
    colHeight = w.globals.gridHeight / labels.length;
    yPos = -(colHeight / 2.2);
    let lbFormatter = w.globals.yLabelFormatters[0];
    const ylabels = w.config.yaxis[0].labels;
    if (ylabels.show) {
      for (let i = 0; i <= labels.length - 1; i++) {
        let label = typeof labels[i] === "undefined" ? "" : labels[i];
        label = lbFormatter(label, {
          seriesIndex: realIndex,
          dataPointIndex: i,
          w
        });
        const yColors = this.axesUtils.getYAxisForeColor(
          ylabels.style.colors,
          realIndex
        );
        const getForeColor = () => {
          return Array.isArray(yColors) ? yColors[i] : yColors;
        };
        let multiY = 0;
        if (Array.isArray(label)) {
          multiY = label.length / 2 * parseInt(ylabels.style.fontSize, 10);
        }
        let offsetX = ylabels.offsetX - 15;
        let textAnchor = "end";
        if (this.yaxis.opposite) {
          textAnchor = "start";
        }
        if (w.config.yaxis[0].labels.align === "left") {
          offsetX = ylabels.offsetX;
          textAnchor = "start";
        } else if (w.config.yaxis[0].labels.align === "center") {
          offsetX = ylabels.offsetX;
          textAnchor = "middle";
        } else if (w.config.yaxis[0].labels.align === "right") {
          textAnchor = "end";
        }
        let elLabel = graphics.drawText({
          x: offsetX,
          y: yPos + colHeight + ylabels.offsetY - multiY,
          text: label,
          textAnchor,
          foreColor: getForeColor(),
          fontSize: ylabels.style.fontSize,
          fontFamily: ylabels.style.fontFamily,
          fontWeight: ylabels.style.fontWeight,
          isPlainText: false,
          cssClass: "apexcharts-yaxis-label " + ylabels.style.cssClass,
          maxWidth: ylabels.maxWidth
        });
        elYaxisTexts.add(elLabel);
        elLabel.on("click", (e) => {
          if (typeof w.config.chart.events.xAxisLabelClick === "function") {
            const opts = Object.assign({}, w, {
              labelIndex: i
            });
            w.config.chart.events.xAxisLabelClick(e, this.ctx, opts);
          }
        });
        let elTooltipTitle = document.createElementNS(w.globals.SVGNS, "title");
        elTooltipTitle.textContent = Array.isArray(label) ? label.join(" ") : label;
        elLabel.node.appendChild(elTooltipTitle);
        if (w.config.yaxis[realIndex].labels.rotate !== 0) {
          let labelRotatingCenter = graphics.rotateAroundCenter(elLabel.node);
          elLabel.node.setAttribute(
            "transform",
            `rotate(${w.config.yaxis[realIndex].labels.rotate} 0 ${labelRotatingCenter.y})`
          );
        }
        yPos = yPos + colHeight;
      }
    }
    if (w.config.yaxis[0].title.text !== void 0) {
      let elXaxisTitle = graphics.group({
        class: "apexcharts-yaxis-title apexcharts-xaxis-title-inversed",
        transform: "translate(" + translateYAxisX + ", 0)"
      });
      let elXAxisTitleText = graphics.drawText({
        x: w.config.yaxis[0].title.offsetX,
        y: w.globals.gridHeight / 2 + w.config.yaxis[0].title.offsetY,
        text: w.config.yaxis[0].title.text,
        textAnchor: "middle",
        foreColor: w.config.yaxis[0].title.style.color,
        fontSize: w.config.yaxis[0].title.style.fontSize,
        fontWeight: w.config.yaxis[0].title.style.fontWeight,
        fontFamily: w.config.yaxis[0].title.style.fontFamily,
        cssClass: "apexcharts-yaxis-title-text " + w.config.yaxis[0].title.style.cssClass
      });
      elXaxisTitle.add(elXAxisTitleText);
      elYaxis.add(elXaxisTitle);
    }
    let offX = 0;
    if (this.isCategoryBarHorizontal && w.config.yaxis[0].opposite) {
      offX = w.globals.gridWidth;
    }
    const axisBorder = w.config.xaxis.axisBorder;
    if (axisBorder.show) {
      let elVerticalLine = graphics.drawLine(
        w.globals.padHorizontal + axisBorder.offsetX + offX,
        1 + axisBorder.offsetY,
        w.globals.padHorizontal + axisBorder.offsetX + offX,
        w.globals.gridHeight + axisBorder.offsetY,
        axisBorder.color,
        0
      );
      if (this.elgrid && this.elgrid.elGridBorders && w.config.grid.show) {
        this.elgrid.elGridBorders.add(elVerticalLine);
      } else {
        elYaxis.add(elVerticalLine);
      }
    }
    if (w.config.yaxis[0].axisTicks.show) {
      this.axesUtils.drawYAxisTicks(
        offX,
        labels.length,
        w.config.yaxis[0].axisBorder,
        w.config.yaxis[0].axisTicks,
        0,
        colHeight,
        elYaxis
      );
    }
    return elYaxis;
  }
  drawXaxisTicks(x1, y2, appendToElement) {
    let w = this.w;
    let x2 = x1;
    if (x1 < 0 || x1 - 2 > w.globals.gridWidth) return;
    let y1 = this.offY + w.config.xaxis.axisTicks.offsetY;
    y2 = y2 + y1 + w.config.xaxis.axisTicks.height;
    if (w.config.xaxis.position === "top") {
      y2 = y1 - w.config.xaxis.axisTicks.height;
    }
    if (w.config.xaxis.axisTicks.show) {
      let graphics = new Graphics(this.ctx);
      let line = graphics.drawLine(
        x1 + w.config.xaxis.axisTicks.offsetX,
        y1 + w.config.xaxis.offsetY,
        x2 + w.config.xaxis.axisTicks.offsetX,
        y2 + w.config.xaxis.offsetY,
        w.config.xaxis.axisTicks.color
      );
      appendToElement.add(line);
      line.node.classList.add("apexcharts-xaxis-tick");
    }
  }
  getXAxisTicksPositions() {
    const w = this.w;
    let xAxisTicksPositions = [];
    const xCount = this.xaxisLabels.length;
    let x1 = w.globals.padHorizontal;
    if (w.globals.timescaleLabels.length > 0) {
      for (let i = 0; i < xCount; i++) {
        x1 = this.xaxisLabels[i].position;
        xAxisTicksPositions.push(x1);
      }
    } else {
      let xCountForCategoryCharts = xCount;
      for (let i = 0; i < xCountForCategoryCharts; i++) {
        let x1Count = xCountForCategoryCharts;
        if (w.globals.isXNumeric && w.config.chart.type !== "bar") {
          x1Count -= 1;
        }
        x1 = x1 + w.globals.gridWidth / x1Count;
        xAxisTicksPositions.push(x1);
      }
    }
    return xAxisTicksPositions;
  }
  // to rotate x-axis labels or to put ... for longer text in xaxis
  xAxisLabelCorrections() {
    let w = this.w;
    let graphics = new Graphics(this.ctx);
    let xAxis = w.globals.dom.baseEl.querySelector(".apexcharts-xaxis-texts-g");
    let xAxisTexts = w.globals.dom.baseEl.querySelectorAll(
      ".apexcharts-xaxis-texts-g text:not(.apexcharts-xaxis-group-label)"
    );
    let yAxisTextsInversed = w.globals.dom.baseEl.querySelectorAll(
      ".apexcharts-yaxis-inversed text"
    );
    let xAxisTextsInversed = w.globals.dom.baseEl.querySelectorAll(
      ".apexcharts-xaxis-inversed-texts-g text tspan"
    );
    if (w.globals.rotateXLabels || w.config.xaxis.labels.rotateAlways) {
      for (let xat = 0; xat < xAxisTexts.length; xat++) {
        let textRotatingCenter = graphics.rotateAroundCenter(xAxisTexts[xat]);
        textRotatingCenter.y = textRotatingCenter.y - 1;
        textRotatingCenter.x = textRotatingCenter.x + 1;
        xAxisTexts[xat].setAttribute(
          "transform",
          `rotate(${w.config.xaxis.labels.rotate} ${textRotatingCenter.x} ${textRotatingCenter.y})`
        );
        xAxisTexts[xat].setAttribute("text-anchor", `end`);
        xAxis.setAttribute("transform", `translate(0, ${-10})`);
        let tSpan = xAxisTexts[xat].childNodes;
        if (w.config.xaxis.labels.trim) {
          Array.prototype.forEach.call(tSpan, (ts) => {
            graphics.placeTextWithEllipsis(
              ts,
              ts.textContent,
              w.globals.xAxisLabelsHeight - (w.config.legend.position === "bottom" ? 20 : 10)
            );
          });
        }
      }
    } else {
      let width = w.globals.gridWidth / (w.globals.labels.length + 1);
      for (let xat = 0; xat < xAxisTexts.length; xat++) {
        let tSpan = xAxisTexts[xat].childNodes;
        if (w.config.xaxis.labels.trim && w.config.xaxis.type !== "datetime") {
          Array.prototype.forEach.call(tSpan, (ts) => {
            graphics.placeTextWithEllipsis(ts, ts.textContent, width);
          });
        }
      }
    }
    if (yAxisTextsInversed.length > 0) {
      let firstLabelPosX = yAxisTextsInversed[yAxisTextsInversed.length - 1].getBBox();
      let lastLabelPosX = yAxisTextsInversed[0].getBBox();
      if (firstLabelPosX.x < -20) {
        yAxisTextsInversed[yAxisTextsInversed.length - 1].parentNode.removeChild(
          yAxisTextsInversed[yAxisTextsInversed.length - 1]
        );
      }
      if (lastLabelPosX.x + lastLabelPosX.width > w.globals.gridWidth && !w.globals.isBarHorizontal) {
        yAxisTextsInversed[0].parentNode.removeChild(yAxisTextsInversed[0]);
      }
      for (let xat = 0; xat < xAxisTextsInversed.length; xat++) {
        graphics.placeTextWithEllipsis(
          xAxisTextsInversed[xat],
          xAxisTextsInversed[xat].textContent,
          w.config.yaxis[0].labels.maxWidth - (w.config.yaxis[0].title.text ? parseFloat(w.config.yaxis[0].title.style.fontSize) * 2 : 0) - 15
        );
      }
    }
  }
  // renderXAxisBands() {
  //   let w = this.w;
  //   let plotBand = document.createElementNS(w.globals.SVGNS, 'rect')
  //   w.globals.dom.elGraphical.add(plotBand)
  // }
}
class Grid {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
    const w = this.w;
    this.xaxisLabels = w.globals.labels.slice();
    this.axesUtils = new AxesUtils(ctx);
    this.isRangeBar = w.globals.seriesRange.length && w.globals.isBarHorizontal;
    if (w.globals.timescaleLabels.length > 0) {
      this.xaxisLabels = w.globals.timescaleLabels.slice();
    }
  }
  drawGridArea(elGrid = null) {
    const w = this.w;
    const graphics = new Graphics(this.ctx);
    if (!elGrid) {
      elGrid = graphics.group({ class: "apexcharts-grid" });
    }
    const elVerticalLine = graphics.drawLine(
      w.globals.padHorizontal,
      1,
      w.globals.padHorizontal,
      w.globals.gridHeight,
      "transparent"
    );
    const elHorzLine = graphics.drawLine(
      w.globals.padHorizontal,
      w.globals.gridHeight,
      w.globals.gridWidth,
      w.globals.gridHeight,
      "transparent"
    );
    elGrid.add(elHorzLine);
    elGrid.add(elVerticalLine);
    return elGrid;
  }
  drawGrid() {
    const gl = this.w.globals;
    if (gl.axisCharts) {
      const elgrid = this.renderGrid();
      this.drawGridArea(elgrid.el);
      return elgrid;
    }
    return null;
  }
  createGridMask() {
    const w = this.w;
    const gl = w.globals;
    const graphics = new Graphics(this.ctx);
    const strokeSize = Array.isArray(w.config.stroke.width) ? Math.max(...w.config.stroke.width) : w.config.stroke.width;
    const createClipPath = (id) => {
      const clipPath = document.createElementNS(gl.SVGNS, "clipPath");
      clipPath.setAttribute("id", id);
      return clipPath;
    };
    gl.dom.elGridRectMask = createClipPath(`gridRectMask${gl.cuid}`);
    gl.dom.elGridRectBarMask = createClipPath(`gridRectBarMask${gl.cuid}`);
    gl.dom.elGridRectMarkerMask = createClipPath(`gridRectMarkerMask${gl.cuid}`);
    gl.dom.elForecastMask = createClipPath(`forecastMask${gl.cuid}`);
    gl.dom.elNonForecastMask = createClipPath(`nonForecastMask${gl.cuid}`);
    const hasBar = ["bar", "rangeBar", "candlestick", "boxPlot"].includes(
      w.config.chart.type
    ) || w.globals.comboBarCount > 0;
    let barWidthLeft = 0;
    let barWidthRight = 0;
    if (hasBar && w.globals.isXNumeric && !w.globals.isBarHorizontal) {
      barWidthLeft = Math.max(
        w.config.grid.padding.left,
        gl.barPadForNumericAxis
      );
      barWidthRight = Math.max(
        w.config.grid.padding.right,
        gl.barPadForNumericAxis
      );
    }
    gl.dom.elGridRect = graphics.drawRect(
      -strokeSize / 2 - 2,
      -strokeSize / 2 - 2,
      gl.gridWidth + strokeSize + 4,
      gl.gridHeight + strokeSize + 4,
      0,
      "#fff"
    );
    gl.dom.elGridRectBar = graphics.drawRect(
      -strokeSize / 2 - barWidthLeft - 2,
      -strokeSize / 2 - 2,
      gl.gridWidth + strokeSize + barWidthRight + barWidthLeft + 4,
      gl.gridHeight + strokeSize + 4,
      0,
      "#fff"
    );
    const markerSize = w.globals.markers.largestSize;
    gl.dom.elGridRectMarker = graphics.drawRect(
      Math.min(-strokeSize / 2 - barWidthLeft - 2, -markerSize),
      -markerSize,
      gl.gridWidth + Math.max(strokeSize + barWidthRight + barWidthLeft + 4, markerSize * 2),
      gl.gridHeight + markerSize * 2,
      0,
      "#fff"
    );
    gl.dom.elGridRectMask.appendChild(gl.dom.elGridRect.node);
    gl.dom.elGridRectBarMask.appendChild(gl.dom.elGridRectBar.node);
    gl.dom.elGridRectMarkerMask.appendChild(gl.dom.elGridRectMarker.node);
    const defs = gl.dom.baseEl.querySelector("defs");
    defs.appendChild(gl.dom.elGridRectMask);
    defs.appendChild(gl.dom.elGridRectBarMask);
    defs.appendChild(gl.dom.elGridRectMarkerMask);
    defs.appendChild(gl.dom.elForecastMask);
    defs.appendChild(gl.dom.elNonForecastMask);
  }
  _drawGridLines({ i, x1, y1, x2, y2, xCount, parent }) {
    const w = this.w;
    const shouldDraw = () => {
      if (i === 0 && w.globals.skipFirstTimelinelabel) return false;
      if (i === xCount - 1 && w.globals.skipLastTimelinelabel && !w.config.xaxis.labels.formatter)
        return false;
      if (w.config.chart.type === "radar") return false;
      return true;
    };
    if (shouldDraw()) {
      if (w.config.grid.xaxis.lines.show) {
        this._drawGridLine({ i, x1, y1, x2, y2, xCount, parent });
      }
      let y_2 = 0;
      if (w.globals.hasXaxisGroups && w.config.xaxis.tickPlacement === "between") {
        const groups = w.globals.groups;
        if (groups) {
          let gacc = 0;
          for (let gi = 0; gacc < i && gi < groups.length; gi++) {
            gacc += groups[gi].cols;
          }
          if (gacc === i) {
            y_2 = w.globals.xAxisLabelsHeight * 0.6;
          }
        }
      }
      const xAxis = new XAxis(this.ctx);
      xAxis.drawXaxisTicks(x1, y_2, w.globals.dom.elGraphical);
    }
  }
  _drawGridLine({ i, x1, y1, x2, y2, xCount, parent }) {
    const w = this.w;
    const isHorzLine = parent.node.classList.contains(
      "apexcharts-gridlines-horizontal"
    );
    const offX = w.globals.barPadForNumericAxis;
    const excludeBorders = y1 === 0 && y2 === 0 || x1 === 0 && x2 === 0 || y1 === w.globals.gridHeight && y2 === w.globals.gridHeight || w.globals.isBarHorizontal && (i === 0 || i === xCount - 1);
    const graphics = new Graphics(this);
    const line = graphics.drawLine(
      x1 - (isHorzLine ? offX : 0),
      y1,
      x2 + (isHorzLine ? offX : 0),
      y2,
      w.config.grid.borderColor,
      w.config.grid.strokeDashArray
    );
    line.node.classList.add("apexcharts-gridline");
    if (excludeBorders && w.config.grid.show) {
      this.elGridBorders.add(line);
    } else {
      parent.add(line);
    }
  }
  _drawGridBandRect({ c, x1, y1, x2, y2, type }) {
    const w = this.w;
    const graphics = new Graphics(this.ctx);
    const offX = w.globals.barPadForNumericAxis;
    const color = w.config.grid[type].colors[c];
    const rect = graphics.drawRect(
      x1 - (type === "row" ? offX : 0),
      y1,
      x2 + (type === "row" ? offX * 2 : 0),
      y2,
      0,
      color,
      w.config.grid[type].opacity
    );
    this.elg.add(rect);
    rect.attr("clip-path", `url(#gridRectMask${w.globals.cuid})`);
    rect.node.classList.add(`apexcharts-grid-${type}`);
  }
  _drawXYLines({ xCount, tickAmount }) {
    const w = this.w;
    const datetimeLines = ({ xC, x1, y1, x2, y2 }) => {
      for (let i = 0; i < xC; i++) {
        x1 = this.xaxisLabels[i].position;
        x2 = this.xaxisLabels[i].position;
        this._drawGridLines({
          i,
          x1,
          y1,
          x2,
          y2,
          xCount,
          parent: this.elgridLinesV
        });
      }
    };
    const categoryLines = ({ xC, x1, y1, x2, y2 }) => {
      for (let i = 0; i < xC + (w.globals.isXNumeric ? 0 : 1); i++) {
        if (i === 0 && xC === 1 && w.globals.dataPoints === 1) {
          x1 = w.globals.gridWidth / 2;
          x2 = x1;
        }
        this._drawGridLines({
          i,
          x1,
          y1,
          x2,
          y2,
          xCount,
          parent: this.elgridLinesV
        });
        x1 += w.globals.gridWidth / (w.globals.isXNumeric ? xC - 1 : xC);
        x2 = x1;
      }
    };
    if (w.config.grid.xaxis.lines.show || w.config.xaxis.axisTicks.show) {
      let x1 = w.globals.padHorizontal;
      let y1 = 0;
      let x2;
      let y2 = w.globals.gridHeight;
      if (w.globals.timescaleLabels.length) {
        datetimeLines({ xC: xCount, x1, y1, x2, y2 });
      } else {
        if (w.globals.isXNumeric) {
          xCount = w.globals.xAxisScale.result.length;
        }
        categoryLines({ xC: xCount, x1, y1, x2, y2 });
      }
    }
    if (w.config.grid.yaxis.lines.show) {
      let x1 = 0;
      let y1 = 0;
      let y2 = 0;
      let x2 = w.globals.gridWidth;
      let tA = tickAmount + 1;
      if (this.isRangeBar) {
        tA = w.globals.labels.length;
      }
      for (let i = 0; i < tA + (this.isRangeBar ? 1 : 0); i++) {
        this._drawGridLine({
          i,
          xCount: tA + (this.isRangeBar ? 1 : 0),
          x1,
          y1,
          x2,
          y2,
          parent: this.elgridLinesH
        });
        y1 += w.globals.gridHeight / (this.isRangeBar ? tA : tickAmount);
        y2 = y1;
      }
    }
  }
  _drawInvertedXYLines({ xCount }) {
    const w = this.w;
    if (w.config.grid.xaxis.lines.show || w.config.xaxis.axisTicks.show) {
      let x1 = w.globals.padHorizontal;
      let y1 = 0;
      let x2;
      let y2 = w.globals.gridHeight;
      for (let i = 0; i < xCount + 1; i++) {
        if (w.config.grid.xaxis.lines.show) {
          this._drawGridLine({
            i,
            xCount: xCount + 1,
            x1,
            y1,
            x2,
            y2,
            parent: this.elgridLinesV
          });
        }
        const xAxis = new XAxis(this.ctx);
        xAxis.drawXaxisTicks(x1, 0, w.globals.dom.elGraphical);
        x1 += w.globals.gridWidth / xCount;
        x2 = x1;
      }
    }
    if (w.config.grid.yaxis.lines.show) {
      let x1 = 0;
      let y1 = 0;
      let y2 = 0;
      let x2 = w.globals.gridWidth;
      for (let i = 0; i < w.globals.dataPoints + 1; i++) {
        this._drawGridLine({
          i,
          xCount: w.globals.dataPoints + 1,
          x1,
          y1,
          x2,
          y2,
          parent: this.elgridLinesH
        });
        y1 += w.globals.gridHeight / w.globals.dataPoints;
        y2 = y1;
      }
    }
  }
  renderGrid() {
    var _a, _b, _c;
    const w = this.w;
    const gl = w.globals;
    const graphics = new Graphics(this.ctx);
    this.elg = graphics.group({ class: "apexcharts-grid" });
    this.elgridLinesH = graphics.group({
      class: "apexcharts-gridlines-horizontal"
    });
    this.elgridLinesV = graphics.group({
      class: "apexcharts-gridlines-vertical"
    });
    this.elGridBorders = graphics.group({ class: "apexcharts-grid-borders" });
    this.elg.add(this.elgridLinesH);
    this.elg.add(this.elgridLinesV);
    if (!w.config.grid.show) {
      this.elgridLinesV.hide();
      this.elgridLinesH.hide();
      this.elGridBorders.hide();
    }
    let gridAxisIndex = 0;
    while (gridAxisIndex < gl.seriesYAxisMap.length && gl.ignoreYAxisIndexes.includes(gridAxisIndex)) {
      gridAxisIndex++;
    }
    if (gridAxisIndex === gl.seriesYAxisMap.length) {
      gridAxisIndex = 0;
    }
    let yTickAmount = gl.yAxisScale[gridAxisIndex].result.length - 1;
    let xCount;
    if (!gl.isBarHorizontal || this.isRangeBar) {
      xCount = this.xaxisLabels.length;
      if (this.isRangeBar) {
        yTickAmount = gl.labels.length;
        if (w.config.xaxis.tickAmount && w.config.xaxis.labels.formatter) {
          xCount = w.config.xaxis.tickAmount;
        }
        if (((_c = (_b = (_a = gl.yAxisScale) == null ? void 0 : _a[gridAxisIndex]) == null ? void 0 : _b.result) == null ? void 0 : _c.length) > 0 && w.config.xaxis.type !== "datetime") {
          xCount = gl.yAxisScale[gridAxisIndex].result.length - 1;
        }
      }
      this._drawXYLines({ xCount, tickAmount: yTickAmount });
    } else {
      xCount = yTickAmount;
      yTickAmount = gl.xTickAmount;
      this._drawInvertedXYLines({ xCount, tickAmount: yTickAmount });
    }
    this.drawGridBands(xCount, yTickAmount);
    return {
      el: this.elg,
      elGridBorders: this.elGridBorders,
      xAxisTickWidth: gl.gridWidth / xCount
    };
  }
  drawGridBands(xCount, tickAmount) {
    var _a, _b, _c;
    const w = this.w;
    const drawBands = (type, count, x1, y1, x2, y2) => {
      for (let i = 0, c = 0; i < count; i++, c++) {
        if (c >= w.config.grid[type].colors.length) {
          c = 0;
        }
        this._drawGridBandRect({ c, x1, y1, x2, y2, type });
        y1 += w.globals.gridHeight / tickAmount;
      }
    };
    if (((_a = w.config.grid.row.colors) == null ? void 0 : _a.length) > 0) {
      drawBands(
        "row",
        tickAmount,
        0,
        0,
        w.globals.gridWidth,
        w.globals.gridHeight / tickAmount
      );
    }
    if (((_b = w.config.grid.column.colors) == null ? void 0 : _b.length) > 0) {
      let xc = !w.globals.isBarHorizontal && w.config.xaxis.tickPlacement === "on" && (w.config.xaxis.type === "category" || w.config.xaxis.convertedCatToNumeric) ? xCount - 1 : xCount;
      if (w.globals.isXNumeric) {
        xc = w.globals.xAxisScale.result.length - 1;
      }
      let x1 = w.globals.padHorizontal;
      let y1 = 0;
      let x2 = w.globals.padHorizontal + w.globals.gridWidth / xc;
      let y2 = w.globals.gridHeight;
      for (let i = 0, c = 0; i < xCount; i++, c++) {
        if (c >= w.config.grid.column.colors.length) {
          c = 0;
        }
        if (w.config.xaxis.type === "datetime") {
          x1 = this.xaxisLabels[i].position;
          x2 = (((_c = this.xaxisLabels[i + 1]) == null ? void 0 : _c.position) || w.globals.gridWidth) - this.xaxisLabels[i].position;
        }
        this._drawGridBandRect({ c, x1, y1, x2, y2, type: "column" });
        x1 += w.globals.gridWidth / xc;
      }
    }
  }
}
class Scales {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
    this.coreUtils = new CoreUtils(this.ctx);
  }
  // http://stackoverflow.com/questions/326679/choosing-an-attractive-linear-scale-for-a-graphs-y-axis
  // This routine creates the Y axis values for a graph.
  niceScale(yMin, yMax, index2 = 0) {
    const jsPrecision = 1e-11;
    const w = this.w;
    const gl = w.globals;
    let axisCnf;
    let maxTicks;
    let gotMin;
    let gotMax;
    if (gl.isBarHorizontal) {
      axisCnf = w.config.xaxis;
      maxTicks = Math.max((gl.svgWidth - 100) / 25, 2);
    } else {
      axisCnf = w.config.yaxis[index2];
      maxTicks = Math.max((gl.svgHeight - 100) / 15, 2);
    }
    if (!Utils$1.isNumber(maxTicks)) {
      maxTicks = 10;
    }
    gotMin = axisCnf.min !== void 0 && axisCnf.min !== null;
    gotMax = axisCnf.max !== void 0 && axisCnf.min !== null;
    let gotStepSize = axisCnf.stepSize !== void 0 && axisCnf.stepSize !== null;
    let gotTickAmount = axisCnf.tickAmount !== void 0 && axisCnf.tickAmount !== null;
    let ticks = gotTickAmount ? axisCnf.tickAmount : gl.niceScaleDefaultTicks[Math.min(
      Math.round(maxTicks / 2),
      gl.niceScaleDefaultTicks.length - 1
    )];
    if (gl.isMultipleYAxis && !gotTickAmount && gl.multiAxisTickAmount > 0) {
      ticks = gl.multiAxisTickAmount;
      gotTickAmount = true;
    }
    if (ticks === "dataPoints") {
      ticks = gl.dataPoints - 1;
    } else {
      ticks = Math.abs(Math.round(ticks));
    }
    if (yMin === Number.MIN_VALUE && yMax === 0 || !Utils$1.isNumber(yMin) && !Utils$1.isNumber(yMax) || yMin === Number.MIN_VALUE && yMax === -Number.MAX_VALUE) {
      yMin = Utils$1.isNumber(axisCnf.min) ? axisCnf.min : 0;
      yMax = Utils$1.isNumber(axisCnf.max) ? axisCnf.max : yMin + ticks;
      gl.allSeriesCollapsed = false;
    }
    if (yMin > yMax) {
      console.warn(
        "axis.min cannot be greater than axis.max: swapping min and max"
      );
      let temp = yMax;
      yMax = yMin;
      yMin = temp;
    } else if (yMin === yMax) {
      yMin = yMin === 0 ? 0 : yMin - 1;
      yMax = yMax === 0 ? 2 : yMax + 1;
    }
    let result = [];
    if (ticks < 1) {
      ticks = 1;
    }
    let tiks = ticks;
    let range = Math.abs(yMax - yMin);
    let proximityRatio = 0.15;
    if (!gotMin && yMin > 0 && yMin / range < proximityRatio) {
      yMin = 0;
      gotMin = true;
    }
    if (!gotMax && yMax < 0 && -yMax / range < proximityRatio) {
      yMax = 0;
      gotMax = true;
    }
    range = Math.abs(yMax - yMin);
    let stepSize = range / tiks;
    let niceStep = stepSize;
    let mag = Math.floor(Math.log10(niceStep));
    let magPow = Math.pow(10, mag);
    let magMsd = Math.ceil(niceStep / magPow);
    magMsd = gl.niceScaleAllowedMagMsd[gl.yValueDecimal === 0 ? 0 : 1][magMsd];
    niceStep = magMsd * magPow;
    stepSize = niceStep;
    if (gl.isBarHorizontal && axisCnf.stepSize && axisCnf.type !== "datetime") {
      stepSize = axisCnf.stepSize;
      gotStepSize = true;
    } else if (gotStepSize) {
      stepSize = axisCnf.stepSize;
    }
    if (gotStepSize) {
      if (axisCnf.forceNiceScale) {
        let stepMag = Math.floor(Math.log10(stepSize));
        stepSize *= Math.pow(10, mag - stepMag);
      }
    }
    if (gotMin && gotMax) {
      let crudeStep = range / tiks;
      if (gotTickAmount) {
        if (gotStepSize) {
          if (Utils$1.mod(range, stepSize) != 0) {
            let gcdStep = Utils$1.getGCD(stepSize, crudeStep);
            if (crudeStep / gcdStep < 10) {
              stepSize = gcdStep;
            } else {
              stepSize = crudeStep;
            }
          } else {
            if (Utils$1.mod(stepSize, crudeStep) == 0) {
              stepSize = crudeStep;
            } else {
              crudeStep = stepSize;
              gotTickAmount = false;
            }
          }
        } else {
          stepSize = crudeStep;
        }
      } else {
        if (gotStepSize) {
          if (Utils$1.mod(range, stepSize) == 0) {
            crudeStep = stepSize;
          } else {
            stepSize = crudeStep;
          }
        } else {
          if (Utils$1.mod(range, stepSize) == 0) {
            crudeStep = stepSize;
          } else {
            tiks = Math.ceil(range / stepSize);
            crudeStep = range / tiks;
            let gcdStep = Utils$1.getGCD(range, stepSize);
            if (range / gcdStep < maxTicks) {
              crudeStep = gcdStep;
            }
            stepSize = crudeStep;
          }
        }
      }
      tiks = Math.round(range / stepSize);
    } else {
      if (!gotMin && !gotMax) {
        if (gl.isMultipleYAxis && gotTickAmount) {
          let tMin = stepSize * Math.floor(yMin / stepSize);
          let tMax = tMin + stepSize * tiks;
          if (tMax < yMax) {
            stepSize *= 2;
          }
          yMin = tMin;
          tMax = yMax;
          yMax = yMin + stepSize * tiks;
          range = Math.abs(yMax - yMin);
          if (yMin > 0 && yMin < Math.abs(tMax - yMax)) {
            yMin = 0;
            yMax = stepSize * tiks;
          }
          if (yMax < 0 && -yMax < Math.abs(tMin - yMin)) {
            yMax = 0;
            yMin = -stepSize * tiks;
          }
        } else {
          yMin = stepSize * Math.floor(yMin / stepSize);
          yMax = stepSize * Math.ceil(yMax / stepSize);
        }
      } else if (gotMax) {
        if (gotTickAmount) {
          yMin = yMax - stepSize * tiks;
        } else {
          let yMinPrev = yMin;
          yMin = stepSize * Math.floor(yMin / stepSize);
          if (Math.abs(yMax - yMin) / Utils$1.getGCD(range, stepSize) > maxTicks) {
            yMin = yMax - stepSize * ticks;
            yMin += stepSize * Math.floor((yMinPrev - yMin) / stepSize);
          }
        }
      } else if (gotMin) {
        if (gotTickAmount) {
          yMax = yMin + stepSize * tiks;
        } else {
          let yMaxPrev = yMax;
          yMax = stepSize * Math.ceil(yMax / stepSize);
          if (Math.abs(yMax - yMin) / Utils$1.getGCD(range, stepSize) > maxTicks) {
            yMax = yMin + stepSize * ticks;
            yMax += stepSize * Math.ceil((yMaxPrev - yMax) / stepSize);
          }
        }
      }
      range = Math.abs(yMax - yMin);
      stepSize = Utils$1.getGCD(range, stepSize);
      tiks = Math.round(range / stepSize);
    }
    if (!gotTickAmount && !(gotMin || gotMax)) {
      tiks = Math.ceil((range - jsPrecision) / (stepSize + jsPrecision));
      if (tiks > 16 && Utils$1.getPrimeFactors(tiks).length < 2) {
        tiks++;
      }
    }
    if (!gotTickAmount && axisCnf.forceNiceScale && gl.yValueDecimal === 0 && tiks > range) {
      tiks = range;
      stepSize = Math.round(range / tiks);
    }
    if (tiks > maxTicks && (!(gotTickAmount || gotStepSize) || axisCnf.forceNiceScale)) {
      let pf = Utils$1.getPrimeFactors(tiks);
      let last = pf.length - 1;
      let tt = tiks;
      reduceLoop: for (var xFactors = 0; xFactors < last; xFactors++) {
        for (var lowest = 0; lowest <= last - xFactors; lowest++) {
          let stop = Math.min(lowest + xFactors, last);
          let t = tt;
          let div = 1;
          for (var next = lowest; next <= stop; next++) {
            div *= pf[next];
          }
          t /= div;
          if (t < maxTicks) {
            tt = t;
            break reduceLoop;
          }
        }
      }
      if (tt === tiks) {
        stepSize = range;
      } else {
        stepSize = range / tt;
      }
      tiks = Math.round(range / stepSize);
    }
    if (gl.isMultipleYAxis && gl.multiAxisTickAmount == 0 && gl.ignoreYAxisIndexes.indexOf(index2) < 0) {
      gl.multiAxisTickAmount = tiks;
    }
    let val = yMin - stepSize;
    let err = stepSize * jsPrecision;
    do {
      val += stepSize;
      result.push(Utils$1.stripNumber(val, 7));
    } while (yMax - val > err);
    return {
      result,
      niceMin: result[0],
      niceMax: result[result.length - 1]
    };
  }
  linearScale(yMin, yMax, ticks = 10, index2 = 0, step = void 0) {
    let range = Math.abs(yMax - yMin);
    let result = [];
    if (yMin === yMax) {
      result = [yMin];
      return {
        result,
        niceMin: result[0],
        niceMax: result[result.length - 1]
      };
    }
    ticks = this._adjustTicksForSmallRange(ticks, index2, range);
    if (ticks === "dataPoints") {
      ticks = this.w.globals.dataPoints - 1;
    }
    if (!step) {
      step = range / ticks;
    }
    const MIN_PRECISION = 2;
    if (step !== 0 && isFinite(step)) {
      const magnitude = Math.floor(Math.log10(Math.abs(step)));
      const precision = Math.max(MIN_PRECISION, -magnitude + MIN_PRECISION);
      const multiplier = Math.pow(10, precision);
      step = Math.round((step + Number.EPSILON) * multiplier) / multiplier;
    }
    if (ticks === Number.MAX_VALUE) {
      ticks = 5;
      step = 1;
    }
    let v = yMin;
    while (ticks >= 0) {
      result.push(v);
      v = Utils$1.preciseAddition(v, step);
      ticks -= 1;
    }
    return {
      result,
      niceMin: result[0],
      niceMax: result[result.length - 1]
    };
  }
  logarithmicScaleNice(yMin, yMax, base) {
    if (yMax <= 0) yMax = Math.max(yMin, base);
    if (yMin <= 0) yMin = Math.min(yMax, base);
    const logs = [];
    const logMax = Math.ceil(Math.log(yMax) / Math.log(base) + 1);
    const logMin = Math.floor(Math.log(yMin) / Math.log(base));
    for (let i = logMin; i < logMax; i++) {
      logs.push(Math.pow(base, i));
    }
    return {
      result: logs,
      niceMin: logs[0],
      niceMax: logs[logs.length - 1]
    };
  }
  logarithmicScale(yMin, yMax, base) {
    if (yMax <= 0) yMax = Math.max(yMin, base);
    if (yMin <= 0) yMin = Math.min(yMax, base);
    const logs = [];
    const logMax = Math.log(yMax) / Math.log(base);
    const logMin = Math.log(yMin) / Math.log(base);
    const logRange = logMax - logMin;
    const ticks = Math.round(logRange);
    const logTickSpacing = logRange / ticks;
    for (let i = 0, logTick = logMin; i < ticks; i++, logTick += logTickSpacing) {
      logs.push(Math.pow(base, logTick));
    }
    logs.push(Math.pow(base, logMax));
    return {
      result: logs,
      niceMin: yMin,
      niceMax: yMax
    };
  }
  _adjustTicksForSmallRange(ticks, index2, range) {
    let newTicks = ticks;
    if (typeof index2 !== "undefined" && this.w.config.yaxis[index2].labels.formatter && this.w.config.yaxis[index2].tickAmount === void 0) {
      const formattedVal = Number(
        this.w.config.yaxis[index2].labels.formatter(1)
      );
      if (Utils$1.isNumber(formattedVal) && this.w.globals.yValueDecimal === 0) {
        newTicks = Math.ceil(range);
      }
    }
    return newTicks < ticks ? newTicks : ticks;
  }
  setYScaleForIndex(index2, minY, maxY) {
    const gl = this.w.globals;
    const cnf = this.w.config;
    let y = gl.isBarHorizontal ? cnf.xaxis : cnf.yaxis[index2];
    if (typeof gl.yAxisScale[index2] === "undefined") {
      gl.yAxisScale[index2] = [];
    }
    let range = Math.abs(maxY - minY);
    if (y.logarithmic && range <= 5) {
      gl.invalidLogScale = true;
    }
    if (y.logarithmic && range > 5) {
      gl.allSeriesCollapsed = false;
      gl.yAxisScale[index2] = y.forceNiceScale ? this.logarithmicScaleNice(minY, maxY, y.logBase) : this.logarithmicScale(minY, maxY, y.logBase);
    } else {
      if (maxY === -Number.MAX_VALUE || !Utils$1.isNumber(maxY) || minY === Number.MAX_VALUE || !Utils$1.isNumber(minY)) {
        gl.yAxisScale[index2] = this.niceScale(Number.MIN_VALUE, 0, index2);
      } else {
        gl.allSeriesCollapsed = false;
        gl.yAxisScale[index2] = this.niceScale(minY, maxY, index2);
      }
    }
  }
  setXScale(minX, maxX) {
    const w = this.w;
    const gl = w.globals;
    if (maxX === -Number.MAX_VALUE || !Utils$1.isNumber(maxX)) {
      gl.xAxisScale = this.linearScale(0, 10, 10);
    } else {
      let ticks = gl.xTickAmount;
      gl.xAxisScale = this.linearScale(
        minX,
        maxX,
        ticks,
        0,
        w.config.xaxis.max === void 0 ? w.config.xaxis.stepSize : void 0
      );
    }
    return gl.xAxisScale;
  }
  scaleMultipleYAxes() {
    const cnf = this.w.config;
    const gl = this.w.globals;
    this.coreUtils.setSeriesYAxisMappings();
    let axisSeriesMap = gl.seriesYAxisMap;
    let minYArr = gl.minYArr;
    let maxYArr = gl.maxYArr;
    gl.allSeriesCollapsed = true;
    gl.barGroups = [];
    axisSeriesMap.forEach((axisSeries, ai) => {
      let groupNames = [];
      axisSeries.forEach((as2) => {
        var _a;
        let group = (_a = cnf.series[as2]) == null ? void 0 : _a.group;
        if (groupNames.indexOf(group) < 0) {
          groupNames.push(group);
        }
      });
      if (axisSeries.length > 0) {
        let minY = Number.MAX_VALUE;
        let maxY = -Number.MAX_VALUE;
        let lowestY = minY;
        let highestY = maxY;
        let seriesType;
        let seriesGroupName;
        if (cnf.chart.stacked) {
          let mapSeries = new Array(gl.dataPoints).fill(0);
          let sumSeries = [];
          let posSeries = [];
          let negSeries = [];
          groupNames.forEach(() => {
            sumSeries.push(mapSeries.map(() => Number.MIN_VALUE));
            posSeries.push(mapSeries.map(() => Number.MIN_VALUE));
            negSeries.push(mapSeries.map(() => Number.MIN_VALUE));
          });
          for (let i = 0; i < axisSeries.length; i++) {
            if (!seriesType && cnf.series[axisSeries[i]].type) {
              seriesType = cnf.series[axisSeries[i]].type;
            }
            let si = axisSeries[i];
            if (cnf.series[si].group) {
              seriesGroupName = cnf.series[si].group;
            } else {
              seriesGroupName = "axis-".concat(ai);
            }
            let collapsed = !(gl.collapsedSeriesIndices.indexOf(si) < 0 && gl.ancillaryCollapsedSeriesIndices.indexOf(si) < 0);
            if (!collapsed) {
              gl.allSeriesCollapsed = false;
              groupNames.forEach((gn, gni) => {
                if (cnf.series[si].group === gn) {
                  for (let j = 0; j < gl.series[si].length; j++) {
                    let val = gl.series[si][j];
                    if (val >= 0) {
                      posSeries[gni][j] += val;
                    } else {
                      negSeries[gni][j] += val;
                    }
                    sumSeries[gni][j] += val;
                    lowestY = Math.min(lowestY, val);
                    highestY = Math.max(highestY, val);
                  }
                }
              });
            }
            if (seriesType === "bar" || seriesType === "column") {
              gl.barGroups.push(seriesGroupName);
            }
          }
          if (!seriesType) {
            seriesType = cnf.chart.type;
          }
          if (seriesType === "bar" || seriesType === "column") {
            groupNames.forEach((gn, gni) => {
              minY = Math.min(minY, Math.min.apply(null, negSeries[gni]));
              maxY = Math.max(maxY, Math.max.apply(null, posSeries[gni]));
            });
          } else {
            groupNames.forEach((gn, gni) => {
              lowestY = Math.min(lowestY, Math.min.apply(null, sumSeries[gni]));
              highestY = Math.max(
                highestY,
                Math.max.apply(null, sumSeries[gni])
              );
            });
            minY = lowestY;
            maxY = highestY;
          }
          if (minY === Number.MIN_VALUE && maxY === Number.MIN_VALUE) {
            maxY = -Number.MAX_VALUE;
          }
        } else {
          for (let i = 0; i < axisSeries.length; i++) {
            let si = axisSeries[i];
            minY = Math.min(minY, minYArr[si]);
            maxY = Math.max(maxY, maxYArr[si]);
            let collapsed = !(gl.collapsedSeriesIndices.indexOf(si) < 0 && gl.ancillaryCollapsedSeriesIndices.indexOf(si) < 0);
            if (!collapsed) {
              gl.allSeriesCollapsed = false;
            }
          }
        }
        if (cnf.yaxis[ai].min !== void 0) {
          if (typeof cnf.yaxis[ai].min === "function") {
            minY = cnf.yaxis[ai].min(minY);
          } else {
            minY = cnf.yaxis[ai].min;
          }
        }
        if (cnf.yaxis[ai].max !== void 0) {
          if (typeof cnf.yaxis[ai].max === "function") {
            maxY = cnf.yaxis[ai].max(maxY);
          } else {
            maxY = cnf.yaxis[ai].max;
          }
        }
        gl.barGroups = gl.barGroups.filter((v, i, a) => a.indexOf(v) === i);
        this.setYScaleForIndex(ai, minY, maxY);
        axisSeries.forEach((si) => {
          minYArr[si] = gl.yAxisScale[ai].niceMin;
          maxYArr[si] = gl.yAxisScale[ai].niceMax;
        });
      } else {
        this.setYScaleForIndex(ai, 0, -Number.MAX_VALUE);
      }
    });
  }
}
class Range {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
    this.scales = new Scales(ctx);
  }
  init() {
    this.setYRange();
    this.setXRange();
    this.setZRange();
  }
  getMinYMaxY(startingSeriesIndex, lowestY = Number.MAX_VALUE, highestY = -Number.MAX_VALUE, endingSeriesIndex = null) {
    var _a, _b, _c, _d, _e;
    const cnf = this.w.config;
    const gl = this.w.globals;
    let maxY = -Number.MAX_VALUE;
    let minY = Number.MIN_VALUE;
    if (endingSeriesIndex === null) {
      endingSeriesIndex = startingSeriesIndex + 1;
    }
    let series = gl.series;
    let seriesMin = series;
    let seriesMax = series;
    if (cnf.chart.type === "candlestick") {
      seriesMin = gl.seriesCandleL;
      seriesMax = gl.seriesCandleH;
    } else if (cnf.chart.type === "boxPlot") {
      seriesMin = gl.seriesCandleO;
      seriesMax = gl.seriesCandleC;
    } else if (gl.isRangeData) {
      seriesMin = gl.seriesRangeStart;
      seriesMax = gl.seriesRangeEnd;
    }
    let autoScaleYaxis = false;
    if (gl.seriesX.length >= endingSeriesIndex) {
      let brush = (_a = gl.brushSource) == null ? void 0 : _a.w.config.chart.brush;
      if (cnf.chart.zoom.enabled && cnf.chart.zoom.autoScaleYaxis || (brush == null ? void 0 : brush.enabled) && (brush == null ? void 0 : brush.autoScaleYaxis)) {
        autoScaleYaxis = true;
      }
    }
    for (let i = startingSeriesIndex; i < endingSeriesIndex; i++) {
      gl.dataPoints = Math.max(gl.dataPoints, series[i].length);
      const seriesType = cnf.series[i].type;
      if (gl.categoryLabels.length) {
        gl.dataPoints = gl.categoryLabels.filter(
          (label) => typeof label !== "undefined"
        ).length;
      }
      if (gl.labels.length && cnf.xaxis.type !== "datetime" && gl.series.reduce((a, c) => a + c.length, 0) !== 0) {
        gl.dataPoints = Math.max(gl.dataPoints, gl.labels.length);
      }
      let firstXIndex = 0;
      let lastXIndex = series[i].length - 1;
      if (autoScaleYaxis) {
        if (cnf.xaxis.min) {
          for (; firstXIndex < lastXIndex && gl.seriesX[i][firstXIndex] < cnf.xaxis.min; firstXIndex++) {
          }
        }
        if (cnf.xaxis.max) {
          for (; lastXIndex > firstXIndex && gl.seriesX[i][lastXIndex] > cnf.xaxis.max; lastXIndex--) {
          }
        }
      }
      for (let j = firstXIndex; j <= lastXIndex && j < gl.series[i].length; j++) {
        let val = series[i][j];
        if (val !== null && Utils$1.isNumber(val)) {
          if (typeof ((_b = seriesMax[i]) == null ? void 0 : _b[j]) !== "undefined") {
            maxY = Math.max(maxY, seriesMax[i][j]);
            lowestY = Math.min(lowestY, seriesMax[i][j]);
          }
          if (typeof ((_c = seriesMin[i]) == null ? void 0 : _c[j]) !== "undefined") {
            lowestY = Math.min(lowestY, seriesMin[i][j]);
            highestY = Math.max(highestY, seriesMin[i][j]);
          }
          switch (seriesType) {
            case "candlestick":
              {
                if (typeof gl.seriesCandleC[i][j] !== "undefined") {
                  maxY = Math.max(maxY, gl.seriesCandleH[i][j]);
                  lowestY = Math.min(lowestY, gl.seriesCandleL[i][j]);
                }
              }
              break;
            case "boxPlot":
              {
                if (typeof gl.seriesCandleC[i][j] !== "undefined") {
                  maxY = Math.max(maxY, gl.seriesCandleC[i][j]);
                  lowestY = Math.min(lowestY, gl.seriesCandleO[i][j]);
                }
              }
              break;
          }
          if (seriesType && seriesType !== "candlestick" && seriesType !== "boxPlot" && seriesType !== "rangeArea" && seriesType !== "rangeBar") {
            maxY = Math.max(maxY, gl.series[i][j]);
            lowestY = Math.min(lowestY, gl.series[i][j]);
          }
          if (gl.seriesGoals[i] && gl.seriesGoals[i][j] && Array.isArray(gl.seriesGoals[i][j])) {
            gl.seriesGoals[i][j].forEach((g) => {
              maxY = Math.max(maxY, g.value);
              lowestY = Math.min(lowestY, g.value);
            });
          }
          highestY = maxY;
          val = Utils$1.noExponents(val);
          if (Utils$1.isFloat(val)) {
            gl.yValueDecimal = Math.max(
              gl.yValueDecimal,
              val.toString().split(".")[1].length
            );
          }
          if (minY > ((_d = seriesMin[i]) == null ? void 0 : _d[j]) && ((_e = seriesMin[i]) == null ? void 0 : _e[j]) < 0) {
            minY = seriesMin[i][j];
          }
        } else {
          gl.hasNullValues = true;
        }
      }
      if (seriesType === "bar" || seriesType === "column") {
        if (minY < 0 && maxY < 0) {
          maxY = 0;
          highestY = Math.max(highestY, 0);
        }
        if (minY === Number.MIN_VALUE) {
          minY = 0;
          lowestY = Math.min(lowestY, 0);
        }
      }
    }
    if (cnf.chart.type === "rangeBar" && gl.seriesRangeStart.length && gl.isBarHorizontal) {
      minY = lowestY;
    }
    if (cnf.chart.type === "bar") {
      if (minY < 0 && maxY < 0) {
        maxY = 0;
      }
      if (minY === Number.MIN_VALUE) {
        minY = 0;
      }
    }
    return {
      minY,
      maxY,
      lowestY,
      highestY
    };
  }
  setYRange() {
    let gl = this.w.globals;
    let cnf = this.w.config;
    gl.maxY = -Number.MAX_VALUE;
    gl.minY = Number.MIN_VALUE;
    let lowestYInAllSeries = Number.MAX_VALUE;
    let minYMaxY;
    if (gl.isMultipleYAxis) {
      lowestYInAllSeries = Number.MAX_VALUE;
      for (let i = 0; i < gl.series.length; i++) {
        minYMaxY = this.getMinYMaxY(i);
        gl.minYArr[i] = minYMaxY.lowestY;
        gl.maxYArr[i] = minYMaxY.highestY;
        lowestYInAllSeries = Math.min(lowestYInAllSeries, minYMaxY.lowestY);
      }
    }
    minYMaxY = this.getMinYMaxY(0, lowestYInAllSeries, null, gl.series.length);
    if (cnf.chart.type === "bar") {
      gl.minY = minYMaxY.minY;
      gl.maxY = minYMaxY.maxY;
    } else {
      gl.minY = minYMaxY.lowestY;
      gl.maxY = minYMaxY.highestY;
    }
    lowestYInAllSeries = minYMaxY.lowestY;
    if (cnf.chart.stacked) {
      this._setStackedMinMax();
    }
    if (cnf.chart.type === "line" || cnf.chart.type === "area" || cnf.chart.type === "scatter" || cnf.chart.type === "candlestick" || cnf.chart.type === "boxPlot" || cnf.chart.type === "rangeBar" && !gl.isBarHorizontal) {
      if (gl.minY === Number.MIN_VALUE && lowestYInAllSeries !== -Number.MAX_VALUE && lowestYInAllSeries !== gl.maxY) {
        gl.minY = lowestYInAllSeries;
      }
    } else {
      gl.minY = gl.minY !== Number.MIN_VALUE ? Math.min(minYMaxY.minY, gl.minY) : minYMaxY.minY;
    }
    cnf.yaxis.forEach((yaxe, index2) => {
      if (yaxe.max !== void 0) {
        if (typeof yaxe.max === "number") {
          gl.maxYArr[index2] = yaxe.max;
        } else if (typeof yaxe.max === "function") {
          gl.maxYArr[index2] = yaxe.max(
            gl.isMultipleYAxis ? gl.maxYArr[index2] : gl.maxY
          );
        }
        gl.maxY = gl.maxYArr[index2];
      }
      if (yaxe.min !== void 0) {
        if (typeof yaxe.min === "number") {
          gl.minYArr[index2] = yaxe.min;
        } else if (typeof yaxe.min === "function") {
          gl.minYArr[index2] = yaxe.min(
            gl.isMultipleYAxis ? gl.minYArr[index2] === Number.MIN_VALUE ? 0 : gl.minYArr[index2] : gl.minY
          );
        }
        gl.minY = gl.minYArr[index2];
      }
    });
    if (gl.isBarHorizontal) {
      const minmax = ["min", "max"];
      minmax.forEach((m2) => {
        if (cnf.xaxis[m2] !== void 0 && typeof cnf.xaxis[m2] === "number") {
          m2 === "min" ? gl.minY = cnf.xaxis[m2] : gl.maxY = cnf.xaxis[m2];
        }
      });
    }
    if (gl.isMultipleYAxis) {
      this.scales.scaleMultipleYAxes();
      gl.minY = lowestYInAllSeries;
    } else {
      this.scales.setYScaleForIndex(0, gl.minY, gl.maxY);
      gl.minY = gl.yAxisScale[0].niceMin;
      gl.maxY = gl.yAxisScale[0].niceMax;
      gl.minYArr[0] = gl.minY;
      gl.maxYArr[0] = gl.maxY;
    }
    gl.barGroups = [];
    gl.lineGroups = [];
    gl.areaGroups = [];
    cnf.series.forEach((s) => {
      let type = s.type || cnf.chart.type;
      switch (type) {
        case "bar":
        case "column":
          gl.barGroups.push(s.group);
          break;
        case "line":
          gl.lineGroups.push(s.group);
          break;
        case "area":
          gl.areaGroups.push(s.group);
          break;
      }
    });
    gl.barGroups = gl.barGroups.filter((v, i, a) => a.indexOf(v) === i);
    gl.lineGroups = gl.lineGroups.filter((v, i, a) => a.indexOf(v) === i);
    gl.areaGroups = gl.areaGroups.filter((v, i, a) => a.indexOf(v) === i);
    return {
      minY: gl.minY,
      maxY: gl.maxY,
      minYArr: gl.minYArr,
      maxYArr: gl.maxYArr,
      yAxisScale: gl.yAxisScale
    };
  }
  setXRange() {
    let gl = this.w.globals;
    let cnf = this.w.config;
    const isXNumeric = cnf.xaxis.type === "numeric" || cnf.xaxis.type === "datetime" || cnf.xaxis.type === "category" && !gl.noLabelsProvided || gl.noLabelsProvided || gl.isXNumeric;
    const getInitialMinXMaxX = () => {
      for (let i = 0; i < gl.series.length; i++) {
        if (gl.labels[i]) {
          for (let j = 0; j < gl.labels[i].length; j++) {
            if (gl.labels[i][j] !== null && Utils$1.isNumber(gl.labels[i][j])) {
              gl.maxX = Math.max(gl.maxX, gl.labels[i][j]);
              gl.initialMaxX = Math.max(gl.maxX, gl.labels[i][j]);
              gl.minX = Math.min(gl.minX, gl.labels[i][j]);
              gl.initialMinX = Math.min(gl.minX, gl.labels[i][j]);
            }
          }
        }
      }
    };
    if (gl.isXNumeric) {
      getInitialMinXMaxX();
    }
    if (gl.noLabelsProvided) {
      if (cnf.xaxis.categories.length === 0) {
        gl.maxX = gl.labels[gl.labels.length - 1];
        gl.initialMaxX = gl.labels[gl.labels.length - 1];
        gl.minX = 1;
        gl.initialMinX = 1;
      }
    }
    if (gl.isXNumeric || gl.noLabelsProvided || gl.dataFormatXNumeric) {
      let ticks = 10;
      if (cnf.xaxis.tickAmount === void 0) {
        ticks = Math.round(gl.svgWidth / 150);
        if (cnf.xaxis.type === "numeric" && gl.dataPoints < 30) {
          ticks = gl.dataPoints - 1;
        }
        if (ticks > gl.dataPoints && gl.dataPoints !== 0) {
          ticks = gl.dataPoints - 1;
        }
      } else if (cnf.xaxis.tickAmount === "dataPoints") {
        if (gl.series.length > 1) {
          ticks = gl.series[gl.maxValsInArrayIndex].length - 1;
        }
        if (gl.isXNumeric) {
          const diff2 = Math.round(gl.maxX - gl.minX);
          if (diff2 < 30) {
            ticks = diff2;
          }
        }
      } else {
        ticks = cnf.xaxis.tickAmount;
      }
      gl.xTickAmount = ticks;
      if (cnf.xaxis.max !== void 0 && typeof cnf.xaxis.max === "number") {
        gl.maxX = cnf.xaxis.max;
      }
      if (cnf.xaxis.min !== void 0 && typeof cnf.xaxis.min === "number") {
        gl.minX = cnf.xaxis.min;
      }
      if (cnf.xaxis.range !== void 0) {
        gl.minX = gl.maxX - cnf.xaxis.range;
      }
      if (gl.minX !== Number.MAX_VALUE && gl.maxX !== -Number.MAX_VALUE) {
        if (cnf.xaxis.convertedCatToNumeric && !gl.dataFormatXNumeric) {
          let catScale = [];
          for (let i = gl.minX - 1; i < gl.maxX; i++) {
            catScale.push(i + 1);
          }
          gl.xAxisScale = {
            result: catScale,
            niceMin: catScale[0],
            niceMax: catScale[catScale.length - 1]
          };
        } else {
          gl.xAxisScale = this.scales.setXScale(gl.minX, gl.maxX);
        }
      } else {
        gl.xAxisScale = this.scales.linearScale(
          0,
          ticks,
          ticks,
          0,
          cnf.xaxis.stepSize
        );
        if (gl.noLabelsProvided && gl.labels.length > 0) {
          gl.xAxisScale = this.scales.linearScale(
            1,
            gl.labels.length,
            ticks - 1,
            0,
            cnf.xaxis.stepSize
          );
          gl.seriesX = gl.labels.slice();
        }
      }
      if (isXNumeric) {
        gl.labels = gl.xAxisScale.result.slice();
      }
    }
    if (gl.isBarHorizontal && gl.labels.length) {
      gl.xTickAmount = gl.labels.length;
    }
    this._handleSingleDataPoint();
    this._getMinXDiff();
    return {
      minX: gl.minX,
      maxX: gl.maxX
    };
  }
  setZRange() {
    let gl = this.w.globals;
    if (!gl.isDataXYZ) return;
    for (let i = 0; i < gl.series.length; i++) {
      if (typeof gl.seriesZ[i] !== "undefined") {
        for (let j = 0; j < gl.seriesZ[i].length; j++) {
          if (gl.seriesZ[i][j] !== null && Utils$1.isNumber(gl.seriesZ[i][j])) {
            gl.maxZ = Math.max(gl.maxZ, gl.seriesZ[i][j]);
            gl.minZ = Math.min(gl.minZ, gl.seriesZ[i][j]);
          }
        }
      }
    }
  }
  _handleSingleDataPoint() {
    const gl = this.w.globals;
    const cnf = this.w.config;
    if (gl.minX === gl.maxX) {
      let datetimeObj = new DateTime(this.ctx);
      if (cnf.xaxis.type === "datetime") {
        const newMinX = datetimeObj.getDate(gl.minX);
        if (cnf.xaxis.labels.datetimeUTC) {
          newMinX.setUTCDate(newMinX.getUTCDate() - 2);
        } else {
          newMinX.setDate(newMinX.getDate() - 2);
        }
        gl.minX = new Date(newMinX).getTime();
        const newMaxX = datetimeObj.getDate(gl.maxX);
        if (cnf.xaxis.labels.datetimeUTC) {
          newMaxX.setUTCDate(newMaxX.getUTCDate() + 2);
        } else {
          newMaxX.setDate(newMaxX.getDate() + 2);
        }
        gl.maxX = new Date(newMaxX).getTime();
      } else if (cnf.xaxis.type === "numeric" || cnf.xaxis.type === "category" && !gl.noLabelsProvided) {
        gl.minX = gl.minX - 2;
        gl.initialMinX = gl.minX;
        gl.maxX = gl.maxX + 2;
        gl.initialMaxX = gl.maxX;
      }
    }
  }
  _getMinXDiff() {
    const gl = this.w.globals;
    if (gl.isXNumeric) {
      gl.seriesX.forEach((sX) => {
        if (sX.length) {
          if (sX.length === 1) {
            sX.push(
              gl.seriesX[gl.maxValsInArrayIndex][gl.seriesX[gl.maxValsInArrayIndex].length - 1]
            );
          }
          const seriesX = sX.slice();
          seriesX.sort((a, b) => a - b);
          seriesX.forEach((s, j) => {
            if (j > 0) {
              let xDiff = s - seriesX[j - 1];
              if (xDiff > 0) {
                gl.minXDiff = Math.min(xDiff, gl.minXDiff);
              }
            }
          });
          if (gl.dataPoints === 1 || gl.minXDiff === Number.MAX_VALUE) {
            gl.minXDiff = 0.5;
          }
        }
      });
    }
  }
  _setStackedMinMax() {
    const gl = this.w.globals;
    if (!gl.series.length) return;
    let seriesGroups = gl.seriesGroups;
    if (!seriesGroups.length) {
      seriesGroups = [this.w.globals.seriesNames.map((name2) => name2)];
    }
    let stackedPoss = {};
    let stackedNegs = {};
    seriesGroups.forEach((group) => {
      stackedPoss[group] = [];
      stackedNegs[group] = [];
      const indicesOfSeriesInGroup = this.w.config.series.map(
        (serie, si) => group.indexOf(gl.seriesNames[si]) > -1 ? si : null
      ).filter((f) => f !== null);
      indicesOfSeriesInGroup.forEach((i) => {
        var _a, _b, _c, _d;
        for (let j = 0; j < gl.series[gl.maxValsInArrayIndex].length; j++) {
          if (typeof stackedPoss[group][j] === "undefined") {
            stackedPoss[group][j] = 0;
            stackedNegs[group][j] = 0;
          }
          let stackSeries = this.w.config.chart.stacked && !gl.comboCharts || this.w.config.chart.stacked && gl.comboCharts && (!this.w.config.chart.stackOnlyBar || ((_b = (_a = this.w.config.series) == null ? void 0 : _a[i]) == null ? void 0 : _b.type) === "bar" || ((_d = (_c = this.w.config.series) == null ? void 0 : _c[i]) == null ? void 0 : _d.type) === "column");
          if (stackSeries) {
            if (gl.series[i][j] !== null && Utils$1.isNumber(gl.series[i][j])) {
              gl.series[i][j] > 0 ? stackedPoss[group][j] += parseFloat(gl.series[i][j]) + 1e-4 : stackedNegs[group][j] += parseFloat(gl.series[i][j]);
            }
          }
        }
      });
    });
    Object.entries(stackedPoss).forEach(([key]) => {
      stackedPoss[key].forEach((_, stgi) => {
        gl.maxY = Math.max(gl.maxY, stackedPoss[key][stgi]);
        gl.minY = Math.min(gl.minY, stackedNegs[key][stgi]);
      });
    });
  }
}
class YAxis {
  constructor(ctx, elgrid) {
    this.ctx = ctx;
    this.elgrid = elgrid;
    this.w = ctx.w;
    const w = this.w;
    this.xaxisFontSize = w.config.xaxis.labels.style.fontSize;
    this.axisFontFamily = w.config.xaxis.labels.style.fontFamily;
    this.xaxisForeColors = w.config.xaxis.labels.style.colors;
    this.isCategoryBarHorizontal = w.config.chart.type === "bar" && w.config.plotOptions.bar.horizontal;
    this.xAxisoffX = w.config.xaxis.position === "bottom" ? w.globals.gridHeight : 0;
    this.drawnLabels = [];
    this.axesUtils = new AxesUtils(ctx);
  }
  drawYaxis(realIndex) {
    const w = this.w;
    const graphics = new Graphics(this.ctx);
    const yaxisStyle = w.config.yaxis[realIndex].labels.style;
    const {
      fontSize: yaxisFontSize,
      fontFamily: yaxisFontFamily,
      fontWeight: yaxisFontWeight
    } = yaxisStyle;
    const elYaxis = graphics.group({
      class: "apexcharts-yaxis",
      rel: realIndex,
      transform: `translate(${w.globals.translateYAxisX[realIndex]}, 0)`
    });
    if (this.axesUtils.isYAxisHidden(realIndex)) return elYaxis;
    const elYaxisTexts = graphics.group({ class: "apexcharts-yaxis-texts-g" });
    elYaxis.add(elYaxisTexts);
    const tickAmount = w.globals.yAxisScale[realIndex].result.length - 1;
    const labelsDivider = w.globals.gridHeight / tickAmount;
    const lbFormatter = w.globals.yLabelFormatters[realIndex];
    let labels = this.axesUtils.checkForReversedLabels(
      realIndex,
      w.globals.yAxisScale[realIndex].result.slice()
    );
    if (w.config.yaxis[realIndex].labels.show) {
      let lY = w.globals.translateY + w.config.yaxis[realIndex].labels.offsetY;
      if (w.globals.isBarHorizontal) lY = 0;
      else if (w.config.chart.type === "heatmap") lY -= labelsDivider / 2;
      lY += parseInt(yaxisFontSize, 10) / 3;
      let firstLabel = null;
      for (let i = tickAmount; i >= 0; i--) {
        let val = lbFormatter(labels[i], i, w);
        let xPad = w.config.yaxis[realIndex].labels.padding;
        if (w.config.yaxis[realIndex].opposite && w.config.yaxis.length !== 0)
          xPad *= -1;
        const textAnchor = this.getTextAnchor(
          w.config.yaxis[realIndex].labels.align,
          w.config.yaxis[realIndex].opposite
        );
        const yColors = this.axesUtils.getYAxisForeColor(
          yaxisStyle.colors,
          realIndex
        );
        const foreColor = Array.isArray(yColors) ? yColors[i] : yColors;
        const existingYLabels = Utils$1.listToArray(
          w.globals.dom.baseEl.querySelectorAll(
            `.apexcharts-yaxis[rel='${realIndex}'] .apexcharts-yaxis-label tspan`
          )
        ).map((label2) => label2.textContent);
        const label = graphics.drawText({
          x: xPad,
          y: lY,
          text: existingYLabels.includes(val) && !w.config.yaxis[realIndex].labels.showDuplicates ? "" : val,
          textAnchor,
          fontSize: yaxisFontSize,
          fontFamily: yaxisFontFamily,
          fontWeight: yaxisFontWeight,
          maxWidth: w.config.yaxis[realIndex].labels.maxWidth,
          foreColor,
          isPlainText: false,
          cssClass: `apexcharts-yaxis-label ${yaxisStyle.cssClass}`
        });
        elYaxisTexts.add(label);
        this.addTooltip(label, val);
        if (firstLabel === null) {
          firstLabel = label;
        }
        if (w.config.yaxis[realIndex].labels.rotate !== 0) {
          this.rotateLabel(
            graphics,
            label,
            firstLabel,
            w.config.yaxis[realIndex].labels.rotate
          );
        }
        lY += labelsDivider;
      }
    }
    this.addYAxisTitle(graphics, elYaxis, realIndex);
    this.addAxisBorder(graphics, elYaxis, realIndex, tickAmount, labelsDivider);
    return elYaxis;
  }
  getTextAnchor(align, opposite) {
    if (align === "left") return "start";
    if (align === "center") return "middle";
    if (align === "right") return "end";
    return opposite ? "start" : "end";
  }
  addTooltip(label, val) {
    const elTooltipTitle = document.createElementNS(
      this.w.globals.SVGNS,
      "title"
    );
    elTooltipTitle.textContent = Array.isArray(val) ? val.join(" ") : val;
    label.node.appendChild(elTooltipTitle);
  }
  rotateLabel(graphics, label, firstLabel, rotate) {
    const firstLabelCenter = graphics.rotateAroundCenter(firstLabel.node);
    const labelCenter = graphics.rotateAroundCenter(label.node);
    label.node.setAttribute(
      "transform",
      `rotate(${rotate} ${firstLabelCenter.x} ${labelCenter.y})`
    );
  }
  addYAxisTitle(graphics, elYaxis, realIndex) {
    const w = this.w;
    if (w.config.yaxis[realIndex].title.text !== void 0) {
      const elYaxisTitle = graphics.group({ class: "apexcharts-yaxis-title" });
      const x = w.config.yaxis[realIndex].opposite ? w.globals.translateYAxisX[realIndex] : 0;
      const elYAxisTitleText = graphics.drawText({
        x,
        y: w.globals.gridHeight / 2 + w.globals.translateY + w.config.yaxis[realIndex].title.offsetY,
        text: w.config.yaxis[realIndex].title.text,
        textAnchor: "end",
        foreColor: w.config.yaxis[realIndex].title.style.color,
        fontSize: w.config.yaxis[realIndex].title.style.fontSize,
        fontWeight: w.config.yaxis[realIndex].title.style.fontWeight,
        fontFamily: w.config.yaxis[realIndex].title.style.fontFamily,
        cssClass: `apexcharts-yaxis-title-text ${w.config.yaxis[realIndex].title.style.cssClass}`
      });
      elYaxisTitle.add(elYAxisTitleText);
      elYaxis.add(elYaxisTitle);
    }
  }
  addAxisBorder(graphics, elYaxis, realIndex, tickAmount, labelsDivider) {
    const w = this.w;
    const axisBorder = w.config.yaxis[realIndex].axisBorder;
    let x = 31 + axisBorder.offsetX;
    if (w.config.yaxis[realIndex].opposite) x = -31 - axisBorder.offsetX;
    if (axisBorder.show) {
      const elVerticalLine = graphics.drawLine(
        x,
        w.globals.translateY + axisBorder.offsetY - 2,
        x,
        w.globals.gridHeight + w.globals.translateY + axisBorder.offsetY + 2,
        axisBorder.color,
        0,
        axisBorder.width
      );
      elYaxis.add(elVerticalLine);
    }
    if (w.config.yaxis[realIndex].axisTicks.show) {
      this.axesUtils.drawYAxisTicks(
        x,
        tickAmount,
        axisBorder,
        w.config.yaxis[realIndex].axisTicks,
        realIndex,
        labelsDivider,
        elYaxis
      );
    }
  }
  drawYaxisInversed(realIndex) {
    const w = this.w;
    const graphics = new Graphics(this.ctx);
    const elXaxis = graphics.group({
      class: "apexcharts-xaxis apexcharts-yaxis-inversed"
    });
    const elXaxisTexts = graphics.group({
      class: "apexcharts-xaxis-texts-g",
      transform: `translate(${w.globals.translateXAxisX}, ${w.globals.translateXAxisY})`
    });
    elXaxis.add(elXaxisTexts);
    let tickAmount = w.globals.yAxisScale[realIndex].result.length - 1;
    const labelsDivider = w.globals.gridWidth / tickAmount + 0.1;
    let l = labelsDivider + w.config.xaxis.labels.offsetX;
    const lbFormatter = w.globals.xLabelFormatter;
    let labels = this.axesUtils.checkForReversedLabels(
      realIndex,
      w.globals.yAxisScale[realIndex].result.slice()
    );
    const timescaleLabels = w.globals.timescaleLabels;
    if (timescaleLabels.length > 0) {
      this.xaxisLabels = timescaleLabels.slice();
      labels = timescaleLabels.slice();
      tickAmount = labels.length;
    }
    if (w.config.xaxis.labels.show) {
      for (let i = timescaleLabels.length ? 0 : tickAmount; timescaleLabels.length ? i < timescaleLabels.length : i >= 0; timescaleLabels.length ? i++ : i--) {
        let val = lbFormatter(labels[i], i, w);
        let x = w.globals.gridWidth + w.globals.padHorizontal - (l - labelsDivider + w.config.xaxis.labels.offsetX);
        if (timescaleLabels.length) {
          const label = this.axesUtils.getLabel(
            labels,
            timescaleLabels,
            x,
            i,
            this.drawnLabels,
            this.xaxisFontSize
          );
          x = label.x;
          val = label.text;
          this.drawnLabels.push(label.text);
          if (i === 0 && w.globals.skipFirstTimelinelabel) val = "";
          if (i === labels.length - 1 && w.globals.skipLastTimelinelabel)
            val = "";
        }
        const elTick = graphics.drawText({
          x,
          y: this.xAxisoffX + w.config.xaxis.labels.offsetY + 30 - (w.config.xaxis.position === "top" ? w.globals.xAxisHeight + w.config.xaxis.axisTicks.height - 2 : 0),
          text: val,
          textAnchor: "middle",
          foreColor: Array.isArray(this.xaxisForeColors) ? this.xaxisForeColors[realIndex] : this.xaxisForeColors,
          fontSize: this.xaxisFontSize,
          fontFamily: this.xaxisFontFamily,
          fontWeight: w.config.xaxis.labels.style.fontWeight,
          isPlainText: false,
          cssClass: `apexcharts-xaxis-label ${w.config.xaxis.labels.style.cssClass}`
        });
        elXaxisTexts.add(elTick);
        this.addTooltip(elTick, val);
        l += labelsDivider;
      }
    }
    this.inversedYAxisTitleText(elXaxis);
    this.inversedYAxisBorder(elXaxis);
    return elXaxis;
  }
  inversedYAxisBorder(parent) {
    const w = this.w;
    const graphics = new Graphics(this.ctx);
    const axisBorder = w.config.xaxis.axisBorder;
    if (axisBorder.show) {
      let lineCorrection = 0;
      if (w.config.chart.type === "bar" && w.globals.isXNumeric)
        lineCorrection -= 15;
      const elHorzLine = graphics.drawLine(
        w.globals.padHorizontal + lineCorrection + axisBorder.offsetX,
        this.xAxisoffX,
        w.globals.gridWidth,
        this.xAxisoffX,
        axisBorder.color,
        0,
        axisBorder.height
      );
      if (this.elgrid && this.elgrid.elGridBorders && w.config.grid.show) {
        this.elgrid.elGridBorders.add(elHorzLine);
      } else {
        parent.add(elHorzLine);
      }
    }
  }
  inversedYAxisTitleText(parent) {
    const w = this.w;
    const graphics = new Graphics(this.ctx);
    if (w.config.xaxis.title.text !== void 0) {
      const elYaxisTitle = graphics.group({
        class: "apexcharts-xaxis-title apexcharts-yaxis-title-inversed"
      });
      const elYAxisTitleText = graphics.drawText({
        x: w.globals.gridWidth / 2 + w.config.xaxis.title.offsetX,
        y: this.xAxisoffX + parseFloat(this.xaxisFontSize) + parseFloat(w.config.xaxis.title.style.fontSize) + w.config.xaxis.title.offsetY + 20,
        text: w.config.xaxis.title.text,
        textAnchor: "middle",
        fontSize: w.config.xaxis.title.style.fontSize,
        fontFamily: w.config.xaxis.title.style.fontFamily,
        fontWeight: w.config.xaxis.title.style.fontWeight,
        foreColor: w.config.xaxis.title.style.color,
        cssClass: `apexcharts-xaxis-title-text ${w.config.xaxis.title.style.cssClass}`
      });
      elYaxisTitle.add(elYAxisTitleText);
      parent.add(elYaxisTitle);
    }
  }
  yAxisTitleRotate(realIndex, yAxisOpposite) {
    const w = this.w;
    const graphics = new Graphics(this.ctx);
    const elYAxisLabelsWrap = w.globals.dom.baseEl.querySelector(
      `.apexcharts-yaxis[rel='${realIndex}'] .apexcharts-yaxis-texts-g`
    );
    const yAxisLabelsCoord = elYAxisLabelsWrap ? elYAxisLabelsWrap.getBoundingClientRect() : { width: 0, height: 0 };
    const yAxisTitle = w.globals.dom.baseEl.querySelector(
      `.apexcharts-yaxis[rel='${realIndex}'] .apexcharts-yaxis-title text`
    );
    const yAxisTitleCoord = yAxisTitle ? yAxisTitle.getBoundingClientRect() : { width: 0, height: 0 };
    if (yAxisTitle) {
      const x = this.xPaddingForYAxisTitle(
        realIndex,
        yAxisLabelsCoord,
        yAxisTitleCoord,
        yAxisOpposite
      );
      yAxisTitle.setAttribute("x", x.xPos - (yAxisOpposite ? 10 : 0));
      const titleRotatingCenter = graphics.rotateAroundCenter(yAxisTitle);
      yAxisTitle.setAttribute(
        "transform",
        `rotate(${yAxisOpposite ? w.config.yaxis[realIndex].title.rotate * -1 : w.config.yaxis[realIndex].title.rotate} ${titleRotatingCenter.x} ${titleRotatingCenter.y})`
      );
    }
  }
  xPaddingForYAxisTitle(realIndex, yAxisLabelsCoord, yAxisTitleCoord, yAxisOpposite) {
    const w = this.w;
    let x = 0;
    let padd = 10;
    if (w.config.yaxis[realIndex].title.text === void 0 || realIndex < 0) {
      return { xPos: x, padd: 0 };
    }
    if (yAxisOpposite) {
      x = yAxisLabelsCoord.width + w.config.yaxis[realIndex].title.offsetX + yAxisTitleCoord.width / 2 + padd / 2;
    } else {
      x = yAxisLabelsCoord.width * -1 + w.config.yaxis[realIndex].title.offsetX + padd / 2 + yAxisTitleCoord.width / 2;
      if (w.globals.isBarHorizontal) {
        padd = 25;
        x = yAxisLabelsCoord.width * -1 - w.config.yaxis[realIndex].title.offsetX - padd;
      }
    }
    return { xPos: x, padd };
  }
  setYAxisXPosition(yaxisLabelCoords, yTitleCoords) {
    const w = this.w;
    let xLeft = 0;
    let xRight = 0;
    let leftOffsetX = 18;
    let rightOffsetX = 1;
    if (w.config.yaxis.length > 1) this.multipleYs = true;
    w.config.yaxis.forEach((yaxe, index2) => {
      const shouldNotDrawAxis = w.globals.ignoreYAxisIndexes.includes(index2) || !yaxe.show || yaxe.floating || yaxisLabelCoords[index2].width === 0;
      const axisWidth = yaxisLabelCoords[index2].width + yTitleCoords[index2].width;
      if (!yaxe.opposite) {
        xLeft = w.globals.translateX - leftOffsetX;
        if (!shouldNotDrawAxis) leftOffsetX += axisWidth + 20;
        w.globals.translateYAxisX[index2] = xLeft + yaxe.labels.offsetX;
      } else {
        if (w.globals.isBarHorizontal) {
          xRight = w.globals.gridWidth + w.globals.translateX - 1;
          w.globals.translateYAxisX[index2] = xRight - yaxe.labels.offsetX;
        } else {
          xRight = w.globals.gridWidth + w.globals.translateX + rightOffsetX;
          if (!shouldNotDrawAxis) rightOffsetX += axisWidth + 20;
          w.globals.translateYAxisX[index2] = xRight - yaxe.labels.offsetX + 20;
        }
      }
    });
  }
  setYAxisTextAlignments() {
    const w = this.w;
    const yaxis = Utils$1.listToArray(
      w.globals.dom.baseEl.getElementsByClassName("apexcharts-yaxis")
    );
    yaxis.forEach((y, index2) => {
      const yaxe = w.config.yaxis[index2];
      if (yaxe && !yaxe.floating && yaxe.labels.align !== void 0) {
        const yAxisInner = w.globals.dom.baseEl.querySelector(
          `.apexcharts-yaxis[rel='${index2}'] .apexcharts-yaxis-texts-g`
        );
        const yAxisTexts = Utils$1.listToArray(
          w.globals.dom.baseEl.querySelectorAll(
            `.apexcharts-yaxis[rel='${index2}'] .apexcharts-yaxis-label`
          )
        );
        const rect = yAxisInner.getBoundingClientRect();
        yAxisTexts.forEach((label) => {
          label.setAttribute("text-anchor", yaxe.labels.align);
        });
        if (yaxe.labels.align === "left" && !yaxe.opposite) {
          yAxisInner.setAttribute("transform", `translate(-${rect.width}, 0)`);
        } else if (yaxe.labels.align === "center") {
          yAxisInner.setAttribute(
            "transform",
            `translate(${rect.width / 2 * (!yaxe.opposite ? -1 : 1)}, 0)`
          );
        } else if (yaxe.labels.align === "right" && yaxe.opposite) {
          yAxisInner.setAttribute("transform", `translate(${rect.width}, 0)`);
        }
      }
    });
  }
}
class Events {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
    this.documentEvent = Utils$1.bind(this.documentEvent, this);
  }
  addEventListener(name2, handler) {
    const w = this.w;
    if (Object.prototype.hasOwnProperty.call(w.globals.events, name2)) {
      w.globals.events[name2].push(handler);
    } else {
      w.globals.events[name2] = [handler];
    }
  }
  removeEventListener(name2, handler) {
    const w = this.w;
    if (!Object.prototype.hasOwnProperty.call(w.globals.events, name2)) {
      return;
    }
    let index2 = w.globals.events[name2].indexOf(handler);
    if (index2 !== -1) {
      w.globals.events[name2].splice(index2, 1);
    }
  }
  fireEvent(name2, args) {
    const w = this.w;
    if (!Object.prototype.hasOwnProperty.call(w.globals.events, name2)) {
      return;
    }
    if (!args || !args.length) {
      args = [];
    }
    let evs = w.globals.events[name2];
    let l = evs.length;
    for (let i = 0; i < l; i++) {
      evs[i].apply(null, args);
    }
  }
  setupEventHandlers() {
    const w = this.w;
    const me = this.ctx;
    let clickableArea = w.globals.dom.baseEl.querySelector(w.globals.chartClass);
    this.ctx.eventList.forEach((event) => {
      clickableArea.addEventListener(
        event,
        (e) => {
          let capturedSeriesIndex = e.target.getAttribute("i") === null && w.globals.capturedSeriesIndex !== -1 ? w.globals.capturedSeriesIndex : e.target.getAttribute("i");
          let capturedDataPointIndex = e.target.getAttribute("j") === null && w.globals.capturedDataPointIndex !== -1 ? w.globals.capturedDataPointIndex : e.target.getAttribute("j");
          const opts = Object.assign({}, w, {
            seriesIndex: w.globals.axisCharts ? capturedSeriesIndex : 0,
            dataPointIndex: capturedDataPointIndex
          });
          if (e.type === "keydown") {
            if (w.config.chart.accessibility.enabled && w.config.chart.accessibility.keyboard.enabled) {
              if (typeof w.config.chart.events.keyDown === "function") {
                w.config.chart.events.keyDown(e, me, opts);
              }
              me.ctx.events.fireEvent("keydown", [e, me, opts]);
            }
          } else if (e.type === "keyup") {
            if (w.config.chart.accessibility.enabled && w.config.chart.accessibility.keyboard.enabled) {
              if (typeof w.config.chart.events.keyUp === "function") {
                w.config.chart.events.keyUp(e, me, opts);
              }
              me.ctx.events.fireEvent("keyup", [e, me, opts]);
            }
          } else if (e.type === "mousemove" || e.type === "touchmove") {
            if (typeof w.config.chart.events.mouseMove === "function") {
              w.config.chart.events.mouseMove(e, me, opts);
            }
          } else if (e.type === "mouseleave" || e.type === "touchleave") {
            if (typeof w.config.chart.events.mouseLeave === "function") {
              w.config.chart.events.mouseLeave(e, me, opts);
            }
          } else if (e.type === "mouseup" && e.which === 1 || e.type === "touchend") {
            if (typeof w.config.chart.events.click === "function") {
              w.config.chart.events.click(e, me, opts);
            }
            me.ctx.events.fireEvent("click", [e, me, opts]);
          }
        },
        { capture: false, passive: true }
      );
    });
    this.ctx.eventList.forEach((event) => {
      w.globals.dom.baseEl.addEventListener(event, this.documentEvent, {
        passive: true
      });
    });
    this.ctx.core.setupBrushHandler();
  }
  documentEvent(e) {
    const w = this.w;
    const target = e.target.className;
    if (e.type === "click") {
      let elMenu = w.globals.dom.baseEl.querySelector(".apexcharts-menu");
      if (elMenu && elMenu.classList.contains("apexcharts-menu-open") && target !== "apexcharts-menu-icon") {
        elMenu.classList.remove("apexcharts-menu-open");
      }
    }
    w.globals.clientX = e.type === "touchmove" ? e.touches[0].clientX : e.clientX;
    w.globals.clientY = e.type === "touchmove" ? e.touches[0].clientY : e.clientY;
  }
}
class Localization {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
  }
  setCurrentLocaleValues(localeName) {
    let locales2 = this.w.config.chart.locales;
    if (window.Apex.chart && window.Apex.chart.locales && window.Apex.chart.locales.length > 0) {
      locales2 = this.w.config.chart.locales.concat(window.Apex.chart.locales);
    }
    const selectedLocale = locales2.filter((c) => c.name === localeName)[0];
    if (selectedLocale) {
      let ret = Utils$1.extend(en, selectedLocale);
      this.w.globals.locale = ret.options;
    } else {
      throw new Error(
        "Wrong locale name provided. Please make sure you set the correct locale name in options"
      );
    }
  }
}
class Axes {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
  }
  drawAxis(type, elgrid) {
    let gl = this.w.globals;
    let cnf = this.w.config;
    let xAxis = new XAxis(this.ctx, elgrid);
    let yAxis = new YAxis(this.ctx, elgrid);
    if (gl.axisCharts && type !== "radar") {
      let elXaxis, elYaxis;
      if (gl.isBarHorizontal) {
        elYaxis = yAxis.drawYaxisInversed(0);
        elXaxis = xAxis.drawXaxisInversed(0);
        gl.dom.elGraphical.add(elXaxis);
        gl.dom.elGraphical.add(elYaxis);
      } else {
        elXaxis = xAxis.drawXaxis();
        gl.dom.elGraphical.add(elXaxis);
        cnf.yaxis.map((yaxe, index2) => {
          if (gl.ignoreYAxisIndexes.indexOf(index2) === -1) {
            elYaxis = yAxis.drawYaxis(index2);
            gl.dom.Paper.add(elYaxis);
            if (this.w.config.grid.position === "back") {
              const inner = gl.dom.Paper.children()[1];
              inner.remove();
              gl.dom.Paper.add(inner);
            }
          }
        });
      }
    }
  }
}
class Crosshairs {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
  }
  drawXCrosshairs() {
    const w = this.w;
    let graphics = new Graphics(this.ctx);
    let filters = new Filters(this.ctx);
    let crosshairGradient = w.config.xaxis.crosshairs.fill.gradient;
    let crosshairShadow = w.config.xaxis.crosshairs.dropShadow;
    let fillType = w.config.xaxis.crosshairs.fill.type;
    let gradientFrom = crosshairGradient.colorFrom;
    let gradientTo = crosshairGradient.colorTo;
    let opacityFrom = crosshairGradient.opacityFrom;
    let opacityTo = crosshairGradient.opacityTo;
    let stops = crosshairGradient.stops;
    let shadow = "none";
    let dropShadow = crosshairShadow.enabled;
    let shadowLeft = crosshairShadow.left;
    let shadowTop = crosshairShadow.top;
    let shadowBlur = crosshairShadow.blur;
    let shadowColor = crosshairShadow.color;
    let shadowOpacity = crosshairShadow.opacity;
    let xcrosshairsFill = w.config.xaxis.crosshairs.fill.color;
    if (w.config.xaxis.crosshairs.show) {
      if (fillType === "gradient") {
        xcrosshairsFill = graphics.drawGradient(
          "vertical",
          gradientFrom,
          gradientTo,
          opacityFrom,
          opacityTo,
          null,
          stops,
          null
        );
      }
      let xcrosshairs = graphics.drawRect();
      if (w.config.xaxis.crosshairs.width === 1) {
        xcrosshairs = graphics.drawLine();
      }
      let gridHeight = w.globals.gridHeight;
      if (!Utils$1.isNumber(gridHeight) || gridHeight < 0) {
        gridHeight = 0;
      }
      let crosshairsWidth = w.config.xaxis.crosshairs.width;
      if (!Utils$1.isNumber(crosshairsWidth) || crosshairsWidth < 0) {
        crosshairsWidth = 0;
      }
      xcrosshairs.attr({
        class: "apexcharts-xcrosshairs",
        x: 0,
        y: 0,
        y2: gridHeight,
        width: crosshairsWidth,
        height: gridHeight,
        fill: xcrosshairsFill,
        filter: shadow,
        "fill-opacity": w.config.xaxis.crosshairs.opacity,
        stroke: w.config.xaxis.crosshairs.stroke.color,
        "stroke-width": w.config.xaxis.crosshairs.stroke.width,
        "stroke-dasharray": w.config.xaxis.crosshairs.stroke.dashArray
      });
      if (dropShadow) {
        xcrosshairs = filters.dropShadow(xcrosshairs, {
          left: shadowLeft,
          top: shadowTop,
          blur: shadowBlur,
          color: shadowColor,
          opacity: shadowOpacity
        });
      }
      w.globals.dom.elGraphical.add(xcrosshairs);
    }
  }
  drawYCrosshairs() {
    const w = this.w;
    let graphics = new Graphics(this.ctx);
    let crosshair = w.config.yaxis[0].crosshairs;
    const offX = w.globals.barPadForNumericAxis;
    if (w.config.yaxis[0].crosshairs.show) {
      let ycrosshairs = graphics.drawLine(
        -offX,
        0,
        w.globals.gridWidth + offX,
        0,
        crosshair.stroke.color,
        crosshair.stroke.dashArray,
        crosshair.stroke.width
      );
      ycrosshairs.attr({
        class: "apexcharts-ycrosshairs"
      });
      w.globals.dom.elGraphical.add(ycrosshairs);
    }
    let ycrosshairsHidden = graphics.drawLine(
      -offX,
      0,
      w.globals.gridWidth + offX,
      0,
      crosshair.stroke.color,
      0,
      0
    );
    ycrosshairsHidden.attr({
      class: "apexcharts-ycrosshairs-hidden"
    });
    w.globals.dom.elGraphical.add(ycrosshairsHidden);
  }
}
class Responsive {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
  }
  // the opts parameter if not null has to be set overriding everything
  // as the opts is set by user externally
  checkResponsiveConfig(opts) {
    const w = this.w;
    const cnf = w.config;
    if (cnf.responsive.length === 0) return;
    let res = cnf.responsive.slice();
    res.sort(
      (a, b) => a.breakpoint > b.breakpoint ? 1 : b.breakpoint > a.breakpoint ? -1 : 0
    ).reverse();
    let config = new Config({});
    const iterateResponsiveOptions = (newOptions = {}) => {
      let largestBreakpoint = res[0].breakpoint;
      const width = window.innerWidth > 0 ? window.innerWidth : screen.width;
      if (width > largestBreakpoint) {
        let initialConfig = Utils$1.clone(w.globals.initialConfig);
        initialConfig.series = Utils$1.clone(w.config.series);
        let options2 = CoreUtils.extendArrayProps(
          config,
          initialConfig,
          w
        );
        newOptions = Utils$1.extend(options2, newOptions);
        newOptions = Utils$1.extend(w.config, newOptions);
        this.overrideResponsiveOptions(newOptions);
      } else {
        for (let i = 0; i < res.length; i++) {
          if (width < res[i].breakpoint) {
            newOptions = CoreUtils.extendArrayProps(config, res[i].options, w);
            newOptions = Utils$1.extend(w.config, newOptions);
            this.overrideResponsiveOptions(newOptions);
          }
        }
      }
    };
    if (opts) {
      let options2 = CoreUtils.extendArrayProps(config, opts, w);
      options2 = Utils$1.extend(w.config, options2);
      options2 = Utils$1.extend(options2, opts);
      iterateResponsiveOptions(options2);
    } else {
      iterateResponsiveOptions({});
    }
  }
  overrideResponsiveOptions(newOptions) {
    let newConfig = new Config(newOptions).init({ responsiveOverride: true });
    this.w.config = newConfig;
  }
}
class Theme {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
    this.colors = [];
    this.isColorFn = false;
    this.isHeatmapDistributed = this.checkHeatmapDistributed();
    this.isBarDistributed = this.checkBarDistributed();
  }
  checkHeatmapDistributed() {
    const { chart, plotOptions } = this.w.config;
    return chart.type === "treemap" && plotOptions.treemap && plotOptions.treemap.distributed || chart.type === "heatmap" && plotOptions.heatmap && plotOptions.heatmap.distributed;
  }
  checkBarDistributed() {
    const { chart, plotOptions } = this.w.config;
    return plotOptions.bar && plotOptions.bar.distributed && (chart.type === "bar" || chart.type === "rangeBar");
  }
  init() {
    this.setDefaultColors();
  }
  setDefaultColors() {
    const w = this.w;
    const utils = new Utils$1();
    w.globals.dom.elWrap.classList.add(
      `apexcharts-theme-${w.config.theme.mode || "light"}`
    );
    const configColors = [...w.config.colors || w.config.fill.colors || []];
    w.globals.colors = this.getColors(configColors);
    this.applySeriesColors(w.globals.seriesColors, w.globals.colors);
    if (w.config.theme.monochrome.enabled) {
      w.globals.colors = this.getMonochromeColors(
        w.config.theme.monochrome,
        w.globals.series,
        utils
      );
    }
    const defaultColors = w.globals.colors.slice();
    this.pushExtraColors(w.globals.colors);
    this.applyColorTypes(["fill", "stroke"], defaultColors);
    this.applyDataLabelsColors(defaultColors);
    this.applyRadarPolygonsColors();
    this.applyMarkersColors(defaultColors);
  }
  getColors(configColors) {
    const w = this.w;
    if (!configColors || configColors.length === 0) {
      return this.predefined();
    }
    if (Array.isArray(configColors) && configColors.length > 0 && typeof configColors[0] === "function") {
      this.isColorFn = true;
      return w.config.series.map((s, i) => {
        let c = configColors[i] || configColors[0];
        return typeof c === "function" ? c({
          value: w.globals.axisCharts ? w.globals.series[i][0] || 0 : w.globals.series[i],
          seriesIndex: i,
          dataPointIndex: i,
          w: this.w
        }) : c;
      });
    }
    return configColors;
  }
  applySeriesColors(seriesColors, globalsColors) {
    seriesColors.forEach((c, i) => {
      if (c) {
        globalsColors[i] = c;
      }
    });
  }
  getMonochromeColors(monochrome, series, utils) {
    const { color, shadeIntensity, shadeTo } = monochrome;
    const glsCnt = this.isBarDistributed || this.isHeatmapDistributed ? series[0].length * series.length : series.length;
    const part = 1 / (glsCnt / shadeIntensity);
    let percent = 0;
    return Array.from({ length: glsCnt }, () => {
      const newColor = shadeTo === "dark" ? utils.shadeColor(percent * -1, color) : utils.shadeColor(percent, color);
      percent += part;
      return newColor;
    });
  }
  applyColorTypes(colorTypes, defaultColors) {
    const w = this.w;
    colorTypes.forEach((c) => {
      w.globals[c].colors = w.config[c].colors === void 0 ? this.isColorFn ? w.config.colors : defaultColors : w.config[c].colors.slice();
      this.pushExtraColors(w.globals[c].colors);
    });
  }
  applyDataLabelsColors(defaultColors) {
    const w = this.w;
    w.globals.dataLabels.style.colors = w.config.dataLabels.style.colors === void 0 ? defaultColors : w.config.dataLabels.style.colors.slice();
    this.pushExtraColors(w.globals.dataLabels.style.colors, 50);
  }
  applyRadarPolygonsColors() {
    const w = this.w;
    w.globals.radarPolygons.fill.colors = w.config.plotOptions.radar.polygons.fill.colors === void 0 ? [w.config.theme.mode === "dark" ? "#343A3F" : "none"] : w.config.plotOptions.radar.polygons.fill.colors.slice();
    this.pushExtraColors(w.globals.radarPolygons.fill.colors, 20);
  }
  applyMarkersColors(defaultColors) {
    const w = this.w;
    w.globals.markers.colors = w.config.markers.colors === void 0 ? defaultColors : w.config.markers.colors.slice();
    this.pushExtraColors(w.globals.markers.colors);
  }
  pushExtraColors(colorSeries, length, distributed = null) {
    const w = this.w;
    let len = length || w.globals.series.length;
    if (distributed === null) {
      distributed = this.isBarDistributed || this.isHeatmapDistributed || w.config.chart.type === "heatmap" && w.config.plotOptions.heatmap && w.config.plotOptions.heatmap.colorScale.inverse;
    }
    if (distributed && w.globals.series.length) {
      len = w.globals.series[w.globals.maxValsInArrayIndex].length * w.globals.series.length;
    }
    if (colorSeries.length < len) {
      let diff2 = len - colorSeries.length;
      for (let i = 0; i < diff2; i++) {
        colorSeries.push(colorSeries[i]);
      }
    }
  }
  updateThemeOptions(options2) {
    options2.chart = options2.chart || {};
    options2.tooltip = options2.tooltip || {};
    const mode = options2.theme.mode;
    const palette = mode === "dark" ? "palette4" : mode === "light" ? "palette1" : options2.theme.palette || "palette1";
    const foreColor = mode === "dark" ? "#f6f7f8" : mode === "light" ? "#373d3f" : options2.chart.foreColor || "#373d3f";
    options2.tooltip.theme = mode || "light";
    options2.chart.foreColor = foreColor;
    options2.theme.palette = palette;
    return options2;
  }
  predefined() {
    const palette = this.w.config.theme.palette;
    const palettes = this.ctx.constructor.getThemePalettes();
    return palettes[palette] || palettes.palette1;
  }
}
class TitleSubtitle {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
  }
  draw() {
    this.drawTitleSubtitle("title");
    this.drawTitleSubtitle("subtitle");
  }
  drawTitleSubtitle(type) {
    let w = this.w;
    const tsConfig = type === "title" ? w.config.title : w.config.subtitle;
    let x = w.globals.svgWidth / 2;
    let y = tsConfig.offsetY;
    let textAnchor = "middle";
    if (tsConfig.align === "left") {
      x = 10;
      textAnchor = "start";
    } else if (tsConfig.align === "right") {
      x = w.globals.svgWidth - 10;
      textAnchor = "end";
    }
    x = x + tsConfig.offsetX;
    y = y + parseInt(tsConfig.style.fontSize, 10) + tsConfig.margin / 2;
    if (tsConfig.text !== void 0) {
      let graphics = new Graphics(this.ctx);
      let titleText = graphics.drawText({
        x,
        y,
        text: tsConfig.text,
        textAnchor,
        fontSize: tsConfig.style.fontSize,
        fontFamily: tsConfig.style.fontFamily,
        fontWeight: tsConfig.style.fontWeight,
        foreColor: tsConfig.style.color,
        opacity: 1
      });
      titleText.node.setAttribute("class", `apexcharts-${type}-text`);
      w.globals.dom.Paper.add(titleText);
    }
  }
}
let Helpers$3 = class Helpers2 {
  constructor(dCtx) {
    this.w = dCtx.w;
    this.dCtx = dCtx;
  }
  /**
   * Get Chart Title/Subtitle Dimensions
   * @memberof Dimensions
   * @return {{width, height}}
   **/
  getTitleSubtitleCoords(type) {
    let w = this.w;
    let width = 0;
    let height = 0;
    const floating = type === "title" ? w.config.title.floating : w.config.subtitle.floating;
    let el = w.globals.dom.baseEl.querySelector(`.apexcharts-${type}-text`);
    if (el !== null && !floating) {
      let coord = el.getBoundingClientRect();
      width = coord.width;
      height = w.globals.axisCharts ? coord.height + 5 : coord.height;
    }
    return {
      width,
      height
    };
  }
  getLegendsRect() {
    let w = this.w;
    let elLegendWrap = w.globals.dom.elLegendWrap;
    if (!w.config.legend.height && (w.config.legend.position === "top" || w.config.legend.position === "bottom")) {
      elLegendWrap.style.maxHeight = w.globals.svgHeight / 2 + "px";
    }
    let lgRect = Object.assign({}, Utils$1.getBoundingClientRect(elLegendWrap));
    if (elLegendWrap !== null && !w.config.legend.floating && w.config.legend.show) {
      this.dCtx.lgRect = {
        x: lgRect.x,
        y: lgRect.y,
        height: lgRect.height,
        width: lgRect.height === 0 ? 0 : lgRect.width
      };
    } else {
      this.dCtx.lgRect = {
        x: 0,
        y: 0,
        height: 0,
        width: 0
      };
    }
    if (w.config.legend.position === "left" || w.config.legend.position === "right") {
      if (this.dCtx.lgRect.width * 1.5 > w.globals.svgWidth) {
        this.dCtx.lgRect.width = w.globals.svgWidth / 1.5;
      }
    }
    return this.dCtx.lgRect;
  }
  /**
   * Get Y Axis Dimensions
   * @memberof Dimensions
   * @return {{width, height}}
   **/
  getDatalabelsRect() {
    let w = this.w;
    let allLabels = [];
    w.config.series.forEach((serie, seriesIndex) => {
      serie.data.forEach((datum, dataPointIndex) => {
        const getText = (v) => {
          return w.config.dataLabels.formatter(v, {
            ctx: this.dCtx.ctx,
            seriesIndex,
            dataPointIndex,
            w
          });
        };
        const labelText = getText(w.globals.series[seriesIndex][dataPointIndex]);
        allLabels.push(labelText);
      });
    });
    let val = Utils$1.getLargestStringFromArr(allLabels);
    let graphics = new Graphics(this.dCtx.ctx);
    const dataLabelsStyle = w.config.dataLabels.style;
    let labelrect = graphics.getTextRects(
      val,
      parseInt(dataLabelsStyle.fontSize),
      dataLabelsStyle.fontFamily
    );
    return {
      width: labelrect.width * 1.05,
      height: labelrect.height
    };
  }
  getLargestStringFromMultiArr(val, arr) {
    const w = this.w;
    let valArr = val;
    if (w.globals.isMultiLineX) {
      let maxArrs = arr.map((xl) => {
        return Array.isArray(xl) ? xl.length : 1;
      });
      let maxArrLen = Math.max(...maxArrs);
      let maxArrIndex = maxArrs.indexOf(maxArrLen);
      valArr = arr[maxArrIndex];
    }
    return valArr;
  }
};
class DimXAxis {
  constructor(dCtx) {
    this.w = dCtx.w;
    this.dCtx = dCtx;
  }
  /**
   * Get X Axis Dimensions
   * @memberof Dimensions
   * @return {{width, height}}
   **/
  getxAxisLabelsCoords() {
    let w = this.w;
    let xaxisLabels = w.globals.labels.slice();
    if (w.config.xaxis.convertedCatToNumeric && xaxisLabels.length === 0) {
      xaxisLabels = w.globals.categoryLabels;
    }
    let rect;
    if (w.globals.timescaleLabels.length > 0) {
      const coords = this.getxAxisTimeScaleLabelsCoords();
      rect = {
        width: coords.width,
        height: coords.height
      };
      w.globals.rotateXLabels = false;
    } else {
      this.dCtx.lgWidthForSideLegends = (w.config.legend.position === "left" || w.config.legend.position === "right") && !w.config.legend.floating ? this.dCtx.lgRect.width : 0;
      let xlbFormatter = w.globals.xLabelFormatter;
      let val = Utils$1.getLargestStringFromArr(xaxisLabels);
      let valArr = this.dCtx.dimHelpers.getLargestStringFromMultiArr(
        val,
        xaxisLabels
      );
      if (w.globals.isBarHorizontal) {
        val = w.globals.yAxisScale[0].result.reduce(
          (a, b) => a.length > b.length ? a : b,
          0
        );
        valArr = val;
      }
      let xFormat = new Formatters(this.dCtx.ctx);
      let timestamp = val;
      val = xFormat.xLabelFormat(xlbFormatter, val, timestamp, {
        i: void 0,
        dateFormatter: new DateTime(this.dCtx.ctx).formatDate,
        w
      });
      valArr = xFormat.xLabelFormat(xlbFormatter, valArr, timestamp, {
        i: void 0,
        dateFormatter: new DateTime(this.dCtx.ctx).formatDate,
        w
      });
      if (w.config.xaxis.convertedCatToNumeric && typeof val === "undefined" || String(val).trim() === "") {
        val = "1";
        valArr = val;
      }
      let graphics = new Graphics(this.dCtx.ctx);
      let xLabelrect = graphics.getTextRects(
        val,
        w.config.xaxis.labels.style.fontSize
      );
      let xArrLabelrect = xLabelrect;
      if (val !== valArr) {
        xArrLabelrect = graphics.getTextRects(
          valArr,
          w.config.xaxis.labels.style.fontSize
        );
      }
      rect = {
        width: xLabelrect.width >= xArrLabelrect.width ? xLabelrect.width : xArrLabelrect.width,
        height: xLabelrect.height >= xArrLabelrect.height ? xLabelrect.height : xArrLabelrect.height
      };
      if (rect.width * xaxisLabels.length > w.globals.svgWidth - this.dCtx.lgWidthForSideLegends - this.dCtx.yAxisWidth - this.dCtx.gridPad.left - this.dCtx.gridPad.right && w.config.xaxis.labels.rotate !== 0 || w.config.xaxis.labels.rotateAlways) {
        if (!w.globals.isBarHorizontal) {
          w.globals.rotateXLabels = true;
          const getRotatedTextRects = (text) => {
            return graphics.getTextRects(
              text,
              w.config.xaxis.labels.style.fontSize,
              w.config.xaxis.labels.style.fontFamily,
              `rotate(${w.config.xaxis.labels.rotate} 0 0)`,
              false
            );
          };
          xLabelrect = getRotatedTextRects(val);
          if (val !== valArr) {
            xArrLabelrect = getRotatedTextRects(valArr);
          }
          rect.height = (xLabelrect.height > xArrLabelrect.height ? xLabelrect.height : xArrLabelrect.height) / 1.5;
          rect.width = xLabelrect.width > xArrLabelrect.width ? xLabelrect.width : xArrLabelrect.width;
        }
      } else {
        w.globals.rotateXLabels = false;
      }
    }
    if (!w.config.xaxis.labels.show) {
      rect = {
        width: 0,
        height: 0
      };
    }
    return {
      width: rect.width,
      height: rect.height
    };
  }
  /**
   * Get X Axis Label Group height
   * @memberof Dimensions
   * @return {{width, height}}
   */
  getxAxisGroupLabelsCoords() {
    var _a;
    let w = this.w;
    if (!w.globals.hasXaxisGroups) {
      return { width: 0, height: 0 };
    }
    const fontSize = ((_a = w.config.xaxis.group.style) == null ? void 0 : _a.fontSize) || w.config.xaxis.labels.style.fontSize;
    let xaxisLabels = w.globals.groups.map((g) => g.title);
    let rect;
    let val = Utils$1.getLargestStringFromArr(xaxisLabels);
    let valArr = this.dCtx.dimHelpers.getLargestStringFromMultiArr(
      val,
      xaxisLabels
    );
    let graphics = new Graphics(this.dCtx.ctx);
    let xLabelrect = graphics.getTextRects(val, fontSize);
    let xArrLabelrect = xLabelrect;
    if (val !== valArr) {
      xArrLabelrect = graphics.getTextRects(valArr, fontSize);
    }
    rect = {
      width: xLabelrect.width >= xArrLabelrect.width ? xLabelrect.width : xArrLabelrect.width,
      height: xLabelrect.height >= xArrLabelrect.height ? xLabelrect.height : xArrLabelrect.height
    };
    if (!w.config.xaxis.labels.show) {
      rect = {
        width: 0,
        height: 0
      };
    }
    return {
      width: rect.width,
      height: rect.height
    };
  }
  /**
   * Get X Axis Title Dimensions
   * @memberof Dimensions
   * @return {{width, height}}
   **/
  getxAxisTitleCoords() {
    let w = this.w;
    let width = 0;
    let height = 0;
    if (w.config.xaxis.title.text !== void 0) {
      let graphics = new Graphics(this.dCtx.ctx);
      let rect = graphics.getTextRects(
        w.config.xaxis.title.text,
        w.config.xaxis.title.style.fontSize
      );
      width = rect.width;
      height = rect.height;
    }
    return {
      width,
      height
    };
  }
  getxAxisTimeScaleLabelsCoords() {
    let w = this.w;
    let rect;
    this.dCtx.timescaleLabels = w.globals.timescaleLabels.slice();
    let labels = this.dCtx.timescaleLabels.map((label) => label.value);
    let val = labels.reduce((a, b) => {
      if (typeof a === "undefined") {
        console.error(
          "You have possibly supplied invalid Date format. Please supply a valid JavaScript Date"
        );
        return 0;
      } else {
        return a.length > b.length ? a : b;
      }
    }, 0);
    let graphics = new Graphics(this.dCtx.ctx);
    rect = graphics.getTextRects(val, w.config.xaxis.labels.style.fontSize);
    let totalWidthRotated = rect.width * 1.05 * labels.length;
    if (totalWidthRotated > w.globals.gridWidth && w.config.xaxis.labels.rotate !== 0) {
      w.globals.overlappingXLabels = true;
    }
    return rect;
  }
  // In certain cases, the last labels gets cropped in xaxis.
  // Hence, we add some additional padding based on the label length to avoid the last label being cropped or we don't draw it at all
  additionalPaddingXLabels(xaxisLabelCoords) {
    const w = this.w;
    const gl = w.globals;
    const cnf = w.config;
    const xtype = cnf.xaxis.type;
    let lbWidth = xaxisLabelCoords.width;
    gl.skipLastTimelinelabel = false;
    gl.skipFirstTimelinelabel = false;
    const isBarOpposite = w.config.yaxis[0].opposite && w.globals.isBarHorizontal;
    const isCollapsed = (i) => gl.collapsedSeriesIndices.indexOf(i) !== -1;
    const rightPad = (yaxe) => {
      if (this.dCtx.timescaleLabels && this.dCtx.timescaleLabels.length) {
        const firstimescaleLabel = this.dCtx.timescaleLabels[0];
        const lastTimescaleLabel = this.dCtx.timescaleLabels[this.dCtx.timescaleLabels.length - 1];
        const lastLabelPosition = lastTimescaleLabel.position + lbWidth / 1.75 - this.dCtx.yAxisWidthRight;
        const firstLabelPosition = firstimescaleLabel.position - lbWidth / 1.75 + this.dCtx.yAxisWidthLeft;
        let lgRightRectWidth = w.config.legend.position === "right" && this.dCtx.lgRect.width > 0 ? this.dCtx.lgRect.width : 0;
        if (lastLabelPosition > gl.svgWidth - gl.translateX - lgRightRectWidth) {
          gl.skipLastTimelinelabel = true;
        }
        if (firstLabelPosition < -((!yaxe.show || yaxe.floating) && (cnf.chart.type === "bar" || cnf.chart.type === "candlestick" || cnf.chart.type === "rangeBar" || cnf.chart.type === "boxPlot") ? lbWidth / 1.75 : 10)) {
          gl.skipFirstTimelinelabel = true;
        }
      } else if (xtype === "datetime") {
        if (this.dCtx.gridPad.right < lbWidth && !gl.rotateXLabels) {
          gl.skipLastTimelinelabel = true;
        }
      } else if (xtype !== "datetime") {
        if (this.dCtx.gridPad.right < lbWidth / 2 - this.dCtx.yAxisWidthRight && !gl.rotateXLabels && !w.config.xaxis.labels.trim) {
          this.dCtx.xPadRight = lbWidth / 2 + 1;
        }
      }
    };
    const padYAxe = (yaxe, i) => {
      if (cnf.yaxis.length > 1 && isCollapsed(i)) return;
      rightPad(yaxe);
    };
    cnf.yaxis.forEach((yaxe, i) => {
      if (isBarOpposite) {
        if (this.dCtx.gridPad.left < lbWidth) {
          this.dCtx.xPadLeft = lbWidth / 2 + 1;
        }
        this.dCtx.xPadRight = lbWidth / 2 + 1;
      } else {
        padYAxe(yaxe, i);
      }
    });
  }
}
class DimYAxis {
  constructor(dCtx) {
    this.w = dCtx.w;
    this.dCtx = dCtx;
  }
  /**
   * Get Y Axis Dimensions
   * @memberof Dimensions
   * @return {{width, height}}
   **/
  getyAxisLabelsCoords() {
    let w = this.w;
    let width = 0;
    let height = 0;
    let ret = [];
    let labelPad = 10;
    const axesUtils = new AxesUtils(this.dCtx.ctx);
    w.config.yaxis.map((yaxe, index2) => {
      const formatterArgs = {
        seriesIndex: index2,
        dataPointIndex: -1,
        w
      };
      const yS = w.globals.yAxisScale[index2];
      let yAxisMinWidth = 0;
      if (!axesUtils.isYAxisHidden(index2) && yaxe.labels.show && yaxe.labels.minWidth !== void 0)
        yAxisMinWidth = yaxe.labels.minWidth;
      if (!axesUtils.isYAxisHidden(index2) && yaxe.labels.show && yS.result.length) {
        let lbFormatter = w.globals.yLabelFormatters[index2];
        let minV = yS.niceMin === Number.MIN_VALUE ? 0 : yS.niceMin;
        let val = yS.result.reduce((acc, curr) => {
          var _a, _b;
          return ((_a = String(lbFormatter(acc, formatterArgs))) == null ? void 0 : _a.length) > ((_b = String(lbFormatter(curr, formatterArgs))) == null ? void 0 : _b.length) ? acc : curr;
        }, minV);
        val = lbFormatter(val, formatterArgs);
        let valArr = val;
        if (typeof val === "undefined" || val.length === 0) {
          val = yS.niceMax;
        }
        if (String(val).length === 1) {
          val = val + ".0";
          valArr = val;
        }
        if (w.globals.isBarHorizontal) {
          labelPad = 0;
          let barYaxisLabels = w.globals.labels.slice();
          val = Utils$1.getLargestStringFromArr(barYaxisLabels);
          val = lbFormatter(val, { seriesIndex: index2, dataPointIndex: -1, w });
          valArr = this.dCtx.dimHelpers.getLargestStringFromMultiArr(
            val,
            barYaxisLabels
          );
        }
        let graphics = new Graphics(this.dCtx.ctx);
        let rotateStr = "rotate(".concat(yaxe.labels.rotate, " 0 0)");
        let rect = graphics.getTextRects(
          val,
          yaxe.labels.style.fontSize,
          yaxe.labels.style.fontFamily,
          rotateStr,
          false
        );
        let arrLabelrect = rect;
        if (val !== valArr) {
          arrLabelrect = graphics.getTextRects(
            valArr,
            yaxe.labels.style.fontSize,
            yaxe.labels.style.fontFamily,
            rotateStr,
            false
          );
        }
        ret.push({
          width: (yAxisMinWidth > arrLabelrect.width || yAxisMinWidth > rect.width ? yAxisMinWidth : arrLabelrect.width > rect.width ? arrLabelrect.width : rect.width) + labelPad,
          height: arrLabelrect.height > rect.height ? arrLabelrect.height : rect.height
        });
      } else {
        ret.push({
          width,
          height
        });
      }
    });
    return ret;
  }
  /**
   * Get Y Axis Dimensions
   * @memberof Dimensions
   * @return {{width, height}}
   **/
  getyAxisTitleCoords() {
    let w = this.w;
    let ret = [];
    w.config.yaxis.map((yaxe) => {
      if (yaxe.show && yaxe.title.text !== void 0) {
        let graphics = new Graphics(this.dCtx.ctx);
        let rotateStr = "rotate(".concat(yaxe.title.rotate, " 0 0)");
        let rect = graphics.getTextRects(
          yaxe.title.text,
          yaxe.title.style.fontSize,
          yaxe.title.style.fontFamily,
          rotateStr,
          false
        );
        ret.push({
          width: rect.width,
          height: rect.height
        });
      } else {
        ret.push({
          width: 0,
          height: 0
        });
      }
    });
    return ret;
  }
  getTotalYAxisWidth() {
    let w = this.w;
    let yAxisWidth = 0;
    let yAxisWidthLeft = 0;
    let yAxisWidthRight = 0;
    let padding = w.globals.yAxisScale.length > 1 ? 10 : 0;
    const axesUtils = new AxesUtils(this.dCtx.ctx);
    const isHiddenYAxis = function(index2) {
      return w.globals.ignoreYAxisIndexes.indexOf(index2) > -1;
    };
    const padForLabelTitle = (coord, index2) => {
      let floating = w.config.yaxis[index2].floating;
      let width = 0;
      if (coord.width > 0 && !floating) {
        width = coord.width + padding;
        if (isHiddenYAxis(index2)) {
          width = width - coord.width - padding;
        }
      } else {
        width = floating || axesUtils.isYAxisHidden(index2) ? 0 : 5;
      }
      w.config.yaxis[index2].opposite ? yAxisWidthRight = yAxisWidthRight + width : yAxisWidthLeft = yAxisWidthLeft + width;
      yAxisWidth = yAxisWidth + width;
    };
    w.globals.yLabelsCoords.map((yLabelCoord, index2) => {
      padForLabelTitle(yLabelCoord, index2);
    });
    w.globals.yTitleCoords.map((yTitleCoord, index2) => {
      padForLabelTitle(yTitleCoord, index2);
    });
    if (w.globals.isBarHorizontal && !w.config.yaxis[0].floating) {
      yAxisWidth = w.globals.yLabelsCoords[0].width + w.globals.yTitleCoords[0].width + 15;
    }
    this.dCtx.yAxisWidthLeft = yAxisWidthLeft;
    this.dCtx.yAxisWidthRight = yAxisWidthRight;
    return yAxisWidth;
  }
}
class DimGrid {
  constructor(dCtx) {
    this.w = dCtx.w;
    this.dCtx = dCtx;
  }
  gridPadForColumnsInNumericAxis(gridWidth) {
    const { w } = this;
    const { config: cnf, globals: gl } = w;
    if (gl.noData || gl.collapsedSeries.length + gl.ancillaryCollapsedSeries.length === cnf.series.length) {
      return 0;
    }
    const hasBar = (type2) => ["bar", "rangeBar", "candlestick", "boxPlot"].includes(type2);
    const type = cnf.chart.type;
    let barWidth = 0;
    let seriesLen = hasBar(type) ? cnf.series.length : 1;
    if (gl.comboBarCount > 0) {
      seriesLen = gl.comboBarCount;
    }
    gl.collapsedSeries.forEach((c) => {
      if (hasBar(c.type)) {
        seriesLen -= 1;
      }
    });
    if (cnf.chart.stacked) {
      seriesLen = 1;
    }
    const barsPresent = hasBar(type) || gl.comboBarCount > 0;
    let xRange = Math.abs(gl.initialMaxX - gl.initialMinX);
    if (barsPresent && gl.isXNumeric && !gl.isBarHorizontal && seriesLen > 0 && xRange !== 0) {
      if (xRange <= 3) {
        xRange = gl.dataPoints;
      }
      const xRatio = xRange / gridWidth;
      let xDivision = gl.minXDiff && gl.minXDiff / xRatio > 0 ? gl.minXDiff / xRatio : 0;
      if (xDivision > gridWidth / 2) {
        xDivision /= 2;
      }
      barWidth = xDivision * parseInt(cnf.plotOptions.bar.columnWidth, 10) / 100;
      if (barWidth < 1) {
        barWidth = 1;
      }
      gl.barPadForNumericAxis = barWidth;
    }
    return barWidth;
  }
  gridPadFortitleSubtitle() {
    const { w } = this;
    const { globals: gl } = w;
    let gridShrinkOffset = this.dCtx.isSparkline || !gl.axisCharts ? 0 : 10;
    const titleSubtitle = ["title", "subtitle"];
    titleSubtitle.forEach((t) => {
      if (w.config[t].text !== void 0) {
        gridShrinkOffset += w.config[t].margin;
      } else {
        gridShrinkOffset += this.dCtx.isSparkline || !gl.axisCharts ? 0 : 5;
      }
    });
    if (w.config.legend.show && w.config.legend.position === "bottom" && !w.config.legend.floating && !gl.axisCharts) {
      gridShrinkOffset += 10;
    }
    const titleCoords = this.dCtx.dimHelpers.getTitleSubtitleCoords("title");
    const subtitleCoords = this.dCtx.dimHelpers.getTitleSubtitleCoords("subtitle");
    gl.gridHeight -= titleCoords.height + subtitleCoords.height + gridShrinkOffset;
    gl.translateY += titleCoords.height + subtitleCoords.height + gridShrinkOffset;
  }
  setGridXPosForDualYAxis(yTitleCoords, yaxisLabelCoords) {
    const { w } = this;
    const axesUtils = new AxesUtils(this.dCtx.ctx);
    w.config.yaxis.forEach((yaxe, index2) => {
      if (w.globals.ignoreYAxisIndexes.indexOf(index2) === -1 && !yaxe.floating && !axesUtils.isYAxisHidden(index2)) {
        if (yaxe.opposite) {
          w.globals.translateX -= yaxisLabelCoords[index2].width + yTitleCoords[index2].width + parseInt(yaxe.labels.style.fontSize, 10) / 1.2 + 12;
        }
        if (w.globals.translateX < 2) {
          w.globals.translateX = 2;
        }
      }
    });
  }
}
class Dimensions {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
    this.lgRect = {};
    this.yAxisWidth = 0;
    this.yAxisWidthLeft = 0;
    this.yAxisWidthRight = 0;
    this.xAxisHeight = 0;
    this.isSparkline = this.w.config.chart.sparkline.enabled;
    this.dimHelpers = new Helpers$3(this);
    this.dimYAxis = new DimYAxis(this);
    this.dimXAxis = new DimXAxis(this);
    this.dimGrid = new DimGrid(this);
    this.lgWidthForSideLegends = 0;
    this.gridPad = this.w.config.grid.padding;
    this.xPadRight = 0;
    this.xPadLeft = 0;
  }
  /**
   * @memberof Dimensions
   * @param {object} w - chart context
   **/
  plotCoords() {
    let w = this.w;
    let gl = w.globals;
    this.lgRect = this.dimHelpers.getLegendsRect();
    this.datalabelsCoords = { width: 0, height: 0 };
    const maxStrokeWidth = Array.isArray(w.config.stroke.width) ? Math.max(...w.config.stroke.width) : w.config.stroke.width;
    if (this.isSparkline) {
      if (w.config.markers.discrete.length > 0 || w.config.markers.size > 0) {
        Object.entries(this.gridPad).forEach(([k, v]) => {
          this.gridPad[k] = Math.max(
            v,
            this.w.globals.markers.largestSize / 1.5
          );
        });
      }
      this.gridPad.top = Math.max(maxStrokeWidth / 2, this.gridPad.top);
      this.gridPad.bottom = Math.max(maxStrokeWidth / 2, this.gridPad.bottom);
    }
    if (gl.axisCharts) {
      this.setDimensionsForAxisCharts();
    } else {
      this.setDimensionsForNonAxisCharts();
    }
    this.dimGrid.gridPadFortitleSubtitle();
    gl.gridHeight = gl.gridHeight - this.gridPad.top - this.gridPad.bottom;
    gl.gridWidth = gl.gridWidth - this.gridPad.left - this.gridPad.right - this.xPadRight - this.xPadLeft;
    let barWidth = this.dimGrid.gridPadForColumnsInNumericAxis(gl.gridWidth);
    gl.gridWidth = gl.gridWidth - barWidth * 2;
    gl.translateX = gl.translateX + this.gridPad.left + this.xPadLeft + (barWidth > 0 ? barWidth : 0);
    gl.translateY = gl.translateY + this.gridPad.top;
  }
  setDimensionsForAxisCharts() {
    let w = this.w;
    let gl = w.globals;
    let yaxisLabelCoords = this.dimYAxis.getyAxisLabelsCoords();
    let yTitleCoords = this.dimYAxis.getyAxisTitleCoords();
    if (gl.isSlopeChart) {
      this.datalabelsCoords = this.dimHelpers.getDatalabelsRect();
    }
    w.globals.yLabelsCoords = [];
    w.globals.yTitleCoords = [];
    w.config.yaxis.map((yaxe, index2) => {
      w.globals.yLabelsCoords.push({
        width: yaxisLabelCoords[index2].width,
        index: index2
      });
      w.globals.yTitleCoords.push({
        width: yTitleCoords[index2].width,
        index: index2
      });
    });
    this.yAxisWidth = this.dimYAxis.getTotalYAxisWidth();
    let xaxisLabelCoords = this.dimXAxis.getxAxisLabelsCoords();
    let xaxisGroupLabelCoords = this.dimXAxis.getxAxisGroupLabelsCoords();
    let xtitleCoords = this.dimXAxis.getxAxisTitleCoords();
    this.conditionalChecksForAxisCoords(
      xaxisLabelCoords,
      xtitleCoords,
      xaxisGroupLabelCoords
    );
    gl.translateXAxisY = w.globals.rotateXLabels ? this.xAxisHeight / 8 : -4;
    gl.translateXAxisX = w.globals.rotateXLabels && w.globals.isXNumeric && w.config.xaxis.labels.rotate <= -45 ? -this.xAxisWidth / 4 : 0;
    if (w.globals.isBarHorizontal) {
      gl.rotateXLabels = false;
      gl.translateXAxisY = -1 * (parseInt(w.config.xaxis.labels.style.fontSize, 10) / 1.5);
    }
    gl.translateXAxisY = gl.translateXAxisY + w.config.xaxis.labels.offsetY;
    gl.translateXAxisX = gl.translateXAxisX + w.config.xaxis.labels.offsetX;
    let yAxisWidth = this.yAxisWidth;
    let xAxisHeight = this.xAxisHeight;
    gl.xAxisLabelsHeight = this.xAxisHeight - xtitleCoords.height;
    gl.xAxisGroupLabelsHeight = gl.xAxisLabelsHeight - xaxisLabelCoords.height;
    gl.xAxisLabelsWidth = this.xAxisWidth;
    gl.xAxisHeight = this.xAxisHeight;
    let translateY = 10;
    if (w.config.chart.type === "radar" || this.isSparkline) {
      yAxisWidth = 0;
      xAxisHeight = 0;
    }
    if (this.isSparkline) {
      this.lgRect = {
        height: 0,
        width: 0
      };
    }
    if (this.isSparkline || w.config.chart.type === "treemap") {
      yAxisWidth = 0;
      xAxisHeight = 0;
      translateY = 0;
    }
    if (!this.isSparkline && w.config.chart.type !== "treemap") {
      this.dimXAxis.additionalPaddingXLabels(xaxisLabelCoords);
    }
    const legendTopBottom = () => {
      gl.translateX = yAxisWidth + this.datalabelsCoords.width;
      gl.gridHeight = gl.svgHeight - this.lgRect.height - xAxisHeight - (!this.isSparkline && w.config.chart.type !== "treemap" ? w.globals.rotateXLabels ? 10 : 15 : 0);
      gl.gridWidth = gl.svgWidth - yAxisWidth - this.datalabelsCoords.width * 2;
    };
    if (w.config.xaxis.position === "top")
      translateY = gl.xAxisHeight - w.config.xaxis.axisTicks.height - 5;
    switch (w.config.legend.position) {
      case "bottom":
        gl.translateY = translateY;
        legendTopBottom();
        break;
      case "top":
        gl.translateY = this.lgRect.height + translateY;
        legendTopBottom();
        break;
      case "left":
        gl.translateY = translateY;
        gl.translateX = this.lgRect.width + yAxisWidth + this.datalabelsCoords.width;
        gl.gridHeight = gl.svgHeight - xAxisHeight - 12;
        gl.gridWidth = gl.svgWidth - this.lgRect.width - yAxisWidth - this.datalabelsCoords.width * 2;
        break;
      case "right":
        gl.translateY = translateY;
        gl.translateX = yAxisWidth + this.datalabelsCoords.width;
        gl.gridHeight = gl.svgHeight - xAxisHeight - 12;
        gl.gridWidth = gl.svgWidth - this.lgRect.width - yAxisWidth - this.datalabelsCoords.width * 2 - 5;
        break;
      default:
        throw new Error("Legend position not supported");
    }
    this.dimGrid.setGridXPosForDualYAxis(yTitleCoords, yaxisLabelCoords);
    let objyAxis = new YAxis(this.ctx);
    objyAxis.setYAxisXPosition(yaxisLabelCoords, yTitleCoords);
  }
  setDimensionsForNonAxisCharts() {
    let w = this.w;
    let gl = w.globals;
    let cnf = w.config;
    let xPad = 0;
    if (w.config.legend.show && !w.config.legend.floating) {
      xPad = 20;
    }
    const type = cnf.chart.type === "pie" || cnf.chart.type === "polarArea" || cnf.chart.type === "donut" ? "pie" : "radialBar";
    let offY = cnf.plotOptions[type].offsetY;
    let offX = cnf.plotOptions[type].offsetX;
    if (!cnf.legend.show || cnf.legend.floating) {
      gl.gridHeight = gl.svgHeight;
      const maxWidth = gl.dom.elWrap.getBoundingClientRect().width;
      gl.gridWidth = Math.min(maxWidth, gl.gridHeight);
      gl.translateY = offY;
      gl.translateX = offX + (gl.svgWidth - gl.gridWidth) / 2;
      return;
    }
    switch (cnf.legend.position) {
      case "bottom":
        gl.gridHeight = gl.svgHeight - this.lgRect.height;
        gl.gridWidth = gl.svgWidth;
        gl.translateY = offY - 10;
        gl.translateX = offX + (gl.svgWidth - gl.gridWidth) / 2;
        break;
      case "top":
        gl.gridHeight = gl.svgHeight - this.lgRect.height;
        gl.gridWidth = gl.svgWidth;
        gl.translateY = this.lgRect.height + offY + 10;
        gl.translateX = offX + (gl.svgWidth - gl.gridWidth) / 2;
        break;
      case "left":
        gl.gridWidth = gl.svgWidth - this.lgRect.width - xPad;
        gl.gridHeight = cnf.chart.height !== "auto" ? gl.svgHeight : gl.gridWidth;
        gl.translateY = offY;
        gl.translateX = offX + this.lgRect.width + xPad;
        break;
      case "right":
        gl.gridWidth = gl.svgWidth - this.lgRect.width - xPad - 5;
        gl.gridHeight = cnf.chart.height !== "auto" ? gl.svgHeight : gl.gridWidth;
        gl.translateY = offY;
        gl.translateX = offX + 10;
        break;
      default:
        throw new Error("Legend position not supported");
    }
  }
  conditionalChecksForAxisCoords(xaxisLabelCoords, xtitleCoords, xaxisGroupLabelCoords) {
    const w = this.w;
    const xAxisNum = w.globals.hasXaxisGroups ? 2 : 1;
    const baseXAxisHeight = xaxisGroupLabelCoords.height + xaxisLabelCoords.height + xtitleCoords.height;
    const xAxisHeightMultiplicate = w.globals.isMultiLineX ? 1.2 : w.globals.LINE_HEIGHT_RATIO;
    const rotatedXAxisOffset = w.globals.rotateXLabels ? 22 : 10;
    const rotatedXAxisLegendOffset = w.globals.rotateXLabels && w.config.legend.position === "bottom";
    const additionalOffset = rotatedXAxisLegendOffset ? 10 : 0;
    this.xAxisHeight = baseXAxisHeight * xAxisHeightMultiplicate + xAxisNum * rotatedXAxisOffset + additionalOffset;
    this.xAxisWidth = xaxisLabelCoords.width;
    if (this.xAxisHeight - xtitleCoords.height > w.config.xaxis.labels.maxHeight) {
      this.xAxisHeight = w.config.xaxis.labels.maxHeight;
    }
    if (w.config.xaxis.labels.minHeight && this.xAxisHeight < w.config.xaxis.labels.minHeight) {
      this.xAxisHeight = w.config.xaxis.labels.minHeight;
    }
    if (w.config.xaxis.floating) {
      this.xAxisHeight = 0;
    }
    let minYAxisWidth = 0;
    let maxYAxisWidth = 0;
    w.config.yaxis.forEach((y) => {
      minYAxisWidth += y.labels.minWidth;
      maxYAxisWidth += y.labels.maxWidth;
    });
    if (this.yAxisWidth < minYAxisWidth) {
      this.yAxisWidth = minYAxisWidth;
    }
    if (this.yAxisWidth > maxYAxisWidth) {
      this.yAxisWidth = maxYAxisWidth;
    }
  }
}
let Helpers$2 = class Helpers3 {
  constructor(lgCtx) {
    this.w = lgCtx.w;
    this.lgCtx = lgCtx;
  }
  getLegendStyles() {
    var _a, _b, _c;
    let stylesheet = document.createElement("style");
    stylesheet.setAttribute("type", "text/css");
    const nonce = ((_c = (_b = (_a = this.lgCtx.ctx) == null ? void 0 : _a.opts) == null ? void 0 : _b.chart) == null ? void 0 : _c.nonce) || this.w.config.chart.nonce;
    if (nonce) {
      stylesheet.setAttribute("nonce", nonce);
    }
    const rule = document.createTextNode(apexchartsLegendCSS);
    stylesheet.appendChild(rule);
    return stylesheet;
  }
  getLegendDimensions() {
    const w = this.w;
    let currLegendsWrap = w.globals.dom.baseEl.querySelector(".apexcharts-legend");
    let { width: currLegendsWrapWidth, height: currLegendsWrapHeight } = currLegendsWrap.getBoundingClientRect();
    return {
      clwh: currLegendsWrapHeight,
      clww: currLegendsWrapWidth
    };
  }
  appendToForeignObject() {
    const gl = this.w.globals;
    if (this.w.config.chart.injectStyleSheet !== false) {
      gl.dom.elLegendForeign.appendChild(this.getLegendStyles());
    }
  }
  toggleDataSeries(seriesCnt, isHidden) {
    const w = this.w;
    if (w.globals.axisCharts || w.config.chart.type === "radialBar") {
      w.globals.resized = true;
      let seriesEl = null;
      let realIndex = null;
      w.globals.risingSeries = [];
      if (w.globals.axisCharts) {
        seriesEl = w.globals.dom.baseEl.querySelector(
          `.apexcharts-series[data\\:realIndex='${seriesCnt}']`
        );
        if (!seriesEl) return;
        realIndex = parseInt(seriesEl.getAttribute("data:realIndex"), 10);
      } else {
        seriesEl = w.globals.dom.baseEl.querySelector(
          `.apexcharts-series[rel='${seriesCnt + 1}']`
        );
        if (!seriesEl) return;
        realIndex = parseInt(seriesEl.getAttribute("rel"), 10) - 1;
      }
      if (isHidden) {
        const seriesToMakeVisible = [
          {
            cs: w.globals.collapsedSeries,
            csi: w.globals.collapsedSeriesIndices
          },
          {
            cs: w.globals.ancillaryCollapsedSeries,
            csi: w.globals.ancillaryCollapsedSeriesIndices
          }
        ];
        seriesToMakeVisible.forEach((r) => {
          this.riseCollapsedSeries(r.cs, r.csi, realIndex);
        });
      } else {
        this.hideSeries({ seriesEl, realIndex });
      }
      if (w.config.chart.accessibility.enabled) {
        const legendItem = w.globals.dom.baseEl.querySelector(
          `.apexcharts-legend-series[rel="${seriesCnt + 1}"]`
        );
        if (legendItem) {
          const isCollapsed = w.globals.collapsedSeriesIndices.includes(realIndex) || w.globals.ancillaryCollapsedSeriesIndices.includes(realIndex);
          legendItem.setAttribute(
            "aria-pressed",
            isCollapsed ? "true" : "false"
          );
          const legendTextEl = legendItem.querySelector(
            ".apexcharts-legend-text"
          );
          const seriesName = legendTextEl ? legendTextEl.textContent : w.globals.seriesNames[seriesCnt];
          const statusText = isCollapsed ? "hidden" : "visible";
          legendItem.setAttribute(
            "aria-label",
            `${seriesName}, ${statusText}. Press Enter or Space to toggle.`
          );
        }
      }
    } else {
      let seriesEl = w.globals.dom.Paper.findOne(
        ` .apexcharts-series[rel='${seriesCnt + 1}'] path`
      );
      const type = w.config.chart.type;
      if (type === "pie" || type === "polarArea" || type === "donut") {
        let dataLabels = w.config.plotOptions.pie.donut.labels;
        const graphics = new Graphics(this.lgCtx.ctx);
        graphics.pathMouseDown(seriesEl, null);
        this.lgCtx.ctx.pie.printDataLabelsInner(seriesEl.node, dataLabels);
      }
      if (w.config.chart.accessibility.enabled) {
        const legendItem = w.globals.dom.baseEl.querySelector(
          `.apexcharts-legend-series[rel="${seriesCnt + 1}"]`
        );
        if (legendItem) {
          const isCollapsed = w.globals.collapsedSeriesIndices.includes(seriesCnt);
          legendItem.setAttribute(
            "aria-pressed",
            isCollapsed ? "true" : "false"
          );
          const legendTextEl = legendItem.querySelector(
            ".apexcharts-legend-text"
          );
          const seriesName = legendTextEl ? legendTextEl.textContent : w.globals.seriesNames[seriesCnt];
          const statusText = isCollapsed ? "hidden" : "visible";
          legendItem.setAttribute(
            "aria-label",
            `${seriesName}, ${statusText}. Press Enter or Space to toggle.`
          );
        }
      }
    }
  }
  getSeriesAfterCollapsing({ realIndex }) {
    const w = this.w;
    const gl = w.globals;
    let series = Utils$1.clone(w.config.series);
    if (gl.axisCharts) {
      let yaxis = w.config.yaxis[gl.seriesYAxisReverseMap[realIndex]];
      const collapseData = {
        index: realIndex,
        data: series[realIndex].data.slice(),
        type: series[realIndex].type || w.config.chart.type
      };
      if (yaxis && yaxis.show && yaxis.showAlways) {
        if (gl.ancillaryCollapsedSeriesIndices.indexOf(realIndex) < 0) {
          gl.ancillaryCollapsedSeries.push(collapseData);
          gl.ancillaryCollapsedSeriesIndices.push(realIndex);
        }
      } else {
        if (gl.collapsedSeriesIndices.indexOf(realIndex) < 0) {
          gl.collapsedSeries.push(collapseData);
          gl.collapsedSeriesIndices.push(realIndex);
          let removeIndexOfRising = gl.risingSeries.indexOf(realIndex);
          gl.risingSeries.splice(removeIndexOfRising, 1);
        }
      }
    } else {
      gl.collapsedSeries.push({
        index: realIndex,
        data: series[realIndex]
      });
      gl.collapsedSeriesIndices.push(realIndex);
    }
    gl.allSeriesCollapsed = gl.collapsedSeries.length + gl.ancillaryCollapsedSeries.length === w.config.series.length;
    return this._getSeriesBasedOnCollapsedState(series);
  }
  hideSeries({ seriesEl, realIndex }) {
    const w = this.w;
    let series = this.getSeriesAfterCollapsing({
      realIndex
    });
    let seriesChildren = seriesEl.childNodes;
    for (let sc = 0; sc < seriesChildren.length; sc++) {
      if (seriesChildren[sc].classList.contains("apexcharts-series-markers-wrap")) {
        if (seriesChildren[sc].classList.contains("apexcharts-hide")) {
          seriesChildren[sc].classList.remove("apexcharts-hide");
        } else {
          seriesChildren[sc].classList.add("apexcharts-hide");
        }
      }
    }
    this.lgCtx.ctx.updateHelpers._updateSeries(
      series,
      w.config.chart.animations.dynamicAnimation.enabled
    );
  }
  riseCollapsedSeries(collapsedSeries, seriesIndices, realIndex) {
    const w = this.w;
    let series = Utils$1.clone(w.config.series);
    if (collapsedSeries.length > 0) {
      for (let c = 0; c < collapsedSeries.length; c++) {
        if (collapsedSeries[c].index === realIndex) {
          if (w.globals.axisCharts) {
            series[realIndex].data = collapsedSeries[c].data.slice();
          } else {
            series[realIndex] = collapsedSeries[c].data;
          }
          if (typeof series[realIndex] !== "number") {
            series[realIndex].hidden = false;
          }
          collapsedSeries.splice(c, 1);
          seriesIndices.splice(c, 1);
          w.globals.risingSeries.push(realIndex);
          c--;
        }
      }
      series = this._getSeriesBasedOnCollapsedState(series);
      this.lgCtx.ctx.updateHelpers._updateSeries(
        series,
        w.config.chart.animations.dynamicAnimation.enabled
      );
    }
  }
  _getSeriesBasedOnCollapsedState(series) {
    const w = this.w;
    let collapsed = 0;
    if (w.globals.axisCharts) {
      series.forEach((s, sI) => {
        if (!(w.globals.collapsedSeriesIndices.indexOf(sI) < 0 && w.globals.ancillaryCollapsedSeriesIndices.indexOf(sI) < 0)) {
          series[sI].data = [];
          collapsed++;
        }
      });
    } else {
      series.forEach((s, sI) => {
        if (!(w.globals.collapsedSeriesIndices.indexOf(sI) < 0)) {
          series[sI] = 0;
          collapsed++;
        }
      });
    }
    w.globals.allSeriesCollapsed = collapsed === series.length;
    return series;
  }
};
class Legend {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
    this.onLegendClick = this.onLegendClick.bind(this);
    this.onLegendHovered = this.onLegendHovered.bind(this);
    this.isBarsDistributed = this.w.config.chart.type === "bar" && this.w.config.plotOptions.bar.distributed && this.w.config.series.length === 1;
    this.legendHelpers = new Helpers$2(this);
  }
  init() {
    const w = this.w;
    const gl = w.globals;
    const cnf = w.config;
    const showLegendAlways = cnf.legend.showForSingleSeries && gl.series.length === 1 || this.isBarsDistributed || gl.series.length > 1;
    this.legendHelpers.appendToForeignObject();
    if ((showLegendAlways || !gl.axisCharts) && cnf.legend.show) {
      while (gl.dom.elLegendWrap.firstChild) {
        gl.dom.elLegendWrap.removeChild(gl.dom.elLegendWrap.firstChild);
      }
      this.drawLegends();
      if (cnf.legend.position === "bottom" || cnf.legend.position === "top") {
        this.legendAlignHorizontal();
      } else if (cnf.legend.position === "right" || cnf.legend.position === "left") {
        this.legendAlignVertical();
      }
    }
  }
  createLegendMarker({ i, fillcolor }) {
    const w = this.w;
    const elMarker = document.createElement("span");
    elMarker.classList.add("apexcharts-legend-marker");
    let mShape = w.config.legend.markers.shape || w.config.markers.shape;
    let shape = mShape;
    if (Array.isArray(mShape)) {
      shape = mShape[i];
    }
    let mSize = Array.isArray(w.config.legend.markers.size) ? parseFloat(w.config.legend.markers.size[i]) : parseFloat(w.config.legend.markers.size);
    let mOffsetX = Array.isArray(w.config.legend.markers.offsetX) ? parseFloat(w.config.legend.markers.offsetX[i]) : parseFloat(w.config.legend.markers.offsetX);
    let mOffsetY = Array.isArray(w.config.legend.markers.offsetY) ? parseFloat(w.config.legend.markers.offsetY[i]) : parseFloat(w.config.legend.markers.offsetY);
    let mBorderWidth = Array.isArray(w.config.legend.markers.strokeWidth) ? parseFloat(w.config.legend.markers.strokeWidth[i]) : parseFloat(w.config.legend.markers.strokeWidth);
    let mStyle = elMarker.style;
    mStyle.height = (mSize + mBorderWidth) * 2 + "px";
    mStyle.width = (mSize + mBorderWidth) * 2 + "px";
    mStyle.left = mOffsetX + "px";
    mStyle.top = mOffsetY + "px";
    if (w.config.legend.markers.customHTML) {
      mStyle.background = "transparent";
      mStyle.color = fillcolor[i];
      if (Array.isArray(w.config.legend.markers.customHTML)) {
        if (w.config.legend.markers.customHTML[i]) {
          elMarker.innerHTML = w.config.legend.markers.customHTML[i]();
        }
      } else {
        elMarker.innerHTML = w.config.legend.markers.customHTML();
      }
    } else {
      let markers = new Markers(this.ctx);
      const markerConfig = markers.getMarkerConfig({
        cssClass: `apexcharts-legend-marker apexcharts-marker apexcharts-marker-${shape}`,
        seriesIndex: i,
        strokeWidth: mBorderWidth,
        size: mSize
      });
      const SVGMarker = window.SVG().addTo(elMarker).size("100%", "100%");
      const marker = new Graphics(this.ctx).drawMarker(0, 0, __spreadProps(__spreadValues({}, markerConfig), {
        pointFillColor: Array.isArray(fillcolor) ? fillcolor[i] : markerConfig.pointFillColor,
        shape
      }));
      const shapesEls = w.globals.dom.Paper.find(
        ".apexcharts-legend-marker.apexcharts-marker"
      );
      shapesEls.forEach((shapeEl) => {
        if (shapeEl.node.classList.contains("apexcharts-marker-triangle")) {
          shapeEl.node.style.transform = "translate(50%, 45%)";
        } else {
          shapeEl.node.style.transform = "translate(50%, 50%)";
        }
      });
      SVGMarker.add(marker);
    }
    return elMarker;
  }
  drawLegends() {
    var _a;
    let me = this;
    let w = this.w;
    let fontFamily = w.config.legend.fontFamily;
    let legendNames = w.globals.seriesNames;
    let fillcolor = w.config.legend.markers.fillColors ? w.config.legend.markers.fillColors.slice() : w.globals.colors.slice();
    if (w.config.chart.type === "heatmap") {
      const ranges = w.config.plotOptions.heatmap.colorScale.ranges;
      legendNames = ranges.map((colorScale) => {
        return colorScale.name ? colorScale.name : colorScale.from + " - " + colorScale.to;
      });
      fillcolor = ranges.map((color) => color.color);
    } else if (this.isBarsDistributed) {
      legendNames = w.globals.labels.slice();
    }
    if (w.config.legend.customLegendItems.length) {
      legendNames = w.config.legend.customLegendItems;
    }
    let legendFormatter = w.globals.legendFormatter;
    let isLegendInversed = w.config.legend.inverseOrder;
    let legendGroups = [];
    if (w.globals.seriesGroups.length > 1 && w.config.legend.clusterGroupedSeries) {
      w.globals.seriesGroups.forEach((_, gi) => {
        legendGroups[gi] = document.createElement("div");
        legendGroups[gi].classList.add(
          "apexcharts-legend-group",
          `apexcharts-legend-group-${gi}`
        );
        if (w.config.legend.clusterGroupedSeriesOrientation === "horizontal") {
          w.globals.dom.elLegendWrap.classList.add(
            "apexcharts-legend-group-horizontal"
          );
        } else {
          legendGroups[gi].classList.add("apexcharts-legend-group-vertical");
        }
      });
    }
    for (let i = isLegendInversed ? legendNames.length - 1 : 0; isLegendInversed ? i >= 0 : i <= legendNames.length - 1; isLegendInversed ? i-- : i++) {
      let text = legendFormatter(legendNames[i], { seriesIndex: i, w });
      let collapsedSeries = false;
      let ancillaryCollapsedSeries = false;
      if (w.globals.collapsedSeries.length > 0) {
        for (let c = 0; c < w.globals.collapsedSeries.length; c++) {
          if (w.globals.collapsedSeries[c].index === i) {
            collapsedSeries = true;
          }
        }
      }
      if (w.globals.ancillaryCollapsedSeriesIndices.length > 0) {
        for (let c = 0; c < w.globals.ancillaryCollapsedSeriesIndices.length; c++) {
          if (w.globals.ancillaryCollapsedSeriesIndices[c] === i) {
            ancillaryCollapsedSeries = true;
          }
        }
      }
      let elMarker = this.createLegendMarker({ i, fillcolor });
      Graphics.setAttrs(elMarker, {
        rel: i + 1,
        "data:collapsed": collapsedSeries || ancillaryCollapsedSeries
      });
      if (collapsedSeries || ancillaryCollapsedSeries) {
        elMarker.classList.add("apexcharts-inactive-legend");
      }
      let elLegend = document.createElement("div");
      if (w.config.chart.accessibility.enabled && w.config.chart.accessibility.keyboard.enabled) {
        elLegend.setAttribute("role", "button");
        elLegend.setAttribute("tabindex", "0");
        const seriesName = Array.isArray(text) ? text.join(" ") : text;
        const isCollapsed = collapsedSeries || ancillaryCollapsedSeries;
        const statusText = isCollapsed ? "hidden" : "visible";
        elLegend.setAttribute(
          "aria-label",
          `${seriesName}, ${statusText}. Press Enter or Space to toggle.`
        );
        elLegend.setAttribute("aria-pressed", isCollapsed ? "true" : "false");
      }
      let elLegendText = document.createElement("span");
      elLegendText.classList.add("apexcharts-legend-text");
      elLegendText.innerHTML = Array.isArray(text) ? text.join(" ") : text;
      let textColor = w.config.legend.labels.useSeriesColors ? w.globals.colors[i] : Array.isArray(w.config.legend.labels.colors) ? (_a = w.config.legend.labels.colors) == null ? void 0 : _a[i] : w.config.legend.labels.colors;
      if (!textColor) {
        textColor = w.config.chart.foreColor;
      }
      elLegendText.style.color = textColor;
      elLegendText.style.fontSize = w.config.legend.fontSize;
      elLegendText.style.fontWeight = w.config.legend.fontWeight;
      elLegendText.style.fontFamily = fontFamily || w.config.chart.fontFamily;
      Graphics.setAttrs(elLegendText, {
        rel: i + 1,
        i,
        "data:default-text": encodeURIComponent(text),
        "data:collapsed": collapsedSeries || ancillaryCollapsedSeries
      });
      elLegend.appendChild(elMarker);
      elLegend.appendChild(elLegendText);
      const coreUtils = new CoreUtils(this.ctx);
      if (!w.config.legend.showForZeroSeries) {
        const total = coreUtils.getSeriesTotalByIndex(i);
        if (total === 0 && coreUtils.seriesHaveSameValues(i) && !coreUtils.isSeriesNull(i) && w.globals.collapsedSeriesIndices.indexOf(i) === -1 && w.globals.ancillaryCollapsedSeriesIndices.indexOf(i) === -1) {
          elLegend.classList.add("apexcharts-hidden-zero-series");
        }
      }
      if (!w.config.legend.showForNullSeries) {
        if (coreUtils.isSeriesNull(i) && w.globals.collapsedSeriesIndices.indexOf(i) === -1 && w.globals.ancillaryCollapsedSeriesIndices.indexOf(i) === -1) {
          elLegend.classList.add("apexcharts-hidden-null-series");
        }
      }
      if (legendGroups.length) {
        w.globals.seriesGroups.forEach((group, gi) => {
          var _a2;
          if (group.includes((_a2 = w.config.series[i]) == null ? void 0 : _a2.name)) {
            w.globals.dom.elLegendWrap.appendChild(legendGroups[gi]);
            legendGroups[gi].appendChild(elLegend);
          }
        });
      } else {
        w.globals.dom.elLegendWrap.appendChild(elLegend);
      }
      w.globals.dom.elLegendWrap.classList.add(
        `apexcharts-align-${w.config.legend.horizontalAlign}`
      );
      w.globals.dom.elLegendWrap.classList.add(
        "apx-legend-position-" + w.config.legend.position
      );
      elLegend.classList.add("apexcharts-legend-series");
      elLegend.style.margin = `${w.config.legend.itemMargin.vertical}px ${w.config.legend.itemMargin.horizontal}px`;
      w.globals.dom.elLegendWrap.style.width = w.config.legend.width ? w.config.legend.width + "px" : "";
      w.globals.dom.elLegendWrap.style.height = w.config.legend.height ? w.config.legend.height + "px" : "";
      Graphics.setAttrs(elLegend, {
        rel: i + 1,
        seriesName: Utils$1.escapeString(legendNames[i]),
        "data:collapsed": collapsedSeries || ancillaryCollapsedSeries
      });
      if (collapsedSeries || ancillaryCollapsedSeries) {
        elLegend.classList.add("apexcharts-inactive-legend");
      }
      if (!w.config.legend.onItemClick.toggleDataSeries) {
        elLegend.classList.add("apexcharts-no-click");
      }
    }
    w.globals.dom.elWrap.addEventListener("click", me.onLegendClick, true);
    if (w.config.legend.onItemHover.highlightDataSeries && w.config.legend.customLegendItems.length === 0) {
      w.globals.dom.elWrap.addEventListener(
        "mousemove",
        me.onLegendHovered,
        true
      );
      w.globals.dom.elWrap.addEventListener(
        "mouseout",
        me.onLegendHovered,
        true
      );
    }
    if (w.config.chart.accessibility.enabled && w.config.chart.accessibility.keyboard.enabled) {
      w.globals.dom.elWrap.addEventListener("keydown", me.onLegendKeyDown.bind(me), true);
    }
  }
  setLegendWrapXY(offsetX, offsetY) {
    let w = this.w;
    let elLegendWrap = w.globals.dom.elLegendWrap;
    const legendHeight = elLegendWrap.clientHeight;
    let x = 0;
    let y = 0;
    if (w.config.legend.position === "bottom") {
      y = w.globals.svgHeight - Math.min(legendHeight, w.globals.svgHeight / 2) - 5;
    } else if (w.config.legend.position === "top") {
      const dim = new Dimensions(this.ctx);
      const titleH = dim.dimHelpers.getTitleSubtitleCoords("title").height;
      const subtitleH = dim.dimHelpers.getTitleSubtitleCoords("subtitle").height;
      y = (titleH > 0 ? titleH - 10 : 0) + (subtitleH > 0 ? subtitleH - 10 : 0);
    }
    elLegendWrap.style.position = "absolute";
    x = x + offsetX + w.config.legend.offsetX;
    y = y + offsetY + w.config.legend.offsetY;
    elLegendWrap.style.left = x + "px";
    elLegendWrap.style.top = y + "px";
    if (w.config.legend.position === "right") {
      elLegendWrap.style.left = "auto";
      elLegendWrap.style.right = 25 + w.config.legend.offsetX + "px";
    }
    const fixedHeigthWidth = ["width", "height"];
    fixedHeigthWidth.forEach((hw) => {
      if (elLegendWrap.style[hw]) {
        elLegendWrap.style[hw] = parseInt(w.config.legend[hw], 10) + "px";
      }
    });
  }
  legendAlignHorizontal() {
    let w = this.w;
    let elLegendWrap = w.globals.dom.elLegendWrap;
    elLegendWrap.style.right = 0;
    let dimensions = new Dimensions(this.ctx);
    let titleRect = dimensions.dimHelpers.getTitleSubtitleCoords("title");
    let subtitleRect = dimensions.dimHelpers.getTitleSubtitleCoords("subtitle");
    let offsetX = 20;
    let offsetY = 0;
    if (w.config.legend.position === "top") {
      offsetY = titleRect.height + subtitleRect.height + w.config.title.margin + w.config.subtitle.margin - 10;
    }
    this.setLegendWrapXY(offsetX, offsetY);
  }
  legendAlignVertical() {
    let w = this.w;
    let lRect = this.legendHelpers.getLegendDimensions();
    let offsetY = 20;
    let offsetX = 0;
    if (w.config.legend.position === "left") {
      offsetX = 20;
    }
    if (w.config.legend.position === "right") {
      offsetX = w.globals.svgWidth - lRect.clww - 10;
    }
    this.setLegendWrapXY(offsetX, offsetY);
  }
  onLegendHovered(e) {
    const w = this.w;
    const hoverOverLegend = e.target.classList.contains("apexcharts-legend-series") || e.target.classList.contains("apexcharts-legend-text") || e.target.classList.contains("apexcharts-legend-marker");
    if (w.config.chart.type !== "heatmap" && !this.isBarsDistributed) {
      if (!e.target.classList.contains("apexcharts-inactive-legend") && hoverOverLegend) {
        let series = new Series(this.ctx);
        series.toggleSeriesOnHover(e, e.target);
      }
    } else {
      if (hoverOverLegend) {
        let seriesCnt = parseInt(e.target.getAttribute("rel"), 10) - 1;
        this.ctx.events.fireEvent("legendHover", [this.ctx, seriesCnt, this.w]);
        let series = new Series(this.ctx);
        series.highlightRangeInSeries(e, e.target);
      }
    }
  }
  onLegendKeyDown(e) {
    const me = this;
    const isLegendItem = e.target.classList.contains("apexcharts-legend-series") || e.target.classList.contains("apexcharts-legend-text") || e.target.classList.contains("apexcharts-legend-marker");
    if (!isLegendItem) return;
    if (e.key === "Enter" || e.key === " ") {
      e.preventDefault();
      me.onLegendClick(e);
    }
  }
  onLegendClick(e) {
    const w = this.w;
    if (w.config.legend.customLegendItems.length) return;
    if (e.target.classList.contains("apexcharts-legend-series") || e.target.classList.contains("apexcharts-legend-text") || e.target.classList.contains("apexcharts-legend-marker")) {
      let seriesCnt = parseInt(e.target.getAttribute("rel"), 10) - 1;
      let isHidden = e.target.getAttribute("data:collapsed") === "true";
      const legendClick = this.w.config.chart.events.legendClick;
      if (typeof legendClick === "function") {
        legendClick(this.ctx, seriesCnt, this.w);
      }
      this.ctx.events.fireEvent("legendClick", [this.ctx, seriesCnt, this.w]);
      const markerClick = this.w.config.legend.markers.onClick;
      if (typeof markerClick === "function" && e.target.classList.contains("apexcharts-legend-marker")) {
        markerClick(this.ctx, seriesCnt, this.w);
        this.ctx.events.fireEvent("legendMarkerClick", [
          this.ctx,
          seriesCnt,
          this.w
        ]);
      }
      const clickAllowed = w.config.chart.type !== "treemap" && w.config.chart.type !== "heatmap" && !this.isBarsDistributed;
      if (clickAllowed && w.config.legend.onItemClick.toggleDataSeries) {
        this.legendHelpers.toggleDataSeries(seriesCnt, isHidden);
      }
    }
  }
}
const icoPan = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" fill="#000000" height="24" viewBox="0 0 24 24" width="24">\n    <defs>\n        <path d="M0 0h24v24H0z" id="a"/>\n    </defs>\n    <clipPath id="b">\n        <use overflow="visible" xlink:href="#a"/>\n    </clipPath>\n    <path clip-path="url(#b)" d="M23 5.5V20c0 2.2-1.8 4-4 4h-7.3c-1.08 0-2.1-.43-2.85-1.19L1 14.83s1.26-1.23 1.3-1.25c.22-.19.49-.29.79-.29.22 0 .42.06.6.16.04.01 4.31 2.46 4.31 2.46V4c0-.83.67-1.5 1.5-1.5S11 3.17 11 4v7h1V1.5c0-.83.67-1.5 1.5-1.5S15 .67 15 1.5V11h1V2.5c0-.83.67-1.5 1.5-1.5s1.5.67 1.5 1.5V11h1V5.5c0-.83.67-1.5 1.5-1.5s1.5.67 1.5 1.5z"/>\n</svg>';
const icoZoom = '<svg xmlns="http://www.w3.org/2000/svg" fill="#000000" height="24" viewBox="0 0 24 24" width="24">\n    <path d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z"/>\n    <path d="M0 0h24v24H0V0z" fill="none"/>\n    <path d="M12 10h-2v2H9v-2H7V9h2V7h1v2h2v1z"/>\n</svg>';
const icoReset = '<svg fill="#000000" height="24" viewBox="0 0 24 24" width="24" xmlns="http://www.w3.org/2000/svg">\n    <path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z"/>\n    <path d="M0 0h24v24H0z" fill="none"/>\n</svg>';
const icoZoomIn = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">\n    <path d="M0 0h24v24H0z" fill="none"/>\n    <path d="M13 7h-2v4H7v2h4v4h2v-4h4v-2h-4V7zm-1-5C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z"/>\n</svg>\n';
const icoZoomOut = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">\n    <path d="M0 0h24v24H0z" fill="none"/>\n    <path d="M7 11v2h10v-2H7zm5-9C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z"/>\n</svg>\n';
const icoSelect = '<svg fill="#6E8192" height="24" viewBox="0 0 24 24" width="24" xmlns="http://www.w3.org/2000/svg">\n    <path d="M0 0h24v24H0z" fill="none"/>\n    <path d="M3 5h2V3c-1.1 0-2 .9-2 2zm0 8h2v-2H3v2zm4 8h2v-2H7v2zM3 9h2V7H3v2zm10-6h-2v2h2V3zm6 0v2h2c0-1.1-.9-2-2-2zM5 21v-2H3c0 1.1.9 2 2 2zm-2-4h2v-2H3v2zM9 3H7v2h2V3zm2 18h2v-2h-2v2zm8-8h2v-2h-2v2zm0 8c1.1 0 2-.9 2-2h-2v2zm0-12h2V7h-2v2zm0 8h2v-2h-2v2zm-4 4h2v-2h-2v2zm0-16h2V3h-2v2z"/>\n</svg>';
const icoMenu = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path fill="none" d="M0 0h24v24H0V0z"/><path d="M3 18h18v-2H3v2zm0-5h18v-2H3v2zm0-7v2h18V6H3z"/></svg>';
class Toolbar {
  constructor(ctx) {
    this.ctx = ctx;
    this.w = ctx.w;
    const w = this.w;
    this.ev = this.w.config.chart.events;
    this.selectedClass = "apexcharts-selected";
    this.localeValues = this.w.globals.locale.toolbar;
    this.minX = w.globals.minX;
    this.maxX = w.globals.maxX;
  }
  createToolbar() {
    let w = this.w;
    const createDiv = () => {
      return document.createElement("div");
    };
    const elToolbarWrap = createDiv();
    elToolbarWrap.setAttribute("class", "apexcharts-toolbar");
    elToolbarWrap.style.top = w.config.chart.toolbar.offsetY + "px";
    elToolbarWrap.style.right = -w.config.chart.toolbar.offsetX + 3 + "px";
    w.globals.dom.elWrap.appendChild(elToolbarWrap);
    this.elZoom = createDiv();
    this.elZoomIn = createDiv();
    this.elZoomOut = createDiv();
    this.elPan = createDiv();
    this.elSelection = createDiv();
    this.elZoomReset = createDiv();
    this.elMenuIcon = createDiv();
    this.elMenu = createDiv();
    this.elCustomIcons = [];
    this.t = w.config.chart.toolbar.tools;
    if (Array.isArray(this.t.customIcons)) {
      for (let i = 0; i < this.t.customIcons.length; i++) {
        this.elCustomIcons.push(createDiv());
      }
    }
    let toolbarControls = [];
    const appendZoomControl = (type, el, ico) => {
      const tool = type.toLowerCase();
      if (this.t[tool] && w.config.chart.zoom.enabled) {
        toolbarControls.push({
          el,
          icon: typeof this.t[tool] === "string" ? this.t[tool] : ico,
          title: this.localeValues[type],
          class: `apexcharts-${tool}-icon`
        });
      }
    };
    appendZoomControl("zoomIn", this.elZoomIn, icoZoomIn);
    appendZoomControl("zoomOut", this.elZoomOut, icoZoomOut);
    const zoomSelectionCtrls = (z) => {
      if (this.t[z] && w.config.chart[z].enabled) {
        toolbarControls.push({
          el: z === "zoom" ? this.elZoom : this.elSelection,
          icon: typeof this.t[z] === "string" ? this.t[z] : z === "zoom" ? icoZoom : icoSelect,
          title: this.localeValues[z === "zoom" ? "selectionZoom" : "selection"],
          class: `apexcharts-${z}-icon`
        });
      }
    };
    zoomSelectionCtrls("zoom");
    zoomSelectionCtrls("selection");
    if (this.t.pan && w.config.chart.zoom.enabled) {
      toolbarControls.push({
        el: this.elPan,
        icon: typeof this.t.pan === "string" ? this.t.pan : icoPan,
        title: this.localeValues.pan,
        class: "apexcharts-pan-icon"
      });
    }
    appendZoomControl("reset", this.elZoomReset, icoReset);
    if (this.t.download) {
      toolbarControls.push({
        el: this.elMenuIcon,
        icon: typeof this.t.download === "string" ? this.t.download : icoMenu,
        title: this.localeValues.menu,
        class: "apexcharts-menu-icon"
      });
    }
    for (let i = 0; i < this.elCustomIcons.length; i++) {
      toolbarControls.push({
        el: this.elCustomIcons[i],
        icon: this.t.customIcons[i].icon,
        title: this.t.customIcons[i].title,
        index: this.t.customIcons[i].index,
        class: "apexcharts-toolbar-custom-icon " + this.t.customIcons[i].class
      });
    }
    toolbarControls.forEach((t, index2) => {
      if (t.index) {
        Utils$1.moveIndexInArray(toolbarControls, index2, t.index);
      }
    });
    for (let i = 0; i < toolbarControls.length; i++) {
      Graphics.setAttrs(toolbarControls[i].el, {
        class: toolbarControls[i].class,
        title: toolbarControls[i].title
      });
      toolbarControls[i].el.innerHTML = toolbarControls[i].icon;
      elToolbarWrap.appendChild(toolbarControls[i].el);
    }
    this._createHamburgerMenu(elToolbarWrap);
    if (w.globals.zoomEnabled) {
      this.elZoom.classList.add(this.selectedClass);
    } else if (w.globals.panEnabled) {
      this.elPan.classList.add(this.selectedClass);
    } else if (w.globals.selectionEnabled) {
      this.elSelection.classList.add(this.selectedClass);
    }
    this.addToolbarEventListeners();
  }
  _createHamburgerMenu(parent) {
    this.elMenuItems = [];
    parent.appendChild(this.elMenu);
    Graphics.setAttrs(this.elMenu, {
      class: "apexcharts-menu"
    });
    const menuItems = [
      {
        name: "exportSVG",
        title: this.localeValues.exportToSVG
      },
      {
        name: "exportPNG",
        title: this.localeValues.exportToPNG
      },
      {
        name: "exportCSV",
        title: this.localeValues.exportToCSV
      }
    ];
    for (let i = 0; i < menuItems.length; i++) {
      this.elMenuItems.push(document.createElement("div"));
      this.elMenuItems[i].innerHTML = menuItems[i].title;
      Graphics.setAttrs(this.elMenuItems[i], {
        class: `apexcharts-menu-item ${menuItems[i].name}`,
        title: menuItems[i].title
      });
      this.elMenu.appendChild(this.elMenuItems[i]);
    }
  }
  addToolbarEventListeners() {
    this.elZoomReset.addEventListener("click", this.handleZoomReset.bind(this));
    this.elSelection.addEventListener(
      "click",
      this.toggleZoomSelection.bind(this, "selection")
    );
    this.elZoom.addEventListener(
      "click",
      this.toggleZoomSelection.bind(this, "zoom")
    );
    this.elZoomIn.addEventListener("click", this.handleZoomIn.bind(this));
    this.elZoomOut.addEventListener("click", this.handleZoomOut.bind(this));
    this.elPan.addEventListener("click", this.togglePanning.bind(this));
    this.elMenuIcon.addEventListener("click", this.toggleMenu.bind(this));
    this.elMenuItems.forEach((m2) => {
      if (m2.classList.contains("exportSVG")) {
        m2.addEventListener("click", this.handleDownload.bind(this, "svg"));
      } else if (m2.classList.contains("exportPNG")) {
        m2.addEventListener("click", this.handleDownload.bind(this, "png"));
      } else if (m2.classList.contains("exportCSV")) {
        m2.addEventListener("click", this.handleDownload.bind(this, "csv"));
      }
    });
    for (let i = 0; i < this.t.customIcons.length; i++) {
      this.elCustomIcons[i].addEventListener(
        "click",
        this.t.customIcons[i].click.bind(this, this.ctx, this.ctx.w)
      );
    }
  }
  toggleZoomSelection(type) {
    const charts = this.ctx.getSyncedCharts();
    charts.forEach((ch) => {
      ch.ctx.toolbar.toggleOtherControls();
      let el = type === "selection" ? ch.ctx.toolbar.elSelection : ch.ctx.toolbar.elZoom;
      let enabledType = type === "selection" ? "selectionEnabled" : "zoomEnabled";
      ch.w.globals[enabledType] = !ch.w.globals[enabledType];
      if (!el.classList.contains(ch.ctx.toolbar.selectedClass)) {
        el.classList.add(ch.ctx.toolbar.selectedClass);
      } else {
        el.classList.remove(ch.ctx.toolbar.selectedClass);
      }
    });
  }
  getToolbarIconsReference() {
    const w = this.w;
    if (!this.elZoom) {
      this.elZoom = w.globals.dom.baseEl.querySelector(".apexcharts-zoom-icon");
    }
    if (!this.elPan) {
      this.elPan = w.globals.dom.baseEl.querySelector(".apexcharts-pan-icon");
    }
    if (!this.elSelection) {
      this.elSelection = w.globals.dom.baseEl.querySelector(
        ".apexcharts-selection-icon"
      );
    }
  }
  enableZoomPanFromToolbar(type) {
    this.toggleOtherControls();
    type === "pan" ? this.w.globals.panEnabled = true : this.w.globals.zoomEnabled = true;
    const el = type === "pan" ? this.elPan : this.elZoom;
    const el2 = type === "pan" ? this.elZoom : this.elPan;
    if (el) {
      el.classList.add(this.selectedClass);
    }
    if (el2) {
      el2.classList.remove(this.selectedClass);
    }
  }
  togglePanning() {
    const charts = this.ctx.getSyncedCharts();
    charts.forEach((ch) => {
      ch.ctx.toolbar.toggleOtherControls();
      ch.w.globals.panEnabled = !ch.w.globals.panEnabled;
      if (!ch.ctx.toolbar.elPan.classList.contains(ch.ctx.toolbar.selectedClass)) {
        ch.ctx.toolbar.elPan.classList.add(ch.ctx.toolbar.selectedClass);
      } else {
        ch.ctx.toolbar.elPan.classList.remove(ch.ctx.toolbar.selectedClass);
      }
    });
  }
  toggleOtherControls() {
    const w = this.w;
    w.globals.panEnabled = false;
    w.globals.zoomEnabled = false;
    w.globals.selectionEnabled = false;
    this.getToolbarIconsReference();
    const toggleEls = [this.elPan, this.elSelection, this.elZoom];
    toggleEls.forEach((el) => {
      if (el) {
        el.classList.remove(this.selectedClass);
      }
    });
  }
  handleZoomIn() {
    const w = this.w;
    if (w.globals.isRangeBar) {
      this.minX = w.globals.minY;
      this.maxX = w.globals.maxY;
    }
    const centerX = (this.minX + this.maxX) / 2;
    let newMinX = (this.minX + centerX) / 2;
    let newMaxX = (this.maxX + centerX) / 2;
    const newMinXMaxX = this._getNewMinXMaxX(newMinX, newMaxX);
    if (!w.globals.disableZoomIn) {
      this.zoomUpdateOptions(newMinXMaxX.minX, newMinXMaxX.maxX);
    }
  }
  handleZoomOut() {
    const w = this.w;
    if (w.globals.isRangeBar) {
      this.minX = w.globals.minY;
      this.maxX = w.globals.maxY;
    }
    if (w.config.xaxis.type === "datetime" && new Date(this.minX).getUTCFullYear() < 1e3) {
      return;
    }
    const centerX = (this.minX + this.maxX) / 2;
    let newMinX = this.minX - (centerX - this.minX);
    let newMaxX = this.maxX - (centerX - this.maxX);
    const newMinXMaxX = this._getNewMinXMaxX(newMinX, newMaxX);
    if (!w.globals.disableZoomOut) {
      this.zoomUpdateOptions(newMinXMaxX.minX, newMinXMaxX.maxX);
    }
  }
  _getNewMinXMaxX(newMinX, newMaxX) {
    const shouldFloor = this.w.config.xaxis.convertedCatToNumeric;
    return {
      minX: shouldFloor ? Math.floor(newMinX) : newMinX,
      maxX: shouldFloor ? Math.floor(newMaxX) : newMaxX
    };
  }
  zoomUpdateOptions(newMinX, newMaxX) {
    const w = this.w;
    if (newMinX === void 0 && newMaxX === void 0) {
      this.handleZoomReset();
      return;
    }
    if (w.config.xaxis.convertedCatToNumeric) {
      if (newMinX < 1) {
        newMinX = 1;
        newMaxX = w.globals.dataPoints;
      }
      if (newMaxX - newMinX < 2) {
        return;
      }
    }
    let xaxis = {
      min: newMinX,
      max: newMaxX
    };
    const beforeZoomRange = this.getBeforeZoomRange(xaxis);
    if (beforeZoomRange) {
      xaxis = beforeZoomRange.xaxis;
    }
    let options2 = {
      xaxis
    };
    let yaxis = Utils$1.clone(w.globals.initialConfig.yaxis);
    if (!w.config.chart.group) {
      options2.yaxis = yaxis;
    }
    this.w.globals.zoomed = true;
    this.ctx.updateHelpers._updateOptions(
      options2,
      false,
      this.w.config.chart.animations.dynamicAnimation.enabled
    );
    this.zoomCallback(xaxis, yaxis);
  }
  zoomCallback(xaxis, yaxis) {
    if (typeof this.ev.zoomed === "function") {
      this.ev.zoomed(this.ctx, { xaxis, yaxis });
      this.ctx.events.fireEvent("zoomed", { xaxis, yaxis });
    }
  }
  getBeforeZoomRange(xaxis, yaxis) {
    let newRange = null;
    if (typeof this.ev.beforeZoom === "function") {
      newRange = this.ev.beforeZoom(this, { xaxis, yaxis });
    }
    return newRange;
  }
  toggleMenu() {
    window.setTimeout(() => {
      if (this.elMenu.classList.contains("apexcharts-menu-open")) {
        this.elMenu.classList.remove("apexcharts-menu-open");
      } else {
        this.elMenu.classList.add("apexcharts-menu-open");
      }
    }, 0);
  }
  handleDownload(type) {
    const w = this.w;
    const exprt = new Exports(this.ctx);
    switch (type) {
      case "svg":
        exprt.exportToSVG(this.ctx);
        break;
      case "png":
        exprt.exportToPng(this.ctx);
        break;
      case "csv":
        exprt.exportToCSV({
          series: w.config.series,
          columnDelimiter: w.config.chart.toolbar.export.csv.columnDelimiter
        });
        break;
    }
  }
  handleZoomReset() {
    const charts = this.ctx.getSyncedCharts();
    charts.forEach((ch) => {
      let w = ch.w;
      w.globals.lastXAxis.min = w.globals.initialConfig.xaxis.min;
      w.globals.lastXAxis.max = w.globals.initialConfig.xaxis.max;
      ch.updateHelpers.revertDefaultAxisMinMax();
      if (typeof w.config.chart.events.beforeResetZoom === "function") {
        const resetZoomRange = w.config.chart.events.beforeResetZoom(ch, w);
        if (resetZoomRange) {
          ch.updateHelpers.revertDefaultAxisMinMax(resetZoomRange);
        }
      }
      if (typeof w.config.chart.events.zoomed === "function") {
        ch.ctx.toolbar.zoomCallback({
          min: w.config.xaxis.min,
          max: w.config.xaxis.max
        });
      }
      w.globals.zoomed = false;
      let series = ch.ctx.series.emptyCollapsedSeries(
        Utils$1.clone(w.globals.initialSeries)
      );
      ch.updateHelpers._updateSeries(
        series,
        w.config.chart.animations.dynamicAnimation.enabled
      );
    });
  }
  destroy() {
    this.elZoom = null;
    this.elZoomIn = null;
    this.elZoomOut = null;
    this.elPan = null;
    this.elSelection = null;
    this.elZoomReset = null;
    this.elMenuIcon = null;
  }
}
class SVGElement {
  constructor(node) {
    this.node = node;
    if (node) {
      node.instance = this;
    }
    this._listeners = [];
    this._filter = null;
  }
  // ---- Attribute methods ----
  attr(a, v) {
    if (typeof a === "string" && v === void 0) {
      return this.node.getAttribute(a);
    }
    const attrs = typeof a === "string" ? { [a]: v } : a;
    for (const key in attrs) {
      let val = attrs[key];
      if (val === null) {
        this.node.removeAttribute(key);
      } else if (val !== void 0) {
        if (typeof val === "number" && isNaN(val)) val = 0;
        this.node.setAttribute(key, val);
      }
    }
    if (this.node.nodeName === "text" && attrs.x != null) {
      const tspans = this.node.querySelectorAll("tspan[data-newline]");
      for (let i = 0; i < tspans.length; i++) {
        tspans[i].setAttribute("x", attrs.x);
      }
    }
    return this;
  }
  css(styles) {
    for (const k in styles) {
      this.node.style[k] = styles[k];
    }
    return this;
  }
  fill(v) {
    if (typeof v === "object") {
      return this.attr(v);
    }
    return this.attr("fill", v);
  }
  stroke(v) {
    if (typeof v === "object") {
      if (v.color !== void 0) this.attr("stroke", v.color);
      if (v.width !== void 0) this.attr("stroke-width", v.width);
      if (v.dasharray !== void 0) this.attr("stroke-dasharray", v.dasharray);
      if (v.linecap !== void 0) this.attr("stroke-linecap", v.linecap);
      if (v.opacity !== void 0) this.attr("stroke-opacity", v.opacity);
      return this;
    }
    return this.attr("stroke", v);
  }
  size(w, h2) {
    return this.attr({ width: w, height: h2 });
  }
  move(x, y) {
    return this.attr({ x, y });
  }
  center(cx, cy) {
    if (this.node.nodeName === "g") {
      const box = this.bbox();
      const dx = cx - (box.x + box.width / 2);
      const dy = cy - (box.y + box.height / 2);
      return this.attr("transform", `translate(${dx}, ${dy})`);
    }
    return this.attr({ cx, cy });
  }
  // ---- Tree operations ----
  add(child) {
    this.node.appendChild(child.node || child);
    return this;
  }
  addTo(parent) {
    const p = parent.node || parent;
    p.appendChild(this.node);
    return this;
  }
  remove() {
    if (this.node.parentNode) {
      this.node.parentNode.removeChild(this.node);
    }
    return this;
  }
  clear() {
    while (this.node.firstChild) {
      this.node.removeChild(this.node.firstChild);
    }
    return this;
  }
  // ---- Query ----
  find(selector) {
    return Array.from(this.node.querySelectorAll(selector)).map(
      (n) => n.instance || new SVGElement(n)
    );
  }
  findOne(selector) {
    const n = this.node.querySelector(selector);
    return n ? n.instance || new SVGElement(n) : null;
  }
  // ---- Events ----
  on(event, handler) {
    const eventType = event.split(".")[0];
    this._listeners.push({ event, eventType, handler });
    this.node.addEventListener(eventType, handler);
    return this;
  }
  off(event, handler) {
    if (!event && !handler) {
      this._listeners.forEach((l) => {
        this.node.removeEventListener(l.eventType, l.handler);
      });
      this._listeners = [];
    } else if (event && !handler) {
      const eventType = event.split(".")[0];
      this._listeners = this._listeners.filter((l) => {
        if (l.eventType === eventType) {
          this.node.removeEventListener(l.eventType, l.handler);
          return false;
        }
        return true;
      });
    } else {
      const eventType = event.split(".")[0];
      this._listeners = this._listeners.filter((l) => {
        if (l.eventType === eventType && l.handler === handler) {
          this.node.removeEventListener(l.eventType, l.handler);
          return false;
        }
        return true;
      });
    }
    return this;
  }
  // ---- Iteration ----
  each(fn, deep) {
    const children = Array.from(this.node.children);
    children.forEach((child) => {
      const inst = child.instance || new SVGElement(child);
      fn.call(inst);
      if (deep) inst.each(fn, deep);
    });
    return this;
  }
  // ---- CSS classes ----
  removeClass(cls) {
    if (cls === "*") {
      this.node.removeAttribute("class");
    } else {
      this.node.classList.remove(cls);
    }
    return this;
  }
  // ---- Children ----
  children() {
    return Array.from(this.node.childNodes).filter((n) => n.nodeType === 1).map((n) => n.instance || new SVGElement(n));
  }
  // ---- Visibility ----
  hide() {
    this.node.style.display = "none";
    return this;
  }
  show() {
    this.node.style.display = "";
    return this;
  }
  // ---- Measurement ----
  bbox() {
    if (typeof this.node.getBBox === "function") {
      try {
        return this.node.getBBox();
      } catch (e) {
      }
    }
    return { x: 0, y: 0, width: 0, height: 0 };
  }
  // ---- Text-specific ----
  tspan(text) {
    const tspan = document.createElementNS(
      "http://www.w3.org/2000/svg",
      "tspan"
    );
    tspan.textContent = text;
    this.node.appendChild(tspan);
    return new SVGElement(tspan);
  }
  // ---- Path-specific ----
  plot(d) {
    if (typeof d === "string") {
      this.attr("d", d);
    }
    return this;
  }
  // ---- Animation (overridden by SVGAnimation mixin) ----
  animate() {
    throw new Error("Animation module not loaded");
  }
  // ---- Filter methods (set up by SVGFilter module) ----
  filterWith() {
    throw new Error("Filter module not loaded");
  }
  unfilter(all) {
    if (this._filter) {
      this.node.removeAttribute("filter");
      if (all && this._filter.node && this._filter.node.parentNode) {
        this._filter.node.parentNode.removeChild(this._filter.node);
      }
      this._filter = null;
    }
    return this;
  }
  filterer() {
    return this._filter;
  }
}
const SVGNS = "http://www.w3.org/2000/svg";
class Point {
  constructor(x, y) {
    if (typeof x === "object") {
      this.x = x.x;
      this.y = x.y;
    } else {
      this.x = x || 0;
      this.y = y || 0;
    }
  }
  transform(matrix2) {
    return matrix2.apply(this);
  }
  clone() {
    return new Point(this.x, this.y);
  }
}
class Matrix {
  constructor(a, b, c, d, e, f) {
    this.a = a != null ? a : 1;
    this.b = b != null ? b : 0;
    this.c = c != null ? c : 0;
    this.d = d != null ? d : 1;
    this.e = e != null ? e : 0;
    this.f = f != null ? f : 0;
  }
  rotate(deg) {
    const rad = deg * Math.PI / 180;
    const cos = Math.cos(rad);
    const sin = Math.sin(rad);
    return this.multiply(new Matrix(cos, sin, -sin, cos, 0, 0));
  }
  scale(sx, sy) {
    return this.multiply(new Matrix(sx, 0, 0, sy != null ? sy : sx, 0, 0));
  }
  multiply(m2) {
    return new Matrix(
      this.a * m2.a + this.c * m2.b,
      this.b * m2.a + this.d * m2.b,
      this.a * m2.c + this.c * m2.d,
      this.b * m2.c + this.d * m2.d,
      this.a * m2.e + this.c * m2.f + this.e,
      this.b * m2.e + this.d * m2.f + this.f
    );
  }
  apply(point) {
    return new Point(
      this.a * point.x + this.c * point.y + this.e,
      this.b * point.x + this.d * point.y + this.f
    );
  }
}
class Box {
  constructor(x, y, w, h2) {
    this.x = x;
    this.y = y;
    this.w = w;
    this.h = h2;
    this.width = w;
    this.height = h2;
    this.x2 = x + w;
    this.y2 = y + h2;
  }
}
let gradientCounter = 0;
class SVGGradient extends SVGElement {
  constructor(container, type, builder) {
    const tag = type === "radial" ? "radialGradient" : "linearGradient";
    const node = BrowserAPIs.createElementNS(SVGNS, tag);
    super(node);
    this._id = "SvgjsGradient" + ++gradientCounter;
    this.attr("id", this._id);
    if (typeof builder === "function") {
      builder(new StopBuilder(this));
    }
    let defs = container.node.querySelector("defs");
    if (!defs) {
      defs = BrowserAPIs.createElementNS(SVGNS, "defs");
      container.node.appendChild(defs);
    }
    defs.appendChild(this.node);
  }
  stop(offset2, color, opacity) {
    const s = BrowserAPIs.createElementNS(SVGNS, "stop");
    s.setAttribute("offset", offset2);
    s.setAttribute("stop-color", color);
    if (opacity !== void 0) s.setAttribute("stop-opacity", opacity);
    this.node.appendChild(s);
    return this;
  }
  from(x, y) {
    return this.attr({ x1: x, y1: y });
  }
  to(x, y) {
    return this.attr({ x2: x, y2: y });
  }
  url() {
    return "url(#" + this._id + ")";
  }
  toString() {
    return this.url();
  }
  valueOf() {
    return this.url();
  }
  fill() {
    return this.url();
  }
}
class StopBuilder {
  constructor(gradient) {
    this.gradient = gradient;
  }
  stop(offset2, color, opacity) {
    this.gradient.stop(offset2, color, opacity);
    return this;
  }
}
let patternCounter = 0;
class SVGPattern extends SVGElement {
  constructor(container, w, h2, builder) {
    const node = BrowserAPIs.createElementNS(SVGNS, "pattern");
    super(node);
    this._id = "SvgjsPattern" + ++patternCounter;
    this.attr({
      id: this._id,
      width: w,
      height: h2,
      patternUnits: "userSpaceOnUse"
    });
    if (typeof builder === "function") {
      const patternContainer = new SVGContainer(this.node);
      builder(patternContainer);
    }
    let defs = container.node.querySelector("defs");
    if (!defs) {
      defs = BrowserAPIs.createElementNS(SVGNS, "defs");
      container.node.appendChild(defs);
    }
    defs.appendChild(this.node);
  }
  url() {
    return "url(#" + this._id + ")";
  }
  toString() {
    return this.url();
  }
  valueOf() {
    return this.url();
  }
  fill() {
    return this.url();
  }
}
class SVGContainer extends SVGElement {
  line(x1, y1, x2, y2) {
    const el = this._make("line");
    if (x1 !== void 0) {
      el.attr({ x1, y1, x2, y2 });
    }
    return el;
  }
  rect(w, h2) {
    const el = this._make("rect");
    if (w !== void 0) {
      el.attr({ width: w, height: h2 });
    }
    return el;
  }
  circle(d) {
    const el = this._make("circle");
    if (d !== void 0) {
      el.attr({ r: d / 2, cx: d / 2, cy: d / 2 });
    }
    return el;
  }
  path(d) {
    const el = this._make("path");
    if (d) el.attr("d", d);
    return el;
  }
  polygon(pts) {
    const el = this._make("polygon");
    if (pts) el.attr("points", pts);
    return el;
  }
  group() {
    return this._makeContainer("g");
  }
  defs() {
    return this._makeContainer("defs");
  }
  plain(textContent) {
    const node = BrowserAPIs.createElementNS(SVGNS, "text");
    node.textContent = textContent;
    const el = new SVGElement(node);
    this.node.appendChild(node);
    return el;
  }
  text(builder) {
    const node = BrowserAPIs.createElementNS(SVGNS, "text");
    const el = new SVGElement(node);
    this.node.appendChild(node);
    if (typeof builder === "function") {
      builder(new TspanBuilder(node));
    }
    return el;
  }
  image(url, callback) {
    const node = BrowserAPIs.createElementNS(SVGNS, "image");
    node.setAttributeNS("http://www.w3.org/1999/xlink", "href", url);
    const el = new SVGElement(node);
    this.node.appendChild(node);
    if (typeof callback === "function") {
      const img = new Image();
      img.onload = function() {
        el.size(img.width, img.height);
        callback.call(el, { width: img.width, height: img.height });
      };
      img.src = url;
    }
    return el;
  }
  gradient(type, builder) {
    return new SVGGradient(this, type, builder);
  }
  pattern(w, h2, builder) {
    return new SVGPattern(this, w, h2, builder);
  }
  _make(tag) {
    const node = BrowserAPIs.createElementNS(SVGNS, tag);
    this.node.appendChild(node);
    return new SVGElement(node);
  }
  _makeContainer(tag) {
    const node = BrowserAPIs.createElementNS(SVGNS, tag);
    this.node.appendChild(node);
    return new SVGContainer(node);
  }
}
class TspanBuilder {
  constructor(textNode) {
    this.textNode = textNode;
  }
  tspan(text) {
    const tspan = BrowserAPIs.createElementNS(SVGNS, "tspan");
    tspan.textContent = text;
    this.textNode.appendChild(tspan);
    return new TspanWrapper(tspan, this.textNode);
  }
}
class TspanWrapper {
  constructor(node, textNode) {
    this.node = node;
    this.textNode = textNode;
  }
  newLine() {
    this.node.setAttribute("dy", "1.1em");
    this.node.dataset.newline = "1";
    return this;
  }
}
let filterCounter = 0;
class SVGFilter extends SVGElement {
  constructor() {
    const node = BrowserAPIs.createElementNS(SVGNS, "filter");
    super(node);
    this._id = "SvgjsFilter" + ++filterCounter;
    this.attr("id", this._id);
  }
  size(w, h2, x, y) {
    return this.attr({ width: w, height: h2, x, y });
  }
}
class FilterBuilder {
  constructor(filter) {
    this.filter = filter;
  }
  colorMatrix(attrs) {
    return this._primitive("feColorMatrix", attrs);
  }
  offset(attrs) {
    return this._primitive("feOffset", attrs);
  }
  gaussianBlur(attrs) {
    return this._primitive("feGaussianBlur", attrs);
  }
  flood(attrs) {
    return this._primitive("feFlood", attrs);
  }
  composite(attrs) {
    return this._primitive("feComposite", attrs);
  }
  merge(sources) {
    const m2 = BrowserAPIs.createElementNS(SVGNS, "feMerge");
    sources.forEach((src) => {
      const mn = BrowserAPIs.createElementNS(SVGNS, "feMergeNode");
      mn.setAttribute("in", src);
      m2.appendChild(mn);
    });
    this.filter.node.appendChild(m2);
    return new SVGElement(m2);
  }
  _primitive(tag, attrs) {
    const el = BrowserAPIs.createElementNS(SVGNS, tag);
    for (const key in attrs) {
      el.setAttribute(key, attrs[key]);
    }
    this.filter.node.appendChild(el);
    return new SVGElement(el);
  }
}
function installFilterMethods(ElementClass) {
  ElementClass.prototype.filterWith = function(fn) {
    const filter = new SVGFilter();
    this._filter = filter;
    let svgRoot = this.node;
    while (svgRoot && svgRoot.nodeName !== "svg") {
      svgRoot = svgRoot.parentNode;
    }
    if (svgRoot) {
      let defs = svgRoot.querySelector("defs");
      if (!defs) {
        defs = BrowserAPIs.createElementNS(SVGNS, "defs");
        svgRoot.insertBefore(defs, svgRoot.firstChild);
      }
      defs.appendChild(filter.node);
    }
    fn(new FilterBuilder(filter));
    this.attr("filter", "url(#" + filter._id + ")");
    return this;
  };
  ElementClass.prototype.unfilter = function(all) {
    if (this._filter) {
      this.node.removeAttribute("filter");
      if (all && this._filter.node && this._filter.node.parentNode) {
        this._filter.node.parentNode.removeChild(this._filter.node);
      }
      this._filter = null;
    }
    return this;
  };
  ElementClass.prototype.filterer = function() {
    return this._filter;
  };
}
function parsePath(d) {
  if (