import { a as openBlock, c as createElementBlock, e as createBlock, f as createCommentVNode, g as createBaseVNode, t as toDisplayString, n as normalizeClass, u as unref, _ as __, b as createVNode, w as withDirectives, v as vModelText, h as withCtx, r as ref, i as computed, j as _export_sfc, k as watch, T as Transition, l as Teleport, m as withModifiers, F as Fragment, p as renderList, q as getWidgetSupportForType, s as reactive, o as onMounted, x as onBeforeUnmount, y as useRoute, d as useRouter } from "../custom-dashboard.js";
import { u as useCustomViewsStore, d as draggable, c as customDashboardAPI, V as ViewNavigation, _ as _sfc_main$5, a as _sfc_main$6, b as _sfc_main$7, A as AuthModal, R as ReAuthModal, E as ErrorModal, e as useAuthGate, f as _sfc_main$8 } from "./useAuthGate-B6lyRC98.js";
import { I as Icon, b as useLicenseStore, u as useFeatureGate, U as UpsellModal, a as useSampleData } from "./useSampleData-DjRjarai.js";
const _hoisted_1$4 = { class: "exactmetrics-widget-item__name" };
const _sfc_main$4 = {
  __name: "WidgetItem",
  props: {
    widget: {
      type: Object,
      required: true
    }
  },
  emits: ["drag"],
  setup(__props, { emit: __emit }) {
    const emit = __emit;
    function handleDragStart(event) {
      emit("drag", event);
    }
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(["exactmetrics-widget-item", {
          "exactmetrics-widget-item--selected": __props.widget.selected
        }]),
        draggable: "true",
        onDragstart: handleDragStart
      }, [
        __props.widget.icon ? (openBlock(), createBlock(Icon, {
          key: 0,
          name: __props.widget.icon,
          size: 16
        }, null, 8, ["name"])) : createCommentVNode("", true),
        createBaseVNode("span", _hoisted_1$4, toDisplayString(__props.widget.name), 1)
      ], 34);
    };
  }
};
const _hoisted_1$3 = ["aria-label", "title"];
const _hoisted_2$3 = { class: "exactmetrics-widget-sidebar__content" };
const _hoisted_3$3 = {
  key: 0,
  class: "exactmetrics-widget-search"
};
const _hoisted_4$3 = ["placeholder"];
const _hoisted_5$2 = { class: "exactmetrics-widget-sections" };
const _hoisted_6$2 = {
  key: 0,
  class: "exactmetrics-widget-group"
};
const _hoisted_7$2 = { class: "exactmetrics-widget-group__title" };
const _hoisted_8$2 = {
  key: 1,
  class: "exactmetrics-widget-group"
};
const _hoisted_9$2 = { class: "exactmetrics-widget-group__title" };
const _hoisted_10$2 = {
  key: 2,
  class: "exactmetrics-widget-group"
};
const _hoisted_11$1 = { class: "exactmetrics-widget-group__title" };
const _hoisted_12$1 = {
  key: 3,
  class: "exactmetrics-widget-group"
};
const _hoisted_13 = { class: "exactmetrics-widget-group__title" };
const _sfc_main$3 = {
  __name: "WidgetsSidebar",
  setup(__props) {
    const store = useCustomViewsStore();
    const licenseStore = useLicenseStore();
    const isLite = computed(() => licenseStore.activeLicenseType === "Lite" || !licenseStore.activeLicenseType);
    const searchQuery = ref("");
    const isCollapsed = ref(false);
    function toggleCollapse() {
      isCollapsed.value = !isCollapsed.value;
    }
    const keyMetricsWidgets = computed(() => {
      return Object.entries(store.widgetMetadata).filter(([_, widget]) => widget.category === __("Key Metrics", "google-analytics-dashboard-for-wp")).map(([type, widget]) => ({
        id: type,
        name: widget.title,
        icon: widget.icon || "icons/datetime"
      }));
    });
    const trafficSourceWidgets = computed(() => {
      return Object.entries(store.widgetMetadata).filter(([_, widget]) => widget.category === __("Traffic Source", "google-analytics-dashboard-for-wp")).map(([type, widget]) => ({
        id: type,
        name: widget.title,
        icon: widget.icon || "icons/page-search"
      }));
    });
    const customDimensionWidgets = computed(() => {
      return Object.entries(store.widgetMetadata).filter(([_, widget]) => widget.category === __("Custom Dimensions", "google-analytics-dashboard-for-wp")).map(([type, widget]) => ({
        id: type,
        name: widget.title,
        icon: widget.icon || "icons/category"
      }));
    });
    const trafficWidgets = computed(() => {
      return Object.entries(store.widgetMetadata).filter(([_, widget]) => widget.category === __("Traffic", "google-analytics-dashboard-for-wp")).map(([type, widget]) => ({
        id: type,
        name: widget.title,
        icon: widget.icon || "icons/web-asset"
      }));
    });
    const filteredKeyMetricsWidgets = computed(
      () => keyMetricsWidgets.value.filter(
        (widget) => widget.name.toLowerCase().includes(searchQuery.value.toLowerCase())
      )
    );
    const filteredTrafficSourceWidgets = computed(
      () => trafficSourceWidgets.value.filter(
        (widget) => widget.name.toLowerCase().includes(searchQuery.value.toLowerCase())
      )
    );
    const filteredCustomDimensionWidgets = computed(
      () => customDimensionWidgets.value.filter(
        (widget) => widget.name.toLowerCase().includes(searchQuery.value.toLowerCase())
      )
    );
    const filteredTrafficWidgets = computed(
      () => trafficWidgets.value.filter(
        (widget) => widget.name.toLowerCase().includes(searchQuery.value.toLowerCase())
      )
    );
    function cloneWidget(widget) {
      const widgetType = widget.id;
      const widgetMeta = store.getWidgetByType(widgetType);
      const widgetTitle = widgetMeta?.title || widgetType;
      const widgetDefaults = widgetMeta?.defaults || {};
      const { type: _, ...apiDefaults } = widgetDefaults;
      const defaultDisplayType = widgetDefaults.type || "infobox";
      let defaultHeight = 1;
      if (defaultDisplayType === "table") {
        defaultHeight = 3;
      } else if (defaultDisplayType === "line-chart" || defaultDisplayType === "bar-chart" || defaultDisplayType === "pie-chart") {
        defaultHeight = 2;
      }
      const widgetInstance = {
        ...widget,
        id: `${widgetType}-${Date.now()}`,
        type: widgetType,
        // This is the widget data type (e.g., 'active-users')
        title: widgetTitle,
        displayType: defaultDisplayType,
        // Set the UI display type from widget defaults
        ...apiDefaults,
        // Spread only API-related defaults (metrics, dimensions, etc.)
        position: { x: 0, y: 0, w: 1, h: defaultHeight }
      };
      return widgetInstance;
    }
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(["exactmetrics-widget-sidebar", { "exactmetrics-widget-sidebar--collapsed": isCollapsed.value }])
      }, [
        createBaseVNode("button", {
          class: "exactmetrics-widget-sidebar__toggle",
          "aria-label": isCollapsed.value ? unref(__)("Expand sidebar", "google-analytics-dashboard-for-wp") : unref(__)("Collapse sidebar", "google-analytics-dashboard-for-wp"),
          title: isCollapsed.value ? unref(__)("Expand sidebar", "google-analytics-dashboard-for-wp") : unref(__)("Collapse sidebar", "google-analytics-dashboard-for-wp"),
          onClick: toggleCollapse
        }, [
          (openBlock(), createElementBlock("svg", {
            class: normalizeClass(["exactmetrics-widget-sidebar__toggle-icon", { "exactmetrics-widget-sidebar__toggle-icon--collapsed": isCollapsed.value }]),
            width: "8",
            height: "14",
            viewBox: "0 0 8 14",
            fill: "none",
            xmlns: "http://www.w3.org/2000/svg"
          }, [..._cache[1] || (_cache[1] = [
            createBaseVNode("path", {
              d: "M1 1L7 7L1 13",
              stroke: "currentColor",
              "stroke-width": "2",
              "stroke-linecap": "round",
              "stroke-linejoin": "round"
            }, null, -1)
          ])], 2))
        ], 8, _hoisted_1$3),
        createBaseVNode("div", _hoisted_2$3, [
          !isLite.value ? (openBlock(), createElementBlock("div", _hoisted_3$3, [
            createVNode(Icon, {
              name: "search",
              size: 20
            }),
            withDirectives(createBaseVNode("input", {
              "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => searchQuery.value = $event),
              type: "text",
              placeholder: unref(__)("Search Widget", "google-analytics-dashboard-for-wp")
            }, null, 8, _hoisted_4$3), [
              [vModelText, searchQuery.value]
            ])
          ])) : createCommentVNode("", true),
          createBaseVNode("div", _hoisted_5$2, [
            filteredKeyMetricsWidgets.value.length ? (openBlock(), createElementBlock("div", _hoisted_6$2, [
              createBaseVNode("h3", _hoisted_7$2, toDisplayString(unref(__)("Key Metrics", "google-analytics-dashboard-for-wp")), 1),
              createVNode(unref(draggable), {
                "model-value": filteredKeyMetricsWidgets.value,
                "item-key": "id",
                class: "exactmetrics-widget-group__items",
                group: { name: "widgets", pull: "clone", put: false },
                sort: false,
                clone: cloneWidget
              }, {
                item: withCtx(({ element: widget }) => [
                  createVNode(_sfc_main$4, { widget }, null, 8, ["widget"])
                ]),
                _: 1
              }, 8, ["model-value"])
            ])) : createCommentVNode("", true),
            filteredTrafficSourceWidgets.value.length ? (openBlock(), createElementBlock("div", _hoisted_8$2, [
              createBaseVNode("h3", _hoisted_9$2, toDisplayString(unref(__)("Traffic Source", "google-analytics-dashboard-for-wp")), 1),
              createVNode(unref(draggable), {
                "model-value": filteredTrafficSourceWidgets.value,
                "item-key": "id",
                class: "exactmetrics-widget-group__items",
                group: { name: "widgets", pull: "clone", put: false },
                sort: false,
                clone: cloneWidget
              }, {
                item: withCtx(({ element: widget }) => [
                  createVNode(_sfc_main$4, { widget }, null, 8, ["widget"])
                ]),
                _: 1
              }, 8, ["model-value"])
            ])) : createCommentVNode("", true),
            filteredCustomDimensionWidgets.value.length ? (openBlock(), createElementBlock("div", _hoisted_10$2, [
              createBaseVNode("h3", _hoisted_11$1, toDisplayString(unref(__)("Custom Dimensions", "google-analytics-dashboard-for-wp")), 1),
              createVNode(unref(draggable), {
                "model-value": filteredCustomDimensionWidgets.value,
                "item-key": "id",
                class: "exactmetrics-widget-group__items",
                group: { name: "widgets", pull: "clone", put: false },
                sort: false,
                clone: cloneWidget
              }, {
                item: withCtx(({ element: widget }) => [
                  createVNode(_sfc_main$4, { widget }, null, 8, ["widget"])
                ]),
                _: 1
              }, 8, ["model-value"])
            ])) : createCommentVNode("", true),
            filteredTrafficWidgets.value.length ? (openBlock(), createElementBlock("div", _hoisted_12$1, [
              createBaseVNode("h3", _hoisted_13, toDisplayString(unref(__)("Traffic", "google-analytics-dashboard-for-wp")), 1),
              createVNode(unref(draggable), {
                "model-value": filteredTrafficWidgets.value,
                "item-key": "id",
                class: "exactmetrics-widget-group__items",
                group: { name: "widgets", pull: "clone", put: false },
                sort: false,
                clone: cloneWidget
              }, {
                item: withCtx(({ element: widget }) => [
                  createVNode(_sfc_main$4, { widget }, null, 8, ["widget"])
                ]),
                _: 1
              }, 8, ["model-value"])
            ])) : createCommentVNode("", true)
          ])
        ])
      ], 2);
    };
  }
};
const _hoisted_1$2 = { class: "exactmetrics-modal-content" };
const _hoisted_2$2 = { class: "exactmetrics-modal-header" };
const _hoisted_3$2 = ["aria-label"];
const _hoisted_4$2 = ["aria-label"];
const _hoisted_5$1 = { class: "exactmetrics-modal-body" };
const _hoisted_6$1 = { class: "exactmetrics-radio-label" };
const _hoisted_7$1 = ["value", "checked", "disabled", "onChange"];
const _hoisted_8$1 = { class: "exactmetrics-radio-text" };
const _hoisted_9$1 = { class: "exactmetrics-checkbox-label" };
const _hoisted_10$1 = ["value", "checked", "disabled", "onChange"];
const _hoisted_11 = { class: "exactmetrics-checkbox-text" };
const _hoisted_12 = { class: "exactmetrics-modal-footer" };
const _sfc_main$2 = {
  __name: "EditMetricsModal",
  props: {
    isOpen: {
      type: Boolean,
      default: false
    },
    widget: {
      type: Object,
      default: null
    },
    widgetMetadata: {
      type: Object,
      default: null
    }
  },
  emits: ["close", "apply"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const selectedMetrics = ref([]);
    watch(() => props.widget, (newWidget) => {
      if (newWidget && newWidget.metrics) {
        selectedMetrics.value = [...newWidget.metrics];
      } else if (newWidget) {
        selectedMetrics.value = [];
      }
    }, { immediate: true });
    const currentDisplayType = computed(() => {
      return props.widget?.displayType || props.widgetMetadata?.defaults?.type || "infobox";
    });
    const isSingleSelection = computed(() => {
      const selectionConfig = props.widgetMetadata?.support?.metricSelection;
      if (!selectionConfig) return false;
      const displayType = currentDisplayType.value;
      if (typeof selectionConfig === "object" && !Array.isArray(selectionConfig)) {
        return selectionConfig[displayType] === "single";
      }
      return selectionConfig === "single";
    });
    const availableMetrics = computed(() => {
      if (!props.widgetMetadata || !props.widgetMetadata.support) {
        return [];
      }
      const typeSupport = getWidgetSupportForType(props.widgetMetadata.support, currentDisplayType.value);
      const supportedMetrics = typeSupport.metrics;
      const metricLabels = {
        "sessions": __("Sessions", "google-analytics-dashboard-for-wp"),
        "activeUsers": __("Users", "google-analytics-dashboard-for-wp"),
        "screenPageViews": __("Views", "google-analytics-dashboard-for-wp"),
        "engagementRate": __("Engagement Rate", "google-analytics-dashboard-for-wp"),
        "engagedSessions": __("Engaged Sessions", "google-analytics-dashboard-for-wp"),
        "conversions": __("Conversions", "google-analytics-dashboard-for-wp"),
        "conversionRate": __("Conversion Rate", "google-analytics-dashboard-for-wp"),
        "totalRevenue": __("Revenue", "google-analytics-dashboard-for-wp"),
        "bounceRate": __("Bounce Rate", "google-analytics-dashboard-for-wp"),
        "averageSessionDuration": __("Avg Session Duration", "google-analytics-dashboard-for-wp"),
        "newUsers": __("New Users", "google-analytics-dashboard-for-wp"),
        "transactions": __("Purchases", "google-analytics-dashboard-for-wp")
      };
      return supportedMetrics.map((metric) => ({
        value: metric,
        label: metricLabels[metric] || metric,
        disabled: false
        // TODO: Add logic for pro metrics if needed
      }));
    });
    function isMetricSelected(metricValue) {
      return selectedMetrics.value.includes(metricValue);
    }
    function selectMetric(metricValue) {
      selectedMetrics.value = [metricValue];
    }
    function toggleMetric(metricValue) {
      const index = selectedMetrics.value.indexOf(metricValue);
      if (index > -1) {
        selectedMetrics.value.splice(index, 1);
      } else {
        selectedMetrics.value.push(metricValue);
      }
    }
    function handleCancel() {
      emit("close");
    }
    function handleApply() {
      emit("apply", {
        widgetId: props.widget.id,
        metrics: selectedMetrics.value
      });
      emit("close");
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(Teleport, { to: "body" }, [
        createVNode(Transition, { name: "modal-fade" }, {
          default: withCtx(() => [
            __props.isOpen ? (openBlock(), createElementBlock("div", {
              key: 0,
              class: "exactmetrics-modal-overlay",
              onClick: withModifiers(handleCancel, ["self"])
            }, [
              createBaseVNode("div", _hoisted_1$2, [
                createBaseVNode("div", _hoisted_2$2, [
                  createBaseVNode("button", {
                    class: "exactmetrics-modal-back",
                    onClick: handleCancel,
                    "aria-label": unref(__)("Back", "google-analytics-dashboard-for-wp")
                  }, [
                    createVNode(Icon, {
                      name: "dashicons-arrow-left-alt2",
                      size: 16
                    })
                  ], 8, _hoisted_3$2),
                  createBaseVNode("h3", null, toDisplayString(unref(__)("Customize Metrics", "google-analytics-dashboard-for-wp")), 1),
                  createBaseVNode("button", {
                    class: "exactmetrics-modal-close",
                    onClick: handleCancel,
                    "aria-label": unref(__)("Close", "google-analytics-dashboard-for-wp")
                  }, [
                    createVNode(Icon, {
                      name: "close",
                      size: 16
                    })
                  ], 8, _hoisted_4$2)
                ]),
                _cache[0] || (_cache[0] = createBaseVNode("div", { class: "exactmetrics-modal-divider" }, null, -1)),
                createBaseVNode("div", _hoisted_5$1, [
                  isSingleSelection.value ? (openBlock(true), createElementBlock(Fragment, { key: 0 }, renderList(availableMetrics.value, (metric) => {
                    return openBlock(), createElementBlock("div", {
                      key: metric.value,
                      class: normalizeClass(["exactmetrics-metric-option", { "exactmetrics-metric-option--disabled": metric.disabled }])
                    }, [
                      createBaseVNode("label", _hoisted_6$1, [
                        createBaseVNode("input", {
                          type: "radio",
                          value: metric.value,
                          checked: isMetricSelected(metric.value),
                          disabled: metric.disabled,
                          onChange: ($event) => selectMetric(metric.value),
                          class: "exactmetrics-radio",
                          name: "metric-selection"
                        }, null, 40, _hoisted_7$1),
                        createBaseVNode("span", _hoisted_8$1, toDisplayString(metric.label), 1)
                      ])
                    ], 2);
                  }), 128)) : (openBlock(true), createElementBlock(Fragment, { key: 1 }, renderList(availableMetrics.value, (metric) => {
                    return openBlock(), createElementBlock("div", {
                      key: metric.value,
                      class: normalizeClass(["exactmetrics-metric-option", { "exactmetrics-metric-option--disabled": metric.disabled }])
                    }, [
                      createBaseVNode("label", _hoisted_9$1, [
                        createBaseVNode("input", {
                          type: "checkbox",
                          value: metric.value,
                          checked: isMetricSelected(metric.value),
                          disabled: metric.disabled,
                          onChange: ($event) => toggleMetric(metric.value),
                          class: "exactmetrics-checkbox"
                        }, null, 40, _hoisted_10$1),
                        createBaseVNode("span", _hoisted_11, toDisplayString(metric.label), 1)
                      ])
                    ], 2);
                  }), 128))
                ]),
                createBaseVNode("div", _hoisted_12, [
                  createBaseVNode("button", {
                    class: "exactmetrics-button exactmetrics-button--secondary",
                    onClick: handleCancel
                  }, toDisplayString(unref(__)("Cancel", "google-analytics-dashboard-for-wp")), 1),
                  createBaseVNode("button", {
                    class: "exactmetrics-button exactmetrics-button--primary",
                    onClick: handleApply
                  }, toDisplayString(unref(__)("Apply", "google-analytics-dashboard-for-wp")), 1)
                ])
              ])
            ])) : createCommentVNode("", true)
          ]),
          _: 1
        })
      ]);
    };
  }
};
const EditMetricsModal = /* @__PURE__ */ _export_sfc(_sfc_main$2, [["__scopeId", "data-v-c618694f"]]);
const _hoisted_1$1 = { class: "exactmetrics-modal-content" };
const _hoisted_2$1 = { class: "exactmetrics-modal-header" };
const _hoisted_3$1 = ["aria-label"];
const _hoisted_4$1 = ["aria-label"];
const _hoisted_5 = { class: "exactmetrics-modal-body" };
const _hoisted_6 = { class: "exactmetrics-modal-description" };
const _hoisted_7 = { class: "exactmetrics-radio-label" };
const _hoisted_8 = ["value", "checked", "onChange"];
const _hoisted_9 = { class: "exactmetrics-radio-text" };
const _hoisted_10 = { class: "exactmetrics-modal-footer" };
const _sfc_main$1 = {
  __name: "EditDimensionsModal",
  props: {
    isOpen: {
      type: Boolean,
      default: false
    },
    widget: {
      type: Object,
      default: null
    },
    widgetMetadata: {
      type: Object,
      default: null
    }
  },
  emits: ["close", "apply"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const selectedDimension = ref("");
    watch(() => props.widget, (newWidget) => {
      if (newWidget && newWidget.dimensions && newWidget.dimensions.length > 0) {
        selectedDimension.value = newWidget.dimensions[0];
      } else if (props.widgetMetadata?.defaults?.dimensions) {
        selectedDimension.value = props.widgetMetadata.defaults.dimensions[0];
      }
    }, { immediate: true });
    const availableDimensions = computed(() => {
      if (!props.widgetMetadata) return [];
      const displayType = props.widget?.displayType || props.widgetMetadata.defaults?.type || "table";
      const typeSupport = getWidgetSupportForType(props.widgetMetadata.support, displayType);
      const supportedDimensions = typeSupport.dimensions || [];
      const dimensionLabels = {
        "sessionSource": __("Source", "google-analytics-dashboard-for-wp"),
        "sessionMedium": __("Medium", "google-analytics-dashboard-for-wp"),
        "sessionDefaultChannelGrouping": __("Channel Grouping", "google-analytics-dashboard-for-wp"),
        "country": __("Country", "google-analytics-dashboard-for-wp"),
        "city": __("City", "google-analytics-dashboard-for-wp"),
        "region": __("Region", "google-analytics-dashboard-for-wp"),
        "deviceCategory": __("Device Category", "google-analytics-dashboard-for-wp"),
        "browser": __("Browser", "google-analytics-dashboard-for-wp"),
        "operatingSystem": __("Operating System", "google-analytics-dashboard-for-wp"),
        "pagePath": __("Page Path", "google-analytics-dashboard-for-wp"),
        "pageTitle": __("Page Title", "google-analytics-dashboard-for-wp"),
        "landingPage": __("Landing Page", "google-analytics-dashboard-for-wp"),
        "eventName": __("Event Name", "google-analytics-dashboard-for-wp"),
        "date": __("Date", "google-analytics-dashboard-for-wp"),
        // SEO Score dimensions
        "customEvent:seo_score": __("SEO Score (Generic)", "google-analytics-dashboard-for-wp"),
        "customEvent:aioseo_truseo_score": __("All in One SEO (TruSEO Score)", "google-analytics-dashboard-for-wp"),
        "customEvent:yoast_seo_score": __("Yoast SEO Score", "google-analytics-dashboard-for-wp"),
        "customEvent:rankmath_seo_score": __("Rank Math SEO Score", "google-analytics-dashboard-for-wp")
      };
      return supportedDimensions.map((dim) => ({
        value: dim,
        label: dimensionLabels[dim] || dim
      }));
    });
    function selectDimension(dimension) {
      selectedDimension.value = dimension;
    }
    function handleCancel() {
      emit("close");
    }
    function handleApply() {
      emit("apply", [selectedDimension.value]);
      emit("close");
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(Teleport, { to: "body" }, [
        createVNode(Transition, { name: "modal-fade" }, {
          default: withCtx(() => [
            __props.isOpen ? (openBlock(), createElementBlock("div", {
              key: 0,
              class: "exactmetrics-modal-overlay",
              onClick: withModifiers(handleCancel, ["self"])
            }, [
              createBaseVNode("div", _hoisted_1$1, [
                createBaseVNode("div", _hoisted_2$1, [
                  createBaseVNode("button", {
                    class: "exactmetrics-modal-back",
                    onClick: handleCancel,
                    "aria-label": unref(__)("Back", "google-analytics-dashboard-for-wp")
                  }, [
                    createVNode(Icon, {
                      name: "dashicons-arrow-left-alt2",
                      size: 16
                    })
                  ], 8, _hoisted_3$1),
                  createBaseVNode("h3", null, toDisplayString(unref(__)("Customize Breakdown", "google-analytics-dashboard-for-wp")), 1),
                  createBaseVNode("button", {
                    class: "exactmetrics-modal-close",
                    onClick: handleCancel,
                    "aria-label": unref(__)("Close", "google-analytics-dashboard-for-wp")
                  }, [
                    createVNode(Icon, {
                      name: "close",
                      size: 16
                    })
                  ], 8, _hoisted_4$1)
                ]),
                _cache[0] || (_cache[0] = createBaseVNode("div", { class: "exactmetrics-modal-divider" }, null, -1)),
                createBaseVNode("div", _hoisted_5, [
                  createBaseVNode("p", _hoisted_6, toDisplayString(unref(__)("Select how you want to break down your data:", "google-analytics-dashboard-for-wp")), 1),
                  (openBlock(true), createElementBlock(Fragment, null, renderList(availableDimensions.value, (dimension) => {
                    return openBlock(), createElementBlock("div", {
                      key: dimension.value,
                      class: "exactmetrics-dimension-option"
                    }, [
                      createBaseVNode("label", _hoisted_7, [
                        createBaseVNode("input", {
                          type: "radio",
                          value: dimension.value,
                          checked: selectedDimension.value === dimension.value,
                          onChange: ($event) => selectDimension(dimension.value),
                          class: "exactmetrics-radio",
                          name: "dimension"
                        }, null, 40, _hoisted_8),
                        createBaseVNode("span", _hoisted_9, toDisplayString(dimension.label), 1)
                      ])
                    ]);
                  }), 128))
                ]),
                createBaseVNode("div", _hoisted_10, [
                  createBaseVNode("button", {
                    class: "exactmetrics-button exactmetrics-button--secondary",
                    onClick: handleCancel
                  }, toDisplayString(unref(__)("Cancel", "google-analytics-dashboard-for-wp")), 1),
                  createBaseVNode("button", {
                    class: "exactmetrics-button exactmetrics-button--primary",
                    onClick: handleApply
                  }, toDisplayString(unref(__)("Apply", "google-analytics-dashboard-for-wp")), 1)
                ])
              ])
            ])) : createCommentVNode("", true)
          ]),
          _: 1
        })
      ]);
    };
  }
};
const EditDimensionsModal = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["__scopeId", "data-v-d90f910b"]]);
const _hoisted_1 = { class: "exactmetrics-dashboard-create" };
const _hoisted_2 = { class: "exactmetrics-page-header" };
const _hoisted_3 = ["title"];
const _hoisted_4 = {
  key: 0,
  class: "exactmetrics-saving-overlay"
};
const _sfc_main = {
  __name: "DashboardCreate",
  setup(__props) {
    const router = useRouter();
    const route = useRoute();
    const store = useCustomViewsStore();
    const {
      hasAccess,
      isSampleMode,
      shouldBlurContent,
      shouldShowUpsell,
      upsellContent,
      hasSampleData,
      openUpsellModal,
      closeUpsellModal,
      enableSampleMode
    } = useFeatureGate("custom-dashboard");
    const {
      isAuthenticated,
      showAuthModal,
      showReAuthModal,
      shouldBlurContent: shouldBlurForAuth,
      openAuthModal,
      closeAuthModal
    } = useAuthGate();
    const { sampleData, loadSampleData } = useSampleData("custom-dashboard", "widgets-data");
    const { sampleData: sampleViewData, loadSampleData: loadSampleView } = useSampleData("custom-dashboard", "sample-view");
    const isDirty = ref(false);
    const autoSaveStatus = ref("saved");
    const widgets = reactive([]);
    const dateRange = reactive(getDefaultDateRange());
    const lastSavedLayoutSnapshot = ref("");
    function getLayoutSnapshot() {
      return JSON.stringify(
        widgets.map((widget, index) => ({
          id: widget?.id,
          type: widget?.type,
          displayType: widget?.displayType,
          title: widget?.title,
          position: {
            x: index % 3,
            y: Math.floor(index / 3),
            w: widget?.position?.w || 1
          },
          metrics: widget?.metrics,
          dimensions: widget?.dimensions,
          compare: widget?.compare,
          extendedView: widget?.extendedView
        }))
      );
    }
    function updateLayoutSnapshot() {
      lastSavedLayoutSnapshot.value = getLayoutSnapshot();
    }
    function hasLayoutChanged() {
      return getLayoutSnapshot() !== lastSavedLayoutSnapshot.value;
    }
    watch(
      widgets,
      () => {
        isDirty.value = true;
        autoSaveStatus.value = "unsaved";
        debounceSave();
      },
      { deep: true }
    );
    let debounceTimer = null;
    const debounceSave = () => {
      clearTimeout(debounceTimer);
      debounceTimer = setTimeout(() => {
        saveView();
      }, 100);
    };
    function handleWidgetsUpdate(newWidgets) {
      widgets.length = 0;
      widgets.push(...newWidgets);
    }
    const widgetData = reactive({});
    const widgetLoadingStates = reactive({});
    const currentView = computed(() => {
      if (isSampleMode.value && sampleViewData.value?.[0]) {
        return sampleViewData.value[0];
      }
      return store.currentView;
    });
    const allViews = computed(() => {
      if (isSampleMode.value && sampleViewData.value) {
        return sampleViewData.value;
      }
      return store.allViews;
    });
    const displayWidgetData = computed(() => {
      if (isSampleMode.value && sampleData.value?.widgets) {
        return sampleData.value.widgets;
      }
      return widgetData;
    });
    const dateRangeModel = computed({
      get() {
        return dateRange;
      },
      set(value) {
        Object.assign(dateRange, value);
      }
    });
    const isAnyWidgetLoading = computed(() => store.isLoading);
    onMounted(async () => {
      if (!isAuthenticated.value) {
        openAuthModal();
        return;
      }
      if (!hasAccess.value) {
        openUpsellModal();
        await Promise.all([
          loadSampleData(),
          loadSampleView(),
          store.loadWidgetMetadata()
          // Load widget metadata for sidebar
        ]);
        return;
      }
      store.setLoading(true);
      try {
        await Promise.all([
          store.loadViews(),
          store.loadWidgetMetadata()
        ]);
        await loadDashboard(route.params.id);
      } catch (err) {
        console.error("Error during initial load:", err);
        store.setLoading(false);
      }
    });
    async function handleSeeSample() {
      enableSampleMode();
      if (sampleViewData.value?.[0]?.layout) {
        widgets.length = 0;
        const sortedLayout = [...sampleViewData.value[0].layout].sort(
          (a, b) => a.position.y * 3 + a.position.x - (b.position.y * 3 + b.position.x)
        );
        widgets.push(...sortedLayout);
        updateLayoutSnapshot();
      }
    }
    watch(() => route.params.id, (newId, oldId) => {
      if (newId !== oldId) {
        loadDashboard(newId);
      }
    });
    async function loadDashboard(viewId) {
      if (!hasAccess.value) {
        return;
      }
      store.setLoading(true);
      try {
        widgets.length = 0;
        Object.keys(widgetData).forEach((key) => delete widgetData[key]);
        Object.keys(widgetLoadingStates).forEach((key) => delete widgetLoadingStates[key]);
        if (viewId) {
          await store.loadViewForEdit(viewId);
          if (store.currentView?.layout?.length) {
            const sortedLayout = [...store.currentView.layout].sort(
              (a, b) => a.position.y * 3 + a.position.x - (b.position.y * 3 + b.position.x)
            );
            widgets.push(...sortedLayout);
            updateLayoutSnapshot();
            await fetchAllWidgetsData();
          } else {
            store.setLoading(false);
          }
        } else {
          const templateId = route.query.template;
          const title = templateId ? getTemplateTitle(templateId) : "";
          store.createNewView(title);
          updateLayoutSnapshot();
          store.setLoading(false);
        }
      } catch (err) {
        console.error("Error loading dashboard:", err);
        store.setLoading(false);
      }
    }
    onBeforeUnmount(() => {
      if (isDirty.value) ;
    });
    function getTemplateTitle(templateId) {
      const templates = {
        "blank": __("Blank Dashboard", "google-analytics-dashboard-for-wp"),
        "ecommerce": __("eCommerce Dashboard", "google-analytics-dashboard-for-wp"),
        "small-business": __("Small Business Dashboard", "google-analytics-dashboard-for-wp"),
        "publisher": __("Publisher Dashboard", "google-analytics-dashboard-for-wp"),
        "marketer": __("Marketer Dashboard", "google-analytics-dashboard-for-wp")
      };
      return templates[templateId] || __("My Custom View", "google-analytics-dashboard-for-wp");
    }
    async function onWidgetGridChange(event) {
      if (event.added) {
        const newWidget = event.added.element;
        if (newWidget) {
          await fetchWidgetData(newWidget);
        }
      }
      isDirty.value = true;
      debounceSave();
    }
    async function fetchAllWidgetsData() {
      if (!widgets.length) {
        store.setLoading(false);
        return;
      }
      const BATCH_SIZE = 5;
      const batches = [];
      for (let i = 0; i < widgets.length; i += BATCH_SIZE) {
        batches.push(widgets.slice(i, i + BATCH_SIZE));
      }
      store.setLoading(true);
      widgets.forEach((widget) => {
        if (widget && widget.id) {
          widgetLoadingStates[widget.id] = true;
        }
      });
      store.clearError();
      for (let batchIndex = 0; batchIndex < batches.length; batchIndex++) {
        const batch = batches[batchIndex];
        try {
          const response = await customDashboardAPI.getDashboardData(batch, dateRange);
          const widgetsData = response?.widgets || response?.data?.widgets;
          const responseDateRange = response?.data?.date_range || response?.date_range;
          if (widgetsData) {
            Object.keys(widgetsData).forEach((widgetId) => {
              widgetData[widgetId] = {
                ...widgetsData[widgetId],
                dateRange: responseDateRange ? {
                  current: {
                    start: responseDateRange.start,
                    end: responseDateRange.end
                  },
                  previous: {
                    start: responseDateRange.compareStart || "",
                    end: responseDateRange.compareEnd || ""
                  }
                } : null
              };
            });
          }
          batch.forEach((widget) => {
            if (widget && widget.id) {
              widgetLoadingStates[widget.id] = false;
            }
          });
        } catch (error) {
          console.error(`Error fetching batch ${batchIndex + 1}:`, error);
          store.setError({
            title: __("Error Loading Data", "google-analytics-dashboard-for-wp"),
            message: error.message || __("Failed to load dashboard data", "google-analytics-dashboard-for-wp")
          });
          const remainingWidgets = batches.slice(batchIndex).flat();
          remainingWidgets.forEach((widget) => {
            if (widget && widget.id) {
              widgetData[widget.id] = { error: true, message: error.message };
              widgetLoadingStates[widget.id] = false;
            }
          });
          break;
        }
        if (batchIndex < batches.length - 1) {
          await new Promise((resolve) => setTimeout(resolve, 300));
        }
      }
      store.setLoading(false);
    }
    async function fetchWidgetData(widget) {
      if (!widget || !widget.id) return;
      store.setLoading(true);
      widgetLoadingStates[widget.id] = true;
      try {
        const response = await customDashboardAPI.getDashboardData([widget], dateRange);
        const widgetsData = response?.widgets || response?.data?.widgets;
        const responseDateRange = response?.data?.date_range || response?.date_range;
        if (widgetsData && widgetsData[widget.id]) {
          widgetData[widget.id] = {
            ...widgetsData[widget.id],
            dateRange: responseDateRange ? {
              current: {
                start: responseDateRange.start,
                end: responseDateRange.end
              },
              previous: {
                start: responseDateRange.compareStart || "",
                end: responseDateRange.compareEnd || ""
              }
            } : null
          };
        }
      } catch (error) {
        console.error(`Error fetching data for widget ${widget.id}:`, error);
        widgetData[widget.id] = { error: true, message: error.message };
      } finally {
        widgetLoadingStates[widget.id] = false;
        store.setLoading(false);
      }
    }
    function getDefaultDateRange() {
      const end = /* @__PURE__ */ new Date();
      const start = /* @__PURE__ */ new Date();
      start.setDate(start.getDate() - 30);
      return {
        start: start.toISOString().split("T")[0],
        end: end.toISOString().split("T")[0],
        compareStart: "",
        compareEnd: "",
        interval: "last30days",
        compareReport: false,
        text: "",
        compareText: "",
        intervalText: "",
        intervalCompareText: ""
      };
    }
    async function handleDateChanged() {
      await fetchAllWidgetsData();
    }
    function removeWidget(widgetId) {
      const widgetIndex = widgets.findIndex((widget) => widget?.id === widgetId);
      if (widgetIndex !== -1) {
        widgets.splice(widgetIndex, 1);
        delete widgetData[widgetId];
        delete widgetLoadingStates[widgetId];
        isDirty.value = true;
      }
    }
    const isEditMetricsModalOpen = ref(false);
    const selectedWidgetForEdit = ref(null);
    const selectedWidgetMetadata = computed(() => {
      if (!selectedWidgetForEdit.value) return null;
      return store.getWidgetByType(selectedWidgetForEdit.value.type);
    });
    function configureWidget(widgetId) {
      const widget = widgets.find((w) => w?.id === widgetId);
      if (widget) {
        selectedWidgetForEdit.value = widget;
        isEditMetricsModalOpen.value = true;
      }
    }
    function closeEditMetricsModal() {
      isEditMetricsModalOpen.value = false;
      selectedWidgetForEdit.value = null;
    }
    function handleApplyMetrics({ widgetId, metrics }) {
      const widgetIndex = widgets.findIndex((widget) => widget?.id === widgetId);
      if (widgetIndex !== -1 && widgets[widgetIndex]) {
        widgets[widgetIndex].metrics = metrics;
        isDirty.value = true;
        debounceSave();
        fetchWidgetData(widgets[widgetIndex]);
      }
    }
    const isEditDimensionsModalOpen = ref(false);
    function configureDimensions(widgetId) {
      const widget = widgets.find((w) => w?.id === widgetId);
      if (widget) {
        selectedWidgetForEdit.value = widget;
        isEditDimensionsModalOpen.value = true;
      }
    }
    function closeEditDimensionsModal() {
      isEditDimensionsModalOpen.value = false;
      selectedWidgetForEdit.value = null;
    }
    function handleApplyDimensions(dimensions) {
      if (!selectedWidgetForEdit.value) return;
      const widgetIndex = widgets.findIndex((widget) => widget?.id === selectedWidgetForEdit.value.id);
      if (widgetIndex !== -1 && widgets[widgetIndex]) {
        widgets[widgetIndex].dimensions = dimensions;
        isDirty.value = true;
        debounceSave();
        fetchWidgetData(widgets[widgetIndex]);
      }
    }
    function handleToggleChart({ widgetId, chartType }) {
      const widgetIndex = widgets.findIndex((widget) => widget?.id === widgetId);
      if (widgetIndex !== -1 && widgets[widgetIndex]) {
        widgets[widgetIndex].displayType = chartType;
        if (!widgets[widgetIndex].position) {
          widgets[widgetIndex].position = { x: 0, y: 0, w: 1 };
        }
        isDirty.value = true;
        debounceSave();
        fetchWidgetData(widgets[widgetIndex]);
      }
    }
    function handleWidgetResize({ widgetId, width }) {
      const widgetIndex = widgets.findIndex((widget) => widget?.id === widgetId);
      if (widgetIndex !== -1 && widgets[widgetIndex]) {
        if (!widgets[widgetIndex].position) {
          widgets[widgetIndex].position = { x: 0, y: 0, w: 1 };
        }
        widgets[widgetIndex].position.w = width;
        isDirty.value = true;
        debounceSave();
      }
    }
    function handleToggleExtendedView(widgetId) {
      const widgetIndex = widgets.findIndex((widget) => widget?.id === widgetId);
      if (widgetIndex !== -1 && widgets[widgetIndex]) {
        widgets[widgetIndex].extendedView = !widgets[widgetIndex].extendedView;
        isDirty.value = true;
        debounceSave();
      }
    }
    function handleToggleComparison(widgetId) {
      const widgetIndex = widgets.findIndex((widget) => widget?.id === widgetId);
      if (widgetIndex !== -1 && widgets[widgetIndex]) {
        widgets[widgetIndex].compare = !widgets[widgetIndex].compare;
        isDirty.value = true;
        debounceSave();
        fetchWidgetData(widgets[widgetIndex]);
      }
    }
    function handleRenameWidget({ widgetId, title }) {
      const widgetIndex = widgets.findIndex((widget) => widget?.id === widgetId);
      if (widgetIndex !== -1 && widgets[widgetIndex]) {
        widgets[widgetIndex].title = title;
        isDirty.value = true;
        debounceSave();
      }
    }
    async function saveView() {
      if (!hasAccess.value || !store.currentView) {
        return;
      }
      if (!hasLayoutChanged()) {
        autoSaveStatus.value = "saved";
        isDirty.value = false;
        return;
      }
      autoSaveStatus.value = "saving";
      try {
        const layout = widgets.map((widget, index) => {
          if (!widget) return null;
          const width = widget.position?.w || 1;
          return {
            ...widget,
            position: {
              x: index % 3,
              // Assuming 3 columns
              y: Math.floor(index / 3),
              w: width
              // Preserve widget width only, height is determined by widget type
            }
          };
        }).filter(Boolean);
        store.currentView.layout = layout;
        await store.saveCurrentView();
        isDirty.value = false;
        autoSaveStatus.value = "saved";
        updateLayoutSnapshot();
        if (route.name === "dashboard-create" && store.currentView?.id) {
          router.push({
            name: "dashboard-edit",
            params: { id: store.currentView.id }
          });
        }
      } catch (err) {
        console.error("Error saving view:", err);
        autoSaveStatus.value = "error";
      }
    }
    async function handleRenameView({ name }) {
      if (store.currentView) {
        store.currentView.title = name;
        isDirty.value = true;
        await saveView();
      }
    }
    function selectView(viewId) {
      if (viewId === "new") {
        router.push({ name: "dashboard-create" });
      } else {
        router.push({ name: "dashboard-view", params: { id: viewId } });
      }
    }
    function addNewView() {
      if (!hasAccess.value) {
        openUpsellModal();
        return;
      }
      router.push({ name: "dashboard-add" });
    }
    async function handleDeleteView(id) {
      try {
        await store.deleteView(id);
        const remainingViews = store.allViews;
        const baseUrl = window.exactmetrics.custom_dashboard_url;
        if (remainingViews.length > 0) {
          window.location.href = `${baseUrl}#/dashboards/edit/${remainingViews[0].id}`;
        } else {
          window.location.href = `${baseUrl}#/`;
        }
      } catch (err) {
        console.error("Error deleting view:", err);
      }
    }
    function handleCloseError() {
      store.clearError();
    }
    async function handleRetryLoad() {
      store.clearError();
      await fetchAllWidgetsData();
    }
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", _hoisted_1, [
        unref(isSampleMode) ? (openBlock(), createBlock(_sfc_main$8, {
          key: 0,
          feature: "custom-dashboard"
        })) : createCommentVNode("", true),
        createVNode(ViewNavigation, {
          "all-views": allViews.value,
          "current-view": currentView.value,
          "auto-save-status": autoSaveStatus.value,
          "is-new-view": !unref(route).params.id,
          "allow-reorder": true,
          onSelect: selectView,
          onRename: handleRenameView,
          onDelete: handleDeleteView,
          onAddNew: addNewView
        }, null, 8, ["all-views", "current-view", "auto-save-status", "is-new-view"]),
        createBaseVNode("div", {
          class: normalizeClass(["exactmetrics-dashboard-main-content", { "exactmetrics-dashboard-main-content--saving": autoSaveStatus.value === "saving" }])
        }, [
          createBaseVNode("div", {
            class: normalizeClass(["exactmetrics-dashboard-main", { "exactmetrics-content-blurred": unref(shouldBlurContent) || unref(shouldBlurForAuth) }])
          }, [
            createBaseVNode("div", _hoisted_2, [
              createBaseVNode("h1", null, toDisplayString(currentView.value?.title || unref(__)("New Dashboard", "google-analytics-dashboard-for-wp")), 1),
              createBaseVNode("div", {
                class: normalizeClass(["exactmetrics-page-header__actions", { "exactmetrics-page-header__actions--disabled": isAnyWidgetLoading.value }]),
                title: isAnyWidgetLoading.value ? unref(__)("Please wait while data is loading...", "google-analytics-dashboard-for-wp") : ""
              }, [
                createVNode(_sfc_main$5, {
                  "report-title": currentView.value?.title,
                  disabled: isAnyWidgetLoading.value
                }, null, 8, ["report-title", "disabled"]),
                createVNode(unref(_sfc_main$6), {
                  modelValue: dateRangeModel.value,
                  "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => dateRangeModel.value = $event),
                  disabled: isAnyWidgetLoading.value,
                  onDateChanged: handleDateChanged
                }, null, 8, ["modelValue", "disabled"])
              ], 10, _hoisted_3)
            ]),
            createVNode(_sfc_main$7, {
              ref: "widgetsGridRef",
              widgets,
              "widget-data": displayWidgetData.value,
              "widget-loading-states": widgetLoadingStates,
              "is-draggable": autoSaveStatus.value !== "saving" && !isAnyWidgetLoading.value,
              "onUpdate:widgets": handleWidgetsUpdate,
              onChange: onWidgetGridChange,
              onEnd: debounceSave,
              onRemove: removeWidget,
              onConfigure: configureWidget,
              onEditDimensions: configureDimensions,
              onToggleChart: handleToggleChart,
              onResize: handleWidgetResize,
              onToggleExtendedView: handleToggleExtendedView,
              onToggleComparison: handleToggleComparison,
              onRename: handleRenameWidget
            }, null, 8, ["widgets", "widget-data", "widget-loading-states", "is-draggable"])
          ], 2),
          createVNode(_sfc_main$3),
          autoSaveStatus.value === "saving" ? (openBlock(), createElementBlock("div", _hoisted_4, [..._cache[1] || (_cache[1] = [
            createBaseVNode("span", { class: "exactmetrics-saving-spinner" }, null, -1)
          ])])) : createCommentVNode("", true)
        ], 2),
        createVNode(AuthModal, {
          isOpen: unref(showAuthModal),
          onClose: unref(closeAuthModal)
        }, null, 8, ["isOpen", "onClose"]),
        createVNode(ReAuthModal, {
          isOpen: unref(showReAuthModal),
          onClose: unref(closeAuthModal)
        }, null, 8, ["isOpen", "onClose"]),
        createVNode(UpsellModal, {
          isOpen: unref(shouldShowUpsell),
          feature: "custom-dashboard",
          content: unref(upsellContent),
          showSampleButton: unref(hasSampleData),
          customImage: "sample-image-exactmetrics.png",
          onClose: unref(closeUpsellModal),
          onSeeSample: handleSeeSample
        }, null, 8, ["isOpen", "content", "showSampleButton", "onClose"]),
        createVNode(ErrorModal, {
          isOpen: !!unref(store).error,
          title: unref(store).error?.title || unref(__)("Error", "google-analytics-dashboard-for-wp"),
          message: unref(store).error?.message || unref(__)("An error occurred", "google-analytics-dashboard-for-wp"),
          onClose: handleCloseError,
          onRetry: handleRetryLoad
        }, null, 8, ["isOpen", "title", "message"]),
        createVNode(EditMetricsModal, {
          "is-open": isEditMetricsModalOpen.value,
          widget: selectedWidgetForEdit.value,
          "widget-metadata": selectedWidgetMetadata.value,
          onClose: closeEditMetricsModal,
          onApply: handleApplyMetrics
        }, null, 8, ["is-open", "widget", "widget-metadata"]),
        createVNode(EditDimensionsModal, {
          "is-open": isEditDimensionsModalOpen.value,
          widget: selectedWidgetForEdit.value,
          "widget-metadata": selectedWidgetMetadata.value,
          onClose: closeEditDimensionsModal,
          onApply: handleApplyDimensions
        }, null, 8, ["is-open", "widget", "widget-metadata"])
      ]);
    };
  }
};
export {
  _sfc_main as default
};
