<?php
/**
 * Custom Error class for ExactMetrics API responses.
 *
 * Extends WP_Error to provide a custom error object from API responses.
 *
 * @package ExactMetrics
 */
class ExactMetrics_API_Error extends WP_Error {
	/**
	 * Constructor.
	 *
	 * Creates a new WP_Error object from a ExactMetrics API error response.
	 *
	 *
	 * @param array $response_body The decoded JSON response body containing the error details.
	 */
	public function __construct( $response_body ) {
		$error_data = $response_body['error'];

		$code    = $error_data['code'];
		$message = $error_data['message'];
		$details = $error_data['details'];

		parent::__construct( $code, $message, $details );
	}

}