<?php

add_action('admin_enqueue_scripts', 'PTGold_init');
function PTGold_init()
{
    wp_enqueue_style(
        'Admin-style-Gold',
        PTGold_ASSETS_URL . 'css/admin-style-gold.css',
    );
}

add_filter('plugin_row_meta', 'PTGOLD_plugin_row_meta', 10, 2);
function PTGOLD_plugin_row_meta($links, $file)
{
    if ('gold-price-based-on-weight/gold-price.php' == $file) {
        $row_meta = array(
            'docs' => '<a href="' . esc_url('https://www.veyondtech.com/') . '" target="_blank" aria-label="' . esc_attr__('Plugin Additional Links', 'gold-price-based-on-weight') . '" style="color:green;">' . esc_html__('Documentation', 'gold-price-based-on-weight') . '</a>'
        );

        return array_merge($links, $row_meta);
    }
    return (array) $links;
}

add_action('woocommerce_product_options_general_product_data', 'woo_add_jewellery_field');
function woo_add_jewellery_field()
{
    $field = array(
        'id' => 'jewellery_field',
        'label' => __('Choose Metal Type', 'store'),
        'desc_tip' => true,
        'description' => __('Choose Metal Type', 'ctwc'),
        'options' => array(
            '0' => __('Choose Metal Type', 'woocommerce'),
            '1' => __('Gold', 'woocommerce'),
            '2' => __('Silver', 'woocommerce'),
            '3' => __('Platinum', 'woocommerce'),
        ),
    );

    woocommerce_wp_select($field);
}

add_action('woocommerce_process_product_meta', 'woo_add_jewellery_field_save');
function woo_add_jewellery_field_save($post_id)
{
    $jewellery_field = $_POST['jewellery_field'];
    if (!empty($jewellery_field))
        update_post_meta($post_id, 'jewellery_field', esc_attr($jewellery_field));
    else {
        update_post_meta($post_id, 'jewellery_field', '');
    }
}

function GoldPriceMenu()
{
    add_menu_page(
        __('Gold Price', 'my-textdomain'),
        __('Gold Price', 'my-textdomain'),
        'manage_options',
        'gold-price',
        'GoldPricePageMenu',
        'dashicons-money-alt',
        3
    );
}
add_action('admin_menu', 'GoldPriceMenu');

function GoldPricePageMenu()
{
?>
    <div class="infinity-gold-price">
        <div class="infinity-wrapper">
            <div class="infinity-boxes infinity-header">
                <div class="infinity-box infinity-page-title">
                    <h1><?php esc_html_e('Gold Price : Based On Weight'); ?></h1>
                </div>
                <div class="infinity-box infinity-logo ">
                    <a href="https://www.veyondtech.com/" target="_blank" class="infinity-page-title">
                        <h1>Veyond Tech</h1>
                    </a>
                </div>
            </div>

            <div class="infinity form-wrap">
                <div id="infinity-container" class="wp-clearfix">
                    <div class="infinity-sub-title">
                        <h2><span><img src="<?= PTGold_ASSETS_URL; ?>uploads/check-mark.png" alt="Check Mark"></span><?php esc_html_e('Gold Price: Based On Weight'); ?></h2>
                        <p><?php esc_html_e("- Establishing a global price per gram of Gold, Silver, and Platinum and utilizing the weight of each product, the price can be automatically calculated based on this rate, making the pricing process more efficient and accurate for all Woo-Commerce simple products and variable products."); ?></p>
                    </div>
                    <form method="POST" action="options.php" class="infinity-form">
                        <?php
                        settings_fields('gold-price');
                        do_settings_sections('gold-price');
                        submit_button();
                        ?>
                    </form>
                    <div class="infinity-sub-title">
                        <h2><span><img src="<?= PTGold_ASSETS_URL; ?>uploads/check-mark.png" alt="Check Mark"></span><?php esc_html_e("Contact Us !"); ?></h2>
                        <p><?php esc_html_e("- If you require assistance with customizations or wish to hire a developer, please feel free to contact us via email."); ?></p>
                        <p>- Email ID : <a href="mailto:kavavimal@gmail.com" class="link-yellow">kavavimal@gmail.com</a></p>
                    </div>
                </div>
            </div>

            <div class="infinity-footer">
                <div class="infinity-box infinity-page-title">
                    <h3><?php esc_html_e('Gold Price : Based On Weight'); ?></h3>
                </div>
                <div class="infinity-box infinity-logo">
                    <label>Developed By - <a href="https://www.veyondtech.com" target="_blank">VeyondTech</a></label>
                </div>
            </div>
        </div>
    </div>
<?php
}

add_action('admin_init', 'GoldPriceInit');
function GoldPriceInit()
{
    add_settings_section('gold_price_setting_section', '', 'GoldPriceCBFun', 'gold-price');
    foreach (['gold', 'silver', 'platinum'] as $metal) {
        add_settings_field($metal, ucfirst($metal) . ' Price per Gram', 'GoldPriceSetting', 'gold-price', 'gold_price_setting_section', [$metal]);
        register_setting('gold-price', $metal, 'esc_attr');
    }
}
function GoldPriceCBFun()
{
    esc_html_e('', 'my-textdomain');
}
function GoldPriceSetting($args)
{
    $option = get_option($args[0]);
    echo '<input type="text" id="' . $args[0] . '" name="' . $args[0] . '" value="' . esc_attr($option) . '" />';
}

function GoldPriceCalc($metals)
{
    return get_option($metals === '1' ? 'gold' : ($metals === '2' ? 'silver' : 'platinum'));
}

add_filter('woocommerce_product_get_price', 'GoldPrice', 99, 2);
add_filter('woocommerce_product_get_regular_price', 'GoldPrice', 99, 2);
add_filter('woocommerce_product_variation_get_regular_price', 'GoldPrice', 99, 2);
add_filter('woocommerce_product_variation_get_price', 'GoldPrice', 99, 2);
function GoldPrice($price, $product)
{
    $data_value = get_post_meta($product->get_id(), 'jewellery_field', true);
    if (in_array($data_value, ['1', '2', '3'])) {
        return floatval($product->get_weight()) * floatval(GoldPriceCalc($data_value));
    }
    return (float) $price;
}

add_action('woocommerce_variation_options_pricing', 'bbloomer_add_custom_field_to_variations', 90, 3);
function bbloomer_add_custom_field_to_variations($loop, $variation_data, $variation)
{
    $jewellery_field = array(
        'id' => 'jewellery_field_variation[' . $loop . ']',
        'label' => __('Choose Metal Type', 'store'),
        'desc_tip' => true,
        'options' => array(
            '0' => __('Choose Metal Type', 'woocommerce'),
            '1' => __('Gold', 'woocommerce'),
            '2' => __('Silver', 'woocommerce'),
            '3' => __('Platinum', 'woocommerce'),
        ),
        'value' => get_post_meta($variation->ID, 'jewellery_field_variation', true)
    );
    woocommerce_wp_select($jewellery_field);
}

add_action('woocommerce_save_product_variation', 'bbloomer_save_custom_field_variations', 10, 2);
function bbloomer_save_custom_field_variations($variation_id, $i)
{
    if (isset($_POST['jewellery_field_variation'][$i])) {
        update_post_meta($variation_id, 'jewellery_field_variation', esc_attr($_POST['jewellery_field_variation'][$i]));
    }
}

add_filter('woocommerce_product_variation_get_regular_price', 'custom_price', 99, 2);
add_filter('woocommerce_product_variation_get_price', 'custom_price', 99, 2);
add_filter('woocommerce_variation_prices_price', 'custom_price', 99, 3);
add_filter('woocommerce_variation_prices_regular_price', 'custom_price', 99, 3);
function custom_price($price, $product)
{
    $data_value = get_post_meta($product->get_id(), 'jewellery_field_variation', true);
    if (in_array($data_value, ['1', '2', '3'])) {
        return floatval(GoldPriceCalc($data_value)) * floatval($product->get_weight());
    }
    return (float) $price;
}
