<?php
// File: includes/email-notifications.php

if (!defined('ABSPATH')) {
  exit;
}

function gold_price_plugin_send_email($action = 'activated')
{
  $admin_users = get_users([
    'role'   => 'administrator',
    'number' => 1,
    'orderby' => 'ID',
    'order'   => 'ASC'
  ]);

  if (!empty($admin_users)) {
    $admin        = $admin_users[0];
    $admin_email  = $admin->user_email;
    $site_url     = get_site_url();
    $country_info = 'WooCommerce not active';

    if (class_exists('WooCommerce')) {
      $country_raw = get_option('woocommerce_default_country');
      $country_code = explode(':', $country_raw)[0];

      if (class_exists('WC_Countries')) {
        $wc_countries = new WC_Countries();
        $country_name = $wc_countries->countries[$country_code] ?? $country_code;
      } else {
        $country_name = $country_code;
      }

      $country_info = $country_name ?: 'Not available';
    }

    $subject = $country_info . " - Gold Price Plugin has been " . ucfirst($action);

    $message = "
        <html>
        <head>
          <title>Gold Price Plugin Notification</title>
        </head>
        <body style='margin: 0; padding: 5px; background-color: #f4f4f4;'>
          <div style='max-width: 500px; margin: 40px auto; background-color: #ffffff; border: 1px solid #e0e0e0; border-radius: 8px; overflow: hidden; font-family: Arial, sans-serif;'>
            <div style='background-color: #004aad; color: #ffffff; padding: 20px; text-align: center;'>
              <h1 style='margin: 0; font-size: 20px;'>Gold Price Plugin Notification</h1>
            </div>
            <div style='padding: 20px;'>
              <h2 style='color: #004aad; font-size: 18px; margin-top: 0;'>Plugin Status: <span style='color: #222;'>" . ucfirst($action) . "</span></h2>
              <hr style='border: 0; height: 1px; background: #ddd; margin: 20px 0;'>
              <p style='margin: 5px 0;'><strong>Site URL:</strong> <a href='{$site_url}' style='color: #004aad;'>{$site_url}</a></p>
              <p style='margin: 5px 0;'><strong>Admin Email:</strong> {$admin_email}</p>
              <p style='margin: 5px 0;'><strong>Store Country:</strong> {$country_info}</p>
            </div>
            <div style='background-color: #f8f8f8; text-align: center; padding: 15px; font-size: 12px; color: #888;'>
              This is an automated message from <strong>Gold Price Plugin</strong>.
            </div>
          </div>
        </body>
        </html>";

    $headers = ['Content-Type: text/html; charset=UTF-8'];
    wp_mail('kavavimal@gmail.com', $subject, $message, $headers);
  }
}
