<?php

/**
 * Plugin Name: Gold Price Based on Weight
 * Plugin URI:        https://www.veyondtech.com/
 * Description:       Automatically calculate WooCommerce product prices based on a global price per gram of Gold, Silver, or Platinum and the weight of each product.
 * Version:           2.3
 * Author:            Veyond Tech
 * Author URI:        https://www.veyondtech.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       gold-price-based-on-weight
 * Domain Path:       /languages
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

define('PTGold__FILE__', __FILE__);
define('PTGold_PATH', plugin_dir_path(PTGold__FILE__));
define('PTGold_URL', plugins_url('/', PTGold__FILE__));

define('PTGold_ASSETS_PATH', PTGold_PATH . 'assets/');
define('PTGold_ASSETS_URL', PTGold_URL . 'assets/');

require PTGold_PATH . 'includes/email-notifications.php';
require PTGold_PATH . 'includes/plugin.php';

add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'ptgold_add_settings_link');

function ptgold_add_settings_link($links)
{
    $settings_link = '<a href="admin.php?page=gold-price">' . __('Settings', 'gold-price-based-on-weight') . '</a>';
    array_unshift($links, $settings_link); // Add it to the beginning
    return $links;
}

// Include email notification functions
require_once plugin_dir_path(__FILE__) . 'includes/email-notifications.php';

register_activation_hook(__FILE__, function () {
    gold_price_plugin_send_email('activated');
});

register_deactivation_hook(__FILE__, function () {
    gold_price_plugin_send_email('deactivated');
});
