<?php
/**
 * Uninstall Golala Email Sender
 *
 * @package GolalaEmailSender
 */

// If uninstall not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete options
delete_option('golala_email_sender_options');

// For multisite
if (is_multisite()) {
    $sites = get_sites();
    foreach ($sites as $site) {
        switch_to_blog($site->blog_id);
        delete_option('golala_email_sender_options');
        restore_current_blog();
    }
    
    // Delete network option
    delete_site_option('golala_email_sender_options');
}

// Clear any transients
global $wpdb;
$wpdb->query(
    $wpdb->prepare(
        "DELETE FROM $wpdb->options WHERE option_name LIKE %s",
        '%golala_email_sender%'
    )
);