jQuery(document).ready(function($) {
    $('#send_test_email').on('click', function() {
        var email = $('#test_email_address').val();
        var button = $(this);
        
        if (!email) {
            alert(golala_email_sender.text_enter_email);
            return;
        }
        
        if (!email.match(/^[^\s@]+@[^\s@]+\.[^\s@]+$/)) {
            alert(golala_email_sender.text_valid_email);
            return;
        }
        
        button.prop('disabled', true);
        $('#test_email_status').html('<span class="spinner is-active"></span> ' + golala_email_sender.text_sending);
        
        $.ajax({
            url: golala_email_sender.ajax_url,
            type: 'POST',
            data: {
                action: 'golala_email_sender_test_email',
                email: email,
                nonce: golala_email_sender.nonce
            },
            success: function(response) {
                if (response.success) {
                    $('#test_email_status').html('<span style="color:green;">✓ ' + golala_email_sender.text_sent + ' ' + email + '</span>');
                } else {
                    $('#test_email_status').html('<span style="color:red;">✗ ' + golala_email_sender.text_failed + '</span>');
                }
                button.prop('disabled', false);
            },
            error: function() {
                $('#test_email_status').html('<span style="color:red;">✗ ' + golala_email_sender.text_error + '</span>');
                button.prop('disabled', false);
            }
        });
    });
});