<?php
/*
Plugin Name: GMeyshan - Gmail for wordpress 
Version: 1.21
Plugin URI: http://www.spicyexpress.net/
Description: This widget helps visitor of your site to check gmail and gmail for your domain without leaving your website <a href="http://www.Spicypipes.com">SpicyPipes.com - A api magic</a> by Dayaparan.
Author: P. Dayaparan 
Version: 1.21
Author URI: http://www.spicyexpress.net
*/

// Put functions into one big function we'll call at the plugins_loaded
// action. This ensures that all required plugin functions are defined.
function widget_gmeyshan_init() {
	// Check for the required plugin functions. This will prevent fatal
	// errors occurring when you deactivate the dynamic-sidebar plugin.
	if ( !function_exists('register_sidebar_widget') )
		return;


	// This is the function that outputs our little Google search form.
	function widget_gmeyshan($args) {
		include(dirname(__FILE__).'/settings.php');
		if($gm_conf !== TRUE){
    gmail_settings('',spliturl(get_settings('siteurl')).'/wp-content/plugins/gmail-widget');
    include(dirname(__FILE__).'/settings.php');

    }
				// $args is an array of strings that help widgets to conform to
		// the active theme: before_widget, before_title, after_widget,
		// and after_title are the array keys. Default tags: li and h2.
		extract($args);

		// Each widget can store its own options. We keep strings here.
		$options = get_option('widget_gmeyshan');
		$title = $options['title'];
		$text = $options['text'];
    $image = $options['image'];

		echo $before_widget . $before_title . $title . $after_title;
		$url_parts = parse_url(get_bloginfo('home'));
		if($image != ""){
    $gmeyshan_cont = "<img src=\"".$image."\" alt=\"GMeyshan\" />";
    }else{
    $gmeyshan_cont = $text;
    }
		//echo '<a href="'.$widget_path.'index.php" title="Gmail-lite" onclick="Modalbox.show(this.href, {title: this.title, height: 600}); return false;">'.$gmeyshan_cont.'</a>';
		echo '<a href="'.$widget_path.'index.php?keepThis=true&TB_iframe=true&height=400&width=600" title="Gmail-lite" class="thickbox">'.$gmeyshan_cont.'</a>';
    echo $after_widget;
	}

	// This is the function that outputs the form to let the users edit
	// the widget's title. It's an optional feature that users cry for.
	function widget_gmeyshan_control() {
    include(dirname(__FILE__).'/settings.php');
		// Get our options and see if we're handling a form submission.
		$options = get_option('widget_gmeyshan');
		if ( !is_array($options) )
			$options = array('title'=>'', 'text'=>__('Check your GMail!', 'widgets'), 'image'=>'gm_banner.png');
		if ( $_POST['gmeyshan-submit'] ) {

			// Remember to sanitize and format use input appropriately.
			$options['title'] = strip_tags(stripslashes($_POST['gmeyshan-title']));
			$options['text'] = strip_tags(stripslashes($_POST['gmeyshan-text']));
			$options['image'] = strip_tags(stripslashes($_POST['gmeyshan-image']));
			$widget_url = spliturl(get_settings('siteurl')).'/wp-content/plugins/gmail-widget';
      gmail_settings(strip_tags(stripslashes($_POST['gmeyshan-domain'])),$widget_url);
			update_option('widget_gmeyshan', $options);

		}

		// Be sure you format your options to be valid HTML attributes.
		$title = htmlspecialchars($options['title'], ENT_QUOTES);
		$text = htmlspecialchars($options['text'], ENT_QUOTES);
		$image = htmlspecialchars($options['image'], ENT_QUOTES);
		$domain = htmlspecialchars($domain, ENT_QUOTES);
		// Here is our little form segment. Notice that we don't need a
		// complete form. This will be embedded into the existing form.
		echo '<p style="text-align:right;"><label for="gmeyshan-title">' . __('Title:') . ' <input style="width: 200px;" id="gmeyshan-title" name="gmeyshan-title" type="text" value="'.$title.'" /></label></p>';
		echo '<p style="text-align:right;"><label for="gmeyshan-text">' . __('Button Text:', 'widgets') . ' <input style="width: 200px;" id="gmeyshan-text" name="gmeyshan-text" type="text" value="'.$text.'" /></label></p>';
		echo '<p style="text-align:right;"><label for="gmeyshan-image">' . __('Image URL:', 'widgets') . ' <input style="width: 200px;" id="gmeyshan-image" name="gmeyshan-image" type="text" value="'.$image.'" /></label></p>';
		echo '<p style="text-align:right;"><label for="gmeyshan-domain">' . __('Domain:', 'widgets') . ' <input style="width: 200px;" id="gmeyshan-domain" name="gmeyshan-domain" type="text" value="'.$domain.'" /></label></p>';
		echo '<input type="hidden" id="gmeyshan-submit" name="gmeyshan-submit" value="1" />';
	}
	
	// This registers our widget so it appears with the other available
	// widgets and can be dragged and dropped into any active sidebars.
	register_sidebar_widget(array('GMeyshan Mail', 'widgets'), 'widget_gmeyshan');

	// This registers our optional widget control form. Because of this
	// our widget will have a button that reveals a 300x100 pixel form.
	register_widget_control(array('GMeyshan Mail', 'widgets'), 'widget_gmeyshan_control', 300, 100);
}

function modalbox_head()
{
$widget_dir = get_settings('siteurl').'/wp-content/plugins/gmail-widget';
echo	'<script type="text/javascript" src="'.$widget_dir.'/lib/prototype.js"></script>';
echo	'<script type="text/javascript" src="'.$widget_dir.'/lib/scriptaculous.js?load=builder,effects"></script>';
echo	'<script type="text/javascript" src="'.$widget_dir.'/modalbox.js"></script>';
echo	'<link rel="stylesheet" href="'.$widget_dir.'/modalbox.css" type="text/css" />';
}

function gmail_settings($domain,$widget_url){

	$config  = "<?php\n";
	$config .= "\$gm_conf = TRUE;\n";
	$config .= "\$domain = \"".$domain."\";\n";
	$config .= "\$widget_url = \"".$widget_url."/\";\n";
	$config .= "\$widget_path = \"".$widget_url."/\";\n";
	$config .= "?>\n";
	$fh = fopen( dirname(__FILE__).'/settings.php', 'w' );
  fputs( $fh, $config, strlen( $config ) );
  fclose( $fh );
}

function spliturl($url){
preg_match('/\/\/[^\/]+?(\/.+)$/', $url, $m);
return $m[1];
}
add_action('wp_head', 'modalbox_head');
// Run our code later in case this loads prior to any required plugins.
add_action('widgets_init', 'widget_gmeyshan_init');

?>
