<?php

require_once("config.php");

$gm = new GMailer();
if (!$gm->created) {
	die("fail to create gmailer");
}

quick_init($gm);

// Check if necessary cookies exist; Added by Neerav; 13 May 2006
check_cookie();

// support for hosted domains; Added by Neerav; 9 June 2006
$domain = get_domain();
if ($domain !== "") $gm->setDomain($domain);

if (!$gm->connect()) {
	header("Location: index.php?err=10");
	exit();
}

$th			= (isset($_REQUEST["th"]))		? $_REQUEST["th"] 		: 0;
$mg 		= (isset($_REQUEST["mg"]))		? $_REQUEST["mg"] 		: 0;
$html 		= (isset($_REQUEST["html"]))	? $_REQUEST["html"] 	: M_DISPLAY_HTML_ALWAYS;
$html_img 	= (isset($_REQUEST["himg"]))	? $_REQUEST["himg"] 	: 0;
$std 		= (isset($_REQUEST["std"]))		? $_REQUEST["std"] 		: "";
$label 		= (isset($_REQUEST["label"]))	? $_REQUEST["label"] 	: "";
$query 		= (isset($_REQUEST["query"]))	? stripslashes($_REQUEST["query"]) : "";
$sum 		= (isset($_REQUEST["sum"]))		? $_REQUEST["sum"] 		: 0;   
$unread 	= (isset($_REQUEST["unread"]))	? $_REQUEST["unread"] 	: 0; 
$pos 		= (isset($_REQUEST["pos"]))		? $_REQUEST["pos"] 		: 0;    
$orig 		= (isset($_REQUEST["orig"]))	? $_REQUEST["orig"] 	: 0;    
$showhid 	= (isset($_REQUEST["show"]))	? $_REQUEST["show"] 	: 0;    
$ashow 		= (isset($_REQUEST["ashow"]))	? urldecode($_REQUEST["ashow"])	: "";    // always show images from this sender
// perform action?
$act 		= (isset($_REQUEST["act"]))		? $_REQUEST["act"] 		: 0;
$lbl 		= (isset($_REQUEST["lbl"]))		? $_REQUEST["lbl"] 		: "";    
$t 			= (isset($_REQUEST["t"]))		? $_REQUEST["t"] 		: array();    
$back 		= (isset($_REQUEST["back"]))	? preg_replace("/(%26|%26amp%3B|&|&amp;)status.*/","",$_REQUEST["back"]) 	: 0;
$prevconv 	= (isset($_REQUEST["pc"]))		? $_REQUEST["pc"] 		: 0;    
$nextconv 	= (isset($_REQUEST["nc"]))		? $_REQUEST["nc"] 		: 0;    
// add sender to contacts; Added by Neerav; 2 May 2006
$astc 		= (isset($_REQUEST["astc"]))	? urldecode($_REQUEST["astc"]) 	: 0;
// quick star/unstar; Added by Neerav; 14 May 2006
$starit 	= (isset($_REQUEST["qs"]))		? (int)$_REQUEST["qs"] 	: "";

// Display status information; by Neerav; 29 April 2006
$status 	= (isset($_REQUEST["status"]))	? htmlentities($_REQUEST["status"]) 	: "";

/// button actions
// Added Delete Button Functionality; by PENorwood; April 2006
// Changed Location; Neerav; 20 April 2006
// Archive button; Added by Neerav; 27 April 2006
$button_action = false;
if (isset($_GET['delete']) and $_GET['submit'] == 'delete') {
	$status = $gm->performAction(GM_ACT_TRASH, $t, $lbl);
	$button_action = true;
} elseif (isset($_GET['del_spam']) and $_GET['submit'] == 'del_spam') {
	$status = $gm->performAction(GM_ACT_DELSPAM, $t, $lbl);
	$button_action = true;
} elseif (isset($_GET['del_forever']) and $_GET['submit'] == 'del_forever') {
	$status = $gm->performAction(GM_ACT_DELFOREVER, $t, $lbl);
	$button_action = true;
} elseif (isset($_GET['archive']) and $_GET['submit'] == 'archive') {
	$status = $gm->performAction(GM_ACT_ARCHIVE, $t, $lbl);
	$button_action = true;
	list($last_mbox,$last_mbox_path) = get_last_mailbox();
	$back = "main.php?".$last_mbox_path;
/* } elseif (isset($_GET['mark_spam']) and $_GET['mark_spam']) { */
/* 	$status = $gm->performAction(GM_ACT_SPAM, $t, $lbl); */
/* 	$button_action = true; */
} elseif ($astc) {
	// add sender to contacts; Added by Neerav; 2 May 2006
	$gm->addSenderToContact($t);	
}
if ($button_action) {
	$status_message	= $gm->lastActionStatus('message');
	$back = urldecode($back);
	if (strpos($back,".php?") === false) {
		$back .= "?";
	}
	header("Location: ".$back."&status=".rawurlencode($status_message));
	exit;
}

// go to previous or next conversation; Added by Neerav; 13 Nov 2006
// only triggered if Sessions are used
if ($prevconv or $nextconv) {
	list($last_mbox,$last_mbox_path) = get_last_mailbox();

	$msgid = ($prevconv) ? $prevconv : $nextconv;
	$total_cached_box = count($_SESSION['mbox_cache']);
	for ($i = 0; $i < $total_cached_box; $i++) {
		if ($_SESSION['mbox_cache'][$i]['id'] == $msgid) {
			if ($prevconv) {
				header("Location: main.php?".$last_mbox_path."&th=".$_SESSION['mbox_cache'][$i-1]['id']);
				exit;
			} elseif ($nextconv) {
				header("Location: main.php?".$last_mbox_path."&th=".$_SESSION['mbox_cache'][$i+1]['id']);
				exit;
			} 
			break;
		}
	}
	header("Location: main.php?".$last_mbox_path);
	exit;
}

/// act on messages
if (($act && count($t) > 0 && $back)) {
	if (GM_ACT_DELTRASHEDMSGS == $act) {
		$status = $gm->performAction(GM_ACT_DELTRASHEDMSGS, $t, "","all");
		$status_message	= $gm->lastActionStatus('message');

		if ($status) {
			header("Location: main.php?th=$t".(($status)?"&status=".rawurlencode($status_message):""));
			exit();   // redirect right away
		} else {
			$status = $status_message;
		}
	} else {
		// for actions on messages other than the inbox; by Neerav; 6 May 2006
		$this_box = ($std) 
			? $std
			: (($label) ? $label : "")
			;
		if ($act == GM_ACT_APPLYLABEL or $act == GM_ACT_REMOVELABEL) {
			if ($lbl != "") {
				$status = $gm->performAction($act, $t, $lbl,$this_box);
				$status_message	= $gm->lastActionStatus('message');
			} else {
				$status = false;
				$status_message	= "Please choose a label.";
			}
		} else {
			$status = $gm->performAction($act, $t, "",$this_box);
			$status_message	= $gm->lastActionStatus('message');
		}
		if ($status) {
			if ($act == GM_ACT_UNREAD or $act == GM_ACT_TRASH) {
				list($last_mbox,$last_mbox_path) = get_last_mailbox();
				$back = "main.php?".$last_mbox_path;
			} else {
				$back = urldecode($back);
			}

			if (strpos($back,".php?") === false) {
				$back .= "?";
			}
			header("Location: ".$back.(($status)?"&status=".rawurlencode($status_message):""));
			exit();   // redirect right away
		} else {
			$status = $status_message;
		}
	}
} elseif ($starit != "") {
	if ($starit == 0) {
		$status = $gm->starMessageQuick($t,"unstar");
		$status_message = $gm->lastActionStatus('message');
		if ($status) {
			header("Location: main.php?th=$th".(($status)?"&status=".rawurlencode($status_message):""));
			exit();
		}
	} elseif ($starit == 1) {
		$status = $gm->starMessageQuick($t,"star");
		$status_message = $gm->lastActionStatus('message');
		if ($status) {
			header("Location: main.php?th=$th".(($status)?"&status=".rawurlencode($status_message):""));
			exit();
		}
	}
} 

/// create query
if ($sum) {
	$q = "search=cat&cat=dummyjusttoretrievesummary&view=tl&start=0&init=1";
	$tit = "summary";
} elseif ($orig && $mg) {
	$q = "view=om&th=".$mg;
	// dump the whole page... with some escaping
	header("Content-type: text/plain; charset=big5");
	echo $gm->dump($q);
	exit();
} else {   
	if ($unread) {
		$q = "search=query&q=is%3Aunread&view=tl&start=".$pos;
		$tit = "unread";
	} else {   
		if ($th) {			
			$tit = "conversation";
			if (!$std) $std = "inbox";

			if ($mg) $q = "search=".$std."&view=cv&th=".$th."&msgs=".$mg;      
			else $q = "search=".$std."&view=cv&th=".$th.(($showhid)?"&shtr=true":"");

			// display images in html mail which are being hidden; Added by Neerav; 20 April 2006
			if ($html_img) $q .= "&ser=1";
			     
		} else {
			if ($query) {
				$q = "search=query&q=".urlencode($query)."&view=tl&start=".$pos;
				$tit = "search";
			} elseif ($label) {
				$q = "search=cat&cat=".urlencode($label)."&view=tl&start=".$pos;
				$tit = $label;
			} else {
				if ($std) {
					$q = "search=".$std."&view=tl&start=".$pos;
				} else {
					$q = "search=inbox&view=tl&start=0&init=1";
					$std = "inbox";
				}
				$tit = $std;
			}
		}
	}
}

/// retrieve from Gmail
$gm->fetch($q);
$snapshot = $gm->getSnapshot(GM_STANDARD|GM_LABEL|GM_QUERY|GM_CONVERSATION);


// always show images from this sender
if ($ashow) {
	/// send "always show" to Gmail
	$gm->fetch("&th=".$th."&msgs=".$mg."&ser=1&rfh=1&qt=&act=aser&ere=".rawurlencode($ashow)."&at=".$gm->at_value());
	$snapshot2 = $gm->getSnapshot(GM_STANDARD|GM_LABEL|GM_QUERY|GM_CONVERSATION);
	if (isset($gm->raw['ar'][2])) {
		$status = $gm->raw['ar'][2];
		if ($gm->raw['ar'][1] == 1) { 	// successful
			// retrieve again from Gmail WITH images
			$gm->fetch($q."&ser=1");
			$snapshot = $gm->getSnapshot(GM_STANDARD|GM_LABEL|GM_QUERY|GM_CONVERSATION);
			$html_img = 1;
			$html = 1;
		}
	}
}

/* debug_print(print_r($gm,true)); */
/* debug_print(print_r($snapshot)); */
/* exit; */
/*  */
if ($snapshot->created == 0) {
	// error occurred
	header("Location: main.php?std=".$std."&label=".$label.(defined("SID")?"&".strip_tags(SID):""));
	exit;
}

$stdbox = GMailer::getStandardBox();
$stdbox[] = "Chats";  // Addition of the Chat archives box; by Neerav; Feb 2006 

//debug_print("dumping snapshot: ".print_r($snapshot,true));
//debug_print("dumping gm object: ".print_r($gm,true));

$show_total = ($sum == 1 && S_SHOW_TOTAL == 1);
if ($show_total) {
	$gm->fetchBox(GM_PREFERENCE, 0, 0);
	$snapshot2 = $gm->getSnapshot(GM_PREFERENCE);
}

// show the number of messages in the box/label in the page Title
// Added by Neerav; 12 Jan 2006
if ($std and !$th and !$mg) {
	$stl_std = strtolower($std);
	if ($stl_std === "inbox" or $stl_std === "spam" or $stl_std === "drafts") {
		$count_std = count($stdbox);
		for ($i = 0; $i < $count_std; $i++) {
			if (strtolower($stdbox[$i]) === "$std" and isset($snapshot->std_box_new[$i])) {
				$tit = $tit." (".$snapshot->std_box_new[$i].")";
				break;
			}
		}
	}
} elseif ($label and !$th and !$mg) {
	$count_label = count($snapshot->label_list);
	for ($i = 0; $i < $count_label; $i++) {
		if ($snapshot->label_list[$i] === "$label") {
			$tit = $tit." (".$snapshot->label_new[$i].")";
			break;
		}
	}
} elseif ($sum) {
	if ($snapshot->std_box_new[0] or $snapshot->std_box_new[5]) {
		$tit = /* $tit. */" ["
			.(($snapshot->std_box_new[0])?"In:".$snapshot->std_box_new[0]:"")
			.(($snapshot->std_box_new[5])?" Spam:".$snapshot->std_box_new[5]:"")
			."]";
	}
}

// Back to [mailbox/label/search] button; Added by Neerav; 10 May 2006
$last_mbox = "";
if (!$th and ($std or $label or $query or $pos)) {
	if 		($std) 	$last_mbox = "$std::std=$std";
	elseif ($label) $last_mbox = "$label::label=$label";
	elseif ($query) $last_mbox = "Search results::query=".rawurlencode($query);
	
	if ($pos and $last_mbox !== "") $last_mbox .= "&pos=$pos";
	
	if ($session_method & GM_USE_PHPSESSION) {
		$_SESSION['last_mbox'] = $last_mbox;
	} else {
		setcookie("gmail-lite_last_mbox", base64_encode($last_mbox));
	}
}

// Summary display based on mobile settings; Neerav; 14 May 2006
if ($sum) {
	$display_boxes = array($stdbox);
	$display_selective = false;
	if ($session_method & GM_USE_PHPSESSION) {
		//debug_print(print_r($_SESSION['display_mboxes'],true));
		if (isset($_SESSION['display_mboxes']) and count($_SESSION['display_mboxes']) > 0) {
			$display_boxes = $_SESSION['display_mboxes'];
			$display_selective = true;
		}
	} else {
		if (isset($_COOKIE['gmail-lite_mboxes']) and $_COOKIE['gmail-lite_mboxes'] != "") {
			if ($temp_display_boxes = @unserialize(gzuncompress(base64_decode($_COOKIE['gmail-lite_mboxes'])))) {
				if (count($temp_display_boxes) > 0) $display_boxes = $temp_display_boxes;
				$display_selective = true;
			} else {
				setcookie("gmail-lite_mboxes", "", 1); 
			}
		}
	}
}

// retrieve webclip; Added AGAIN by Neerav; 13 May 2006
$this_webclip = get_web_clip();

/// header
header("Pragma: no-cache");  // stop caching	
print_headers();
$server = "";
if (strpos($_SERVER['HTTP_HOST'], "glite2") !== false) {
	$server = 2;
} elseif (strpos($_SERVER['HTTP_HOST'], "glite3") !== false) {
	$server = 3;
}
?> 
<html><head><title>gmail-lite<? if ($server) echo '{'.$server.'}'; echo ":".$tit ?></title>
<?
if ($sum == 1 && S_REFRESH_SEC > 0)   // auto-refresh in summary page
echo "<meta http-equiv='REFRESH' content='".S_REFRESH_SEC."'>";

if (get_js_status() and !$th) { ?>
<? } ?>
<link rel="stylesheet" type="text/css" href="<?php echo $widget_url; ?>glite.css">
</head>
<body>
<table width="95%" align="center" cellpadding="2" cellspacing="0" border="0"><tr><td>
<? 

navigation_links($snapshot->have_invit, (($sum)?true:N_SHOW_INVITES));
if (!$sum) { ?>
<form id="mboxes" name="mboxes" action="main.php" method="get">
<select name="std">
<option value="">standard:</option>
<?   
$count_std = count($stdbox);
for ($i = 0; $i < $count_std; $i++) {
	echo "<option value='".strtolower($stdbox[$i])."'>";
	if (isset($snapshot->std_box_new[$i]) and $snapshot->std_box_new[$i] > 0) {
		echo $stdbox[$i]." (".$snapshot->std_box_new[$i].")</option>\n";
	} else {
		echo $stdbox[$i]."</option>\n";
	}
}
?>
</select> <select name="label">
<option value="">labels:</option>
<?
$count_label = count($snapshot->label_list);
for ($i = 0; $i < $count_label; $i++) {
	// skip gmskin settings; Neerav; 25 April 2006
	if (strpos($snapshot->label_list[$i], "gmskin:") !== false) continue;     
	echo "<option value='".$snapshot->label_list[$i]."'";
	if ($snapshot->label_new[$i] > 0) {
		echo ">".$snapshot->label_list[$i]." (".$snapshot->label_new[$i].")</option>\n";
	} else {
		echo ">".$snapshot->label_list[$i]."</option>\n";
	}
}

// separated search box and display the current search in the box; by Neerav; 31 July 2006
$last_query = "";
if ($query) {
	$last_query = htmlentities($query);
} else {
	if ($label) {
		$last_query = "label:".str_replace(" ","-",$label);
	} elseif (!$std) {
		if ($session_method & GM_USE_PHPSESSION) {
			$last_query_temp = $_SESSION['last_mbox'];
		} else {
			$last_query_temp = (isset($_COOKIE['gmail-lite_last_mbox']) ? base64_decode($_COOKIE['gmail-lite_last_mbox']) : "");
		}
		if (substr($last_query_temp,0,14) == "Search results") {
			$last_query = urldecode(str_replace("::query=","",substr($last_query_temp,strpos($last_query_temp,":"))));
		}
	}
}
?>
</select>  <input type="submit" value="Go" onclick="Modalbox.show('<? echo $widget_path;?>/main.php', {title: 'Gmail-lite', width: 500, method: 'get', params: Form.serialize('mboxes')}); return false;">
</form>
<form id="search" name="search" action="main.php" method="get">
<input type="text" name="query" value="<? echo $last_query ?>"> <input type="submit" value="Search mail" onclick="Modalbox.show('<? echo $widget_path;?>/main.php', {title: 'Gmail-lite', width: 500, method: 'get', params: Form.serialize('search')}); return false;">
</form>
<form id="box" name="box" action="main.php" method="get">
<?
// Display status information; by Neerav; 29 April 2006
if ($status) display_status($status);
?>
<table width="100%" cellpadding="2" cellspacing="1" border="0">
<?
if (!$th) {
	/// mailbox view
	
	
	// if there are no messages in the box, go a page that has a message by making another query.
	if (count($snapshot->box) == 0 and $pos > 0) {
		$pos = ((ceil($snapshot->box_total/M_DISPLAY_CONVS)-1) * M_DISPLAY_CONVS);
		if ($pos < 0) $pos = 0;
		$q = preg_replace("/&start=\d*$/","",$q)."&start=".$pos;
		
		$gm->fetch($q);
		$snapshot = $gm->getSnapshot(GM_STANDARD|GM_LABEL|GM_QUERY|GM_CONVERSATION);
	}
	
	// cache the mailbox results for prev/next action
	if ($session_method & GM_USE_PHPSESSION) {
		$_SESSION['mbox_cache'] = $snapshot->box;
	}

/* 	if ($query) { */
/* 		echo "<tr><td colspan='3'>Query: <b style='color:brown'>".htmlentities($query)."</b></td></tr>\n"; */
/* 	} */
	// Added webclips; by Neerav; 22 April 2006
	display_web_clip($this_webclip,((!M_CHECKBOX_ON_RIGHT)?4:3));
	echo "<tr class='optrow'>";
	navigation_line(((!M_CHECKBOX_ON_RIGHT)?4:3));
	echo "</tr>";
	$lastidx = count($snapshot->box)-1;
	$displayed_convs = 0;
	
	// for an intelligent menu; Added by Neerav; 11 May 2006
	$menu_star = false;
	$menu_unstar = false;
	$menu_read = false;
	$menu_unread = false;
	$menu_spam = false;
	if ($std == "spam") {
		$menu_unspam = true;
	} else {
		$menu_unspam = false;
	} 
	$menu_remlabel = false;
	$menu_addlabel = false;
	
	
/* 	print_r($snapshot); */
	for ($i = 0; $i <= $lastidx && $i < M_DISPLAY_CONVS ; $i++) {
		// for an intelligent menu; Added by Neerav; 11 May 2006
			// read/unread
		if (!$snapshot->box[$i]["is_read"]) {
			$menu_unread = true;
		} else {
			$menu_read = true;
		}
			// spam/unspam
		if (array_search("^s",$snapshot->box[$i]['labels']) === false) {
			$menu_spam = true;
		} else {
			$menu_unspam = true;
		}


		if ($i % 2 == 0/*  || $query */) {
			echo "<tr class='altrow'>";
		} else { 
			echo "<tr>";
		}
		
		// checkbox on left or right; Added by Neerav; 11 May 2006
		if (!M_CHECKBOX_ON_RIGHT) {
			echo "<td><input type='checkbox' name='t[]' value='".$snapshot->box[$i]["id"]."'></td>";
		}

		echo "<td>";

		if ($std === "trash") {
			echo "<img src='trash.gif' border='0' align='bottom' alt='X'> ";
		}
		if ($snapshot->box[$i]["is_starred"] == 1) {
			echo "<img src='star.gif' border='0' align='bottom' alt='*'> ";
			$menu_unstar = true;
		} else {
			$menu_star = true;
		}
		if ($snapshot->box[$i]['is_chat']) {
			echo "<img src='chat.gif' border='0' align='bottom' alt='O'> ";
		}		
		
		echo $snapshot->box[$i]["sender"]."</td>";
		
		// added personal level indicators; by Neerav; 27 Mar 2006
		echo "<td>".$snapshot->box[$i]['flag'];
		
		// added labels; by Neerav; 27 Mar 2006
		$all_msg_labels = "";
		foreach ($snapshot->box[$i]['labels'] as $label_entry) {
			switch ($label_entry) {
				case "^i": 	$label_entry_name = "Inbox"; 	break;
				case "^s": 	$label_entry_name = "Spam"; 	break;
				case "^k": 	$label_entry_name = ""; 		break; // trash
				case "^r": 	$label_entry_name = "Draft"; 	break;
				default:	$label_entry_name = $label_entry;
							$menu_remlabel = true;
							break;
			}
			if ($label === $label_entry or $label_entry_name === strtolower($std)) continue;
			if ($label_entry_name != "") $all_msg_labels .= ($all_msg_labels != "") ? ", ".$label_entry_name : $label_entry_name ;
		}
		if ($all_msg_labels != "") echo "<span class='label'>".$all_msg_labels."</span> ";
		
		if ($std === "trash" || $std === "spam") {
			echo "<a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."main.php?std=".$std."&amp;th=".$snapshot->box[$i]["id"]."'>";
		} else {
			echo "<a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."main.php?th=".$snapshot->box[$i]["id"]."'>";
		}
		
		echo $snapshot->box[$i]["subj"].(($snapshot->box[$i]['is_chat']) ? " ".$snapshot->box[$i]['chat_length'] : "")."</a> ";
		if ($snapshot->box[$i]["snippet"] != "") echo "<span style='color:grey;font-size:9pt'>".$snapshot->box[$i]["snippet"] ."</span> ";

		// Replaced + symbols for attachments with paperclip and total; Neerav; Mar 2006
		$count_attachments = count($snapshot->box[$i]["attachment"]);
		if ($count_attachments) 
			echo "<img src='clip.gif' border='0' align='bottom' alt='@'> (".$count_attachments.")";
		echo "</td>";

		// checkbox on left or right; Added by Neerav; 11 May 2006
		if (M_CHECKBOX_ON_RIGHT) {
			echo "<td align='right'>".$snapshot->box[$i]["date"]." <input type='checkbox' name='t[]' value='".$snapshot->box[$i]["id"]."'></td></tr>\n";
		} else {
			echo "<td align='center'>".$snapshot->box[$i]["date"]."</td></tr>\n";
		}

		// increment the number of displayed conversations
		$displayed_convs++;
		
	}
	
	// changed to display navigation ONLY if there are some conversations displayed; Neerav; 20 April 2006
	if ($displayed_convs > 5) {
		echo "<tr class='optrow'>";
		navigation_line(((!M_CHECKBOX_ON_RIGHT)?4:3));
		echo "</tr>";
	}

	// changed to display actions ONLY if there are conversations displayed; Neerav; 20 April 2006
	if ($displayed_convs > 0) {

		echo "<tr><td".((!M_CHECKBOX_ON_RIGHT)?" colspan='2'":"")."><br>";
		// archive button; Added by Neerav; 1 May 2006
		if ($std == 'inbox') {
			echo "<input name='archive' type='submit' value='archive' style='color:green' onclick=\"Modalbox.show('$widget_path/main.php', {title: 'Gmail-lite', width: 500, method: 'get', params: Form.serialize('box')+'&submit=archive'}); return false;\">&nbsp;";
		}
/* 		if ($std != 'spam') { */
/* 			echo "<input name='mark_spam' type='submit' value='mark as spam'>&nbsp;"; */
/* 		} */
		// delete button; Added by PENorwood; April 2006
		if ($std == 'trash') {
			echo "<input name='del_forever' type='submit' value='delete forever!' style='color:red' onclick=\"Modalbox.show('$widget_path/main.php', {title: 'Gmail-lite', width: 500, method: 'get', params: Form.serialize('box')+'&submit=del_forever'}); return false;\"><br />&nbsp;<br />";
		} elseif ($std =='spam') {
			echo "<input name='del_spam' type='submit' value='delete spam forever!' style='color:red' onclick=\"Modalbox.show('$widget_path/main.php', {title: 'Gmail-lite', width: 500, method: 'get', params: Form.serialize('box')+'&submit=del_spam'}); return false;\"><br />&nbsp;<br />";
		} else {
			echo "<input name='delete' type='submit' value='delete' style='color:red' onclick=\"Modalbox.show('$widget_path/main.php', {title: 'Gmail-lite', width: 500, method: 'get', params: Form.serialize('box')+'&submit=delete'}); return false;\"><br />&nbsp;<br />";
		}
		echo "</td>";

		//select list
		echo "<td colspan='2' align='right'><br>";
		// little javascript do no harm... ; Gan
		// Changed to display only if javascript is active; by Paul Norwood; 26 April 2006
		// Updated 15 May, 2006 by PENorwood
		if (get_js_status()) { ?>
<?
		}	
		echo "<select name='act'>\n<option value='0'>action:</option>\n"
			."<option value='-1'>===========</option>\n"
			."<option value='11'>archive</option>\n"
			."<option value='12'>unarchive</option>\n"
			."<option value='-1'>--------</option>\n"
			."<option value='1'>apply label:</option>\n";
		if ($menu_remlabel) echo "<option value='2'>remove label:</option>\n";      
		if ($menu_star) 	echo "<option value='3'>star</option>\n";
		if ($menu_unstar) 	echo "<option value='4'>unstar</option>\n";
		if ($menu_read) 	echo "<option value='7'>read</option>\n";
		if ($menu_unread) 	echo "<option value='8'>unread</option>\n";
		if ($menu_spam and ($std != "spam")) 	
							echo "<option value='5'>spam</option>\n";
		if ($menu_unspam) 	echo "<option value='6'>unspam</option>\n";
		echo "<option value='-1'>--------</option>\n";
		echo "<option value='9'>trash conv</option>\n";
		echo "<option value='13'>untrash conv</option>\n";
		echo "<option value='-1'>--------</option>\n";
		echo "<option value='14'>discard draft</option>\n";
		if ($std === "spam")
			$act_code = 16;
		elseif ($std === "trash")
			$act_code = 17;
		else
			$act_code = 10;         
		echo "<option value=''>===========</option>\n<option value='".$act_code."'>!!!DEL FOREVER!!!</option>\n";
		echo "</select> <select name='lbl'>\n<option value=''>label:</option>\n";
		$count_label = count($snapshot->label_list);
		for ($i = 0; $i < $count_label; $i++) {
			// skip gmskin settings; Neerav; 25 April 2006
			if (strpos($snapshot->label_list[$i], "gmskin:") !== false) continue;     
			echo "<option value='".$snapshot->label_list[$i]."'";
			echo ">".$snapshot->label_list[$i]."</option>\n";
		}
		echo "</select> <input type='submit' value='Do' onclick=\"Modalbox.show('$widget_path/main.php', {title: 'Gmail-lite', width: 500, method: 'get', params: Form.serialize('box')}); return false;\">";
// for actions on messages other than the inbox; by Neerav; 6 May 2006
?>
<input type="hidden" name="std" value="<? echo $std ?>">
<input type="hidden" name="label" value="<? echo $label ?>">
<?		echo "</td></tr>\n";
	}

	
} else {
	/// conversation view

	// Added webclips; by Neerav; 22 April 2006
	display_web_clip($this_webclip);

	// Back to [mailbox/label/search] button; Added by Neerav; 10 May 2006
	// Prev/next; Added by Neerav; 13 Nov 2006
	list($last_mbox,$last_mbox_path) = get_last_mailbox();
	if ($session_method & GM_USE_PHPSESSION and isset($_SESSION['mbox_cache'])) {
		$next_exists = false;
		$prev_exists = false;
		$total_cached_box = count($_SESSION['mbox_cache']);
		for ($i = 0; $i < $total_cached_box; $i++) {
			if ($_SESSION['mbox_cache'][$i]['id'] == $snapshot->conv_id) {
				if (isset($_SESSION['mbox_cache'][$i+1]['id'])) {
					$next_exists = true;
				}
				if (isset($_SESSION['mbox_cache'][$i-1]['id'])) {
					$prev_exists = true;
				}
				break;
			}
		}
		echo "<tr class='optrow'><td><table width='100%' cellpadding='2' cellspacing='0' border='0'><tr>"
		 ."<td><a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href=\"".$widget_url."main.php?".str_replace("&","&amp;",$last_mbox_path)."\">&lt;&lt; Back to ".$last_mbox."</a></td>"
		 ."<td align='right'>"
		 .(($prev_exists) ? '<a onclick="Modalbox.show(this.href, {title: \'Gmail-lite\', width: 600}); return false;" href="'.$widget_url.'main.php?pc='.$snapshot->conv_id.'">&lt; Prev</a>' : "")
		 .(($next_exists and $prev_exists) ? " | " : "")
		 .(($next_exists) ? '<a onclick="Modalbox.show(this.href, {title: \'Gmail-lite\', width: 600}); return false;" href="'.$widget_url.'main.php?nc='.$snapshot->conv_id.'">Next &gt;</a>' : "")
		 ."</td></tr></table></td></tr>";
	} else {
		echo "<tr class='optrow'><td><a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href=\"".$widget_url."main.php?".str_replace("&","&amp;",$last_mbox_path)."\">&lt;&lt; Back to ".$last_mbox."</a></td></tr>";
	}

	echo "<tr class='altrow'><td>";
	if ($snapshot->conv_starred) {
		echo "<img src='star.gif' border='0' align='bottom' alt='*'> ";
	}
	echo "<b>".$snapshot->conv_title."</b>";
	// Added label display at the top of a conversation; Neerav; March 2006
	$all_msg_labels = "";
	$menu_remlabel = false;
	if ($snapshot->conv_labels) {
		foreach ($snapshot->conv_labels as $label_entry) {
/* 		print $label_entry." "; */
			switch ($label_entry) {
				case "^i": 	$label_entry_name = "INBOX"; 	break;
				case "^s": 	$label_entry_name = "SPAM"; 	break;
				case "^k": 	$label_entry_name = ""; 		break;
				case "^r": 	$label_entry_name = "DRAFT"; 	break;
				default:	$label_entry_name = $label_entry;
							$menu_remlabel = true;
							break;
			}
			//if ($label === $label_entry or $label_entry_name === strtolower($std)) continue;
			if ($label_entry_name != "") $all_msg_labels .= $label_entry_name." ";
		}
	}

	if ($snapshot->conv_labels) {
		echo "<br /><span class='label'>".$all_msg_labels."</span>";
	}
	
	echo "</td></tr></table>";
	$msg_count = count($snapshot->conv);
	$skipped = 0;
	for ($curr_msg = 0; $curr_msg < $msg_count; $curr_msg++) {
		$mg = $snapshot->conv[$curr_msg];
		if ($mg['is_trashed'] and $std != "trash" and !$showhid) {
			$skipped++;
			continue;
		}
		echo "<table width='100%' cellpadding='2' cellspacing='0' border='0'>";
		echo "<tr class='altrow'>";
		echo "<td align='left'>"
/* 			.(($mg["is_star"]) */
/* 				? "<a href='".$widget_url."main.php?qs=0&amp;th".$snapshot->conv_id."&amp;t=".$mg["id"]."'><img src='star.gif' border='0' align='bottom' alt='*'></a>&nbsp;" */
/* 				: "<a href='".$widget_url."main.php?qs=1&amp;th".$snapshot->conv_id."&amp;t=".$mg["id"]."'><img src='nost.gif' border='0' align='bottom' alt=''></a>&nbsp;" ) */
			.(($mg["is_trashed"])?"<img src='trash.gif' border='0' align='bottom' alt='X'>&nbsp;":"")
			.str_replace(array(" ("," "),array(" <wbr/>(","&nbsp;"),$mg["dt_easy"])
			."</td>";
		echo "<td align='right'>";
		if ($mg["sender"] == $mg["sender_email"]) {
			echo str_replace("@","@<wbr/>",$mg["sender"]);
		} else {
			echo $mg["sender"]." (".str_replace("@","@<wbr/>",$mg["sender_email"]).")";
		}

		// Add to Contacts list button; Added by Neerav; 2 May 2006
		if (!(preg_match("/postmaster\@|mailer-daemon\@/",$mg['sender_email']))
				and 
			!$mg['sender_in_contact']
			) {
			echo "<br />[&nbsp;<a href=\"main.php?astc=1&amp;html=".$html."&amp;th=".$snapshot->conv_id."&amp;t=".$mg["id"]."\">add sender to contacts</a>&nbsp;]\n";
		}

		echo "</td></tr>";
		if ((($mg['mbox'] & 1) or ($mg['mbox'] & 2)) and $mg['mbox'] != 0) {
			// collapsed message
			echo "<tr class='optrow'><td align='left'>";
			$natt = count($mg["attachment"]);
			if ($natt > 0) {
				echo "attach:".$natt;
			}
			echo "</td>";
			echo "<td align='right'>[";
			if ($mg['is_trashed']) {
				echo "<a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."main.php?t=".$mg["id"]."&amp;act=".GM_ACT_UNTRASHMSG."&amp;back=".urlencode("main.php?th=".$snapshot->conv_id."&show=$showhid")."'>recover msg</a> | ";               
			}
			echo "<a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."compose.php?th=".$snapshot->conv_id."&amp;mg=".$mg["id"]."&amp;back=".urlencode($_SERVER['SCRIPT_NAME']."?".$_SERVER['QUERY_STRING'])."&amp;mbox=".(($std)?$std:(($label)?$label:''))."'>reply</a>";
			// Reply to all; Added by Neerav; 4 May 2006
			if (count($mg["recv_email"]) > 1 or count($mg["cc_email"]) > 0) {
				echo " | <a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."compose.php?th=".$snapshot->conv_id."&amp;mg=".$mg["id"]."&amp;back=".urlencode($_SERVER['SCRIPT_NAME']."?".$_SERVER['QUERY_STRING'])."&amp;mbox=".(($std)?$std:(($label)?$label:''))."&amp;reall=1'>reply all</a>";
			}
			echo " | <a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."compose.php?th=".$snapshot->conv_id."&amp;mg=".$mg["id"]."&amp;back=".urlencode($_SERVER['SCRIPT_NAME']."?".$_SERVER['QUERY_STRING'])."&amp;mbox=".(($std)?$std:(($label)?$label:''))."&amp;forward=1'>forward</a>";
			echo " | <a href='".$widget_url."main.php?orig=1&amp;mg=".$mg["id"]."'>raw</a>";
			if (!$mg['is_trashed']) {
				echo " | <a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."main.php?act=15&amp;t=".$mg["id"]."&amp;back=".urlencode($_SERVER['SCRIPT_NAME']."?".$_SERVER['QUERY_STRING'])."'>trash</a>";
			}
			echo " ]</td></tr>";
			echo "<tr><td colspan='2'>".$mg["snippet"]." [ <a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."main.php?th=".$snapshot->conv_id."&amp;mg=".$mg["id"]."'>more</a> ]";
			echo "</td></tr>\n";
			
			
		} else {
			// expanded message
			echo "<tr class='optrow'><td align='left'>";
			// Added download limits for attachments; Neerav; Mar 2006
			$att_html = "";
			$att_limit_maxed = false;
			$count_attach = count($mg["attachment"]);
			for ($i = 0; $i < $count_attach; $i++) {
				if (is_numeric(C_VIEW_ATTACHMENT_LIMIT) and (C_VIEW_ATTACHMENT_LIMIT == 0 or ((C_VIEW_ATTACHMENT_LIMIT*1024) >= $mg["attachment"][$i]["size"]))) {
					$att_html .= "<a href='".$widget_url."dl.php?a=".$mg["attachment"][$i]["id"]."&amp;m=".$mg["id"]."&amp;f=".urlencode($mg["attachment"][$i]["filename"])."'>".urldecode($mg["attachment"][$i]["filename"])."</a>";
				} else {
					$att_html .= urldecode($mg["attachment"][$i]["filename"]);
					$att_limit_maxed = true;
				}
				if ($i != count($mg["attachment"])-1) $att_html .= " | ";
			}
			if ($att_html != "") echo "[".$att_html."] ";
			if ($att_html != "" and $att_limit_maxed) echo "(D/L Limit: ".C_VIEW_ATTACHMENT_LIMIT." KB)";
			if (count($mg["attachment"]) > 1 and !$att_limit_maxed) {
				echo "<br />[<a href='".$widget_url."dl.php?a=dummy&amp;m=".$mg["id"]."&amp;f=dummy&amp;z=1'>all in zip</a>]";
			}            
			echo "</td>";
			if ($mg["is_draft"] == true) {
				echo "<td align='right'>[<a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); href='".$widget_url."compose.php?df=1&amp;th=".$snapshot->conv_id."&amp;mg=".$mg["id"]."&amp;back=".urlencode($_SERVER['SCRIPT_NAME']."?".$_SERVER['QUERY_STRING'])."'>resume</a>";
				echo "]</td></tr>";
				echo "<tr><td colspan='2'><b>*** DRAFT ***</b><br>".nl2br($mg["body"])."</td></tr>";
			} else {            
				echo "<td align='right'>[";
				if ($mg['is_trashed']) 
					echo "<a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."main.php?t=".$mg["id"]."&amp;act=".GM_ACT_UNTRASHMSG."&amp;back=".urlencode("main.php?th=".$snapshot->conv_id."&mg=".$mg["id"]."&show=$showhid")."'>recover msg</a> | ";               

				// Changed to allow reverting back to text only; by Neerav; 19 April 2006
				if ($html) {
					echo "<a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."main.php?th=".$snapshot->conv_id."&amp;mg=".$mg["id"]."&amp;html=0'>text</a> | ";               
				} else/* if ($mg["is_html"]) */ {
					// display html link, only if message is html; Neerav; 31 Oct 2006
					echo "<a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."main.php?th=".$snapshot->conv_id."&amp;mg=".$mg["id"]."&amp;html=1'>html</a> | ";               
				}
				echo "<a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."compose.php?th=".$snapshot->conv_id."&amp;mg=".$mg["id"]."&amp;back=".urlencode($_SERVER['SCRIPT_NAME']."?".$_SERVER['QUERY_STRING'])."&amp;mbox=".(($std)?$std:(($label)?$label:''))."'>reply</a> ";
				// Reply to all; Added by Neerav; 4 May 2006
				if (count($mg["recv_email"]) > 1 or count($mg["cc_email"]) > 0) {
					echo " | <a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."compose.php?th=".$snapshot->conv_id."&amp;mg=".$mg["id"]."&amp;back=".urlencode($_SERVER['SCRIPT_NAME']."?".$_SERVER['QUERY_STRING'])."&amp;mbox=".(($std)?$std:(($label)?$label:''))."&amp;reall=1'>reply all</a>";
				}
				echo " | <a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."compose.php?th=".$snapshot->conv_id."&amp;mg=".$mg["id"]."&amp;back=".urlencode($_SERVER['SCRIPT_NAME']."?".$_SERVER['QUERY_STRING'])."&amp;mbox=".(($std)?$std:(($label)?$label:''))."&amp;forward=1'>forward</a>";
				echo " | <a href='".$widget_url."main.php?orig=1&amp;mg=".$mg["id"]."'>raw</a>";
/* 				if (!$mg['is_trashed']) echo " | <a href='".$widget_url."main.php?act=15&amp;t=".$mg["id"]."&amp;back=".urlencode($_SERVER['SCRIPT_NAME']."?".$_SERVER['QUERY_STRING'])."'>trash</a>"; */
				if (!$mg['is_trashed']) echo " | <a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."main.php?act=15&amp;t=".$mg["id"]."&amp;back=".urlencode($_SERVER['SCRIPT_NAME']."?th=".$snapshot->conv_id)."'>trash</a>";
				echo "]</td></tr>\n";

				// added display of images in html messages that have not yet been permitted; by Neerav; 20 April 2006
				if ($html and $mg['is_html'] and !$mg['html_images']) {
					echo "<tr class='altrow'><td align='center' colspan='2'>";
					echo "<a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."main.php?th=".$snapshot->conv_id."&amp;mg=".$mg["id"]."&amp;html=1&amp;himg=1'>display images below</a> | ";               
					echo "<a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."main.php?th=".$snapshot->conv_id."&amp;mg=".$mg["id"]."&amp;ashow=".rawurlencode($mg['sender_email'])."'>always display images from this sender</a>";
					echo "</td></tr>\n";
				}/*  elseif ($html and $mg['is_html']) { */
/* 					echo "<tr class='altrow'><td align='center' colspan='2'>"; */
/* 					echo "<a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."main.php?th=".$snapshot->conv_id."&amp;mg=".$mg["id"]."&amp;html=1&amp;himg=1'>display images below</a> | ";                */
/* 					echo "<a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."main.php?th=".$snapshot->conv_id."&amp;mg=".$mg["id"]."&amp;ashow=".rawurlencode($mg['sender_email'])."'>always display images from this sender</a>"; */
/* 					echo "</td></tr>\n"; */
/* 				} */

				// phishing warning; Neerav; Mar 2006
				if ($mg['warning']) {
					echo "<tr><td colspan='2' style='background-color:red'>".preg_replace('/<a [^>]*>[^<]*<\/a>/is',"",$mg['warning'])."</td></tr>";
				}
				if ($html) {
					// added support for inline images
					preg_match_all(
					//eregi('([^>]*alt="([^"]*))?[^>]*/mail/\?[^>]*attid=([^&]*)[^>]*(disp=emb)?[^>]*&amp;th=([a-zA-Z0-9]*)([^>]*alt="([^"]*))?', $text[$i], $matches);

						'@/mail/\?.*?attid=([^&]*).*?(disp=emb)+.*?&amp;th=(.*? alt="([^"]*))?@is'
						//'@<a \s*href(=|u003d)[\'|"](http://|https://)([^"\']*)[\'|"][^>]*>(.*?)</a>@is'
						,$mg["body"]
						,$matches, PREG_SET_ORDER | PREG_OFFSET_CAPTURE);
						$_SESSION['gm_msg_all_links'] = $matches;
/* 					print_r($matches); */
/* 					debug_print(print_r($matches,true)); */
					$count_links = count($matches);
					for ($link = $count_links-1; $link >= 0; $link--) {
						if (!isset($matches[$link][3])		// skip something that didn't match
								or
							preg_match("/\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}/",$matches[$link][3][0]) // skip IP addresses
							) continue;
						$mg["body"] = substr_replace(
							$mg["body"],
							'dl.php?aid='.$matches[$link][1][0].'&amp;m='.$matches[$link][3][0],
							$matches[$link][0][1],
							strlen($matches[$link][0][0])
						);
					}

					echo "<tr><td colspan='2'>".str_replace("- Show quoted text -", "", $mg["body"])."</td></tr>";
				} else {
					//$body = str_replace("- Show quoted text -", "", strip_tags($mg["body"],"<br>,<a>,<p>,<i>,<b>"));
/* 					$body = str_replace("- Show quoted text -", "", strip_tags($mg["body"],"<wbr><br>,<a>,<p>,<i>,<b>")); */

					// better handling of html to text conversion; 25 August 2006
					// Original regex by Peter de Bliek (http://phonifier.com)
					// modified by Neerav
					$body = $mg["body"];
					$search = array(
						// html-comments
						'@<!--(.*)-->@Usi'                                                                                                        
/* 						// encode wbr for later use; Neerav */
/* 						,'@<wbr />@' */
						,'@<wbr />@'	// get rid of the <wbr>
						// ??
						,'@\/\/<!\[CDATA\[.*?\/\/\]\]>@ism'
						//all javascript-triggers that results in an js-error
						,'@on(click|mouseover|mouseout|blur|error|focus|load|unload|submit|reset|abort|change|select)=(\'|").*(["\'])+( |>)@Usi'
						// remove stylesheets that a mobile phone doesn't use
						,'@<link(.*)media=(\'|")(screen|print)(\'|").*?'.'>\r\n@Uie'
						// script and object-tags
						,'@<(noedit|iframe|script)[^>]*?'.'>.*?<\/(noedit|iframe|script)>@ism'
						// script and object-tags
						,'@<(head|object|style|map)[^>]*?'.'>.*?<\/(head|object|style|map)>@ism'
						// empty body and p tags
						,'@<(body|p)[^>]*?'.'>@ism'
						// removes everything before the html tag
						,'@.*<html[^>]*?'.'>@ism'
						// replaces table row with <br/>
						,'@</tr>@ism'
						//remove tables,div,span,link,meta
						,'@<(\/)?(html|body|div|span|link|meta|font|center|noscript|frameset|noframes|table|tr|th|td|tbody|thead|tfoot)[^>]*?'.'>@ism'                                 
						// cleans extra line returns around list of links
						,'@<\/p>(\r\n)+\|(\r\n)+<p>@ism'
/* 						// compresses multiple <br> */
/* 						,'@((<br ?/?'.'>)+((\r)?\n)*)+@i' */
						// changes line returns into a space
						,'@(\r\n)+@'
						// removes styles from tags
						,'@(style)=(\'|").*(["\'])+( |>)@Usi'
						// converts frames into links
						,'@<frame.*src=(\'|")(.*)(\'|").*>@Uis'
						// removes target option from tags
						,'@(target)=(\'|")?.*(["\'])?( |>)@Usi'
						// remove quoted text text; Neerav
						,'@"?- Show quoted text -"?@'
						// remove spaces from <br /> and <wbr />; Neerav
						,'@<br />@ism'
						// corrects mailto: links to compose.php; Neerav
						,'@href=[\'|"]mailto:([^\'"]*)[\'|"]@ism'
/* 						// decodes wbr again; Neerav */
/* 						,'@\[\[wbr\]\]@ism' */
						// compress multiple whitespace; Neerav
						,'@(\s)+@'
						// remove empty tags (e.g. <strong></strong>
						,'/<([^>]+)>\s*<\/\1>/s'
						//images with alt
						,"/<img[^>]* alt=(\"([^\"]+)\"|'([^']+)'|([^\"'> ]+))[^>]*>/i"
						//images without alt
						,'/<img.*[^>]*?'.'>/Ui'
					);
					
					$replace = array(
						''			// remove html comments
/* 						,'[[wbr]]' 	// encodes <wbr> for later use*/
								,''	// get rid of the <wbr>
						,''			// ??
						,'\4'		// remove all javascript-triggers in tags
						,''			// remove unusable stylesheets
						,''			// remove script and object-tags
						,''			// remove script and object-tags
						,'<\1>'		// empty body and p tags
						,''			// remove everything before the html tag
						,'<br/>'	// replace table row with <br/>
						,''			// remove tables, div, span, link, meta
						,' | '		// cleans extra line returns around list of links
/* 						,'<br/>'	// compress multiple <br> */
						,' '		// changes line returns into a space
						,'\4'		// removes styles from tags
						,'Frame: <a href=\'?i=1&u=\2\'>\2</a><br/>'	// converts frames into links
						,'\4'		// removes target option from tags
						,''			// remove quoted text text
						,'<br/>'	// remove spaces from <br />
						,'href="compose.php?mailto=\1"'	// corrects mailto: links to compose.php
/* 						,'<wbr/>'	// decodes wbr again */
						,'\1'		// compress multiple whitespace
						,''			// remove empty tags 
						,"[$2$3$4] "// images with alt
						,'[img]'	// images without alt
					);
								   
					$body = preg_replace($search, $replace, $body);

					echo "\n<tr><td colspan='2'>\n".$body."\n</td></tr>\n";
				}
			}
		}
		echo "</table>";
	}

/* 	print_r($snapshot->conv); */
	// Added trashed messages in conversation lines; Neerav; Feb 2006
	if ($skipped > 0) {
		echo "<table width='100%' cellpadding='2' cellspacing='1' border='0'><tr class='altrow'>";
		echo "<td align='center'><img src='trash.gif' border='0' align='bottom' alt='X'> <span style=\"color:gray;background-color:inherit;font-size:9pt\">$skipped deleted messages in this conversation. <a href=\"".$widget_url."main.php?th=$th&amp;show=1\" style=\"font-size:9pt;\" onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\">View messages</a> or <a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href=\"".$widget_url."main.php?act=".GM_ACT_DELTRASHEDMSGS."&amp;t=".$snapshot->conv_id."&amp;back=".urlencode($widget_url."main.php?th=".$snapshot->conv_id)."\" style=\"font-size:9pt;\" onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\">delete forever</a>.</span>";
		echo "</td></tr></table>";
	}

	echo "<table width='100%' cellpadding='2' cellspacing='1' border='0'>";

	echo "<tr class='altrow'>";
	echo "<td align='left'>";
	if ($snapshot->conv_labels) {
		echo "<span class='label' style='font-size:11pt'>".$all_msg_labels."</span>";
	}

	// more intelligent menu; Neerav; 29 April 2006
	if (array_search("^i",$snapshot->conv_labels) !== false) {
		echo "<br /><input name='archive' type='submit' value='Archive' onclick=\"Modalbox.show('$widget_path/main.php', {title: 'Gmail-lite', width: 500, method: 'get', params: Form.serialize('box')+'&submit=archive'}); return false;\">";
	}
	echo "</td><td align='right'>";
	echo "<input type='hidden' name='t[]' value='".$snapshot->conv_id."'>";
	echo "<select name='act'><option value='0'>action:</option>";
	echo "<option value='-1'>===========</option>";
	if (array_search("^s",$snapshot->conv_labels) !== false) {
		echo "<option value='".GM_ACT_UNSPAM."'>unspam</option>\n";
	} elseif (array_search("^i",$snapshot->conv_labels) === false) {
		echo "<option value='".GM_ACT_INBOX."'>unarchive</option>\n\n";
	} else {
		echo "<option value='".GM_ACT_ARCHIVE."'>archive</option>\n";
	}
	echo "<option value='".GM_ACT_APPLYLABEL."'>apply label:</option>\n";
	if ($menu_remlabel) echo "<option value='".GM_ACT_REMOVELABEL."'>remove label:</option>\n";      
	if ($snapshot->conv_starred) {
		echo "<option value='".GM_ACT_UNSTAR."'>unstar</option>\n";
	} else {
		echo "<option value='".GM_ACT_STAR."'>star</option>\n";
	}
	// don't need a "read" option while reading a conversation!
	/* echo "<option value='7'>read</option>\n" */
	echo "<option value='".GM_ACT_UNREAD."'>unread</option>\n";
	if (array_search("^s",$snapshot->conv_labels) === false) {
		echo "<option value='".GM_ACT_SPAM."'>spam</option>\n";
	}
	echo "<option value='-1'>--------</option>\n";
	if (array_search("^k",$snapshot->conv_labels) === false  or $skipped or $showhid) {
		echo "<option value='".GM_ACT_TRASH."'>trash conv</option>\n";
	}	
	if (array_search("^k",$snapshot->conv_labels) !== false or $skipped) {
		echo "<option value='".GM_ACT_UNTRASH."'>untrash conv</option>\n";
	}	
	if (array_search("^r",$snapshot->conv_labels) !== false) {
		echo "<option value='".GM_ACT_UNDRAFT."'>discard draft</option>\n";
	}	
	if ($std === "spam")
		$act_code = GM_ACT_DELSPAM;
	elseif ($std === "trash")
		$act_code = GM_ACT_DELTRASHED;
	else
		$act_code = GM_ACT_DELFOREVER;         
	echo "<option value='-1'>===========</option>\n<option value='".$act_code."'>!!!DEL FOREVER!!!</option>\n";
	echo "</select> <select name='lbl'><option value=''>label:</option>";
	$count_label = count($snapshot->label_list);
	for ($i = 0; $i < $count_label; $i++) {
		// skip gmskin settings; Neerav; 25 April 2006
		if (strpos($snapshot->label_list[$i], "gmskin:") !== false) continue;     
		echo "<option value='".$snapshot->label_list[$i]."'";
		echo ">".$snapshot->label_list[$i]."</option>";
	}
	echo "</select> <input type='submit' value='Do'>";
	echo "</td></tr>";

	// "back to mailbox"; Added by Neerav; 22 April 2006
	// Prev/next; Added by Neerav; 13 Nov 2006
	if ($session_method & GM_USE_PHPSESSION and isset($_SESSION['mbox_cache'])) {
		$next_exists = false;
		$prev_exists = false;
		$total_cached_box = count($_SESSION['mbox_cache']);
		for ($i = 0; $i < $total_cached_box; $i++) {
			if ($_SESSION['mbox_cache'][$i]['id'] == $snapshot->conv_id) {
				if (isset($_SESSION['mbox_cache'][$i+1]['id'])) {
					$next_exists = true;
				}
				if (isset($_SESSION['mbox_cache'][$i-1]['id'])) {
					$prev_exists = true;
				}
				break;
			}
		}
		echo "<tr class='optrow'><td colspan='2'><table width='100%' cellpadding='2' cellspacing='0' border='0'><tr>"
		 ."<td><a href=\"main.php?".str_replace("&","&amp;",$last_mbox_path)."\">&lt;&lt; Back to ".$last_mbox."</a></td>"
		 ."<td align='right'>"
		 .(($prev_exists) ? '<a href="main.php?pc='.$snapshot->conv_id.'">&lt; Prev</a>' : "")
		 .(($next_exists and $prev_exists) ? " | " : "")
		 .(($next_exists) ? '<a href="main.php?nc='.$snapshot->conv_id.'">Next &gt;</a>' : "")
		 ."</td></tr></table></td></tr>";
	} else {
		echo "<tr class='optrow'><td colspan='2'><a href=\"main.php?".str_replace("&","&amp;",$last_mbox_path)."\">&lt;&lt; Back to ".$last_mbox."</a></td></tr>";
	}

}

?>
</table><input type="hidden" name="back" value="<? echo $_SERVER['SCRIPT_NAME'].'?'.urlencode($_SERVER['QUERY_STRING']) ?>"></form>
</td></tr><tr><td align="right"><i style="color:brown;font-size:8pt">gmail-lite <? echo GL_VER ?>, with libgmailer <? echo GM_VER ?></i></td></tr></table>
<a name="down"> </a>
</body>
</html>

<? } else { 

/// summary page

?>
<form id="summary" name="summary" action="<?php echo $widget_url;?>main.php" method="get">
<input type="text" name="query">
</form>
<input type="button" value="Search mail" onclick="Modalbox.show('<?php echo $widget_url;?>main.php',{title: 'Gmail-lite', params: Form.serialize('summary')}); return false;">
<table width="100%" cellpadding="2" cellspacing="1" border="0">
<?

// Webclips; Added by Neerav; 22 April 2006
if (
	(($session_method & GM_USE_PHPSESSION) and isset($_SESSION['dis_web_clip']) and $_SESSION['dis_web_clip'])
		or
	(isset($_COOKIE['gmail-lite_webclips']) and $_COOKIE['gmail-lite_webclips'])
	) {
	if (isset($snapshot->web_clips[0])) {
		display_web_clip($snapshot->web_clips[0], 2);
	}
}

/* print_r($snapshot); */
/* debug_print("persistent searches (main): ".print_r(parse_persist_searches(),true)); */
//debug_print("persistent searches (main): ".print_r($searches,true));

$display_count 	= count($display_boxes);
// Summary display based on mobile settings; Neerav; 14 May 2006
$stdbox_count 	= count($stdbox);
$show_std 		= array();
for ($i = 0; $i < $stdbox_count; $i++) {
	if (	(array_search(strtolower($stdbox[$i]), $display_boxes) !== false)
				or 
			!$display_selective
				or
			strtolower($stdbox[$i]) == "chats"
		) {
		if (isset($snapshot->std_box_new[$i]) and $snapshot->std_box_new[$i] > 0) {
			$show_std[] = "<td><a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."main.php?std=".strtolower($stdbox[$i])."'><b>".$stdbox[$i]." (".$snapshot->std_box_new[$i].")</b></a></td>\n";
		} else {
			$show_std[] = "<td><a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."main.php?std=".strtolower($stdbox[$i])."'>".$stdbox[$i]."</a></td>\n";
		}
	}
}

$show_label 	= array();
$label_count 	= count($snapshot->label_list);
for ($l = 0; $l < $label_count; $l++) {
	if (	(array_search($snapshot->label_list[$l], $display_boxes) !== false)
					or 
			!$display_selective
		) {
		$line = "";
		if (strpos($snapshot->label_list[$l], "gmskin:") !== false) {
			// skip gmskin settings; Neerav; 25 April 2006
			continue;
		} elseif ($snapshot->label_new[$l] > 0) {
			$line .= "<td><a class='label llabel' href='".$widget_url."main.php?label=".rawurlencode($snapshot->label_list[$l])."'><b>".$snapshot->label_list[$l]." (".$snapshot->label_new[$l];
			if ($show_total) {
				$line .= "/".$snapshot2->label_total[$l];
			}
			$line .= ")</b></a></td>\n";
		} else {
			$line .= "<td><a class='label llabel' href='".$widget_url."main.php?label=".rawurlencode($snapshot->label_list[$l])."'>".$snapshot->label_list[$l]." (0";
			if ($show_total) {
				$line .= "/".$snapshot2->label_total[$l];
			}
			$line .= ")</a></td>\n";
		}
		
		if ($line != "") $show_label[] = $line;
		
	}
}

$searches 		= parse_persist_searches();
$search_count 	= count($searches['searches']);
$show_search	= array();
for ($i = 0; $i < $search_count; $i++) {
	$show_search[] = "<td><a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."main.php?query=".$searches['searches'][$i]['query']."'>".urldecode($searches['searches'][$i]['label'])."</a></td>\n";
}

$stdbox_count 	= count($show_std);
$label_count 	= count($show_label);
$search_count 	= count($show_search);
$left_menu_count = $stdbox_count + $search_count + (($search_count) ? 2 : 0); // add 2 rows 
echo "<tr class='altrow' align='center'><td><b style='text-decoration:underline'>Standard</b></td><td><b class='label llabel' style='text-decoration:underline;font-weight:bold'>Labels</b></td></tr>\n";
for ($i = 0, $l = 0, $color = 1; ($i < $left_menu_count || $l < $label_count); $i++,$l++) {
	
	$line = "";
	if ($color % 2 == 0) {
		$line .= "<tr class='altrow' align='center'>";
	} else {
		$line .= "<tr align='center'>";
	}
	
	if (isset($show_std[$i])) {
		$line .= $show_std[$i];
	} elseif ($search_count > 0 and $i > $stdbox_count) {
		if ($i == $stdbox_count) {
			// blank separator line
			$line .= "<td>&nbsp;</td>";
		} elseif ($i == $stdbox_count+1) {
			// section title
			$line .= "<td><b style='text-decoration:underline'>Quick Searches</b></td>";
		} elseif ($i > $stdbox_count+1 and $i < $left_menu_count) {
			// display persistant search
			$line .= $show_search[$i-$stdbox_count-2];
		} else {
			// else a blank line for the labels
			$line .= "<td>&nbsp;</td>";
		}
	} else {
		$line .= "<td>&nbsp;</td>";
	}

	if (isset($show_label[$l])) {
		$line .= $show_label[$l];
	} else {
		$line .= "<td>&nbsp;</td>";
	}
	$line .= "</tr>\n";
	echo $line;
	$color++;
}

?>
</table>   
</td></tr>
<tr class='optrow'><td align="center"><a onclick="Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;" href="<? echo $widget_url; ?>preferences.php?pref=mobile">Customize this Summary page</a></td></tr>
<tr><td align="center" style="color:<? echo $snapshot->quota_col ?>;"><? 
	// some accounts have MB in the quota amounts, some do not
	echo "You are currently using "
	.$snapshot->quota_mb.((strpos($snapshot->quota_mb,"MB") === false) ? "&nbsp;MB": "" )
	." (".$snapshot->quota_per.((strpos($snapshot->quota_per,"%") === false) ? "%": "" ).") of your "
	.$snapshot->quota_tot.((strpos($snapshot->quota_tot,"MB") === false) ? "&nbsp;MB": "" )."."
?></td>
</tr>
<tr><td align="right"><i style="color:brown;font-size:8pt">gmail-lite <? echo GL_VER ?>, with libgmailer <? echo GM_VER ?></i></td></tr></table>
<a name="down"> </a>
<? //debug_print(print_r($gm,true)); ?></body>
</html>

<? } 


// common navigation line; Neerav; Feb 2006
// fixed ending conversation numbers and prev/next buttons; Neerav; 31 Oct 2006
function navigation_line($columns = 3) {
	global $pos, $query, $std, $label, $unread, $snapshot, $displayed_convs;
	
	// Added oldest/newest links; Neerav; 16 Nov 2006
	
	//print_r($snapshot);
	$displayed = ($snapshot->box_display <= M_DISPLAY_CONVS) ? $snapshot->box_display: M_DISPLAY_CONVS;

	echo "<td colspan='".$columns."'><table width='100%' cellpadding='2' cellspacing='1' border='0'><tr>";
	
	$newer = "";
	if ($pos >= 2 * M_DISPLAY_CONVS) {
		$newer .= "<a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."main.php?"
			.(($query) ? "&amp;query=".urlencode($query) : "")
			.(($std) ? "&amp;std=".$std : "")
			.(($label) ? "&amp;label=".urlencode($label) : "")
			.(($unread) ? "&amp;unread=".$unread : "")
			."&amp;pos=0"
			."'>&lt;&lt;Newest</a>";
	}
	if ($pos > 0) {
		$p = ($pos >= $displayed) ? $pos-$displayed : 0;
/* 		echo "<td align='left'><a href='".$widget_url."main.php?" */
		if ($newer !== "") $newer .= " ";
		$newer .= "<a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."main.php?"
			.(($query) ? "&amp;query=".urlencode($query) : "")
			.(($std) ? "&amp;std=".$std : "")
			.(($label) ? "&amp;label=".urlencode($label) : "")
			.(($unread) ? "&amp;unread=".$unread : "")
			.(($p) ? "&amp;pos=".$p : "")
			."'>&lt;Newer</a>";
	}/*  else { */
/* 		echo "<td>&nbsp;</td>"; */
/* 	} */
	
	echo ($newer !== "") ? "<td align='left'>$newer</td>": "<td>&nbsp;</td>";

	$start = $pos+1;
	$end = ($pos + $displayed > $snapshot->box_total) ? $snapshot->box_total : $pos + $displayed;
	
	if ($end != 0) {
		echo "<td align='center'><b>$start</b> - <b>$end</b> of <b>".$snapshot->box_total."</b></td>";
	} else {
		echo "<td align='center'><b>No conversations</b></td>";
	}
	
	$older = "";
	if ($pos < $snapshot->box_total-$displayed) {
		$p = $pos+$displayed;
		$older .= "<a  onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."main.php?"
			.(($query) ? "&amp;query=".urlencode($query) : "")
			.(($std) ? "&amp;std=".$std : "")
			.(($label) ? "&amp;label=".urlencode($label) : "")
			.(($unread) ? "&amp;unread=".$unread : "")
			.(($p) ? "&amp;pos=".$p : "")
			."'>Older&gt;</a>";
	}/*  else { */
/* 		echo "<td>&nbsp;</td>"; */
/* 	} */

	$very_last_page = ((ceil($snapshot->box_total/M_DISPLAY_CONVS)-1) * M_DISPLAY_CONVS);
	if ($very_last_page > $pos + M_DISPLAY_CONVS) {
		if ($older !== "") $older .= " ";
		$older .= "<a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', width: 600}); return false;\" href='".$widget_url."main.php?"
			.(($query) ? "&amp;query=".urlencode($query) : "")
			.(($std) ? "&amp;std=".$std : "")
			.(($label) ? "&amp;label=".urlencode($label) : "")
			.(($unread) ? "&amp;unread=".$unread : "")
			."&amp;pos=".$very_last_page
			."'>Oldest&gt;&gt;</a>";
	
	}

	echo ($older !== "") ? "<td align='right'>$older</td>": "<td>&nbsp;</td>";

	echo "</tr></table></td>";

}

// Webclips; Added by Neerav; 22 April 2006
function display_web_clip($clip, $columns = 0) {

	// if webclip empty or incomplete, return nothing.
	if (!isset($clip["title"]) or trim($clip["title"]) == "") return;

	echo "<tr class='webclip'>".(($columns)?"<td colspan='".$columns."'>":"<td>");
	echo "<table width='100%'><tr>\n";
	echo "<td>".((trim($clip["site"]) != "") ? $clip["site"]." - ": "")
		.((trim($clip["url"]) != "") ? "<a href=\"".$clip["url"]."\">".$clip["title"].$clip["sub"]."</a>" : $clip["title"].$clip["sub"]);
	echo (trim($clip["date"]) != "") 
		? " <span style=\"color:gray\">-&nbsp;"
			.str_replace(" ","&nbsp;",$clip["date"])
			."</span>"
		: ""
		;
	echo "</td>\n";
	echo "<td align='right'><span style=\"color:gray\">"./* str_replace(" ","&nbsp;", */$clip["type"]/* ) */."</span></td>\n";
	echo "\n</tr></table></td></tr>\n";
	// blank line/space
	//echo "<tr>".(($columns)?"<td colspan='".$columns."'>":"<td>")."&nbsp;</td></tr>";

} 

// Webclips; Added AGAIN by Neerav; 13 May 2006
function get_web_clip() {
	global $session_method;
	
	$web_clips = array();
	$time = time();
	
	if ($session_method & GM_USE_PHPSESSION) {
		if (!isset($_SESSION['last_web_clip_time'])) $_SESSION['last_web_clip_time'] = $time;
		if ($time < $_SESSION['last_web_clip_time']+30) {
			if (isset($_SESSION['last_web_clip'])) {
				return $_SESSION['last_web_clip'];
			} else {
				return array();
			}
		}
		if (isset($_SESSION['dis_web_clip']) and $_SESSION['dis_web_clip']) {
			$web_clips = $_SESSION['web_clips'];
		} else {
			return array();
		}
	} else {
		if (isset($_COOKIE['gmail-lite_webclips']) and $_COOKIE['gmail-lite_webclips']) {
			if (isset($_COOKIE['gmail-lite_clips']) and $_COOKIE['gmail-lite_clips'] != "") {
				if (!($web_clips = @unserialize(gzuncompress(base64_decode($_COOKIE['gmail-lite_clips']))))) {
					$web_clips = array();
					//debug_print("web clips serialized: ".print_r(gzuncompress(base64_decode($_COOKIE['gmail-lite_clips'])),true));
				}
			} else {
				$web_clips = array();
			}
		} else {
			return array();
		}
	}

	// if webclip is empty, retrieve
	if (!isset($web_clips[0])) {
		global $gm;
		$web_clips = $gm->webClip();
	}


	$clip = array_shift($web_clips);
	
	if ($session_method & GM_USE_PHPSESSION) {
		$_SESSION['web_clips'] = $web_clips;
		$_SESSION['last_web_clip'] = $clip;
		$_SESSION['last_web_clip_time'] = $time;
	} else {
		//debug_print("web clips: ".print_r($web_clips,true));
		setcookie("gmail-lite_clips", base64_encode(gzcompress(serialize($web_clips))));
	}

	return $clip;
} 


// Display status information; by Neerav; 29 April 2006
function display_status($status) {
	$status = trim(stripslashes($status));
	if ($status == "") return;
	echo "<table align='center' cellpadding='2' cellspacing='1' border='0'>";
	echo "<tr class='status'><td><b>&nbsp;&nbsp;".$status."&nbsp;&nbsp;</b></td></tr>\n";
	echo "<tr><td></td></tr></table>\n";
}

// Get last visited mailbox/label/search; Added by Neerav; 10 May 2006
function get_last_mailbox() {
	global $session_method;
	
	if ($session_method & GM_USE_PHPSESSION) {
		$mailbox = explode("::",$_SESSION['last_mbox']);
	} else {
		//debug_print("last_mbox cookie: ".base64_decode($_COOKIE['gmail-lite_last_mbox']));
		if (isset($_COOKIE['gmail-lite_last_mbox'])) {
			$mailbox = explode("::",base64_decode($_COOKIE['gmail-lite_last_mbox']));
		}
	}
	
	$last_mbox = (isset($mailbox[0])) ? $mailbox[0]: "(error. pls report.)" ;
	$last_mbox_path = (isset($mailbox[1])) ? $mailbox[1]: "" ;
	
	return array($last_mbox,$last_mbox_path);
}

?>
