<html>
<body>
<?php

// Test 0 (php): if you can read this, you do not have PHP installed!

// Test 1 (safe mode)
$test1 = 1;
echo "<p>Test 1 (safe mode): ";
if (@ini_get('safe_mode') == true) {
	$test1 = 2;
}
switch ($test1) {
	case 1:
		echo "<font color=\"green\"><b>passed</b></font>."; break;
	case 2:
		echo "<font color=\"red\"><b>FAILED</b></font>. Safe-mode restrictions in effect.  Some features will not be available or not work correctly in php safe-mode.  You may continue, but it is recommended that you use another server.";
		break;
	default:
		echo "<font color=\"red\"><b>FAILED</b></font>. Something's wrong with your PHP...";
		break;
}
echo "</p>\n"; 

// Test 2 (curl extension)
$test1 = 1;
echo "<p>Test 2 (curl extension): ";
if (!extension_loaded('curl')) {
	if (!dl('php_curl.dll') && !dl('curl.so')) {
		$test1 = 3;
	}
}   
if (!function_exists("curl_setopt")) {         
	$test1 = 2;
}
switch ($test1) {
	case 1:
		echo "<font color=\"green\"><b>passed</b></font>."; break;
	case 2:
		echo "<font color=\"red\"><b>FAILED</b></font>. It seems that you do not have CURL installed. You may read <a href='http://www.php.net/manual/en/ref.curl.php'>this</a> for more infos on CURL in PHP.";
		break;
	case 3:
		echo "<font color=\"red\"><b>FAILED</b></font>. It seems that you have CURL installed but failed to load it. Here we assume the library filename is php_curl.dll (for WIN) or curl.so (for *NIX). If not, you may have to modify the source code for that.";
		break;
	default:
		echo "<font color=\"red\"><b>FAILED</b></font>. Something's wrong with your PHP...";
		break;
}
echo "</p>\n"; 

// Test 3 (curl)
$test2 = 1;
echo "<p>Test 3 (curl http): ";   
$c = curl_init();
curl_setopt($c, CURLOPT_RETURNTRANSFER, 1);
if (	version_compare(PHP_VERSION, "4.4.4", ">=") 
	and version_compare(PHP_VERSION, "5.0.0", "<") 
	and ini_get('open_basedir') != ""
	) {
	
} else {
	curl_setopt($c, CURLOPT_FOLLOWLOCATION, 1);
}
curl_setopt($c, CURLOPT_URL, "http://www.google.com/");
curl_setopt($c, CURLOPT_USERAGENT, "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.4b) Gecko/20040612 Mozilla Firebird/0.9");
curl_setopt($c, CURLOPT_HEADER, 1);
curl_setopt($c, CURLOPT_REFERER, "http://www.linux.org/");
$result = curl_exec($c);
if (strlen($result) == 0) {
 $test2 = 2;
} else {
 if (strpos(strtolower($result), "google") === false || strpos(strtolower($result), "</html>") === false) {  // www.google.com without google: impossible, right?
	$test2 = 4;
 }
}
if (curl_errno($c) != 0) {
 $test2 = 3;
 $cerr = curl_error($c);
}
curl_close($c);
switch($test2) {
 case 1:
	echo "<font color=\"green\"><b>passed</b></font>.";
	break;
 case 2:
	echo "<font color=\"red\"><b>FAILED</b></font>. Nothing could be obtained by curl. Please check your curl settings.";
	break;
 case 3:
	echo "<font color=\"red\"><b>FAILED</b></font>. CURL error: ".$cerr.". Please check your curl settings.";
	break;
 case 4:
	echo "<font color=\"red\"><b>FAILED</b></font>. Failed to connect to the dedicated host: www.google.com. Result: <pre>".$result."</pre>";
	break;
 default:
	echo "<font color=\"red\"><b>FAILED</b></font>. Something's wrong with your PHP...";
	break;
}
echo "</p>\n"; 

// Test 4 (curl https)
$test3 = 1;
echo "<p>Test 4 (SSL via curl): ";   
$c = curl_init();
curl_setopt($c, CURLOPT_RETURNTRANSFER, 1);
if (	version_compare(PHP_VERSION, "4.4.4", ">=") 
	and version_compare(PHP_VERSION, "5.0.0", "<") 
	and ini_get('open_basedir') != ""
	) {
	
} else {
	curl_setopt($c, CURLOPT_FOLLOWLOCATION, 1);
}
curl_setopt($c, CURLOPT_URL, "https://mail.google.com/mail");
curl_setopt($c, CURLOPT_USERAGENT, "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.4b) Gecko/20040612 Mozilla Firebird/0.9");
curl_setopt($c, CURLOPT_HEADER, 1);
curl_setopt($c, CURLOPT_SSL_VERIFYPEER, FALSE);
curl_setopt($c, CURLOPT_SSL_VERIFYHOST,  2);   
curl_setopt($c, CURLOPT_REFERER, "http://www.linux.org/");
$result = curl_exec($c);
if (strlen($result) == 0) {
	$test3 = 2;
} elseif (	version_compare(PHP_VERSION, "4.4.4", ">=") 
	and version_compare(PHP_VERSION, "5.0.0", "<") 
	and ini_get('open_basedir') != ""
	and strpos($result, "302 Moved Temporarily") !== false
	) {
	$test3 = 5;
} else {
	if (strpos(strtolower($result), "google") === false || strpos(strtolower($result), "</html>") === false) {  // mail.google.com without google: impossible, right?
		$test3 = 4;
	}
}
if (curl_errno($c) != 0) {
	$test3 = 3;
	$cerr = curl_error($c);
}
curl_close($c);
switch($test3) {
 case 1:
	echo "<font color=\"green\"><b>passed</b></font>.";
	break;
 case 2:
	echo "<font color=\"red\"><b>FAILED</b></font>. Nothing could be obtained by curl. Please check your curl-ssl settings.";
	break;
 case 3:
	echo "<font color=\"red\"><b>FAILED</b></font>. CURL error: ".$cerr.". Please check your curl-ssl settings.";
	break;
 case 4:
	echo "<font color=\"red\"><b>FAILED</b></font>. Failed to connect to the dedicated host: mail.google.com. Result: <pre>".$result."</pre>";
	break;
 case 5:
	echo "<font color=\"green\"><b>provisionally passed</b></font>.  <font color=\"red\">See Test 4b.</font>";
	break;
 default:
	echo "<font color=\"red\"><b>FAILED</b></font>. Something's wrong with your PHP...";
	break;
}
echo "</p>\n"; 

// Test 4b (GAfYD, php 4.4.4, open_basedir)
if (	version_compare(PHP_VERSION, "4.4.4", ">=") 
	and version_compare(PHP_VERSION, "5.0.0", "<") 
	and ini_get('open_basedir') != ""
	) {
	echo "<p>Test 4b (GAfYD, php >= 4.4.4, open_basedir): ";
	echo "<font color=\"red\"><b>WARNING</b></font>. open_basedir restriction in effect.  All features may not work properly.  Please contact the author or post in the support forum if such a feature is discovered.";
	echo "</p>\n"; 
}

// Test 5 (PHP session)
$test4 = 1;
echo "<p>Test 5 (PHP session extension): ";
if (!extension_loaded('session')) {
 if (!@dl('php_session.dll') && !@dl('session.so')) {
	$test4 = 3;
 }
}   
if (!function_exists("session_start")) {         
 $test4 = 2;
}
switch ($test4) {
 case 1:
	echo "<font color=\"green\"><b>passed</b></font>."; break;
 case 2:
	echo "<font color=\"red\"><b>FAILED</b></font>. It seems that you do not have PHP Session installed. You may read <a href='http://www.php.net/manual/en/ref.session.php'>this</a> for more infos on PHP Session.";
	break;
 case 3:
	echo "<font color=\"red\"><b>FAILED</b></font>. It seems that you have PHP Session installed but failed to load it. Here we assume the library filename is php_session.dll (for WIN) or session.so (for *NIX). If not, you may have to modify the source code for that.";
	break;
 default:
	echo "<font color=\"red\"><b>FAILED</b></font>. Something's wrong with your PHP...";
	break;
}
echo "</p>\n"; 


// Test 6 (trans_sid)
/* $test_trans = 1; */
/* echo "<p>Test 6 (trans_sid): currently not applicable for gmail-lite"; */
/* echo "</p>\n";  */

// Test 7 (argument separator)
/* $test_sep = 1; */
/* echo "<p>Test 7 (argument separator): "; */
/* ini_set('arg_separator.output', '&amp;'); */
/*  */
/* if (ini_get("arg_separator.output") != '&amp;' ) { */
/* 	$test_sep = 2; */
/* }    */
/*  */
/* switch ($test_sep) { */
/*  case 1: */
/* 	echo "<font color=\"green\"><b>passed</b></font>."; break; */
/*  case 2: */
/* 	echo "<font color=\"red\"><b>FAILED</b></font>. Could not set the arg_separator.output.  Please follow the directions in SERVER_HELP for 'Argument separator'."; */
/* 	break; */
/*  default: */
/* 	echo "<font color=\"red\"><b>FAILED</b></font>. Something's wrong with your PHP..."; */
/* 	break; */
/* } */
/* echo "</p>\n";  */

// Test 8 (session name)
/* $test_name = 1; */
/* echo "<p>Test 8 (session name): "; */
/* ini_set("session.name", "sess"); */
/*  */
/* if (ini_get("session.name") != 'sess' ) { */
/* 	$test_name = 2; */
/* }    */
/*  */
/* switch ($test_name) { */
/*  case 1: */
/* 	echo "<font color=\"green\"><b>passed</b></font>."; break; */
/*  case 2: */
/* 	echo "<font color=\"red\"><b>FAILED</b></font>. Could not set the session name.  This is NOT CRUCIAL.  You may wish to follow the directions in SERVER_HELP for 'Session Name' if you wish to save a few bytes in page size and/or download speed.  Otherwise, gmail-mobile will still work correctly."; */
/* 	break; */
/*  default: */
/* 	echo "<font color=\"red\"><b>FAILED</b></font>. Something's wrong with your PHP..."; */
/* 	break; */
/* } */
/* echo "</p>\n";  */


// Test 9 (short tags)
$test_short = 1;
echo "<p>Test 9 (short tags): ";
if (ini_get("short_open_tag") == false ) {
	$test_short = 2;
}   
switch ($test_short) {
 case 1:
	echo "<font color=\"green\"><b>passed</b></font>."; break;
 case 2:
	echo "<font color=\"red\"><b>FAILED</b></font>. Your server REQUIRES long php parsing tags.  Please follow the directions in SERVER_HELP for 'Short Open Tags'.  Either that, or you have to edit ALL of the gmail-mobile files...!";
	break;
 default:
	echo "<font color=\"red\"><b>FAILED</b></font>. Something's wrong with your PHP...";
	break;
}
echo "</p>\n"; 


echo "<p>If you have passed <b>all</b> tests, you should have no problem installing and using gmail-lite and libgmailer.</p>\n";

?>
<p>The information below is for debugging or support.</p>
<p><?php phpinfo(); ?></p>
</body>
</html>