<?php


/** fsol **/
require("settings.php");
/** config.php **/

require_once("libgmailer.php");

/** for accessing with proxy **/
define("P_PROXY",   "");
define("P_USER",    "");
define("P_PWD",     "");
  
/** **/
/** for session management method, must pick one of the following three options **/
/** **/

/** This one is recommended, will remember your signin for a week, with minimal cookies, 
	similar to Gmail's "Remember me" option **/
$session_method = (GM_USE_PHPSESSION | GM_USE_COOKIE);  // if you are going to use PHP Session and with cookies

/** This one is recommended if you want the session to automatically expire 
	after 20-40 minutes even if you do not signout.
	This option will also allow users to sign into more than one
	account at a time in separate browser windows **/
//$session_method = (GM_USE_PHPSESSION | !GM_USE_COOKIE);  // if you are going to use PHP Session, but without cookies

/** This one will remember your signin for a week, but will use 
	almost a dozen cookies and thus higher bandwidth.
	Some gmail-lite features WILL NOT be available **/
//$session_method = (!GM_USE_PHPSESSION | GM_USE_COOKIE);  // if you do not have, or are not going to use PHP Session (then you must use cookies)

/** **/
/** END session management method **/
/** **/

/** for composing **/  
define("C_ATTACHMENT",    		0);			// 0 => attachment not allowed, 1 => allowed
// 1024 KB = 1 MB
// 5120 KB = 5 MB
define("C_ATTACHMENT_LIMIT", 	5120);		// Attachment size limit in KILOBYTES -- 0 => unlimited
define("C_VIEW_ATTACHMENT_LIMIT", 0);	// Attachment viewing size limit in KILOBYTES -- 0 => unlimited, -1 => OFF
define("C_SIGNATURE_ON_TOP", 	0);		// 0 => signature placement (default -- at the bottom), 1 => signature BEFORE the reply

/** auto-refresh of Summary **/
define("S_REFRESH_SEC",   		300);		// second to refresh summary page; 0 => no auto-refresh

/** display total no. of conversation for each label in the summary page (may make it slow to render) **/
define("S_SHOW_TOTAL",  		1);			// 1 => display, 0 => not display

/** Display x conversations per screen **/
define("M_DISPLAY_CONVS",  		10); 		// number of conversations to display per screen (default is 10)

/** Default display of messages: text or HTML **/
define("M_DISPLAY_HTML_ALWAYS",	0); 		// 0 => display messages as text (default), 1 => display as HTML
	
/** Placement of the checkbox: left (websites) or right (pdas)  **/
define("M_CHECKBOX_ON_RIGHT",	1); 		// 0 => display checkbox on left, 1 => display checkbox on right (default)

/** Show invite link in navigation bar.  The link will ALWAYS show in the Summary. **/
define("N_SHOW_INVITES",		0); 		// 0 => hide invites link, 1 => show invites on all pages

/** for debugger/debugging **/
$D_FILE 	= "tmp/debug.php";     // debugging data file, should be in PHP for security reason
$D_ON 		= 0;               // debugging mode. 0 => off, 1 => on
// log, rather than display errors
ini_set('log_errors', false);		
ini_set('display_errors', false);
// log an error only once per script, rather than every instance
ini_set('ignore_repeated_errors', true);	
// level of error reporting
error_reporting(E_ALL);


/**** please do NOT modify the code after this line ****/
	
/** gmail-lite version **/
define("GL_VER",     "0.10 beta 7");   

if ($session_method & GM_USE_PHPSESSION) {
	@ini_set("session.name", "gmail-lite_session");
}

/** quick init. gmailer for gmail-lite **/
function quick_init(&$gmailer) {
	  global $session_method;
	  
	  if ($gmailer->created) {
		 if (strlen(P_PROXY) > 0)
			$gmailer->setProxy(P_PROXY, P_USER, P_PWD);
		 if (isset($session_method))
			$gmailer->setSessionMethod($session_method);
	  }
	  return 0;
}
	
function print_headers() {
	
	$charset = "utf-8";
	
	// set the correct MIME document type
	header("Content-type: text/html; charset=".$charset);
	
	// headers to prevent caching
	//header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");	// expires in the past
	//header("Cache-Control: no-cache, must-revalidate");	// Prevent caching, HTTP/1.1
	//header("Pragma: no-cache");							// Prevent caching, HTTP/1.0
	//header("Cache-Control: max-age=1");					// "caches for only 1 second
	
	echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"". " \"http://www.w3.org/TR/html4/loose.dtd\">";
}
	
function print_meta() {
	
	$charset = "utf-8";
	?>
<meta content="text/html; charset=<? echo $charset ?>" http-equiv="content-type">
	<?
}
	
function debug_print($str,$filename = "debug.php") {
	if ($filename == "") {
		global $D_FILE;
		$filename = $D_FILE;
	}
	$fd = fopen($filename, "a+");
	fwrite($fd, "<?php /**\n".date("l jS of F Y h:i:s A",time())."\n".str_replace("    ", "\t",$str)." **/ ?".">\n");
	fclose($fd);
}
	
Debugger::say("======== ".date("j M Y H:i:s")." entry begin ===============================");
	
function navigation_links($invites = 0, $show_invites = N_SHOW_INVITES) {
	global $session_method, $widget_url;
	$script = basename($_SERVER['SCRIPT_NAME']);

	//echo '<p>';
	if ($session_method & GM_USE_PHPSESSION) {
		$gmail_address = (isset($_SESSION['gmail_address']) and $_SESSION['gmail_address']) 
			? $_SESSION['gmail_address']
			: ""
			;
	} else {
		$gmail_address = (isset($_COOKIE['gmail-lite_email']) and $_COOKIE['gmail-lite_email']) 
			? base64_decode($_COOKIE['gmail-lite_email']) 
			: ""
			;
	}

	echo "<a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', height: 600, method: 'get', params: ''}); return false;\" href='".$widget_url."main.php?sum=1'>summary</a> | ";
	echo "<a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', height: 600, method: 'get', params: ''}); return false;\" href='".$widget_url."main.php?std=inbox'>inbox</a> | ";
	echo "<a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', height: 600, method: 'get', params: ''}); return false;\" href='".$widget_url."main.php?unread=1'>unread</a> | ";
	$this_url = strlen($_SERVER['QUERY_STRING']) > 0 
		? urlencode($_SERVER['SCRIPT_NAME']."?".$_SERVER['QUERY_STRING']) 
		: urlencode($_SERVER['SCRIPT_NAME'])
		; 
	if ($script != "compose.php")
		echo "<a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', height: 600, method: 'get', params: ''}); return false;\" href='".$widget_url."compose.php?back=".$this_url."'>compose</a> | ";
	if ($script != "preferences.php")
		echo "<a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', height: 600, method: 'get', params: ''}); return false;\" href='".$widget_url."preferences.php'>settings</a> | ";

	if ($script != "preferences.php" and $invites > 0 and $show_invites) { 
 		echo "<a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', height: 600, method: 'get', params: ''}); return false;\" href='".$widget_url."invite.php?back=".$this_url."&amp;num=".$invites."'>invite ".$invites."</a> | "; 
	}      
	echo "<a onclick=\"Modalbox.show(this.href, {title: 'Gmail-lite', height: 600, method: 'get', params: ''}); return false;\" href='".$widget_url."logout.php' style='color:red'>logout</a>";
	if ($gmail_address) echo " | ".$gmail_address;
	//echo "</p>";
	echo "<br /><br />";

}

// check if all required cookies exist
function check_cookie() {
	global $session_method;	
	
	if ($session_method == (GM_USE_PHPSESSION | GM_USE_COOKIE)) {
		if (	!isset($_COOKIE['gmail-lite_cookie'])
			//or	!isset($_COOKIE['gmail-lite_key'])
		) {
			global $gm;
			$gm->disconnect();  
			// set blank cookies to expire on Jan 1, 1970 
			setcookie("gmail-lite_cookie", "", 1); 
			//setcookie("gmail-lite_key", "", 1); 

			header("Location: index.php?err=20");
			exit;

		} elseif (!isset($_COOKIE[ini_get("session.name")])) {
			header("Location: index.php");
			exit;
		} elseif (!isset($_SESSION['glid']) or $_SESSION['glid'] != session_id()) {
			$cookie_path = str_replace(DIRECTORY_SEPARATOR,"/",dirname($_SERVER['SCRIPT_NAME']))."/";
			if ($cookie_path == "//") $cookie_path = "/";
			setcookie(ini_get("session.name"), "", 1, $cookie_path);
			header("Location: index.php");
			exit;
		}

	} elseif ($session_method == (!GM_USE_PHPSESSION | GM_USE_COOKIE)) {
		if (	//!isset($_COOKIE['gmail-lite_sign'])			// may not exist
			/* or	 */
/* 			false */
			!isset($_COOKIE['gmail-lite_email'])
			or	!isset($_COOKIE['gmail-lite_webclips'])
			or	!isset($_COOKIE['gmail-lite_mboxes'])
			//or	!isset($_COOKIE['gmail-lite_clips'])  		// expires at end of session
			//or	!isset($_COOKIE['gmail-lite_last_mbox'])	// expires at end of session
			//or	!isset($_COOKIE['gmail-lite_js_status'])
			//or	!isset($_COOKIE['gmail-lite_searches'])
			//or	!isset($_COOKIE['gmail-lite_domain'])
		) {
			global $gm;
			$gm->disconnect(); 
			// set blank cookies to expire on Jan 1, 1970 
			setcookie("gmail-lite_sign", "", 1); 
			setcookie("gmail-lite_email", "", 1); 
			setcookie("gmail-lite_webclips", "", 1); 
			setcookie("gmail-lite_mboxes", "", 1); 
			setcookie("gmail-lite_clips", "", 1); 
			setcookie("gmail-lite_last_mbox", "", 1); 
			setcookie("gmail-lite_js_status", "", 1); 
			setcookie("gmail-lite_searches", "", 1); 
			setcookie("gmail-lite_domain", "", 1); 
			if (strpos($_SERVER["HTTP_HOST"],":"))
				$host_domain = substr($_SERVER["HTTP_HOST"],0,strpos($_SERVER["HTTP_HOST"],":"));
			else
				$host_domain = $_SERVER["HTTP_HOST"];
			setcookie(GM_COOKIE_KEY, "", 1, "", $host_domain);
			setcookie(GM_COOKIE_IK_KEY, "", 1, "", $host_domain);

		header("Location: index.php?err=20");
		exit;

		}
	} else {
		// we don't need to check phpsession
	}

}

// Get the javascript status; Added by Neerav; 17 May 2006
function get_js_status() {
	global $session_method;
	
	if ($session_method & GM_USE_PHPSESSION) {
		return ((isset($_SESSION['js_status']) and $_SESSION['js_status']) ? true : false);
	} else {
		return ((isset($_COOKIE['gmail-lite_js_status']) and $_COOKIE['gmail-lite_js_status']) ? true : false);
	}
}

// Get the rich text editor status; 17 May 2006
function get_rte_status() {
	global $session_method;
	
	if ($session_method & GM_USE_PHPSESSION) {
		return ((isset($_SESSION['rte_status']) and $_SESSION['rte_status']) ? true : false);
	} else {
		return ((isset($_COOKIE['gmail-lite_rte_status']) and $_COOKIE['gmail-lite_rte_status']) ? true : false);
	}
}

// Get the hosted domain; 9 July 2006
function get_domain() {
	global $session_method;
	
	return ((isset($_SESSION['domain']) and $_SESSION['domain']) 
		?  $_SESSION['domain']
		: ((isset($_COOKIE['gmail-lite_domain']) and $_COOKIE['gmail-lite_domain']) 
			? $_COOKIE['gmail-lite_domain'] 
			: ""
			)
		);
	
	return "";
}

// get/parse the persistent searches data; 17 May 2006
function parse_persist_searches() {
	global $session_method;
	$searches = array("contact_id" => "", "searches" => array());
	
	if ($session_method & GM_USE_PHPSESSION) {
		$persist_searches = ((isset($_SESSION['searches']) and $_SESSION['searches']) ? $_SESSION['searches'] : 0);
	} else {
		$persist_searches = (isset($_COOKIE['gmail-lite_searches']) and $_COOKIE['gmail-lite_searches']) 
			? gzuncompress(base64_decode($_COOKIE['gmail-lite_searches']))
			: 0
			;
	}
	
	if (!$persist_searches) {
		$persist_searches = "contact_id%3D-1%3BPersistentSearches%3Dquery%3Dis%3Aunread%26label%3DUnread%26totalResults%3D0%26unreadResults%3D0%3BPersistentSearchesCollapsedCookie%3D0%3B";
	}
	$all_searches = explode("%3B",$persist_searches);
	$searches['contact_id'] = substr($all_searches[0], 13);
	$searches_array = explode("%7C",substr($all_searches[1], 21));
	$count_searches = count($searches_array);
	for ($i=0; $i < $count_searches; $i++) {
		$temp = array();
		$data = explode("%26",$searches_array[$i]);
		$temp['query'] = substr($data[0], 8);
		if (!isset($data[1]) or !isset($data[2]) or !isset($data[3])) continue;
		$temp['label'] = substr($data[1], 8);
		$temp['total'] = substr($data[2], 15);
		$temp['unread'] = substr($data[3], 16);
		$searches['searches'][] = $temp;
	}
	$searches['cookie'] = substr($all_searches[2], 36);
	//print_r($searches);	
	return $searches;
}

?>
