<?php
if (! defined('ABSPATH')) exit; // Exit if accessed directly
require_once plugin_dir_path(__FILE__) . '../GlycerineIAWClient.php';

// Ensure this file is accessed only from within the block render function
if (!isset($selected_collections) || !is_array($selected_collections)) {
    return;
}

$block_id = uniqid('annotation_table_');

$api_key = get_option('glycerine_api_key');
$base_url = get_option('glycerine_iaw_base_url');
$GlycerineIawClient = new GlycerineIAWClient($base_url, $api_key);

$loading_image_url = plugin_dir_url(__FILE__) . '../assets/image/loading.gif';

$all_annotations = [];
if (!empty($annotations)) {
    $all_annotations = $annotations;
} else {
    foreach ($selected_collections as $collection_id) {
        $annotations = $GlycerineIawClient->searchWithCollection($collection_id, 'annotation', [], true, $block_cache_id);
        if (!empty($annotations) && is_array($annotations)) {
            $all_annotations = array_merge($all_annotations, $annotations);
        }
    }
}

if (empty($all_annotations)) {
    echo '<h2>No annotations found for selected collection</h2>';
    return;
}


// Sort title
usort($all_annotations, function ($a, $b) {
    $titleA = $a['fields']['title']['en']['values'][0] ?? null;
    $titleB = $b['fields']['title']['en']['values'][0] ?? null;

    if ($titleA !== null && $titleB !== null) {
        return strcasecmp($titleA, $titleB);
    }

    return 0;
});


$total_items = count($all_annotations);
$total_pages = ceil($total_items / $paging);
?>


<div id="<?php echo esc_attr($block_id); ?>" class="glycerine-table">
    <input type="hidden" id="annotation-image-width" value="<?php echo esc_attr($imageQuality); ?>">
    <input type="hidden" id="annotation-table-paging" value="<?php echo esc_attr($paging); ?>">
    <input type="hidden" id="admin-url" value="<?php echo esc_attr(admin_url('admin-ajax.php')); ?>">
    <inout type="hidden" id="annotation-table-block-id" value="<?php echo esc_attr($block_id); ?>">

        <!-- Filters Row -->
        <div id="table-filters">
            <input type="text" id="annotation-search" placeholder="Search..." style="padding: 5px; flex-grow: 1;">

            <div class="annotation-table-column-filters">
                <?php foreach ($filterColumns as $filterColumn) : ?>

                    <div class="column-filter-container">
                        <div style="align-self: flex-start; font-weight:600 ; font-size: 1.6rem;">
                            <?php echo esc_html($filterColumnLabelMap[$filterColumn] ?? $filterColumn); ?>
                        </div>
                        <select class="column-filter" multiple data-column="<?php echo esc_attr($filterColumn); ?>" style="padding: 5px;">
                            <?php
                            $unique_values = [];

                            // Collect unique values for this column
                            foreach ($all_annotations as $annotation) {
                                switch ($filterColumn) {
                                    case 'Collection':
                                        $value = $collection_map[$annotation['annotation_set']['image_set']['collection_id']] ?? '';
                                        break;
                                    case 'Image Set':
                                        $value = $annotation['annotation_set']['image_set']['name'] ?? '';
                                        break;
                                    case 'Tags':
                                        if (!empty($annotation['tags']) && is_array($annotation['tags'])) {
                                            foreach ($annotation['tags'] as $tag) {
                                                $value = $tag['term_label'] ?? '';
                                                if (!empty($value)) {
                                                    $unique_values[$value] = true;
                                                }
                                            }
                                        }
                                        continue 2; // Skip adding a single option, handled in loop
                                    default:
                                        $value = '';
                                }

                                if (!empty($value)) {
                                    $unique_values[$value] = true;
                                }
                            }

                            // Output options
                            foreach (array_keys($unique_values) as $value) {
                                echo '<option value="' . esc_attr($value) . '">' . esc_html($value) . '</option>';
                            }
                            ?>
                        </select>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <table id="<?php echo esc_attr($block_id); ?>" class="annotation-table">
            <thead id="annotation-table-header">
                <tr>
                    <?php
                    $all_possible_columns = $selected_columns;
                    foreach (['Collection', 'Image Set'] as $required) {
                        if (!in_array($required, $all_possible_columns)) {
                            $all_possible_columns[] = $required;
                        }
                    }
                    foreach ($all_possible_columns as $column) :
                        $is_hidden = !in_array($column, $selected_columns);
                    ?>
                        <th <?php echo $is_hidden ? 'style="display:none;"' : ''; ?>>
                            <?php if (isset($columnLabelMap[$column])) : ?>
                                <?php echo esc_html($columnLabelMap[$column]); ?>
                            <?php else : ?>
                                <?php echo esc_html($column); ?>
                            <?php endif; ?>
                        </th>
                    <?php endforeach; ?>
                </tr>
            </thead>
            <tbody id="annotation-table-body">
                <?php foreach ($all_annotations as $index => $annotation) : ?>
                    <?php $page = floor($index / $paging) + 1; ?>
                    <tr data-page="<?php echo esc_attr($page); ?>" <?php echo $page != 1 ? ' style="display:' . esc_attr('none') . ';"' : ''; ?>>
                        <?php foreach ($all_possible_columns as $column) : ?>
                            <?php
                            $is_hidden = !in_array($column, $selected_columns);
                            ?>
                            <td <?php echo $is_hidden ? 'style="display:none;"' : ''; ?>>
                                <?php
                                switch ($column) {
                                    case 'Collection':
                                        echo esc_html($collection_map[$annotation['annotation_set']['image_set']['collection_id']] ?? '');
                                        break;
                                    case 'Image Set':
                                        echo esc_html($annotation['annotation_set']['image_set']['name'] ?? '');
                                        break;
                                    case 'Annotation Set':
                                        echo esc_html($annotation['annotation_set']['name'] ?? '');
                                        break;
                                    case 'Image':
                                        echo '<img class="annotation-img loading" src="' . esc_url($loading_image_url) . '" alt="Loading..." data-image-set-id="' . esc_attr($annotation['annotation_set']['image_set']['id']) . '" data-collection-id="' . esc_attr($annotation['annotation_set']['image_set']['collection_id']) . '" />';
                                        break;
                                    case 'Title':
                                        foreach ($annotation['fields'] as $field) {
                                            if ($field['field']['name'] == 'Title' && isset($field['values']['en'])) {
                                                echo esc_html($field['values']['en'][0] ?? '');
                                                break;
                                            }
                                        }
                                        break;
                                    case 'Description':
                                        foreach ($annotation['fields'] as $field) {
                                            if ($field['field']['name'] == 'Description' && isset($field['values']['en'])) {
                                                echo wp_kses(
                                                    $field['values']['en'][0] ?? '',
                                                    [
                                                        'p' => [],
                                                        'a' => ['href' => [], 'title' => []],
                                                        'strong' => [],
                                                        'em' => [],
                                                        'br' => [],
                                                        'ul' => [],
                                                        'ol' => [],
                                                        'li' => [],
                                                    ]
                                                );
                                                break;
                                            }
                                        }
                                        break;
                                    case 'Notes':
                                        foreach ($annotation['fields'] as $field) {
                                            if ($field['field']['name'] == 'Note' && isset($field['values']['en'])) {
                                                echo wp_kses(
                                                    $field['values']['en'][0] ?? '',
                                                    [
                                                        'p' => [],
                                                        'a' => ['href' => [], 'title' => []],
                                                        'strong' => [],
                                                        'em' => [],
                                                        'br' => [],
                                                        'ul' => [],
                                                        'ol' => [],
                                                        'li' => [],
                                                    ]
                                                );
                                                break;
                                            }
                                        }
                                        break;
                                    case 'Tags':
                                        if (!empty($annotation['tags']) && is_array($annotation['tags'])) {
                                            foreach ($annotation['tags'] as $tag) {
                                                $tag_label = $tag['term_label'] ?? '';
                                                if (!empty($tag_label)) {
                                                    echo '<div class="annotation-tag">' . esc_html($tag_label) . '</div>';
                                                }
                                            }
                                        }
                                        break;
                                }
                                ?>
                            </td>
                        <?php endforeach; ?>

                        <?php
                        $target = json_encode($annotation['target']);
                        $encodedTarget = htmlspecialchars($target, ENT_QUOTES, 'UTF-8');
                        ?>
                        <td style="display:none;">
                            <input type="hidden" class="annotation-data" value="<?php echo esc_attr($encodedTarget); ?>">
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>


        <!-- Pagination -->
        <div class="annotation-table-pagination">
            <button id="prev-page" class="p-link" disabled style="margin-right:10px">
                < </button>
                    <?php for ($i = 1; $i <= $total_pages; $i++) : ?>
                        <button class="page-number" data-page="<?php echo esc_attr($i); ?>" <?php echo $i === 1 ? 'disabled' : ''; ?>>
                            <?php echo esc_html($i); ?>
                        </button>
                    <?php endfor; ?>
                    <button id="next-page" class="p-link" <?php echo $total_pages <= 1 ? 'disabled' : ''; ?>>></button>
        </div>
</div>

<div id="<?php echo esc_attr($block_id); ?>_loadingWheel" class="loadingWheel">
    <div class="spinner"></div>
</div>