<?php
if (! defined('ABSPATH')) exit; // Exit if accessed directly
$loading_image_url = plugin_dir_url(__FILE__) . '../assets/image/loading.gif';

?>

<div style="display: flex; justify-content: center; position: relative;">
    <div>
        <!-- Annotation Image -->
        <?php $uid = uniqid('cutout_'); ?>
        <img class="annotation-img loading"
            data-cutout-id="<?php echo esc_attr($uid); ?>"
            data-annotation-json='<?php echo esc_attr(wp_json_encode($annotationData, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP)); ?>'
            data-public-url="<?php echo esc_url($selectedImageSet['public_url']); ?>"
            data-persistent-url="<?php echo esc_url($selectedImageSet['persistent_url']); ?>"
            src="<?php echo esc_url($loading_image_url); ?>">

        <!-- Title -->
        <?php if (in_array('title', $selectedFields) && isset($annotationTitle)) : ?>
            <figcaption class="annotation-cutout-title"
                data-cutout-id="<?php echo esc_attr($uid); ?>"
                style="font-size: 14px; text-align: center; font-weight: bold;">
                <?php echo esc_html($annotationTitle); ?>
            </figcaption>
        <?php endif; ?>

        <!-- Description -->
        <?php if (in_array('description', $selectedFields) && isset($annotationDescription)) : ?>
            <figcaption class="annotation-cutout-description" data-cutout-id="<?php echo esc_attr($uid); ?>" style=" font-size: 14px; text-align: center;">
                <?php echo esc_html($annotationDescription); ?>
            </figcaption>
        <?php endif; ?>

        <!-- Tooltip (Initially Hidden) -->
        <div class="annotation-tooltip" data-cutout-id="<?php echo esc_attr($uid); ?>"
            style="display: none; background: rgba(0,0,0,0.8); color: #fff; padding: 10px; border-radius: 5px; font-size: 12px; max-width: 250px; z-index: 999;">
        </div>
    </div>
</div>

