<?php

// Register settings for API key and Base URL
function glycerine_embeds_register_settings()
{
    register_setting(
        'glycerine_embeds_settings_group',
        'glycerine_api_key',
        array(
            'type'              => 'string',
            'sanitize_callback' => 'sanitize_text_field',
            'default'           => '',
            'show_in_rest'      => false,
        )
    );

    register_setting(
        'glycerine_embeds_settings_group',
        'glycerine_iaw_base_url',
        array(
            'type'              => 'string',
            'sanitize_callback' => 'sanitize_text_field',
            'default'           => '',
            'show_in_rest'      => false,
        )
    );
}
add_action('admin_init', 'glycerine_embeds_register_settings');

// Admin page content (called in the admin menu)
function glycerine_embeds_page()
{
?>
    <div class="wrap">
        <h1>Glycerine Settings</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('glycerine_embeds_settings_group');
            do_settings_sections('glycerine_embeds');
            ?>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">API Key</th>
                    <td>
                        <input type="text" name="glycerine_api_key" value="<?php echo esc_attr(get_option('glycerine_api_key')); ?>" />
                        <p class="description">
                            An API key is a unique identifier that the Glycerine plugin will use to authenticate your
                            Glycerine API access. If you don't have an API key, request one here:
                            <a href="https://glycerine.io/request-api-access/" target="_blank">
                                https://glycerine.io/request-api-access/
                            </a>
                        </p>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">Glycerine Server</th>
                    <td>
                        <select name="glycerine_iaw_base_url">
                            <option value="https://iaw-server.ardc-hdcl-sia-iaw.cloud.edu.au/api" <?php selected(get_option('glycerine_iaw_base_url'), 'https://iaw-server.ardc-hdcl-sia-iaw.cloud.edu.au/api'); ?>>
                                Australia
                            </option>
                            <option value="https://app.glycerine.io/api" <?php selected(get_option('glycerine_iaw_base_url'), 'https://server.glycerine.io/api/'); ?>>
                                International
                            </option>
                        </select>

                        <p class="description">
                            Select the server used for your Glycerine account. This will likely be
                            <strong>Australia</strong> if you are in Australia or <strong>International</strong>
                            if you’re somewhere else.
                        </p>
                    </td>
                </tr>
            </table>
            <?php submit_button(); ?>
        </form>
    </div>
<?php
}
