class ImageLoader {
    iifSize;
    loaded;
    imageElement;
    iiif_url;
    ratio;

    constructor(iiif_url, width = null) {
        let size = "max";
        if (width) {
            size = `${width},`;
        }
        this.iifSize = size;

        // Force https if http is used
        if (iiif_url.startsWith("http:")) {
            iiif_url = iiif_url.replace(/^http:/, "https:");
        }

        this.iiif_url = iiif_url;
        this.loaded = false;
    }

    async load() {
        if (this.loaded) {
            return;
        }

        let imageURL, info;

        if (this.iiif_url.startsWith("https://heidicon")) {
            imageURL = `${this.iiif_url}/full/${this.iifSize}/0/default.jpg`;

            info = await fetch(`${this.iiif_url}/info.json`).then((response) =>
                response.json()
            );
        } else if (this.iiif_url.startsWith("https://iaw-image-server")) {
            imageURL = `${this.iiif_url}/full/${this.iifSize}/0/default.jpg`;
            info = await fetch(`${this.iiif_url}`).then((response) =>
                response.json()
            );
        } else {
            info = await fetch(
                `/wp-json/glycerine/v1/proxy?target=${this.iiif_url}`
            )
                .then((response) => {
                    if (!response.ok)
                        throw new Error("Network response was not ok");
                    return response.json();
                })
                .catch((error) => {
                    console.error("Fetch error:", error);
                });

            imageURL =
                info["items"][0]["items"][0]["body"]["service"]["0"]["id"] +
                "/full/" +
                this.iifSize +
                "/0/default.jpg";
        }

        const imageWidth = info.width;

        this.imageElement = new Image();
        this.imageElement.crossOrigin = "anonymous";
        this.imageElement.src = imageURL;
        await this.imageElement.decode();

        this.ratio = this.imageElement.width / imageWidth;
        this.loaded = true;

        return;
    }

    getImageElement() {
        return this.imageElement;
    }

    getRatio() {
        return this.ratio;
    }

    hasLoaded() {
        return this.loaded;
    }
}
