if (typeof window.loadedAnnotations === "undefined") {
    window.loadedAnnotations = new Set();
}

document.querySelectorAll(".annotation-img.loading").forEach((img) => {
    const uid = img.getAttribute("data-cutout-id");
    const annotationData = JSON.parse(img.getAttribute("data-annotation-json"));
    const tooltip = document.querySelector(
        `.annotation-tooltip[data-cutout-id="${uid}"]`
    );

    const sourceUrl = annotationData?.target?.source;
    if (!sourceUrl || window.loadedAnnotations.has(sourceUrl)) {
        return; // skip if already loaded
    }
    window.loadedAnnotations.add(sourceUrl);

    runWhenImageLoaderIsReady(annotationData, img);

    function runWhenImageLoaderIsReady(data, imgElement) {
        if (
            typeof ImageLoader !== "undefined" &&
            typeof AnnotationCropper !== "undefined"
        ) {
            getAnnotationUrl(data.target, imgElement);
        } else {
            setTimeout(() => runWhenImageLoaderIsReady(data, imgElement), 100);
        }
    }

    async function getAnnotationUrl(annotation, imgElement) {
        let imageLoader = new ImageLoader(annotation.source);
        await imageLoader.load();

        if (imageLoader && imageLoader.hasLoaded()) {
            const src = AnnotationCropper.cropAnnotationImage(
                annotation,
                imageLoader
            );
            imgElement.src = src;
            imgElement.classList.remove("loading");
        }
    }

    img.addEventListener("click", () => {
        const persistentUrl = img.getAttribute("data-persistent-url");
        const publicUrl = img.getAttribute("data-public-url");
        const annotationData = JSON.parse(
            img.getAttribute("data-annotation-json")
        );

        const imageId = annotationData.image_id;
        const canvasId = persistentUrl + "/manifest/canvases/" + imageId;

        const imagesetUrl = publicUrl + "?startImageId=" + canvasId;

        window.open(imagesetUrl, "_blank");
    });

    // Tooltip handlers
    img.addEventListener("mouseover", (event) => {
        let tooltipContent = ``;
        annotationData.fields.forEach((field) => {
            let key = field.field.name;
            let capitalizedKey = key
                .replace(/_/g, " ")
                .replace(/\b\w/g, (l) => l.toUpperCase());
            let value = field.values.en ? field.values.en[0] : "";

            tooltipContent += `<strong>${capitalizedKey}:</strong> ${value}<br>`;
        });

        tooltip.innerHTML = tooltipContent;
        tooltip.style.display = "block";
        moveTooltip(event);
    });

    img.addEventListener("mousemove", moveTooltip);

    img.addEventListener("mouseout", () => {
        tooltip.style.display = "none";
    });

    function moveTooltip(event) {
        const tooltipWidth = tooltip.offsetWidth;
        const tooltipHeight = tooltip.offsetHeight;
        const padding = 10;

        let x = event.pageX + padding;
        let y = event.pageY - tooltipHeight / 2;

        if (x + tooltipWidth > window.innerWidth) {
            x = event.pageX - tooltipWidth - padding;
        }

        if (y < 0) y = padding;

        tooltip.style.left = `${x}px`;
        tooltip.style.top = `${y}px`;
    }
});
