=== Glycerine ===
Contributors: systemik, mufengniu
Tags: iiif, annotation, glycerine
Stable tag: 1.0.4
License: GPLv2
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Requires at least: 5.2
Tested up to: 6.8

A plugin to embed IIIF-compatible image , text annotation tables and viewers using Glycerine framework.

== Description ==

The Glycerine plugin brings annotation and image collection display functionality to your WordPress site using IIIF. It allows users to embed data tables, annotation viewers, and collection-based visual components with dynamic interactions.

== Installation ==

1. Upload the `glycerine` plugin directory to your `/wp-content/plugins/` directory.
2. Activate the plugin through the "Plugins" menu in WordPress.
3. Go to **Settings > Glycerine** to configure your API key and Glycerine server URL.

== Configuration ==

- Go to **Settings > Glycerine**.
- Enter your API key.
- Choose your Glycerine server (Australia or International).

== Blocks ==

This plugin provides the following blocks:

1. **Glycerine Table**
   - Embed a paginated table of annotations from Glycerine with search filters.

2. **Glycerine Image Set**
   - Embed a Glycerine Image Set using the Glycerine Viewer.

3. **Glycerine Annotation Cutouts**
   - Embed an image annotation cutout from Glycerine.

4. **Glycerine Collection**
   - Embed a Glycerine Collection using the Glycerine Viewer.

== Changelog ==

= 1.0.0 =
* Initial release

== License ==

Glycerine is free software licensed under the GPLv2.

## External Services

This plugin requires access to external services to function. Specifically, it connects to the **Glycerine IAW API** to retrieve and display image sets, annotations, and related publication data.

### What services are used and why
- **IAW Server (Australia)** – `https://iaw-server.ardc-hdcl-sia-iaw.cloud.edu.au/api`  
- **Glycerine.io (International)** – `https://app.glycerine.io/api`  

These services provide the underlying IIIF (International Image Interoperability Framework) data and annotation sets needed for the plugin to render images, text annotations, and collections inside WordPress.

### What data is sent and when
- When the plugin is configured, it will send the **API key** (entered by the administrator) along with **requests for images, image sets, annotations, and publication metadata**.  
- These requests occur when a user loads a page or block containing a Glycerine viewer or annotation table.  
- No personally identifiable information about site visitors is transmitted.

### Terms of Service and Privacy Policies
- [Glycerine.io Terms of Use](https://glycerine.io/legal/acceptable-use-policy/)  
- [Glycerine.io Privacy Policy](https://glycerine.io/legal/privacy-policy/)  

### Notes
- If you are based in Australia, you may prefer to use the IAW server.  
- If you are outside Australia, the Glycerine.io international server is recommended.