<?php
/**
 * Uninstall Script
 *
 * @package Glimbyte_SSL_Manager
 */

// If uninstall not called from WordPress, exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

/**
 * Delete all plugin options.
 */
function glimbyte_ssl_uninstall() {
	// Single site options.
	$options = array(
		'glimbyte_ssl_https_enabled',
		'glimbyte_ssl_redirect_type',
		'glimbyte_ssl_force_all',
		'glimbyte_ssl_excluded_urls',
		'glimbyte_ssl_mixed_content_fix_enabled',
		'glimbyte_ssl_mixed_content_method',
		'glimbyte_ssl_cert_alert_enabled',
		'glimbyte_ssl_cert_alert_days',
		'glimbyte_ssl_cert_alert_email',
		'glimbyte_ssl_hsts_enabled',
		'glimbyte_ssl_hsts_max_age',
		'glimbyte_ssl_hsts_subdomains',
		'glimbyte_ssl_hsts_preload',
		'glimbyte_ssl_debug_mode',
		'glimbyte_ssl_logs',
	);

	foreach ( $options as $option ) {
		delete_option( $option );
	}

	// Delete transients.
	delete_transient( 'glimbyte_ssl_scan_results' );
	delete_transient( 'glimbyte_ssl_admin_notice' );

	// Clear scheduled cron jobs.
	wp_clear_scheduled_hook( 'glimbyte_ssl_check_certificate' );

	// For multisite.
	if ( is_multisite() ) {
		// Delete network options.
		delete_site_option( 'glimbyte_ssl_network_force_https' );
		delete_site_option( 'glimbyte_ssl_allow_site_override' );

		// Delete options from all sites.
		global $wpdb;
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Required for multisite cleanup during uninstall. Caching is unnecessary as this runs once.
		$blog_ids = $wpdb->get_col( "SELECT blog_id FROM {$wpdb->blogs}" );

		foreach ( $blog_ids as $blog_id ) {
			switch_to_blog( $blog_id );

			foreach ( $options as $option ) {
				delete_option( $option );
			}

			delete_transient( 'glimbyte_ssl_scan_results' );
			delete_transient( 'glimbyte_ssl_admin_notice' );

			// Clear certificate cache.
			$parsed_url = wp_parse_url( home_url() );
			$domain = isset( $parsed_url['host'] ) ? $parsed_url['host'] : '';
			$cache_key = 'glimbyte_ssl_cert_info_' . md5( $domain );
			delete_transient( $cache_key );

			restore_current_blog();
		}
	}
}

glimbyte_ssl_uninstall();
