<?php
/**
 * Dashboard Widget
 *
 * @package Glimbyte_SSL_Manager
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Dashboard Widget class.
 */
class Glimbyte_SSL_Dashboard_Widget {

	/**
	 * Class instance.
	 *
	 * @var Glimbyte_SSL_Dashboard_Widget
	 */
	private static $instance = null;

	/**
	 * Get class instance.
	 *
	 * @return Glimbyte_SSL_Dashboard_Widget
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Constructor.
	 */
	private function __construct() {
		add_action( 'wp_dashboard_setup', array( $this, 'add_dashboard_widget' ) );
	}

	/**
	 * Add dashboard widget.
	 */
	public function add_dashboard_widget() {
		wp_add_dashboard_widget(
			'glimbyte_ssl_dashboard_widget',
			__( 'SSL Status', 'glimbyte-ssl-guardian' ),
			array( $this, 'render_dashboard_widget' )
		);
	}

	/**
	 * Render dashboard widget.
	 */
	public function render_dashboard_widget() {
		// Get SSL certificate info.
		$cert_info = glimbyte_ssl_get_cert_info();
		$is_https = glimbyte_ssl_is_https();
		$https_enabled = glimbyte_ssl_get_option( 'https_enabled', false );

		?>
		<div class="glimbyte-ssl-dashboard-widget">
			<div class="ssl-status-indicator">
				<?php if ( $is_https && ! is_wp_error( $cert_info ) && $cert_info['is_valid'] ) : ?>
					<span class="ssl-status ssl-status-valid">
						<span class="dashicons dashicons-yes-alt"></span>
						<?php esc_html_e( 'SSL Active & Valid', 'glimbyte-ssl-guardian' ); ?>
					</span>
				<?php elseif ( is_wp_error( $cert_info ) ) : ?>
					<span class="ssl-status ssl-status-error">
						<span class="dashicons dashicons-warning"></span>
						<?php esc_html_e( 'SSL Error', 'glimbyte-ssl-guardian' ); ?>
					</span>
				<?php else : ?>
					<span class="ssl-status ssl-status-warning">
						<span class="dashicons dashicons-info"></span>
						<?php esc_html_e( 'SSL Not Active', 'glimbyte-ssl-guardian' ); ?>
					</span>
				<?php endif; ?>
			</div>

			<?php if ( ! is_wp_error( $cert_info ) ) : ?>
				<div class="ssl-certificate-info">
					<p>
						<strong><?php esc_html_e( 'Certificate Expiry:', 'glimbyte-ssl-guardian' ); ?></strong>
						<?php
						$days_left = $cert_info['days_left'];
						if ( $days_left > 30 ) {
							echo '<span class="ssl-expiry-good">';
						} elseif ( $days_left > 7 ) {
							echo '<span class="ssl-expiry-warning">';
						} else {
							echo '<span class="ssl-expiry-critical">';
						}
						printf(
							/* translators: %d: Days until expiry */
							esc_html__( '%d days remaining', 'glimbyte-ssl-guardian' ),
							absint( $days_left )
						);
						echo '</span>';
						?>
					</p>
					<p>
						<strong><?php esc_html_e( 'Issued by:', 'glimbyte-ssl-guardian' ); ?></strong>
						<?php echo esc_html( $cert_info['issuer'] ); ?>
					</p>
				</div>
			<?php endif; ?>

			<div class="ssl-quick-actions">
				<p>
					<strong><?php esc_html_e( 'HTTPS Redirect:', 'glimbyte-ssl-guardian' ); ?></strong>
					<?php if ( $https_enabled ) : ?>
						<span class="ssl-enabled"><?php esc_html_e( 'Enabled', 'glimbyte-ssl-guardian' ); ?></span>
					<?php else : ?>
						<span class="ssl-disabled"><?php esc_html_e( 'Disabled', 'glimbyte-ssl-guardian' ); ?></span>
					<?php endif; ?>
				</p>
				<p>
					<a href="<?php echo esc_url( glimbyte_ssl_get_admin_url() ); ?>" class="button button-primary">
						<?php esc_html_e( 'Manage SSL Settings', 'glimbyte-ssl-guardian' ); ?>
					</a>
				</p>
			</div>
		</div>

		<?php
	}
}
