<?php
/**
 * Support Tab View
 *
 * @package Glimbyte_SSL_Manager
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="glimbyte-ssl-support">
	<div class="glimbyte-ssl-card">
		<h2><?php esc_html_e( 'Need Help?', 'glimbyte-ssl-guardian' ); ?></h2>
		<p><?php esc_html_e( 'Glimbyte SSL Guardian is a free plugin developed by Glimbyte Ltd. We offer professional services to help you get the most out of your WordPress site.', 'glimbyte-ssl-guardian' ); ?></p>
	</div>

	<div class="glimbyte-ssl-support-grid">
		<div class="glimbyte-ssl-card">
			<h3><?php esc_html_e( 'Free Support', 'glimbyte-ssl-guardian' ); ?></h3>
			<p><?php esc_html_e( 'Community support is available through the WordPress.org support forum.', 'glimbyte-ssl-guardian' ); ?></p>
			<p>
				<a href="https://wordpress.org/support/plugin/glimbyte-ssl-guardian/" target="_blank" class="button">
					<?php esc_html_e( 'Visit Support Forum', 'glimbyte-ssl-guardian' ); ?>
				</a>
			</p>
		</div>

		<div class="glimbyte-ssl-card">
			<h3><?php esc_html_e( 'Documentation', 'glimbyte-ssl-guardian' ); ?></h3>
			<p><?php esc_html_e( 'Read our comprehensive documentation to learn how to use all features.', 'glimbyte-ssl-guardian' ); ?></p>
			<p>
				<a href="https://glimbyte.ie/docs/glimbyte-ssl-guardian" target="_blank" class="button">
					<?php esc_html_e( 'View Documentation', 'glimbyte-ssl-guardian' ); ?>
				</a>
			</p>
		</div>

		<div class="glimbyte-ssl-card">
			<h3><?php esc_html_e( 'Priority Support', 'glimbyte-ssl-guardian' ); ?></h3>
			<p><?php esc_html_e( 'Need immediate help? Get priority email and chat support with our support plans.', 'glimbyte-ssl-guardian' ); ?></p>
			<p>
				<a href="https://glimbyte.ie/support" target="_blank" class="button button-primary">
					<?php esc_html_e( 'Get Priority Support', 'glimbyte-ssl-guardian' ); ?>
				</a>
			</p>
		</div>
	</div>

	<hr>

	<h2><?php esc_html_e( 'Professional Services', 'glimbyte-ssl-guardian' ); ?></h2>

	<div class="glimbyte-ssl-services-grid">
		<div class="glimbyte-ssl-card">
			<h3><span class="dashicons dashicons-lock"></span> <?php esc_html_e( 'SSL Certificate Installation', 'glimbyte-ssl-guardian' ); ?></h3>
			<p><?php esc_html_e( 'Don\'t have an SSL certificate yet? We can install and configure SSL for your website.', 'glimbyte-ssl-guardian' ); ?></p>
			<ul>
				<li><?php esc_html_e( 'Free Let\'s Encrypt SSL', 'glimbyte-ssl-guardian' ); ?></li>
				<li><?php esc_html_e( 'Commercial SSL certificates', 'glimbyte-ssl-guardian' ); ?></li>
				<li><?php esc_html_e( 'Wildcard & EV certificates', 'glimbyte-ssl-guardian' ); ?></li>
				<li><?php esc_html_e( 'Complete setup & configuration', 'glimbyte-ssl-guardian' ); ?></li>
			</ul>
		</div>

		<div class="glimbyte-ssl-card">
			<h3><span class="dashicons dashicons-shield"></span> <?php esc_html_e( 'Security Audit', 'glimbyte-ssl-guardian' ); ?></h3>
			<p><?php esc_html_e( 'Comprehensive security audit and hardening for your WordPress site.', 'glimbyte-ssl-guardian' ); ?></p>
			<ul>
				<li><?php esc_html_e( 'Vulnerability scanning', 'glimbyte-ssl-guardian' ); ?></li>
				<li><?php esc_html_e( 'Malware detection & removal', 'glimbyte-ssl-guardian' ); ?></li>
				<li><?php esc_html_e( 'Security hardening', 'glimbyte-ssl-guardian' ); ?></li>
				<li><?php esc_html_e( 'Ongoing monitoring', 'glimbyte-ssl-guardian' ); ?></li>
			</ul>
		</div>

		<div class="glimbyte-ssl-card">
			<h3><span class="dashicons dashicons-performance"></span> <?php esc_html_e( 'Performance Optimization', 'glimbyte-ssl-guardian' ); ?></h3>
			<p><?php esc_html_e( 'Speed up your WordPress site with professional optimization services.', 'glimbyte-ssl-guardian' ); ?></p>
			<ul>
				<li><?php esc_html_e( 'Page speed optimization', 'glimbyte-ssl-guardian' ); ?></li>
				<li><?php esc_html_e( 'Database optimization', 'glimbyte-ssl-guardian' ); ?></li>
				<li><?php esc_html_e( 'Caching configuration', 'glimbyte-ssl-guardian' ); ?></li>
				<li><?php esc_html_e( 'CDN setup', 'glimbyte-ssl-guardian' ); ?></li>
			</ul>
		</div>

		<div class="glimbyte-ssl-card">
			<h3><span class="dashicons dashicons-admin-tools"></span> <?php esc_html_e( 'Custom Development', 'glimbyte-ssl-guardian' ); ?></h3>
			<p><?php esc_html_e( 'Need custom WordPress development? Our team can help with any requirement.', 'glimbyte-ssl-guardian' ); ?></p>
			<ul>
				<li><?php esc_html_e( 'Custom plugin development', 'glimbyte-ssl-guardian' ); ?></li>
				<li><?php esc_html_e( 'Theme customization', 'glimbyte-ssl-guardian' ); ?></li>
				<li><?php esc_html_e( 'API integrations', 'glimbyte-ssl-guardian' ); ?></li>
				<li><?php esc_html_e( 'Migration services', 'glimbyte-ssl-guardian' ); ?></li>
			</ul>
		</div>
	</div>

	<div style="text-align: center; margin-top: 30px;">
		<a href="https://glimbyte.ie/contact" target="_blank" class="button button-primary button-hero">
			<?php esc_html_e( 'Contact Us for a Free Consultation', 'glimbyte-ssl-guardian' ); ?>
		</a>
	</div>

	<hr>

	<div class="glimbyte-ssl-card">
		<h2><?php esc_html_e( 'About Glimbyte', 'glimbyte-ssl-guardian' ); ?></h2>
		<p><?php esc_html_e( 'Glimbyte Ltd is a WordPress development and security company based in Ireland. We specialize in WordPress security, performance optimization, and custom development.', 'glimbyte-ssl-guardian' ); ?></p>
		<p>
			<strong><?php esc_html_e( 'Website:', 'glimbyte-ssl-guardian' ); ?></strong>
			<a href="https://glimbyte.ie" target="_blank">https://glimbyte.ie</a>
		</p>
		<p>
			<strong><?php esc_html_e( 'Email:', 'glimbyte-ssl-guardian' ); ?></strong>
			<a href="mailto:info@glimbyte.ie">info@glimbyte.ie</a>
		</p>
	</div>
</div>

