<?php
/**
 * Mixed Content Tab View
 *
 * @package Glimbyte_SSL_Manager
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Template variables - passed from parent scope, not globals.
// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound

$mixed_content_enabled = glimbyte_ssl_get_option( 'mixed_content_fix_enabled', false );
$mixed_content_method = glimbyte_ssl_get_option( 'mixed_content_method', 'https' );
$scan_results = get_transient( 'glimbyte_ssl_scan_results' );

// phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
?>

<form method="post" action="options.php">
	<?php settings_fields( 'glimbyte_ssl_mixed_content' ); ?>

	<table class="form-table">
		<tr>
			<th scope="row"><?php esc_html_e( 'Enable Mixed Content Fix', 'glimbyte-ssl-guardian' ); ?></th>
			<td>
				<label>
					<input type="checkbox" name="glimbyte_ssl_mixed_content_fix_enabled" value="1" <?php checked( $mixed_content_enabled, true ); ?>>
					<?php esc_html_e( 'Automatically fix mixed content issues', 'glimbyte-ssl-guardian' ); ?>
				</label>
				<p class="description">
					<?php esc_html_e( 'Rewrite HTTP URLs to HTTPS in real-time on page load.', 'glimbyte-ssl-guardian' ); ?>
				</p>
			</td>
		</tr>

		<tr>
			<th scope="row"><?php esc_html_e( 'Fixing Method', 'glimbyte-ssl-guardian' ); ?></th>
			<td>
				<label>
					<input type="radio" name="glimbyte_ssl_mixed_content_method" value="https" <?php checked( $mixed_content_method, 'https' ); ?>>
					<?php esc_html_e( 'Replace with HTTPS (Recommended)', 'glimbyte-ssl-guardian' ); ?>
				</label><br>
				<label>
					<input type="radio" name="glimbyte_ssl_mixed_content_method" value="protocol-relative" <?php checked( $mixed_content_method, 'protocol-relative' ); ?>>
					<?php esc_html_e( 'Use protocol-relative URLs (//)', 'glimbyte-ssl-guardian' ); ?>
				</label>
			</td>
		</tr>
	</table>

	<?php submit_button(); ?>
</form>

<hr>

<h2><?php esc_html_e( 'Content Scanner', 'glimbyte-ssl-guardian' ); ?></h2>
<p><?php esc_html_e( 'Scan your website content for mixed content issues.', 'glimbyte-ssl-guardian' ); ?></p>

<div id="glimbyte-ssl-scanner">
	<button type="button" id="glimbyte-ssl-scan-btn" class="button button-primary">
		<?php esc_html_e( 'Scan Content', 'glimbyte-ssl-guardian' ); ?>
	</button>

	<?php if ( $scan_results ) : ?>
	<button type="button" id="glimbyte-ssl-fix-btn" class="button button-secondary">
		<?php esc_html_e( 'Fix All Issues in Database', 'glimbyte-ssl-guardian' ); ?>
	</button>
	<?php endif; ?>

	<div id="glimbyte-ssl-scan-progress" style="display:none;">
		<p><?php esc_html_e( 'Scanning...', 'glimbyte-ssl-guardian' ); ?></p>
		<progress style="width: 100%;"></progress>
	</div>

	<?php if ( $scan_results ) : ?>
	<div id="glimbyte-ssl-scan-results">
		<h3><?php esc_html_e( 'Scan Results', 'glimbyte-ssl-guardian' ); ?></h3>
		<table class="wp-list-table widefat fixed striped">
			<tr>
				<th><?php esc_html_e( 'Total Posts Scanned', 'glimbyte-ssl-guardian' ); ?></th>
				<td><?php echo esc_html( number_format_i18n( $scan_results['total_posts'] ) ); ?></td>
			</tr>
			<tr>
				<th><?php esc_html_e( 'Posts with Issues', 'glimbyte-ssl-guardian' ); ?></th>
				<td><?php echo esc_html( number_format_i18n( $scan_results['posts_with_issues'] ) ); ?></td>
			</tr>
			<tr>
				<th><?php esc_html_e( 'Total Issues Found', 'glimbyte-ssl-guardian' ); ?></th>
				<td><strong><?php echo esc_html( number_format_i18n( $scan_results['total_issues'] ) ); ?></strong></td>
			</tr>
		</table>

		<h4><?php esc_html_e( 'Issues by Type', 'glimbyte-ssl-guardian' ); ?></h4>
		<ul>
			<li><?php 
			/* translators: %d: Number of images with mixed content issues */
			printf( esc_html__( 'Images: %d', 'glimbyte-ssl-guardian' ), absint( $scan_results['issues_by_type']['images'] ) ); ?></li>
			<li><?php 
			/* translators: %d: Number of scripts with mixed content issues */
			printf( esc_html__( 'Scripts: %d', 'glimbyte-ssl-guardian' ), absint( $scan_results['issues_by_type']['scripts'] ) ); ?></li>
			<li><?php 
			/* translators: %d: Number of stylesheets with mixed content issues */
			printf( esc_html__( 'Stylesheets: %d', 'glimbyte-ssl-guardian' ), absint( $scan_results['issues_by_type']['stylesheets'] ) ); ?></li>
			<li><?php 
			/* translators: %d: Number of iframes with mixed content issues */
			printf( esc_html__( 'Iframes: %d', 'glimbyte-ssl-guardian' ), absint( $scan_results['issues_by_type']['iframes'] ) ); ?></li>
			<li><?php 
			/* translators: %d: Number of other resources with mixed content issues */
			printf( esc_html__( 'Other: %d', 'glimbyte-ssl-guardian' ), absint( $scan_results['issues_by_type']['other'] ) ); ?></li>
		</ul>
	</div>
	<?php endif; ?>
</div>
