<?php
/**
 * HTTPS Settings Tab View
 *
 * @package Glimbyte_SSL_Manager
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Template variables - passed from parent scope, not globals.
// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound

$https_enabled = glimbyte_ssl_get_option( 'https_enabled', false );
$redirect_type = glimbyte_ssl_get_option( 'redirect_type', '301' );
$force_all = glimbyte_ssl_get_option( 'force_all', true );
$excluded_urls = glimbyte_ssl_get_option( 'excluded_urls', '' );

// phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
?>

<form method="post" action="options.php">
	<?php settings_fields( 'glimbyte_ssl_https' ); ?>

	<table class="form-table">
		<tr>
			<th scope="row"><?php esc_html_e( 'Enable HTTPS Redirect', 'glimbyte-ssl-guardian' ); ?></th>
			<td>
				<label>
					<input type="checkbox" name="glimbyte_ssl_https_enabled" value="1" <?php checked( $https_enabled, true ); ?>>
					<?php esc_html_e( 'Force all HTTP traffic to HTTPS', 'glimbyte-ssl-guardian' ); ?>
				</label>
				<p class="description">
					<?php esc_html_e( 'Automatically redirect all HTTP requests to HTTPS.', 'glimbyte-ssl-guardian' ); ?>
				</p>
			</td>
		</tr>

		<tr>
			<th scope="row"><?php esc_html_e( 'Redirect Type', 'glimbyte-ssl-guardian' ); ?></th>
			<td>
				<select name="glimbyte_ssl_redirect_type">
					<option value="301" <?php selected( $redirect_type, '301' ); ?>>
						<?php esc_html_e( '301 - Permanent (Recommended)', 'glimbyte-ssl-guardian' ); ?>
					</option>
					<option value="302" <?php selected( $redirect_type, '302' ); ?>>
						<?php esc_html_e( '302 - Temporary', 'glimbyte-ssl-guardian' ); ?>
					</option>
					<option value="307" <?php selected( $redirect_type, '307' ); ?>>
						<?php esc_html_e( '307 - Temporary (preserving method)', 'glimbyte-ssl-guardian' ); ?>
					</option>
				</select>
				<p class="description">
					<?php esc_html_e( 'Use 301 for permanent redirects (SEO-friendly). Use 302/307 for testing.', 'glimbyte-ssl-guardian' ); ?>
				</p>
			</td>
		</tr>

		<tr>
			<th scope="row"><?php esc_html_e( 'Force on All Pages', 'glimbyte-ssl-guardian' ); ?></th>
			<td>
				<label>
					<input type="checkbox" name="glimbyte_ssl_force_all" value="1" <?php checked( $force_all, true ); ?>>
					<?php esc_html_e( 'Force HTTPS on entire site', 'glimbyte-ssl-guardian' ); ?>
				</label>
			</td>
		</tr>

		<tr>
			<th scope="row"><?php esc_html_e( 'Excluded URLs', 'glimbyte-ssl-guardian' ); ?></th>
			<td>
				<textarea name="glimbyte_ssl_excluded_urls" rows="5" class="large-text"><?php echo esc_textarea( $excluded_urls ); ?></textarea>
				<p class="description">
					<?php esc_html_e( 'Enter URLs or patterns to exclude from HTTPS redirect (one per line). Example: /api/, /webhook/. Supports wildcards (*).', 'glimbyte-ssl-guardian' ); ?>
				</p>
			</td>
		</tr>
	</table>

	<?php submit_button(); ?>
</form>
