<?php
/**
 * HSTS Tab View
 *
 * @package Glimbyte_SSL_Manager
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Template variables - passed from parent scope, not globals.
// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound

$hsts_enabled = glimbyte_ssl_get_option( 'hsts_enabled', false );
$hsts_max_age = glimbyte_ssl_get_option( 'hsts_max_age', '31536000' );
$hsts_subdomains = glimbyte_ssl_get_option( 'hsts_subdomains', false );
$hsts_preload = glimbyte_ssl_get_option( 'hsts_preload', false );

// phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
?>

<form method="post" action="options.php">
	<?php settings_fields( 'glimbyte_ssl_hsts' ); ?>

	<div class="notice notice-warning">
		<p><strong><?php esc_html_e( 'Warning:', 'glimbyte-ssl-guardian' ); ?></strong> <?php esc_html_e( 'HSTS is a powerful security feature but can lock your site to HTTPS. Only enable if you are certain your SSL certificate is working correctly and will be renewed on time.', 'glimbyte-ssl-guardian' ); ?></p>
	</div>

	<table class="form-table">
		<tr>
			<th scope="row"><?php esc_html_e( 'Enable HSTS', 'glimbyte-ssl-guardian' ); ?></th>
			<td>
				<label>
					<input type="checkbox" name="glimbyte_ssl_hsts_enabled" value="1" <?php checked( $hsts_enabled, true ); ?>>
					<?php esc_html_e( 'Enable HTTP Strict Transport Security', 'glimbyte-ssl-guardian' ); ?>
				</label>
				<p class="description">
					<?php esc_html_e( 'Forces browsers to always use HTTPS when accessing your site.', 'glimbyte-ssl-guardian' ); ?>
				</p>
			</td>
		</tr>

		<tr>
			<th scope="row"><?php esc_html_e( 'Max Age', 'glimbyte-ssl-guardian' ); ?></th>
			<td>
				<select name="glimbyte_ssl_hsts_max_age">
					<?php foreach ( Glimbyte_SSL_HSTS_Manager::get_max_age_options() as $value => $label ) : // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound ?>
					<option value="<?php echo esc_attr( $value ); ?>" <?php selected( $hsts_max_age, $value ); ?>>
						<?php echo esc_html( $label ); ?>
					</option>
					<?php endforeach; ?>
				</select>
				<p class="description">
					<?php esc_html_e( 'How long browsers should remember to use HTTPS.', 'glimbyte-ssl-guardian' ); ?>
				</p>
			</td>
		</tr>

		<tr>
			<th scope="row"><?php esc_html_e( 'Include Subdomains', 'glimbyte-ssl-guardian' ); ?></th>
			<td>
				<label>
					<input type="checkbox" name="glimbyte_ssl_hsts_subdomains" value="1" <?php checked( $hsts_subdomains, true ); ?>>
					<?php esc_html_e( 'Apply HSTS to all subdomains', 'glimbyte-ssl-guardian' ); ?>
				</label>
				<p class="description">
					<?php esc_html_e( 'Only enable if all your subdomains have valid SSL certificates.', 'glimbyte-ssl-guardian' ); ?>
				</p>
			</td>
		</tr>

		<tr>
			<th scope="row"><?php esc_html_e( 'Preload', 'glimbyte-ssl-guardian' ); ?></th>
			<td>
				<label>
					<input type="checkbox" name="glimbyte_ssl_hsts_preload" value="1" <?php checked( $hsts_preload, true ); ?>>
					<?php esc_html_e( 'Enable HSTS Preload', 'glimbyte-ssl-guardian' ); ?>
				</label>
				<p class="description">
					<?php
					printf(
						/* translators: %s: hstspreload.org link */
						esc_html__( 'Submit your site to the HSTS preload list. Learn more at %s', 'glimbyte-ssl-guardian' ),
						'<a href="https://hstspreload.org/" target="_blank">hstspreload.org</a>'
					);
					?>
				</p>
			</td>
		</tr>
	</table>

	<?php submit_button(); ?>
</form>

<div class="glimbyte-ssl-card">
	<h3><?php esc_html_e( 'About HSTS', 'glimbyte-ssl-guardian' ); ?></h3>
	<p><?php esc_html_e( 'HTTP Strict Transport Security (HSTS) is a web security policy mechanism that helps protect websites against man-in-the-middle attacks.', 'glimbyte-ssl-guardian' ); ?></p>
	<p><?php esc_html_e( 'When enabled, browsers will automatically convert all HTTP requests to HTTPS for the specified duration (max-age).', 'glimbyte-ssl-guardian' ); ?></p>
	<p><strong><?php esc_html_e( 'Important:', 'glimbyte-ssl-guardian' ); ?></strong> <?php esc_html_e( 'HSTS settings are cached by browsers and cannot be immediately reverted. Test thoroughly before enabling.', 'glimbyte-ssl-guardian' ); ?></p>
</div>
