<?php
/**
 * Debug Tab View
 *
 * @package Glimbyte_SSL_Manager
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Template variables - passed from parent scope, not globals.
// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound

$debug_mode = glimbyte_ssl_get_option( 'debug_mode', false );
$logs = Glimbyte_SSL_Logger::get_recent_logs( 100 );
$log_counts = Glimbyte_SSL_Logger::get_log_counts();

// phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound

// Handle log actions.
if ( isset( $_POST['glimbyte_ssl_clear_logs'] ) && check_admin_referer( 'glimbyte_ssl_clear_logs' ) ) {
	Glimbyte_SSL_Logger::clear_logs();
	glimbyte_ssl_add_admin_notice( __( 'Logs cleared successfully.', 'glimbyte-ssl-guardian' ), 'success' );
	wp_safe_redirect( glimbyte_ssl_get_admin_url( 'debug' ) );
	exit;
}

if ( isset( $_GET['export_logs'] ) && check_admin_referer( 'glimbyte_ssl_export_logs', 'nonce' ) ) {
	$logs_text = Glimbyte_SSL_Logger::export_logs() ; // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	header( 'Content-Type: text/plain; charset=utf-8' );
	header( 'Content-Disposition: attachment; filename="glimbyte-ssl-logs-' . gmdate( 'Y-m-d-H-i-s' ) . '.txt"' );
	// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Plain text file export
	echo $logs_text;
	exit;
}
?>

<form method="post" action="options.php">
	<?php settings_fields( 'glimbyte_ssl_debug' ); ?>

	<table class="form-table">
		<tr>
			<th scope="row"><?php esc_html_e( 'Debug Mode', 'glimbyte-ssl-guardian' ); ?></th>
			<td>
				<label>
					<input type="checkbox" name="glimbyte_ssl_debug_mode" value="1" <?php checked( $debug_mode, true ); ?>>
					<?php esc_html_e( 'Enable debug logging', 'glimbyte-ssl-guardian' ); ?>
				</label>
				<p class="description">
					<?php esc_html_e( 'Log plugin actions for troubleshooting. Disable in production for better performance.', 'glimbyte-ssl-guardian' ); ?>
				</p>
			</td>
		</tr>
	</table>

	<?php submit_button(); ?>
</form>

<hr>

<h2><?php esc_html_e( 'Activity Logs', 'glimbyte-ssl-guardian' ); ?></h2>

<div class="glimbyte-ssl-log-stats">
	<p>
		<strong><?php esc_html_e( 'Total Logs:', 'glimbyte-ssl-guardian' ); ?></strong>
		<?php echo esc_html( number_format_i18n( count( $logs ) ) ); ?>
		(<?php
		printf(
			/* translators: 1: Info count, 2: Warning count, 3: Error count */
			esc_html__( '%1$d info, %2$d warnings, %3$d errors', 'glimbyte-ssl-guardian' ),
			absint( $log_counts['info'] ),
			absint( $log_counts['warning'] ),
			absint( $log_counts['error'] )
		);
		?>)
	</p>
</div>

<form method="post" action="" style="display: inline-block;">
	<?php wp_nonce_field( 'glimbyte_ssl_clear_logs' ); ?>
	<button type="submit" name="glimbyte_ssl_clear_logs" class="button" onclick="return confirm('<?php esc_attr_e( 'Are you sure you want to clear all logs?', 'glimbyte-ssl-guardian' ); ?>');">
		<?php esc_html_e( 'Clear Logs', 'glimbyte-ssl-guardian' ); ?>
	</button>
</form>

<a href="<?php echo esc_url( wp_nonce_url( add_query_arg( 'export_logs', '1', glimbyte_ssl_get_admin_url( 'debug' ) ), 'glimbyte_ssl_export_logs', 'nonce' ) ); ?>" class="button">
	<?php esc_html_e( 'Export Logs', 'glimbyte-ssl-guardian' ); ?>
</a>

<?php if ( ! empty( $logs ) ) : ?>
<table class="wp-list-table widefat fixed striped" style="margin-top: 20px;">
	<thead>
		<tr>
			<th style="width: 150px;"><?php esc_html_e( 'Time', 'glimbyte-ssl-guardian' ); ?></th>
			<th style="width: 80px;"><?php esc_html_e( 'Type', 'glimbyte-ssl-guardian' ); ?></th>
			<th><?php esc_html_e( 'Message', 'glimbyte-ssl-guardian' ); ?></th>
		</tr>
	</thead>
	<tbody>
		<?php // phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound ?>
		<?php foreach ( $logs as $log ) : ?>
		<tr>
			<td><?php echo esc_html( gmdate( 'Y-m-d H:i:s', $log['timestamp'] ) ); ?></td>
			<td>
				<?php
				$type = $log['type'];
				$type_class = 'log-type-' . $type;
				$type_colors = array(
					'info'    => '#007cba',
					'warning' => '#dba617',
					'error'   => '#d63638',
				);
				$color = isset( $type_colors[ $type ] ) ? $type_colors[ $type ] : '#000';
				echo '<span style="color: ' . esc_attr( $color ) . '; font-weight: 600;">' . esc_html( strtoupper( $type ) ) . '</span>';
				?>
			</td>
			<td><?php echo esc_html( $log['message'] ); ?></td>
		</tr>
		<?php endforeach; ?>
		// phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	</tbody>
</table>
<?php else : ?>
<p><?php esc_html_e( 'No logs available. Enable debug mode to start logging.', 'glimbyte-ssl-guardian' ); ?></p>
<?php endif; ?>
