<?php
/**
 * Certificate Monitor Tab View
 *
 * @package Glimbyte_SSL_Manager
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Template variables - passed from parent scope, not globals.
// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound

$cert_info = glimbyte_ssl_get_cert_info();
$cert_alert_enabled = glimbyte_ssl_get_option( 'cert_alert_enabled', true );
$cert_alert_days = glimbyte_ssl_get_option( 'cert_alert_days', '30,14,7' );
$cert_alert_email = glimbyte_ssl_get_option( 'cert_alert_email', get_option( 'admin_email' ) );

// phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
?>

<form method="post" action="options.php">
	<?php settings_fields( 'glimbyte_ssl_certificate' ); ?>

	<h2><?php esc_html_e( 'Certificate Information', 'glimbyte-ssl-guardian' ); ?></h2>

	<?php if ( ! is_wp_error( $cert_info ) ) : ?>
	<table class="wp-list-table widefat fixed striped">
		<tr>
			<th><?php esc_html_e( 'Domain', 'glimbyte-ssl-guardian' ); ?></th>
			<td><?php echo esc_html( $cert_info['subject'] ); ?></td>
		</tr>
		<tr>
			<th><?php esc_html_e( 'Issuer', 'glimbyte-ssl-guardian' ); ?></th>
			<td><?php echo esc_html( $cert_info['issuer'] ); ?></td>
		</tr>
		<tr>
			<th><?php esc_html_e( 'Valid From', 'glimbyte-ssl-guardian' ); ?></th>
			<td><?php echo esc_html( glimbyte_ssl_format_date( $cert_info['valid_from'] ) ); ?></td>
		</tr>
		<tr>
			<th><?php esc_html_e( 'Valid Until', 'glimbyte-ssl-guardian' ); ?></th>
			<td><?php echo esc_html( glimbyte_ssl_format_date( $cert_info['valid_to'] ) ); ?></td>
		</tr>
		<tr>
			<th><?php esc_html_e( 'Days Until Expiry', 'glimbyte-ssl-guardian' ); ?></th>
			<td>
				<?php // phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
				$days_left = absint( $cert_info['days_left'] );
				if ( $days_left > 30 ) {
					$style = 'color: #00a32a; font-weight: 600;';
				} elseif ( $days_left > 7 ) {
					$style = 'color: #dba617; font-weight: 600;';
				} else {
					$style = 'color: #d63638; font-weight: 600;';
				}
				printf( '<span style="%s">%d days</span>', esc_attr( $style ), absint( $days_left ) );
				// phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
				?>
			</td>
		</tr>
		<tr>
			<th><?php esc_html_e( 'Signature Algorithm', 'glimbyte-ssl-guardian' ); ?></th>
			<td><?php echo esc_html( $cert_info['signature'] ); ?></td>
		</tr>
		<tr>
			<th><?php esc_html_e( 'Status', 'glimbyte-ssl-guardian' ); ?></th>
			<td>
				<?php
				if ( 'valid' === $cert_info['status'] ) {
					echo '<span style="color: #00a32a; font-weight: 600;">' . esc_html__( 'Valid', 'glimbyte-ssl-guardian' ) . '</span>';
				} elseif ( 'expiring_soon' === $cert_info['status'] ) {
					echo '<span style="color: #dba617; font-weight: 600;">' . esc_html__( 'Expiring Soon', 'glimbyte-ssl-guardian' ) . '</span>';
				} else {
					echo '<span style="color: #d63638; font-weight: 600;">' . esc_html__( 'Expired', 'glimbyte-ssl-guardian' ) . '</span>';
				}
				?>
			</td>
		</tr>
	</table>
	<?php else : ?>
	<div class="notice notice-error">
		<p><strong><?php esc_html_e( 'Error:', 'glimbyte-ssl-guardian' ); ?></strong> <?php echo esc_html( $cert_info->get_error_message() ); ?></p>
	</div>
	<?php endif; ?>

	<hr>

	<h2><?php esc_html_e( 'Expiry Alerts', 'glimbyte-ssl-guardian' ); ?></h2>

	<table class="form-table">
		<tr>
			<th scope="row"><?php esc_html_e( 'Enable Alerts', 'glimbyte-ssl-guardian' ); ?></th>
			<td>
				<label>
					<input type="checkbox" name="glimbyte_ssl_cert_alert_enabled" value="1" <?php checked( $cert_alert_enabled, true ); ?>>
					<?php esc_html_e( 'Send email alerts before certificate expires', 'glimbyte-ssl-guardian' ); ?>
				</label>
			</td>
		</tr>

		<tr>
			<th scope="row"><?php esc_html_e( 'Alert Days', 'glimbyte-ssl-guardian' ); ?></th>
			<td>
				<input type="text" name="glimbyte_ssl_cert_alert_days" value="<?php echo esc_attr( $cert_alert_days ); ?>" class="regular-text">
				<p class="description">
					<?php esc_html_e( 'Days before expiry to send alerts (comma-separated). Default: 30,14,7', 'glimbyte-ssl-guardian' ); ?>
				</p>
			</td>
		</tr>

		<tr>
			<th scope="row"><?php esc_html_e( 'Alert Email', 'glimbyte-ssl-guardian' ); ?></th>
			<td>
				<input type="email" name="glimbyte_ssl_cert_alert_email" value="<?php echo esc_attr( $cert_alert_email ); ?>" class="regular-text">
				<p class="description">
					<?php esc_html_e( 'Email address to receive alerts', 'glimbyte-ssl-guardian' ); ?>
				</p>
			</td>
		</tr>
	</table>

	<?php submit_button(); ?>
</form>

<button type="button" id="glimbyte-ssl-test-email-btn" class="button">
	<?php esc_html_e( 'Send Test Email', 'glimbyte-ssl-guardian' ); ?>
</button>
