/**
 * Glimbyte SSL Guardian - Admin Scripts
 *
 * @package Glimbyte_SSL_Manager
 */

(function($) {
	'use strict';

	$(document).ready(function() {
		
		// Scan Content Button
		$('#glimbyte-ssl-scan-btn').on('click', function() {
			var $button = $(this);
			var $progress = $('#glimbyte-ssl-scan-progress');
			var $results = $('#glimbyte-ssl-scan-results');

			$button.prop('disabled', true).text(glimbyteSSL.strings.scanning);
			$progress.show();
			$results.hide();

			$.ajax({
				url: glimbyteSSL.ajax_url,
				type: 'POST',
				data: {
					action: 'glimbyte_ssl_scan_content',
					nonce: glimbyteSSL.nonce
				},
				success: function(response) {
					if (response.success) {
						location.reload();
					} else {
						alert(response.data.message || glimbyteSSL.strings.error);
					}
				},
				error: function() {
					alert(glimbyteSSL.strings.error);
				},
				complete: function() {
					$button.prop('disabled', false).text('Scan Content');
					$progress.hide();
				}
			});
		});

		// Fix Content Button
		$('#glimbyte-ssl-fix-btn').on('click', function() {
			if (!confirm('This will modify your database content. Make sure you have a backup. Continue?')) {
				return;
			}

			var $button = $(this);
			var $progress = $('#glimbyte-ssl-scan-progress');

			$button.prop('disabled', true).text(glimbyteSSL.strings.fixing);
			$progress.show();

			$.ajax({
				url: glimbyteSSL.ajax_url,
				type: 'POST',
				data: {
					action: 'glimbyte_ssl_fix_content',
					nonce: glimbyteSSL.nonce
				},
				success: function(response) {
					if (response.success) {
						alert(glimbyteSSL.strings.fix_complete + ' Posts fixed: ' + response.data.posts_fixed);
						location.reload();
					} else {
						alert(response.data.message || glimbyteSSL.strings.error);
					}
				},
				error: function() {
					alert(glimbyteSSL.strings.error);
				},
				complete: function() {
					$button.prop('disabled', false).text('Fix All Issues in Database');
					$progress.hide();
				}
			});
		});

		// Test Email Button
		$('#glimbyte-ssl-test-email-btn').on('click', function() {
			var $button = $(this);

			$button.prop('disabled', true).text('Sending...');

			$.ajax({
				url: glimbyteSSL.ajax_url,
				type: 'POST',
				data: {
					action: 'glimbyte_ssl_test_email',
					nonce: glimbyteSSL.nonce
				},
				success: function(response) {
					if (response.success) {
						alert(response.data.message);
					} else {
						alert(response.data.message || glimbyteSSL.strings.error);
					}
				},
				error: function() {
					alert(glimbyteSSL.strings.error);
				},
				complete: function() {
					$button.prop('disabled', false).text('Send Test Email');
				}
			});
		});

		// Support Form - Show
		$('#show-support-form').on('click', function() {
			$(this).hide();
			$('#support-form-container').slideDown(300);
		});

		// Support Form - Cancel
		$('#cancel-support-form').on('click', function() {
			$('#support-form-container').slideUp(300, function() {
				$('#show-support-form').show();
				$('#support-form')[0].reset();
				$('#support-form-result').hide();
			});
		});

		// Support Form - Submit
		$('#support-form').on('submit', function(e) {
			e.preventDefault();

			var $form = $(this);
			var $submitBtn = $form.find('button[type="submit"]');
			var $result = $('#support-form-result');
			var originalHtml = $submitBtn.html();

			// Get form data
			var formData = {
				action: 'glimbyte_ssl_submit_support',
				nonce: glimbyteSSL.nonce,
				name: $form.find('input[name="name"]').val(),
				email: $form.find('input[name="email"]').val(),
				phone: $form.find('input[name="phone"]').val(),
				message: $form.find('textarea[name="message"]').val(),
				consent: $form.find('input[name="consent"]').is(':checked') ? 1 : 0
			};

			// Disable submit button
			$submitBtn.prop('disabled', true).html('<span class="dashicons dashicons-update spin"></span> Sending...');
			$result.hide();

			$.ajax({
				url: glimbyteSSL.ajax_url,
				type: 'POST',
				data: formData,
				success: function(response) {
					if (response.success) {
						$result
							.removeClass('notice-error')
							.addClass('notice-success')
							.html('<p><strong>' + response.data.message + '</strong></p>')
							.slideDown();
						
						// Reset form
						$form[0].reset();
						
						// Hide form after 3 seconds
						setTimeout(function() {
							$('#support-form-container').slideUp(300, function() {
								$('#show-support-form').show();
								$result.hide();
							});
						}, 3000);
					} else {
						$result
							.removeClass('notice-success')
							.addClass('notice-error')
							.html('<p><strong>' + response.data.message + '</strong></p>')
							.slideDown();
					}
				},
				error: function() {
					$result
						.removeClass('notice-success')
						.addClass('notice-error')
						.html('<p><strong>' + glimbyteSSL.strings.error + '</strong></p>')
						.slideDown();
				},
				complete: function() {
					$submitBtn.prop('disabled', false).html(originalHtml);
				}
			});
		});

	});

})(jQuery);
