/**
 * Claim UI
 *
 * @package Gift_Card_Manager
 */

( ( $ ) => {
	window.giftCardManagerClaim = ( btn, test ) => {
		const get               = selector => $( btn ).closest( 'div' ).find( selector );
		get( '.woogiftcard-status' ).css( 'display', 'none' );
		get( '.woogiftcard-busy' ).css( 'display', '' );
		$
			.post(
				gift_card_manager_php_claim_settings.ajax_url,
				{
					...{
						action: 'gift_card_manager_claim_ajax',
						_ajax_nonce: gift_card_manager_php_claim_settings.ajax_nonce,
						code: get( 'input' ).val().trim()
					},
					...(test ? { test : 1 } : {})
				},
				function (data) {
					if ( data && typeof data === 'object' ) {
						get( '.woogiftcard-status' ).css( 'display', 'none' );
					}
					if ( data.error ) {
						get( '.woogiftcard-' + data.error ).css(
							'display',
							''
						);
					} else if ( data.ok ) {
						get( '.woogiftcard-success' ).css( 'display', '' )
						get( '.woogiftcard-amount' ).text( data.value );
					} else {
						get( '.woogiftcard-failed' ).css( 'display', '' );
					}
				}
			)
			.fail(
				function () {
					get( '.woogiftcard-status' ).css( 'display', 'none' );
					get( '.woogiftcard-failed' ).css( 'display', '' );
				}
			);
	};
} )( jQuery );