<?php
/*
Plugin Name: Gif Controller
Plugin URI: https://github.com/mostafa272/Gif-Controller
Description: The GIF Controller is a simple and lightweight plugin for playing and stopping the GIF images.
Version: 1.0
Author: Mostafa Shahiri<mostafa2134@gmail.com>
Author URI: https://github.com/mostafa272
*/
/*  Copyright 2009  Mostafa Shahiri(email : mostafa2134@gmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
add_action('admin_menu', 'gif_controller_setup_menu');
add_action( 'wp_enqueue_scripts', 'gif_controller_scripts' );
add_action('admin_init', 'gif_controller_register_settings');
function gif_controller_setup_menu(){
        add_menu_page( 'GIF Controller Plugin', 'GIF Controller', 'manage_options', 'gif-controller', 'gif_controller_init' );
}
function gif_controller_register_settings(){

    register_setting('gif-controller-settings', 'gif_hover');
     register_setting('gif-controller-settings', 'gif_wait');
      register_setting('gif-controller-settings', 'gif_labelimg');

}
function gif_controller_init(){
?>
        <h1>GIF Controller Setting</h1>
        <form  method="post" action="options.php" >
        <?php settings_fields( 'gif-controller-settings' ); ?>
    <?php do_settings_sections( 'gif-controller-settings' ); ?>
    <table class="form-table">
    <tbody>
    <tr><th scope="row"><label>Hover Play?</label></th>
    <td> <input type="radio" id="gif_hover" style="margin-left:20px;" name="gif_hover" value="1" <?php checked( '1', get_option( 'gif_hover' ) ); ?>/>Yes
 <input type="radio" id="gif_hover" name="gif_hover" style="margin-left:20px;" value="0" <?php checked( '0', get_option( 'gif_hover' ) ); ?>/>No</td></tr>
      <tr><th scope="row"><label>Wait to load?</label></th>
    <td><input type="radio" id="gif_wait" name="gif_wait" style="margin-left:20px;" value="1" <?php checked( '1', get_option( 'gif_wait' ) ); ?>/>Yes
    <input type="radio" id="gif_wait" name="gif_wait" style="margin-left:20px;" value="0" <?php checked( '0', get_option( 'gif_wait' ) ); ?>/>No</td></tr>
    <tr><th scope="row"><label>Label text:</label></th>
    <td> <input type="text" name="gif_labelimg" value="<?php echo empty(get_option('gif_labelimg'))?'Play':sanitize_text_field(get_option('gif_labelimg'));  ?>"/></td></tr>
               <tr><td><?php submit_button('Save') ?>  </td></tr>
                </tbody>
                </table>
        </form>
<?php
}
/**
 * Add our JS and CSS files
 */
function gif_controller_scripts() {
      wp_enqueue_script( 'gifcontroller-script', plugins_url( 'js/script.js', __FILE__ ),array('jquery'),'1.0',false );
         wp_enqueue_style( 'gifcontroller-style', plugins_url( 'css/style.css', __FILE__ ) );
}
//Add custom JS tage
function gif_controller_custom_js() {
 $labelimg=sanitize_text_field(get_option('gif_labelimg'));
$gifscript="jQuery(document).ready( function(){
				jQuery('.gifctrl').gifplayer({label:'".$labelimg."'});
			});";
    echo '<script type="text/javascript">'.$gifscript.'</script>';
}
add_action( 'wp_head', 'gif_controller_custom_js' );

function gif_controller_applygif( $content ) {

       $hover=get_option('gif_hover');
       $wait=get_option('gif_wait');
       $found=preg_match_all('#<img(.*?)src="(.*?).gif"(.*?)>#i', $content, $images);
       if($found){
       foreach ($images[0] as $img)
       {
       $s=preg_match_all('#src="(.*?)"#s', $img, $src);
       if($s)
       {
       foreach( $src[0] as $sr)
       {
       $tmpsrc1=str_replace('src="','',$sr);
       $tmpsrc2=str_replace('.gif"','.jpg',$tmpsrc1);
      $tmpath=parse_url($tmpsrc2);
       if(!file_exists($_SERVER['DOCUMENT_ROOT'].$tmpath['path']))
       { $gifimg = imagecreatefromgif(substr($tmpsrc1,0,-1));
       imagejpeg($gifimg,$_SERVER['DOCUMENT_ROOT'].$tmpath['path']);
       imagedestroy($gifimg);
       }
       }
       }
       $f=preg_match_all('#class="(.*?)"#s', $img, $class);
       if($f)
       {
       foreach( $class[0] as $c)
       {
       $img1=preg_replace('#'.$c.'#s',substr($c,0,-1).' gifctrl"',$img);
       }
       }
       else{
       $img1=preg_replace('#'.$img.'#s',substr($img,0,-2).' class="gifctrl" />',$img);
       }
       $content=preg_replace('#'.$img.'#s',$img1,$content);

       $a='';
       if($hover)
       $a=' data-playon="hover"';
       if($wait)
       $a=$a.' data-wait="true"';
       $content=preg_replace('#'.$img1.'#s',substr($img1,0,-2).$a.'/>',$content);

       }
       $content=str_replace('.gif','.jpg',$content);
       return $content;
       }
       }
 add_filter('the_content','gif_controller_applygif');