<?php
if (!defined('ABSPATH')) exit;

function ghostgate_render_code_form($args = []) {
    // デフォルト値とマージ
    $defaults = [
        'title'       => __('認証コードを入力してください', 'ghostgate'),
        'button'      => __('送信', 'ghostgate'),
        'max_length'  => absint(get_option('ghostgate_code_length', 4)),
        'redirect_to' => home_url('/' . trim(get_option('ghostgate_login_slug', 'ghost-login'), '/')),
        'input_id'    => 'ghostgate-code',
        'input_name'  => 'code',
    ];
    $args = wp_parse_args($args, $defaults);

    // 個別
    $title       = $args['title'];
    $button      = $args['button'];
    $max_length  = (int) $args['max_length'];
    $redirect_to = $args['redirect_to'];
    $input_id    = $args['input_id'];
    $input_name  = $args['input_name'];

    // ブランド（フィルタ差し替え可）
    $brand_logo_1x = apply_filters(
        'ghostgate_brand_logo_url',
        GHOSTGATE_URL . 'assets/img/icon-256x256.png'
    );
    // 2x が未用意なら 1x を使う（審査向けに安全）
    $brand_logo_2x = apply_filters(
        'ghostgate_brand_logo_url_2x',
        GHOSTGATE_URL . 'assets/img/icon-512x512.png'
    );
    if (empty($brand_logo_2x)) {
        $brand_logo_2x = $brand_logo_1x;
    }

    $brand_title    = apply_filters('ghostgate_brand_title',    __('Ghost Gate', 'ghostgate'));
    $brand_subtitle = apply_filters('ghostgate_brand_subtitle', __('Invisible Entrance', 'ghostgate'));

    // アセット
    $script_handle = 'ghostgate-code-form';
    $script_url    = GHOSTGATE_URL . 'assets/js/ghost-script.js';
    $style_handle  = 'ghostgate-code-style';
    $style_url     = GHOSTGATE_URL . 'assets/css/ghost-style.css';
    $version       = defined('GHOSTGATE_VERSION') ? GHOSTGATE_VERSION : '1.3.2';

    // JS注入
    add_action('wp_footer', function () use (
        $script_handle, $script_url, $input_id, $input_name,
        $max_length, $redirect_to, $version
    ) {
        wp_enqueue_script($script_handle, $script_url, [], $version, true);

        $vars = [
            'input_id'    => $input_id,
            'input_name'  => $input_name,
            'max_length'  => $max_length,
            'alert_text'  => __('正しいコードを入力してください', 'ghostgate'),
            'redirect_to' => esc_url($redirect_to),
        ];
        wp_add_inline_script(
            $script_handle,
            'window.ghostgateVars = ' . wp_json_encode($vars) . ';',
            'before'
        );
    }, 5);

    // CSS読込み
    add_action('wp_enqueue_scripts', function () use ($style_handle, $style_url, $version) {
        wp_enqueue_style($style_handle, $style_url, [], $version);
    }, 5);

    // HTML
    ?>
    <!DOCTYPE html>
    <html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo('charset'); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title><?php echo esc_html($title); ?></title>
        <?php wp_head(); ?>
    </head>
    <body class="ghostgate-auth-code-page">
        <div class="ghostgate-login-container">
            <!-- ブランドヘッダー -->
            <div class="ghostgate-brand" role="banner" aria-label="<?php echo esc_attr($brand_title); ?>">
                <img
                    class="ghostgate-brand__logo"
                    src="<?php echo esc_url($brand_logo_1x); ?>"
                    srcset="<?php echo esc_url($brand_logo_1x); ?> 1x, <?php echo esc_url($brand_logo_2x); ?> 2x"
                    alt="<?php echo esc_attr($brand_title); ?>"
                    width="64" height="64"
                    loading="eager" decoding="async"
                />
                <div class="ghostgate-brand__text">
                    <div class="ghostgate-brand__title"><?php echo esc_html($brand_title); ?></div>
                    <div class="ghostgate-brand__subtitle"><?php echo esc_html($brand_subtitle); ?></div>
                </div>
            </div>

            <h2 class="ghostgate-form-title"><?php echo esc_html($title); ?></h2>

            <!-- アクセシビリティ説明（視覚非表示） -->
            <p class="screen-reader-text" id="ghostgate-desc">
                <?php esc_html_e('セキュリティ保護のため、受け取った認証コードを入力してください。', 'ghostgate'); ?>
            </p>

            <label for="<?php echo esc_attr($input_id); ?>" class="screen-reader-text">
                <?php echo esc_html($title); ?>
            </label>
            <input
                id="<?php echo esc_attr($input_id); ?>"
                name="<?php echo esc_attr($input_name); ?>"
                type="text"
                maxlength="<?php echo esc_attr($max_length); ?>"
                inputmode="numeric"
                autocomplete="one-time-code"
                aria-describedby="ghostgate-desc"
                class="ghostgate-code-input"
            >
            <br><br>
            <button id="ghostgate-check-btn" class="ghostgate-submit-btn">
                <?php echo esc_html($button); ?>
            </button>
        </div>
        <?php wp_footer(); ?>
    </body>
    </html>
    <?php
}
