<?php
if ( ! defined( 'ABSPATH' ) ) exit;

add_action( 'admin_post_ghostgate_unblock_ip', 'ghostgate_handle_unblock_ip' );

function ghostgate_handle_unblock_ip() {
	// メニューと同じ権限（必要ならフィルタで変更）
	$cap = apply_filters( 'ghostgate_required_capability', 'manage_options' );
	if ( ! current_user_can( $cap ) ) {
		wp_die( esc_html__( 'You do not have permission.', 'ghostgate' ), '', array( 'response' => 403 ) );
	}

	check_admin_referer( 'ghostgate_unblock_ip_action' );

	// --- 入力の安全な取り出し（$_POSTを必ず配列化） ---
	$ips_raw = array();
	if ( isset( $_POST['ip'] ) ) {
		$val = $_POST['ip'];
		// ボタン(name="ip") or チェックボックス(name="ip[]") の両対応
		$ips_raw = is_array( $val ) ? $val : array( $val );
	}

	// --- 正規化（unslash → sanitize） ---
	$ips_raw = array_map(
		static function ( $v ) {
			$v = is_string( $v ) ? $v : '';
			$v = wp_unslash( $v );
			return sanitize_text_field( $v );
		},
		$ips_raw
	);

	// --- 検証（IPv4/IPv6 のみ許可） ---
	$ips = array_values(
		array_filter(
			array_unique(
				array_map(
					static function ( $v ) {
						// 念のため許可文字だけ残す
						$v = preg_replace( '/[^0-9a-fA-F:\.\-]/', '', (string) $v );
						return filter_var( $v, FILTER_VALIDATE_IP ) ? $v : '';
					},
					$ips_raw
				)
			)
		)
	);

	// --- 未選択ならそのまま戻る ---
	$dst = wp_get_referer();
	if ( ! $dst ) {
		$dst = is_network_admin()
			? network_admin_url( 'admin.php?page=ghostgate' )
			: admin_url( 'admin.php?page=ghostgate' );
	}

	if ( empty( $ips ) ) {
		$dst = add_query_arg( array( 'ghostgate_msg' => 'no_targets' ), $dst );
		wp_safe_redirect( wp_validate_redirect( $dst, admin_url( 'admin.php?page=ghostgate' ) ) );
		exit;
	}

	// --- 解除実行 ---
	foreach ( $ips as $ip ) {
		if ( function_exists( 'ghostgate_unblock_ip' ) ) {
			ghostgate_unblock_ip( $ip );
		}
	}

	// --- 戻り先へ（件数付きメッセージ） ---
	$dst = add_query_arg(
		array(
			'ghostgate_msg' => 'unblocked',
			'count'         => count( $ips ),
		),
		$dst
	);
	wp_safe_redirect( wp_validate_redirect( $dst, admin_url( 'admin.php?page=ghostgate' ) ) );
	exit;
}
