<?php
/**
 * Plugin Name: GhostGate
 * Plugin URI: https://arce-experience.com/product/
 * Description: ログインURLを隠して、2FA認証やDoS遮断も可能なWordPress専用セキュリティ強化ツールです。WordPress Login Hardening Plugin.
 * Version: 1.3.3
 * Author: ジー（Code GEE）
 * Author URI: https://arce-experience.com/developer/
 * License: GPLv2 or later
 * Text Domain: ghostgate
 * Domain Path: /languages
 */

// セキュリティ: 直アクセス防止
if (!defined('ABSPATH')) {
    exit;
}

// 定数定義
define('GHOSTGATE_VERSION', '1.3.3');
define('GHOSTGATE_PATH', plugin_dir_path(__FILE__));
define('GHOSTGATE_URL', plugin_dir_url(__FILE__));
define('GHOSTGATE_ASSETS_URL', plugin_dir_url(__FILE__) . 'assets/');
// GHOSTGATE_LOG_FILE is a plugin-specific constant for the login log file path.
// This uses the uploads directory to ensure compatibility with all WordPress setups.
$ghostgate_upload_dir = wp_upload_dir();
$ghostgate_log_path   = trailingslashit($ghostgate_upload_dir['basedir']) . 'ghostgate/sbp2-login.log';
define('GHOSTGATE_LOG_FILE', $ghostgate_log_path);


// オートローダーや依存読み込み（ここでは手動でinc/をロード）
require_once GHOSTGATE_PATH . 'inc/core.php';
require_once GHOSTGATE_PATH . 'inc/logger.php';
require_once GHOSTGATE_PATH . 'inc/two-factor-auth.php';
require_once GHOSTGATE_PATH . 'inc/block-admin-ajax.php';
require_once GHOSTGATE_PATH . 'inc/admin-ui.php';
require_once GHOSTGATE_PATH . 'inc/admin-actions.php';
require_once GHOSTGATE_PATH . 'inc/template-functions.php';
require_once GHOSTGATE_PATH . 'inc/feature-login-slug.php';
require_once GHOSTGATE_PATH . 'inc/session-manager.php';
require_once GHOSTGATE_PATH . 'inc/admin-enqueue.php';


register_activation_hook(__FILE__, function () use ($ghostgate_log_path) {
    $defaults = [
        'ghostgate_login_slug'              => 'ghost-login',
        'ghostgate_code_mode'               => 'date',
        'ghostgate_enable_code_mode'        => '1',
        'ghostgate_code_length'             => 4,
        'ghostgate_enable_code_length'      => '1',
        'ghostgate_enable_2fa'              => '1',
        'ghostgate_ajax_limit'              => 3,
        'ghostgate_enable_ajax_limit'       => '1',
        'ghostgate_log_file_path'           => $ghostgate_log_path,
        'ghostgate_enable_log_file'         => '1',
        'ghostgate_notify_on_block'         => '1',
        'ghostgate_block_author_enum'       => '1',
        'ghostgate_disable_xmlrpc'          => '1',
        'ghostgate_enable_login_limit'      => '1',
        'ghostgate_login_attempt_limit'     => 3,
        'ghostgate_enable_login_slug'       => '1',
        'ghostgate_block_unused_rest'       => '0',
    ];

    foreach ($defaults as $key => $value) {
        if (get_option($key) === false) {
            add_option($key, $value);
        }
    }
});
