// REVIEW: 審査対応 — 変数名を ghostgVars → window.ghostgateVars に統一（機能変更なし）
document.addEventListener("DOMContentLoaded", function () {
    const v = window.ghostgateVars;
    if (!v) return;

    const el  = document.getElementById(v.input_id);
    const btn = document.getElementById("ghostgate-check-btn");

    if (!el || !btn) return;

    // ✅ 強制的に maxlength を再適用（安全策）
    el.setAttribute("maxlength", v.max_length);

    btn.addEventListener("click", function () {
        const val = el.value.trim();

        if (val.length > v.max_length) {
            alert(v.alert_text);
            el.style.border = "2px solid red";
            el.focus();
            return;
        }

        const param     = encodeURIComponent(v.input_name) + '=' + encodeURIComponent(val);
        const connector = v.redirect_to.includes('?') ? '&' : '?';
        const url       = v.redirect_to + connector + param;

        window.location.href = url;
    });
});
