document.addEventListener("DOMContentLoaded", function () {
    // タブ切り替え
    const tabs = document.querySelectorAll(".ghostgate-tab");
    const contents = document.querySelectorAll(".ghostgate-tab-content");
    tabs.forEach(tab => {
        tab.addEventListener("click", function () {
            tabs.forEach(t => t.classList.remove("active"));
            contents.forEach(c => c.classList.remove("active"));
            this.classList.add("active");
            const target = document.getElementById(this.dataset.target);
            if (target) target.classList.add("active");
        });
    });

    // ログインスラッグ → コード連動
    const mainSwitch = document.getElementById("ghostgate_enable_login_slug");
    const subSwitches = [
        document.getElementById("ghostgate_enable_code_length"),
        document.getElementById("ghostgate_enable_code_mode")
    ];
    if (mainSwitch && subSwitches.every(Boolean)) {
        mainSwitch.addEventListener("change", function () {
            subSwitches.forEach(sw => {
                sw.checked = mainSwitch.checked;
            });
        });
    }

const select = document.getElementById("ghostgate_code_mode");
const customWrap = document.getElementById("ghostgate_custom_code_wrap");
if (select && customWrap) {
    select.addEventListener("change", function () {
        if (this.value === "custom") {
            customWrap.classList.add("visible");
        } else {
            customWrap.classList.remove("visible");
        }
    });
}

    // RESTエンドポイント一覧のトグル
    const toggleBtn = document.getElementById("ghostgate-toggle-route-list");
    const accordion = document.getElementById("ghostgate-route-list");
    if (toggleBtn && accordion) {
        toggleBtn.addEventListener("click", function () {
            accordion.classList.toggle("hidden");
        });
    }

    const customCodeInput  = document.querySelector("input[name='ghostgate_custom_code']");
    const codeLengthInput  = document.querySelector("input[name='ghostgate_code_length']");
    const codeModeSelect   = document.getElementById("ghostgate_code_mode");

    function updateLengthFromCustom() {
        if (!customCodeInput || !codeLengthInput) return;

        const digits = customCodeInput.value.trim().length;

        if (digits >= 3 && digits <= 8) {
            codeLengthInput.value = digits;
        } else {
        }
    }

    // 入力時に桁数反映
    if (customCodeInput && codeLengthInput) {
        customCodeInput.addEventListener("input", updateLengthFromCustom);
    }

    // カスタム形式が選ばれたとき、既存の入力から桁数反映
    if (codeModeSelect) {
        codeModeSelect.addEventListener("change", function () {
            if (this.value === "custom") {
                updateLengthFromCustom();
            }
        });
    }


    if (codeModeSelect && codeLengthInput) {
        codeModeSelect.addEventListener("change", function () {
            const mode = this.value;

            if (mode !== "custom") {
                codeLengthInput.value = 4;
            }
        });
    }

});



document.addEventListener('DOMContentLoaded', function () {
    const elapsedEl = document.getElementById('ghostgate-elapsed');
    const remainingEl = document.getElementById('ghostgate-remaining');

    if (!elapsedEl || !remainingEl) return;

    let elapsed = parseInt(elapsedEl.dataset.elapsed, 10);
    let remaining = parseInt(remainingEl.dataset.remaining, 10);

    function updateSessionDisplay() {
        elapsed++;
        remaining--;

        if (remaining < 0) remaining = 0;

        elapsedEl.textContent = elapsed;
        remainingEl.textContent = remaining;
    }

    setInterval(updateSessionDisplay, 1000);
});
