<?php
/*
Plugin Name: GF Limit Payments
Plugin URI: https://wordpress.org/plugins/gf-queries
Version: 1.0.2
Description: End subscription payments after a certain number of payments
Author: James Low
Author URI: http://jameslow.com
*/

require_once 'gf-limit-payments-addon.php';

class GFLimitPayments {
	static $slugs;

	public static function slugs() {
		if (self::$slugs == null) {
			//TODO: Can add braintree, paypal (although paypal addon supports a certain number of payments), or other payment feed in the future;
			self::$slugs = array('gravityformsstripe');
		}
		return self::$slugs;
	}
	public static function add_hooks() {
		add_action('gform_loaded', array('GFLimitPayments', 'gform_loaded'), 5);
		add_action('gform_post_payment_callback', array('GFLimitPayments', 'process_payment'), 10, 3);
	}
	public static function gform_loaded() {
		GFAddOn::register('GFLimitPaymentsAddon');
	}
	public static function log($obj) {
		error_log(print_r($obj, true));
	}
	public static function is_recurring($feed) {
		return $feed['meta']['recurringAmount'] && !isset($feed['meta']['recurringTimes']);
	}
	public static function get_feed($form_id, $slug) {
		$feeds = GFAPI::get_feeds(null, $form_id);
		foreach ($feeds as $feed) {
			if ($feed['addon_slug'] == $slug && self::is_recurring($feed)) {
				return $feed;
			}
		}
	}
	public static function process_payment($entry, $action, $result) {
		global $wpdb;
		//https://docs.gravityforms.com/cancel-stripe-subscription-payments/
		//https://docs.gravityforms.com/gform_post_payment_callback/
		$hook = 'gform_post_payment_callback';
		if (($action['type'] == 'add_subscription_payment' || $action['type'] == 'complete_payment') && $result && rgar($entry, 'payment_status') == 'Active') {
			$form = RGFormsModel::get_form_meta($entry['form_id']);
			$meta = $form['gf-limit-payments'];
			$logdebug = "entry #{$entry['id']}, form #{$entry['form_id']}";
			if ($meta && $meta['enabled']) {
				$sql = "SELECT addon_slug FROM {$wpdb->prefix}gf_addon_payment_callback WHERE lead_id = %s ORDER BY date_created DESC LIMIT 1";
				$query = $wpdb->prepare($sql, $entry['id']); 
				$slug = $wpdb->get_var($query);
				if (in_array($slug, self::slugs())) {
					$feed = self::get_feed($entry['form_id'], $slug);
					if ($feed) {
						$limit = $meta['payments_'.$feed['id']];
						$feed_name  = rgars( $feed, 'meta/feedName' );
						$logdebug = "(feed #{$feed['id']} - {$feed_name}) for $logdebug";
						if ($limit == '' || $limit == '0' && $limit == null) {
							$limit = $meta['payments_default'];
							GFLimitPaymentsAddon::get_instance()->log_debug("$hook: Feed not found, using default limit $logdebug.");
						}
						if ($limit != '' && $limit != '0' && $limit != null) {
							$count = $wpdb->get_var($wpdb->prepare("SELECT count(id) FROM {$wpdb->prefix}gf_addon_payment_transaction WHERE lead_id=%d", $entry['id']));
							$limit = (int) $limit;
							if ($count >= $limit) {
								$result = gf_stripe()->cancel( $entry, $feed );
								$message = "$hook: Cancelling subscription $logdebug. Result: " . print_r($result, 1);
								gf_stripe()->log_debug($message);
								GFLimitPaymentsAddon::get_instance()->log_debug($message);
							} else {
								GFLimitPaymentsAddon::get_instance()->log_debug("$hook: Maxmium payment not yet reached for $logdebug.");	
							}
						} else {
							GFLimitPaymentsAddon::get_instance()->log_debug("$hook: No limit set for feed for $logdebug.");
						}
					} else {
						GFLimitPaymentsAddon::get_instance()->log_error("$hook: Cancelling subscription failed $logdebug. Form has not feed with slug " . $slug);
					}
				} else {
					GFLimitPaymentsAddon::get_instance()->log_error("$hook: Cancelling subscription failed $logdebug. Unsupported feed type " . $slug);
				}
			}
		}
	}
}
GFLimitPayments::add_hooks();