<?php
if (class_exists('GFAddOn')) {
class GFLimitPaymentsAddon extends GFAddOn {
	protected $_slug = 'gf-limit-payments';
	protected $_title = 'GF Limit Payments';
	protected $_short_title = 'GF Limit Payments';
	private static $_instance = null;

	public static function get_instance() {
		if ( self::$_instance == null ) {
			self::$_instance = new GFLimitPaymentsAddon();
		}
		return self::$_instance;
	}

	public function init_admin() {
		parent::init_admin();
		//add actions to allow the payment status to be modified
		//add_action( 'gform_payment_status', array( $this, 'admin_edit_payment_status' ), 3, 3 );
		//add_action( 'gform_payment_date', array( $this, 'admin_edit_payment_date' ), 3, 3 );
		//add_action( 'gform_payment_transaction_id', array( $this, 'admin_edit_payment_transaction_id' ), 3, 3 );
		//add_action( 'gform_payment_amount', array( $this, 'admin_edit_payment_amount' ), 3, 3 );
		//add_action( 'gform_after_update_entry', array( $this, 'admin_update_payment' ), 4, 2 );
		//add_filter( 'gform_addon_navigation', array( $this, 'maybe_create_menu' ) );
	}

	/*public function plugin_page() {
		echo 'GF Limit Payments';
	}*/
	public function form_settings_fields($form) {
		$feeds = GFAPI::get_feeds(null, $form['id']);
		$limits = array(array(
			'label' => esc_html__( 'infinite', $this->_slug),
			'name'  => '0'
		));
		for ($i=1; $i<=100; $i++) {
			$limits[] = array(
				'label' => esc_html__( ''.$i, $this->_slug),
				'name'  => ''.$i
			);
		}
		$fields = array(
			array(
				'label'   => esc_html__('Enable GF Limit Payments', $this->_slug),
				'type'    => 'checkbox',
				'name'    => 'enabled',
				'tooltip' => esc_html__('Enable GF Limit Payments for this Gravity Form', $this->_slug),
				'choices' => array(
					array(
						'label' => esc_html__( 'Enabled', $this->_slug),
						'name'  => 'enabled'
					)
				)
			),
			array(
				'label'   => esc_html__('Default Limit', $this->_slug),
				'type'    => 'select',
				'name'    => 'payments_default',
				'tooltip' => esc_html__('Default Limit', $this->_slug),
				'choices' => $limits
			)
		);

		foreach ($feeds as $feed) {
			$id = $feed['id'];
			$name = $feed['meta']['feedName'];
			$name = $name ? $name : $feed['meta']['feed_name'];
			if (in_array($feed['addon_slug'], GFLimitPayments::slugs()) && GFLimitPayments::is_recurring($feed)) {
				$fields[] = array(
					'label'   => esc_html__($name, $this->_slug),
					'type'    => 'select',
					'name'    => 'payments_'.$id,
					'tooltip' => esc_html__($name, $this->_slug),
					'choices' => $limits
				);
			}
		}

		return array(
			array(
				'title'  => esc_html__('GF Limit Payments', $this->_slug),
				'fields' => $fields
			)
		);
	}
}
}
