<?php
/**
 * @package GetCost
 * @version 1.3.0
 */
/*
Plugin Name: GetCost WP Plugin
Plugin URI: http://wordpress.org/plugins/getcost/
Description: Plugin integration to have a GetCost form integrated into your wordpress's website.
Version: 1.3.0
Author: GetCost
Author URI: https://www.getcost.com
License: GPL2
*/


function insert_getcost($atts) {
  $atts=shortcode_atts(
    array(
      'form' => '',
      'business' => '',
      'width' => '*',
      'height' => '*',
    ), $atts, 'getcost');
  $form=esc_attr($atts['form']);
  $business=esc_attr($atts['business']);
  $width=esc_attr($atts['width']);
  $height=esc_attr($atts['height']);

  $src = 'https://www.getcost.com/form-emb/' . $form . '?businessId=' . $business;
  $iframe = '<iframe loading="lazy" title="GetCost" src="' . $src . '" frameborder="0"></iframe>';

  $content  = '<div class="embed-container" style="width:' . $width . ';height:' . $height . '">';
  if(isset($form) && !empty($form) && 
     isset($business) && !empty($business)) {
    $content .= $iframe;
  } else {
    $content .= 'form and business attributes must be set [getcost form="0" business="0"]<br />';
    $content .= 'Get your own shortcode from the Settings | Leads screen<br />';
  }
  $content .= '</div>';    
  return $content;
}


// We need some CSS to position the paragraph.
function getcost_css() {
	echo "";
}


add_action( 'admin_head', 'getcost_css' );
add_shortcode('getcost', 'insert_getcost');

?>
