<?php

/**
 * Fired during plugin deactivation
 *
 * @link       http://palindromecommunications.com/
 * @since      1.0.0
 *
 * @package    Get_Blog_Posts
 * @subpackage Get_Blog_Posts/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    Get_Blog_Posts
 * @subpackage Get_Blog_Posts/includes
 * @author     Palindrome Communications <http://palindromecommunications.com/>
 */
class Get_Blog_Posts_Deactivator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function deactivate() {
		delete_option( 'get_blog_posts_submitted' );
		delete_option( 'get_blog_posts_settings' );
	}

}
