<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              http://palindromecommunications.com/
 * @since             1.0.0
 * @package           Get_Blog_Posts
 *
 * @wordpress-plugin
 * Plugin Name:       Get Blog Posts
 * Plugin URI:        http://palindromecommunications.com/
 * Description:       Congratulations. You’ve got a WordPress site. Now what? Order a blog post package and get your own original blog posts delivered to you. Publish them on your blog for SEO and brand/authority building.
 * Version:           1.0.0
 * Author:            Palindrome Communications
 * Author URI:        
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       get-blog-posts
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'GET_BLOG_POSTS_VERSION', '1.0.0' );
define( 'GET_BLOG_POSTS_PATH', plugin_dir_path( __FILE__ ) );
define( 'GET_BLOG_POSTS_URL', plugin_dir_url( __FILE__ ) );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-get-blog-posts-activator.php
 */
function activate_get_blog_posts() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-get-blog-posts-activator.php';
	Get_Blog_Posts_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-get-blog-posts-deactivator.php
 */
function deactivate_get_blog_posts() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-get-blog-posts-deactivator.php';
	Get_Blog_Posts_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_get_blog_posts' );
register_deactivation_hook( __FILE__, 'deactivate_get_blog_posts' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-get-blog-posts.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_get_blog_posts() {

	$plugin = new Get_Blog_Posts();
	$plugin->run();

}
run_get_blog_posts();
