<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       http://palindromecommunications.com/
 * @since      1.0.0
 *
 * @package    Get_Blog_Posts
 * @subpackage Get_Blog_Posts/admin/partials
 */
?>

<!-- This file should primarily consist of HTML with a little bit of PHP. -->

<?php
    $tab = (isset($_GET['tab']) && !empty($_GET['tab'])) ? esc_attr($_GET['tab']) : "instructions";
    $getBlogPostsSettings = get_option('get_blog_posts_settings', array());
    $get_blog_posts_submitted = get_option('get_blog_posts_submitted');
?>

<div class="wrap get-blog-posts-settings-div">
    <h2><?php _e( 'Get Blog Posts', 'get-blog-posts' ); ?></h2>
    <?php settings_errors(); ?>
    <h2 class="nav-tab-wrapper">
        <a href="<?php echo admin_url('admin.php?page=get-blog-posts-settings&tab=instructions'); ?>" class="nav-tab <?php echo ($tab=='instructions') ? 'nav-tab-active' : ''; ?>">
            <?php _e( 'Instructions', 'get-blog-posts' ); ?>
        </a>
        <?php if (isset($getBlogPostsSettings['get_blog_posts_google_folder_link']) && !empty($getBlogPostsSettings['get_blog_posts_google_folder_link'])) { ?>
            <a href="<?php echo admin_url('admin.php?page=get-blog-posts-settings&tab=google-folder'); ?>" class="nav-tab <?php echo ($tab=='google-folder') ? 'nav-tab-active' : ''; ?>">
                <?php _e( 'Google Folder', 'get-blog-posts' ); ?>
            </a>
        <?php } else { ?>
            <a href="<?php echo admin_url('admin.php?page=get-blog-posts-settings&tab=google-folder-link'); ?>" class="nav-tab <?php echo ($tab=='google-folder-link') ? 'nav-tab-active' : ''; ?>">
                <?php _e( 'Google Folder Link', 'get-blog-posts' ); ?>
            </a>
            <a href="<?php echo admin_url('admin.php?page=get-blog-posts-settings&tab=page-settings-menu'); ?>" class="nav-tab <?php echo ($tab=='page-settings-menu') ? 'nav-tab-active' : ''; ?>">
                <?php _e( 'Book Package Form', 'get-blog-posts' ); ?>
            </a>
        <?php } ?>
        <?php if (isset($get_blog_posts_submitted) && !empty($get_blog_posts_submitted) && $get_blog_posts_submitted == 'true') { ?>
            <a href="<?php echo admin_url('admin.php?page=get-blog-posts-settings&tab=notifications'); ?>" class="nav-tab notifications <?php echo ($tab=='notifications') ? 'nav-tab-active' : ''; ?>">
                <?php _e( 'Notifications', 'get-blog-posts' ); ?>
            </a>
        <?php } ?>
    </h2>
    <?php if ($tab == 'instructions') { ?>
        <ul>
            <li>
                <iframe width="640" height="345" src="https://www.youtube.com/embed/gB8nlFXUGCk"></iframe>
            </li>
            <li>
                Congratulations. You’ve got a WordPress site. Now what? Fill up the booking form to order your very own original blog posts. No deposits, upfront fees or credit card required. As low as USD 35 for each blog post. Get consistent blog posts delivered to you for SEO and brand/authority building. <br>
                Find out more and get in touch with us via our website: <a href="https://palindromecommunications.com/" target="_blank">palindromecommunications.com</a> <br>
                You can also message us on WhatsApp: <a href="https://wa.me/60105389657" target="_blank">https://wa.me/60105389657</a>
            </li>
        </ul>
    <?php } ?>
    <?php if ($tab == 'page-settings-menu') { ?>
        <div class="get-blog-posts">
            <?php wp_enqueue_script( 'jotform', 'https://form.jotform.me/jsform/93315503315449' ); ?>
            <!-- <script type="text/javascript" src="https://form.jotform.me/jsform/93315503315449"></script> -->
        </div>    
    <?php } ?>
    <?php if ($tab == 'notifications') { ?>
        <div style="padding: 5rem; background-color: white;">
            <div style="background-color: #1360EF; border-radius: 5px;">
                <h3 style="padding: 2rem; color: white;">
                    <?php if (isset($getBlogPostsSettings['get_blog_posts_google_folder_link']) && !empty($getBlogPostsSettings['get_blog_posts_google_folder_link'])) { ?>
                        Glad to have you aboard! Please contact support@palindromecommunications.com if you need any help.
                    <?php } else { ?>
                        Thanks for your order. Check your email soon. Please give us one or two days to respond to you with your Google folder link. If you don’t receive an email from us in one or two days, please check your spam folder. Thanks!
                    <?php } ?>
                </h3>
            </div>
        </div>
    <?php } ?>
    <?php if ($tab == 'google-folder-link') { ?>
        <form method="POST" action="options.php">
            <?php settings_fields( 'get-blog-posts-settings' );
            do_settings_sections( 'get-blog-posts-settings' );
            $getBlogPostsSettings = get_option('get_blog_posts_settings', array()); ?>
            <table class="widefat form-table get-blog-posts-setting-table">
                <tbody>
                    <tr>
                        <td scope="row" width="150">
                            <label for="get_blog_posts_google_folder_link"><?php _e( 'Google Folder Link', 'custom-courier-driver-jps' ); ?></label>
                        </td>
                        <td>
                            <input type="text" style="width: 100%;" name="get_blog_posts_settings[get_blog_posts_google_folder_link]" id="get_blog_posts_google_folder_link" value="<?php echo (isset($getBlogPostsSettings['get_blog_posts_google_folder_link']) && !empty($getBlogPostsSettings['get_blog_posts_google_folder_link'])) ? $getBlogPostsSettings['get_blog_posts_google_folder_link'] : ''; ?>">
                            Please copy and paste your Google folder link
                        </td>
                    </tr>
                </tbody>
            </table>
            <?php submit_button(); ?>
        </form>
    <?php } ?>
    <?php if ($tab == 'google-folder') { ?>
        <div style="padding: 2rem;">
            <a href="<?php echo $getBlogPostsSettings['get_blog_posts_google_folder_link']; ?>" target="_blank" class="custom-button">
                <figure><img src="<?php echo GET_BLOG_POSTS_URL . 'admin/partials/google-drive.png'; ?>"></figure>
                <div class="text">
                    Open Folder
                </div>
            </a>
        </div>
    <?php } ?>
</div>
