<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       http://palindromecommunications.com/
 * @since      1.0.0
 *
 * @package    Get_Blog_Posts
 * @subpackage Get_Blog_Posts/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Get_Blog_Posts
 * @subpackage Get_Blog_Posts/admin
 * @author     Palindrome Communications <http://palindromecommunications.com/>
 */
class Get_Blog_Posts_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Get_Blog_Posts_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Get_Blog_Posts_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/get-blog-posts-admin.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Get_Blog_Posts_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Get_Blog_Posts_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/get-blog-posts-admin.js', array( 'jquery' ), $this->version, false );
		wp_localize_script( $this->plugin_name, 'admin_url_str', array( 'admin_url' => admin_url() ));
		$bookPackageFormSettings = get_option('get_blog_posts_settings', array());
		if ($_GET['tab'] == 'google-folder-link' && isset($bookPackageFormSettings['get_blog_posts_google_folder_link']) && !empty($bookPackageFormSettings['get_blog_posts_google_folder_link'])) {
			wp_redirect(admin_url('admin.php?page=get-blog-posts-settings&tab=google-folder'));
		}

	}

	public function get_blog_posts_plugin_settings() {
		register_setting( 'get-blog-posts-settings', 'get_blog_posts_settings' );
	}

	public function get_blog_posts_plugin_menu() {
		add_menu_page(
			'Get Blog Posts',
			'Get Blog Posts',
			'manage_options',
			'get-blog-posts-settings',
			array($this, 'plugin_settings_callback')
		);
	}

	public function plugin_settings_callback() {
		require('partials/get-blog-posts-admin-display.php');
	}

	public function get_blog_posts_submitted() {
		update_option( 'get_blog_posts_submitted', 'true' );
		echo "true";
	}

}
